package documentdb

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cosmos-db/mgmt/2015-04-08/documentdb"

// ConflictResolutionMode enumerates the values for conflict resolution mode.
type ConflictResolutionMode string

const (
	// Custom ...
	Custom ConflictResolutionMode = "Custom"
	// LastWriterWins ...
	LastWriterWins ConflictResolutionMode = "LastWriterWins"
)

// PossibleConflictResolutionModeValues returns an array of possible values for the ConflictResolutionMode const type.
func PossibleConflictResolutionModeValues() []ConflictResolutionMode {
	return []ConflictResolutionMode{Custom, LastWriterWins}
}

// ConnectorOffer enumerates the values for connector offer.
type ConnectorOffer string

const (
	// Small ...
	Small ConnectorOffer = "Small"
)

// PossibleConnectorOfferValues returns an array of possible values for the ConnectorOffer const type.
func PossibleConnectorOfferValues() []ConnectorOffer {
	return []ConnectorOffer{Small}
}

// DatabaseAccountKind enumerates the values for database account kind.
type DatabaseAccountKind string

const (
	// GlobalDocumentDB ...
	GlobalDocumentDB DatabaseAccountKind = "GlobalDocumentDB"
	// MongoDB ...
	MongoDB DatabaseAccountKind = "MongoDB"
	// Parse ...
	Parse DatabaseAccountKind = "Parse"
)

// PossibleDatabaseAccountKindValues returns an array of possible values for the DatabaseAccountKind const type.
func PossibleDatabaseAccountKindValues() []DatabaseAccountKind {
	return []DatabaseAccountKind{GlobalDocumentDB, MongoDB, Parse}
}

// DatabaseAccountOfferType enumerates the values for database account offer type.
type DatabaseAccountOfferType string

const (
	// Standard ...
	Standard DatabaseAccountOfferType = "Standard"
)

// PossibleDatabaseAccountOfferTypeValues returns an array of possible values for the DatabaseAccountOfferType const type.
func PossibleDatabaseAccountOfferTypeValues() []DatabaseAccountOfferType {
	return []DatabaseAccountOfferType{Standard}
}

// DataType enumerates the values for data type.
type DataType string

const (
	// LineString ...
	LineString DataType = "LineString"
	// MultiPolygon ...
	MultiPolygon DataType = "MultiPolygon"
	// Number ...
	Number DataType = "Number"
	// Point ...
	Point DataType = "Point"
	// Polygon ...
	Polygon DataType = "Polygon"
	// String ...
	String DataType = "String"
)

// PossibleDataTypeValues returns an array of possible values for the DataType const type.
func PossibleDataTypeValues() []DataType {
	return []DataType{LineString, MultiPolygon, Number, Point, Polygon, String}
}

// DefaultConsistencyLevel enumerates the values for default consistency level.
type DefaultConsistencyLevel string

const (
	// BoundedStaleness ...
	BoundedStaleness DefaultConsistencyLevel = "BoundedStaleness"
	// ConsistentPrefix ...
	ConsistentPrefix DefaultConsistencyLevel = "ConsistentPrefix"
	// Eventual ...
	Eventual DefaultConsistencyLevel = "Eventual"
	// Session ...
	Session DefaultConsistencyLevel = "Session"
	// Strong ...
	Strong DefaultConsistencyLevel = "Strong"
)

// PossibleDefaultConsistencyLevelValues returns an array of possible values for the DefaultConsistencyLevel const type.
func PossibleDefaultConsistencyLevelValues() []DefaultConsistencyLevel {
	return []DefaultConsistencyLevel{BoundedStaleness, ConsistentPrefix, Eventual, Session, Strong}
}

// IndexingMode enumerates the values for indexing mode.
type IndexingMode string

const (
	// Consistent ...
	Consistent IndexingMode = "Consistent"
	// Lazy ...
	Lazy IndexingMode = "Lazy"
	// None ...
	None IndexingMode = "None"
)

// PossibleIndexingModeValues returns an array of possible values for the IndexingMode const type.
func PossibleIndexingModeValues() []IndexingMode {
	return []IndexingMode{Consistent, Lazy, None}
}

// IndexKind enumerates the values for index kind.
type IndexKind string

const (
	// Hash ...
	Hash IndexKind = "Hash"
	// Range ...
	Range IndexKind = "Range"
	// Spatial ...
	Spatial IndexKind = "Spatial"
)

// PossibleIndexKindValues returns an array of possible values for the IndexKind const type.
func PossibleIndexKindValues() []IndexKind {
	return []IndexKind{Hash, Range, Spatial}
}

// KeyKind enumerates the values for key kind.
type KeyKind string

const (
	// Primary ...
	Primary KeyKind = "primary"
	// PrimaryReadonly ...
	PrimaryReadonly KeyKind = "primaryReadonly"
	// Secondary ...
	Secondary KeyKind = "secondary"
	// SecondaryReadonly ...
	SecondaryReadonly KeyKind = "secondaryReadonly"
)

// PossibleKeyKindValues returns an array of possible values for the KeyKind const type.
func PossibleKeyKindValues() []KeyKind {
	return []KeyKind{Primary, PrimaryReadonly, Secondary, SecondaryReadonly}
}

// PartitionKind enumerates the values for partition kind.
type PartitionKind string

const (
	// PartitionKindHash ...
	PartitionKindHash PartitionKind = "Hash"
	// PartitionKindRange ...
	PartitionKindRange PartitionKind = "Range"
)

// PossiblePartitionKindValues returns an array of possible values for the PartitionKind const type.
func PossiblePartitionKindValues() []PartitionKind {
	return []PartitionKind{PartitionKindHash, PartitionKindRange}
}

// PrimaryAggregationType enumerates the values for primary aggregation type.
type PrimaryAggregationType string

const (
	// PrimaryAggregationTypeAverage ...
	PrimaryAggregationTypeAverage PrimaryAggregationType = "Average"
	// PrimaryAggregationTypeLast ...
	PrimaryAggregationTypeLast PrimaryAggregationType = "Last"
	// PrimaryAggregationTypeMaximum ...
	PrimaryAggregationTypeMaximum PrimaryAggregationType = "Maximum"
	// PrimaryAggregationTypeMinimum ...
	PrimaryAggregationTypeMinimum PrimaryAggregationType = "Minimum"
	// PrimaryAggregationTypeNone ...
	PrimaryAggregationTypeNone PrimaryAggregationType = "None"
	// PrimaryAggregationTypeTotal ...
	PrimaryAggregationTypeTotal PrimaryAggregationType = "Total"
)

// PossiblePrimaryAggregationTypeValues returns an array of possible values for the PrimaryAggregationType const type.
func PossiblePrimaryAggregationTypeValues() []PrimaryAggregationType {
	return []PrimaryAggregationType{PrimaryAggregationTypeAverage, PrimaryAggregationTypeLast, PrimaryAggregationTypeMaximum, PrimaryAggregationTypeMinimum, PrimaryAggregationTypeNone, PrimaryAggregationTypeTotal}
}

// UnitType enumerates the values for unit type.
type UnitType string

const (
	// Bytes ...
	Bytes UnitType = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond UnitType = "BytesPerSecond"
	// Count ...
	Count UnitType = "Count"
	// CountPerSecond ...
	CountPerSecond UnitType = "CountPerSecond"
	// Milliseconds ...
	Milliseconds UnitType = "Milliseconds"
	// Percent ...
	Percent UnitType = "Percent"
	// Seconds ...
	Seconds UnitType = "Seconds"
)

// PossibleUnitTypeValues returns an array of possible values for the UnitType const type.
func PossibleUnitTypeValues() []UnitType {
	return []UnitType{Bytes, BytesPerSecond, Count, CountPerSecond, Milliseconds, Percent, Seconds}
}

// Capability cosmos DB capability object
type Capability struct {
	// Name - Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
	Name *string `json:"name,omitempty"`
}

// CassandraKeyspace an Azure Cosmos DB Cassandra keyspace.
type CassandraKeyspace struct {
	autorest.Response `json:"-"`
	// CassandraKeyspaceProperties - The properties of an Azure Cosmos DB Cassandra keyspace
	*CassandraKeyspaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CassandraKeyspace.
func (ck CassandraKeyspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ck.CassandraKeyspaceProperties != nil {
		objectMap["properties"] = ck.CassandraKeyspaceProperties
	}
	if ck.Location != nil {
		objectMap["location"] = ck.Location
	}
	if ck.Tags != nil {
		objectMap["tags"] = ck.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraKeyspace struct.
func (ck *CassandraKeyspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraKeyspaceProperties CassandraKeyspaceProperties
				err = json.Unmarshal(*v, &cassandraKeyspaceProperties)
				if err != nil {
					return err
				}
				ck.CassandraKeyspaceProperties = &cassandraKeyspaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ck.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ck.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ck.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ck.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ck.Tags = tags
			}
		}
	}

	return nil
}

// CassandraKeyspaceCreateUpdateParameters parameters to create and update Cosmos DB Cassandra keyspace.
type CassandraKeyspaceCreateUpdateParameters struct {
	// CassandraKeyspaceCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra keyspace.
	*CassandraKeyspaceCreateUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraKeyspaceCreateUpdateParameters.
func (ckcup CassandraKeyspaceCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckcup.CassandraKeyspaceCreateUpdateProperties != nil {
		objectMap["properties"] = ckcup.CassandraKeyspaceCreateUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraKeyspaceCreateUpdateParameters struct.
func (ckcup *CassandraKeyspaceCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraKeyspaceCreateUpdateProperties CassandraKeyspaceCreateUpdateProperties
				err = json.Unmarshal(*v, &cassandraKeyspaceCreateUpdateProperties)
				if err != nil {
					return err
				}
				ckcup.CassandraKeyspaceCreateUpdateProperties = &cassandraKeyspaceCreateUpdateProperties
			}
		}
	}

	return nil
}

// CassandraKeyspaceCreateUpdateProperties properties to create and update Azure Cosmos DB Cassandra
// keyspace.
type CassandraKeyspaceCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Cassandra keyspace
	Resource *CassandraKeyspaceResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for CassandraKeyspaceCreateUpdateProperties.
func (ckcup CassandraKeyspaceCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckcup.Resource != nil {
		objectMap["resource"] = ckcup.Resource
	}
	if ckcup.Options != nil {
		objectMap["options"] = ckcup.Options
	}
	return json.Marshal(objectMap)
}

// CassandraKeyspaceListResult the List operation response, that contains the Cassandra keyspaces and their
// properties.
type CassandraKeyspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Cassandra keyspaces and their properties.
	Value *[]CassandraKeyspace `json:"value,omitempty"`
}

// CassandraKeyspaceProperties the properties of an Azure Cosmos DB Cassandra keyspace
type CassandraKeyspaceProperties struct {
	// ID - Name of the Cosmos DB Cassandra keyspace
	ID *string `json:"id,omitempty"`
}

// CassandraKeyspaceResource cosmos DB Cassandra keyspace id object
type CassandraKeyspaceResource struct {
	// ID - Name of the Cosmos DB Cassandra keyspace
	ID *string `json:"id,omitempty"`
}

// CassandraPartitionKey cosmos DB Cassandra table partition key
type CassandraPartitionKey struct {
	// Name - Name of the Cosmos DB Cassandra table partition key
	Name *string `json:"name,omitempty"`
}

// CassandraSchema cosmos DB Cassandra table schema
type CassandraSchema struct {
	// Columns - List of Cassandra table columns.
	Columns *[]Column `json:"columns,omitempty"`
	// PartitionKeys - List of partition key.
	PartitionKeys *[]CassandraPartitionKey `json:"partitionKeys,omitempty"`
	// ClusterKeys - List of cluster key.
	ClusterKeys *[]ClusterKey `json:"clusterKeys,omitempty"`
}

// CassandraTable an Azure Cosmos DB Cassandra table.
type CassandraTable struct {
	autorest.Response `json:"-"`
	// CassandraTableProperties - The properties of an Azure Cosmos DB Cassandra table
	*CassandraTableProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CassandraTable.
func (ct CassandraTable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ct.CassandraTableProperties != nil {
		objectMap["properties"] = ct.CassandraTableProperties
	}
	if ct.Location != nil {
		objectMap["location"] = ct.Location
	}
	if ct.Tags != nil {
		objectMap["tags"] = ct.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraTable struct.
func (ct *CassandraTable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraTableProperties CassandraTableProperties
				err = json.Unmarshal(*v, &cassandraTableProperties)
				if err != nil {
					return err
				}
				ct.CassandraTableProperties = &cassandraTableProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ct.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ct.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ct.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ct.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ct.Tags = tags
			}
		}
	}

	return nil
}

// CassandraTableCreateUpdateParameters parameters to create and update Cosmos DB Cassandra table.
type CassandraTableCreateUpdateParameters struct {
	// CassandraTableCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra table.
	*CassandraTableCreateUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraTableCreateUpdateParameters.
func (ctcup CassandraTableCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctcup.CassandraTableCreateUpdateProperties != nil {
		objectMap["properties"] = ctcup.CassandraTableCreateUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraTableCreateUpdateParameters struct.
func (ctcup *CassandraTableCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraTableCreateUpdateProperties CassandraTableCreateUpdateProperties
				err = json.Unmarshal(*v, &cassandraTableCreateUpdateProperties)
				if err != nil {
					return err
				}
				ctcup.CassandraTableCreateUpdateProperties = &cassandraTableCreateUpdateProperties
			}
		}
	}

	return nil
}

// CassandraTableCreateUpdateProperties properties to create and update Azure Cosmos DB Cassandra table.
type CassandraTableCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Cassandra table
	Resource *CassandraTableResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for CassandraTableCreateUpdateProperties.
func (ctcup CassandraTableCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctcup.Resource != nil {
		objectMap["resource"] = ctcup.Resource
	}
	if ctcup.Options != nil {
		objectMap["options"] = ctcup.Options
	}
	return json.Marshal(objectMap)
}

// CassandraTableListResult the List operation response, that contains the Cassandra tables and their
// properties.
type CassandraTableListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Cassandra tables and their properties.
	Value *[]CassandraTable `json:"value,omitempty"`
}

// CassandraTableProperties the properties of an Azure Cosmos DB Cassandra table
type CassandraTableProperties struct {
	// ID - Name of the Cosmos DB Cassandra table
	ID *string `json:"id,omitempty"`
	// DefaultTTL - Time to live of the Cosmos DB Cassandra table
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// Schema - Schema of the Cosmos DB Cassandra table
	Schema *CassandraSchema `json:"schema,omitempty"`
}

// CassandraTableResource cosmos DB Cassandra table id object
type CassandraTableResource struct {
	// ID - Name of the Cosmos DB Cassandra table
	ID *string `json:"id,omitempty"`
	// DefaultTTL - Time to live of the Cosmos DB Cassandra table
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// Schema - Schema of the Cosmos DB Cassandra table
	Schema *CassandraSchema `json:"schema,omitempty"`
}

// ClusterKey cosmos DB Cassandra table cluster key
type ClusterKey struct {
	// Name - Name of the Cosmos DB Cassandra table cluster key
	Name *string `json:"name,omitempty"`
	// OrderBy - Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
	OrderBy *string `json:"orderBy,omitempty"`
}

// Column cosmos DB Cassandra table column
type Column struct {
	// Name - Name of the Cosmos DB Cassandra table column
	Name *string `json:"name,omitempty"`
	// Type - Type of the Cosmos DB Cassandra table column
	Type *string `json:"type,omitempty"`
}

// ConflictResolutionPolicy the conflict resolution policy for the container.
type ConflictResolutionPolicy struct {
	// Mode - Indicates the conflict resolution mode. Possible values include: 'LastWriterWins', 'Custom'
	Mode ConflictResolutionMode `json:"mode,omitempty"`
	// ConflictResolutionPath - The conflict resolution path in the case of LastWriterWins mode.
	ConflictResolutionPath *string `json:"conflictResolutionPath,omitempty"`
	// ConflictResolutionProcedure - The procedure to resolve conflicts in the case of custom mode.
	ConflictResolutionProcedure *string `json:"conflictResolutionProcedure,omitempty"`
}

// ConsistencyPolicy the consistency policy for the Cosmos DB database account.
type ConsistencyPolicy struct {
	// DefaultConsistencyLevel - The default consistency level and configuration settings of the Cosmos DB account. Possible values include: 'Eventual', 'Session', 'BoundedStaleness', 'Strong', 'ConsistentPrefix'
	DefaultConsistencyLevel DefaultConsistencyLevel `json:"defaultConsistencyLevel,omitempty"`
	// MaxStalenessPrefix - When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxStalenessPrefix *int64 `json:"maxStalenessPrefix,omitempty"`
	// MaxIntervalInSeconds - When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxIntervalInSeconds *int32 `json:"maxIntervalInSeconds,omitempty"`
}

// ContainerPartitionKey the configuration of the partition key to be used for partitioning data into
// multiple partitions
type ContainerPartitionKey struct {
	// Paths - List of paths using which data within the container can be partitioned
	Paths *[]string `json:"paths,omitempty"`
	// Kind - Indicates the kind of algorithm used for partitioning. Possible values include: 'PartitionKindHash', 'PartitionKindRange'
	Kind PartitionKind `json:"kind,omitempty"`
}

// DatabaseAccount an Azure Cosmos DB database account.
type DatabaseAccount struct {
	autorest.Response `json:"-"`
	// Kind - Indicates the type of database account. This can only be set at database account creation. Possible values include: 'GlobalDocumentDB', 'MongoDB', 'Parse'
	Kind                       DatabaseAccountKind `json:"kind,omitempty"`
	*DatabaseAccountProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DatabaseAccount.
func (da DatabaseAccount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if da.Kind != "" {
		objectMap["kind"] = da.Kind
	}
	if da.DatabaseAccountProperties != nil {
		objectMap["properties"] = da.DatabaseAccountProperties
	}
	if da.Location != nil {
		objectMap["location"] = da.Location
	}
	if da.Tags != nil {
		objectMap["tags"] = da.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccount struct.
func (da *DatabaseAccount) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind DatabaseAccountKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				da.Kind = kind
			}
		case "properties":
			if v != nil {
				var databaseAccountProperties DatabaseAccountProperties
				err = json.Unmarshal(*v, &databaseAccountProperties)
				if err != nil {
					return err
				}
				da.DatabaseAccountProperties = &databaseAccountProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				da.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				da.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				da.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				da.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				da.Tags = tags
			}
		}
	}

	return nil
}

// DatabaseAccountConnectionString connection string for the Cosmos DB account
type DatabaseAccountConnectionString struct {
	// ConnectionString - READ-ONLY; Value of the connection string
	ConnectionString *string `json:"connectionString,omitempty"`
	// Description - READ-ONLY; Description of the connection string
	Description *string `json:"description,omitempty"`
}

// DatabaseAccountCreateUpdateParameters parameters to create and update Cosmos DB database accounts.
type DatabaseAccountCreateUpdateParameters struct {
	// Kind - Indicates the type of database account. This can only be set at database account creation. Possible values include: 'GlobalDocumentDB', 'MongoDB', 'Parse'
	Kind                                   DatabaseAccountKind `json:"kind,omitempty"`
	*DatabaseAccountCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountCreateUpdateParameters.
func (dacup DatabaseAccountCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dacup.Kind != "" {
		objectMap["kind"] = dacup.Kind
	}
	if dacup.DatabaseAccountCreateUpdateProperties != nil {
		objectMap["properties"] = dacup.DatabaseAccountCreateUpdateProperties
	}
	if dacup.Location != nil {
		objectMap["location"] = dacup.Location
	}
	if dacup.Tags != nil {
		objectMap["tags"] = dacup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountCreateUpdateParameters struct.
func (dacup *DatabaseAccountCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind DatabaseAccountKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dacup.Kind = kind
			}
		case "properties":
			if v != nil {
				var databaseAccountCreateUpdateProperties DatabaseAccountCreateUpdateProperties
				err = json.Unmarshal(*v, &databaseAccountCreateUpdateProperties)
				if err != nil {
					return err
				}
				dacup.DatabaseAccountCreateUpdateProperties = &databaseAccountCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dacup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dacup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dacup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dacup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dacup.Tags = tags
			}
		}
	}

	return nil
}

// DatabaseAccountCreateUpdateProperties properties to create and update Azure Cosmos DB database accounts.
type DatabaseAccountCreateUpdateProperties struct {
	// ConsistencyPolicy - The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Locations - An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations *[]Location `json:"locations,omitempty"`
	// DatabaseAccountOfferType - The offer type for the database
	DatabaseAccountOfferType *string `json:"databaseAccountOfferType,omitempty"`
	// IPRangeFilter - Cosmos DB Firewall Support: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account. IP addresses/ranges must be comma separated and must not contain any spaces.
	IPRangeFilter *string `json:"ipRangeFilter,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// EnableMultipleWriteLocations - Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`
	// EnableCassandraConnector - Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`
	// ConnectorOffer - The cassandra connector offer type for the Cosmos DB database C* account. Possible values include: 'Small'
	ConnectorOffer ConnectorOffer `json:"connectorOffer,omitempty"`
}

// DatabaseAccountListConnectionStringsResult the connection strings for the given database account.
type DatabaseAccountListConnectionStringsResult struct {
	autorest.Response `json:"-"`
	// ConnectionStrings - An array that contains the connection strings for the Cosmos DB account.
	ConnectionStrings *[]DatabaseAccountConnectionString `json:"connectionStrings,omitempty"`
}

// DatabaseAccountListKeysResult the access keys for the given database account.
type DatabaseAccountListKeysResult struct {
	autorest.Response `json:"-"`
	// PrimaryMasterKey - READ-ONLY; Base 64 encoded value of the primary read-write key.
	PrimaryMasterKey *string `json:"primaryMasterKey,omitempty"`
	// SecondaryMasterKey - READ-ONLY; Base 64 encoded value of the secondary read-write key.
	SecondaryMasterKey *string `json:"secondaryMasterKey,omitempty"`
	// PrimaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string `json:"primaryReadonlyMasterKey,omitempty"`
	// SecondaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string `json:"secondaryReadonlyMasterKey,omitempty"`
}

// DatabaseAccountListReadOnlyKeysResult the read-only access keys for the given database account.
type DatabaseAccountListReadOnlyKeysResult struct {
	autorest.Response `json:"-"`
	// PrimaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string `json:"primaryReadonlyMasterKey,omitempty"`
	// SecondaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string `json:"secondaryReadonlyMasterKey,omitempty"`
}

// DatabaseAccountPatchParameters parameters for patching Azure Cosmos DB database account properties.
type DatabaseAccountPatchParameters struct {
	Tags                            map[string]*string `json:"tags"`
	*DatabaseAccountPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountPatchParameters.
func (dapp DatabaseAccountPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dapp.Tags != nil {
		objectMap["tags"] = dapp.Tags
	}
	if dapp.DatabaseAccountPatchProperties != nil {
		objectMap["properties"] = dapp.DatabaseAccountPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountPatchParameters struct.
func (dapp *DatabaseAccountPatchParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dapp.Tags = tags
			}
		case "properties":
			if v != nil {
				var databaseAccountPatchProperties DatabaseAccountPatchProperties
				err = json.Unmarshal(*v, &databaseAccountPatchProperties)
				if err != nil {
					return err
				}
				dapp.DatabaseAccountPatchProperties = &databaseAccountPatchProperties
			}
		}
	}

	return nil
}

// DatabaseAccountPatchProperties properties to update Azure Cosmos DB database accounts.
type DatabaseAccountPatchProperties struct {
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
}

// DatabaseAccountProperties properties for the database account.
type DatabaseAccountProperties struct {
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// DocumentEndpoint - READ-ONLY; The connection endpoint for the Cosmos DB database account.
	DocumentEndpoint *string `json:"documentEndpoint,omitempty"`
	// DatabaseAccountOfferType - READ-ONLY; The offer type for the Cosmos DB database account. Default value: Standard. Possible values include: 'Standard'
	DatabaseAccountOfferType DatabaseAccountOfferType `json:"databaseAccountOfferType,omitempty"`
	// IPRangeFilter - Cosmos DB Firewall Support: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account. IP addresses/ranges must be comma separated and must not contain any spaces.
	IPRangeFilter *string `json:"ipRangeFilter,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// ConsistencyPolicy - The consistency policy for the Cosmos DB database account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// WriteLocations - READ-ONLY; An array that contains the write location for the Cosmos DB account.
	WriteLocations *[]Location `json:"writeLocations,omitempty"`
	// ReadLocations - READ-ONLY; An array that contains of the read locations enabled for the Cosmos DB account.
	ReadLocations *[]Location `json:"readLocations,omitempty"`
	// FailoverPolicies - READ-ONLY; An array that contains the regions ordered by their failover priorities.
	FailoverPolicies *[]FailoverPolicy `json:"failoverPolicies,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// EnableMultipleWriteLocations - Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`
	// EnableCassandraConnector - Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`
	// ConnectorOffer - The cassandra connector offer type for the Cosmos DB database C* account. Possible values include: 'Small'
	ConnectorOffer ConnectorOffer `json:"connectorOffer,omitempty"`
}

// DatabaseAccountRegenerateKeyParameters parameters to regenerate the keys within the database account.
type DatabaseAccountRegenerateKeyParameters struct {
	// KeyKind - The access key to regenerate. Possible values include: 'Primary', 'Secondary', 'PrimaryReadonly', 'SecondaryReadonly'
	KeyKind KeyKind `json:"keyKind,omitempty"`
}

// DatabaseAccountsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateOrUpdateFuture) Result(client DatabaseAccountsClient) (da DatabaseAccount, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if da.Response.Response, err = future.GetResult(sender); err == nil && da.Response.Response.StatusCode != http.StatusNoContent {
		da, err = client.CreateOrUpdateResponder(da.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateOrUpdateFuture", "Result", da.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsCreateUpdateCassandraKeyspaceFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsCreateUpdateCassandraKeyspaceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateUpdateCassandraKeyspaceFuture) Result(client DatabaseAccountsClient) (ck CassandraKeyspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateCassandraKeyspaceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateUpdateCassandraKeyspaceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ck.Response.Response, err = future.GetResult(sender); err == nil && ck.Response.Response.StatusCode != http.StatusNoContent {
		ck, err = client.CreateUpdateCassandraKeyspaceResponder(ck.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateCassandraKeyspaceFuture", "Result", ck.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsCreateUpdateCassandraTableFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsCreateUpdateCassandraTableFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateUpdateCassandraTableFuture) Result(client DatabaseAccountsClient) (ct CassandraTable, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateCassandraTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateUpdateCassandraTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ct.Response.Response, err = future.GetResult(sender); err == nil && ct.Response.Response.StatusCode != http.StatusNoContent {
		ct, err = client.CreateUpdateCassandraTableResponder(ct.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateCassandraTableFuture", "Result", ct.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsCreateUpdateGremlinDatabaseFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsCreateUpdateGremlinDatabaseFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateUpdateGremlinDatabaseFuture) Result(client DatabaseAccountsClient) (gd GremlinDatabase, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateGremlinDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateUpdateGremlinDatabaseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gd.Response.Response, err = future.GetResult(sender); err == nil && gd.Response.Response.StatusCode != http.StatusNoContent {
		gd, err = client.CreateUpdateGremlinDatabaseResponder(gd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateGremlinDatabaseFuture", "Result", gd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsCreateUpdateGremlinGraphFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type DatabaseAccountsCreateUpdateGremlinGraphFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateUpdateGremlinGraphFuture) Result(client DatabaseAccountsClient) (gg GremlinGraph, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateGremlinGraphFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateUpdateGremlinGraphFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gg.Response.Response, err = future.GetResult(sender); err == nil && gg.Response.Response.StatusCode != http.StatusNoContent {
		gg, err = client.CreateUpdateGremlinGraphResponder(gg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateGremlinGraphFuture", "Result", gg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsCreateUpdateMongoDBCollectionFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsCreateUpdateMongoDBCollectionFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateUpdateMongoDBCollectionFuture) Result(client DatabaseAccountsClient) (mdc MongoDBCollection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateMongoDBCollectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateUpdateMongoDBCollectionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mdc.Response.Response, err = future.GetResult(sender); err == nil && mdc.Response.Response.StatusCode != http.StatusNoContent {
		mdc, err = client.CreateUpdateMongoDBCollectionResponder(mdc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateMongoDBCollectionFuture", "Result", mdc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsCreateUpdateMongoDBDatabaseFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsCreateUpdateMongoDBDatabaseFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateUpdateMongoDBDatabaseFuture) Result(client DatabaseAccountsClient) (mdd MongoDBDatabase, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateMongoDBDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateUpdateMongoDBDatabaseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mdd.Response.Response, err = future.GetResult(sender); err == nil && mdd.Response.Response.StatusCode != http.StatusNoContent {
		mdd, err = client.CreateUpdateMongoDBDatabaseResponder(mdd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateMongoDBDatabaseFuture", "Result", mdd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsCreateUpdateSQLContainerFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type DatabaseAccountsCreateUpdateSQLContainerFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateUpdateSQLContainerFuture) Result(client DatabaseAccountsClient) (sc SQLContainer, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateSQLContainerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateUpdateSQLContainerFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sc.Response.Response, err = future.GetResult(sender); err == nil && sc.Response.Response.StatusCode != http.StatusNoContent {
		sc, err = client.CreateUpdateSQLContainerResponder(sc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateSQLContainerFuture", "Result", sc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsCreateUpdateSQLDatabaseFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type DatabaseAccountsCreateUpdateSQLDatabaseFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateUpdateSQLDatabaseFuture) Result(client DatabaseAccountsClient) (sd SQLDatabase, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateSQLDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateUpdateSQLDatabaseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sd.Response.Response, err = future.GetResult(sender); err == nil && sd.Response.Response.StatusCode != http.StatusNoContent {
		sd, err = client.CreateUpdateSQLDatabaseResponder(sd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateSQLDatabaseFuture", "Result", sd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsCreateUpdateTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsCreateUpdateTableFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsCreateUpdateTableFuture) Result(client DatabaseAccountsClient) (t Table, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateUpdateTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.CreateUpdateTableResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateUpdateTableFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsDeleteCassandraKeyspaceFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type DatabaseAccountsDeleteCassandraKeyspaceFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteCassandraKeyspaceFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteCassandraKeyspaceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteCassandraKeyspaceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsDeleteCassandraTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsDeleteCassandraTableFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteCassandraTableFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteCassandraTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteCassandraTableFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsDeleteGremlinDatabaseFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DatabaseAccountsDeleteGremlinDatabaseFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteGremlinDatabaseFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteGremlinDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteGremlinDatabaseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsDeleteGremlinGraphFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsDeleteGremlinGraphFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteGremlinGraphFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteGremlinGraphFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteGremlinGraphFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsDeleteMongoDBCollectionFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type DatabaseAccountsDeleteMongoDBCollectionFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteMongoDBCollectionFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteMongoDBCollectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteMongoDBCollectionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsDeleteMongoDBDatabaseFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DatabaseAccountsDeleteMongoDBDatabaseFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteMongoDBDatabaseFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteMongoDBDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteMongoDBDatabaseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsDeleteSQLContainerFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsDeleteSQLContainerFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteSQLContainerFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteSQLContainerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteSQLContainerFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsDeleteSQLDatabaseFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsDeleteSQLDatabaseFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteSQLDatabaseFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteSQLDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteSQLDatabaseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsDeleteTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsDeleteTableFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsDeleteTableFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteTableFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsFailoverPriorityChangeFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DatabaseAccountsFailoverPriorityChangeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsFailoverPriorityChangeFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsFailoverPriorityChangeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsFailoverPriorityChangeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsListResult the List operation response, that contains the database accounts and their
// properties.
type DatabaseAccountsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of database account and their properties.
	Value *[]DatabaseAccount `json:"value,omitempty"`
}

// DatabaseAccountsOfflineRegionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsOfflineRegionFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsOfflineRegionFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsOfflineRegionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsOfflineRegionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsOnlineRegionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsOnlineRegionFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsOnlineRegionFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsOnlineRegionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsOnlineRegionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsPatchFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsPatchFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsPatchFuture) Result(client DatabaseAccountsClient) (da DatabaseAccount, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsPatchFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsPatchFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if da.Response.Response, err = future.GetResult(sender); err == nil && da.Response.Response.StatusCode != http.StatusNoContent {
		da, err = client.PatchResponder(da.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsPatchFuture", "Result", da.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsRegenerateKeyFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsRegenerateKeyFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsRegenerateKeyFuture) Result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsRegenerateKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsRegenerateKeyFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsUpdateCassandraKeyspaceThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsUpdateCassandraKeyspaceThroughputFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsUpdateCassandraKeyspaceThroughputFuture) Result(client DatabaseAccountsClient) (t Throughput, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateCassandraKeyspaceThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateCassandraKeyspaceThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateCassandraKeyspaceThroughputResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateCassandraKeyspaceThroughputFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsUpdateCassandraTableThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsUpdateCassandraTableThroughputFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsUpdateCassandraTableThroughputFuture) Result(client DatabaseAccountsClient) (t Throughput, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateCassandraTableThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateCassandraTableThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateCassandraTableThroughputResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateCassandraTableThroughputFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsUpdateGremlinDatabaseThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsUpdateGremlinDatabaseThroughputFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsUpdateGremlinDatabaseThroughputFuture) Result(client DatabaseAccountsClient) (t Throughput, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateGremlinDatabaseThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateGremlinDatabaseThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateGremlinDatabaseThroughputResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateGremlinDatabaseThroughputFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsUpdateGremlinGraphThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsUpdateGremlinGraphThroughputFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsUpdateGremlinGraphThroughputFuture) Result(client DatabaseAccountsClient) (t Throughput, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateGremlinGraphThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateGremlinGraphThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateGremlinGraphThroughputResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateGremlinGraphThroughputFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsUpdateMongoDBCollectionThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsUpdateMongoDBCollectionThroughputFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsUpdateMongoDBCollectionThroughputFuture) Result(client DatabaseAccountsClient) (t Throughput, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateMongoDBCollectionThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateMongoDBCollectionThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateMongoDBCollectionThroughputResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateMongoDBCollectionThroughputFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsUpdateMongoDBDatabaseThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsUpdateMongoDBDatabaseThroughputFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsUpdateMongoDBDatabaseThroughputFuture) Result(client DatabaseAccountsClient) (t Throughput, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateMongoDBDatabaseThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateMongoDBDatabaseThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateMongoDBDatabaseThroughputResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateMongoDBDatabaseThroughputFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsUpdateSQLContainerThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsUpdateSQLContainerThroughputFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsUpdateSQLContainerThroughputFuture) Result(client DatabaseAccountsClient) (t Throughput, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateSQLContainerThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateSQLContainerThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateSQLContainerThroughputResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateSQLContainerThroughputFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsUpdateSQLDatabaseThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DatabaseAccountsUpdateSQLDatabaseThroughputFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsUpdateSQLDatabaseThroughputFuture) Result(client DatabaseAccountsClient) (t Throughput, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateSQLDatabaseThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateSQLDatabaseThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateSQLDatabaseThroughputResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateSQLDatabaseThroughputFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsUpdateTableThroughputFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DatabaseAccountsUpdateTableThroughputFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabaseAccountsUpdateTableThroughputFuture) Result(client DatabaseAccountsClient) (t Throughput, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateTableThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateTableThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateTableThroughputResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateTableThroughputFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ErrorResponse error Response.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ExcludedPath ...
type ExcludedPath struct {
	// Path - The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
}

// ExtendedResourceProperties the system generated resource properties associated with SQL databases and
// SQL containers.
type ExtendedResourceProperties struct {
	// Rid - A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// FailoverPolicies the list of new failover policies for the failover priority change.
type FailoverPolicies struct {
	// FailoverPolicies - List of failover policies.
	FailoverPolicies *[]FailoverPolicy `json:"failoverPolicies,omitempty"`
}

// FailoverPolicy the failover policy for a given region of a database account.
type FailoverPolicy struct {
	// ID - READ-ONLY; The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
	ID *string `json:"id,omitempty"`
	// LocationName - The name of the region in which the database account exists.
	LocationName *string `json:"locationName,omitempty"`
	// FailoverPriority - The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
	FailoverPriority *int32 `json:"failoverPriority,omitempty"`
}

// GremlinDatabase an Azure Cosmos DB Gremlin database.
type GremlinDatabase struct {
	autorest.Response `json:"-"`
	// GremlinDatabaseProperties - The properties of an Azure Cosmos DB SQL database
	*GremlinDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GremlinDatabase.
func (gd GremlinDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gd.GremlinDatabaseProperties != nil {
		objectMap["properties"] = gd.GremlinDatabaseProperties
	}
	if gd.Location != nil {
		objectMap["location"] = gd.Location
	}
	if gd.Tags != nil {
		objectMap["tags"] = gd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinDatabase struct.
func (gd *GremlinDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinDatabaseProperties GremlinDatabaseProperties
				err = json.Unmarshal(*v, &gremlinDatabaseProperties)
				if err != nil {
					return err
				}
				gd.GremlinDatabaseProperties = &gremlinDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gd.Tags = tags
			}
		}
	}

	return nil
}

// GremlinDatabaseCreateUpdateParameters parameters to create and update Cosmos DB Gremlin database.
type GremlinDatabaseCreateUpdateParameters struct {
	// GremlinDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB Gremlin database.
	*GremlinDatabaseCreateUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for GremlinDatabaseCreateUpdateParameters.
func (gdcup GremlinDatabaseCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gdcup.GremlinDatabaseCreateUpdateProperties != nil {
		objectMap["properties"] = gdcup.GremlinDatabaseCreateUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinDatabaseCreateUpdateParameters struct.
func (gdcup *GremlinDatabaseCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinDatabaseCreateUpdateProperties GremlinDatabaseCreateUpdateProperties
				err = json.Unmarshal(*v, &gremlinDatabaseCreateUpdateProperties)
				if err != nil {
					return err
				}
				gdcup.GremlinDatabaseCreateUpdateProperties = &gremlinDatabaseCreateUpdateProperties
			}
		}
	}

	return nil
}

// GremlinDatabaseCreateUpdateProperties properties to create and update Azure Cosmos DB Gremlin database.
type GremlinDatabaseCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Gremlin database
	Resource *GremlinDatabaseResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for GremlinDatabaseCreateUpdateProperties.
func (gdcup GremlinDatabaseCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gdcup.Resource != nil {
		objectMap["resource"] = gdcup.Resource
	}
	if gdcup.Options != nil {
		objectMap["options"] = gdcup.Options
	}
	return json.Marshal(objectMap)
}

// GremlinDatabaseListResult the List operation response, that contains the Gremlin databases and their
// properties.
type GremlinDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Gremlin databases and their properties.
	Value *[]GremlinDatabase `json:"value,omitempty"`
}

// GremlinDatabaseProperties the properties of an Azure Cosmos DB SQL database
type GremlinDatabaseProperties struct {
	// Rid - A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
	// ID - Name of the Cosmos DB Gremlin database
	ID *string `json:"id,omitempty"`
}

// GremlinDatabaseResource cosmos DB Gremlin database id object
type GremlinDatabaseResource struct {
	// ID - Name of the Cosmos DB Gremlin database
	ID *string `json:"id,omitempty"`
}

// GremlinGraph an Azure Cosmos DB Gremlin graph.
type GremlinGraph struct {
	autorest.Response `json:"-"`
	// GremlinGraphProperties - The properties of an Azure Cosmos DB Gremlin graph
	*GremlinGraphProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GremlinGraph.
func (gg GremlinGraph) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gg.GremlinGraphProperties != nil {
		objectMap["properties"] = gg.GremlinGraphProperties
	}
	if gg.Location != nil {
		objectMap["location"] = gg.Location
	}
	if gg.Tags != nil {
		objectMap["tags"] = gg.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinGraph struct.
func (gg *GremlinGraph) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinGraphProperties GremlinGraphProperties
				err = json.Unmarshal(*v, &gremlinGraphProperties)
				if err != nil {
					return err
				}
				gg.GremlinGraphProperties = &gremlinGraphProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gg.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gg.Tags = tags
			}
		}
	}

	return nil
}

// GremlinGraphCreateUpdateParameters parameters to create and update Cosmos DB Gremlin graph.
type GremlinGraphCreateUpdateParameters struct {
	// GremlinGraphCreateUpdateProperties - Properties to create and update Azure Cosmos DB Gremlin graph.
	*GremlinGraphCreateUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for GremlinGraphCreateUpdateParameters.
func (ggcup GremlinGraphCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ggcup.GremlinGraphCreateUpdateProperties != nil {
		objectMap["properties"] = ggcup.GremlinGraphCreateUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinGraphCreateUpdateParameters struct.
func (ggcup *GremlinGraphCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinGraphCreateUpdateProperties GremlinGraphCreateUpdateProperties
				err = json.Unmarshal(*v, &gremlinGraphCreateUpdateProperties)
				if err != nil {
					return err
				}
				ggcup.GremlinGraphCreateUpdateProperties = &gremlinGraphCreateUpdateProperties
			}
		}
	}

	return nil
}

// GremlinGraphCreateUpdateProperties properties to create and update Azure Cosmos DB Gremlin graph.
type GremlinGraphCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Gremlin graph
	Resource *GremlinGraphResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for GremlinGraphCreateUpdateProperties.
func (ggcup GremlinGraphCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ggcup.Resource != nil {
		objectMap["resource"] = ggcup.Resource
	}
	if ggcup.Options != nil {
		objectMap["options"] = ggcup.Options
	}
	return json.Marshal(objectMap)
}

// GremlinGraphListResult the List operation response, that contains the graphs and their properties.
type GremlinGraphListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of graphs and their properties.
	Value *[]GremlinGraph `json:"value,omitempty"`
}

// GremlinGraphProperties the properties of an Azure Cosmos DB Gremlin graph
type GremlinGraphProperties struct {
	// ID - Name of the Cosmos DB Gremlin graph
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the graph.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	// Rid - A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// GremlinGraphResource cosmos DB Gremlin graph resource object
type GremlinGraphResource struct {
	// ID - Name of the Cosmos DB Gremlin graph
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the graph.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
}

// IncludedPath the paths that are included in indexing
type IncludedPath struct {
	// Path - The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
	// Indexes - List of indexes for this path
	Indexes *[]Indexes `json:"indexes,omitempty"`
}

// Indexes the indexes for the path.
type Indexes struct {
	// DataType - The datatype for which the indexing behavior is applied to. Possible values include: 'String', 'Number', 'Point', 'Polygon', 'LineString', 'MultiPolygon'
	DataType DataType `json:"dataType,omitempty"`
	// Precision - The precision of the index. -1 is maximum precision.
	Precision *int32 `json:"precision,omitempty"`
	// Kind - Indicates the type of index. Possible values include: 'Hash', 'Range', 'Spatial'
	Kind IndexKind `json:"kind,omitempty"`
}

// IndexingPolicy cosmos DB indexing policy
type IndexingPolicy struct {
	// Automatic - Indicates if the indexing policy is automatic
	Automatic *bool `json:"automatic,omitempty"`
	// IndexingMode - Indicates the indexing mode. Possible values include: 'Consistent', 'Lazy', 'None'
	IndexingMode IndexingMode `json:"indexingMode,omitempty"`
	// IncludedPaths - List of paths to include in the indexing
	IncludedPaths *[]IncludedPath `json:"includedPaths,omitempty"`
	// ExcludedPaths - List of paths to exclude from indexing
	ExcludedPaths *[]ExcludedPath `json:"excludedPaths,omitempty"`
}

// Location a region in which the Azure Cosmos DB database account is deployed.
type Location struct {
	// ID - READ-ONLY; The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;.
	ID *string `json:"id,omitempty"`
	// LocationName - The name of the region.
	LocationName *string `json:"locationName,omitempty"`
	// DocumentEndpoint - READ-ONLY; The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
	DocumentEndpoint  *string `json:"documentEndpoint,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// FailoverPriority - The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
	FailoverPriority *int32 `json:"failoverPriority,omitempty"`
	// IsZoneRedundant - Flag to indicate whether or not this region is an AvailabilityZone region
	IsZoneRedundant *bool `json:"isZoneRedundant,omitempty"`
}

// Metric metric data
type Metric struct {
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MetricAvailability the availability of the metric.
type MetricAvailability struct {
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - READ-ONLY; The retention for the metric values.
	Retention *string `json:"retention,omitempty"`
}

// MetricDefinition the definition of a metric.
type MetricDefinition struct {
	// MetricAvailabilities - READ-ONLY; The list of metric availabilities for the account.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
	// PrimaryAggregationType - READ-ONLY; The primary aggregation type of the metric. Possible values include: 'PrimaryAggregationTypeNone', 'PrimaryAggregationTypeAverage', 'PrimaryAggregationTypeTotal', 'PrimaryAggregationTypeMinimum', 'PrimaryAggregationTypeMaximum', 'PrimaryAggregationTypeLast'
	PrimaryAggregationType PrimaryAggregationType `json:"primaryAggregationType,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// ResourceURI - READ-ONLY; The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
}

// MetricDefinitionsListResult the response to a list metric definitions request.
type MetricDefinitionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of metric definitions for the account.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricListResult the response to a list metrics request.
type MetricListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of metrics for the account.
	Value *[]Metric `json:"value,omitempty"`
}

// MetricName a metric name.
type MetricName struct {
	// Value - READ-ONLY; The name of the metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The friendly name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricValue represents metrics values.
type MetricValue struct {
	// Count - READ-ONLY; The number of values for the metric.
	Count *float64 `json:"_count,omitempty"`
	// Average - READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// MongoDBCollection an Azure Cosmos DB MongoDB collection.
type MongoDBCollection struct {
	autorest.Response `json:"-"`
	// MongoDBCollectionProperties - The properties of an Azure Cosmos DB MongoDB collection
	*MongoDBCollectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MongoDBCollection.
func (mdc MongoDBCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdc.MongoDBCollectionProperties != nil {
		objectMap["properties"] = mdc.MongoDBCollectionProperties
	}
	if mdc.Location != nil {
		objectMap["location"] = mdc.Location
	}
	if mdc.Tags != nil {
		objectMap["tags"] = mdc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBCollection struct.
func (mdc *MongoDBCollection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBCollectionProperties MongoDBCollectionProperties
				err = json.Unmarshal(*v, &mongoDBCollectionProperties)
				if err != nil {
					return err
				}
				mdc.MongoDBCollectionProperties = &mongoDBCollectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mdc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mdc.Tags = tags
			}
		}
	}

	return nil
}

// MongoDBCollectionCreateUpdateParameters parameters to create and update Cosmos DB MongoDB collection.
type MongoDBCollectionCreateUpdateParameters struct {
	// MongoDBCollectionCreateUpdateProperties - Properties to create and update Azure Cosmos DB MongoDB collection.
	*MongoDBCollectionCreateUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionCreateUpdateParameters.
func (mdccup MongoDBCollectionCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdccup.MongoDBCollectionCreateUpdateProperties != nil {
		objectMap["properties"] = mdccup.MongoDBCollectionCreateUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBCollectionCreateUpdateParameters struct.
func (mdccup *MongoDBCollectionCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBCollectionCreateUpdateProperties MongoDBCollectionCreateUpdateProperties
				err = json.Unmarshal(*v, &mongoDBCollectionCreateUpdateProperties)
				if err != nil {
					return err
				}
				mdccup.MongoDBCollectionCreateUpdateProperties = &mongoDBCollectionCreateUpdateProperties
			}
		}
	}

	return nil
}

// MongoDBCollectionCreateUpdateProperties properties to create and update Azure Cosmos DB MongoDB
// collection.
type MongoDBCollectionCreateUpdateProperties struct {
	// Resource - The standard JSON format of a MongoDB collection
	Resource *MongoDBCollectionResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionCreateUpdateProperties.
func (mdccup MongoDBCollectionCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdccup.Resource != nil {
		objectMap["resource"] = mdccup.Resource
	}
	if mdccup.Options != nil {
		objectMap["options"] = mdccup.Options
	}
	return json.Marshal(objectMap)
}

// MongoDBCollectionListResult the List operation response, that contains the MongoDB collections and their
// properties.
type MongoDBCollectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of MongoDB collections and their properties.
	Value *[]MongoDBCollection `json:"value,omitempty"`
}

// MongoDBCollectionProperties the properties of an Azure Cosmos DB MongoDB collection
type MongoDBCollectionProperties struct {
	// ID - Name of the Cosmos DB MongoDB collection
	ID *string `json:"id,omitempty"`
	// ShardKey - A key-value pair of shard keys to be applied for the request.
	ShardKey map[string]*string `json:"shardKey"`
	// Indexes - List of index keys
	Indexes *[]MongoIndex `json:"indexes,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionProperties.
func (mdcp MongoDBCollectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdcp.ID != nil {
		objectMap["id"] = mdcp.ID
	}
	if mdcp.ShardKey != nil {
		objectMap["shardKey"] = mdcp.ShardKey
	}
	if mdcp.Indexes != nil {
		objectMap["indexes"] = mdcp.Indexes
	}
	return json.Marshal(objectMap)
}

// MongoDBCollectionResource cosmos DB MongoDB collection resource object
type MongoDBCollectionResource struct {
	// ID - Name of the Cosmos DB MongoDB collection
	ID *string `json:"id,omitempty"`
	// ShardKey - A key-value pair of shard keys to be applied for the request.
	ShardKey map[string]*string `json:"shardKey"`
	// Indexes - List of index keys
	Indexes *[]MongoIndex `json:"indexes,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionResource.
func (mdcr MongoDBCollectionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdcr.ID != nil {
		objectMap["id"] = mdcr.ID
	}
	if mdcr.ShardKey != nil {
		objectMap["shardKey"] = mdcr.ShardKey
	}
	if mdcr.Indexes != nil {
		objectMap["indexes"] = mdcr.Indexes
	}
	return json.Marshal(objectMap)
}

// MongoDBDatabase an Azure Cosmos DB MongoDB database.
type MongoDBDatabase struct {
	autorest.Response `json:"-"`
	// MongoDBDatabaseProperties - The properties of an Azure Cosmos DB MongoDB database
	*MongoDBDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MongoDBDatabase.
func (mdd MongoDBDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdd.MongoDBDatabaseProperties != nil {
		objectMap["properties"] = mdd.MongoDBDatabaseProperties
	}
	if mdd.Location != nil {
		objectMap["location"] = mdd.Location
	}
	if mdd.Tags != nil {
		objectMap["tags"] = mdd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBDatabase struct.
func (mdd *MongoDBDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBDatabaseProperties MongoDBDatabaseProperties
				err = json.Unmarshal(*v, &mongoDBDatabaseProperties)
				if err != nil {
					return err
				}
				mdd.MongoDBDatabaseProperties = &mongoDBDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mdd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mdd.Tags = tags
			}
		}
	}

	return nil
}

// MongoDBDatabaseCreateUpdateParameters parameters to create and update Cosmos DB MongoDB database.
type MongoDBDatabaseCreateUpdateParameters struct {
	// MongoDBDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB MongoDB database.
	*MongoDBDatabaseCreateUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBDatabaseCreateUpdateParameters.
func (mddcup MongoDBDatabaseCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mddcup.MongoDBDatabaseCreateUpdateProperties != nil {
		objectMap["properties"] = mddcup.MongoDBDatabaseCreateUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBDatabaseCreateUpdateParameters struct.
func (mddcup *MongoDBDatabaseCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBDatabaseCreateUpdateProperties MongoDBDatabaseCreateUpdateProperties
				err = json.Unmarshal(*v, &mongoDBDatabaseCreateUpdateProperties)
				if err != nil {
					return err
				}
				mddcup.MongoDBDatabaseCreateUpdateProperties = &mongoDBDatabaseCreateUpdateProperties
			}
		}
	}

	return nil
}

// MongoDBDatabaseCreateUpdateProperties properties to create and update Azure Cosmos DB MongoDB database.
type MongoDBDatabaseCreateUpdateProperties struct {
	// Resource - The standard JSON format of a MongoDB database
	Resource *MongoDBDatabaseResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for MongoDBDatabaseCreateUpdateProperties.
func (mddcup MongoDBDatabaseCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mddcup.Resource != nil {
		objectMap["resource"] = mddcup.Resource
	}
	if mddcup.Options != nil {
		objectMap["options"] = mddcup.Options
	}
	return json.Marshal(objectMap)
}

// MongoDBDatabaseListResult the List operation response, that contains the MongoDB databases and their
// properties.
type MongoDBDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of MongoDB databases and their properties.
	Value *[]MongoDBDatabase `json:"value,omitempty"`
}

// MongoDBDatabaseProperties the properties of an Azure Cosmos DB MongoDB database
type MongoDBDatabaseProperties struct {
	// ID - Name of the Cosmos DB MongoDB database
	ID *string `json:"id,omitempty"`
}

// MongoDBDatabaseResource cosmos DB MongoDB database id object
type MongoDBDatabaseResource struct {
	// ID - Name of the Cosmos DB MongoDB database
	ID *string `json:"id,omitempty"`
}

// MongoIndex cosmos DB MongoDB collection index key
type MongoIndex struct {
	// Key - Cosmos DB MongoDB collection index keys
	Key *MongoIndexKeys `json:"key,omitempty"`
	// Options - Cosmos DB MongoDB collection index key options
	Options *MongoIndexOptions `json:"options,omitempty"`
}

// MongoIndexKeys cosmos DB MongoDB collection resource object
type MongoIndexKeys struct {
	// Keys - List of keys for each MongoDB collection in the Azure Cosmos DB service
	Keys *[]string `json:"keys,omitempty"`
}

// MongoIndexOptions cosmos DB MongoDB collection index options
type MongoIndexOptions struct {
	// ExpireAfterSeconds - Expire after seconds
	ExpireAfterSeconds *int32 `json:"expireAfterSeconds,omitempty"`
	// Unique - Is unique or not
	Unique *bool `json:"unique,omitempty"`
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.ResourceProvider
	Provider *string `json:"Provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"Resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"Operation,omitempty"`
	// Description - Description of operation
	Description *string `json:"Description,omitempty"`
}

// OperationListResult result of the request to list Resource Provider operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Resource Provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// PartitionMetric the metric values for a single partition.
type PartitionMetric struct {
	// PartitionID - READ-ONLY; The partition id (GUID identifier) of the metric values.
	PartitionID *string `json:"partitionId,omitempty"`
	// PartitionKeyRangeID - READ-ONLY; The partition key range id (integer identifier) of the metric values.
	PartitionKeyRangeID *string `json:"partitionKeyRangeId,omitempty"`
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// PartitionMetricListResult the response to a list partition metrics request.
type PartitionMetricListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of partition-level metrics for the account.
	Value *[]PartitionMetric `json:"value,omitempty"`
}

// PartitionUsage the partition level usage data for a usage request.
type PartitionUsage struct {
	// PartitionID - READ-ONLY; The partition id (GUID identifier) of the usages.
	PartitionID *string `json:"partitionId,omitempty"`
	// PartitionKeyRangeID - READ-ONLY; The partition key range id (integer identifier) of the usages.
	PartitionKeyRangeID *string `json:"partitionKeyRangeId,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// QuotaPeriod - READ-ONLY; The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Limit - READ-ONLY; Maximum value for this metric
	Limit *int64 `json:"limit,omitempty"`
	// CurrentValue - READ-ONLY; Current value for this metric
	CurrentValue *int64 `json:"currentValue,omitempty"`
}

// PartitionUsagesResult the response to a list partition level usage request.
type PartitionUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of partition-level usages for the database. A usage is a point in time metric
	Value *[]PartitionUsage `json:"value,omitempty"`
}

// PercentileMetric percentile Metric data
type PercentileMetric struct {
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The percentile metric values for the specified time window and timestep.
	MetricValues *[]PercentileMetricValue `json:"metricValues,omitempty"`
}

// PercentileMetricListResult the response to a list percentile metrics request.
type PercentileMetricListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of percentile metrics for the account.
	Value *[]PercentileMetric `json:"value,omitempty"`
}

// PercentileMetricValue represents percentile metrics values.
type PercentileMetricValue struct {
	// P10 - READ-ONLY; The 10th percentile value for the metric.
	P10 *float64 `json:"P10,omitempty"`
	// P25 - READ-ONLY; The 25th percentile value for the metric.
	P25 *float64 `json:"P25,omitempty"`
	// P50 - READ-ONLY; The 50th percentile value for the metric.
	P50 *float64 `json:"P50,omitempty"`
	// P75 - READ-ONLY; The 75th percentile value for the metric.
	P75 *float64 `json:"P75,omitempty"`
	// P90 - READ-ONLY; The 90th percentile value for the metric.
	P90 *float64 `json:"P90,omitempty"`
	// P95 - READ-ONLY; The 95th percentile value for the metric.
	P95 *float64 `json:"P95,omitempty"`
	// P99 - READ-ONLY; The 99th percentile value for the metric.
	P99 *float64 `json:"P99,omitempty"`
	// Count - READ-ONLY; The number of values for the metric.
	Count *float64 `json:"_count,omitempty"`
	// Average - READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// RegionForOnlineOffline cosmos DB region to online or offline.
type RegionForOnlineOffline struct {
	// Region - Cosmos DB region, with spaces between words and each word capitalized.
	Region *string `json:"region,omitempty"`
}

// Resource the core properties of ARM resources.
type Resource struct {
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// SQLContainer an Azure Cosmos DB container.
type SQLContainer struct {
	autorest.Response `json:"-"`
	// SQLContainerProperties - The properties of an Azure Cosmos DB container
	*SQLContainerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLContainer.
func (sc SQLContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sc.SQLContainerProperties != nil {
		objectMap["properties"] = sc.SQLContainerProperties
	}
	if sc.Location != nil {
		objectMap["location"] = sc.Location
	}
	if sc.Tags != nil {
		objectMap["tags"] = sc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLContainer struct.
func (sc *SQLContainer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLContainerProperties SQLContainerProperties
				err = json.Unmarshal(*v, &SQLContainerProperties)
				if err != nil {
					return err
				}
				sc.SQLContainerProperties = &SQLContainerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sc.Tags = tags
			}
		}
	}

	return nil
}

// SQLContainerCreateUpdateParameters parameters to create and update Cosmos DB container.
type SQLContainerCreateUpdateParameters struct {
	// SQLContainerCreateUpdateProperties - Properties to create and update Azure Cosmos DB container.
	*SQLContainerCreateUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLContainerCreateUpdateParameters.
func (sccup SQLContainerCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sccup.SQLContainerCreateUpdateProperties != nil {
		objectMap["properties"] = sccup.SQLContainerCreateUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLContainerCreateUpdateParameters struct.
func (sccup *SQLContainerCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLContainerCreateUpdateProperties SQLContainerCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLContainerCreateUpdateProperties)
				if err != nil {
					return err
				}
				sccup.SQLContainerCreateUpdateProperties = &SQLContainerCreateUpdateProperties
			}
		}
	}

	return nil
}

// SQLContainerCreateUpdateProperties properties to create and update Azure Cosmos DB container.
type SQLContainerCreateUpdateProperties struct {
	// Resource - The standard JSON format of a container
	Resource *SQLContainerResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for SQLContainerCreateUpdateProperties.
func (sccup SQLContainerCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sccup.Resource != nil {
		objectMap["resource"] = sccup.Resource
	}
	if sccup.Options != nil {
		objectMap["options"] = sccup.Options
	}
	return json.Marshal(objectMap)
}

// SQLContainerListResult the List operation response, that contains the containers and their properties.
type SQLContainerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of containers and their properties.
	Value *[]SQLContainer `json:"value,omitempty"`
}

// SQLContainerProperties the properties of an Azure Cosmos DB container
type SQLContainerProperties struct {
	// ID - Name of the Cosmos DB SQL container
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	// Rid - A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// SQLContainerResource cosmos DB SQL container resource object
type SQLContainerResource struct {
	// ID - Name of the Cosmos DB SQL container
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
}

// SQLDatabase an Azure Cosmos DB SQL database.
type SQLDatabase struct {
	autorest.Response `json:"-"`
	// SQLDatabaseProperties - The properties of an Azure Cosmos DB SQL database
	*SQLDatabaseProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLDatabase.
func (sd SQLDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.SQLDatabaseProperties != nil {
		objectMap["properties"] = sd.SQLDatabaseProperties
	}
	if sd.Location != nil {
		objectMap["location"] = sd.Location
	}
	if sd.Tags != nil {
		objectMap["tags"] = sd.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLDatabase struct.
func (sd *SQLDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLDatabaseProperties SQLDatabaseProperties
				err = json.Unmarshal(*v, &SQLDatabaseProperties)
				if err != nil {
					return err
				}
				sd.SQLDatabaseProperties = &SQLDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sd.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sd.Tags = tags
			}
		}
	}

	return nil
}

// SQLDatabaseCreateUpdateParameters parameters to create and update Cosmos DB SQL database.
type SQLDatabaseCreateUpdateParameters struct {
	// SQLDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB SQL database.
	*SQLDatabaseCreateUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLDatabaseCreateUpdateParameters.
func (sdcup SQLDatabaseCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdcup.SQLDatabaseCreateUpdateProperties != nil {
		objectMap["properties"] = sdcup.SQLDatabaseCreateUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLDatabaseCreateUpdateParameters struct.
func (sdcup *SQLDatabaseCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLDatabaseCreateUpdateProperties SQLDatabaseCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLDatabaseCreateUpdateProperties)
				if err != nil {
					return err
				}
				sdcup.SQLDatabaseCreateUpdateProperties = &SQLDatabaseCreateUpdateProperties
			}
		}
	}

	return nil
}

// SQLDatabaseCreateUpdateProperties properties to create and update Azure Cosmos DB SQL database.
type SQLDatabaseCreateUpdateProperties struct {
	// Resource - The standard JSON format of a SQL database
	Resource *SQLDatabaseResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for SQLDatabaseCreateUpdateProperties.
func (sdcup SQLDatabaseCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdcup.Resource != nil {
		objectMap["resource"] = sdcup.Resource
	}
	if sdcup.Options != nil {
		objectMap["options"] = sdcup.Options
	}
	return json.Marshal(objectMap)
}

// SQLDatabaseListResult the List operation response, that contains the SQL databases and their properties.
type SQLDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of SQL databases and their properties.
	Value *[]SQLDatabase `json:"value,omitempty"`
}

// SQLDatabaseProperties the properties of an Azure Cosmos DB SQL database
type SQLDatabaseProperties struct {
	// ID - Name of the Cosmos DB SQL database
	ID *string `json:"id,omitempty"`
	// Rid - A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
	// Colls - A system generated property that specified the addressable path of the collections resource.
	Colls *string `json:"_colls,omitempty"`
	// Users - A system generated property that specifies the addressable path of the users resource.
	Users *string `json:"_users,omitempty"`
}

// SQLDatabaseResource cosmos DB SQL database id object
type SQLDatabaseResource struct {
	// ID - Name of the Cosmos DB SQL database
	ID *string `json:"id,omitempty"`
}

// Table an Azure Cosmos DB Table.
type Table struct {
	autorest.Response `json:"-"`
	// TableProperties - The properties of an Azure Cosmos DB Table
	*TableProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Table.
func (t Table) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TableProperties != nil {
		objectMap["properties"] = t.TableProperties
	}
	if t.Location != nil {
		objectMap["location"] = t.Location
	}
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Table struct.
func (t *Table) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableProperties TableProperties
				err = json.Unmarshal(*v, &tableProperties)
				if err != nil {
					return err
				}
				t.TableProperties = &tableProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				t.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				t.Tags = tags
			}
		}
	}

	return nil
}

// TableCreateUpdateParameters parameters to create and update Cosmos DB Table.
type TableCreateUpdateParameters struct {
	// TableCreateUpdateProperties - Properties to create and update Azure Cosmos DB Table.
	*TableCreateUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TableCreateUpdateParameters.
func (tcup TableCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tcup.TableCreateUpdateProperties != nil {
		objectMap["properties"] = tcup.TableCreateUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TableCreateUpdateParameters struct.
func (tcup *TableCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableCreateUpdateProperties TableCreateUpdateProperties
				err = json.Unmarshal(*v, &tableCreateUpdateProperties)
				if err != nil {
					return err
				}
				tcup.TableCreateUpdateProperties = &tableCreateUpdateProperties
			}
		}
	}

	return nil
}

// TableCreateUpdateProperties properties to create and update Azure Cosmos DB Table.
type TableCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Table
	Resource *TableResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for TableCreateUpdateProperties.
func (tcup TableCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tcup.Resource != nil {
		objectMap["resource"] = tcup.Resource
	}
	if tcup.Options != nil {
		objectMap["options"] = tcup.Options
	}
	return json.Marshal(objectMap)
}

// TableListResult the List operation response, that contains the Table and their properties.
type TableListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Table and their properties.
	Value *[]Table `json:"value,omitempty"`
}

// TableProperties the properties of an Azure Cosmos Table
type TableProperties struct {
	// ID - Name of the Cosmos DB table
	ID *string `json:"id,omitempty"`
}

// TableResource cosmos DB table id object
type TableResource struct {
	// ID - Name of the Cosmos DB table
	ID *string `json:"id,omitempty"`
}

// Throughput an Azure Cosmos DB resource throughput.
type Throughput struct {
	autorest.Response `json:"-"`
	// ThroughputProperties - The properties of an Azure Cosmos DB resource throughput
	*ThroughputProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Throughput.
func (t Throughput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.ThroughputProperties != nil {
		objectMap["properties"] = t.ThroughputProperties
	}
	if t.Location != nil {
		objectMap["location"] = t.Location
	}
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Throughput struct.
func (t *Throughput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var throughputProperties ThroughputProperties
				err = json.Unmarshal(*v, &throughputProperties)
				if err != nil {
					return err
				}
				t.ThroughputProperties = &throughputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				t.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				t.Tags = tags
			}
		}
	}

	return nil
}

// ThroughputProperties the properties of an Azure Cosmos DB resource throughput
type ThroughputProperties struct {
	// Throughput - Value of the Cosmos DB resource throughput
	Throughput *int32 `json:"throughput,omitempty"`
}

// ThroughputResource cosmos DB resource throughput object
type ThroughputResource struct {
	// Throughput - Value of the Cosmos DB resource throughput
	Throughput *int32 `json:"throughput,omitempty"`
}

// ThroughputUpdateParameters parameters to update Cosmos DB resource throughput.
type ThroughputUpdateParameters struct {
	// ThroughputUpdateProperties - Properties to update Azure Cosmos DB resource throughput.
	*ThroughputUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ThroughputUpdateParameters.
func (tup ThroughputUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tup.ThroughputUpdateProperties != nil {
		objectMap["properties"] = tup.ThroughputUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ThroughputUpdateParameters struct.
func (tup *ThroughputUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var throughputUpdateProperties ThroughputUpdateProperties
				err = json.Unmarshal(*v, &throughputUpdateProperties)
				if err != nil {
					return err
				}
				tup.ThroughputUpdateProperties = &throughputUpdateProperties
			}
		}
	}

	return nil
}

// ThroughputUpdateProperties properties to update Azure Cosmos DB resource throughput.
type ThroughputUpdateProperties struct {
	// Resource - The standard JSON format of a resource throughput
	Resource *ThroughputResource `json:"resource,omitempty"`
}

// UniqueKey the unique key on that enforces uniqueness constraint on documents in the collection in the
// Azure Cosmos DB service.
type UniqueKey struct {
	// Paths - List of paths must be unique for each document in the Azure Cosmos DB service
	Paths *[]string `json:"paths,omitempty"`
}

// UniqueKeyPolicy the unique key policy configuration for specifying uniqueness constraints on documents
// in the collection in the Azure Cosmos DB service.
type UniqueKeyPolicy struct {
	// UniqueKeys - List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
	UniqueKeys *[]UniqueKey `json:"uniqueKeys,omitempty"`
}

// Usage the usage data for a usage request.
type Usage struct {
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// QuotaPeriod - READ-ONLY; The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Limit - READ-ONLY; Maximum value for this metric
	Limit *int64 `json:"limit,omitempty"`
	// CurrentValue - READ-ONLY; Current value for this metric
	CurrentValue *int64 `json:"currentValue,omitempty"`
}

// UsagesResult the response to a list usage request.
type UsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of usages for the database. A usage is a point in time metric
	Value *[]Usage `json:"value,omitempty"`
}

// VirtualNetworkRule virtual Network ACL Rule object
type VirtualNetworkRule struct {
	// ID - Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
	ID *string `json:"id,omitempty"`
	// IgnoreMissingVNetServiceEndpoint - Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVNetServiceEndpoint *bool `json:"ignoreMissingVNetServiceEndpoint,omitempty"`
}
