// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CloudConnection cloud connection
// swagger:model CloudConnection
type CloudConnection struct {

	// classic
	Classic *CloudConnectionEndpointClassic `json:"classic,omitempty"`

	// cloud connection ID
	// Required: true
	CloudConnectionID *string `json:"cloudConnectionID"`

	// creation date
	// Required: true
	// Format: date-time
	CreationDate *strfmt.DateTime `json:"creationDate"`

	// enable global routing for this cloud connection (default=false)
	// Required: true
	GlobalRouting *bool `json:"globalRouting"`

	// IBM IP address
	// Required: true
	IbmIPAddress *string `json:"ibmIPAddress"`

	// link status
	// Required: true
	LinkStatus *string `json:"linkStatus"`

	// metered
	// Required: true
	Metered *bool `json:"metered"`

	// name of the cloud connection
	// Required: true
	Name *string `json:"name"`

	// Network References
	Networks []*NetworkReference `json:"networks,omitempty"`

	// port
	// Required: true
	Port *int64 `json:"port"`

	// speed of the cloud connection (speed in megabits per second)
	// Required: true
	Speed *int64 `json:"speed"`

	// user IP address
	// Required: true
	UserIPAddress *string `json:"userIPAddress"`

	// vpc
	Vpc *CloudConnectionEndpointVPC `json:"vpc,omitempty"`
}

// Validate validates this cloud connection
func (m *CloudConnection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClassic(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudConnectionID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreationDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGlobalRouting(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIbmIPAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLinkStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetered(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetworks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpeed(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserIPAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVpc(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudConnection) validateClassic(formats strfmt.Registry) error {

	if swag.IsZero(m.Classic) { // not required
		return nil
	}

	if m.Classic != nil {
		if err := m.Classic.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("classic")
			}
			return err
		}
	}

	return nil
}

func (m *CloudConnection) validateCloudConnectionID(formats strfmt.Registry) error {

	if err := validate.Required("cloudConnectionID", "body", m.CloudConnectionID); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnection) validateCreationDate(formats strfmt.Registry) error {

	if err := validate.Required("creationDate", "body", m.CreationDate); err != nil {
		return err
	}

	if err := validate.FormatOf("creationDate", "body", "date-time", m.CreationDate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnection) validateGlobalRouting(formats strfmt.Registry) error {

	if err := validate.Required("globalRouting", "body", m.GlobalRouting); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnection) validateIbmIPAddress(formats strfmt.Registry) error {

	if err := validate.Required("ibmIPAddress", "body", m.IbmIPAddress); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnection) validateLinkStatus(formats strfmt.Registry) error {

	if err := validate.Required("linkStatus", "body", m.LinkStatus); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnection) validateMetered(formats strfmt.Registry) error {

	if err := validate.Required("metered", "body", m.Metered); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnection) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnection) validateNetworks(formats strfmt.Registry) error {

	if swag.IsZero(m.Networks) { // not required
		return nil
	}

	for i := 0; i < len(m.Networks); i++ {
		if swag.IsZero(m.Networks[i]) { // not required
			continue
		}

		if m.Networks[i] != nil {
			if err := m.Networks[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("networks" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CloudConnection) validatePort(formats strfmt.Registry) error {

	if err := validate.Required("port", "body", m.Port); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnection) validateSpeed(formats strfmt.Registry) error {

	if err := validate.Required("speed", "body", m.Speed); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnection) validateUserIPAddress(formats strfmt.Registry) error {

	if err := validate.Required("userIPAddress", "body", m.UserIPAddress); err != nil {
		return err
	}

	return nil
}

func (m *CloudConnection) validateVpc(formats strfmt.Registry) error {

	if swag.IsZero(m.Vpc) { // not required
		return nil
	}

	if m.Vpc != nil {
		if err := m.Vpc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vpc")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudConnection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudConnection) UnmarshalBinary(b []byte) error {
	var res CloudConnection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
