package com.redhat.openshift;

import org.mindrot.jbcrypt.BCrypt;

/**
 * Checks bcrypt password
 * 
 * @author Akram
 *
 */
public class PasswordChecker {
	public static void main(String[] args) {
		String rawPassword = args[0];
		String encodedPassword = args[1];

		if (!BCrypt.checkpw(rawPassword, encodedPassword)) {
			System.out.println("Detected password environment variable change, Jenkins configuration must be updated...");
			System.exit(1);
		}
		System.exit(0);
	}
}
