/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package releasefakes

import (
	"sync"

	"github.com/shirou/gopsutil/v3/disk"
)

type FakePrerequisitesCheckerImpl struct {
	CommandAvailableStub        func(...string) bool
	commandAvailableMutex       sync.RWMutex
	commandAvailableArgsForCall []struct {
		arg1 []string
	}
	commandAvailableReturns struct {
		result1 bool
	}
	commandAvailableReturnsOnCall map[int]struct {
		result1 bool
	}
	ConfigureGlobalDefaultUserAndEmailStub        func() error
	configureGlobalDefaultUserAndEmailMutex       sync.RWMutex
	configureGlobalDefaultUserAndEmailArgsForCall []struct {
	}
	configureGlobalDefaultUserAndEmailReturns struct {
		result1 error
	}
	configureGlobalDefaultUserAndEmailReturnsOnCall map[int]struct {
		result1 error
	}
	DockerVersionStub        func() (string, error)
	dockerVersionMutex       sync.RWMutex
	dockerVersionArgsForCall []struct {
	}
	dockerVersionReturns struct {
		result1 string
		result2 error
	}
	dockerVersionReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	GCloudOutputStub        func(...string) (string, error)
	gCloudOutputMutex       sync.RWMutex
	gCloudOutputArgsForCall []struct {
		arg1 []string
	}
	gCloudOutputReturns struct {
		result1 string
		result2 error
	}
	gCloudOutputReturnsOnCall map[int]struct {
		result1 string
		result2 error
	}
	IsEnvSetStub        func(string) bool
	isEnvSetMutex       sync.RWMutex
	isEnvSetArgsForCall []struct {
		arg1 string
	}
	isEnvSetReturns struct {
		result1 bool
	}
	isEnvSetReturnsOnCall map[int]struct {
		result1 bool
	}
	UsageStub        func(string) (*disk.UsageStat, error)
	usageMutex       sync.RWMutex
	usageArgsForCall []struct {
		arg1 string
	}
	usageReturns struct {
		result1 *disk.UsageStat
		result2 error
	}
	usageReturnsOnCall map[int]struct {
		result1 *disk.UsageStat
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakePrerequisitesCheckerImpl) CommandAvailable(arg1 ...string) bool {
	fake.commandAvailableMutex.Lock()
	ret, specificReturn := fake.commandAvailableReturnsOnCall[len(fake.commandAvailableArgsForCall)]
	fake.commandAvailableArgsForCall = append(fake.commandAvailableArgsForCall, struct {
		arg1 []string
	}{arg1})
	stub := fake.CommandAvailableStub
	fakeReturns := fake.commandAvailableReturns
	fake.recordInvocation("CommandAvailable", []interface{}{arg1})
	fake.commandAvailableMutex.Unlock()
	if stub != nil {
		return stub(arg1...)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakePrerequisitesCheckerImpl) CommandAvailableCallCount() int {
	fake.commandAvailableMutex.RLock()
	defer fake.commandAvailableMutex.RUnlock()
	return len(fake.commandAvailableArgsForCall)
}

func (fake *FakePrerequisitesCheckerImpl) CommandAvailableCalls(stub func(...string) bool) {
	fake.commandAvailableMutex.Lock()
	defer fake.commandAvailableMutex.Unlock()
	fake.CommandAvailableStub = stub
}

func (fake *FakePrerequisitesCheckerImpl) CommandAvailableArgsForCall(i int) []string {
	fake.commandAvailableMutex.RLock()
	defer fake.commandAvailableMutex.RUnlock()
	argsForCall := fake.commandAvailableArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakePrerequisitesCheckerImpl) CommandAvailableReturns(result1 bool) {
	fake.commandAvailableMutex.Lock()
	defer fake.commandAvailableMutex.Unlock()
	fake.CommandAvailableStub = nil
	fake.commandAvailableReturns = struct {
		result1 bool
	}{result1}
}

func (fake *FakePrerequisitesCheckerImpl) CommandAvailableReturnsOnCall(i int, result1 bool) {
	fake.commandAvailableMutex.Lock()
	defer fake.commandAvailableMutex.Unlock()
	fake.CommandAvailableStub = nil
	if fake.commandAvailableReturnsOnCall == nil {
		fake.commandAvailableReturnsOnCall = make(map[int]struct {
			result1 bool
		})
	}
	fake.commandAvailableReturnsOnCall[i] = struct {
		result1 bool
	}{result1}
}

func (fake *FakePrerequisitesCheckerImpl) ConfigureGlobalDefaultUserAndEmail() error {
	fake.configureGlobalDefaultUserAndEmailMutex.Lock()
	ret, specificReturn := fake.configureGlobalDefaultUserAndEmailReturnsOnCall[len(fake.configureGlobalDefaultUserAndEmailArgsForCall)]
	fake.configureGlobalDefaultUserAndEmailArgsForCall = append(fake.configureGlobalDefaultUserAndEmailArgsForCall, struct {
	}{})
	stub := fake.ConfigureGlobalDefaultUserAndEmailStub
	fakeReturns := fake.configureGlobalDefaultUserAndEmailReturns
	fake.recordInvocation("ConfigureGlobalDefaultUserAndEmail", []interface{}{})
	fake.configureGlobalDefaultUserAndEmailMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakePrerequisitesCheckerImpl) ConfigureGlobalDefaultUserAndEmailCallCount() int {
	fake.configureGlobalDefaultUserAndEmailMutex.RLock()
	defer fake.configureGlobalDefaultUserAndEmailMutex.RUnlock()
	return len(fake.configureGlobalDefaultUserAndEmailArgsForCall)
}

func (fake *FakePrerequisitesCheckerImpl) ConfigureGlobalDefaultUserAndEmailCalls(stub func() error) {
	fake.configureGlobalDefaultUserAndEmailMutex.Lock()
	defer fake.configureGlobalDefaultUserAndEmailMutex.Unlock()
	fake.ConfigureGlobalDefaultUserAndEmailStub = stub
}

func (fake *FakePrerequisitesCheckerImpl) ConfigureGlobalDefaultUserAndEmailReturns(result1 error) {
	fake.configureGlobalDefaultUserAndEmailMutex.Lock()
	defer fake.configureGlobalDefaultUserAndEmailMutex.Unlock()
	fake.ConfigureGlobalDefaultUserAndEmailStub = nil
	fake.configureGlobalDefaultUserAndEmailReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakePrerequisitesCheckerImpl) ConfigureGlobalDefaultUserAndEmailReturnsOnCall(i int, result1 error) {
	fake.configureGlobalDefaultUserAndEmailMutex.Lock()
	defer fake.configureGlobalDefaultUserAndEmailMutex.Unlock()
	fake.ConfigureGlobalDefaultUserAndEmailStub = nil
	if fake.configureGlobalDefaultUserAndEmailReturnsOnCall == nil {
		fake.configureGlobalDefaultUserAndEmailReturnsOnCall = make(map[int]struct {
			result1 error
		})
	}
	fake.configureGlobalDefaultUserAndEmailReturnsOnCall[i] = struct {
		result1 error
	}{result1}
}

func (fake *FakePrerequisitesCheckerImpl) DockerVersion() (string, error) {
	fake.dockerVersionMutex.Lock()
	ret, specificReturn := fake.dockerVersionReturnsOnCall[len(fake.dockerVersionArgsForCall)]
	fake.dockerVersionArgsForCall = append(fake.dockerVersionArgsForCall, struct {
	}{})
	stub := fake.DockerVersionStub
	fakeReturns := fake.dockerVersionReturns
	fake.recordInvocation("DockerVersion", []interface{}{})
	fake.dockerVersionMutex.Unlock()
	if stub != nil {
		return stub()
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakePrerequisitesCheckerImpl) DockerVersionCallCount() int {
	fake.dockerVersionMutex.RLock()
	defer fake.dockerVersionMutex.RUnlock()
	return len(fake.dockerVersionArgsForCall)
}

func (fake *FakePrerequisitesCheckerImpl) DockerVersionCalls(stub func() (string, error)) {
	fake.dockerVersionMutex.Lock()
	defer fake.dockerVersionMutex.Unlock()
	fake.DockerVersionStub = stub
}

func (fake *FakePrerequisitesCheckerImpl) DockerVersionReturns(result1 string, result2 error) {
	fake.dockerVersionMutex.Lock()
	defer fake.dockerVersionMutex.Unlock()
	fake.DockerVersionStub = nil
	fake.dockerVersionReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakePrerequisitesCheckerImpl) DockerVersionReturnsOnCall(i int, result1 string, result2 error) {
	fake.dockerVersionMutex.Lock()
	defer fake.dockerVersionMutex.Unlock()
	fake.DockerVersionStub = nil
	if fake.dockerVersionReturnsOnCall == nil {
		fake.dockerVersionReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.dockerVersionReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakePrerequisitesCheckerImpl) GCloudOutput(arg1 ...string) (string, error) {
	fake.gCloudOutputMutex.Lock()
	ret, specificReturn := fake.gCloudOutputReturnsOnCall[len(fake.gCloudOutputArgsForCall)]
	fake.gCloudOutputArgsForCall = append(fake.gCloudOutputArgsForCall, struct {
		arg1 []string
	}{arg1})
	stub := fake.GCloudOutputStub
	fakeReturns := fake.gCloudOutputReturns
	fake.recordInvocation("GCloudOutput", []interface{}{arg1})
	fake.gCloudOutputMutex.Unlock()
	if stub != nil {
		return stub(arg1...)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakePrerequisitesCheckerImpl) GCloudOutputCallCount() int {
	fake.gCloudOutputMutex.RLock()
	defer fake.gCloudOutputMutex.RUnlock()
	return len(fake.gCloudOutputArgsForCall)
}

func (fake *FakePrerequisitesCheckerImpl) GCloudOutputCalls(stub func(...string) (string, error)) {
	fake.gCloudOutputMutex.Lock()
	defer fake.gCloudOutputMutex.Unlock()
	fake.GCloudOutputStub = stub
}

func (fake *FakePrerequisitesCheckerImpl) GCloudOutputArgsForCall(i int) []string {
	fake.gCloudOutputMutex.RLock()
	defer fake.gCloudOutputMutex.RUnlock()
	argsForCall := fake.gCloudOutputArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakePrerequisitesCheckerImpl) GCloudOutputReturns(result1 string, result2 error) {
	fake.gCloudOutputMutex.Lock()
	defer fake.gCloudOutputMutex.Unlock()
	fake.GCloudOutputStub = nil
	fake.gCloudOutputReturns = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakePrerequisitesCheckerImpl) GCloudOutputReturnsOnCall(i int, result1 string, result2 error) {
	fake.gCloudOutputMutex.Lock()
	defer fake.gCloudOutputMutex.Unlock()
	fake.GCloudOutputStub = nil
	if fake.gCloudOutputReturnsOnCall == nil {
		fake.gCloudOutputReturnsOnCall = make(map[int]struct {
			result1 string
			result2 error
		})
	}
	fake.gCloudOutputReturnsOnCall[i] = struct {
		result1 string
		result2 error
	}{result1, result2}
}

func (fake *FakePrerequisitesCheckerImpl) IsEnvSet(arg1 string) bool {
	fake.isEnvSetMutex.Lock()
	ret, specificReturn := fake.isEnvSetReturnsOnCall[len(fake.isEnvSetArgsForCall)]
	fake.isEnvSetArgsForCall = append(fake.isEnvSetArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.IsEnvSetStub
	fakeReturns := fake.isEnvSetReturns
	fake.recordInvocation("IsEnvSet", []interface{}{arg1})
	fake.isEnvSetMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1
	}
	return fakeReturns.result1
}

func (fake *FakePrerequisitesCheckerImpl) IsEnvSetCallCount() int {
	fake.isEnvSetMutex.RLock()
	defer fake.isEnvSetMutex.RUnlock()
	return len(fake.isEnvSetArgsForCall)
}

func (fake *FakePrerequisitesCheckerImpl) IsEnvSetCalls(stub func(string) bool) {
	fake.isEnvSetMutex.Lock()
	defer fake.isEnvSetMutex.Unlock()
	fake.IsEnvSetStub = stub
}

func (fake *FakePrerequisitesCheckerImpl) IsEnvSetArgsForCall(i int) string {
	fake.isEnvSetMutex.RLock()
	defer fake.isEnvSetMutex.RUnlock()
	argsForCall := fake.isEnvSetArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakePrerequisitesCheckerImpl) IsEnvSetReturns(result1 bool) {
	fake.isEnvSetMutex.Lock()
	defer fake.isEnvSetMutex.Unlock()
	fake.IsEnvSetStub = nil
	fake.isEnvSetReturns = struct {
		result1 bool
	}{result1}
}

func (fake *FakePrerequisitesCheckerImpl) IsEnvSetReturnsOnCall(i int, result1 bool) {
	fake.isEnvSetMutex.Lock()
	defer fake.isEnvSetMutex.Unlock()
	fake.IsEnvSetStub = nil
	if fake.isEnvSetReturnsOnCall == nil {
		fake.isEnvSetReturnsOnCall = make(map[int]struct {
			result1 bool
		})
	}
	fake.isEnvSetReturnsOnCall[i] = struct {
		result1 bool
	}{result1}
}

func (fake *FakePrerequisitesCheckerImpl) Usage(arg1 string) (*disk.UsageStat, error) {
	fake.usageMutex.Lock()
	ret, specificReturn := fake.usageReturnsOnCall[len(fake.usageArgsForCall)]
	fake.usageArgsForCall = append(fake.usageArgsForCall, struct {
		arg1 string
	}{arg1})
	stub := fake.UsageStub
	fakeReturns := fake.usageReturns
	fake.recordInvocation("Usage", []interface{}{arg1})
	fake.usageMutex.Unlock()
	if stub != nil {
		return stub(arg1)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakePrerequisitesCheckerImpl) UsageCallCount() int {
	fake.usageMutex.RLock()
	defer fake.usageMutex.RUnlock()
	return len(fake.usageArgsForCall)
}

func (fake *FakePrerequisitesCheckerImpl) UsageCalls(stub func(string) (*disk.UsageStat, error)) {
	fake.usageMutex.Lock()
	defer fake.usageMutex.Unlock()
	fake.UsageStub = stub
}

func (fake *FakePrerequisitesCheckerImpl) UsageArgsForCall(i int) string {
	fake.usageMutex.RLock()
	defer fake.usageMutex.RUnlock()
	argsForCall := fake.usageArgsForCall[i]
	return argsForCall.arg1
}

func (fake *FakePrerequisitesCheckerImpl) UsageReturns(result1 *disk.UsageStat, result2 error) {
	fake.usageMutex.Lock()
	defer fake.usageMutex.Unlock()
	fake.UsageStub = nil
	fake.usageReturns = struct {
		result1 *disk.UsageStat
		result2 error
	}{result1, result2}
}

func (fake *FakePrerequisitesCheckerImpl) UsageReturnsOnCall(i int, result1 *disk.UsageStat, result2 error) {
	fake.usageMutex.Lock()
	defer fake.usageMutex.Unlock()
	fake.UsageStub = nil
	if fake.usageReturnsOnCall == nil {
		fake.usageReturnsOnCall = make(map[int]struct {
			result1 *disk.UsageStat
			result2 error
		})
	}
	fake.usageReturnsOnCall[i] = struct {
		result1 *disk.UsageStat
		result2 error
	}{result1, result2}
}

func (fake *FakePrerequisitesCheckerImpl) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.commandAvailableMutex.RLock()
	defer fake.commandAvailableMutex.RUnlock()
	fake.configureGlobalDefaultUserAndEmailMutex.RLock()
	defer fake.configureGlobalDefaultUserAndEmailMutex.RUnlock()
	fake.dockerVersionMutex.RLock()
	defer fake.dockerVersionMutex.RUnlock()
	fake.gCloudOutputMutex.RLock()
	defer fake.gCloudOutputMutex.RUnlock()
	fake.isEnvSetMutex.RLock()
	defer fake.isEnvSetMutex.RUnlock()
	fake.usageMutex.RLock()
	defer fake.usageMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakePrerequisitesCheckerImpl) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}
