package authoring

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// AppsClient is the client for the Apps methods of the Authoring service.
type AppsClient struct {
	BaseClient
}

// NewAppsClient creates an instance of the AppsClient client.
func NewAppsClient(endpoint string) AppsClient {
	return AppsClient{New(endpoint)}
}

// Add creates a new LUIS app.
// Parameters:
// applicationCreateObject - an application containing Name, Description (optional), Culture, Usage Scenario
// (optional), Domain (optional) and initial version ID (optional) of the application. Default value for the
// version ID is "0.1". Note: the culture cannot be changed after the app is created.
func (client AppsClient) Add(ctx context.Context, applicationCreateObject ApplicationCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.Add")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: applicationCreateObject,
			Constraints: []validation.Constraint{{Target: "applicationCreateObject.Culture", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "applicationCreateObject.Name", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("authoring.AppsClient", "Add", err.Error())
	}

	req, err := client.AddPreparer(ctx, applicationCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Add", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Add", resp, "Failure sending request")
		return
	}

	result, err = client.AddResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Add", resp, "Failure responding to request")
	}

	return
}

// AddPreparer prepares the Add request.
func (client AppsClient) AddPreparer(ctx context.Context, applicationCreateObject ApplicationCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPath("/apps/"),
		autorest.WithJSON(applicationCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSender sends the Add request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AddSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddResponder handles the response to the Add request. The method always
// closes the http.Response Body.
func (client AppsClient) AddResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// AddCustomPrebuiltDomain adds a prebuilt domain along with its intent and entity models as a new application.
// Parameters:
// prebuiltDomainCreateObject - a prebuilt domain create object containing the name and culture of the domain.
func (client AppsClient) AddCustomPrebuiltDomain(ctx context.Context, prebuiltDomainCreateObject PrebuiltDomainCreateObject) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.AddCustomPrebuiltDomain")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddCustomPrebuiltDomainPreparer(ctx, prebuiltDomainCreateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "AddCustomPrebuiltDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddCustomPrebuiltDomainSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "AddCustomPrebuiltDomain", resp, "Failure sending request")
		return
	}

	result, err = client.AddCustomPrebuiltDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "AddCustomPrebuiltDomain", resp, "Failure responding to request")
	}

	return
}

// AddCustomPrebuiltDomainPreparer prepares the AddCustomPrebuiltDomain request.
func (client AppsClient) AddCustomPrebuiltDomainPreparer(ctx context.Context, prebuiltDomainCreateObject PrebuiltDomainCreateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPath("/apps/customprebuiltdomains"),
		autorest.WithJSON(prebuiltDomainCreateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddCustomPrebuiltDomainSender sends the AddCustomPrebuiltDomain request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) AddCustomPrebuiltDomainSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddCustomPrebuiltDomainResponder handles the response to the AddCustomPrebuiltDomain request. The method always
// closes the http.Response Body.
func (client AppsClient) AddCustomPrebuiltDomainResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes an application.
// Parameters:
// appID - the application ID.
// force - a flag to indicate whether to force an operation.
func (client AppsClient) Delete(ctx context.Context, appID uuid.UUID, force *bool) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.Delete")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, appID, force)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client AppsClient) DeletePreparer(ctx context.Context, appID uuid.UUID, force *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	queryParameters := map[string]interface{}{}
	if force != nil {
		queryParameters["force"] = autorest.Encode("query", *force)
	} else {
		queryParameters["force"] = autorest.Encode("query", false)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client AppsClient) DeleteResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DownloadQueryLogs gets the logs of the past month's endpoint queries for the application.
// Parameters:
// appID - the application ID.
func (client AppsClient) DownloadQueryLogs(ctx context.Context, appID uuid.UUID) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.DownloadQueryLogs")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DownloadQueryLogsPreparer(ctx, appID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "DownloadQueryLogs", nil, "Failure preparing request")
		return
	}

	resp, err := client.DownloadQueryLogsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "DownloadQueryLogs", resp, "Failure sending request")
		return
	}

	result, err = client.DownloadQueryLogsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "DownloadQueryLogs", resp, "Failure responding to request")
	}

	return
}

// DownloadQueryLogsPreparer prepares the DownloadQueryLogs request.
func (client AppsClient) DownloadQueryLogsPreparer(ctx context.Context, appID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/querylogs", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DownloadQueryLogsSender sends the DownloadQueryLogs request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) DownloadQueryLogsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DownloadQueryLogsResponder handles the response to the DownloadQueryLogs request. The method always
// closes the http.Response Body.
func (client AppsClient) DownloadQueryLogsResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets the application info.
// Parameters:
// appID - the application ID.
func (client AppsClient) Get(ctx context.Context, appID uuid.UUID) (result ApplicationInfoResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, appID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client AppsClient) GetPreparer(ctx context.Context, appID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client AppsClient) GetResponder(resp *http.Response) (result ApplicationInfoResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPublishSettings get the application publish settings including 'UseAllTrainingData'.
// Parameters:
// appID - the application ID.
func (client AppsClient) GetPublishSettings(ctx context.Context, appID uuid.UUID) (result PublishSettings, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetPublishSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPublishSettingsPreparer(ctx, appID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "GetPublishSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPublishSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "GetPublishSettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetPublishSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "GetPublishSettings", resp, "Failure responding to request")
	}

	return
}

// GetPublishSettingsPreparer prepares the GetPublishSettings request.
func (client AppsClient) GetPublishSettingsPreparer(ctx context.Context, appID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/publishsettings", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPublishSettingsSender sends the GetPublishSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetPublishSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetPublishSettingsResponder handles the response to the GetPublishSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) GetPublishSettingsResponder(resp *http.Response) (result PublishSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSettings get the application settings including 'UseAllTrainingData'.
// Parameters:
// appID - the application ID.
func (client AppsClient) GetSettings(ctx context.Context, appID uuid.UUID) (result ApplicationSettings, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.GetSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSettingsPreparer(ctx, appID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "GetSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "GetSettings", resp, "Failure sending request")
		return
	}

	result, err = client.GetSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "GetSettings", resp, "Failure responding to request")
	}

	return
}

// GetSettingsPreparer prepares the GetSettings request.
func (client AppsClient) GetSettingsPreparer(ctx context.Context, appID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/settings", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSettingsSender sends the GetSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) GetSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSettingsResponder handles the response to the GetSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) GetSettingsResponder(resp *http.Response) (result ApplicationSettings, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Import imports an application to LUIS, the application's structure is included in the request body.
// Parameters:
// luisApp - a LUIS application structure.
// appName - the application name to create. If not specified, the application name will be read from the
// imported object. If the application name already exists, an error is returned.
func (client AppsClient) Import(ctx context.Context, luisApp LuisApp, appName string) (result UUID, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.Import")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ImportPreparer(ctx, luisApp, appName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Import", nil, "Failure preparing request")
		return
	}

	resp, err := client.ImportSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Import", resp, "Failure sending request")
		return
	}

	result, err = client.ImportResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Import", resp, "Failure responding to request")
	}

	return
}

// ImportPreparer prepares the Import request.
func (client AppsClient) ImportPreparer(ctx context.Context, luisApp LuisApp, appName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{}
	if len(appName) > 0 {
		queryParameters["appName"] = autorest.Encode("query", appName)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPath("/apps/import"),
		autorest.WithJSON(luisApp),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ImportSender sends the Import request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ImportSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ImportResponder handles the response to the Import request. The method always
// closes the http.Response Body.
func (client AppsClient) ImportResponder(resp *http.Response) (result UUID, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists all of the user's applications.
// Parameters:
// skip - the number of entries to skip. Default value is 0.
// take - the number of entries to return. Maximum page size is 500. Default is 100.
func (client AppsClient) List(ctx context.Context, skip *int32, take *int32) (result ListApplicationInfoResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: skip,
			Constraints: []validation.Constraint{{Target: "skip", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "skip", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(500), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authoring.AppsClient", "List", err.Error())
	}

	req, err := client.ListPreparer(ctx, skip, take)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client AppsClient) ListPreparer(ctx context.Context, skip *int32, take *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 100)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPath("/apps/"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client AppsClient) ListResponder(resp *http.Response) (result ListApplicationInfoResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAvailableCustomPrebuiltDomains gets all the available custom prebuilt domains for all cultures.
func (client AppsClient) ListAvailableCustomPrebuiltDomains(ctx context.Context) (result ListPrebuiltDomain, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListAvailableCustomPrebuiltDomains")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListAvailableCustomPrebuiltDomainsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListAvailableCustomPrebuiltDomains", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAvailableCustomPrebuiltDomainsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListAvailableCustomPrebuiltDomains", resp, "Failure sending request")
		return
	}

	result, err = client.ListAvailableCustomPrebuiltDomainsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListAvailableCustomPrebuiltDomains", resp, "Failure responding to request")
	}

	return
}

// ListAvailableCustomPrebuiltDomainsPreparer prepares the ListAvailableCustomPrebuiltDomains request.
func (client AppsClient) ListAvailableCustomPrebuiltDomainsPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPath("/apps/customprebuiltdomains"))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAvailableCustomPrebuiltDomainsSender sends the ListAvailableCustomPrebuiltDomains request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListAvailableCustomPrebuiltDomainsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListAvailableCustomPrebuiltDomainsResponder handles the response to the ListAvailableCustomPrebuiltDomains request. The method always
// closes the http.Response Body.
func (client AppsClient) ListAvailableCustomPrebuiltDomainsResponder(resp *http.Response) (result ListPrebuiltDomain, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAvailableCustomPrebuiltDomainsForCulture gets all the available prebuilt domains for a specific culture.
// Parameters:
// culture - culture.
func (client AppsClient) ListAvailableCustomPrebuiltDomainsForCulture(ctx context.Context, culture string) (result ListPrebuiltDomain, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListAvailableCustomPrebuiltDomainsForCulture")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListAvailableCustomPrebuiltDomainsForCulturePreparer(ctx, culture)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListAvailableCustomPrebuiltDomainsForCulture", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAvailableCustomPrebuiltDomainsForCultureSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListAvailableCustomPrebuiltDomainsForCulture", resp, "Failure sending request")
		return
	}

	result, err = client.ListAvailableCustomPrebuiltDomainsForCultureResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListAvailableCustomPrebuiltDomainsForCulture", resp, "Failure responding to request")
	}

	return
}

// ListAvailableCustomPrebuiltDomainsForCulturePreparer prepares the ListAvailableCustomPrebuiltDomainsForCulture request.
func (client AppsClient) ListAvailableCustomPrebuiltDomainsForCulturePreparer(ctx context.Context, culture string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"culture": autorest.Encode("path", culture),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/customprebuiltdomains/{culture}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAvailableCustomPrebuiltDomainsForCultureSender sends the ListAvailableCustomPrebuiltDomainsForCulture request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListAvailableCustomPrebuiltDomainsForCultureSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListAvailableCustomPrebuiltDomainsForCultureResponder handles the response to the ListAvailableCustomPrebuiltDomainsForCulture request. The method always
// closes the http.Response Body.
func (client AppsClient) ListAvailableCustomPrebuiltDomainsForCultureResponder(resp *http.Response) (result ListPrebuiltDomain, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCortanaEndpoints gets the endpoint URLs for the prebuilt Cortana applications.
func (client AppsClient) ListCortanaEndpoints(ctx context.Context) (result PersonalAssistantsResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListCortanaEndpoints")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListCortanaEndpointsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListCortanaEndpoints", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCortanaEndpointsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListCortanaEndpoints", resp, "Failure sending request")
		return
	}

	result, err = client.ListCortanaEndpointsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListCortanaEndpoints", resp, "Failure responding to request")
	}

	return
}

// ListCortanaEndpointsPreparer prepares the ListCortanaEndpoints request.
func (client AppsClient) ListCortanaEndpointsPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPath("/apps/assistants"))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCortanaEndpointsSender sends the ListCortanaEndpoints request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListCortanaEndpointsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCortanaEndpointsResponder handles the response to the ListCortanaEndpoints request. The method always
// closes the http.Response Body.
func (client AppsClient) ListCortanaEndpointsResponder(resp *http.Response) (result PersonalAssistantsResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDomains gets the available application domains.
func (client AppsClient) ListDomains(ctx context.Context) (result ListString, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListDomains")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListDomainsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListDomains", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDomainsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListDomains", resp, "Failure sending request")
		return
	}

	result, err = client.ListDomainsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListDomains", resp, "Failure responding to request")
	}

	return
}

// ListDomainsPreparer prepares the ListDomains request.
func (client AppsClient) ListDomainsPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPath("/apps/domains"))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDomainsSender sends the ListDomains request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListDomainsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListDomainsResponder handles the response to the ListDomains request. The method always
// closes the http.Response Body.
func (client AppsClient) ListDomainsResponder(resp *http.Response) (result ListString, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListEndpoints returns the available endpoint deployment regions and URLs.
// Parameters:
// appID - the application ID.
func (client AppsClient) ListEndpoints(ctx context.Context, appID uuid.UUID) (result SetString, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListEndpoints")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListEndpointsPreparer(ctx, appID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListEndpoints", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListEndpointsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListEndpoints", resp, "Failure sending request")
		return
	}

	result, err = client.ListEndpointsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListEndpoints", resp, "Failure responding to request")
	}

	return
}

// ListEndpointsPreparer prepares the ListEndpoints request.
func (client AppsClient) ListEndpointsPreparer(ctx context.Context, appID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/endpoints", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListEndpointsSender sends the ListEndpoints request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListEndpointsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListEndpointsResponder handles the response to the ListEndpoints request. The method always
// closes the http.Response Body.
func (client AppsClient) ListEndpointsResponder(resp *http.Response) (result SetString, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSupportedCultures gets a list of supported cultures. Cultures are equivalent to the written language and locale.
// For example,"en-us" represents the U.S. variation of English.
func (client AppsClient) ListSupportedCultures(ctx context.Context) (result ListAvailableCulture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListSupportedCultures")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSupportedCulturesPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListSupportedCultures", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSupportedCulturesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListSupportedCultures", resp, "Failure sending request")
		return
	}

	result, err = client.ListSupportedCulturesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListSupportedCultures", resp, "Failure responding to request")
	}

	return
}

// ListSupportedCulturesPreparer prepares the ListSupportedCultures request.
func (client AppsClient) ListSupportedCulturesPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPath("/apps/cultures"))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSupportedCulturesSender sends the ListSupportedCultures request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListSupportedCulturesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListSupportedCulturesResponder handles the response to the ListSupportedCultures request. The method always
// closes the http.Response Body.
func (client AppsClient) ListSupportedCulturesResponder(resp *http.Response) (result ListAvailableCulture, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListUsageScenarios gets the application available usage scenarios.
func (client AppsClient) ListUsageScenarios(ctx context.Context) (result ListString, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.ListUsageScenarios")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListUsageScenariosPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListUsageScenarios", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListUsageScenariosSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListUsageScenarios", resp, "Failure sending request")
		return
	}

	result, err = client.ListUsageScenariosResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "ListUsageScenarios", resp, "Failure responding to request")
	}

	return
}

// ListUsageScenariosPreparer prepares the ListUsageScenarios request.
func (client AppsClient) ListUsageScenariosPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPath("/apps/usagescenarios"))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListUsageScenariosSender sends the ListUsageScenarios request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) ListUsageScenariosSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListUsageScenariosResponder handles the response to the ListUsageScenarios request. The method always
// closes the http.Response Body.
func (client AppsClient) ListUsageScenariosResponder(resp *http.Response) (result ListString, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// PackagePublishedApplicationAsGzip packages a published LUIS application as a GZip file to be used in the LUIS
// container.
// Parameters:
// appID - the application ID.
// slotName - the publishing slot name.
func (client AppsClient) PackagePublishedApplicationAsGzip(ctx context.Context, appID uuid.UUID, slotName string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.PackagePublishedApplicationAsGzip")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PackagePublishedApplicationAsGzipPreparer(ctx, appID, slotName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "PackagePublishedApplicationAsGzip", nil, "Failure preparing request")
		return
	}

	resp, err := client.PackagePublishedApplicationAsGzipSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "PackagePublishedApplicationAsGzip", resp, "Failure sending request")
		return
	}

	result, err = client.PackagePublishedApplicationAsGzipResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "PackagePublishedApplicationAsGzip", resp, "Failure responding to request")
	}

	return
}

// PackagePublishedApplicationAsGzipPreparer prepares the PackagePublishedApplicationAsGzip request.
func (client AppsClient) PackagePublishedApplicationAsGzipPreparer(ctx context.Context, appID uuid.UUID, slotName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":    autorest.Encode("path", appID),
		"slotName": autorest.Encode("path", slotName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/package/{appId}/slot/{slotName}/gzip", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PackagePublishedApplicationAsGzipSender sends the PackagePublishedApplicationAsGzip request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) PackagePublishedApplicationAsGzipSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// PackagePublishedApplicationAsGzipResponder handles the response to the PackagePublishedApplicationAsGzip request. The method always
// closes the http.Response Body.
func (client AppsClient) PackagePublishedApplicationAsGzipResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// PackageTrainedApplicationAsGzip packages trained LUIS application as GZip file to be used in the LUIS container.
// Parameters:
// appID - the application ID.
// versionID - the version ID.
func (client AppsClient) PackageTrainedApplicationAsGzip(ctx context.Context, appID uuid.UUID, versionID string) (result ReadCloser, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.PackageTrainedApplicationAsGzip")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PackageTrainedApplicationAsGzipPreparer(ctx, appID, versionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "PackageTrainedApplicationAsGzip", nil, "Failure preparing request")
		return
	}

	resp, err := client.PackageTrainedApplicationAsGzipSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "PackageTrainedApplicationAsGzip", resp, "Failure sending request")
		return
	}

	result, err = client.PackageTrainedApplicationAsGzipResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "PackageTrainedApplicationAsGzip", resp, "Failure responding to request")
	}

	return
}

// PackageTrainedApplicationAsGzipPreparer prepares the PackageTrainedApplicationAsGzip request.
func (client AppsClient) PackageTrainedApplicationAsGzipPreparer(ctx context.Context, appID uuid.UUID, versionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId":     autorest.Encode("path", appID),
		"versionId": autorest.Encode("path", versionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/package/{appId}/versions/{versionId}/gzip", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PackageTrainedApplicationAsGzipSender sends the PackageTrainedApplicationAsGzip request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) PackageTrainedApplicationAsGzipSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// PackageTrainedApplicationAsGzipResponder handles the response to the PackageTrainedApplicationAsGzip request. The method always
// closes the http.Response Body.
func (client AppsClient) PackageTrainedApplicationAsGzipResponder(resp *http.Response) (result ReadCloser, err error) {
	result.Value = &resp.Body
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK))
	result.Response = autorest.Response{Response: resp}
	return
}

// Publish publishes a specific version of the application.
// Parameters:
// appID - the application ID.
// applicationPublishObject - the application publish object. The region is the target region that the
// application is published to.
func (client AppsClient) Publish(ctx context.Context, appID uuid.UUID, applicationPublishObject ApplicationPublishObject) (result ProductionOrStagingEndpointInfo, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.Publish")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PublishPreparer(ctx, appID, applicationPublishObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Publish", nil, "Failure preparing request")
		return
	}

	resp, err := client.PublishSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Publish", resp, "Failure sending request")
		return
	}

	result, err = client.PublishResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Publish", resp, "Failure responding to request")
	}

	return
}

// PublishPreparer prepares the Publish request.
func (client AppsClient) PublishPreparer(ctx context.Context, appID uuid.UUID, applicationPublishObject ApplicationPublishObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/publish", pathParameters),
		autorest.WithJSON(applicationPublishObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PublishSender sends the Publish request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) PublishSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// PublishResponder handles the response to the Publish request. The method always
// closes the http.Response Body.
func (client AppsClient) PublishResponder(resp *http.Response) (result ProductionOrStagingEndpointInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusMultiStatus),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update updates the name or description of the application.
// Parameters:
// appID - the application ID.
// applicationUpdateObject - a model containing Name and Description of the application.
func (client AppsClient) Update(ctx context.Context, appID uuid.UUID, applicationUpdateObject ApplicationUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.Update")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, appID, applicationUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client AppsClient) UpdatePreparer(ctx context.Context, appID uuid.UUID, applicationUpdateObject ApplicationUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}", pathParameters),
		autorest.WithJSON(applicationUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdatePublishSettings updates the application publish settings including 'UseAllTrainingData'.
// Parameters:
// appID - the application ID.
// publishSettingUpdateObject - an object containing the new publish application settings.
func (client AppsClient) UpdatePublishSettings(ctx context.Context, appID uuid.UUID, publishSettingUpdateObject PublishSettingUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.UpdatePublishSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePublishSettingsPreparer(ctx, appID, publishSettingUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "UpdatePublishSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdatePublishSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "UpdatePublishSettings", resp, "Failure sending request")
		return
	}

	result, err = client.UpdatePublishSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "UpdatePublishSettings", resp, "Failure responding to request")
	}

	return
}

// UpdatePublishSettingsPreparer prepares the UpdatePublishSettings request.
func (client AppsClient) UpdatePublishSettingsPreparer(ctx context.Context, appID uuid.UUID, publishSettingUpdateObject PublishSettingUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/publishsettings", pathParameters),
		autorest.WithJSON(publishSettingUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdatePublishSettingsSender sends the UpdatePublishSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdatePublishSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdatePublishSettingsResponder handles the response to the UpdatePublishSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdatePublishSettingsResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateSettings updates the application settings including 'UseAllTrainingData'.
// Parameters:
// appID - the application ID.
// applicationSettingUpdateObject - an object containing the new application settings.
func (client AppsClient) UpdateSettings(ctx context.Context, appID uuid.UUID, applicationSettingUpdateObject ApplicationSettingUpdateObject) (result OperationStatus, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AppsClient.UpdateSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateSettingsPreparer(ctx, appID, applicationSettingUpdateObject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "UpdateSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "UpdateSettings", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authoring.AppsClient", "UpdateSettings", resp, "Failure responding to request")
	}

	return
}

// UpdateSettingsPreparer prepares the UpdateSettings request.
func (client AppsClient) UpdateSettingsPreparer(ctx context.Context, appID uuid.UUID, applicationSettingUpdateObject ApplicationSettingUpdateObject) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{Endpoint}/luis/api/v2.0", urlParameters),
		autorest.WithPathParameters("/apps/{appId}/settings", pathParameters),
		autorest.WithJSON(applicationSettingUpdateObject))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSettingsSender sends the UpdateSettings request. The method will close the
// http.Response Body if it receives an error.
func (client AppsClient) UpdateSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateSettingsResponder handles the response to the UpdateSettings request. The method always
// closes the http.Response Body.
func (client AppsClient) UpdateSettingsResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
