package operationalinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/operationalinsights/v1/operationalinsights"

// MetadataColumnDataType enumerates the values for metadata column data type.
type MetadataColumnDataType string

const (
	// Bool ...
	Bool MetadataColumnDataType = "bool"
	// Datetime ...
	Datetime MetadataColumnDataType = "datetime"
	// Dynamic ...
	Dynamic MetadataColumnDataType = "dynamic"
	// Int ...
	Int MetadataColumnDataType = "int"
	// Long ...
	Long MetadataColumnDataType = "long"
	// Real ...
	Real MetadataColumnDataType = "real"
	// String ...
	String MetadataColumnDataType = "string"
)

// PossibleMetadataColumnDataTypeValues returns an array of possible values for the MetadataColumnDataType const type.
func PossibleMetadataColumnDataTypeValues() []MetadataColumnDataType {
	return []MetadataColumnDataType{Bool, Datetime, Dynamic, Int, Long, Real, String}
}

// Column a column in a table.
type Column struct {
	// Name - The name of this column.
	Name *string `json:"name,omitempty"`
	// Type - The data type of this column.
	Type *string `json:"type,omitempty"`
}

// ErrorDetail ...
type ErrorDetail struct {
	// Code - The error's code.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
	// Target - Indicates which property in the request is responsible for the error.
	Target *string `json:"target,omitempty"`
	// Value - Indicates which value in 'target' is responsible for the error.
	Value *string `json:"value,omitempty"`
	// Resources - Indicates resources which were responsible for the error.
	Resources *[]string `json:"resources,omitempty"`
	// AdditionalProperties - Additional properties that can be provided on the error details object
	AdditionalProperties interface{} `json:"additionalProperties,omitempty"`
}

// ErrorInfo ...
type ErrorInfo struct {
	// Code - A machine readable error code.
	Code *string `json:"code,omitempty"`
	// Message - A human readable error message.
	Message *string `json:"message,omitempty"`
	// Details - error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// Innererror - Inner error details if they exist.
	Innererror *ErrorInfo `json:"innererror,omitempty"`
	// AdditionalProperties - Additional properties that can be provided on the error info object
	AdditionalProperties interface{} `json:"additionalProperties,omitempty"`
}

// ErrorResponse contains details when the response code indicates an error.
type ErrorResponse struct {
	// Error - The error details.
	Error *ErrorInfo `json:"error,omitempty"`
}

// MetadataApplication application Insights apps that were part of the metadata request and that the user
// has access to.
type MetadataApplication struct {
	// ID - The ID of the Application Insights app.
	ID *string `json:"id,omitempty"`
	// ResourceID - The ARM resource ID of the Application Insights app.
	ResourceID *string `json:"resourceId,omitempty"`
	// Name - The name of the Application Insights app.
	Name *string `json:"name,omitempty"`
	// Region - The Azure region of the Application Insights app.
	Region *string `json:"region,omitempty"`
	// Related - The related metadata items for the Application Insights app.
	Related *MetadataApplicationRelated `json:"related,omitempty"`
}

// MetadataApplicationRelated the related metadata items for the Application Insights app.
type MetadataApplicationRelated struct {
	// Tables - The related tables for the Application Insights app.
	Tables *[]string `json:"tables,omitempty"`
	// Functions - The related functions for the Application Insights app.
	Functions *[]string `json:"functions,omitempty"`
}

// MetadataCategory categories are used to group other metadata entities.
type MetadataCategory struct {
	// ID - The ID of the category
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name of the category
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the category
	Description *string `json:"description,omitempty"`
	// Related - The related metadata items for the category
	Related *MetadataCategoryRelated `json:"related,omitempty"`
}

// MetadataCategoryRelated the related metadata items for the category
type MetadataCategoryRelated struct {
	// Tables - The tables related to the category
	Tables *[]string `json:"tables,omitempty"`
	// Functions - The functions related to the category
	Functions *[]string `json:"functions,omitempty"`
	// ResourceTypes - The resource types related to the category
	ResourceTypes *[]string `json:"resourceTypes,omitempty"`
	// Queries - The saved queries related to the category
	Queries *[]string `json:"queries,omitempty"`
	// Solutions - The Log Analytics solutions related to the category
	Solutions *[]string `json:"solutions,omitempty"`
}

// MetadataFunction functions are stored Kusto queries that can be specified as part of queries by using
// their name.
type MetadataFunction struct {
	// ID - The ID of the function.
	ID *string `json:"id,omitempty"`
	// Name - The name of the function, to be used in queries.
	Name *string `json:"name,omitempty"`
	// Parameters - The parameters/arguments of the function, if any.
	Parameters *string `json:"parameters,omitempty"`
	// DisplayName - The display name of the function.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the function.
	Description *string `json:"description,omitempty"`
	// Body - The KQL body of the function.
	Body *string `json:"body,omitempty"`
	// Tags - The tags associated with the function.
	Tags interface{} `json:"tags,omitempty"`
	// Properties - The properties of the function.
	Properties interface{} `json:"properties,omitempty"`
	// Related - The related metadata items for the function.
	Related *MetadataFunctionRelated `json:"related,omitempty"`
}

// MetadataFunctionRelated the related metadata items for the function.
type MetadataFunctionRelated struct {
	// Tables - The related tables for the function.
	Tables *[]string `json:"tables,omitempty"`
	// Solutions - The related Log Analytics solutions for the function.
	Solutions *[]string `json:"solutions,omitempty"`
	// ResourceTypes - The related resource types for the function.
	ResourceTypes *[]string `json:"resourceTypes,omitempty"`
	// Categories - The related categories for the function.
	Categories *[]string `json:"categories,omitempty"`
	// Workspaces - The related workspaces for the function.
	Workspaces *[]string `json:"workspaces,omitempty"`
}

// MetadataPermissions permission information for the metadata call, includes apps/workspaces/resource the
// user didn't have access to.
type MetadataPermissions struct {
	// Workspaces - The permission indication for the workspaces on the metadata request.
	Workspaces *[]MetadataPermissionsWorkspacesItem `json:"workspaces,omitempty"`
	// Resources - The permission indication for the Azure resources on the metadata request.
	Resources *[]MetadataPermissionsResourcesItem `json:"resources,omitempty"`
	// Applications - The permission indication for the Application Insights apps on the metadata request.
	Applications *[]MetadataPermissionsApplicationsItem `json:"applications,omitempty"`
}

// MetadataPermissionsApplicationsItem ...
type MetadataPermissionsApplicationsItem struct {
	// ResourceID - The resource ID on the permission indication.
	ResourceID *string `json:"resourceId,omitempty"`
}

// MetadataPermissionsResourcesItem ...
type MetadataPermissionsResourcesItem struct {
	// ResourceID - The resource ID on the permission indication.
	ResourceID *string `json:"resourceId,omitempty"`
	// DenyTables - The list of tables that were denied access for the resource ID.
	DenyTables *[]string `json:"denyTables,omitempty"`
}

// MetadataPermissionsWorkspacesItem ...
type MetadataPermissionsWorkspacesItem struct {
	// ResourceID - The resource ID on the permission indication.
	ResourceID *string `json:"resourceId,omitempty"`
	// DenyTables - The list of tables that were denied access for the resource ID.
	DenyTables *[]string `json:"denyTables,omitempty"`
}

// MetadataQuery queries are stored pieces of KQL, along with a list of relevant metadata items.
type MetadataQuery struct {
	// ID - The ID of the query.
	ID *string `json:"id,omitempty"`
	// DisplayName - The display name of the query.
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the query.
	Description *string `json:"description,omitempty"`
	// Body - The KQL body of the query.
	Body *string `json:"body,omitempty"`
	// Labels - The user defined labels associated with the query.
	Labels *[]string `json:"labels,omitempty"`
	// Tags - The tags associated with the query.
	Tags interface{} `json:"tags,omitempty"`
	// Properties - The properties of the query.
	Properties interface{} `json:"properties,omitempty"`
	// Related - The related metadata items for the query.
	Related *MetadataQueryRelated `json:"related,omitempty"`
}

// MetadataQueryRelated the related metadata items for the query.
type MetadataQueryRelated struct {
	// Categories - The related categories for the query.
	Categories *[]string `json:"categories,omitempty"`
	// Solutions - The related Log Analytics solutions for the query.
	Solutions *[]string `json:"solutions,omitempty"`
	// ResourceTypes - The related resource types for the query.
	ResourceTypes *[]string `json:"resourceTypes,omitempty"`
	// Tables - The related tables for the query.
	Tables *[]string `json:"tables,omitempty"`
}

// MetadataResourceType metadata about types of Azure resources, containing relevant tables, functions,
// etc.
type MetadataResourceType struct {
	// ID - The ID of the resource-type
	ID *string `json:"id,omitempty"`
	// Type - The type of the resource-type
	Type *string `json:"type,omitempty"`
	// DisplayName - The display name of the resource-type
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the resource-type
	Description *string `json:"description,omitempty"`
	// Labels - The user-defined labels of the resource-type
	Labels *[]string `json:"labels,omitempty"`
	// Tags - The tags associated with the resource-type
	Tags interface{} `json:"tags,omitempty"`
	// Properties - The properties of the resource-type
	Properties interface{} `json:"properties,omitempty"`
	// Related - The related metadata items for the resource-type
	Related *MetadataResourceTypeRelated `json:"related,omitempty"`
}

// MetadataResourceTypeRelated the related metadata items for the resource-type
type MetadataResourceTypeRelated struct {
	// Tables - The tables related to the resource-type
	Tables *[]string `json:"tables,omitempty"`
	// Functions - The functions related to the resource-type
	Functions *[]string `json:"functions,omitempty"`
	// Categories - The categories related to the resource-type
	Categories *[]string `json:"categories,omitempty"`
	// Queries - The queries related to the resource-type
	Queries *[]string `json:"queries,omitempty"`
	// Workspaces - The Log Analytics workspaces related to the resource-type
	Workspaces *[]string `json:"workspaces,omitempty"`
	// Resources - The Azure resources related to the resource-type
	Resources *[]string `json:"resources,omitempty"`
}

// MetadataResults the metadata response for the app, including available tables, etc.
type MetadataResults struct {
	autorest.Response `json:"-"`
	// Categories - The list of categories that are referenced in this metadata response.
	Categories *[]MetadataCategory `json:"categories,omitempty"`
	// ResourceTypes - The list of resource types that are referenced in this metadata response.
	ResourceTypes *[]MetadataResourceType `json:"resourceTypes,omitempty"`
	// Solutions - The list of Log Analytics solutions installed on the workspace.
	Solutions *[]MetadataSolution `json:"solutions,omitempty"`
	// Tables - The list of tables and columns that comprise the schema of the workspace.
	Tables *[]MetadataTable `json:"tables,omitempty"`
	// Functions - The list of functions stored on the workspace, or introduced by solutions etc.
	Functions *[]MetadataFunction `json:"functions,omitempty"`
	// Queries - The list of saved queries stored on the workspace, or introduced by solutions, resource types, etc.
	Queries *[]MetadataQuery `json:"queries,omitempty"`
	// Applications - The list of Application Insights apps that were referenced in the metadata request.
	Applications *[]MetadataApplication `json:"applications,omitempty"`
	// Workspaces - The list of Log Analytics workspaces that were referenced in the metadata request.
	Workspaces *[]MetadataWorkspace `json:"workspaces,omitempty"`
	// Resources - The list of Azure resources that were referenced in the metadata request.
	Resources *[]interface{} `json:"resources,omitempty"`
	// Permissions - The list of permission rules that affected the metadata request.
	Permissions *[]MetadataPermissions `json:"permissions,omitempty"`
}

// MetadataSolution solutions can group tables and functions that are associated with a certain Azure Log
// Analytics offering.
type MetadataSolution struct {
	// ID - The ID of the Log Analytics solution
	ID *string `json:"id,omitempty"`
	// Name - The name of the Log Analytics solution
	Name *string `json:"name,omitempty"`
	// DisplayName - The display name of the Log Analytics solution
	DisplayName *string `json:"displayName,omitempty"`
	// Description - The description of the Log Analytics solution
	Description *string `json:"description,omitempty"`
	// Tags - The tags that are associated with the Log Analytics solution
	Tags interface{} `json:"tags,omitempty"`
	// Properties - The properties of the Log Analytics solution
	Properties interface{} `json:"properties,omitempty"`
	// Related - The related metadata items for the Log Analytics solution
	Related *MetadataSolutionRelated `json:"related,omitempty"`
}

// MetadataSolutionRelated the related metadata items for the Log Analytics solution
type MetadataSolutionRelated struct {
	// Tables - The tables related to the Log Analytics solution
	Tables *[]string `json:"tables,omitempty"`
	// Functions - The functions related to the Log Analytics solution
	Functions *[]string `json:"functions,omitempty"`
	// Categories - The categories related to the Log Analytics solution
	Categories *[]string `json:"categories,omitempty"`
	// Queries - The saved queries related to the Log Analytics solution
	Queries *[]string `json:"queries,omitempty"`
	// Workspaces - The Workspaces referenced in the metadata request that are related to the Log Analytics solution
	Workspaces *[]string `json:"workspaces,omitempty"`
}

// MetadataTable tables are part of the workspace schema, and contain a list of columns and a reference to
// other relevant metadata items.
type MetadataTable struct {
	// ID - The ID of the table
	ID *string `json:"id,omitempty"`
	// Name - The name of the table
	Name *string `json:"name,omitempty"`
	// Description - The description of the table
	Description *string `json:"description,omitempty"`
	// TimespanColumn - The column associated with the timespan query parameter for the table
	TimespanColumn *string `json:"timespanColumn,omitempty"`
	// Labels - The user defined labels of the table
	Labels *[]string `json:"labels,omitempty"`
	// Tags - The tags associated with the table
	Tags interface{} `json:"tags,omitempty"`
	// Properties - The properties of the table
	Properties interface{} `json:"properties,omitempty"`
	// Columns - The list of columns defined on the table
	Columns *[]MetadataTableColumnsItem `json:"columns,omitempty"`
	// Related - The related metadata items for the table
	Related *MetadataTableRelated `json:"related,omitempty"`
}

// MetadataTableColumnsItem ...
type MetadataTableColumnsItem struct {
	// Name - The name of the column
	Name *string `json:"name,omitempty"`
	// Description - The description of the column
	Description *string `json:"description,omitempty"`
	// Type - The data type of the column. Possible values include: 'Bool', 'Datetime', 'Dynamic', 'Int', 'Long', 'Real', 'String'
	Type MetadataColumnDataType `json:"type,omitempty"`
	// IsPreferredFacet - A flag indicating this column is a preferred facet
	IsPreferredFacet *bool `json:"isPreferredFacet,omitempty"`
	// Source - an indication of the source of the column, used only when multiple workspaces have conflicting definition for the column
	Source interface{} `json:"source,omitempty"`
}

// MetadataTableRelated the related metadata items for the table
type MetadataTableRelated struct {
	// Categories - The related categories for the table
	Categories *[]string `json:"categories,omitempty"`
	// Solutions - The related Log Analytics solutions for the table
	Solutions *[]string `json:"solutions,omitempty"`
	// ResourceTypes - The related resource types for the table
	ResourceTypes *[]string `json:"resourceTypes,omitempty"`
	// Workspaces - The related Log Analytics workspaces for the table
	Workspaces *[]string `json:"workspaces,omitempty"`
	// Functions - The related functions for the table
	Functions *[]string `json:"functions,omitempty"`
	// Queries - The related saved queries for the table
	Queries *[]string `json:"queries,omitempty"`
}

// MetadataWorkspace log Analytics workspaces that were part of the metadata request and that the user has
// access to.
type MetadataWorkspace struct {
	// ID - The ID of the Log Analytics workspace.
	ID *string `json:"id,omitempty"`
	// ResourceID - The ARM resource ID of the Log Analytics workspace.
	ResourceID *string `json:"resourceId,omitempty"`
	// Name - The name of the Log Analytics workspace.
	Name *string `json:"name,omitempty"`
	// Region - The Azure region of the Log Analytics workspace.
	Region *string `json:"region,omitempty"`
	// Related - The related metadata items for the Log Analytics workspace.
	Related *MetadataWorkspaceRelated `json:"related,omitempty"`
}

// MetadataWorkspaceRelated the related metadata items for the Log Analytics workspace.
type MetadataWorkspaceRelated struct {
	// Tables - The related tables for the Log Analytics workspace.
	Tables *[]string `json:"tables,omitempty"`
	// Solutions - The related Log Analytics solutions for the Log Analytics workspace.
	Solutions *[]string `json:"solutions,omitempty"`
	// ResourceTypes - The related resource types for the Log Analytics workspace.
	ResourceTypes *[]string `json:"resourceTypes,omitempty"`
	// Functions - The related functions for the Log Analytics workspace.
	Functions *[]string `json:"functions,omitempty"`
	// Resources - The related Azure resources for the Log Analytics workspace.
	Resources *[]string `json:"resources,omitempty"`
}

// QueryBody the Analytics query. Learn more about the [Analytics query
// syntax](https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/)
type QueryBody struct {
	// Query - The query to execute.
	Query *string `json:"query,omitempty"`
	// Timespan - Optional. The timespan over which to query data. This is an ISO8601 time period value.  This timespan is applied in addition to any that are specified in the query expression.
	Timespan *string `json:"timespan,omitempty"`
	// Workspaces - A list of workspaces that are included in the query.
	Workspaces *[]string `json:"workspaces,omitempty"`
}

// QueryResults contains the tables, columns & rows resulting from a query.
type QueryResults struct {
	autorest.Response `json:"-"`
	// Tables - The list of tables, columns and rows.
	Tables *[]Table `json:"tables,omitempty"`
}

// Table contains the columns and rows for one table in a query response.
type Table struct {
	// Name - The name of the table.
	Name *string `json:"name,omitempty"`
	// Columns - The list of columns in this table.
	Columns *[]Column `json:"columns,omitempty"`
	// Rows - The resulting rows from this query.
	Rows *[][]interface{} `json:"rows,omitempty"`
}
