// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAllocateStaticIp = "AllocateStaticIp"

// AllocateStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the AllocateStaticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AllocateStaticIp for more information on using the AllocateStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AllocateStaticIpRequest method.
//    req, resp := client.AllocateStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp
func (c *Lightsail) AllocateStaticIpRequest(input *AllocateStaticIpInput) (req *request.Request, output *AllocateStaticIpOutput) {
	op := &request.Operation{
		Name:       opAllocateStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateStaticIpInput{}
	}

	output = &AllocateStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AllocateStaticIp API operation for Amazon Lightsail.
//
// Allocates a static IP address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AllocateStaticIp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AllocateStaticIp
func (c *Lightsail) AllocateStaticIp(input *AllocateStaticIpInput) (*AllocateStaticIpOutput, error) {
	req, out := c.AllocateStaticIpRequest(input)
	return out, req.Send()
}

// AllocateStaticIpWithContext is the same as AllocateStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AllocateStaticIpWithContext(ctx aws.Context, input *AllocateStaticIpInput, opts ...request.Option) (*AllocateStaticIpOutput, error) {
	req, out := c.AllocateStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachDisk = "AttachDisk"

// AttachDiskRequest generates a "aws/request.Request" representing the
// client's request for the AttachDisk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachDisk for more information on using the AttachDisk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachDiskRequest method.
//    req, resp := client.AttachDiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk
func (c *Lightsail) AttachDiskRequest(input *AttachDiskInput) (req *request.Request, output *AttachDiskOutput) {
	op := &request.Operation{
		Name:       opAttachDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachDiskInput{}
	}

	output = &AttachDiskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachDisk API operation for Amazon Lightsail.
//
// Attaches a block storage disk to a running or stopped Lightsail instance
// and exposes it to the instance with the specified disk name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AttachDisk for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk
func (c *Lightsail) AttachDisk(input *AttachDiskInput) (*AttachDiskOutput, error) {
	req, out := c.AttachDiskRequest(input)
	return out, req.Send()
}

// AttachDiskWithContext is the same as AttachDisk with the addition of
// the ability to pass a context and additional request options.
//
// See AttachDisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AttachDiskWithContext(ctx aws.Context, input *AttachDiskInput, opts ...request.Option) (*AttachDiskOutput, error) {
	req, out := c.AttachDiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachInstancesToLoadBalancer = "AttachInstancesToLoadBalancer"

// AttachInstancesToLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the AttachInstancesToLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachInstancesToLoadBalancer for more information on using the AttachInstancesToLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachInstancesToLoadBalancerRequest method.
//    req, resp := client.AttachInstancesToLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer
func (c *Lightsail) AttachInstancesToLoadBalancerRequest(input *AttachInstancesToLoadBalancerInput) (req *request.Request, output *AttachInstancesToLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opAttachInstancesToLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachInstancesToLoadBalancerInput{}
	}

	output = &AttachInstancesToLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachInstancesToLoadBalancer API operation for Amazon Lightsail.
//
// Attaches one or more Lightsail instances to a load balancer.
//
// After some time, the instances are attached to the load balancer and the
// health check status is available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AttachInstancesToLoadBalancer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachInstancesToLoadBalancer
func (c *Lightsail) AttachInstancesToLoadBalancer(input *AttachInstancesToLoadBalancerInput) (*AttachInstancesToLoadBalancerOutput, error) {
	req, out := c.AttachInstancesToLoadBalancerRequest(input)
	return out, req.Send()
}

// AttachInstancesToLoadBalancerWithContext is the same as AttachInstancesToLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See AttachInstancesToLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AttachInstancesToLoadBalancerWithContext(ctx aws.Context, input *AttachInstancesToLoadBalancerInput, opts ...request.Option) (*AttachInstancesToLoadBalancerOutput, error) {
	req, out := c.AttachInstancesToLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachLoadBalancerTlsCertificate = "AttachLoadBalancerTlsCertificate"

// AttachLoadBalancerTlsCertificateRequest generates a "aws/request.Request" representing the
// client's request for the AttachLoadBalancerTlsCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachLoadBalancerTlsCertificate for more information on using the AttachLoadBalancerTlsCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachLoadBalancerTlsCertificateRequest method.
//    req, resp := client.AttachLoadBalancerTlsCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate
func (c *Lightsail) AttachLoadBalancerTlsCertificateRequest(input *AttachLoadBalancerTlsCertificateInput) (req *request.Request, output *AttachLoadBalancerTlsCertificateOutput) {
	op := &request.Operation{
		Name:       opAttachLoadBalancerTlsCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachLoadBalancerTlsCertificateInput{}
	}

	output = &AttachLoadBalancerTlsCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachLoadBalancerTlsCertificate API operation for Amazon Lightsail.
//
// Attaches a Transport Layer Security (TLS) certificate to your load balancer.
// TLS is just an updated, more secure version of Secure Socket Layer (SSL).
//
// Once you create and validate your certificate, you can attach it to your
// load balancer. You can also use this API to rotate the certificates on your
// account. Use the AttachLoadBalancerTlsCertificate operation with the non-attached
// certificate, and it will replace the existing one and become the attached
// certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AttachLoadBalancerTlsCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachLoadBalancerTlsCertificate
func (c *Lightsail) AttachLoadBalancerTlsCertificate(input *AttachLoadBalancerTlsCertificateInput) (*AttachLoadBalancerTlsCertificateOutput, error) {
	req, out := c.AttachLoadBalancerTlsCertificateRequest(input)
	return out, req.Send()
}

// AttachLoadBalancerTlsCertificateWithContext is the same as AttachLoadBalancerTlsCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See AttachLoadBalancerTlsCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AttachLoadBalancerTlsCertificateWithContext(ctx aws.Context, input *AttachLoadBalancerTlsCertificateInput, opts ...request.Option) (*AttachLoadBalancerTlsCertificateOutput, error) {
	req, out := c.AttachLoadBalancerTlsCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachStaticIp = "AttachStaticIp"

// AttachStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the AttachStaticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachStaticIp for more information on using the AttachStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachStaticIpRequest method.
//    req, resp := client.AttachStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp
func (c *Lightsail) AttachStaticIpRequest(input *AttachStaticIpInput) (req *request.Request, output *AttachStaticIpOutput) {
	op := &request.Operation{
		Name:       opAttachStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachStaticIpInput{}
	}

	output = &AttachStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AttachStaticIp API operation for Amazon Lightsail.
//
// Attaches a static IP address to a specific Amazon Lightsail instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation AttachStaticIp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachStaticIp
func (c *Lightsail) AttachStaticIp(input *AttachStaticIpInput) (*AttachStaticIpOutput, error) {
	req, out := c.AttachStaticIpRequest(input)
	return out, req.Send()
}

// AttachStaticIpWithContext is the same as AttachStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See AttachStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) AttachStaticIpWithContext(ctx aws.Context, input *AttachStaticIpInput, opts ...request.Option) (*AttachStaticIpOutput, error) {
	req, out := c.AttachStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCloseInstancePublicPorts = "CloseInstancePublicPorts"

// CloseInstancePublicPortsRequest generates a "aws/request.Request" representing the
// client's request for the CloseInstancePublicPorts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CloseInstancePublicPorts for more information on using the CloseInstancePublicPorts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CloseInstancePublicPortsRequest method.
//    req, resp := client.CloseInstancePublicPortsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts
func (c *Lightsail) CloseInstancePublicPortsRequest(input *CloseInstancePublicPortsInput) (req *request.Request, output *CloseInstancePublicPortsOutput) {
	op := &request.Operation{
		Name:       opCloseInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloseInstancePublicPortsInput{}
	}

	output = &CloseInstancePublicPortsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CloseInstancePublicPorts API operation for Amazon Lightsail.
//
// Closes the public ports on a specific Amazon Lightsail instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CloseInstancePublicPorts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CloseInstancePublicPorts
func (c *Lightsail) CloseInstancePublicPorts(input *CloseInstancePublicPortsInput) (*CloseInstancePublicPortsOutput, error) {
	req, out := c.CloseInstancePublicPortsRequest(input)
	return out, req.Send()
}

// CloseInstancePublicPortsWithContext is the same as CloseInstancePublicPorts with the addition of
// the ability to pass a context and additional request options.
//
// See CloseInstancePublicPorts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CloseInstancePublicPortsWithContext(ctx aws.Context, input *CloseInstancePublicPortsInput, opts ...request.Option) (*CloseInstancePublicPortsOutput, error) {
	req, out := c.CloseInstancePublicPortsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDisk = "CreateDisk"

// CreateDiskRequest generates a "aws/request.Request" representing the
// client's request for the CreateDisk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDisk for more information on using the CreateDisk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDiskRequest method.
//    req, resp := client.CreateDiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk
func (c *Lightsail) CreateDiskRequest(input *CreateDiskInput) (req *request.Request, output *CreateDiskOutput) {
	op := &request.Operation{
		Name:       opCreateDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDiskInput{}
	}

	output = &CreateDiskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDisk API operation for Amazon Lightsail.
//
// Creates a block storage disk that can be attached to a Lightsail instance
// in the same Availability Zone (e.g., us-east-2a). The disk is created in
// the regional endpoint that you send the HTTP request to. For more information,
// see Regions and Availability Zones in Lightsail (https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDisk for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDisk
func (c *Lightsail) CreateDisk(input *CreateDiskInput) (*CreateDiskOutput, error) {
	req, out := c.CreateDiskRequest(input)
	return out, req.Send()
}

// CreateDiskWithContext is the same as CreateDisk with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDiskWithContext(ctx aws.Context, input *CreateDiskInput, opts ...request.Option) (*CreateDiskOutput, error) {
	req, out := c.CreateDiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDiskFromSnapshot = "CreateDiskFromSnapshot"

// CreateDiskFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateDiskFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDiskFromSnapshot for more information on using the CreateDiskFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDiskFromSnapshotRequest method.
//    req, resp := client.CreateDiskFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot
func (c *Lightsail) CreateDiskFromSnapshotRequest(input *CreateDiskFromSnapshotInput) (req *request.Request, output *CreateDiskFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDiskFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDiskFromSnapshotInput{}
	}

	output = &CreateDiskFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDiskFromSnapshot API operation for Amazon Lightsail.
//
// Creates a block storage disk from a disk snapshot that can be attached to
// a Lightsail instance in the same Availability Zone (e.g., us-east-2a). The
// disk is created in the regional endpoint that you send the HTTP request to.
// For more information, see Regions and Availability Zones in Lightsail (https://lightsail.aws.amazon.com/ls/docs/overview/article/understanding-regions-and-availability-zones-in-amazon-lightsail).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDiskFromSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskFromSnapshot
func (c *Lightsail) CreateDiskFromSnapshot(input *CreateDiskFromSnapshotInput) (*CreateDiskFromSnapshotOutput, error) {
	req, out := c.CreateDiskFromSnapshotRequest(input)
	return out, req.Send()
}

// CreateDiskFromSnapshotWithContext is the same as CreateDiskFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDiskFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDiskFromSnapshotWithContext(ctx aws.Context, input *CreateDiskFromSnapshotInput, opts ...request.Option) (*CreateDiskFromSnapshotOutput, error) {
	req, out := c.CreateDiskFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDiskSnapshot = "CreateDiskSnapshot"

// CreateDiskSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateDiskSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDiskSnapshot for more information on using the CreateDiskSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDiskSnapshotRequest method.
//    req, resp := client.CreateDiskSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot
func (c *Lightsail) CreateDiskSnapshotRequest(input *CreateDiskSnapshotInput) (req *request.Request, output *CreateDiskSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateDiskSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDiskSnapshotInput{}
	}

	output = &CreateDiskSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDiskSnapshot API operation for Amazon Lightsail.
//
// Creates a snapshot of a block storage disk. You can use snapshots for backups,
// to make copies of disks, and to save data before shutting down a Lightsail
// instance.
//
// You can take a snapshot of an attached disk that is in use; however, snapshots
// only capture data that has been written to your disk at the time the snapshot
// command is issued. This may exclude any data that has been cached by any
// applications or the operating system. If you can pause any file systems on
// the disk long enough to take a snapshot, your snapshot should be complete.
// Nevertheless, if you cannot pause all file writes to the disk, you should
// unmount the disk from within the Lightsail instance, issue the create disk
// snapshot command, and then remount the disk to ensure a consistent and complete
// snapshot. You may remount and use your disk while the snapshot status is
// pending.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDiskSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDiskSnapshot
func (c *Lightsail) CreateDiskSnapshot(input *CreateDiskSnapshotInput) (*CreateDiskSnapshotOutput, error) {
	req, out := c.CreateDiskSnapshotRequest(input)
	return out, req.Send()
}

// CreateDiskSnapshotWithContext is the same as CreateDiskSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDiskSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDiskSnapshotWithContext(ctx aws.Context, input *CreateDiskSnapshotInput, opts ...request.Option) (*CreateDiskSnapshotOutput, error) {
	req, out := c.CreateDiskSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainRequest method.
//    req, resp := client.CreateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain
func (c *Lightsail) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon Lightsail.
//
// Creates a domain resource for the specified domain (e.g., example.com).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomain
func (c *Lightsail) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomainEntry = "CreateDomainEntry"

// CreateDomainEntryRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomainEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomainEntry for more information on using the CreateDomainEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainEntryRequest method.
//    req, resp := client.CreateDomainEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry
func (c *Lightsail) CreateDomainEntryRequest(input *CreateDomainEntryInput) (req *request.Request, output *CreateDomainEntryOutput) {
	op := &request.Operation{
		Name:       opCreateDomainEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainEntryInput{}
	}

	output = &CreateDomainEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomainEntry API operation for Amazon Lightsail.
//
// Creates one of the following entry records associated with the domain: A
// record, CNAME record, TXT record, or MX record.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateDomainEntry for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateDomainEntry
func (c *Lightsail) CreateDomainEntry(input *CreateDomainEntryInput) (*CreateDomainEntryOutput, error) {
	req, out := c.CreateDomainEntryRequest(input)
	return out, req.Send()
}

// CreateDomainEntryWithContext is the same as CreateDomainEntry with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomainEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateDomainEntryWithContext(ctx aws.Context, input *CreateDomainEntryInput, opts ...request.Option) (*CreateDomainEntryOutput, error) {
	req, out := c.CreateDomainEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceSnapshot = "CreateInstanceSnapshot"

// CreateInstanceSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceSnapshot for more information on using the CreateInstanceSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstanceSnapshotRequest method.
//    req, resp := client.CreateInstanceSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot
func (c *Lightsail) CreateInstanceSnapshotRequest(input *CreateInstanceSnapshotInput) (req *request.Request, output *CreateInstanceSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceSnapshotInput{}
	}

	output = &CreateInstanceSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceSnapshot API operation for Amazon Lightsail.
//
// Creates a snapshot of a specific virtual private server, or instance. You
// can use a snapshot to create a new instance that is based on that snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateInstanceSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstanceSnapshot
func (c *Lightsail) CreateInstanceSnapshot(input *CreateInstanceSnapshotInput) (*CreateInstanceSnapshotOutput, error) {
	req, out := c.CreateInstanceSnapshotRequest(input)
	return out, req.Send()
}

// CreateInstanceSnapshotWithContext is the same as CreateInstanceSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateInstanceSnapshotWithContext(ctx aws.Context, input *CreateInstanceSnapshotInput, opts ...request.Option) (*CreateInstanceSnapshotOutput, error) {
	req, out := c.CreateInstanceSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstances = "CreateInstances"

// CreateInstancesRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstances for more information on using the CreateInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstancesRequest method.
//    req, resp := client.CreateInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances
func (c *Lightsail) CreateInstancesRequest(input *CreateInstancesInput) (req *request.Request, output *CreateInstancesOutput) {
	op := &request.Operation{
		Name:       opCreateInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstancesInput{}
	}

	output = &CreateInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstances API operation for Amazon Lightsail.
//
// Creates one or more Amazon Lightsail virtual private servers, or instances.
// Create instances using active blueprints. Inactive blueprints are listed
// to support customers with existing instances but are not necessarily available
// for launch of new instances. Blueprints are marked inactive when they become
// outdated due to operating system updates or new application releases. Use
// the get blueprints operation to return a list of available blueprints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstances
func (c *Lightsail) CreateInstances(input *CreateInstancesInput) (*CreateInstancesOutput, error) {
	req, out := c.CreateInstancesRequest(input)
	return out, req.Send()
}

// CreateInstancesWithContext is the same as CreateInstances with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateInstancesWithContext(ctx aws.Context, input *CreateInstancesInput, opts ...request.Option) (*CreateInstancesOutput, error) {
	req, out := c.CreateInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstancesFromSnapshot = "CreateInstancesFromSnapshot"

// CreateInstancesFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstancesFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstancesFromSnapshot for more information on using the CreateInstancesFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstancesFromSnapshotRequest method.
//    req, resp := client.CreateInstancesFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot
func (c *Lightsail) CreateInstancesFromSnapshotRequest(input *CreateInstancesFromSnapshotInput) (req *request.Request, output *CreateInstancesFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateInstancesFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstancesFromSnapshotInput{}
	}

	output = &CreateInstancesFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstancesFromSnapshot API operation for Amazon Lightsail.
//
// Uses a specific snapshot as a blueprint for creating one or more new instances
// that are based on that identical configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateInstancesFromSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateInstancesFromSnapshot
func (c *Lightsail) CreateInstancesFromSnapshot(input *CreateInstancesFromSnapshotInput) (*CreateInstancesFromSnapshotOutput, error) {
	req, out := c.CreateInstancesFromSnapshotRequest(input)
	return out, req.Send()
}

// CreateInstancesFromSnapshotWithContext is the same as CreateInstancesFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstancesFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateInstancesFromSnapshotWithContext(ctx aws.Context, input *CreateInstancesFromSnapshotInput, opts ...request.Option) (*CreateInstancesFromSnapshotOutput, error) {
	req, out := c.CreateInstancesFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKeyPair = "CreateKeyPair"

// CreateKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the CreateKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKeyPair for more information on using the CreateKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateKeyPairRequest method.
//    req, resp := client.CreateKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair
func (c *Lightsail) CreateKeyPairRequest(input *CreateKeyPairInput) (req *request.Request, output *CreateKeyPairOutput) {
	op := &request.Operation{
		Name:       opCreateKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyPairInput{}
	}

	output = &CreateKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKeyPair API operation for Amazon Lightsail.
//
// Creates an SSH key pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateKeyPair for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateKeyPair
func (c *Lightsail) CreateKeyPair(input *CreateKeyPairInput) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	return out, req.Send()
}

// CreateKeyPairWithContext is the same as CreateKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateKeyPairWithContext(ctx aws.Context, input *CreateKeyPairInput, opts ...request.Option) (*CreateKeyPairOutput, error) {
	req, out := c.CreateKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLoadBalancer = "CreateLoadBalancer"

// CreateLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLoadBalancer for more information on using the CreateLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLoadBalancerRequest method.
//    req, resp := client.CreateLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer
func (c *Lightsail) CreateLoadBalancerRequest(input *CreateLoadBalancerInput) (req *request.Request, output *CreateLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opCreateLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerInput{}
	}

	output = &CreateLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoadBalancer API operation for Amazon Lightsail.
//
// Creates a Lightsail load balancer. To learn more about deciding whether to
// load balance your application, see Configure your Lightsail instances for
// load balancing (https://lightsail.aws.amazon.com/ls/docs/how-to/article/configure-lightsail-instances-for-load-balancing).
// You can create up to 5 load balancers per AWS Region in your account.
//
// When you create a load balancer, you can specify a unique name and port settings.
// To change additional load balancer settings, use the UpdateLoadBalancerAttribute
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateLoadBalancer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancer
func (c *Lightsail) CreateLoadBalancer(input *CreateLoadBalancerInput) (*CreateLoadBalancerOutput, error) {
	req, out := c.CreateLoadBalancerRequest(input)
	return out, req.Send()
}

// CreateLoadBalancerWithContext is the same as CreateLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateLoadBalancerWithContext(ctx aws.Context, input *CreateLoadBalancerInput, opts ...request.Option) (*CreateLoadBalancerOutput, error) {
	req, out := c.CreateLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLoadBalancerTlsCertificate = "CreateLoadBalancerTlsCertificate"

// CreateLoadBalancerTlsCertificateRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoadBalancerTlsCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLoadBalancerTlsCertificate for more information on using the CreateLoadBalancerTlsCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLoadBalancerTlsCertificateRequest method.
//    req, resp := client.CreateLoadBalancerTlsCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate
func (c *Lightsail) CreateLoadBalancerTlsCertificateRequest(input *CreateLoadBalancerTlsCertificateInput) (req *request.Request, output *CreateLoadBalancerTlsCertificateOutput) {
	op := &request.Operation{
		Name:       opCreateLoadBalancerTlsCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoadBalancerTlsCertificateInput{}
	}

	output = &CreateLoadBalancerTlsCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoadBalancerTlsCertificate API operation for Amazon Lightsail.
//
// Creates a Lightsail load balancer TLS certificate.
//
// TLS is just an updated, more secure version of Secure Socket Layer (SSL).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateLoadBalancerTlsCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateLoadBalancerTlsCertificate
func (c *Lightsail) CreateLoadBalancerTlsCertificate(input *CreateLoadBalancerTlsCertificateInput) (*CreateLoadBalancerTlsCertificateOutput, error) {
	req, out := c.CreateLoadBalancerTlsCertificateRequest(input)
	return out, req.Send()
}

// CreateLoadBalancerTlsCertificateWithContext is the same as CreateLoadBalancerTlsCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLoadBalancerTlsCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateLoadBalancerTlsCertificateWithContext(ctx aws.Context, input *CreateLoadBalancerTlsCertificateInput, opts ...request.Option) (*CreateLoadBalancerTlsCertificateOutput, error) {
	req, out := c.CreateLoadBalancerTlsCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRelationalDatabase = "CreateRelationalDatabase"

// CreateRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRelationalDatabase for more information on using the CreateRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRelationalDatabaseRequest method.
//    req, resp := client.CreateRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabase
func (c *Lightsail) CreateRelationalDatabaseRequest(input *CreateRelationalDatabaseInput) (req *request.Request, output *CreateRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opCreateRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRelationalDatabaseInput{}
	}

	output = &CreateRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRelationalDatabase API operation for Amazon Lightsail.
//
// Creates a new database in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateRelationalDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabase
func (c *Lightsail) CreateRelationalDatabase(input *CreateRelationalDatabaseInput) (*CreateRelationalDatabaseOutput, error) {
	req, out := c.CreateRelationalDatabaseRequest(input)
	return out, req.Send()
}

// CreateRelationalDatabaseWithContext is the same as CreateRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateRelationalDatabaseWithContext(ctx aws.Context, input *CreateRelationalDatabaseInput, opts ...request.Option) (*CreateRelationalDatabaseOutput, error) {
	req, out := c.CreateRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRelationalDatabaseFromSnapshot = "CreateRelationalDatabaseFromSnapshot"

// CreateRelationalDatabaseFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateRelationalDatabaseFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRelationalDatabaseFromSnapshot for more information on using the CreateRelationalDatabaseFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRelationalDatabaseFromSnapshotRequest method.
//    req, resp := client.CreateRelationalDatabaseFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseFromSnapshot
func (c *Lightsail) CreateRelationalDatabaseFromSnapshotRequest(input *CreateRelationalDatabaseFromSnapshotInput) (req *request.Request, output *CreateRelationalDatabaseFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateRelationalDatabaseFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRelationalDatabaseFromSnapshotInput{}
	}

	output = &CreateRelationalDatabaseFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRelationalDatabaseFromSnapshot API operation for Amazon Lightsail.
//
// Creates a new database from an existing database snapshot in Amazon Lightsail.
//
// You can create a new database from a snapshot in if something goes wrong
// with your original database, or to change it to a different plan, such as
// a high availability or standard plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateRelationalDatabaseFromSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseFromSnapshot
func (c *Lightsail) CreateRelationalDatabaseFromSnapshot(input *CreateRelationalDatabaseFromSnapshotInput) (*CreateRelationalDatabaseFromSnapshotOutput, error) {
	req, out := c.CreateRelationalDatabaseFromSnapshotRequest(input)
	return out, req.Send()
}

// CreateRelationalDatabaseFromSnapshotWithContext is the same as CreateRelationalDatabaseFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRelationalDatabaseFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateRelationalDatabaseFromSnapshotWithContext(ctx aws.Context, input *CreateRelationalDatabaseFromSnapshotInput, opts ...request.Option) (*CreateRelationalDatabaseFromSnapshotOutput, error) {
	req, out := c.CreateRelationalDatabaseFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRelationalDatabaseSnapshot = "CreateRelationalDatabaseSnapshot"

// CreateRelationalDatabaseSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateRelationalDatabaseSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRelationalDatabaseSnapshot for more information on using the CreateRelationalDatabaseSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRelationalDatabaseSnapshotRequest method.
//    req, resp := client.CreateRelationalDatabaseSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshot
func (c *Lightsail) CreateRelationalDatabaseSnapshotRequest(input *CreateRelationalDatabaseSnapshotInput) (req *request.Request, output *CreateRelationalDatabaseSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateRelationalDatabaseSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRelationalDatabaseSnapshotInput{}
	}

	output = &CreateRelationalDatabaseSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRelationalDatabaseSnapshot API operation for Amazon Lightsail.
//
// Creates a snapshot of your database in Amazon Lightsail. You can use snapshots
// for backups, to make copies of a database, and to save data before deleting
// a database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation CreateRelationalDatabaseSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/CreateRelationalDatabaseSnapshot
func (c *Lightsail) CreateRelationalDatabaseSnapshot(input *CreateRelationalDatabaseSnapshotInput) (*CreateRelationalDatabaseSnapshotOutput, error) {
	req, out := c.CreateRelationalDatabaseSnapshotRequest(input)
	return out, req.Send()
}

// CreateRelationalDatabaseSnapshotWithContext is the same as CreateRelationalDatabaseSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRelationalDatabaseSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) CreateRelationalDatabaseSnapshotWithContext(ctx aws.Context, input *CreateRelationalDatabaseSnapshotInput, opts ...request.Option) (*CreateRelationalDatabaseSnapshotOutput, error) {
	req, out := c.CreateRelationalDatabaseSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDisk = "DeleteDisk"

// DeleteDiskRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDisk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDisk for more information on using the DeleteDisk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDiskRequest method.
//    req, resp := client.DeleteDiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk
func (c *Lightsail) DeleteDiskRequest(input *DeleteDiskInput) (req *request.Request, output *DeleteDiskOutput) {
	op := &request.Operation{
		Name:       opDeleteDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDiskInput{}
	}

	output = &DeleteDiskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDisk API operation for Amazon Lightsail.
//
// Deletes the specified block storage disk. The disk must be in the available
// state (not attached to a Lightsail instance).
//
// The disk may remain in the deleting state for several minutes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDisk for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDisk
func (c *Lightsail) DeleteDisk(input *DeleteDiskInput) (*DeleteDiskOutput, error) {
	req, out := c.DeleteDiskRequest(input)
	return out, req.Send()
}

// DeleteDiskWithContext is the same as DeleteDisk with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDiskWithContext(ctx aws.Context, input *DeleteDiskInput, opts ...request.Option) (*DeleteDiskOutput, error) {
	req, out := c.DeleteDiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDiskSnapshot = "DeleteDiskSnapshot"

// DeleteDiskSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDiskSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDiskSnapshot for more information on using the DeleteDiskSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDiskSnapshotRequest method.
//    req, resp := client.DeleteDiskSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot
func (c *Lightsail) DeleteDiskSnapshotRequest(input *DeleteDiskSnapshotInput) (req *request.Request, output *DeleteDiskSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteDiskSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDiskSnapshotInput{}
	}

	output = &DeleteDiskSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDiskSnapshot API operation for Amazon Lightsail.
//
// Deletes the specified disk snapshot.
//
// When you make periodic snapshots of a disk, the snapshots are incremental,
// and only the blocks on the device that have changed since your last snapshot
// are saved in the new snapshot. When you delete a snapshot, only the data
// not needed for any other snapshot is removed. So regardless of which prior
// snapshots have been deleted, all active snapshots will have access to all
// the information needed to restore the disk.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDiskSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDiskSnapshot
func (c *Lightsail) DeleteDiskSnapshot(input *DeleteDiskSnapshotInput) (*DeleteDiskSnapshotOutput, error) {
	req, out := c.DeleteDiskSnapshotRequest(input)
	return out, req.Send()
}

// DeleteDiskSnapshotWithContext is the same as DeleteDiskSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDiskSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDiskSnapshotWithContext(ctx aws.Context, input *DeleteDiskSnapshotInput, opts ...request.Option) (*DeleteDiskSnapshotOutput, error) {
	req, out := c.DeleteDiskSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainRequest method.
//    req, resp := client.DeleteDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain
func (c *Lightsail) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomain API operation for Amazon Lightsail.
//
// Deletes the specified domain recordset and all of its domain records.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomain
func (c *Lightsail) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomainEntry = "DeleteDomainEntry"

// DeleteDomainEntryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomainEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomainEntry for more information on using the DeleteDomainEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainEntryRequest method.
//    req, resp := client.DeleteDomainEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry
func (c *Lightsail) DeleteDomainEntryRequest(input *DeleteDomainEntryInput) (req *request.Request, output *DeleteDomainEntryOutput) {
	op := &request.Operation{
		Name:       opDeleteDomainEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainEntryInput{}
	}

	output = &DeleteDomainEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomainEntry API operation for Amazon Lightsail.
//
// Deletes a specific domain entry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteDomainEntry for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteDomainEntry
func (c *Lightsail) DeleteDomainEntry(input *DeleteDomainEntryInput) (*DeleteDomainEntryOutput, error) {
	req, out := c.DeleteDomainEntryRequest(input)
	return out, req.Send()
}

// DeleteDomainEntryWithContext is the same as DeleteDomainEntry with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomainEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteDomainEntryWithContext(ctx aws.Context, input *DeleteDomainEntryInput, opts ...request.Option) (*DeleteDomainEntryOutput, error) {
	req, out := c.DeleteDomainEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstance = "DeleteInstance"

// DeleteInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstance for more information on using the DeleteInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInstanceRequest method.
//    req, resp := client.DeleteInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance
func (c *Lightsail) DeleteInstanceRequest(input *DeleteInstanceInput) (req *request.Request, output *DeleteInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceInput{}
	}

	output = &DeleteInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInstance API operation for Amazon Lightsail.
//
// Deletes a specific Amazon Lightsail virtual private server, or instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance
func (c *Lightsail) DeleteInstance(input *DeleteInstanceInput) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	return out, req.Send()
}

// DeleteInstanceWithContext is the same as DeleteInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteInstanceWithContext(ctx aws.Context, input *DeleteInstanceInput, opts ...request.Option) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstanceSnapshot = "DeleteInstanceSnapshot"

// DeleteInstanceSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstanceSnapshot for more information on using the DeleteInstanceSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInstanceSnapshotRequest method.
//    req, resp := client.DeleteInstanceSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot
func (c *Lightsail) DeleteInstanceSnapshotRequest(input *DeleteInstanceSnapshotInput) (req *request.Request, output *DeleteInstanceSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceSnapshotInput{}
	}

	output = &DeleteInstanceSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteInstanceSnapshot API operation for Amazon Lightsail.
//
// Deletes a specific snapshot of a virtual private server (or instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteInstanceSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceSnapshot
func (c *Lightsail) DeleteInstanceSnapshot(input *DeleteInstanceSnapshotInput) (*DeleteInstanceSnapshotOutput, error) {
	req, out := c.DeleteInstanceSnapshotRequest(input)
	return out, req.Send()
}

// DeleteInstanceSnapshotWithContext is the same as DeleteInstanceSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstanceSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteInstanceSnapshotWithContext(ctx aws.Context, input *DeleteInstanceSnapshotInput, opts ...request.Option) (*DeleteInstanceSnapshotOutput, error) {
	req, out := c.DeleteInstanceSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKeyPair = "DeleteKeyPair"

// DeleteKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKeyPair for more information on using the DeleteKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteKeyPairRequest method.
//    req, resp := client.DeleteKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair
func (c *Lightsail) DeleteKeyPairRequest(input *DeleteKeyPairInput) (req *request.Request, output *DeleteKeyPairOutput) {
	op := &request.Operation{
		Name:       opDeleteKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteKeyPairInput{}
	}

	output = &DeleteKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKeyPair API operation for Amazon Lightsail.
//
// Deletes a specific SSH key pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteKeyPair for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteKeyPair
func (c *Lightsail) DeleteKeyPair(input *DeleteKeyPairInput) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	return out, req.Send()
}

// DeleteKeyPairWithContext is the same as DeleteKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteKeyPairWithContext(ctx aws.Context, input *DeleteKeyPairInput, opts ...request.Option) (*DeleteKeyPairOutput, error) {
	req, out := c.DeleteKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoadBalancer = "DeleteLoadBalancer"

// DeleteLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoadBalancer for more information on using the DeleteLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLoadBalancerRequest method.
//    req, resp := client.DeleteLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer
func (c *Lightsail) DeleteLoadBalancerRequest(input *DeleteLoadBalancerInput) (req *request.Request, output *DeleteLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opDeleteLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerInput{}
	}

	output = &DeleteLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLoadBalancer API operation for Amazon Lightsail.
//
// Deletes a Lightsail load balancer and all its associated SSL/TLS certificates.
// Once the load balancer is deleted, you will need to create a new load balancer,
// create a new certificate, and verify domain ownership again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteLoadBalancer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancer
func (c *Lightsail) DeleteLoadBalancer(input *DeleteLoadBalancerInput) (*DeleteLoadBalancerOutput, error) {
	req, out := c.DeleteLoadBalancerRequest(input)
	return out, req.Send()
}

// DeleteLoadBalancerWithContext is the same as DeleteLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteLoadBalancerWithContext(ctx aws.Context, input *DeleteLoadBalancerInput, opts ...request.Option) (*DeleteLoadBalancerOutput, error) {
	req, out := c.DeleteLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoadBalancerTlsCertificate = "DeleteLoadBalancerTlsCertificate"

// DeleteLoadBalancerTlsCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoadBalancerTlsCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoadBalancerTlsCertificate for more information on using the DeleteLoadBalancerTlsCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLoadBalancerTlsCertificateRequest method.
//    req, resp := client.DeleteLoadBalancerTlsCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate
func (c *Lightsail) DeleteLoadBalancerTlsCertificateRequest(input *DeleteLoadBalancerTlsCertificateInput) (req *request.Request, output *DeleteLoadBalancerTlsCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteLoadBalancerTlsCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoadBalancerTlsCertificateInput{}
	}

	output = &DeleteLoadBalancerTlsCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteLoadBalancerTlsCertificate API operation for Amazon Lightsail.
//
// Deletes an SSL/TLS certificate associated with a Lightsail load balancer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteLoadBalancerTlsCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteLoadBalancerTlsCertificate
func (c *Lightsail) DeleteLoadBalancerTlsCertificate(input *DeleteLoadBalancerTlsCertificateInput) (*DeleteLoadBalancerTlsCertificateOutput, error) {
	req, out := c.DeleteLoadBalancerTlsCertificateRequest(input)
	return out, req.Send()
}

// DeleteLoadBalancerTlsCertificateWithContext is the same as DeleteLoadBalancerTlsCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoadBalancerTlsCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteLoadBalancerTlsCertificateWithContext(ctx aws.Context, input *DeleteLoadBalancerTlsCertificateInput, opts ...request.Option) (*DeleteLoadBalancerTlsCertificateOutput, error) {
	req, out := c.DeleteLoadBalancerTlsCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRelationalDatabase = "DeleteRelationalDatabase"

// DeleteRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRelationalDatabase for more information on using the DeleteRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRelationalDatabaseRequest method.
//    req, resp := client.DeleteRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabase
func (c *Lightsail) DeleteRelationalDatabaseRequest(input *DeleteRelationalDatabaseInput) (req *request.Request, output *DeleteRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opDeleteRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRelationalDatabaseInput{}
	}

	output = &DeleteRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRelationalDatabase API operation for Amazon Lightsail.
//
// Deletes a database in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteRelationalDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabase
func (c *Lightsail) DeleteRelationalDatabase(input *DeleteRelationalDatabaseInput) (*DeleteRelationalDatabaseOutput, error) {
	req, out := c.DeleteRelationalDatabaseRequest(input)
	return out, req.Send()
}

// DeleteRelationalDatabaseWithContext is the same as DeleteRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteRelationalDatabaseWithContext(ctx aws.Context, input *DeleteRelationalDatabaseInput, opts ...request.Option) (*DeleteRelationalDatabaseOutput, error) {
	req, out := c.DeleteRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRelationalDatabaseSnapshot = "DeleteRelationalDatabaseSnapshot"

// DeleteRelationalDatabaseSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRelationalDatabaseSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRelationalDatabaseSnapshot for more information on using the DeleteRelationalDatabaseSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRelationalDatabaseSnapshotRequest method.
//    req, resp := client.DeleteRelationalDatabaseSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabaseSnapshot
func (c *Lightsail) DeleteRelationalDatabaseSnapshotRequest(input *DeleteRelationalDatabaseSnapshotInput) (req *request.Request, output *DeleteRelationalDatabaseSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteRelationalDatabaseSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRelationalDatabaseSnapshotInput{}
	}

	output = &DeleteRelationalDatabaseSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRelationalDatabaseSnapshot API operation for Amazon Lightsail.
//
// Deletes a database snapshot in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DeleteRelationalDatabaseSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteRelationalDatabaseSnapshot
func (c *Lightsail) DeleteRelationalDatabaseSnapshot(input *DeleteRelationalDatabaseSnapshotInput) (*DeleteRelationalDatabaseSnapshotOutput, error) {
	req, out := c.DeleteRelationalDatabaseSnapshotRequest(input)
	return out, req.Send()
}

// DeleteRelationalDatabaseSnapshotWithContext is the same as DeleteRelationalDatabaseSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRelationalDatabaseSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DeleteRelationalDatabaseSnapshotWithContext(ctx aws.Context, input *DeleteRelationalDatabaseSnapshotInput, opts ...request.Option) (*DeleteRelationalDatabaseSnapshotOutput, error) {
	req, out := c.DeleteRelationalDatabaseSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachDisk = "DetachDisk"

// DetachDiskRequest generates a "aws/request.Request" representing the
// client's request for the DetachDisk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachDisk for more information on using the DetachDisk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachDiskRequest method.
//    req, resp := client.DetachDiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk
func (c *Lightsail) DetachDiskRequest(input *DetachDiskInput) (req *request.Request, output *DetachDiskOutput) {
	op := &request.Operation{
		Name:       opDetachDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachDiskInput{}
	}

	output = &DetachDiskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachDisk API operation for Amazon Lightsail.
//
// Detaches a stopped block storage disk from a Lightsail instance. Make sure
// to unmount any file systems on the device within your operating system before
// stopping the instance and detaching the disk.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DetachDisk for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachDisk
func (c *Lightsail) DetachDisk(input *DetachDiskInput) (*DetachDiskOutput, error) {
	req, out := c.DetachDiskRequest(input)
	return out, req.Send()
}

// DetachDiskWithContext is the same as DetachDisk with the addition of
// the ability to pass a context and additional request options.
//
// See DetachDisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DetachDiskWithContext(ctx aws.Context, input *DetachDiskInput, opts ...request.Option) (*DetachDiskOutput, error) {
	req, out := c.DetachDiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachInstancesFromLoadBalancer = "DetachInstancesFromLoadBalancer"

// DetachInstancesFromLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the DetachInstancesFromLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachInstancesFromLoadBalancer for more information on using the DetachInstancesFromLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachInstancesFromLoadBalancerRequest method.
//    req, resp := client.DetachInstancesFromLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer
func (c *Lightsail) DetachInstancesFromLoadBalancerRequest(input *DetachInstancesFromLoadBalancerInput) (req *request.Request, output *DetachInstancesFromLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opDetachInstancesFromLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachInstancesFromLoadBalancerInput{}
	}

	output = &DetachInstancesFromLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachInstancesFromLoadBalancer API operation for Amazon Lightsail.
//
// Detaches the specified instances from a Lightsail load balancer.
//
// This operation waits until the instances are no longer needed before they
// are detached from the load balancer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DetachInstancesFromLoadBalancer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachInstancesFromLoadBalancer
func (c *Lightsail) DetachInstancesFromLoadBalancer(input *DetachInstancesFromLoadBalancerInput) (*DetachInstancesFromLoadBalancerOutput, error) {
	req, out := c.DetachInstancesFromLoadBalancerRequest(input)
	return out, req.Send()
}

// DetachInstancesFromLoadBalancerWithContext is the same as DetachInstancesFromLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See DetachInstancesFromLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DetachInstancesFromLoadBalancerWithContext(ctx aws.Context, input *DetachInstancesFromLoadBalancerInput, opts ...request.Option) (*DetachInstancesFromLoadBalancerOutput, error) {
	req, out := c.DetachInstancesFromLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachStaticIp = "DetachStaticIp"

// DetachStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the DetachStaticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachStaticIp for more information on using the DetachStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachStaticIpRequest method.
//    req, resp := client.DetachStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp
func (c *Lightsail) DetachStaticIpRequest(input *DetachStaticIpInput) (req *request.Request, output *DetachStaticIpOutput) {
	op := &request.Operation{
		Name:       opDetachStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachStaticIpInput{}
	}

	output = &DetachStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetachStaticIp API operation for Amazon Lightsail.
//
// Detaches a static IP from the Amazon Lightsail instance to which it is attached.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DetachStaticIp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DetachStaticIp
func (c *Lightsail) DetachStaticIp(input *DetachStaticIpInput) (*DetachStaticIpOutput, error) {
	req, out := c.DetachStaticIpRequest(input)
	return out, req.Send()
}

// DetachStaticIpWithContext is the same as DetachStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See DetachStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DetachStaticIpWithContext(ctx aws.Context, input *DetachStaticIpInput, opts ...request.Option) (*DetachStaticIpOutput, error) {
	req, out := c.DetachStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDownloadDefaultKeyPair = "DownloadDefaultKeyPair"

// DownloadDefaultKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the DownloadDefaultKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DownloadDefaultKeyPair for more information on using the DownloadDefaultKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DownloadDefaultKeyPairRequest method.
//    req, resp := client.DownloadDefaultKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair
func (c *Lightsail) DownloadDefaultKeyPairRequest(input *DownloadDefaultKeyPairInput) (req *request.Request, output *DownloadDefaultKeyPairOutput) {
	op := &request.Operation{
		Name:       opDownloadDefaultKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DownloadDefaultKeyPairInput{}
	}

	output = &DownloadDefaultKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DownloadDefaultKeyPair API operation for Amazon Lightsail.
//
// Downloads the default SSH key pair from the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation DownloadDefaultKeyPair for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DownloadDefaultKeyPair
func (c *Lightsail) DownloadDefaultKeyPair(input *DownloadDefaultKeyPairInput) (*DownloadDefaultKeyPairOutput, error) {
	req, out := c.DownloadDefaultKeyPairRequest(input)
	return out, req.Send()
}

// DownloadDefaultKeyPairWithContext is the same as DownloadDefaultKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See DownloadDefaultKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) DownloadDefaultKeyPairWithContext(ctx aws.Context, input *DownloadDefaultKeyPairInput, opts ...request.Option) (*DownloadDefaultKeyPairOutput, error) {
	req, out := c.DownloadDefaultKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetActiveNames = "GetActiveNames"

// GetActiveNamesRequest generates a "aws/request.Request" representing the
// client's request for the GetActiveNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetActiveNames for more information on using the GetActiveNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetActiveNamesRequest method.
//    req, resp := client.GetActiveNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames
func (c *Lightsail) GetActiveNamesRequest(input *GetActiveNamesInput) (req *request.Request, output *GetActiveNamesOutput) {
	op := &request.Operation{
		Name:       opGetActiveNames,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetActiveNamesInput{}
	}

	output = &GetActiveNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetActiveNames API operation for Amazon Lightsail.
//
// Returns the names of all active (not deleted) resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetActiveNames for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetActiveNames
func (c *Lightsail) GetActiveNames(input *GetActiveNamesInput) (*GetActiveNamesOutput, error) {
	req, out := c.GetActiveNamesRequest(input)
	return out, req.Send()
}

// GetActiveNamesWithContext is the same as GetActiveNames with the addition of
// the ability to pass a context and additional request options.
//
// See GetActiveNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetActiveNamesWithContext(ctx aws.Context, input *GetActiveNamesInput, opts ...request.Option) (*GetActiveNamesOutput, error) {
	req, out := c.GetActiveNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBlueprints = "GetBlueprints"

// GetBlueprintsRequest generates a "aws/request.Request" representing the
// client's request for the GetBlueprints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlueprints for more information on using the GetBlueprints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBlueprintsRequest method.
//    req, resp := client.GetBlueprintsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints
func (c *Lightsail) GetBlueprintsRequest(input *GetBlueprintsInput) (req *request.Request, output *GetBlueprintsOutput) {
	op := &request.Operation{
		Name:       opGetBlueprints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBlueprintsInput{}
	}

	output = &GetBlueprintsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlueprints API operation for Amazon Lightsail.
//
// Returns the list of available instance images, or blueprints. You can use
// a blueprint to create a new virtual private server already running a specific
// operating system, as well as a preinstalled app or development stack. The
// software each instance is running depends on the blueprint image you choose.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetBlueprints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBlueprints
func (c *Lightsail) GetBlueprints(input *GetBlueprintsInput) (*GetBlueprintsOutput, error) {
	req, out := c.GetBlueprintsRequest(input)
	return out, req.Send()
}

// GetBlueprintsWithContext is the same as GetBlueprints with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlueprints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetBlueprintsWithContext(ctx aws.Context, input *GetBlueprintsInput, opts ...request.Option) (*GetBlueprintsOutput, error) {
	req, out := c.GetBlueprintsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBundles = "GetBundles"

// GetBundlesRequest generates a "aws/request.Request" representing the
// client's request for the GetBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBundles for more information on using the GetBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBundlesRequest method.
//    req, resp := client.GetBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles
func (c *Lightsail) GetBundlesRequest(input *GetBundlesInput) (req *request.Request, output *GetBundlesOutput) {
	op := &request.Operation{
		Name:       opGetBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBundlesInput{}
	}

	output = &GetBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBundles API operation for Amazon Lightsail.
//
// Returns the list of bundles that are available for purchase. A bundle describes
// the specs for your virtual private server (or instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetBundles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetBundles
func (c *Lightsail) GetBundles(input *GetBundlesInput) (*GetBundlesOutput, error) {
	req, out := c.GetBundlesRequest(input)
	return out, req.Send()
}

// GetBundlesWithContext is the same as GetBundles with the addition of
// the ability to pass a context and additional request options.
//
// See GetBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetBundlesWithContext(ctx aws.Context, input *GetBundlesInput, opts ...request.Option) (*GetBundlesOutput, error) {
	req, out := c.GetBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDisk = "GetDisk"

// GetDiskRequest generates a "aws/request.Request" representing the
// client's request for the GetDisk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDisk for more information on using the GetDisk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiskRequest method.
//    req, resp := client.GetDiskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk
func (c *Lightsail) GetDiskRequest(input *GetDiskInput) (req *request.Request, output *GetDiskOutput) {
	op := &request.Operation{
		Name:       opGetDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiskInput{}
	}

	output = &GetDiskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDisk API operation for Amazon Lightsail.
//
// Returns information about a specific block storage disk.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDisk for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk
func (c *Lightsail) GetDisk(input *GetDiskInput) (*GetDiskOutput, error) {
	req, out := c.GetDiskRequest(input)
	return out, req.Send()
}

// GetDiskWithContext is the same as GetDisk with the addition of
// the ability to pass a context and additional request options.
//
// See GetDisk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDiskWithContext(ctx aws.Context, input *GetDiskInput, opts ...request.Option) (*GetDiskOutput, error) {
	req, out := c.GetDiskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDiskSnapshot = "GetDiskSnapshot"

// GetDiskSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the GetDiskSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDiskSnapshot for more information on using the GetDiskSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiskSnapshotRequest method.
//    req, resp := client.GetDiskSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot
func (c *Lightsail) GetDiskSnapshotRequest(input *GetDiskSnapshotInput) (req *request.Request, output *GetDiskSnapshotOutput) {
	op := &request.Operation{
		Name:       opGetDiskSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiskSnapshotInput{}
	}

	output = &GetDiskSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDiskSnapshot API operation for Amazon Lightsail.
//
// Returns information about a specific block storage disk snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDiskSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshot
func (c *Lightsail) GetDiskSnapshot(input *GetDiskSnapshotInput) (*GetDiskSnapshotOutput, error) {
	req, out := c.GetDiskSnapshotRequest(input)
	return out, req.Send()
}

// GetDiskSnapshotWithContext is the same as GetDiskSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See GetDiskSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDiskSnapshotWithContext(ctx aws.Context, input *GetDiskSnapshotInput, opts ...request.Option) (*GetDiskSnapshotOutput, error) {
	req, out := c.GetDiskSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDiskSnapshots = "GetDiskSnapshots"

// GetDiskSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the GetDiskSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDiskSnapshots for more information on using the GetDiskSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDiskSnapshotsRequest method.
//    req, resp := client.GetDiskSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots
func (c *Lightsail) GetDiskSnapshotsRequest(input *GetDiskSnapshotsInput) (req *request.Request, output *GetDiskSnapshotsOutput) {
	op := &request.Operation{
		Name:       opGetDiskSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiskSnapshotsInput{}
	}

	output = &GetDiskSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDiskSnapshots API operation for Amazon Lightsail.
//
// Returns information about all block storage disk snapshots in your AWS account
// and region.
//
// If you are describing a long list of disk snapshots, you can paginate the
// output to make the list more manageable. You can use the pageToken and nextPageToken
// values to retrieve the next items in the list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDiskSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskSnapshots
func (c *Lightsail) GetDiskSnapshots(input *GetDiskSnapshotsInput) (*GetDiskSnapshotsOutput, error) {
	req, out := c.GetDiskSnapshotsRequest(input)
	return out, req.Send()
}

// GetDiskSnapshotsWithContext is the same as GetDiskSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See GetDiskSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDiskSnapshotsWithContext(ctx aws.Context, input *GetDiskSnapshotsInput, opts ...request.Option) (*GetDiskSnapshotsOutput, error) {
	req, out := c.GetDiskSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDisks = "GetDisks"

// GetDisksRequest generates a "aws/request.Request" representing the
// client's request for the GetDisks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDisks for more information on using the GetDisks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDisksRequest method.
//    req, resp := client.GetDisksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks
func (c *Lightsail) GetDisksRequest(input *GetDisksInput) (req *request.Request, output *GetDisksOutput) {
	op := &request.Operation{
		Name:       opGetDisks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDisksInput{}
	}

	output = &GetDisksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDisks API operation for Amazon Lightsail.
//
// Returns information about all block storage disks in your AWS account and
// region.
//
// If you are describing a long list of disks, you can paginate the output to
// make the list more manageable. You can use the pageToken and nextPageToken
// values to retrieve the next items in the list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDisks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisks
func (c *Lightsail) GetDisks(input *GetDisksInput) (*GetDisksOutput, error) {
	req, out := c.GetDisksRequest(input)
	return out, req.Send()
}

// GetDisksWithContext is the same as GetDisks with the addition of
// the ability to pass a context and additional request options.
//
// See GetDisks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDisksWithContext(ctx aws.Context, input *GetDisksInput, opts ...request.Option) (*GetDisksOutput, error) {
	req, out := c.GetDisksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomain = "GetDomain"

// GetDomainRequest generates a "aws/request.Request" representing the
// client's request for the GetDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomain for more information on using the GetDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainRequest method.
//    req, resp := client.GetDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain
func (c *Lightsail) GetDomainRequest(input *GetDomainInput) (req *request.Request, output *GetDomainOutput) {
	op := &request.Operation{
		Name:       opGetDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainInput{}
	}

	output = &GetDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomain API operation for Amazon Lightsail.
//
// Returns information about a specific domain recordset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomain
func (c *Lightsail) GetDomain(input *GetDomainInput) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	return out, req.Send()
}

// GetDomainWithContext is the same as GetDomain with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDomainWithContext(ctx aws.Context, input *GetDomainInput, opts ...request.Option) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomains = "GetDomains"

// GetDomainsRequest generates a "aws/request.Request" representing the
// client's request for the GetDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomains for more information on using the GetDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainsRequest method.
//    req, resp := client.GetDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains
func (c *Lightsail) GetDomainsRequest(input *GetDomainsInput) (req *request.Request, output *GetDomainsOutput) {
	op := &request.Operation{
		Name:       opGetDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDomainsInput{}
	}

	output = &GetDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomains API operation for Amazon Lightsail.
//
// Returns a list of all domains in the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetDomains for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDomains
func (c *Lightsail) GetDomains(input *GetDomainsInput) (*GetDomainsOutput, error) {
	req, out := c.GetDomainsRequest(input)
	return out, req.Send()
}

// GetDomainsWithContext is the same as GetDomains with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetDomainsWithContext(ctx aws.Context, input *GetDomainsInput, opts ...request.Option) (*GetDomainsOutput, error) {
	req, out := c.GetDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstance = "GetInstance"

// GetInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstance for more information on using the GetInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceRequest method.
//    req, resp := client.GetInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance
func (c *Lightsail) GetInstanceRequest(input *GetInstanceInput) (req *request.Request, output *GetInstanceOutput) {
	op := &request.Operation{
		Name:       opGetInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceInput{}
	}

	output = &GetInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstance API operation for Amazon Lightsail.
//
// Returns information about a specific Amazon Lightsail instance, which is
// a virtual private server.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstance
func (c *Lightsail) GetInstance(input *GetInstanceInput) (*GetInstanceOutput, error) {
	req, out := c.GetInstanceRequest(input)
	return out, req.Send()
}

// GetInstanceWithContext is the same as GetInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceWithContext(ctx aws.Context, input *GetInstanceInput, opts ...request.Option) (*GetInstanceOutput, error) {
	req, out := c.GetInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceAccessDetails = "GetInstanceAccessDetails"

// GetInstanceAccessDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceAccessDetails operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceAccessDetails for more information on using the GetInstanceAccessDetails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceAccessDetailsRequest method.
//    req, resp := client.GetInstanceAccessDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails
func (c *Lightsail) GetInstanceAccessDetailsRequest(input *GetInstanceAccessDetailsInput) (req *request.Request, output *GetInstanceAccessDetailsOutput) {
	op := &request.Operation{
		Name:       opGetInstanceAccessDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceAccessDetailsInput{}
	}

	output = &GetInstanceAccessDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceAccessDetails API operation for Amazon Lightsail.
//
// Returns temporary SSH keys you can use to connect to a specific virtual private
// server, or instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceAccessDetails for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceAccessDetails
func (c *Lightsail) GetInstanceAccessDetails(input *GetInstanceAccessDetailsInput) (*GetInstanceAccessDetailsOutput, error) {
	req, out := c.GetInstanceAccessDetailsRequest(input)
	return out, req.Send()
}

// GetInstanceAccessDetailsWithContext is the same as GetInstanceAccessDetails with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceAccessDetails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceAccessDetailsWithContext(ctx aws.Context, input *GetInstanceAccessDetailsInput, opts ...request.Option) (*GetInstanceAccessDetailsOutput, error) {
	req, out := c.GetInstanceAccessDetailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceMetricData = "GetInstanceMetricData"

// GetInstanceMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceMetricData for more information on using the GetInstanceMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceMetricDataRequest method.
//    req, resp := client.GetInstanceMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData
func (c *Lightsail) GetInstanceMetricDataRequest(input *GetInstanceMetricDataInput) (req *request.Request, output *GetInstanceMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetInstanceMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceMetricDataInput{}
	}

	output = &GetInstanceMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceMetricData API operation for Amazon Lightsail.
//
// Returns the data points for the specified Amazon Lightsail instance metric,
// given an instance name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceMetricData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceMetricData
func (c *Lightsail) GetInstanceMetricData(input *GetInstanceMetricDataInput) (*GetInstanceMetricDataOutput, error) {
	req, out := c.GetInstanceMetricDataRequest(input)
	return out, req.Send()
}

// GetInstanceMetricDataWithContext is the same as GetInstanceMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceMetricDataWithContext(ctx aws.Context, input *GetInstanceMetricDataInput, opts ...request.Option) (*GetInstanceMetricDataOutput, error) {
	req, out := c.GetInstanceMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstancePortStates = "GetInstancePortStates"

// GetInstancePortStatesRequest generates a "aws/request.Request" representing the
// client's request for the GetInstancePortStates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstancePortStates for more information on using the GetInstancePortStates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstancePortStatesRequest method.
//    req, resp := client.GetInstancePortStatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates
func (c *Lightsail) GetInstancePortStatesRequest(input *GetInstancePortStatesInput) (req *request.Request, output *GetInstancePortStatesOutput) {
	op := &request.Operation{
		Name:       opGetInstancePortStates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstancePortStatesInput{}
	}

	output = &GetInstancePortStatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstancePortStates API operation for Amazon Lightsail.
//
// Returns the port states for a specific virtual private server, or instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstancePortStates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstancePortStates
func (c *Lightsail) GetInstancePortStates(input *GetInstancePortStatesInput) (*GetInstancePortStatesOutput, error) {
	req, out := c.GetInstancePortStatesRequest(input)
	return out, req.Send()
}

// GetInstancePortStatesWithContext is the same as GetInstancePortStates with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstancePortStates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstancePortStatesWithContext(ctx aws.Context, input *GetInstancePortStatesInput, opts ...request.Option) (*GetInstancePortStatesOutput, error) {
	req, out := c.GetInstancePortStatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceSnapshot = "GetInstanceSnapshot"

// GetInstanceSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceSnapshot for more information on using the GetInstanceSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceSnapshotRequest method.
//    req, resp := client.GetInstanceSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot
func (c *Lightsail) GetInstanceSnapshotRequest(input *GetInstanceSnapshotInput) (req *request.Request, output *GetInstanceSnapshotOutput) {
	op := &request.Operation{
		Name:       opGetInstanceSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceSnapshotInput{}
	}

	output = &GetInstanceSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceSnapshot API operation for Amazon Lightsail.
//
// Returns information about a specific instance snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshot
func (c *Lightsail) GetInstanceSnapshot(input *GetInstanceSnapshotInput) (*GetInstanceSnapshotOutput, error) {
	req, out := c.GetInstanceSnapshotRequest(input)
	return out, req.Send()
}

// GetInstanceSnapshotWithContext is the same as GetInstanceSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceSnapshotWithContext(ctx aws.Context, input *GetInstanceSnapshotInput, opts ...request.Option) (*GetInstanceSnapshotOutput, error) {
	req, out := c.GetInstanceSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceSnapshots = "GetInstanceSnapshots"

// GetInstanceSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceSnapshots for more information on using the GetInstanceSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceSnapshotsRequest method.
//    req, resp := client.GetInstanceSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots
func (c *Lightsail) GetInstanceSnapshotsRequest(input *GetInstanceSnapshotsInput) (req *request.Request, output *GetInstanceSnapshotsOutput) {
	op := &request.Operation{
		Name:       opGetInstanceSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceSnapshotsInput{}
	}

	output = &GetInstanceSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceSnapshots API operation for Amazon Lightsail.
//
// Returns all instance snapshots for the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceSnapshots
func (c *Lightsail) GetInstanceSnapshots(input *GetInstanceSnapshotsInput) (*GetInstanceSnapshotsOutput, error) {
	req, out := c.GetInstanceSnapshotsRequest(input)
	return out, req.Send()
}

// GetInstanceSnapshotsWithContext is the same as GetInstanceSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceSnapshotsWithContext(ctx aws.Context, input *GetInstanceSnapshotsInput, opts ...request.Option) (*GetInstanceSnapshotsOutput, error) {
	req, out := c.GetInstanceSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstanceState = "GetInstanceState"

// GetInstanceStateRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstanceState for more information on using the GetInstanceState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceStateRequest method.
//    req, resp := client.GetInstanceStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState
func (c *Lightsail) GetInstanceStateRequest(input *GetInstanceStateInput) (req *request.Request, output *GetInstanceStateOutput) {
	op := &request.Operation{
		Name:       opGetInstanceState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceStateInput{}
	}

	output = &GetInstanceStateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceState API operation for Amazon Lightsail.
//
// Returns the state of a specific instance. Works on one instance at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstanceState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstanceState
func (c *Lightsail) GetInstanceState(input *GetInstanceStateInput) (*GetInstanceStateOutput, error) {
	req, out := c.GetInstanceStateRequest(input)
	return out, req.Send()
}

// GetInstanceStateWithContext is the same as GetInstanceState with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstanceState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstanceStateWithContext(ctx aws.Context, input *GetInstanceStateInput, opts ...request.Option) (*GetInstanceStateOutput, error) {
	req, out := c.GetInstanceStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstances = "GetInstances"

// GetInstancesRequest generates a "aws/request.Request" representing the
// client's request for the GetInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstances for more information on using the GetInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstancesRequest method.
//    req, resp := client.GetInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances
func (c *Lightsail) GetInstancesRequest(input *GetInstancesInput) (req *request.Request, output *GetInstancesOutput) {
	op := &request.Operation{
		Name:       opGetInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstancesInput{}
	}

	output = &GetInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstances API operation for Amazon Lightsail.
//
// Returns information about all Amazon Lightsail virtual private servers, or
// instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetInstances
func (c *Lightsail) GetInstances(input *GetInstancesInput) (*GetInstancesOutput, error) {
	req, out := c.GetInstancesRequest(input)
	return out, req.Send()
}

// GetInstancesWithContext is the same as GetInstances with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetInstancesWithContext(ctx aws.Context, input *GetInstancesInput, opts ...request.Option) (*GetInstancesOutput, error) {
	req, out := c.GetInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyPair = "GetKeyPair"

// GetKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyPair for more information on using the GetKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetKeyPairRequest method.
//    req, resp := client.GetKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair
func (c *Lightsail) GetKeyPairRequest(input *GetKeyPairInput) (req *request.Request, output *GetKeyPairOutput) {
	op := &request.Operation{
		Name:       opGetKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPairInput{}
	}

	output = &GetKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyPair API operation for Amazon Lightsail.
//
// Returns information about a specific key pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetKeyPair for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPair
func (c *Lightsail) GetKeyPair(input *GetKeyPairInput) (*GetKeyPairOutput, error) {
	req, out := c.GetKeyPairRequest(input)
	return out, req.Send()
}

// GetKeyPairWithContext is the same as GetKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetKeyPairWithContext(ctx aws.Context, input *GetKeyPairInput, opts ...request.Option) (*GetKeyPairOutput, error) {
	req, out := c.GetKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKeyPairs = "GetKeyPairs"

// GetKeyPairsRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyPairs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKeyPairs for more information on using the GetKeyPairs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetKeyPairsRequest method.
//    req, resp := client.GetKeyPairsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs
func (c *Lightsail) GetKeyPairsRequest(input *GetKeyPairsInput) (req *request.Request, output *GetKeyPairsOutput) {
	op := &request.Operation{
		Name:       opGetKeyPairs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPairsInput{}
	}

	output = &GetKeyPairsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKeyPairs API operation for Amazon Lightsail.
//
// Returns information about all key pairs in the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetKeyPairs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetKeyPairs
func (c *Lightsail) GetKeyPairs(input *GetKeyPairsInput) (*GetKeyPairsOutput, error) {
	req, out := c.GetKeyPairsRequest(input)
	return out, req.Send()
}

// GetKeyPairsWithContext is the same as GetKeyPairs with the addition of
// the ability to pass a context and additional request options.
//
// See GetKeyPairs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetKeyPairsWithContext(ctx aws.Context, input *GetKeyPairsInput, opts ...request.Option) (*GetKeyPairsOutput, error) {
	req, out := c.GetKeyPairsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoadBalancer = "GetLoadBalancer"

// GetLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the GetLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoadBalancer for more information on using the GetLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoadBalancerRequest method.
//    req, resp := client.GetLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer
func (c *Lightsail) GetLoadBalancerRequest(input *GetLoadBalancerInput) (req *request.Request, output *GetLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opGetLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoadBalancerInput{}
	}

	output = &GetLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoadBalancer API operation for Amazon Lightsail.
//
// Returns information about the specified Lightsail load balancer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetLoadBalancer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancer
func (c *Lightsail) GetLoadBalancer(input *GetLoadBalancerInput) (*GetLoadBalancerOutput, error) {
	req, out := c.GetLoadBalancerRequest(input)
	return out, req.Send()
}

// GetLoadBalancerWithContext is the same as GetLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetLoadBalancerWithContext(ctx aws.Context, input *GetLoadBalancerInput, opts ...request.Option) (*GetLoadBalancerOutput, error) {
	req, out := c.GetLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoadBalancerMetricData = "GetLoadBalancerMetricData"

// GetLoadBalancerMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetLoadBalancerMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoadBalancerMetricData for more information on using the GetLoadBalancerMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoadBalancerMetricDataRequest method.
//    req, resp := client.GetLoadBalancerMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData
func (c *Lightsail) GetLoadBalancerMetricDataRequest(input *GetLoadBalancerMetricDataInput) (req *request.Request, output *GetLoadBalancerMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetLoadBalancerMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoadBalancerMetricDataInput{}
	}

	output = &GetLoadBalancerMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoadBalancerMetricData API operation for Amazon Lightsail.
//
// Returns information about health metrics for your Lightsail load balancer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetLoadBalancerMetricData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerMetricData
func (c *Lightsail) GetLoadBalancerMetricData(input *GetLoadBalancerMetricDataInput) (*GetLoadBalancerMetricDataOutput, error) {
	req, out := c.GetLoadBalancerMetricDataRequest(input)
	return out, req.Send()
}

// GetLoadBalancerMetricDataWithContext is the same as GetLoadBalancerMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoadBalancerMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetLoadBalancerMetricDataWithContext(ctx aws.Context, input *GetLoadBalancerMetricDataInput, opts ...request.Option) (*GetLoadBalancerMetricDataOutput, error) {
	req, out := c.GetLoadBalancerMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoadBalancerTlsCertificates = "GetLoadBalancerTlsCertificates"

// GetLoadBalancerTlsCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the GetLoadBalancerTlsCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoadBalancerTlsCertificates for more information on using the GetLoadBalancerTlsCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoadBalancerTlsCertificatesRequest method.
//    req, resp := client.GetLoadBalancerTlsCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates
func (c *Lightsail) GetLoadBalancerTlsCertificatesRequest(input *GetLoadBalancerTlsCertificatesInput) (req *request.Request, output *GetLoadBalancerTlsCertificatesOutput) {
	op := &request.Operation{
		Name:       opGetLoadBalancerTlsCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoadBalancerTlsCertificatesInput{}
	}

	output = &GetLoadBalancerTlsCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoadBalancerTlsCertificates API operation for Amazon Lightsail.
//
// Returns information about the TLS certificates that are associated with the
// specified Lightsail load balancer.
//
// TLS is just an updated, more secure version of Secure Socket Layer (SSL).
//
// You can have a maximum of 2 certificates associated with a Lightsail load
// balancer. One is active and the other is inactive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetLoadBalancerTlsCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancerTlsCertificates
func (c *Lightsail) GetLoadBalancerTlsCertificates(input *GetLoadBalancerTlsCertificatesInput) (*GetLoadBalancerTlsCertificatesOutput, error) {
	req, out := c.GetLoadBalancerTlsCertificatesRequest(input)
	return out, req.Send()
}

// GetLoadBalancerTlsCertificatesWithContext is the same as GetLoadBalancerTlsCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoadBalancerTlsCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetLoadBalancerTlsCertificatesWithContext(ctx aws.Context, input *GetLoadBalancerTlsCertificatesInput, opts ...request.Option) (*GetLoadBalancerTlsCertificatesOutput, error) {
	req, out := c.GetLoadBalancerTlsCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoadBalancers = "GetLoadBalancers"

// GetLoadBalancersRequest generates a "aws/request.Request" representing the
// client's request for the GetLoadBalancers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoadBalancers for more information on using the GetLoadBalancers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoadBalancersRequest method.
//    req, resp := client.GetLoadBalancersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers
func (c *Lightsail) GetLoadBalancersRequest(input *GetLoadBalancersInput) (req *request.Request, output *GetLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opGetLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoadBalancersInput{}
	}

	output = &GetLoadBalancersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoadBalancers API operation for Amazon Lightsail.
//
// Returns information about all load balancers in an account.
//
// If you are describing a long list of load balancers, you can paginate the
// output to make the list more manageable. You can use the pageToken and nextPageToken
// values to retrieve the next items in the list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetLoadBalancers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetLoadBalancers
func (c *Lightsail) GetLoadBalancers(input *GetLoadBalancersInput) (*GetLoadBalancersOutput, error) {
	req, out := c.GetLoadBalancersRequest(input)
	return out, req.Send()
}

// GetLoadBalancersWithContext is the same as GetLoadBalancers with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoadBalancers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetLoadBalancersWithContext(ctx aws.Context, input *GetLoadBalancersInput, opts ...request.Option) (*GetLoadBalancersOutput, error) {
	req, out := c.GetLoadBalancersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperation = "GetOperation"

// GetOperationRequest generates a "aws/request.Request" representing the
// client's request for the GetOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperation for more information on using the GetOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationRequest method.
//    req, resp := client.GetOperationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation
func (c *Lightsail) GetOperationRequest(input *GetOperationInput) (req *request.Request, output *GetOperationOutput) {
	op := &request.Operation{
		Name:       opGetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationInput{}
	}

	output = &GetOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperation API operation for Amazon Lightsail.
//
// Returns information about a specific operation. Operations include events
// such as when you create an instance, allocate a static IP, attach a static
// IP, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetOperation for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperation
func (c *Lightsail) GetOperation(input *GetOperationInput) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	return out, req.Send()
}

// GetOperationWithContext is the same as GetOperation with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetOperationWithContext(ctx aws.Context, input *GetOperationInput, opts ...request.Option) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperations = "GetOperations"

// GetOperationsRequest generates a "aws/request.Request" representing the
// client's request for the GetOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperations for more information on using the GetOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationsRequest method.
//    req, resp := client.GetOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations
func (c *Lightsail) GetOperationsRequest(input *GetOperationsInput) (req *request.Request, output *GetOperationsOutput) {
	op := &request.Operation{
		Name:       opGetOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationsInput{}
	}

	output = &GetOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperations API operation for Amazon Lightsail.
//
// Returns information about all operations.
//
// Results are returned from oldest to newest, up to a maximum of 200. Results
// can be paged by making each subsequent call to GetOperations use the maximum
// (last) statusChangedAt value from the previous request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetOperations for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperations
func (c *Lightsail) GetOperations(input *GetOperationsInput) (*GetOperationsOutput, error) {
	req, out := c.GetOperationsRequest(input)
	return out, req.Send()
}

// GetOperationsWithContext is the same as GetOperations with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetOperationsWithContext(ctx aws.Context, input *GetOperationsInput, opts ...request.Option) (*GetOperationsOutput, error) {
	req, out := c.GetOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperationsForResource = "GetOperationsForResource"

// GetOperationsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetOperationsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperationsForResource for more information on using the GetOperationsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationsForResourceRequest method.
//    req, resp := client.GetOperationsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource
func (c *Lightsail) GetOperationsForResourceRequest(input *GetOperationsForResourceInput) (req *request.Request, output *GetOperationsForResourceOutput) {
	op := &request.Operation{
		Name:       opGetOperationsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationsForResourceInput{}
	}

	output = &GetOperationsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperationsForResource API operation for Amazon Lightsail.
//
// Gets operations for a specific resource (e.g., an instance or a static IP).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetOperationsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetOperationsForResource
func (c *Lightsail) GetOperationsForResource(input *GetOperationsForResourceInput) (*GetOperationsForResourceOutput, error) {
	req, out := c.GetOperationsForResourceRequest(input)
	return out, req.Send()
}

// GetOperationsForResourceWithContext is the same as GetOperationsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperationsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetOperationsForResourceWithContext(ctx aws.Context, input *GetOperationsForResourceInput, opts ...request.Option) (*GetOperationsForResourceOutput, error) {
	req, out := c.GetOperationsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegions = "GetRegions"

// GetRegionsRequest generates a "aws/request.Request" representing the
// client's request for the GetRegions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegions for more information on using the GetRegions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegionsRequest method.
//    req, resp := client.GetRegionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions
func (c *Lightsail) GetRegionsRequest(input *GetRegionsInput) (req *request.Request, output *GetRegionsOutput) {
	op := &request.Operation{
		Name:       opGetRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRegionsInput{}
	}

	output = &GetRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegions API operation for Amazon Lightsail.
//
// Returns a list of all valid regions for Amazon Lightsail. Use the include
// availability zones parameter to also return the Availability Zones in a region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRegions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRegions
func (c *Lightsail) GetRegions(input *GetRegionsInput) (*GetRegionsOutput, error) {
	req, out := c.GetRegionsRequest(input)
	return out, req.Send()
}

// GetRegionsWithContext is the same as GetRegions with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRegionsWithContext(ctx aws.Context, input *GetRegionsInput, opts ...request.Option) (*GetRegionsOutput, error) {
	req, out := c.GetRegionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabase = "GetRelationalDatabase"

// GetRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabase for more information on using the GetRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseRequest method.
//    req, resp := client.GetRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabase
func (c *Lightsail) GetRelationalDatabaseRequest(input *GetRelationalDatabaseInput) (req *request.Request, output *GetRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseInput{}
	}

	output = &GetRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabase API operation for Amazon Lightsail.
//
// Returns information about a specific database in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabase
func (c *Lightsail) GetRelationalDatabase(input *GetRelationalDatabaseInput) (*GetRelationalDatabaseOutput, error) {
	req, out := c.GetRelationalDatabaseRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseWithContext is the same as GetRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseWithContext(ctx aws.Context, input *GetRelationalDatabaseInput, opts ...request.Option) (*GetRelationalDatabaseOutput, error) {
	req, out := c.GetRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseBlueprints = "GetRelationalDatabaseBlueprints"

// GetRelationalDatabaseBlueprintsRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseBlueprints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseBlueprints for more information on using the GetRelationalDatabaseBlueprints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseBlueprintsRequest method.
//    req, resp := client.GetRelationalDatabaseBlueprintsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBlueprints
func (c *Lightsail) GetRelationalDatabaseBlueprintsRequest(input *GetRelationalDatabaseBlueprintsInput) (req *request.Request, output *GetRelationalDatabaseBlueprintsOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseBlueprints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseBlueprintsInput{}
	}

	output = &GetRelationalDatabaseBlueprintsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseBlueprints API operation for Amazon Lightsail.
//
// Returns a list of available database blueprints in Amazon Lightsail. A blueprint
// describes the major engine version of a database.
//
// You can use a blueprint ID to create a new database that runs a specific
// database engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseBlueprints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBlueprints
func (c *Lightsail) GetRelationalDatabaseBlueprints(input *GetRelationalDatabaseBlueprintsInput) (*GetRelationalDatabaseBlueprintsOutput, error) {
	req, out := c.GetRelationalDatabaseBlueprintsRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseBlueprintsWithContext is the same as GetRelationalDatabaseBlueprints with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseBlueprints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseBlueprintsWithContext(ctx aws.Context, input *GetRelationalDatabaseBlueprintsInput, opts ...request.Option) (*GetRelationalDatabaseBlueprintsOutput, error) {
	req, out := c.GetRelationalDatabaseBlueprintsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseBundles = "GetRelationalDatabaseBundles"

// GetRelationalDatabaseBundlesRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseBundles for more information on using the GetRelationalDatabaseBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseBundlesRequest method.
//    req, resp := client.GetRelationalDatabaseBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBundles
func (c *Lightsail) GetRelationalDatabaseBundlesRequest(input *GetRelationalDatabaseBundlesInput) (req *request.Request, output *GetRelationalDatabaseBundlesOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseBundlesInput{}
	}

	output = &GetRelationalDatabaseBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseBundles API operation for Amazon Lightsail.
//
// Returns the list of bundles that are available in Amazon Lightsail. A bundle
// describes the performance specifications for a database.
//
// You can use a bundle ID to create a new database with explicit performance
// specifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseBundles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseBundles
func (c *Lightsail) GetRelationalDatabaseBundles(input *GetRelationalDatabaseBundlesInput) (*GetRelationalDatabaseBundlesOutput, error) {
	req, out := c.GetRelationalDatabaseBundlesRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseBundlesWithContext is the same as GetRelationalDatabaseBundles with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseBundlesWithContext(ctx aws.Context, input *GetRelationalDatabaseBundlesInput, opts ...request.Option) (*GetRelationalDatabaseBundlesOutput, error) {
	req, out := c.GetRelationalDatabaseBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseEvents = "GetRelationalDatabaseEvents"

// GetRelationalDatabaseEventsRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseEvents for more information on using the GetRelationalDatabaseEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseEventsRequest method.
//    req, resp := client.GetRelationalDatabaseEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseEvents
func (c *Lightsail) GetRelationalDatabaseEventsRequest(input *GetRelationalDatabaseEventsInput) (req *request.Request, output *GetRelationalDatabaseEventsOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseEventsInput{}
	}

	output = &GetRelationalDatabaseEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseEvents API operation for Amazon Lightsail.
//
// Returns a list of events for a specific database in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseEvents
func (c *Lightsail) GetRelationalDatabaseEvents(input *GetRelationalDatabaseEventsInput) (*GetRelationalDatabaseEventsOutput, error) {
	req, out := c.GetRelationalDatabaseEventsRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseEventsWithContext is the same as GetRelationalDatabaseEvents with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseEventsWithContext(ctx aws.Context, input *GetRelationalDatabaseEventsInput, opts ...request.Option) (*GetRelationalDatabaseEventsOutput, error) {
	req, out := c.GetRelationalDatabaseEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseLogEvents = "GetRelationalDatabaseLogEvents"

// GetRelationalDatabaseLogEventsRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseLogEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseLogEvents for more information on using the GetRelationalDatabaseLogEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseLogEventsRequest method.
//    req, resp := client.GetRelationalDatabaseLogEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogEvents
func (c *Lightsail) GetRelationalDatabaseLogEventsRequest(input *GetRelationalDatabaseLogEventsInput) (req *request.Request, output *GetRelationalDatabaseLogEventsOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseLogEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseLogEventsInput{}
	}

	output = &GetRelationalDatabaseLogEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseLogEvents API operation for Amazon Lightsail.
//
// Returns a list of log events for a database in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseLogEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogEvents
func (c *Lightsail) GetRelationalDatabaseLogEvents(input *GetRelationalDatabaseLogEventsInput) (*GetRelationalDatabaseLogEventsOutput, error) {
	req, out := c.GetRelationalDatabaseLogEventsRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseLogEventsWithContext is the same as GetRelationalDatabaseLogEvents with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseLogEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseLogEventsWithContext(ctx aws.Context, input *GetRelationalDatabaseLogEventsInput, opts ...request.Option) (*GetRelationalDatabaseLogEventsOutput, error) {
	req, out := c.GetRelationalDatabaseLogEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseLogStreams = "GetRelationalDatabaseLogStreams"

// GetRelationalDatabaseLogStreamsRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseLogStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseLogStreams for more information on using the GetRelationalDatabaseLogStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseLogStreamsRequest method.
//    req, resp := client.GetRelationalDatabaseLogStreamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreams
func (c *Lightsail) GetRelationalDatabaseLogStreamsRequest(input *GetRelationalDatabaseLogStreamsInput) (req *request.Request, output *GetRelationalDatabaseLogStreamsOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseLogStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseLogStreamsInput{}
	}

	output = &GetRelationalDatabaseLogStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseLogStreams API operation for Amazon Lightsail.
//
// Returns a list of available log streams for a specific database in Amazon
// Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseLogStreams for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseLogStreams
func (c *Lightsail) GetRelationalDatabaseLogStreams(input *GetRelationalDatabaseLogStreamsInput) (*GetRelationalDatabaseLogStreamsOutput, error) {
	req, out := c.GetRelationalDatabaseLogStreamsRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseLogStreamsWithContext is the same as GetRelationalDatabaseLogStreams with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseLogStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseLogStreamsWithContext(ctx aws.Context, input *GetRelationalDatabaseLogStreamsInput, opts ...request.Option) (*GetRelationalDatabaseLogStreamsOutput, error) {
	req, out := c.GetRelationalDatabaseLogStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseMasterUserPassword = "GetRelationalDatabaseMasterUserPassword"

// GetRelationalDatabaseMasterUserPasswordRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseMasterUserPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseMasterUserPassword for more information on using the GetRelationalDatabaseMasterUserPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseMasterUserPasswordRequest method.
//    req, resp := client.GetRelationalDatabaseMasterUserPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMasterUserPassword
func (c *Lightsail) GetRelationalDatabaseMasterUserPasswordRequest(input *GetRelationalDatabaseMasterUserPasswordInput) (req *request.Request, output *GetRelationalDatabaseMasterUserPasswordOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseMasterUserPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseMasterUserPasswordInput{}
	}

	output = &GetRelationalDatabaseMasterUserPasswordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseMasterUserPassword API operation for Amazon Lightsail.
//
// Returns the current, previous, or pending versions of the master user password
// for a Lightsail database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseMasterUserPassword for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMasterUserPassword
func (c *Lightsail) GetRelationalDatabaseMasterUserPassword(input *GetRelationalDatabaseMasterUserPasswordInput) (*GetRelationalDatabaseMasterUserPasswordOutput, error) {
	req, out := c.GetRelationalDatabaseMasterUserPasswordRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseMasterUserPasswordWithContext is the same as GetRelationalDatabaseMasterUserPassword with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseMasterUserPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseMasterUserPasswordWithContext(ctx aws.Context, input *GetRelationalDatabaseMasterUserPasswordInput, opts ...request.Option) (*GetRelationalDatabaseMasterUserPasswordOutput, error) {
	req, out := c.GetRelationalDatabaseMasterUserPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseMetricData = "GetRelationalDatabaseMetricData"

// GetRelationalDatabaseMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseMetricData for more information on using the GetRelationalDatabaseMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseMetricDataRequest method.
//    req, resp := client.GetRelationalDatabaseMetricDataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMetricData
func (c *Lightsail) GetRelationalDatabaseMetricDataRequest(input *GetRelationalDatabaseMetricDataInput) (req *request.Request, output *GetRelationalDatabaseMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseMetricDataInput{}
	}

	output = &GetRelationalDatabaseMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseMetricData API operation for Amazon Lightsail.
//
// Returns the data points of the specified metric for a database in Amazon
// Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseMetricData for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseMetricData
func (c *Lightsail) GetRelationalDatabaseMetricData(input *GetRelationalDatabaseMetricDataInput) (*GetRelationalDatabaseMetricDataOutput, error) {
	req, out := c.GetRelationalDatabaseMetricDataRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseMetricDataWithContext is the same as GetRelationalDatabaseMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseMetricDataWithContext(ctx aws.Context, input *GetRelationalDatabaseMetricDataInput, opts ...request.Option) (*GetRelationalDatabaseMetricDataOutput, error) {
	req, out := c.GetRelationalDatabaseMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseParameters = "GetRelationalDatabaseParameters"

// GetRelationalDatabaseParametersRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseParameters for more information on using the GetRelationalDatabaseParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseParametersRequest method.
//    req, resp := client.GetRelationalDatabaseParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseParameters
func (c *Lightsail) GetRelationalDatabaseParametersRequest(input *GetRelationalDatabaseParametersInput) (req *request.Request, output *GetRelationalDatabaseParametersOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseParametersInput{}
	}

	output = &GetRelationalDatabaseParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseParameters API operation for Amazon Lightsail.
//
// Returns all of the runtime parameters offered by the underlying database
// software, or engine, for a specific database in Amazon Lightsail.
//
// In addition to the parameter names and values, this operation returns other
// information about each parameter. This information includes whether changes
// require a reboot, whether the parameter is modifiable, the allowed values,
// and the data types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseParameters
func (c *Lightsail) GetRelationalDatabaseParameters(input *GetRelationalDatabaseParametersInput) (*GetRelationalDatabaseParametersOutput, error) {
	req, out := c.GetRelationalDatabaseParametersRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseParametersWithContext is the same as GetRelationalDatabaseParameters with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseParametersWithContext(ctx aws.Context, input *GetRelationalDatabaseParametersInput, opts ...request.Option) (*GetRelationalDatabaseParametersOutput, error) {
	req, out := c.GetRelationalDatabaseParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseSnapshot = "GetRelationalDatabaseSnapshot"

// GetRelationalDatabaseSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseSnapshot for more information on using the GetRelationalDatabaseSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseSnapshotRequest method.
//    req, resp := client.GetRelationalDatabaseSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshot
func (c *Lightsail) GetRelationalDatabaseSnapshotRequest(input *GetRelationalDatabaseSnapshotInput) (req *request.Request, output *GetRelationalDatabaseSnapshotOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseSnapshotInput{}
	}

	output = &GetRelationalDatabaseSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseSnapshot API operation for Amazon Lightsail.
//
// Returns information about a specific database snapshot in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseSnapshot for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshot
func (c *Lightsail) GetRelationalDatabaseSnapshot(input *GetRelationalDatabaseSnapshotInput) (*GetRelationalDatabaseSnapshotOutput, error) {
	req, out := c.GetRelationalDatabaseSnapshotRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseSnapshotWithContext is the same as GetRelationalDatabaseSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseSnapshotWithContext(ctx aws.Context, input *GetRelationalDatabaseSnapshotInput, opts ...request.Option) (*GetRelationalDatabaseSnapshotOutput, error) {
	req, out := c.GetRelationalDatabaseSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabaseSnapshots = "GetRelationalDatabaseSnapshots"

// GetRelationalDatabaseSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabaseSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabaseSnapshots for more information on using the GetRelationalDatabaseSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabaseSnapshotsRequest method.
//    req, resp := client.GetRelationalDatabaseSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshots
func (c *Lightsail) GetRelationalDatabaseSnapshotsRequest(input *GetRelationalDatabaseSnapshotsInput) (req *request.Request, output *GetRelationalDatabaseSnapshotsOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabaseSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabaseSnapshotsInput{}
	}

	output = &GetRelationalDatabaseSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabaseSnapshots API operation for Amazon Lightsail.
//
// Returns information about all of your database snapshots in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabaseSnapshots for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabaseSnapshots
func (c *Lightsail) GetRelationalDatabaseSnapshots(input *GetRelationalDatabaseSnapshotsInput) (*GetRelationalDatabaseSnapshotsOutput, error) {
	req, out := c.GetRelationalDatabaseSnapshotsRequest(input)
	return out, req.Send()
}

// GetRelationalDatabaseSnapshotsWithContext is the same as GetRelationalDatabaseSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabaseSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabaseSnapshotsWithContext(ctx aws.Context, input *GetRelationalDatabaseSnapshotsInput, opts ...request.Option) (*GetRelationalDatabaseSnapshotsOutput, error) {
	req, out := c.GetRelationalDatabaseSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRelationalDatabases = "GetRelationalDatabases"

// GetRelationalDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the GetRelationalDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRelationalDatabases for more information on using the GetRelationalDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRelationalDatabasesRequest method.
//    req, resp := client.GetRelationalDatabasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabases
func (c *Lightsail) GetRelationalDatabasesRequest(input *GetRelationalDatabasesInput) (req *request.Request, output *GetRelationalDatabasesOutput) {
	op := &request.Operation{
		Name:       opGetRelationalDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRelationalDatabasesInput{}
	}

	output = &GetRelationalDatabasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRelationalDatabases API operation for Amazon Lightsail.
//
// Returns information about all of your databases in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetRelationalDatabases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetRelationalDatabases
func (c *Lightsail) GetRelationalDatabases(input *GetRelationalDatabasesInput) (*GetRelationalDatabasesOutput, error) {
	req, out := c.GetRelationalDatabasesRequest(input)
	return out, req.Send()
}

// GetRelationalDatabasesWithContext is the same as GetRelationalDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See GetRelationalDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetRelationalDatabasesWithContext(ctx aws.Context, input *GetRelationalDatabasesInput, opts ...request.Option) (*GetRelationalDatabasesOutput, error) {
	req, out := c.GetRelationalDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStaticIp = "GetStaticIp"

// GetStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the GetStaticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStaticIp for more information on using the GetStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStaticIpRequest method.
//    req, resp := client.GetStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp
func (c *Lightsail) GetStaticIpRequest(input *GetStaticIpInput) (req *request.Request, output *GetStaticIpOutput) {
	op := &request.Operation{
		Name:       opGetStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStaticIpInput{}
	}

	output = &GetStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStaticIp API operation for Amazon Lightsail.
//
// Returns information about a specific static IP.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetStaticIp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIp
func (c *Lightsail) GetStaticIp(input *GetStaticIpInput) (*GetStaticIpOutput, error) {
	req, out := c.GetStaticIpRequest(input)
	return out, req.Send()
}

// GetStaticIpWithContext is the same as GetStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See GetStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetStaticIpWithContext(ctx aws.Context, input *GetStaticIpInput, opts ...request.Option) (*GetStaticIpOutput, error) {
	req, out := c.GetStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStaticIps = "GetStaticIps"

// GetStaticIpsRequest generates a "aws/request.Request" representing the
// client's request for the GetStaticIps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStaticIps for more information on using the GetStaticIps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStaticIpsRequest method.
//    req, resp := client.GetStaticIpsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps
func (c *Lightsail) GetStaticIpsRequest(input *GetStaticIpsInput) (req *request.Request, output *GetStaticIpsOutput) {
	op := &request.Operation{
		Name:       opGetStaticIps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStaticIpsInput{}
	}

	output = &GetStaticIpsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStaticIps API operation for Amazon Lightsail.
//
// Returns information about all static IPs in the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation GetStaticIps for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetStaticIps
func (c *Lightsail) GetStaticIps(input *GetStaticIpsInput) (*GetStaticIpsOutput, error) {
	req, out := c.GetStaticIpsRequest(input)
	return out, req.Send()
}

// GetStaticIpsWithContext is the same as GetStaticIps with the addition of
// the ability to pass a context and additional request options.
//
// See GetStaticIps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) GetStaticIpsWithContext(ctx aws.Context, input *GetStaticIpsInput, opts ...request.Option) (*GetStaticIpsOutput, error) {
	req, out := c.GetStaticIpsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportKeyPair = "ImportKeyPair"

// ImportKeyPairRequest generates a "aws/request.Request" representing the
// client's request for the ImportKeyPair operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportKeyPair for more information on using the ImportKeyPair
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportKeyPairRequest method.
//    req, resp := client.ImportKeyPairRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair
func (c *Lightsail) ImportKeyPairRequest(input *ImportKeyPairInput) (req *request.Request, output *ImportKeyPairOutput) {
	op := &request.Operation{
		Name:       opImportKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyPairInput{}
	}

	output = &ImportKeyPairOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportKeyPair API operation for Amazon Lightsail.
//
// Imports a public SSH key from a specific key pair.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation ImportKeyPair for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair
func (c *Lightsail) ImportKeyPair(input *ImportKeyPairInput) (*ImportKeyPairOutput, error) {
	req, out := c.ImportKeyPairRequest(input)
	return out, req.Send()
}

// ImportKeyPairWithContext is the same as ImportKeyPair with the addition of
// the ability to pass a context and additional request options.
//
// See ImportKeyPair for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) ImportKeyPairWithContext(ctx aws.Context, input *ImportKeyPairInput, opts ...request.Option) (*ImportKeyPairOutput, error) {
	req, out := c.ImportKeyPairRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIsVpcPeered = "IsVpcPeered"

// IsVpcPeeredRequest generates a "aws/request.Request" representing the
// client's request for the IsVpcPeered operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IsVpcPeered for more information on using the IsVpcPeered
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the IsVpcPeeredRequest method.
//    req, resp := client.IsVpcPeeredRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered
func (c *Lightsail) IsVpcPeeredRequest(input *IsVpcPeeredInput) (req *request.Request, output *IsVpcPeeredOutput) {
	op := &request.Operation{
		Name:       opIsVpcPeered,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IsVpcPeeredInput{}
	}

	output = &IsVpcPeeredOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IsVpcPeered API operation for Amazon Lightsail.
//
// Returns a Boolean value indicating whether your Lightsail VPC is peered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation IsVpcPeered for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered
func (c *Lightsail) IsVpcPeered(input *IsVpcPeeredInput) (*IsVpcPeeredOutput, error) {
	req, out := c.IsVpcPeeredRequest(input)
	return out, req.Send()
}

// IsVpcPeeredWithContext is the same as IsVpcPeered with the addition of
// the ability to pass a context and additional request options.
//
// See IsVpcPeered for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) IsVpcPeeredWithContext(ctx aws.Context, input *IsVpcPeeredInput, opts ...request.Option) (*IsVpcPeeredOutput, error) {
	req, out := c.IsVpcPeeredRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opOpenInstancePublicPorts = "OpenInstancePublicPorts"

// OpenInstancePublicPortsRequest generates a "aws/request.Request" representing the
// client's request for the OpenInstancePublicPorts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See OpenInstancePublicPorts for more information on using the OpenInstancePublicPorts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the OpenInstancePublicPortsRequest method.
//    req, resp := client.OpenInstancePublicPortsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts
func (c *Lightsail) OpenInstancePublicPortsRequest(input *OpenInstancePublicPortsInput) (req *request.Request, output *OpenInstancePublicPortsOutput) {
	op := &request.Operation{
		Name:       opOpenInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &OpenInstancePublicPortsInput{}
	}

	output = &OpenInstancePublicPortsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// OpenInstancePublicPorts API operation for Amazon Lightsail.
//
// Adds public ports to an Amazon Lightsail instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation OpenInstancePublicPorts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/OpenInstancePublicPorts
func (c *Lightsail) OpenInstancePublicPorts(input *OpenInstancePublicPortsInput) (*OpenInstancePublicPortsOutput, error) {
	req, out := c.OpenInstancePublicPortsRequest(input)
	return out, req.Send()
}

// OpenInstancePublicPortsWithContext is the same as OpenInstancePublicPorts with the addition of
// the ability to pass a context and additional request options.
//
// See OpenInstancePublicPorts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) OpenInstancePublicPortsWithContext(ctx aws.Context, input *OpenInstancePublicPortsInput, opts ...request.Option) (*OpenInstancePublicPortsOutput, error) {
	req, out := c.OpenInstancePublicPortsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPeerVpc = "PeerVpc"

// PeerVpcRequest generates a "aws/request.Request" representing the
// client's request for the PeerVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PeerVpc for more information on using the PeerVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PeerVpcRequest method.
//    req, resp := client.PeerVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc
func (c *Lightsail) PeerVpcRequest(input *PeerVpcInput) (req *request.Request, output *PeerVpcOutput) {
	op := &request.Operation{
		Name:       opPeerVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PeerVpcInput{}
	}

	output = &PeerVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PeerVpc API operation for Amazon Lightsail.
//
// Tries to peer the Lightsail VPC with the user's default VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation PeerVpc for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PeerVpc
func (c *Lightsail) PeerVpc(input *PeerVpcInput) (*PeerVpcOutput, error) {
	req, out := c.PeerVpcRequest(input)
	return out, req.Send()
}

// PeerVpcWithContext is the same as PeerVpc with the addition of
// the ability to pass a context and additional request options.
//
// See PeerVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) PeerVpcWithContext(ctx aws.Context, input *PeerVpcInput, opts ...request.Option) (*PeerVpcOutput, error) {
	req, out := c.PeerVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutInstancePublicPorts = "PutInstancePublicPorts"

// PutInstancePublicPortsRequest generates a "aws/request.Request" representing the
// client's request for the PutInstancePublicPorts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutInstancePublicPorts for more information on using the PutInstancePublicPorts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutInstancePublicPortsRequest method.
//    req, resp := client.PutInstancePublicPortsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts
func (c *Lightsail) PutInstancePublicPortsRequest(input *PutInstancePublicPortsInput) (req *request.Request, output *PutInstancePublicPortsOutput) {
	op := &request.Operation{
		Name:       opPutInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInstancePublicPortsInput{}
	}

	output = &PutInstancePublicPortsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutInstancePublicPorts API operation for Amazon Lightsail.
//
// Sets the specified open ports for an Amazon Lightsail instance, and closes
// all ports for every protocol not included in the current request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation PutInstancePublicPorts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts
func (c *Lightsail) PutInstancePublicPorts(input *PutInstancePublicPortsInput) (*PutInstancePublicPortsOutput, error) {
	req, out := c.PutInstancePublicPortsRequest(input)
	return out, req.Send()
}

// PutInstancePublicPortsWithContext is the same as PutInstancePublicPorts with the addition of
// the ability to pass a context and additional request options.
//
// See PutInstancePublicPorts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) PutInstancePublicPortsWithContext(ctx aws.Context, input *PutInstancePublicPortsInput, opts ...request.Option) (*PutInstancePublicPortsOutput, error) {
	req, out := c.PutInstancePublicPortsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootInstance = "RebootInstance"

// RebootInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RebootInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootInstance for more information on using the RebootInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootInstanceRequest method.
//    req, resp := client.RebootInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance
func (c *Lightsail) RebootInstanceRequest(input *RebootInstanceInput) (req *request.Request, output *RebootInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootInstanceInput{}
	}

	output = &RebootInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootInstance API operation for Amazon Lightsail.
//
// Restarts a specific instance. When your Amazon Lightsail instance is finished
// rebooting, Lightsail assigns a new public IP address. To use the same IP
// address after restarting, create a static IP address and attach it to the
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation RebootInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootInstance
func (c *Lightsail) RebootInstance(input *RebootInstanceInput) (*RebootInstanceOutput, error) {
	req, out := c.RebootInstanceRequest(input)
	return out, req.Send()
}

// RebootInstanceWithContext is the same as RebootInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RebootInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) RebootInstanceWithContext(ctx aws.Context, input *RebootInstanceInput, opts ...request.Option) (*RebootInstanceOutput, error) {
	req, out := c.RebootInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootRelationalDatabase = "RebootRelationalDatabase"

// RebootRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the RebootRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootRelationalDatabase for more information on using the RebootRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootRelationalDatabaseRequest method.
//    req, resp := client.RebootRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabase
func (c *Lightsail) RebootRelationalDatabaseRequest(input *RebootRelationalDatabaseInput) (req *request.Request, output *RebootRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opRebootRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootRelationalDatabaseInput{}
	}

	output = &RebootRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootRelationalDatabase API operation for Amazon Lightsail.
//
// Restarts a specific database in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation RebootRelationalDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/RebootRelationalDatabase
func (c *Lightsail) RebootRelationalDatabase(input *RebootRelationalDatabaseInput) (*RebootRelationalDatabaseOutput, error) {
	req, out := c.RebootRelationalDatabaseRequest(input)
	return out, req.Send()
}

// RebootRelationalDatabaseWithContext is the same as RebootRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See RebootRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) RebootRelationalDatabaseWithContext(ctx aws.Context, input *RebootRelationalDatabaseInput, opts ...request.Option) (*RebootRelationalDatabaseOutput, error) {
	req, out := c.RebootRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReleaseStaticIp = "ReleaseStaticIp"

// ReleaseStaticIpRequest generates a "aws/request.Request" representing the
// client's request for the ReleaseStaticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReleaseStaticIp for more information on using the ReleaseStaticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReleaseStaticIpRequest method.
//    req, resp := client.ReleaseStaticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp
func (c *Lightsail) ReleaseStaticIpRequest(input *ReleaseStaticIpInput) (req *request.Request, output *ReleaseStaticIpOutput) {
	op := &request.Operation{
		Name:       opReleaseStaticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReleaseStaticIpInput{}
	}

	output = &ReleaseStaticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReleaseStaticIp API operation for Amazon Lightsail.
//
// Deletes a specific static IP from your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation ReleaseStaticIp for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ReleaseStaticIp
func (c *Lightsail) ReleaseStaticIp(input *ReleaseStaticIpInput) (*ReleaseStaticIpOutput, error) {
	req, out := c.ReleaseStaticIpRequest(input)
	return out, req.Send()
}

// ReleaseStaticIpWithContext is the same as ReleaseStaticIp with the addition of
// the ability to pass a context and additional request options.
//
// See ReleaseStaticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) ReleaseStaticIpWithContext(ctx aws.Context, input *ReleaseStaticIpInput, opts ...request.Option) (*ReleaseStaticIpOutput, error) {
	req, out := c.ReleaseStaticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartInstance = "StartInstance"

// StartInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StartInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartInstance for more information on using the StartInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartInstanceRequest method.
//    req, resp := client.StartInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance
func (c *Lightsail) StartInstanceRequest(input *StartInstanceInput) (req *request.Request, output *StartInstanceOutput) {
	op := &request.Operation{
		Name:       opStartInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstanceInput{}
	}

	output = &StartInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartInstance API operation for Amazon Lightsail.
//
// Starts a specific Amazon Lightsail instance from a stopped state. To restart
// an instance, use the reboot instance operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation StartInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartInstance
func (c *Lightsail) StartInstance(input *StartInstanceInput) (*StartInstanceOutput, error) {
	req, out := c.StartInstanceRequest(input)
	return out, req.Send()
}

// StartInstanceWithContext is the same as StartInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StartInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) StartInstanceWithContext(ctx aws.Context, input *StartInstanceInput, opts ...request.Option) (*StartInstanceOutput, error) {
	req, out := c.StartInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRelationalDatabase = "StartRelationalDatabase"

// StartRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the StartRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRelationalDatabase for more information on using the StartRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartRelationalDatabaseRequest method.
//    req, resp := client.StartRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartRelationalDatabase
func (c *Lightsail) StartRelationalDatabaseRequest(input *StartRelationalDatabaseInput) (req *request.Request, output *StartRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opStartRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartRelationalDatabaseInput{}
	}

	output = &StartRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartRelationalDatabase API operation for Amazon Lightsail.
//
// Starts a specific database from a stopped state in Amazon Lightsail. To restart
// a database, use the reboot relational database operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation StartRelationalDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StartRelationalDatabase
func (c *Lightsail) StartRelationalDatabase(input *StartRelationalDatabaseInput) (*StartRelationalDatabaseOutput, error) {
	req, out := c.StartRelationalDatabaseRequest(input)
	return out, req.Send()
}

// StartRelationalDatabaseWithContext is the same as StartRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See StartRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) StartRelationalDatabaseWithContext(ctx aws.Context, input *StartRelationalDatabaseInput, opts ...request.Option) (*StartRelationalDatabaseOutput, error) {
	req, out := c.StartRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopInstance = "StopInstance"

// StopInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StopInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopInstance for more information on using the StopInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopInstanceRequest method.
//    req, resp := client.StopInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance
func (c *Lightsail) StopInstanceRequest(input *StopInstanceInput) (req *request.Request, output *StopInstanceOutput) {
	op := &request.Operation{
		Name:       opStopInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopInstanceInput{}
	}

	output = &StopInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopInstance API operation for Amazon Lightsail.
//
// Stops a specific Amazon Lightsail instance that is currently running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation StopInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopInstance
func (c *Lightsail) StopInstance(input *StopInstanceInput) (*StopInstanceOutput, error) {
	req, out := c.StopInstanceRequest(input)
	return out, req.Send()
}

// StopInstanceWithContext is the same as StopInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StopInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) StopInstanceWithContext(ctx aws.Context, input *StopInstanceInput, opts ...request.Option) (*StopInstanceOutput, error) {
	req, out := c.StopInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopRelationalDatabase = "StopRelationalDatabase"

// StopRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the StopRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopRelationalDatabase for more information on using the StopRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopRelationalDatabaseRequest method.
//    req, resp := client.StopRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopRelationalDatabase
func (c *Lightsail) StopRelationalDatabaseRequest(input *StopRelationalDatabaseInput) (req *request.Request, output *StopRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opStopRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopRelationalDatabaseInput{}
	}

	output = &StopRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopRelationalDatabase API operation for Amazon Lightsail.
//
// Stops a specific database that is currently running in Amazon Lightsail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation StopRelationalDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/StopRelationalDatabase
func (c *Lightsail) StopRelationalDatabase(input *StopRelationalDatabaseInput) (*StopRelationalDatabaseOutput, error) {
	req, out := c.StopRelationalDatabaseRequest(input)
	return out, req.Send()
}

// StopRelationalDatabaseWithContext is the same as StopRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See StopRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) StopRelationalDatabaseWithContext(ctx aws.Context, input *StopRelationalDatabaseInput, opts ...request.Option) (*StopRelationalDatabaseOutput, error) {
	req, out := c.StopRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnpeerVpc = "UnpeerVpc"

// UnpeerVpcRequest generates a "aws/request.Request" representing the
// client's request for the UnpeerVpc operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnpeerVpc for more information on using the UnpeerVpc
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnpeerVpcRequest method.
//    req, resp := client.UnpeerVpcRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc
func (c *Lightsail) UnpeerVpcRequest(input *UnpeerVpcInput) (req *request.Request, output *UnpeerVpcOutput) {
	op := &request.Operation{
		Name:       opUnpeerVpc,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnpeerVpcInput{}
	}

	output = &UnpeerVpcOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UnpeerVpc API operation for Amazon Lightsail.
//
// Attempts to unpeer the Lightsail VPC from the user's default VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UnpeerVpc for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UnpeerVpc
func (c *Lightsail) UnpeerVpc(input *UnpeerVpcInput) (*UnpeerVpcOutput, error) {
	req, out := c.UnpeerVpcRequest(input)
	return out, req.Send()
}

// UnpeerVpcWithContext is the same as UnpeerVpc with the addition of
// the ability to pass a context and additional request options.
//
// See UnpeerVpc for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UnpeerVpcWithContext(ctx aws.Context, input *UnpeerVpcInput, opts ...request.Option) (*UnpeerVpcOutput, error) {
	req, out := c.UnpeerVpcRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomainEntry = "UpdateDomainEntry"

// UpdateDomainEntryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomainEntry for more information on using the UpdateDomainEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainEntryRequest method.
//    req, resp := client.UpdateDomainEntryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry
func (c *Lightsail) UpdateDomainEntryRequest(input *UpdateDomainEntryInput) (req *request.Request, output *UpdateDomainEntryOutput) {
	op := &request.Operation{
		Name:       opUpdateDomainEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainEntryInput{}
	}

	output = &UpdateDomainEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomainEntry API operation for Amazon Lightsail.
//
// Updates a domain recordset after it is created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateDomainEntry for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateDomainEntry
func (c *Lightsail) UpdateDomainEntry(input *UpdateDomainEntryInput) (*UpdateDomainEntryOutput, error) {
	req, out := c.UpdateDomainEntryRequest(input)
	return out, req.Send()
}

// UpdateDomainEntryWithContext is the same as UpdateDomainEntry with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomainEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateDomainEntryWithContext(ctx aws.Context, input *UpdateDomainEntryInput, opts ...request.Option) (*UpdateDomainEntryOutput, error) {
	req, out := c.UpdateDomainEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLoadBalancerAttribute = "UpdateLoadBalancerAttribute"

// UpdateLoadBalancerAttributeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLoadBalancerAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLoadBalancerAttribute for more information on using the UpdateLoadBalancerAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLoadBalancerAttributeRequest method.
//    req, resp := client.UpdateLoadBalancerAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute
func (c *Lightsail) UpdateLoadBalancerAttributeRequest(input *UpdateLoadBalancerAttributeInput) (req *request.Request, output *UpdateLoadBalancerAttributeOutput) {
	op := &request.Operation{
		Name:       opUpdateLoadBalancerAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLoadBalancerAttributeInput{}
	}

	output = &UpdateLoadBalancerAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateLoadBalancerAttribute API operation for Amazon Lightsail.
//
// Updates the specified attribute for a load balancer. You can only update
// one attribute at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateLoadBalancerAttribute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateLoadBalancerAttribute
func (c *Lightsail) UpdateLoadBalancerAttribute(input *UpdateLoadBalancerAttributeInput) (*UpdateLoadBalancerAttributeOutput, error) {
	req, out := c.UpdateLoadBalancerAttributeRequest(input)
	return out, req.Send()
}

// UpdateLoadBalancerAttributeWithContext is the same as UpdateLoadBalancerAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLoadBalancerAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateLoadBalancerAttributeWithContext(ctx aws.Context, input *UpdateLoadBalancerAttributeInput, opts ...request.Option) (*UpdateLoadBalancerAttributeOutput, error) {
	req, out := c.UpdateLoadBalancerAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRelationalDatabase = "UpdateRelationalDatabase"

// UpdateRelationalDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRelationalDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRelationalDatabase for more information on using the UpdateRelationalDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRelationalDatabaseRequest method.
//    req, resp := client.UpdateRelationalDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabase
func (c *Lightsail) UpdateRelationalDatabaseRequest(input *UpdateRelationalDatabaseInput) (req *request.Request, output *UpdateRelationalDatabaseOutput) {
	op := &request.Operation{
		Name:       opUpdateRelationalDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRelationalDatabaseInput{}
	}

	output = &UpdateRelationalDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRelationalDatabase API operation for Amazon Lightsail.
//
// Allows the update of one or more attributes of a database in Amazon Lightsail.
//
// Updates are applied immediately, or in cases where the updates could result
// in an outage, are applied during the database's predefined maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateRelationalDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabase
func (c *Lightsail) UpdateRelationalDatabase(input *UpdateRelationalDatabaseInput) (*UpdateRelationalDatabaseOutput, error) {
	req, out := c.UpdateRelationalDatabaseRequest(input)
	return out, req.Send()
}

// UpdateRelationalDatabaseWithContext is the same as UpdateRelationalDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRelationalDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateRelationalDatabaseWithContext(ctx aws.Context, input *UpdateRelationalDatabaseInput, opts ...request.Option) (*UpdateRelationalDatabaseOutput, error) {
	req, out := c.UpdateRelationalDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRelationalDatabaseParameters = "UpdateRelationalDatabaseParameters"

// UpdateRelationalDatabaseParametersRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRelationalDatabaseParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRelationalDatabaseParameters for more information on using the UpdateRelationalDatabaseParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRelationalDatabaseParametersRequest method.
//    req, resp := client.UpdateRelationalDatabaseParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabaseParameters
func (c *Lightsail) UpdateRelationalDatabaseParametersRequest(input *UpdateRelationalDatabaseParametersInput) (req *request.Request, output *UpdateRelationalDatabaseParametersOutput) {
	op := &request.Operation{
		Name:       opUpdateRelationalDatabaseParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRelationalDatabaseParametersInput{}
	}

	output = &UpdateRelationalDatabaseParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRelationalDatabaseParameters API operation for Amazon Lightsail.
//
// Allows the update of one or more parameters of a database in Amazon Lightsail.
//
// Parameter updates don't cause outages; therefore, their application is not
// subject to the preferred maintenance window. However, there are two ways
// in which paramater updates are applied: dynamic or pending-reboot. Parameters
// marked with a dynamic apply type are applied immediately. Parameters marked
// with a pending-reboot apply type are applied only after the database is rebooted
// using the reboot relational database operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Lightsail's
// API operation UpdateRelationalDatabaseParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   A general service exception.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   Lightsail throws this exception when user input does not conform to the validation
//   rules of an input field.
//
//   Domain-related APIs are only available in the N. Virginia (us-east-1) Region.
//   Please set your AWS Region configuration to us-east-1 to create, view, or
//   edit these resources.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   Lightsail throws this exception when it cannot find a resource.
//
//   * ErrCodeOperationFailureException "OperationFailureException"
//   Lightsail throws this exception when an operation fails to execute.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Lightsail throws this exception when the user cannot be authenticated or
//   uses invalid credentials to access a resource.
//
//   * ErrCodeAccountSetupInProgressException "AccountSetupInProgressException"
//   Lightsail throws this exception when an account is still in the setup in
//   progress state.
//
//   * ErrCodeUnauthenticatedException "UnauthenticatedException"
//   Lightsail throws this exception when the user has not been authenticated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/UpdateRelationalDatabaseParameters
func (c *Lightsail) UpdateRelationalDatabaseParameters(input *UpdateRelationalDatabaseParametersInput) (*UpdateRelationalDatabaseParametersOutput, error) {
	req, out := c.UpdateRelationalDatabaseParametersRequest(input)
	return out, req.Send()
}

// UpdateRelationalDatabaseParametersWithContext is the same as UpdateRelationalDatabaseParameters with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRelationalDatabaseParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Lightsail) UpdateRelationalDatabaseParametersWithContext(ctx aws.Context, input *UpdateRelationalDatabaseParametersInput, opts ...request.Option) (*UpdateRelationalDatabaseParametersOutput, error) {
	req, out := c.UpdateRelationalDatabaseParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AllocateStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP address.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s AllocateStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateStaticIpInput"}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *AllocateStaticIpInput) SetStaticIpName(v string) *AllocateStaticIpInput {
	s.StaticIpName = &v
	return s
}

type AllocateStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the static IP address
	// you allocated.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AllocateStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AllocateStaticIpOutput) SetOperations(v []*Operation) *AllocateStaticIpOutput {
	s.Operations = v
	return s
}

type AttachDiskInput struct {
	_ struct{} `type:"structure"`

	// The unique Lightsail disk name (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`

	// The disk path to expose to the instance (e.g., /dev/xvdf).
	//
	// DiskPath is a required field
	DiskPath *string `locationName:"diskPath" type:"string" required:"true"`

	// The name of the Lightsail instance where you want to utilize the storage
	// disk.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachDiskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachDiskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachDiskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachDiskInput"}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}
	if s.DiskPath == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskPath"))
	}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskName sets the DiskName field's value.
func (s *AttachDiskInput) SetDiskName(v string) *AttachDiskInput {
	s.DiskName = &v
	return s
}

// SetDiskPath sets the DiskPath field's value.
func (s *AttachDiskInput) SetDiskPath(v string) *AttachDiskInput {
	s.DiskPath = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *AttachDiskInput) SetInstanceName(v string) *AttachDiskInput {
	s.InstanceName = &v
	return s
}

type AttachDiskOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachDiskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachDiskOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AttachDiskOutput) SetOperations(v []*Operation) *AttachDiskOutput {
	s.Operations = v
	return s
}

type AttachInstancesToLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// An array of strings representing the instance name(s) you want to attach
	// to your load balancer.
	//
	// An instance must be running before you can attach it to your load balancer.
	//
	// There are no additional limits on the number of instances you can attach
	// to your load balancer, aside from the limit of Lightsail instances you can
	// create in your account (20).
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachInstancesToLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInstancesToLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachInstancesToLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachInstancesToLoadBalancerInput"}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *AttachInstancesToLoadBalancerInput) SetInstanceNames(v []*string) *AttachInstancesToLoadBalancerInput {
	s.InstanceNames = v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *AttachInstancesToLoadBalancerInput) SetLoadBalancerName(v string) *AttachInstancesToLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

type AttachInstancesToLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An object representing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachInstancesToLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInstancesToLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AttachInstancesToLoadBalancerOutput) SetOperations(v []*Operation) *AttachInstancesToLoadBalancerOutput {
	s.Operations = v
	return s
}

type AttachLoadBalancerTlsCertificateInput struct {
	_ struct{} `type:"structure"`

	// The name of your SSL/TLS certificate.
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// The name of the load balancer to which you want to associate the SSL/TLS
	// certificate.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachLoadBalancerTlsCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancerTlsCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachLoadBalancerTlsCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachLoadBalancerTlsCertificateInput"}
	if s.CertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateName"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateName sets the CertificateName field's value.
func (s *AttachLoadBalancerTlsCertificateInput) SetCertificateName(v string) *AttachLoadBalancerTlsCertificateInput {
	s.CertificateName = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *AttachLoadBalancerTlsCertificateInput) SetLoadBalancerName(v string) *AttachLoadBalancerTlsCertificateInput {
	s.LoadBalancerName = &v
	return s
}

type AttachLoadBalancerTlsCertificateOutput struct {
	_ struct{} `type:"structure"`

	// An object representing the API operations.
	//
	// These SSL/TLS certificates are only usable by Lightsail load balancers. You
	// can't get the certificate and use it for another purpose.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachLoadBalancerTlsCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancerTlsCertificateOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AttachLoadBalancerTlsCertificateOutput) SetOperations(v []*Operation) *AttachLoadBalancerTlsCertificateOutput {
	s.Operations = v
	return s
}

type AttachStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The instance name to which you want to attach the static IP address.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The name of the static IP.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachStaticIpInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *AttachStaticIpInput) SetInstanceName(v string) *AttachStaticIpInput {
	s.InstanceName = &v
	return s
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *AttachStaticIpInput) SetStaticIpName(v string) *AttachStaticIpInput {
	s.StaticIpName = &v
	return s
}

type AttachStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *AttachStaticIpOutput) SetOperations(v []*Operation) *AttachStaticIpOutput {
	s.Operations = v
	return s
}

// Describes an Availability Zone.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The state of the Availability Zone.
	State *string `locationName:"state" type:"string"`

	// The name of the Availability Zone. The format is us-east-2a (case-sensitive).
	ZoneName *string `locationName:"zoneName" type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *AvailabilityZone) SetState(v string) *AvailabilityZone {
	s.State = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *AvailabilityZone) SetZoneName(v string) *AvailabilityZone {
	s.ZoneName = &v
	return s
}

// Describes a blueprint (a virtual private server image).
type Blueprint struct {
	_ struct{} `type:"structure"`

	// The ID for the virtual private server image (e.g., app_wordpress_4_4 or app_lamp_7_0).
	BlueprintId *string `locationName:"blueprintId" type:"string"`

	// The description of the blueprint.
	Description *string `locationName:"description" type:"string"`

	// The group name of the blueprint (e.g., amazon-linux).
	Group *string `locationName:"group" type:"string"`

	// A Boolean value indicating whether the blueprint is active. Inactive blueprints
	// are listed to support customers with existing instances but are not necessarily
	// available for launch of new instances. Blueprints are marked inactive when
	// they become outdated due to operating system updates or new application releases.
	IsActive *bool `locationName:"isActive" type:"boolean"`

	// The end-user license agreement URL for the image or blueprint.
	LicenseUrl *string `locationName:"licenseUrl" type:"string"`

	// The minimum bundle power required to run this blueprint. For example, you
	// need a bundle with a power value of 500 or more to create an instance that
	// uses a blueprint with a minimum power value of 500. 0 indicates that the
	// blueprint runs on all instance sizes.
	MinPower *int64 `locationName:"minPower" type:"integer"`

	// The friendly name of the blueprint (e.g., Amazon Linux).
	Name *string `locationName:"name" type:"string"`

	// The operating system platform (either Linux/Unix-based or Windows Server-based)
	// of the blueprint.
	Platform *string `locationName:"platform" type:"string" enum:"InstancePlatform"`

	// The product URL to learn more about the image or blueprint.
	ProductUrl *string `locationName:"productUrl" type:"string"`

	// The type of the blueprint (e.g., os or app).
	Type *string `locationName:"type" type:"string" enum:"BlueprintType"`

	// The version number of the operating system, application, or stack (e.g.,
	// 2016.03.0).
	Version *string `locationName:"version" type:"string"`

	// The version code.
	VersionCode *string `locationName:"versionCode" type:"string"`
}

// String returns the string representation
func (s Blueprint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Blueprint) GoString() string {
	return s.String()
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *Blueprint) SetBlueprintId(v string) *Blueprint {
	s.BlueprintId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Blueprint) SetDescription(v string) *Blueprint {
	s.Description = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *Blueprint) SetGroup(v string) *Blueprint {
	s.Group = &v
	return s
}

// SetIsActive sets the IsActive field's value.
func (s *Blueprint) SetIsActive(v bool) *Blueprint {
	s.IsActive = &v
	return s
}

// SetLicenseUrl sets the LicenseUrl field's value.
func (s *Blueprint) SetLicenseUrl(v string) *Blueprint {
	s.LicenseUrl = &v
	return s
}

// SetMinPower sets the MinPower field's value.
func (s *Blueprint) SetMinPower(v int64) *Blueprint {
	s.MinPower = &v
	return s
}

// SetName sets the Name field's value.
func (s *Blueprint) SetName(v string) *Blueprint {
	s.Name = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Blueprint) SetPlatform(v string) *Blueprint {
	s.Platform = &v
	return s
}

// SetProductUrl sets the ProductUrl field's value.
func (s *Blueprint) SetProductUrl(v string) *Blueprint {
	s.ProductUrl = &v
	return s
}

// SetType sets the Type field's value.
func (s *Blueprint) SetType(v string) *Blueprint {
	s.Type = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *Blueprint) SetVersion(v string) *Blueprint {
	s.Version = &v
	return s
}

// SetVersionCode sets the VersionCode field's value.
func (s *Blueprint) SetVersionCode(v string) *Blueprint {
	s.VersionCode = &v
	return s
}

// Describes a bundle, which is a set of specs describing your virtual private
// server (or instance).
type Bundle struct {
	_ struct{} `type:"structure"`

	// The bundle ID (e.g., micro_1_0).
	BundleId *string `locationName:"bundleId" type:"string"`

	// The number of vCPUs included in the bundle (e.g., 2).
	CpuCount *int64 `locationName:"cpuCount" type:"integer"`

	// The size of the SSD (e.g., 30).
	DiskSizeInGb *int64 `locationName:"diskSizeInGb" type:"integer"`

	// The Amazon EC2 instance type (e.g., t2.micro).
	InstanceType *string `locationName:"instanceType" type:"string"`

	// A Boolean value indicating whether the bundle is active.
	IsActive *bool `locationName:"isActive" type:"boolean"`

	// A friendly name for the bundle (e.g., Micro).
	Name *string `locationName:"name" type:"string"`

	// A numeric value that represents the power of the bundle (e.g., 500). You
	// can use the bundle's power value in conjunction with a blueprint's minimum
	// power value to determine whether the blueprint will run on the bundle. For
	// example, you need a bundle with a power value of 500 or more to create an
	// instance that uses a blueprint with a minimum power value of 500.
	Power *int64 `locationName:"power" type:"integer"`

	// The price in US dollars (e.g., 5.0).
	Price *float64 `locationName:"price" type:"float"`

	// The amount of RAM in GB (e.g., 2.0).
	RamSizeInGb *float64 `locationName:"ramSizeInGb" type:"float"`

	// The operating system platform (Linux/Unix-based or Windows Server-based)
	// that the bundle supports. You can only launch a WINDOWS bundle on a blueprint
	// that supports the WINDOWS platform. LINUX_UNIX blueprints require a LINUX_UNIX
	// bundle.
	SupportedPlatforms []*string `locationName:"supportedPlatforms" type:"list"`

	// The data transfer rate per month in GB (e.g., 2000).
	TransferPerMonthInGb *int64 `locationName:"transferPerMonthInGb" type:"integer"`
}

// String returns the string representation
func (s Bundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Bundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *Bundle) SetBundleId(v string) *Bundle {
	s.BundleId = &v
	return s
}

// SetCpuCount sets the CpuCount field's value.
func (s *Bundle) SetCpuCount(v int64) *Bundle {
	s.CpuCount = &v
	return s
}

// SetDiskSizeInGb sets the DiskSizeInGb field's value.
func (s *Bundle) SetDiskSizeInGb(v int64) *Bundle {
	s.DiskSizeInGb = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Bundle) SetInstanceType(v string) *Bundle {
	s.InstanceType = &v
	return s
}

// SetIsActive sets the IsActive field's value.
func (s *Bundle) SetIsActive(v bool) *Bundle {
	s.IsActive = &v
	return s
}

// SetName sets the Name field's value.
func (s *Bundle) SetName(v string) *Bundle {
	s.Name = &v
	return s
}

// SetPower sets the Power field's value.
func (s *Bundle) SetPower(v int64) *Bundle {
	s.Power = &v
	return s
}

// SetPrice sets the Price field's value.
func (s *Bundle) SetPrice(v float64) *Bundle {
	s.Price = &v
	return s
}

// SetRamSizeInGb sets the RamSizeInGb field's value.
func (s *Bundle) SetRamSizeInGb(v float64) *Bundle {
	s.RamSizeInGb = &v
	return s
}

// SetSupportedPlatforms sets the SupportedPlatforms field's value.
func (s *Bundle) SetSupportedPlatforms(v []*string) *Bundle {
	s.SupportedPlatforms = v
	return s
}

// SetTransferPerMonthInGb sets the TransferPerMonthInGb field's value.
func (s *Bundle) SetTransferPerMonthInGb(v int64) *Bundle {
	s.TransferPerMonthInGb = &v
	return s
}

type CloseInstancePublicPortsInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance on which you're attempting to close the public ports.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// Information about the public port you are trying to close.
	//
	// PortInfo is a required field
	PortInfo *PortInfo `locationName:"portInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s CloseInstancePublicPortsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloseInstancePublicPortsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloseInstancePublicPortsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloseInstancePublicPortsInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.PortInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("PortInfo"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *CloseInstancePublicPortsInput) SetInstanceName(v string) *CloseInstancePublicPortsInput {
	s.InstanceName = &v
	return s
}

// SetPortInfo sets the PortInfo field's value.
func (s *CloseInstancePublicPortsInput) SetPortInfo(v *PortInfo) *CloseInstancePublicPortsInput {
	s.PortInfo = v
	return s
}

type CloseInstancePublicPortsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs that contains information about the operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s CloseInstancePublicPortsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloseInstancePublicPortsOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *CloseInstancePublicPortsOutput) SetOperation(v *Operation) *CloseInstancePublicPortsOutput {
	s.Operation = v
	return s
}

type CreateDiskFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where you want to create the disk (e.g., us-east-2a).
	// Choose the same Availability Zone as the Lightsail instance where you want
	// to create the disk.
	//
	// Use the GetRegions operation to list the Availability Zones where Lightsail
	// is currently available.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The unique Lightsail disk name (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`

	// The name of the disk snapshot (e.g., my-snapshot) from which to create the
	// new storage disk.
	//
	// DiskSnapshotName is a required field
	DiskSnapshotName *string `locationName:"diskSnapshotName" type:"string" required:"true"`

	// The size of the disk in GB (e.g., 32).
	//
	// SizeInGb is a required field
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateDiskFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDiskFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDiskFromSnapshotInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}
	if s.DiskSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskSnapshotName"))
	}
	if s.SizeInGb == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeInGb"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDiskFromSnapshotInput) SetAvailabilityZone(v string) *CreateDiskFromSnapshotInput {
	s.AvailabilityZone = &v
	return s
}

// SetDiskName sets the DiskName field's value.
func (s *CreateDiskFromSnapshotInput) SetDiskName(v string) *CreateDiskFromSnapshotInput {
	s.DiskName = &v
	return s
}

// SetDiskSnapshotName sets the DiskSnapshotName field's value.
func (s *CreateDiskFromSnapshotInput) SetDiskSnapshotName(v string) *CreateDiskFromSnapshotInput {
	s.DiskSnapshotName = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *CreateDiskFromSnapshotInput) SetSizeInGb(v int64) *CreateDiskFromSnapshotInput {
	s.SizeInGb = &v
	return s
}

type CreateDiskFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateDiskFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateDiskFromSnapshotOutput) SetOperations(v []*Operation) *CreateDiskFromSnapshotOutput {
	s.Operations = v
	return s
}

type CreateDiskInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where you want to create the disk (e.g., us-east-2a).
	// Choose the same Availability Zone as the Lightsail instance where you want
	// to create the disk.
	//
	// Use the GetRegions operation to list the Availability Zones where Lightsail
	// is currently available.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The unique Lightsail disk name (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`

	// The size of the disk in GB (e.g., 32).
	//
	// SizeInGb is a required field
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer" required:"true"`
}

// String returns the string representation
func (s CreateDiskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDiskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDiskInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}
	if s.SizeInGb == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeInGb"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDiskInput) SetAvailabilityZone(v string) *CreateDiskInput {
	s.AvailabilityZone = &v
	return s
}

// SetDiskName sets the DiskName field's value.
func (s *CreateDiskInput) SetDiskName(v string) *CreateDiskInput {
	s.DiskName = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *CreateDiskInput) SetSizeInGb(v int64) *CreateDiskInput {
	s.SizeInGb = &v
	return s
}

type CreateDiskOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateDiskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateDiskOutput) SetOperations(v []*Operation) *CreateDiskOutput {
	s.Operations = v
	return s
}

type CreateDiskSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the source disk (e.g., my-source-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`

	// The name of the destination disk snapshot (e.g., my-disk-snapshot) based
	// on the source disk.
	//
	// DiskSnapshotName is a required field
	DiskSnapshotName *string `locationName:"diskSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDiskSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDiskSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDiskSnapshotInput"}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}
	if s.DiskSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskName sets the DiskName field's value.
func (s *CreateDiskSnapshotInput) SetDiskName(v string) *CreateDiskSnapshotInput {
	s.DiskName = &v
	return s
}

// SetDiskSnapshotName sets the DiskSnapshotName field's value.
func (s *CreateDiskSnapshotInput) SetDiskSnapshotName(v string) *CreateDiskSnapshotInput {
	s.DiskSnapshotName = &v
	return s
}

type CreateDiskSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateDiskSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDiskSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateDiskSnapshotOutput) SetOperations(v []*Operation) *CreateDiskSnapshotOutput {
	s.Operations = v
	return s
}

type CreateDomainEntryInput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the domain entry
	// request.
	//
	// DomainEntry is a required field
	DomainEntry *DomainEntry `locationName:"domainEntry" type:"structure" required:"true"`

	// The domain name (e.g., example.com) for which you want to create the domain
	// entry.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainEntryInput"}
	if s.DomainEntry == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainEntry"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainEntry sets the DomainEntry field's value.
func (s *CreateDomainEntryInput) SetDomainEntry(v *DomainEntry) *CreateDomainEntryInput {
	s.DomainEntry = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainEntryInput) SetDomainName(v string) *CreateDomainEntryInput {
	s.DomainName = &v
	return s
}

type CreateDomainEntryOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s CreateDomainEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainEntryOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *CreateDomainEntryOutput) SetOperation(v *Operation) *CreateDomainEntryOutput {
	s.Operation = v
	return s
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain name to manage (e.g., example.com).
	//
	// You cannot register a new domain name using Lightsail. You must register
	// a domain name using Amazon Route 53 or another domain name registrar. If
	// you have already registered your domain, you can enter its name in this parameter
	// to manage the DNS records for that domain.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainInput) SetDomainName(v string) *CreateDomainInput {
	s.DomainName = &v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the domain resource
	// you created.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *CreateDomainOutput) SetOperation(v *Operation) *CreateDomainOutput {
	s.Operation = v
	return s
}

type CreateInstanceSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The Lightsail instance on which to base your snapshot.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The name for your new snapshot.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInstanceSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceSnapshotInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.InstanceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *CreateInstanceSnapshotInput) SetInstanceName(v string) *CreateInstanceSnapshotInput {
	s.InstanceName = &v
	return s
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *CreateInstanceSnapshotInput) SetInstanceSnapshotName(v string) *CreateInstanceSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

type CreateInstanceSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// create instances snapshot request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstanceSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateInstanceSnapshotOutput) SetOperations(v []*Operation) *CreateInstanceSnapshotOutput {
	s.Operations = v
	return s
}

type CreateInstancesFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// An object containing information about one or more disk mappings.
	AttachedDiskMapping map[string][]*DiskMap `locationName:"attachedDiskMapping" type:"map"`

	// The Availability Zone where you want to create your instances. Use the following
	// formatting: us-east-2a (case sensitive). You can get a list of Availability
	// Zones by using the get regions (http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
	// operation. Be sure to add the include Availability Zones parameter to your
	// request.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The bundle of specification information for your virtual private server (or
	// instance), including the pricing plan (e.g., micro_1_0).
	//
	// BundleId is a required field
	BundleId *string `locationName:"bundleId" type:"string" required:"true"`

	// The names for your new instances.
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of the instance snapshot on which you are basing your new instances.
	// Use the get instance snapshots operation to return information about your
	// existing snapshots.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`

	// The name for your key pair.
	KeyPairName *string `locationName:"keyPairName" type:"string"`

	// You can create a launch script that configures a server with additional user
	// data. For example, apt-get -y update.
	//
	// Depending on the machine image you choose, the command to get software on
	// your instance varies. Amazon Linux and CentOS use yum, Debian and Ubuntu
	// use apt-get, and FreeBSD uses pkg. For a complete list, see the Dev Guide
	// (https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image).
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s CreateInstancesFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstancesFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstancesFromSnapshotInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.InstanceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachedDiskMapping sets the AttachedDiskMapping field's value.
func (s *CreateInstancesFromSnapshotInput) SetAttachedDiskMapping(v map[string][]*DiskMap) *CreateInstancesFromSnapshotInput {
	s.AttachedDiskMapping = v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateInstancesFromSnapshotInput) SetAvailabilityZone(v string) *CreateInstancesFromSnapshotInput {
	s.AvailabilityZone = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *CreateInstancesFromSnapshotInput) SetBundleId(v string) *CreateInstancesFromSnapshotInput {
	s.BundleId = &v
	return s
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *CreateInstancesFromSnapshotInput) SetInstanceNames(v []*string) *CreateInstancesFromSnapshotInput {
	s.InstanceNames = v
	return s
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *CreateInstancesFromSnapshotInput) SetInstanceSnapshotName(v string) *CreateInstancesFromSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateInstancesFromSnapshotInput) SetKeyPairName(v string) *CreateInstancesFromSnapshotInput {
	s.KeyPairName = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *CreateInstancesFromSnapshotInput) SetUserData(v string) *CreateInstancesFromSnapshotInput {
	s.UserData = &v
	return s
}

type CreateInstancesFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// create instances from snapshot request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstancesFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateInstancesFromSnapshotOutput) SetOperations(v []*Operation) *CreateInstancesFromSnapshotOutput {
	s.Operations = v
	return s
}

type CreateInstancesInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to create your instance. Use the following
	// format: us-east-2a (case sensitive). You can get a list of Availability Zones
	// by using the get regions (http://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
	// operation. Be sure to add the include Availability Zones parameter to your
	// request.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `locationName:"availabilityZone" type:"string" required:"true"`

	// The ID for a virtual private server image (e.g., app_wordpress_4_4 or app_lamp_7_0).
	// Use the get blueprints operation to return a list of available images (or
	// blueprints).
	//
	// BlueprintId is a required field
	BlueprintId *string `locationName:"blueprintId" type:"string" required:"true"`

	// The bundle of specification information for your virtual private server (or
	// instance), including the pricing plan (e.g., micro_1_0).
	//
	// BundleId is a required field
	BundleId *string `locationName:"bundleId" type:"string" required:"true"`

	// (Deprecated) The name for your custom image.
	//
	// In releases prior to June 12, 2017, this parameter was ignored by the API.
	// It is now deprecated.
	//
	// Deprecated: CustomImageName has been deprecated
	CustomImageName *string `locationName:"customImageName" deprecated:"true" type:"string"`

	// The names to use for your new Lightsail instances. Separate multiple values
	// using quotation marks and commas, for example: ["MyFirstInstance","MySecondInstance"]
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of your key pair.
	KeyPairName *string `locationName:"keyPairName" type:"string"`

	// A launch script you can create that configures a server with additional user
	// data. For example, you might want to run apt-get -y update.
	//
	// Depending on the machine image you choose, the command to get software on
	// your instance varies. Amazon Linux and CentOS use yum, Debian and Ubuntu
	// use apt-get, and FreeBSD uses pkg. For a complete list, see the Dev Guide
	// (https://lightsail.aws.amazon.com/ls/docs/getting-started/article/compare-options-choose-lightsail-instance-image).
	UserData *string `locationName:"userData" type:"string"`
}

// String returns the string representation
func (s CreateInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstancesInput"}
	if s.AvailabilityZone == nil {
		invalidParams.Add(request.NewErrParamRequired("AvailabilityZone"))
	}
	if s.BlueprintId == nil {
		invalidParams.Add(request.NewErrParamRequired("BlueprintId"))
	}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateInstancesInput) SetAvailabilityZone(v string) *CreateInstancesInput {
	s.AvailabilityZone = &v
	return s
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *CreateInstancesInput) SetBlueprintId(v string) *CreateInstancesInput {
	s.BlueprintId = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *CreateInstancesInput) SetBundleId(v string) *CreateInstancesInput {
	s.BundleId = &v
	return s
}

// SetCustomImageName sets the CustomImageName field's value.
func (s *CreateInstancesInput) SetCustomImageName(v string) *CreateInstancesInput {
	s.CustomImageName = &v
	return s
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *CreateInstancesInput) SetInstanceNames(v []*string) *CreateInstancesInput {
	s.InstanceNames = v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateInstancesInput) SetKeyPairName(v string) *CreateInstancesInput {
	s.KeyPairName = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *CreateInstancesInput) SetUserData(v string) *CreateInstancesInput {
	s.UserData = &v
	return s
}

type CreateInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// create instances request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstancesOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateInstancesOutput) SetOperations(v []*Operation) *CreateInstancesOutput {
	s.Operations = v
	return s
}

type CreateKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name for your new key pair.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *CreateKeyPairInput) SetKeyPairName(v string) *CreateKeyPairInput {
	s.KeyPairName = &v
	return s
}

type CreateKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the new key pair
	// you just created.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// create key pair request.
	Operation *Operation `locationName:"operation" type:"structure"`

	// A base64-encoded RSA private key.
	PrivateKeyBase64 *string `locationName:"privateKeyBase64" type:"string"`

	// A base64-encoded public key of the ssh-rsa type.
	PublicKeyBase64 *string `locationName:"publicKeyBase64" type:"string"`
}

// String returns the string representation
func (s CreateKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyPair sets the KeyPair field's value.
func (s *CreateKeyPairOutput) SetKeyPair(v *KeyPair) *CreateKeyPairOutput {
	s.KeyPair = v
	return s
}

// SetOperation sets the Operation field's value.
func (s *CreateKeyPairOutput) SetOperation(v *Operation) *CreateKeyPairOutput {
	s.Operation = v
	return s
}

// SetPrivateKeyBase64 sets the PrivateKeyBase64 field's value.
func (s *CreateKeyPairOutput) SetPrivateKeyBase64(v string) *CreateKeyPairOutput {
	s.PrivateKeyBase64 = &v
	return s
}

// SetPublicKeyBase64 sets the PublicKeyBase64 field's value.
func (s *CreateKeyPairOutput) SetPublicKeyBase64(v string) *CreateKeyPairOutput {
	s.PublicKeyBase64 = &v
	return s
}

type CreateLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The optional alternative domains and subdomains to use with your SSL/TLS
	// certificate (e.g., www.example.com, example.com, m.example.com, blog.example.com).
	CertificateAlternativeNames []*string `locationName:"certificateAlternativeNames" type:"list"`

	// The domain name with which your certificate is associated (e.g., example.com).
	//
	// If you specify certificateDomainName, then certificateName is required (and
	// vice-versa).
	CertificateDomainName *string `locationName:"certificateDomainName" type:"string"`

	// The name of the SSL/TLS certificate.
	//
	// If you specify certificateName, then certificateDomainName is required (and
	// vice-versa).
	CertificateName *string `locationName:"certificateName" type:"string"`

	// The path you provided to perform the load balancer health check. If you didn't
	// specify a health check path, Lightsail uses the root path of your website
	// (e.g., "/").
	//
	// You may want to specify a custom health check path other than the root of
	// your application if your home page loads slowly or has a lot of media or
	// scripting on it.
	HealthCheckPath *string `locationName:"healthCheckPath" type:"string"`

	// The instance port where you're creating your load balancer.
	//
	// InstancePort is a required field
	InstancePort *int64 `locationName:"instancePort" type:"integer" required:"true"`

	// The name of your load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoadBalancerInput"}
	if s.InstancePort == nil {
		invalidParams.Add(request.NewErrParamRequired("InstancePort"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAlternativeNames sets the CertificateAlternativeNames field's value.
func (s *CreateLoadBalancerInput) SetCertificateAlternativeNames(v []*string) *CreateLoadBalancerInput {
	s.CertificateAlternativeNames = v
	return s
}

// SetCertificateDomainName sets the CertificateDomainName field's value.
func (s *CreateLoadBalancerInput) SetCertificateDomainName(v string) *CreateLoadBalancerInput {
	s.CertificateDomainName = &v
	return s
}

// SetCertificateName sets the CertificateName field's value.
func (s *CreateLoadBalancerInput) SetCertificateName(v string) *CreateLoadBalancerInput {
	s.CertificateName = &v
	return s
}

// SetHealthCheckPath sets the HealthCheckPath field's value.
func (s *CreateLoadBalancerInput) SetHealthCheckPath(v string) *CreateLoadBalancerInput {
	s.HealthCheckPath = &v
	return s
}

// SetInstancePort sets the InstancePort field's value.
func (s *CreateLoadBalancerInput) SetInstancePort(v int64) *CreateLoadBalancerInput {
	s.InstancePort = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *CreateLoadBalancerInput) SetLoadBalancerName(v string) *CreateLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

type CreateLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateLoadBalancerOutput) SetOperations(v []*Operation) *CreateLoadBalancerOutput {
	s.Operations = v
	return s
}

type CreateLoadBalancerTlsCertificateInput struct {
	_ struct{} `type:"structure"`

	// An array of strings listing alternative domains and subdomains for your SSL/TLS
	// certificate. Lightsail will de-dupe the names for you. You can have a maximum
	// of 9 alternative names (in addition to the 1 primary domain). We do not support
	// wildcards (e.g., *.example.com).
	CertificateAlternativeNames []*string `locationName:"certificateAlternativeNames" type:"list"`

	// The domain name (e.g., example.com) for your SSL/TLS certificate.
	//
	// CertificateDomainName is a required field
	CertificateDomainName *string `locationName:"certificateDomainName" type:"string" required:"true"`

	// The SSL/TLS certificate name.
	//
	// You can have up to 10 certificates in your account at one time. Each Lightsail
	// load balancer can have up to 2 certificates associated with it at one time.
	// There is also an overall limit to the number of certificates that can be
	// issue in a 365-day period. For more information, see Limits (http://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// The load balancer name where you want to create the SSL/TLS certificate.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLoadBalancerTlsCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerTlsCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoadBalancerTlsCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoadBalancerTlsCertificateInput"}
	if s.CertificateDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateDomainName"))
	}
	if s.CertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateName"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateAlternativeNames sets the CertificateAlternativeNames field's value.
func (s *CreateLoadBalancerTlsCertificateInput) SetCertificateAlternativeNames(v []*string) *CreateLoadBalancerTlsCertificateInput {
	s.CertificateAlternativeNames = v
	return s
}

// SetCertificateDomainName sets the CertificateDomainName field's value.
func (s *CreateLoadBalancerTlsCertificateInput) SetCertificateDomainName(v string) *CreateLoadBalancerTlsCertificateInput {
	s.CertificateDomainName = &v
	return s
}

// SetCertificateName sets the CertificateName field's value.
func (s *CreateLoadBalancerTlsCertificateInput) SetCertificateName(v string) *CreateLoadBalancerTlsCertificateInput {
	s.CertificateName = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *CreateLoadBalancerTlsCertificateInput) SetLoadBalancerName(v string) *CreateLoadBalancerTlsCertificateInput {
	s.LoadBalancerName = &v
	return s
}

type CreateLoadBalancerTlsCertificateOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateLoadBalancerTlsCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoadBalancerTlsCertificateOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateLoadBalancerTlsCertificateOutput) SetOperations(v []*Operation) *CreateLoadBalancerTlsCertificateOutput {
	s.Operations = v
	return s
}

type CreateRelationalDatabaseFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to create your new database. Use the us-east-2a
	// case-sensitive format.
	//
	// You can get a list of Availability Zones by using the get regions operation.
	// Be sure to add the include relational database Availability Zones parameter
	// to your request.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// Specifies the accessibility options for your new database. A value of true
	// specifies a database that is available to resources outside of your Lightsail
	// account. A value of false specifies a database that is available only to
	// your Lightsail resources in the same region as your database.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The bundle ID for your new database. A bundle describes the performance specifications
	// for your database.
	//
	// You can get a list of database bundle IDs by using the get relational database
	// bundles operation.
	//
	// When creating a new database from a snapshot, you cannot choose a bundle
	// that is smaller than the bundle of the source database.
	RelationalDatabaseBundleId *string `locationName:"relationalDatabaseBundleId" type:"string"`

	// The name to use for your new database.
	//
	// Constraints:
	//
	//    * Must contain from 2 to 255 alphanumeric characters, or hyphens.
	//
	//    * The first and last character must be a letter or number.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// The name of the database snapshot from which to create your new database.
	RelationalDatabaseSnapshotName *string `locationName:"relationalDatabaseSnapshotName" type:"string"`

	// The date and time to restore your database from.
	//
	// Constraints:
	//
	//    * Must be before the latest restorable time for the database.
	//
	//    * Cannot be specified if the use latest restorable time parameter is true.
	//
	//    * Specified in Universal Coordinated Time (UTC).
	//
	//    * Specified in the Unix time format.
	//
	// For example, if you wish to use a restore time of October 1, 2018, at 8 PM
	//    UTC, then you input 1538424000 as the restore time.
	RestoreTime *time.Time `locationName:"restoreTime" type:"timestamp"`

	// The name of the source database.
	SourceRelationalDatabaseName *string `locationName:"sourceRelationalDatabaseName" type:"string"`

	// Specifies whether your database is restored from the latest backup time.
	// A value of true restores from the latest backup time.
	//
	// Default: false
	//
	// Constraints: Cannot be specified if the restore time parameter is provided.
	UseLatestRestorableTime *bool `locationName:"useLatestRestorableTime" type:"boolean"`
}

// String returns the string representation
func (s CreateRelationalDatabaseFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRelationalDatabaseFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRelationalDatabaseFromSnapshotInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetAvailabilityZone(v string) *CreateRelationalDatabaseFromSnapshotInput {
	s.AvailabilityZone = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetPubliclyAccessible(v bool) *CreateRelationalDatabaseFromSnapshotInput {
	s.PubliclyAccessible = &v
	return s
}

// SetRelationalDatabaseBundleId sets the RelationalDatabaseBundleId field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetRelationalDatabaseBundleId(v string) *CreateRelationalDatabaseFromSnapshotInput {
	s.RelationalDatabaseBundleId = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetRelationalDatabaseName(v string) *CreateRelationalDatabaseFromSnapshotInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetRelationalDatabaseSnapshotName sets the RelationalDatabaseSnapshotName field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetRelationalDatabaseSnapshotName(v string) *CreateRelationalDatabaseFromSnapshotInput {
	s.RelationalDatabaseSnapshotName = &v
	return s
}

// SetRestoreTime sets the RestoreTime field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetRestoreTime(v time.Time) *CreateRelationalDatabaseFromSnapshotInput {
	s.RestoreTime = &v
	return s
}

// SetSourceRelationalDatabaseName sets the SourceRelationalDatabaseName field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetSourceRelationalDatabaseName(v string) *CreateRelationalDatabaseFromSnapshotInput {
	s.SourceRelationalDatabaseName = &v
	return s
}

// SetUseLatestRestorableTime sets the UseLatestRestorableTime field's value.
func (s *CreateRelationalDatabaseFromSnapshotInput) SetUseLatestRestorableTime(v bool) *CreateRelationalDatabaseFromSnapshotInput {
	s.UseLatestRestorableTime = &v
	return s
}

type CreateRelationalDatabaseFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your create relational database from snapshot
	// request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateRelationalDatabaseFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateRelationalDatabaseFromSnapshotOutput) SetOperations(v []*Operation) *CreateRelationalDatabaseFromSnapshotOutput {
	s.Operations = v
	return s
}

type CreateRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which to create your new database. Use the us-east-2a
	// case-sensitive format.
	//
	// You can get a list of Availability Zones by using the get regions operation.
	// Be sure to add the include relational database Availability Zones parameter
	// to your request.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The name of the master database created when the Lightsail database resource
	// is created.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 64 alphanumeric characters.
	//
	//    * Cannot be a word reserved by the specified database engine
	//
	// MasterDatabaseName is a required field
	MasterDatabaseName *string `locationName:"masterDatabaseName" type:"string" required:"true"`

	// The password for the master user of your new database. The password can include
	// any printable ASCII character except "/", """, or "@".
	//
	// Constraints: Must contain 8 to 41 characters.
	MasterUserPassword *string `locationName:"masterUserPassword" type:"string"`

	// The master user name for your new database.
	//
	// Constraints:
	//
	//    * Master user name is required.
	//
	//    * Must contain from 1 to 16 alphanumeric characters.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot be a reserved word for the database engine you choose.
	//
	// For more information about reserved words in MySQL 5.6 or 5.7, see the Keywords
	//    and Reserved Words articles for MySQL 5.6 (https://dev.mysql.com/doc/refman/5.6/en/keywords.html)
	//    or MySQL 5.7 (https://dev.mysql.com/doc/refman/5.7/en/keywords.html) respectively.
	//
	// MasterUsername is a required field
	MasterUsername *string `locationName:"masterUsername" type:"string" required:"true"`

	// The daily time range during which automated backups are created for your
	// new database if automated backups are enabled.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region. For more information about the preferred backup
	// window time blocks for each region, see the Working With Backups (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
	// guide in the Amazon Relational Database Service (Amazon RDS) documentation.
	//
	// Constraints:
	//
	//    * Must be in the hh24:mi-hh24:mi format.
	//
	// Example: 16:00-16:30
	//
	//    * Specified in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `locationName:"preferredBackupWindow" type:"string"`

	// The weekly time range during which system maintenance can occur on your new
	// database.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week.
	//
	// Constraints:
	//
	//    * Must be in the ddd:hh24:mi-ddd:hh24:mi format.
	//
	//    * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
	//
	//    * Must be at least 30 minutes.
	//
	//    * Specified in Universal Coordinated Time (UTC).
	//
	//    * Example: Tue:17:00-Tue:17:30
	PreferredMaintenanceWindow *string `locationName:"preferredMaintenanceWindow" type:"string"`

	// Specifies the accessibility options for your new database. A value of true
	// specifies a database that is available to resources outside of your Lightsail
	// account. A value of false specifies a database that is available only to
	// your Lightsail resources in the same region as your database.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The blueprint ID for your new database. A blueprint describes the major engine
	// version of a database.
	//
	// You can get a list of database blueprints IDs by using the get relational
	// database blueprints operation.
	//
	// RelationalDatabaseBlueprintId is a required field
	RelationalDatabaseBlueprintId *string `locationName:"relationalDatabaseBlueprintId" type:"string" required:"true"`

	// The bundle ID for your new database. A bundle describes the performance specifications
	// for your database.
	//
	// You can get a list of database bundle IDs by using the get relational database
	// bundles operation.
	//
	// RelationalDatabaseBundleId is a required field
	RelationalDatabaseBundleId *string `locationName:"relationalDatabaseBundleId" type:"string" required:"true"`

	// The name to use for your new database.
	//
	// Constraints:
	//
	//    * Must contain from 2 to 255 alphanumeric characters, or hyphens.
	//
	//    * The first and last character must be a letter or number.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRelationalDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRelationalDatabaseInput"}
	if s.MasterDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterDatabaseName"))
	}
	if s.MasterUsername == nil {
		invalidParams.Add(request.NewErrParamRequired("MasterUsername"))
	}
	if s.RelationalDatabaseBlueprintId == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseBlueprintId"))
	}
	if s.RelationalDatabaseBundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseBundleId"))
	}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateRelationalDatabaseInput) SetAvailabilityZone(v string) *CreateRelationalDatabaseInput {
	s.AvailabilityZone = &v
	return s
}

// SetMasterDatabaseName sets the MasterDatabaseName field's value.
func (s *CreateRelationalDatabaseInput) SetMasterDatabaseName(v string) *CreateRelationalDatabaseInput {
	s.MasterDatabaseName = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *CreateRelationalDatabaseInput) SetMasterUserPassword(v string) *CreateRelationalDatabaseInput {
	s.MasterUserPassword = &v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *CreateRelationalDatabaseInput) SetMasterUsername(v string) *CreateRelationalDatabaseInput {
	s.MasterUsername = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *CreateRelationalDatabaseInput) SetPreferredBackupWindow(v string) *CreateRelationalDatabaseInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateRelationalDatabaseInput) SetPreferredMaintenanceWindow(v string) *CreateRelationalDatabaseInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateRelationalDatabaseInput) SetPubliclyAccessible(v bool) *CreateRelationalDatabaseInput {
	s.PubliclyAccessible = &v
	return s
}

// SetRelationalDatabaseBlueprintId sets the RelationalDatabaseBlueprintId field's value.
func (s *CreateRelationalDatabaseInput) SetRelationalDatabaseBlueprintId(v string) *CreateRelationalDatabaseInput {
	s.RelationalDatabaseBlueprintId = &v
	return s
}

// SetRelationalDatabaseBundleId sets the RelationalDatabaseBundleId field's value.
func (s *CreateRelationalDatabaseInput) SetRelationalDatabaseBundleId(v string) *CreateRelationalDatabaseInput {
	s.RelationalDatabaseBundleId = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *CreateRelationalDatabaseInput) SetRelationalDatabaseName(v string) *CreateRelationalDatabaseInput {
	s.RelationalDatabaseName = &v
	return s
}

type CreateRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your create relational database request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateRelationalDatabaseOutput) SetOperations(v []*Operation) *CreateRelationalDatabaseOutput {
	s.Operations = v
	return s
}

type CreateRelationalDatabaseSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the database on which to base your new snapshot.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// The name for your new database snapshot.
	//
	// Constraints:
	//
	//    * Must contain from 2 to 255 alphanumeric characters, or hyphens.
	//
	//    * The first and last character must be a letter or number.
	//
	// RelationalDatabaseSnapshotName is a required field
	RelationalDatabaseSnapshotName *string `locationName:"relationalDatabaseSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRelationalDatabaseSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRelationalDatabaseSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRelationalDatabaseSnapshotInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}
	if s.RelationalDatabaseSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *CreateRelationalDatabaseSnapshotInput) SetRelationalDatabaseName(v string) *CreateRelationalDatabaseSnapshotInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetRelationalDatabaseSnapshotName sets the RelationalDatabaseSnapshotName field's value.
func (s *CreateRelationalDatabaseSnapshotInput) SetRelationalDatabaseSnapshotName(v string) *CreateRelationalDatabaseSnapshotInput {
	s.RelationalDatabaseSnapshotName = &v
	return s
}

type CreateRelationalDatabaseSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your create relational database snapshot
	// request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s CreateRelationalDatabaseSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRelationalDatabaseSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *CreateRelationalDatabaseSnapshotOutput) SetOperations(v []*Operation) *CreateRelationalDatabaseSnapshotOutput {
	s.Operations = v
	return s
}

type DeleteDiskInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the disk you want to delete (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDiskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDiskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDiskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDiskInput"}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskName sets the DiskName field's value.
func (s *DeleteDiskInput) SetDiskName(v string) *DeleteDiskInput {
	s.DiskName = &v
	return s
}

type DeleteDiskOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteDiskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDiskOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteDiskOutput) SetOperations(v []*Operation) *DeleteDiskOutput {
	s.Operations = v
	return s
}

type DeleteDiskSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the disk snapshot you want to delete (e.g., my-disk-snapshot).
	//
	// DiskSnapshotName is a required field
	DiskSnapshotName *string `locationName:"diskSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDiskSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDiskSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDiskSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDiskSnapshotInput"}
	if s.DiskSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskSnapshotName sets the DiskSnapshotName field's value.
func (s *DeleteDiskSnapshotInput) SetDiskSnapshotName(v string) *DeleteDiskSnapshotInput {
	s.DiskSnapshotName = &v
	return s
}

type DeleteDiskSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteDiskSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDiskSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteDiskSnapshotOutput) SetOperations(v []*Operation) *DeleteDiskSnapshotOutput {
	s.Operations = v
	return s
}

type DeleteDomainEntryInput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your domain entries.
	//
	// DomainEntry is a required field
	DomainEntry *DomainEntry `locationName:"domainEntry" type:"structure" required:"true"`

	// The name of the domain entry to delete.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainEntryInput"}
	if s.DomainEntry == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainEntry"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainEntry sets the DomainEntry field's value.
func (s *DeleteDomainEntryInput) SetDomainEntry(v *DomainEntry) *DeleteDomainEntryInput {
	s.DomainEntry = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainEntryInput) SetDomainName(v string) *DeleteDomainEntryInput {
	s.DomainName = &v
	return s
}

type DeleteDomainEntryOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete domain entry request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteDomainEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainEntryOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DeleteDomainEntryOutput) SetOperation(v *Operation) *DeleteDomainEntryOutput {
	s.Operation = v
	return s
}

type DeleteDomainInput struct {
	_ struct{} `type:"structure"`

	// The specific domain name to delete.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainInput) SetDomainName(v string) *DeleteDomainInput {
	s.DomainName = &v
	return s
}

type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete domain request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DeleteDomainOutput) SetOperation(v *Operation) *DeleteDomainOutput {
	s.Operation = v
	return s
}

type DeleteInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to delete.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *DeleteInstanceInput) SetInstanceName(v string) *DeleteInstanceInput {
	s.InstanceName = &v
	return s
}

type DeleteInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete instance request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteInstanceOutput) SetOperations(v []*Operation) *DeleteInstanceOutput {
	s.Operations = v
	return s
}

type DeleteInstanceSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot to delete.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceSnapshotInput"}
	if s.InstanceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *DeleteInstanceSnapshotInput) SetInstanceSnapshotName(v string) *DeleteInstanceSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

type DeleteInstanceSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete instance snapshot request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteInstanceSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteInstanceSnapshotOutput) SetOperations(v []*Operation) *DeleteInstanceSnapshotOutput {
	s.Operations = v
	return s
}

type DeleteKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name of the key pair to delete.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *DeleteKeyPairInput) SetKeyPairName(v string) *DeleteKeyPairInput {
	s.KeyPairName = &v
	return s
}

type DeleteKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete key pair request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s DeleteKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteKeyPairOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *DeleteKeyPairOutput) SetOperation(v *Operation) *DeleteKeyPairOutput {
	s.Operation = v
	return s
}

type DeleteLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer you want to delete.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoadBalancerInput"}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *DeleteLoadBalancerInput) SetLoadBalancerName(v string) *DeleteLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

type DeleteLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteLoadBalancerOutput) SetOperations(v []*Operation) *DeleteLoadBalancerOutput {
	s.Operations = v
	return s
}

type DeleteLoadBalancerTlsCertificateInput struct {
	_ struct{} `type:"structure"`

	// The SSL/TLS certificate name.
	//
	// CertificateName is a required field
	CertificateName *string `locationName:"certificateName" type:"string" required:"true"`

	// When true, forces the deletion of an SSL/TLS certificate.
	//
	// There can be two certificates associated with a Lightsail load balancer:
	// the primary and the backup. The force parameter is required when the primary
	// SSL/TLS certificate is in use by an instance attached to the load balancer.
	Force *bool `locationName:"force" type:"boolean"`

	// The load balancer name.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoadBalancerTlsCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerTlsCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoadBalancerTlsCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoadBalancerTlsCertificateInput"}
	if s.CertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateName"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateName sets the CertificateName field's value.
func (s *DeleteLoadBalancerTlsCertificateInput) SetCertificateName(v string) *DeleteLoadBalancerTlsCertificateInput {
	s.CertificateName = &v
	return s
}

// SetForce sets the Force field's value.
func (s *DeleteLoadBalancerTlsCertificateInput) SetForce(v bool) *DeleteLoadBalancerTlsCertificateInput {
	s.Force = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *DeleteLoadBalancerTlsCertificateInput) SetLoadBalancerName(v string) *DeleteLoadBalancerTlsCertificateInput {
	s.LoadBalancerName = &v
	return s
}

type DeleteLoadBalancerTlsCertificateOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteLoadBalancerTlsCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoadBalancerTlsCertificateOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteLoadBalancerTlsCertificateOutput) SetOperations(v []*Operation) *DeleteLoadBalancerTlsCertificateOutput {
	s.Operations = v
	return s
}

type DeleteRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the database snapshot created if skip final snapshot is false,
	// which is the default value for that parameter.
	//
	// Specifying this parameter and also specifying the skip final snapshot parameter
	// to true results in an error.
	//
	// Constraints:
	//
	//    * Must contain from 2 to 255 alphanumeric characters, or hyphens.
	//
	//    * The first and last character must be a letter or number.
	FinalRelationalDatabaseSnapshotName *string `locationName:"finalRelationalDatabaseSnapshotName" type:"string"`

	// The name of the database that you are deleting.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// Determines whether a final database snapshot is created before your database
	// is deleted. If true is specified, no database snapshot is created. If false
	// is specified, a database snapshot is created before your database is deleted.
	//
	// You must specify the final relational database snapshot name parameter if
	// the skip final snapshot parameter is false.
	//
	// Default: false
	SkipFinalSnapshot *bool `locationName:"skipFinalSnapshot" type:"boolean"`
}

// String returns the string representation
func (s DeleteRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRelationalDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRelationalDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRelationalDatabaseInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFinalRelationalDatabaseSnapshotName sets the FinalRelationalDatabaseSnapshotName field's value.
func (s *DeleteRelationalDatabaseInput) SetFinalRelationalDatabaseSnapshotName(v string) *DeleteRelationalDatabaseInput {
	s.FinalRelationalDatabaseSnapshotName = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *DeleteRelationalDatabaseInput) SetRelationalDatabaseName(v string) *DeleteRelationalDatabaseInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetSkipFinalSnapshot sets the SkipFinalSnapshot field's value.
func (s *DeleteRelationalDatabaseInput) SetSkipFinalSnapshot(v bool) *DeleteRelationalDatabaseInput {
	s.SkipFinalSnapshot = &v
	return s
}

type DeleteRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your delete relational database request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRelationalDatabaseOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteRelationalDatabaseOutput) SetOperations(v []*Operation) *DeleteRelationalDatabaseOutput {
	s.Operations = v
	return s
}

type DeleteRelationalDatabaseSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the database snapshot that you are deleting.
	//
	// RelationalDatabaseSnapshotName is a required field
	RelationalDatabaseSnapshotName *string `locationName:"relationalDatabaseSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRelationalDatabaseSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRelationalDatabaseSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRelationalDatabaseSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRelationalDatabaseSnapshotInput"}
	if s.RelationalDatabaseSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationalDatabaseSnapshotName sets the RelationalDatabaseSnapshotName field's value.
func (s *DeleteRelationalDatabaseSnapshotInput) SetRelationalDatabaseSnapshotName(v string) *DeleteRelationalDatabaseSnapshotInput {
	s.RelationalDatabaseSnapshotName = &v
	return s
}

type DeleteRelationalDatabaseSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your delete relational database snapshot
	// request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteRelationalDatabaseSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRelationalDatabaseSnapshotOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DeleteRelationalDatabaseSnapshotOutput) SetOperations(v []*Operation) *DeleteRelationalDatabaseSnapshotOutput {
	s.Operations = v
	return s
}

type DetachDiskInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the disk you want to detach from your instance (e.g.,
	// my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachDiskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachDiskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachDiskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachDiskInput"}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskName sets the DiskName field's value.
func (s *DetachDiskInput) SetDiskName(v string) *DetachDiskInput {
	s.DiskName = &v
	return s
}

type DetachDiskOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DetachDiskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachDiskOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DetachDiskOutput) SetOperations(v []*Operation) *DetachDiskOutput {
	s.Operations = v
	return s
}

type DetachInstancesFromLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// An array of strings containing the names of the instances you want to detach
	// from the load balancer.
	//
	// InstanceNames is a required field
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The name of the Lightsail load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachInstancesFromLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInstancesFromLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachInstancesFromLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachInstancesFromLoadBalancerInput"}
	if s.InstanceNames == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceNames"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceNames sets the InstanceNames field's value.
func (s *DetachInstancesFromLoadBalancerInput) SetInstanceNames(v []*string) *DetachInstancesFromLoadBalancerInput {
	s.InstanceNames = v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *DetachInstancesFromLoadBalancerInput) SetLoadBalancerName(v string) *DetachInstancesFromLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

type DetachInstancesFromLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DetachInstancesFromLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInstancesFromLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DetachInstancesFromLoadBalancerOutput) SetOperations(v []*Operation) *DetachInstancesFromLoadBalancerOutput {
	s.Operations = v
	return s
}

type DetachStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP to detach from the instance.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachStaticIpInput"}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *DetachStaticIpInput) SetStaticIpName(v string) *DetachStaticIpInput {
	s.StaticIpName = &v
	return s
}

type DetachStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// detach static IP request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DetachStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *DetachStaticIpOutput) SetOperations(v []*Operation) *DetachStaticIpOutput {
	s.Operations = v
	return s
}

// Describes a system disk or an block storage disk.
type Disk struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the disk.
	Arn *string `locationName:"arn" type:"string"`

	// The resources to which the disk is attached.
	AttachedTo *string `locationName:"attachedTo" type:"string"`

	// (Deprecated) The attachment state of the disk.
	//
	// In releases prior to November 14, 2017, this parameter returned attached
	// for system disks in the API response. It is now deprecated, but still included
	// in the response. Use isAttached instead.
	//
	// Deprecated: AttachmentState has been deprecated
	AttachmentState *string `locationName:"attachmentState" deprecated:"true" type:"string"`

	// The date when the disk was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// (Deprecated) The number of GB in use by the disk.
	//
	// In releases prior to November 14, 2017, this parameter was not included in
	// the API response. It is now deprecated.
	//
	// Deprecated: GbInUse has been deprecated
	GbInUse *int64 `locationName:"gbInUse" deprecated:"true" type:"integer"`

	// The input/output operations per second (IOPS) of the disk.
	Iops *int64 `locationName:"iops" type:"integer"`

	// A Boolean value indicating whether the disk is attached.
	IsAttached *bool `locationName:"isAttached" type:"boolean"`

	// A Boolean value indicating whether this disk is a system disk (has an operating
	// system loaded on it).
	IsSystemDisk *bool `locationName:"isSystemDisk" type:"boolean"`

	// The AWS Region and Availability Zone where the disk is located.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The unique name of the disk.
	Name *string `locationName:"name" type:"string"`

	// The disk path.
	Path *string `locationName:"path" type:"string"`

	// The Lightsail resource type (e.g., Disk).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The size of the disk in GB.
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`

	// Describes the status of the disk.
	State *string `locationName:"state" type:"string" enum:"DiskState"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s Disk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Disk) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Disk) SetArn(v string) *Disk {
	s.Arn = &v
	return s
}

// SetAttachedTo sets the AttachedTo field's value.
func (s *Disk) SetAttachedTo(v string) *Disk {
	s.AttachedTo = &v
	return s
}

// SetAttachmentState sets the AttachmentState field's value.
func (s *Disk) SetAttachmentState(v string) *Disk {
	s.AttachmentState = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Disk) SetCreatedAt(v time.Time) *Disk {
	s.CreatedAt = &v
	return s
}

// SetGbInUse sets the GbInUse field's value.
func (s *Disk) SetGbInUse(v int64) *Disk {
	s.GbInUse = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *Disk) SetIops(v int64) *Disk {
	s.Iops = &v
	return s
}

// SetIsAttached sets the IsAttached field's value.
func (s *Disk) SetIsAttached(v bool) *Disk {
	s.IsAttached = &v
	return s
}

// SetIsSystemDisk sets the IsSystemDisk field's value.
func (s *Disk) SetIsSystemDisk(v bool) *Disk {
	s.IsSystemDisk = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Disk) SetLocation(v *ResourceLocation) *Disk {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Disk) SetName(v string) *Disk {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Disk) SetPath(v string) *Disk {
	s.Path = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Disk) SetResourceType(v string) *Disk {
	s.ResourceType = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *Disk) SetSizeInGb(v int64) *Disk {
	s.SizeInGb = &v
	return s
}

// SetState sets the State field's value.
func (s *Disk) SetState(v string) *Disk {
	s.State = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Disk) SetSupportCode(v string) *Disk {
	s.SupportCode = &v
	return s
}

// Describes a block storage disk mapping.
type DiskMap struct {
	_ struct{} `type:"structure"`

	// The new disk name (e.g., my-new-disk).
	NewDiskName *string `locationName:"newDiskName" type:"string"`

	// The original disk path exposed to the instance (for example, /dev/sdh).
	OriginalDiskPath *string `locationName:"originalDiskPath" type:"string"`
}

// String returns the string representation
func (s DiskMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiskMap) GoString() string {
	return s.String()
}

// SetNewDiskName sets the NewDiskName field's value.
func (s *DiskMap) SetNewDiskName(v string) *DiskMap {
	s.NewDiskName = &v
	return s
}

// SetOriginalDiskPath sets the OriginalDiskPath field's value.
func (s *DiskMap) SetOriginalDiskPath(v string) *DiskMap {
	s.OriginalDiskPath = &v
	return s
}

// Describes a block storage disk snapshot.
type DiskSnapshot struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the disk snapshot.
	Arn *string `locationName:"arn" type:"string"`

	// The date when the disk snapshot was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the source disk from which you are creating
	// the disk snapshot.
	FromDiskArn *string `locationName:"fromDiskArn" type:"string"`

	// The unique name of the source disk from which you are creating the disk snapshot.
	FromDiskName *string `locationName:"fromDiskName" type:"string"`

	// The AWS Region and Availability Zone where the disk snapshot was created.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the disk snapshot (e.g., my-disk-snapshot).
	Name *string `locationName:"name" type:"string"`

	// The progress of the disk snapshot operation.
	Progress *string `locationName:"progress" type:"string"`

	// The Lightsail resource type (e.g., DiskSnapshot).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The size of the disk in GB.
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`

	// The status of the disk snapshot operation.
	State *string `locationName:"state" type:"string" enum:"DiskSnapshotState"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s DiskSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiskSnapshot) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DiskSnapshot) SetArn(v string) *DiskSnapshot {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DiskSnapshot) SetCreatedAt(v time.Time) *DiskSnapshot {
	s.CreatedAt = &v
	return s
}

// SetFromDiskArn sets the FromDiskArn field's value.
func (s *DiskSnapshot) SetFromDiskArn(v string) *DiskSnapshot {
	s.FromDiskArn = &v
	return s
}

// SetFromDiskName sets the FromDiskName field's value.
func (s *DiskSnapshot) SetFromDiskName(v string) *DiskSnapshot {
	s.FromDiskName = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DiskSnapshot) SetLocation(v *ResourceLocation) *DiskSnapshot {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *DiskSnapshot) SetName(v string) *DiskSnapshot {
	s.Name = &v
	return s
}

// SetProgress sets the Progress field's value.
func (s *DiskSnapshot) SetProgress(v string) *DiskSnapshot {
	s.Progress = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DiskSnapshot) SetResourceType(v string) *DiskSnapshot {
	s.ResourceType = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *DiskSnapshot) SetSizeInGb(v int64) *DiskSnapshot {
	s.SizeInGb = &v
	return s
}

// SetState sets the State field's value.
func (s *DiskSnapshot) SetState(v string) *DiskSnapshot {
	s.State = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *DiskSnapshot) SetSupportCode(v string) *DiskSnapshot {
	s.SupportCode = &v
	return s
}

// Describes a domain where you are storing recordsets in Lightsail.
type Domain struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the domain recordset (e.g., arn:aws:lightsail:global:123456789101:Domain/824cede0-abc7-4f84-8dbc-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The date when the domain recordset was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// An array of key-value pairs containing information about the domain entries.
	DomainEntries []*DomainEntry `locationName:"domainEntries" type:"list"`

	// The AWS Region and Availability Zones where the domain recordset was created.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the domain.
	Name *string `locationName:"name" type:"string"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s Domain) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Domain) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Domain) SetArn(v string) *Domain {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Domain) SetCreatedAt(v time.Time) *Domain {
	s.CreatedAt = &v
	return s
}

// SetDomainEntries sets the DomainEntries field's value.
func (s *Domain) SetDomainEntries(v []*DomainEntry) *Domain {
	s.DomainEntries = v
	return s
}

// SetLocation sets the Location field's value.
func (s *Domain) SetLocation(v *ResourceLocation) *Domain {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Domain) SetName(v string) *Domain {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Domain) SetResourceType(v string) *Domain {
	s.ResourceType = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Domain) SetSupportCode(v string) *Domain {
	s.SupportCode = &v
	return s
}

// Describes a domain recordset entry.
type DomainEntry struct {
	_ struct{} `type:"structure"`

	// The ID of the domain recordset entry.
	Id *string `locationName:"id" type:"string"`

	// When true, specifies whether the domain entry is an alias used by the Lightsail
	// load balancer. You can include an alias (A type) record in your request,
	// which points to a load balancer DNS name and routes traffic to your load
	// balancer
	IsAlias *bool `locationName:"isAlias" type:"boolean"`

	// The name of the domain.
	Name *string `locationName:"name" type:"string"`

	// (Deprecated) The options for the domain entry.
	//
	// In releases prior to November 29, 2017, this parameter was not included in
	// the API response. It is now deprecated.
	//
	// Deprecated: Options has been deprecated
	Options map[string]*string `locationName:"options" deprecated:"true" type:"map"`

	// The target AWS name server (e.g., ns-111.awsdns-22.com.).
	//
	// For Lightsail load balancers, the value looks like ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com.
	// Be sure to also set isAlias to true when setting up an A record for a load
	// balancer.
	Target *string `locationName:"target" type:"string"`

	// The type of domain entry (e.g., SOA or NS).
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation
func (s DomainEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainEntry) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DomainEntry) SetId(v string) *DomainEntry {
	s.Id = &v
	return s
}

// SetIsAlias sets the IsAlias field's value.
func (s *DomainEntry) SetIsAlias(v bool) *DomainEntry {
	s.IsAlias = &v
	return s
}

// SetName sets the Name field's value.
func (s *DomainEntry) SetName(v string) *DomainEntry {
	s.Name = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *DomainEntry) SetOptions(v map[string]*string) *DomainEntry {
	s.Options = v
	return s
}

// SetTarget sets the Target field's value.
func (s *DomainEntry) SetTarget(v string) *DomainEntry {
	s.Target = &v
	return s
}

// SetType sets the Type field's value.
func (s *DomainEntry) SetType(v string) *DomainEntry {
	s.Type = &v
	return s
}

type DownloadDefaultKeyPairInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DownloadDefaultKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDefaultKeyPairInput) GoString() string {
	return s.String()
}

type DownloadDefaultKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// A base64-encoded RSA private key.
	PrivateKeyBase64 *string `locationName:"privateKeyBase64" type:"string"`

	// A base64-encoded public key of the ssh-rsa type.
	PublicKeyBase64 *string `locationName:"publicKeyBase64" type:"string"`
}

// String returns the string representation
func (s DownloadDefaultKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadDefaultKeyPairOutput) GoString() string {
	return s.String()
}

// SetPrivateKeyBase64 sets the PrivateKeyBase64 field's value.
func (s *DownloadDefaultKeyPairOutput) SetPrivateKeyBase64(v string) *DownloadDefaultKeyPairOutput {
	s.PrivateKeyBase64 = &v
	return s
}

// SetPublicKeyBase64 sets the PublicKeyBase64 field's value.
func (s *DownloadDefaultKeyPairOutput) SetPublicKeyBase64(v string) *DownloadDefaultKeyPairOutput {
	s.PublicKeyBase64 = &v
	return s
}

type GetActiveNamesInput struct {
	_ struct{} `type:"structure"`

	// A token used for paginating results from your get active names request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetActiveNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActiveNamesInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetActiveNamesInput) SetPageToken(v string) *GetActiveNamesInput {
	s.PageToken = &v
	return s
}

type GetActiveNamesOutput struct {
	_ struct{} `type:"structure"`

	// The list of active names returned by the get active names request.
	ActiveNames []*string `locationName:"activeNames" type:"list"`

	// A token used for advancing to the next page of results from your get active
	// names request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetActiveNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetActiveNamesOutput) GoString() string {
	return s.String()
}

// SetActiveNames sets the ActiveNames field's value.
func (s *GetActiveNamesOutput) SetActiveNames(v []*string) *GetActiveNamesOutput {
	s.ActiveNames = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetActiveNamesOutput) SetNextPageToken(v string) *GetActiveNamesOutput {
	s.NextPageToken = &v
	return s
}

type GetBlueprintsInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether to include inactive results in your request.
	IncludeInactive *bool `locationName:"includeInactive" type:"boolean"`

	// A token used for advancing to the next page of results from your get blueprints
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetBlueprintsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlueprintsInput) GoString() string {
	return s.String()
}

// SetIncludeInactive sets the IncludeInactive field's value.
func (s *GetBlueprintsInput) SetIncludeInactive(v bool) *GetBlueprintsInput {
	s.IncludeInactive = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *GetBlueprintsInput) SetPageToken(v string) *GetBlueprintsInput {
	s.PageToken = &v
	return s
}

type GetBlueprintsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs that contains information about the available
	// blueprints.
	Blueprints []*Blueprint `locationName:"blueprints" type:"list"`

	// A token used for advancing to the next page of results from your get blueprints
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetBlueprintsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlueprintsOutput) GoString() string {
	return s.String()
}

// SetBlueprints sets the Blueprints field's value.
func (s *GetBlueprintsOutput) SetBlueprints(v []*Blueprint) *GetBlueprintsOutput {
	s.Blueprints = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetBlueprintsOutput) SetNextPageToken(v string) *GetBlueprintsOutput {
	s.NextPageToken = &v
	return s
}

type GetBundlesInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that indicates whether to include inactive bundle results
	// in your request.
	IncludeInactive *bool `locationName:"includeInactive" type:"boolean"`

	// A token used for advancing to the next page of results from your get bundles
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBundlesInput) GoString() string {
	return s.String()
}

// SetIncludeInactive sets the IncludeInactive field's value.
func (s *GetBundlesInput) SetIncludeInactive(v bool) *GetBundlesInput {
	s.IncludeInactive = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *GetBundlesInput) SetPageToken(v string) *GetBundlesInput {
	s.PageToken = &v
	return s
}

type GetBundlesOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs that contains information about the available
	// bundles.
	Bundles []*Bundle `locationName:"bundles" type:"list"`

	// A token used for advancing to the next page of results from your get active
	// names request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBundlesOutput) GoString() string {
	return s.String()
}

// SetBundles sets the Bundles field's value.
func (s *GetBundlesOutput) SetBundles(v []*Bundle) *GetBundlesOutput {
	s.Bundles = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetBundlesOutput) SetNextPageToken(v string) *GetBundlesOutput {
	s.NextPageToken = &v
	return s
}

type GetDiskInput struct {
	_ struct{} `type:"structure"`

	// The name of the disk (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDiskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDiskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDiskInput"}
	if s.DiskName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskName sets the DiskName field's value.
func (s *GetDiskInput) SetDiskName(v string) *GetDiskInput {
	s.DiskName = &v
	return s
}

type GetDiskOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the disk.
	Disk *Disk `locationName:"disk" type:"structure"`
}

// String returns the string representation
func (s GetDiskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiskOutput) GoString() string {
	return s.String()
}

// SetDisk sets the Disk field's value.
func (s *GetDiskOutput) SetDisk(v *Disk) *GetDiskOutput {
	s.Disk = v
	return s
}

type GetDiskSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the disk snapshot (e.g., my-disk-snapshot).
	//
	// DiskSnapshotName is a required field
	DiskSnapshotName *string `locationName:"diskSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDiskSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiskSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDiskSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDiskSnapshotInput"}
	if s.DiskSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("DiskSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDiskSnapshotName sets the DiskSnapshotName field's value.
func (s *GetDiskSnapshotInput) SetDiskSnapshotName(v string) *GetDiskSnapshotInput {
	s.DiskSnapshotName = &v
	return s
}

type GetDiskSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the disk snapshot.
	DiskSnapshot *DiskSnapshot `locationName:"diskSnapshot" type:"structure"`
}

// String returns the string representation
func (s GetDiskSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiskSnapshotOutput) GoString() string {
	return s.String()
}

// SetDiskSnapshot sets the DiskSnapshot field's value.
func (s *GetDiskSnapshotOutput) SetDiskSnapshot(v *DiskSnapshot) *GetDiskSnapshotOutput {
	s.DiskSnapshot = v
	return s
}

type GetDiskSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your GetDiskSnapshots
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetDiskSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiskSnapshotsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetDiskSnapshotsInput) SetPageToken(v string) *GetDiskSnapshotsInput {
	s.PageToken = &v
	return s
}

type GetDiskSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects containing information about all block storage disk snapshots.
	DiskSnapshots []*DiskSnapshot `locationName:"diskSnapshots" type:"list"`

	// A token used for advancing to the next page of results from your GetDiskSnapshots
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetDiskSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDiskSnapshotsOutput) GoString() string {
	return s.String()
}

// SetDiskSnapshots sets the DiskSnapshots field's value.
func (s *GetDiskSnapshotsOutput) SetDiskSnapshots(v []*DiskSnapshot) *GetDiskSnapshotsOutput {
	s.DiskSnapshots = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDiskSnapshotsOutput) SetNextPageToken(v string) *GetDiskSnapshotsOutput {
	s.NextPageToken = &v
	return s
}

type GetDisksInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your GetDisks
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetDisksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDisksInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetDisksInput) SetPageToken(v string) *GetDisksInput {
	s.PageToken = &v
	return s
}

type GetDisksOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects containing information about all block storage disks.
	Disks []*Disk `locationName:"disks" type:"list"`

	// A token used for advancing to the next page of results from your GetDisks
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetDisksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDisksOutput) GoString() string {
	return s.String()
}

// SetDisks sets the Disks field's value.
func (s *GetDisksOutput) SetDisks(v []*Disk) *GetDisksOutput {
	s.Disks = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDisksOutput) SetNextPageToken(v string) *GetDisksOutput {
	s.NextPageToken = &v
	return s
}

type GetDomainInput struct {
	_ struct{} `type:"structure"`

	// The domain name for which your want to return information about.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainInput) SetDomainName(v string) *GetDomainInput {
	s.DomainName = &v
	return s
}

type GetDomainOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your get domain
	// request.
	Domain *Domain `locationName:"domain" type:"structure"`
}

// String returns the string representation
func (s GetDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainOutput) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *GetDomainOutput) SetDomain(v *Domain) *GetDomainOutput {
	s.Domain = v
	return s
}

type GetDomainsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get domains
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetDomainsInput) SetPageToken(v string) *GetDomainsInput {
	s.PageToken = &v
	return s
}

type GetDomainsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about each of the domain
	// entries in the user's account.
	Domains []*Domain `locationName:"domains" type:"list"`

	// A token used for advancing to the next page of results from your get active
	// names request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainsOutput) GoString() string {
	return s.String()
}

// SetDomains sets the Domains field's value.
func (s *GetDomainsOutput) SetDomains(v []*Domain) *GetDomainsOutput {
	s.Domains = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetDomainsOutput) SetNextPageToken(v string) *GetDomainsOutput {
	s.NextPageToken = &v
	return s
}

type GetInstanceAccessDetailsInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to access.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The protocol to use to connect to your instance. Defaults to ssh.
	Protocol *string `locationName:"protocol" type:"string" enum:"InstanceAccessProtocol"`
}

// String returns the string representation
func (s GetInstanceAccessDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceAccessDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceAccessDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceAccessDetailsInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetInstanceAccessDetailsInput) SetInstanceName(v string) *GetInstanceAccessDetailsInput {
	s.InstanceName = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *GetInstanceAccessDetailsInput) SetProtocol(v string) *GetInstanceAccessDetailsInput {
	s.Protocol = &v
	return s
}

type GetInstanceAccessDetailsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about a get instance access
	// request.
	AccessDetails *InstanceAccessDetails `locationName:"accessDetails" type:"structure"`
}

// String returns the string representation
func (s GetInstanceAccessDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceAccessDetailsOutput) GoString() string {
	return s.String()
}

// SetAccessDetails sets the AccessDetails field's value.
func (s *GetInstanceAccessDetailsOutput) SetAccessDetails(v *InstanceAccessDetails) *GetInstanceAccessDetailsOutput {
	s.AccessDetails = v
	return s
}

type GetInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetInstanceInput) SetInstanceName(v string) *GetInstanceInput {
	s.InstanceName = &v
	return s
}

type GetInstanceMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The end time of the time period.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The name of the instance for which you want to get metrics data.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// The metric name to get data about.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true" enum:"InstanceMetricName"`

	// The granularity, in seconds, of the returned data points.
	//
	// Period is a required field
	Period *int64 `locationName:"period" min:"60" type:"integer" required:"true"`

	// The start time of the time period.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The instance statistics.
	//
	// Statistics is a required field
	Statistics []*string `locationName:"statistics" type:"list" required:"true"`

	// The unit. The list of valid values is below.
	//
	// Unit is a required field
	Unit *string `locationName:"unit" type:"string" required:"true" enum:"MetricUnit"`
}

// String returns the string representation
func (s GetInstanceMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceMetricDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Statistics == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistics"))
	}
	if s.Unit == nil {
		invalidParams.Add(request.NewErrParamRequired("Unit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetInstanceMetricDataInput) SetEndTime(v time.Time) *GetInstanceMetricDataInput {
	s.EndTime = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetInstanceMetricDataInput) SetInstanceName(v string) *GetInstanceMetricDataInput {
	s.InstanceName = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetInstanceMetricDataInput) SetMetricName(v string) *GetInstanceMetricDataInput {
	s.MetricName = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetInstanceMetricDataInput) SetPeriod(v int64) *GetInstanceMetricDataInput {
	s.Period = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetInstanceMetricDataInput) SetStartTime(v time.Time) *GetInstanceMetricDataInput {
	s.StartTime = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *GetInstanceMetricDataInput) SetStatistics(v []*string) *GetInstanceMetricDataInput {
	s.Statistics = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *GetInstanceMetricDataInput) SetUnit(v string) *GetInstanceMetricDataInput {
	s.Unit = &v
	return s
}

type GetInstanceMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// get instance metric data request.
	MetricData []*MetricDatapoint `locationName:"metricData" type:"list"`

	// The metric name to return data for.
	MetricName *string `locationName:"metricName" type:"string" enum:"InstanceMetricName"`
}

// String returns the string representation
func (s GetInstanceMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceMetricDataOutput) GoString() string {
	return s.String()
}

// SetMetricData sets the MetricData field's value.
func (s *GetInstanceMetricDataOutput) SetMetricData(v []*MetricDatapoint) *GetInstanceMetricDataOutput {
	s.MetricData = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetInstanceMetricDataOutput) SetMetricName(v string) *GetInstanceMetricDataOutput {
	s.MetricName = &v
	return s
}

type GetInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the specified instance.
	Instance *Instance `locationName:"instance" type:"structure"`
}

// String returns the string representation
func (s GetInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceOutput) GoString() string {
	return s.String()
}

// SetInstance sets the Instance field's value.
func (s *GetInstanceOutput) SetInstance(v *Instance) *GetInstanceOutput {
	s.Instance = v
	return s
}

type GetInstancePortStatesInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstancePortStatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancePortStatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstancePortStatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstancePortStatesInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetInstancePortStatesInput) SetInstanceName(v string) *GetInstancePortStatesInput {
	s.InstanceName = &v
	return s
}

type GetInstancePortStatesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the port states resulting from your request.
	PortStates []*InstancePortState `locationName:"portStates" type:"list"`
}

// String returns the string representation
func (s GetInstancePortStatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancePortStatesOutput) GoString() string {
	return s.String()
}

// SetPortStates sets the PortStates field's value.
func (s *GetInstancePortStatesOutput) SetPortStates(v []*InstancePortState) *GetInstancePortStatesOutput {
	s.PortStates = v
	return s
}

type GetInstanceSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot for which you are requesting information.
	//
	// InstanceSnapshotName is a required field
	InstanceSnapshotName *string `locationName:"instanceSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceSnapshotInput"}
	if s.InstanceSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceSnapshotName sets the InstanceSnapshotName field's value.
func (s *GetInstanceSnapshotInput) SetInstanceSnapshotName(v string) *GetInstanceSnapshotInput {
	s.InstanceSnapshotName = &v
	return s
}

type GetInstanceSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// get instance snapshot request.
	InstanceSnapshot *InstanceSnapshot `locationName:"instanceSnapshot" type:"structure"`
}

// String returns the string representation
func (s GetInstanceSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceSnapshotOutput) GoString() string {
	return s.String()
}

// SetInstanceSnapshot sets the InstanceSnapshot field's value.
func (s *GetInstanceSnapshotOutput) SetInstanceSnapshot(v *InstanceSnapshot) *GetInstanceSnapshotOutput {
	s.InstanceSnapshot = v
	return s
}

type GetInstanceSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get instance
	// snapshots request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetInstanceSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceSnapshotsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetInstanceSnapshotsInput) SetPageToken(v string) *GetInstanceSnapshotsInput {
	s.PageToken = &v
	return s
}

type GetInstanceSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// get instance snapshots request.
	InstanceSnapshots []*InstanceSnapshot `locationName:"instanceSnapshots" type:"list"`

	// A token used for advancing to the next page of results from your get instance
	// snapshots request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetInstanceSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceSnapshotsOutput) GoString() string {
	return s.String()
}

// SetInstanceSnapshots sets the InstanceSnapshots field's value.
func (s *GetInstanceSnapshotsOutput) SetInstanceSnapshots(v []*InstanceSnapshot) *GetInstanceSnapshotsOutput {
	s.InstanceSnapshots = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetInstanceSnapshotsOutput) SetNextPageToken(v string) *GetInstanceSnapshotsOutput {
	s.NextPageToken = &v
	return s
}

type GetInstanceStateInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to get state information about.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceStateInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *GetInstanceStateInput) SetInstanceName(v string) *GetInstanceStateInput {
	s.InstanceName = &v
	return s
}

type GetInstanceStateOutput struct {
	_ struct{} `type:"structure"`

	// The state of the instance.
	State *InstanceState `locationName:"state" type:"structure"`
}

// String returns the string representation
func (s GetInstanceStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceStateOutput) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *GetInstanceStateOutput) SetState(v *InstanceState) *GetInstanceStateOutput {
	s.State = v
	return s
}

type GetInstancesInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get instances
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancesInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetInstancesInput) SetPageToken(v string) *GetInstancesInput {
	s.PageToken = &v
	return s
}

type GetInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your instances.
	Instances []*Instance `locationName:"instances" type:"list"`

	// A token used for advancing to the next page of results from your get instances
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *GetInstancesOutput) SetInstances(v []*Instance) *GetInstancesOutput {
	s.Instances = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetInstancesOutput) SetNextPageToken(v string) *GetInstancesOutput {
	s.NextPageToken = &v
	return s
}

type GetKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name of the key pair for which you are requesting information.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *GetKeyPairInput) SetKeyPairName(v string) *GetKeyPairInput {
	s.KeyPairName = &v
	return s
}

type GetKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the key pair.
	KeyPair *KeyPair `locationName:"keyPair" type:"structure"`
}

// String returns the string representation
func (s GetKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPairOutput) GoString() string {
	return s.String()
}

// SetKeyPair sets the KeyPair field's value.
func (s *GetKeyPairOutput) SetKeyPair(v *KeyPair) *GetKeyPairOutput {
	s.KeyPair = v
	return s
}

type GetKeyPairsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get key
	// pairs request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetKeyPairsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPairsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetKeyPairsInput) SetPageToken(v string) *GetKeyPairsInput {
	s.PageToken = &v
	return s
}

type GetKeyPairsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the key pairs.
	KeyPairs []*KeyPair `locationName:"keyPairs" type:"list"`

	// A token used for advancing to the next page of results from your get key
	// pairs request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetKeyPairsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPairsOutput) GoString() string {
	return s.String()
}

// SetKeyPairs sets the KeyPairs field's value.
func (s *GetKeyPairsOutput) SetKeyPairs(v []*KeyPair) *GetKeyPairsOutput {
	s.KeyPairs = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetKeyPairsOutput) SetNextPageToken(v string) *GetKeyPairsOutput {
	s.NextPageToken = &v
	return s
}

type GetLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoadBalancerInput"}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *GetLoadBalancerInput) SetLoadBalancerName(v string) *GetLoadBalancerInput {
	s.LoadBalancerName = &v
	return s
}

type GetLoadBalancerMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The end time of the period.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The name of the load balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`

	// The metric about which you want to return information. Valid values are listed
	// below, along with the most useful statistics to include in your request.
	//
	//    * ClientTLSNegotiationErrorCount - The number of TLS connections initiated
	//    by the client that did not establish a session with the load balancer.
	//    Possible causes include a mismatch of ciphers or protocols.
	//
	// Statistics: The most useful statistic is Sum.
	//
	//    * HealthyHostCount - The number of target instances that are considered
	//    healthy.
	//
	// Statistics: The most useful statistic are Average, Minimum, and Maximum.
	//
	//    * UnhealthyHostCount - The number of target instances that are considered
	//    unhealthy.
	//
	// Statistics: The most useful statistic are Average, Minimum, and Maximum.
	//
	//    * HTTPCode_LB_4XX_Count - The number of HTTP 4XX client error codes that
	//    originate from the load balancer. Client errors are generated when requests
	//    are malformed or incomplete. These requests have not been received by
	//    the target instance. This count does not include any response codes generated
	//    by the target instances.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	//    * HTTPCode_LB_5XX_Count - The number of HTTP 5XX server error codes that
	//    originate from the load balancer. This count does not include any response
	//    codes generated by the target instances.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1. Note that Minimum, Maximum, and Average all
	//    return 1.
	//
	//    * HTTPCode_Instance_2XX_Count - The number of HTTP response codes generated
	//    by the target instances. This does not include any response codes generated
	//    by the load balancer.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	//    * HTTPCode_Instance_3XX_Count - The number of HTTP response codes generated
	//    by the target instances. This does not include any response codes generated
	//    by the load balancer.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	//    * HTTPCode_Instance_4XX_Count - The number of HTTP response codes generated
	//    by the target instances. This does not include any response codes generated
	//    by the load balancer.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	//    * HTTPCode_Instance_5XX_Count - The number of HTTP response codes generated
	//    by the target instances. This does not include any response codes generated
	//    by the load balancer.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	//    * InstanceResponseTime - The time elapsed, in seconds, after the request
	//    leaves the load balancer until a response from the target instance is
	//    received.
	//
	// Statistics: The most useful statistic is Average.
	//
	//    * RejectedConnectionCount - The number of connections that were rejected
	//    because the load balancer had reached its maximum number of connections.
	//
	// Statistics: The most useful statistic is Sum.
	//
	//    * RequestCount - The number of requests processed over IPv4. This count
	//    includes only the requests with a response generated by a target instance
	//    of the load balancer.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true" enum:"LoadBalancerMetricName"`

	// The granularity, in seconds, of the returned data points.
	//
	// Period is a required field
	Period *int64 `locationName:"period" min:"60" type:"integer" required:"true"`

	// The start time of the period.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// An array of statistics that you want to request metrics for. Valid values
	// are listed below.
	//
	//    * SampleCount - The count (number) of data points used for the statistical
	//    calculation.
	//
	//    * Average - The value of Sum / SampleCount during the specified period.
	//    By comparing this statistic with the Minimum and Maximum, you can determine
	//    the full scope of a metric and how close the average use is to the Minimum
	//    and Maximum. This comparison helps you to know when to increase or decrease
	//    your resources as needed.
	//
	//    * Sum - All values submitted for the matching metric added together. This
	//    statistic can be useful for determining the total volume of a metric.
	//
	//    * Minimum - The lowest value observed during the specified period. You
	//    can use this value to determine low volumes of activity for your application.
	//
	//    * Maximum - The highest value observed during the specified period. You
	//    can use this value to determine high volumes of activity for your application.
	//
	// Statistics is a required field
	Statistics []*string `locationName:"statistics" type:"list" required:"true"`

	// The unit for the time period request. Valid values are listed below.
	//
	// Unit is a required field
	Unit *string `locationName:"unit" type:"string" required:"true" enum:"MetricUnit"`
}

// String returns the string representation
func (s GetLoadBalancerMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoadBalancerMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoadBalancerMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoadBalancerMetricDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Statistics == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistics"))
	}
	if s.Unit == nil {
		invalidParams.Add(request.NewErrParamRequired("Unit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetLoadBalancerMetricDataInput) SetEndTime(v time.Time) *GetLoadBalancerMetricDataInput {
	s.EndTime = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *GetLoadBalancerMetricDataInput) SetLoadBalancerName(v string) *GetLoadBalancerMetricDataInput {
	s.LoadBalancerName = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetLoadBalancerMetricDataInput) SetMetricName(v string) *GetLoadBalancerMetricDataInput {
	s.MetricName = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetLoadBalancerMetricDataInput) SetPeriod(v int64) *GetLoadBalancerMetricDataInput {
	s.Period = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetLoadBalancerMetricDataInput) SetStartTime(v time.Time) *GetLoadBalancerMetricDataInput {
	s.StartTime = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *GetLoadBalancerMetricDataInput) SetStatistics(v []*string) *GetLoadBalancerMetricDataInput {
	s.Statistics = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *GetLoadBalancerMetricDataInput) SetUnit(v string) *GetLoadBalancerMetricDataInput {
	s.Unit = &v
	return s
}

type GetLoadBalancerMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// An array of metric datapoint objects.
	MetricData []*MetricDatapoint `locationName:"metricData" type:"list"`

	// The metric about which you are receiving information. Valid values are listed
	// below, along with the most useful statistics to include in your request.
	//
	//    * ClientTLSNegotiationErrorCount - The number of TLS connections initiated
	//    by the client that did not establish a session with the load balancer.
	//    Possible causes include a mismatch of ciphers or protocols.
	//
	// Statistics: The most useful statistic is Sum.
	//
	//    * HealthyHostCount - The number of target instances that are considered
	//    healthy.
	//
	// Statistics: The most useful statistic are Average, Minimum, and Maximum.
	//
	//    * UnhealthyHostCount - The number of target instances that are considered
	//    unhealthy.
	//
	// Statistics: The most useful statistic are Average, Minimum, and Maximum.
	//
	//    * HTTPCode_LB_4XX_Count - The number of HTTP 4XX client error codes that
	//    originate from the load balancer. Client errors are generated when requests
	//    are malformed or incomplete. These requests have not been received by
	//    the target instance. This count does not include any response codes generated
	//    by the target instances.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	//    * HTTPCode_LB_5XX_Count - The number of HTTP 5XX server error codes that
	//    originate from the load balancer. This count does not include any response
	//    codes generated by the target instances.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1. Note that Minimum, Maximum, and Average all
	//    return 1.
	//
	//    * HTTPCode_Instance_2XX_Count - The number of HTTP response codes generated
	//    by the target instances. This does not include any response codes generated
	//    by the load balancer.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	//    * HTTPCode_Instance_3XX_Count - The number of HTTP response codes generated
	//    by the target instances. This does not include any response codes generated
	//    by the load balancer.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	//    * HTTPCode_Instance_4XX_Count - The number of HTTP response codes generated
	//    by the target instances. This does not include any response codes generated
	//    by the load balancer.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	//    * HTTPCode_Instance_5XX_Count - The number of HTTP response codes generated
	//    by the target instances. This does not include any response codes generated
	//    by the load balancer.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	//
	//    * InstanceResponseTime - The time elapsed, in seconds, after the request
	//    leaves the load balancer until a response from the target instance is
	//    received.
	//
	// Statistics: The most useful statistic is Average.
	//
	//    * RejectedConnectionCount - The number of connections that were rejected
	//    because the load balancer had reached its maximum number of connections.
	//
	// Statistics: The most useful statistic is Sum.
	//
	//    * RequestCount - The number of requests processed over IPv4. This count
	//    includes only the requests with a response generated by a target instance
	//    of the load balancer.
	//
	// Statistics: The most useful statistic is Sum. Note that Minimum, Maximum,
	//    and Average all return 1.
	MetricName *string `locationName:"metricName" type:"string" enum:"LoadBalancerMetricName"`
}

// String returns the string representation
func (s GetLoadBalancerMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoadBalancerMetricDataOutput) GoString() string {
	return s.String()
}

// SetMetricData sets the MetricData field's value.
func (s *GetLoadBalancerMetricDataOutput) SetMetricData(v []*MetricDatapoint) *GetLoadBalancerMetricDataOutput {
	s.MetricData = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetLoadBalancerMetricDataOutput) SetMetricName(v string) *GetLoadBalancerMetricDataOutput {
	s.MetricName = &v
	return s
}

type GetLoadBalancerOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about your load balancer.
	LoadBalancer *LoadBalancer `locationName:"loadBalancer" type:"structure"`
}

// String returns the string representation
func (s GetLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoadBalancerOutput) GoString() string {
	return s.String()
}

// SetLoadBalancer sets the LoadBalancer field's value.
func (s *GetLoadBalancerOutput) SetLoadBalancer(v *LoadBalancer) *GetLoadBalancerOutput {
	s.LoadBalancer = v
	return s
}

type GetLoadBalancerTlsCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer you associated with your SSL/TLS certificate.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLoadBalancerTlsCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoadBalancerTlsCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoadBalancerTlsCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoadBalancerTlsCertificatesInput"}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *GetLoadBalancerTlsCertificatesInput) SetLoadBalancerName(v string) *GetLoadBalancerTlsCertificatesInput {
	s.LoadBalancerName = &v
	return s
}

type GetLoadBalancerTlsCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// An array of LoadBalancerTlsCertificate objects describing your SSL/TLS certificates.
	TlsCertificates []*LoadBalancerTlsCertificate `locationName:"tlsCertificates" type:"list"`
}

// String returns the string representation
func (s GetLoadBalancerTlsCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoadBalancerTlsCertificatesOutput) GoString() string {
	return s.String()
}

// SetTlsCertificates sets the TlsCertificates field's value.
func (s *GetLoadBalancerTlsCertificatesOutput) SetTlsCertificates(v []*LoadBalancerTlsCertificate) *GetLoadBalancerTlsCertificatesOutput {
	s.TlsCertificates = v
	return s
}

type GetLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// A token used for paginating the results from your GetLoadBalancers request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoadBalancersInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetLoadBalancersInput) SetPageToken(v string) *GetLoadBalancersInput {
	s.PageToken = &v
	return s
}

type GetLoadBalancersOutput struct {
	_ struct{} `type:"structure"`

	// An array of LoadBalancer objects describing your load balancers.
	LoadBalancers []*LoadBalancer `locationName:"loadBalancers" type:"list"`

	// A token used for advancing to the next page of results from your GetLoadBalancers
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoadBalancersOutput) GoString() string {
	return s.String()
}

// SetLoadBalancers sets the LoadBalancers field's value.
func (s *GetLoadBalancersOutput) SetLoadBalancers(v []*LoadBalancer) *GetLoadBalancersOutput {
	s.LoadBalancers = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetLoadBalancersOutput) SetNextPageToken(v string) *GetLoadBalancersOutput {
	s.NextPageToken = &v
	return s
}

type GetOperationInput struct {
	_ struct{} `type:"structure"`

	// A GUID used to identify the operation.
	//
	// OperationId is a required field
	OperationId *string `locationName:"operationId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOperationInput"}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperationId sets the OperationId field's value.
func (s *GetOperationInput) SetOperationId(v string) *GetOperationInput {
	s.OperationId = &v
	return s
}

type GetOperationOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// get operation request.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s GetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *GetOperationOutput) SetOperation(v *Operation) *GetOperationOutput {
	s.Operation = v
	return s
}

type GetOperationsForResourceInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get operations
	// for resource request.
	PageToken *string `locationName:"pageToken" type:"string"`

	// The name of the resource for which you are requesting information.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOperationsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOperationsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOperationsForResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPageToken sets the PageToken field's value.
func (s *GetOperationsForResourceInput) SetPageToken(v string) *GetOperationsForResourceInput {
	s.PageToken = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *GetOperationsForResourceInput) SetResourceName(v string) *GetOperationsForResourceInput {
	s.ResourceName = &v
	return s
}

type GetOperationsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// (Deprecated) Returns the number of pages of results that remain.
	//
	// In releases prior to June 12, 2017, this parameter returned null by the API.
	// It is now deprecated, and the API returns the next page token parameter instead.
	//
	// Deprecated: NextPageCount has been deprecated
	NextPageCount *string `locationName:"nextPageCount" deprecated:"true" type:"string"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An array of key-value pairs containing information about the results of your
	// get operations for resource request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s GetOperationsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextPageCount sets the NextPageCount field's value.
func (s *GetOperationsForResourceOutput) SetNextPageCount(v string) *GetOperationsForResourceOutput {
	s.NextPageCount = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetOperationsForResourceOutput) SetNextPageToken(v string) *GetOperationsForResourceOutput {
	s.NextPageToken = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *GetOperationsForResourceOutput) SetOperations(v []*Operation) *GetOperationsForResourceOutput {
	s.Operations = v
	return s
}

type GetOperationsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get operations
	// request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetOperationsInput) SetPageToken(v string) *GetOperationsInput {
	s.PageToken = &v
	return s
}

type GetOperationsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get operations
	// request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An array of key-value pairs containing information about the results of your
	// get operations request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s GetOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetOperationsOutput) SetNextPageToken(v string) *GetOperationsOutput {
	s.NextPageToken = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *GetOperationsOutput) SetOperations(v []*Operation) *GetOperationsOutput {
	s.Operations = v
	return s
}

type GetRegionsInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether to also include Availability Zones in
	// your get regions request. Availability Zones are indicated with a letter:
	// e.g., us-east-2a.
	IncludeAvailabilityZones *bool `locationName:"includeAvailabilityZones" type:"boolean"`

	// >A Boolean value indicating whether to also include Availability Zones for
	// databases in your get regions request. Availability Zones are indicated with
	// a letter (e.g., us-east-2a).
	IncludeRelationalDatabaseAvailabilityZones *bool `locationName:"includeRelationalDatabaseAvailabilityZones" type:"boolean"`
}

// String returns the string representation
func (s GetRegionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegionsInput) GoString() string {
	return s.String()
}

// SetIncludeAvailabilityZones sets the IncludeAvailabilityZones field's value.
func (s *GetRegionsInput) SetIncludeAvailabilityZones(v bool) *GetRegionsInput {
	s.IncludeAvailabilityZones = &v
	return s
}

// SetIncludeRelationalDatabaseAvailabilityZones sets the IncludeRelationalDatabaseAvailabilityZones field's value.
func (s *GetRegionsInput) SetIncludeRelationalDatabaseAvailabilityZones(v bool) *GetRegionsInput {
	s.IncludeRelationalDatabaseAvailabilityZones = &v
	return s
}

type GetRegionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about your get regions
	// request.
	Regions []*Region `locationName:"regions" type:"list"`
}

// String returns the string representation
func (s GetRegionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegionsOutput) GoString() string {
	return s.String()
}

// SetRegions sets the Regions field's value.
func (s *GetRegionsOutput) SetRegions(v []*Region) *GetRegionsOutput {
	s.Regions = v
	return s
}

type GetRelationalDatabaseBlueprintsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to a specific page of results for your get relational
	// database blueprints request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetRelationalDatabaseBlueprintsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseBlueprintsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetRelationalDatabaseBlueprintsInput) SetPageToken(v string) *GetRelationalDatabaseBlueprintsInput {
	s.PageToken = &v
	return s
}

type GetRelationalDatabaseBlueprintsOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your get relational database blueprints
	// request.
	Blueprints []*RelationalDatabaseBlueprint `locationName:"blueprints" type:"list"`

	// A token used for advancing to the next page of results of your get relational
	// database blueprints request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetRelationalDatabaseBlueprintsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseBlueprintsOutput) GoString() string {
	return s.String()
}

// SetBlueprints sets the Blueprints field's value.
func (s *GetRelationalDatabaseBlueprintsOutput) SetBlueprints(v []*RelationalDatabaseBlueprint) *GetRelationalDatabaseBlueprintsOutput {
	s.Blueprints = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetRelationalDatabaseBlueprintsOutput) SetNextPageToken(v string) *GetRelationalDatabaseBlueprintsOutput {
	s.NextPageToken = &v
	return s
}

type GetRelationalDatabaseBundlesInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to a specific page of results for your get relational
	// database bundles request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetRelationalDatabaseBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseBundlesInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetRelationalDatabaseBundlesInput) SetPageToken(v string) *GetRelationalDatabaseBundlesInput {
	s.PageToken = &v
	return s
}

type GetRelationalDatabaseBundlesOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your get relational database bundles request.
	Bundles []*RelationalDatabaseBundle `locationName:"bundles" type:"list"`

	// A token used for advancing to the next page of results of your get relational
	// database bundles request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetRelationalDatabaseBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseBundlesOutput) GoString() string {
	return s.String()
}

// SetBundles sets the Bundles field's value.
func (s *GetRelationalDatabaseBundlesOutput) SetBundles(v []*RelationalDatabaseBundle) *GetRelationalDatabaseBundlesOutput {
	s.Bundles = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetRelationalDatabaseBundlesOutput) SetNextPageToken(v string) *GetRelationalDatabaseBundlesOutput {
	s.NextPageToken = &v
	return s
}

type GetRelationalDatabaseEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes in the past from which to retrieve events. For example,
	// to get all events from the past 2 hours, enter 120.
	//
	// Default: 60
	//
	// The minimum is 1 and the maximum is 14 days (20160 minutes).
	DurationInMinutes *int64 `locationName:"durationInMinutes" type:"integer"`

	// A token used for advancing to a specific page of results from for get relational
	// database events request.
	PageToken *string `locationName:"pageToken" type:"string"`

	// The name of the database from which to get events.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRelationalDatabaseEventsInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDurationInMinutes sets the DurationInMinutes field's value.
func (s *GetRelationalDatabaseEventsInput) SetDurationInMinutes(v int64) *GetRelationalDatabaseEventsInput {
	s.DurationInMinutes = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *GetRelationalDatabaseEventsInput) SetPageToken(v string) *GetRelationalDatabaseEventsInput {
	s.PageToken = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *GetRelationalDatabaseEventsInput) SetRelationalDatabaseName(v string) *GetRelationalDatabaseEventsInput {
	s.RelationalDatabaseName = &v
	return s
}

type GetRelationalDatabaseEventsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get relational
	// database events request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An object describing the result of your get relational database events request.
	RelationalDatabaseEvents []*RelationalDatabaseEvent `locationName:"relationalDatabaseEvents" type:"list"`
}

// String returns the string representation
func (s GetRelationalDatabaseEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseEventsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetRelationalDatabaseEventsOutput) SetNextPageToken(v string) *GetRelationalDatabaseEventsOutput {
	s.NextPageToken = &v
	return s
}

// SetRelationalDatabaseEvents sets the RelationalDatabaseEvents field's value.
func (s *GetRelationalDatabaseEventsOutput) SetRelationalDatabaseEvents(v []*RelationalDatabaseEvent) *GetRelationalDatabaseEventsOutput {
	s.RelationalDatabaseEvents = v
	return s
}

type GetRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of the database that you are looking up.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRelationalDatabaseInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *GetRelationalDatabaseInput) SetRelationalDatabaseName(v string) *GetRelationalDatabaseInput {
	s.RelationalDatabaseName = &v
	return s
}

type GetRelationalDatabaseLogEventsInput struct {
	_ struct{} `type:"structure"`

	// The end of the time interval from which to get log events.
	//
	// Constraints:
	//
	//    * Specified in Universal Coordinated Time (UTC).
	//
	//    * Specified in the Unix time format.
	//
	// For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC,
	//    then you input 1538424000 as the end time.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The name of the log stream.
	//
	// Use the get relational database log streams operation to get a list of available
	// log streams.
	//
	// LogStreamName is a required field
	LogStreamName *string `locationName:"logStreamName" type:"string" required:"true"`

	// A token used for advancing to a specific page of results for your get relational
	// database log events request.
	PageToken *string `locationName:"pageToken" type:"string"`

	// The name of your database for which to get log events.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// Parameter to specify if the log should start from head or tail. If true is
	// specified, the log event starts from the head of the log. If false is specified,
	// the log event starts from the tail of the log.
	//
	// Default: false
	StartFromHead *bool `locationName:"startFromHead" type:"boolean"`

	// The start of the time interval from which to get log events.
	//
	// Constraints:
	//
	//    * Specified in Universal Coordinated Time (UTC).
	//
	//    * Specified in the Unix time format.
	//
	// For example, if you wish to use a start time of October 1, 2018, at 8 PM
	//    UTC, then you input 1538424000 as the start time.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation
func (s GetRelationalDatabaseLogEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseLogEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseLogEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRelationalDatabaseLogEventsInput"}
	if s.LogStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("LogStreamName"))
	}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetRelationalDatabaseLogEventsInput) SetEndTime(v time.Time) *GetRelationalDatabaseLogEventsInput {
	s.EndTime = &v
	return s
}

// SetLogStreamName sets the LogStreamName field's value.
func (s *GetRelationalDatabaseLogEventsInput) SetLogStreamName(v string) *GetRelationalDatabaseLogEventsInput {
	s.LogStreamName = &v
	return s
}

// SetPageToken sets the PageToken field's value.
func (s *GetRelationalDatabaseLogEventsInput) SetPageToken(v string) *GetRelationalDatabaseLogEventsInput {
	s.PageToken = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *GetRelationalDatabaseLogEventsInput) SetRelationalDatabaseName(v string) *GetRelationalDatabaseLogEventsInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetStartFromHead sets the StartFromHead field's value.
func (s *GetRelationalDatabaseLogEventsInput) SetStartFromHead(v bool) *GetRelationalDatabaseLogEventsInput {
	s.StartFromHead = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetRelationalDatabaseLogEventsInput) SetStartTime(v time.Time) *GetRelationalDatabaseLogEventsInput {
	s.StartTime = &v
	return s
}

type GetRelationalDatabaseLogEventsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the previous page of results from your get
	// relational database log events request.
	NextBackwardToken *string `locationName:"nextBackwardToken" type:"string"`

	// A token used for advancing to the next page of results from your get relational
	// database log events request.
	NextForwardToken *string `locationName:"nextForwardToken" type:"string"`

	// An object describing the result of your get relational database log events
	// request.
	ResourceLogEvents []*LogEvent `locationName:"resourceLogEvents" type:"list"`
}

// String returns the string representation
func (s GetRelationalDatabaseLogEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseLogEventsOutput) GoString() string {
	return s.String()
}

// SetNextBackwardToken sets the NextBackwardToken field's value.
func (s *GetRelationalDatabaseLogEventsOutput) SetNextBackwardToken(v string) *GetRelationalDatabaseLogEventsOutput {
	s.NextBackwardToken = &v
	return s
}

// SetNextForwardToken sets the NextForwardToken field's value.
func (s *GetRelationalDatabaseLogEventsOutput) SetNextForwardToken(v string) *GetRelationalDatabaseLogEventsOutput {
	s.NextForwardToken = &v
	return s
}

// SetResourceLogEvents sets the ResourceLogEvents field's value.
func (s *GetRelationalDatabaseLogEventsOutput) SetResourceLogEvents(v []*LogEvent) *GetRelationalDatabaseLogEventsOutput {
	s.ResourceLogEvents = v
	return s
}

type GetRelationalDatabaseLogStreamsInput struct {
	_ struct{} `type:"structure"`

	// The name of your database for which to get log streams.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseLogStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseLogStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseLogStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRelationalDatabaseLogStreamsInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *GetRelationalDatabaseLogStreamsInput) SetRelationalDatabaseName(v string) *GetRelationalDatabaseLogStreamsInput {
	s.RelationalDatabaseName = &v
	return s
}

type GetRelationalDatabaseLogStreamsOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your get relational database log streams
	// request.
	LogStreams []*string `locationName:"logStreams" type:"list"`
}

// String returns the string representation
func (s GetRelationalDatabaseLogStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseLogStreamsOutput) GoString() string {
	return s.String()
}

// SetLogStreams sets the LogStreams field's value.
func (s *GetRelationalDatabaseLogStreamsOutput) SetLogStreams(v []*string) *GetRelationalDatabaseLogStreamsOutput {
	s.LogStreams = v
	return s
}

type GetRelationalDatabaseMasterUserPasswordInput struct {
	_ struct{} `type:"structure"`

	// The password version to return.
	//
	// Specifying CURRENT or PREVIOUS returns the current or previous passwords
	// respectively. Specifying PENDING returns the newest version of the password
	// that will rotate to CURRENT. After the PENDING password rotates to CURRENT,
	// the PENDING password is no longer available.
	//
	// Default: CURRENT
	PasswordVersion *string `locationName:"passwordVersion" type:"string" enum:"RelationalDatabasePasswordVersion"`

	// The name of your database for which to get the master user password.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseMasterUserPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseMasterUserPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseMasterUserPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRelationalDatabaseMasterUserPasswordInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPasswordVersion sets the PasswordVersion field's value.
func (s *GetRelationalDatabaseMasterUserPasswordInput) SetPasswordVersion(v string) *GetRelationalDatabaseMasterUserPasswordInput {
	s.PasswordVersion = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *GetRelationalDatabaseMasterUserPasswordInput) SetRelationalDatabaseName(v string) *GetRelationalDatabaseMasterUserPasswordInput {
	s.RelationalDatabaseName = &v
	return s
}

type GetRelationalDatabaseMasterUserPasswordOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp when the specified version of the master user password was
	// created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The master user password for the password version specified.
	MasterUserPassword *string `locationName:"masterUserPassword" type:"string"`
}

// String returns the string representation
func (s GetRelationalDatabaseMasterUserPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseMasterUserPasswordOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetRelationalDatabaseMasterUserPasswordOutput) SetCreatedAt(v time.Time) *GetRelationalDatabaseMasterUserPasswordOutput {
	s.CreatedAt = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *GetRelationalDatabaseMasterUserPasswordOutput) SetMasterUserPassword(v string) *GetRelationalDatabaseMasterUserPasswordOutput {
	s.MasterUserPassword = &v
	return s
}

type GetRelationalDatabaseMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The end of the time interval from which to get metric data.
	//
	// Constraints:
	//
	//    * Specified in Universal Coordinated Time (UTC).
	//
	//    * Specified in the Unix time format.
	//
	// For example, if you wish to use an end time of October 1, 2018, at 8 PM UTC,
	//    then you input 1538424000 as the end time.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The name of the metric data to return.
	//
	// MetricName is a required field
	MetricName *string `locationName:"metricName" type:"string" required:"true" enum:"RelationalDatabaseMetricName"`

	// The granularity, in seconds, of the returned data points.
	//
	// Period is a required field
	Period *int64 `locationName:"period" min:"60" type:"integer" required:"true"`

	// The name of your database from which to get metric data.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// The start of the time interval from which to get metric data.
	//
	// Constraints:
	//
	//    * Specified in Universal Coordinated Time (UTC).
	//
	//    * Specified in the Unix time format.
	//
	// For example, if you wish to use a start time of October 1, 2018, at 8 PM
	//    UTC, then you input 1538424000 as the start time.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The array of statistics for your metric data request.
	//
	// Statistics is a required field
	Statistics []*string `locationName:"statistics" type:"list" required:"true"`

	// The unit for the metric data request.
	//
	// Unit is a required field
	Unit *string `locationName:"unit" type:"string" required:"true" enum:"MetricUnit"`
}

// String returns the string representation
func (s GetRelationalDatabaseMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseMetricDataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseMetricDataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRelationalDatabaseMetricDataInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Period == nil {
		invalidParams.Add(request.NewErrParamRequired("Period"))
	}
	if s.Period != nil && *s.Period < 60 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 60))
	}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.Statistics == nil {
		invalidParams.Add(request.NewErrParamRequired("Statistics"))
	}
	if s.Unit == nil {
		invalidParams.Add(request.NewErrParamRequired("Unit"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *GetRelationalDatabaseMetricDataInput) SetEndTime(v time.Time) *GetRelationalDatabaseMetricDataInput {
	s.EndTime = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetRelationalDatabaseMetricDataInput) SetMetricName(v string) *GetRelationalDatabaseMetricDataInput {
	s.MetricName = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GetRelationalDatabaseMetricDataInput) SetPeriod(v int64) *GetRelationalDatabaseMetricDataInput {
	s.Period = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *GetRelationalDatabaseMetricDataInput) SetRelationalDatabaseName(v string) *GetRelationalDatabaseMetricDataInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetRelationalDatabaseMetricDataInput) SetStartTime(v time.Time) *GetRelationalDatabaseMetricDataInput {
	s.StartTime = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *GetRelationalDatabaseMetricDataInput) SetStatistics(v []*string) *GetRelationalDatabaseMetricDataInput {
	s.Statistics = v
	return s
}

// SetUnit sets the Unit field's value.
func (s *GetRelationalDatabaseMetricDataInput) SetUnit(v string) *GetRelationalDatabaseMetricDataInput {
	s.Unit = &v
	return s
}

type GetRelationalDatabaseMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your get relational database metric data
	// request.
	MetricData []*MetricDatapoint `locationName:"metricData" type:"list"`

	// The name of the metric.
	MetricName *string `locationName:"metricName" type:"string" enum:"RelationalDatabaseMetricName"`
}

// String returns the string representation
func (s GetRelationalDatabaseMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseMetricDataOutput) GoString() string {
	return s.String()
}

// SetMetricData sets the MetricData field's value.
func (s *GetRelationalDatabaseMetricDataOutput) SetMetricData(v []*MetricDatapoint) *GetRelationalDatabaseMetricDataOutput {
	s.MetricData = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *GetRelationalDatabaseMetricDataOutput) SetMetricName(v string) *GetRelationalDatabaseMetricDataOutput {
	s.MetricName = &v
	return s
}

type GetRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the specified database.
	RelationalDatabase *RelationalDatabase `locationName:"relationalDatabase" type:"structure"`
}

// String returns the string representation
func (s GetRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseOutput) GoString() string {
	return s.String()
}

// SetRelationalDatabase sets the RelationalDatabase field's value.
func (s *GetRelationalDatabaseOutput) SetRelationalDatabase(v *RelationalDatabase) *GetRelationalDatabaseOutput {
	s.RelationalDatabase = v
	return s
}

type GetRelationalDatabaseParametersInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to a specific page of results for your get relational
	// database parameters request.
	PageToken *string `locationName:"pageToken" type:"string"`

	// The name of your database for which to get parameters.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRelationalDatabaseParametersInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPageToken sets the PageToken field's value.
func (s *GetRelationalDatabaseParametersInput) SetPageToken(v string) *GetRelationalDatabaseParametersInput {
	s.PageToken = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *GetRelationalDatabaseParametersInput) SetRelationalDatabaseName(v string) *GetRelationalDatabaseParametersInput {
	s.RelationalDatabaseName = &v
	return s
}

type GetRelationalDatabaseParametersOutput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get static
	// IPs request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An object describing the result of your get relational database parameters
	// request.
	Parameters []*RelationalDatabaseParameter `locationName:"parameters" type:"list"`
}

// String returns the string representation
func (s GetRelationalDatabaseParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseParametersOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetRelationalDatabaseParametersOutput) SetNextPageToken(v string) *GetRelationalDatabaseParametersOutput {
	s.NextPageToken = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetRelationalDatabaseParametersOutput) SetParameters(v []*RelationalDatabaseParameter) *GetRelationalDatabaseParametersOutput {
	s.Parameters = v
	return s
}

type GetRelationalDatabaseSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the database snapshot for which to get information.
	//
	// RelationalDatabaseSnapshotName is a required field
	RelationalDatabaseSnapshotName *string `locationName:"relationalDatabaseSnapshotName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRelationalDatabaseSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRelationalDatabaseSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRelationalDatabaseSnapshotInput"}
	if s.RelationalDatabaseSnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseSnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationalDatabaseSnapshotName sets the RelationalDatabaseSnapshotName field's value.
func (s *GetRelationalDatabaseSnapshotInput) SetRelationalDatabaseSnapshotName(v string) *GetRelationalDatabaseSnapshotInput {
	s.RelationalDatabaseSnapshotName = &v
	return s
}

type GetRelationalDatabaseSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the specified database snapshot.
	RelationalDatabaseSnapshot *RelationalDatabaseSnapshot `locationName:"relationalDatabaseSnapshot" type:"structure"`
}

// String returns the string representation
func (s GetRelationalDatabaseSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseSnapshotOutput) GoString() string {
	return s.String()
}

// SetRelationalDatabaseSnapshot sets the RelationalDatabaseSnapshot field's value.
func (s *GetRelationalDatabaseSnapshotOutput) SetRelationalDatabaseSnapshot(v *RelationalDatabaseSnapshot) *GetRelationalDatabaseSnapshotOutput {
	s.RelationalDatabaseSnapshot = v
	return s
}

type GetRelationalDatabaseSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to a specific page of results for your get relational
	// database snapshots request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetRelationalDatabaseSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseSnapshotsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetRelationalDatabaseSnapshotsInput) SetPageToken(v string) *GetRelationalDatabaseSnapshotsInput {
	s.PageToken = &v
	return s
}

type GetRelationalDatabaseSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get relational
	// database snapshots request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An object describing the result of your get relational database snapshots
	// request.
	RelationalDatabaseSnapshots []*RelationalDatabaseSnapshot `locationName:"relationalDatabaseSnapshots" type:"list"`
}

// String returns the string representation
func (s GetRelationalDatabaseSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabaseSnapshotsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetRelationalDatabaseSnapshotsOutput) SetNextPageToken(v string) *GetRelationalDatabaseSnapshotsOutput {
	s.NextPageToken = &v
	return s
}

// SetRelationalDatabaseSnapshots sets the RelationalDatabaseSnapshots field's value.
func (s *GetRelationalDatabaseSnapshotsOutput) SetRelationalDatabaseSnapshots(v []*RelationalDatabaseSnapshot) *GetRelationalDatabaseSnapshotsOutput {
	s.RelationalDatabaseSnapshots = v
	return s
}

type GetRelationalDatabasesInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to a specific page of results for your get relational
	// database request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetRelationalDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabasesInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetRelationalDatabasesInput) SetPageToken(v string) *GetRelationalDatabasesInput {
	s.PageToken = &v
	return s
}

type GetRelationalDatabasesOutput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get relational
	// databases request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An object describing the result of your get relational databases request.
	RelationalDatabases []*RelationalDatabase `locationName:"relationalDatabases" type:"list"`
}

// String returns the string representation
func (s GetRelationalDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRelationalDatabasesOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetRelationalDatabasesOutput) SetNextPageToken(v string) *GetRelationalDatabasesOutput {
	s.NextPageToken = &v
	return s
}

// SetRelationalDatabases sets the RelationalDatabases field's value.
func (s *GetRelationalDatabasesOutput) SetRelationalDatabases(v []*RelationalDatabase) *GetRelationalDatabasesOutput {
	s.RelationalDatabases = v
	return s
}

type GetStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP in Lightsail.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStaticIpInput"}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *GetStaticIpInput) SetStaticIpName(v string) *GetStaticIpInput {
	s.StaticIpName = &v
	return s
}

type GetStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the requested static
	// IP.
	StaticIp *StaticIp `locationName:"staticIp" type:"structure"`
}

// String returns the string representation
func (s GetStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStaticIpOutput) GoString() string {
	return s.String()
}

// SetStaticIp sets the StaticIp field's value.
func (s *GetStaticIpOutput) SetStaticIp(v *StaticIp) *GetStaticIpOutput {
	s.StaticIp = v
	return s
}

type GetStaticIpsInput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get static
	// IPs request.
	PageToken *string `locationName:"pageToken" type:"string"`
}

// String returns the string representation
func (s GetStaticIpsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStaticIpsInput) GoString() string {
	return s.String()
}

// SetPageToken sets the PageToken field's value.
func (s *GetStaticIpsInput) SetPageToken(v string) *GetStaticIpsInput {
	s.PageToken = &v
	return s
}

type GetStaticIpsOutput struct {
	_ struct{} `type:"structure"`

	// A token used for advancing to the next page of results from your get static
	// IPs request.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// An array of key-value pairs containing information about your get static
	// IPs request.
	StaticIps []*StaticIp `locationName:"staticIps" type:"list"`
}

// String returns the string representation
func (s GetStaticIpsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStaticIpsOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetStaticIpsOutput) SetNextPageToken(v string) *GetStaticIpsOutput {
	s.NextPageToken = &v
	return s
}

// SetStaticIps sets the StaticIps field's value.
func (s *GetStaticIpsOutput) SetStaticIps(v []*StaticIp) *GetStaticIpsOutput {
	s.StaticIps = v
	return s
}

type ImportKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name of the key pair for which you want to import the public key.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`

	// A base64-encoded public key of the ssh-rsa type.
	//
	// PublicKeyBase64 is a required field
	PublicKeyBase64 *string `locationName:"publicKeyBase64" type:"string" required:"true"`
}

// String returns the string representation
func (s ImportKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyPairInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyPairInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportKeyPairInput"}
	if s.KeyPairName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyPairName"))
	}
	if s.PublicKeyBase64 == nil {
		invalidParams.Add(request.NewErrParamRequired("PublicKeyBase64"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *ImportKeyPairInput) SetKeyPairName(v string) *ImportKeyPairInput {
	s.KeyPairName = &v
	return s
}

// SetPublicKeyBase64 sets the PublicKeyBase64 field's value.
func (s *ImportKeyPairInput) SetPublicKeyBase64(v string) *ImportKeyPairInput {
	s.PublicKeyBase64 = &v
	return s
}

type ImportKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s ImportKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyPairOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *ImportKeyPairOutput) SetOperation(v *Operation) *ImportKeyPairOutput {
	s.Operation = v
	return s
}

// Describes an instance (a virtual private server).
type Instance struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance (e.g., arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The blueprint ID (e.g., os_amlinux_2016_03).
	BlueprintId *string `locationName:"blueprintId" type:"string"`

	// The friendly name of the blueprint (e.g., Amazon Linux).
	BlueprintName *string `locationName:"blueprintName" type:"string"`

	// The bundle for the instance (e.g., micro_1_0).
	BundleId *string `locationName:"bundleId" type:"string"`

	// The timestamp when the instance was created (e.g., 1479734909.17).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The size of the vCPU and the amount of RAM for the instance.
	Hardware *InstanceHardware `locationName:"hardware" type:"structure"`

	// The IPv6 address of the instance.
	Ipv6Address *string `locationName:"ipv6Address" type:"string"`

	// A Boolean value indicating whether this instance has a static IP assigned
	// to it.
	IsStaticIp *bool `locationName:"isStaticIp" type:"boolean"`

	// The region name and Availability Zone where the instance is located.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name the user gave the instance (e.g., Amazon_Linux-1GB-Ohio-1).
	Name *string `locationName:"name" type:"string"`

	// Information about the public ports and monthly data transfer rates for the
	// instance.
	Networking *InstanceNetworking `locationName:"networking" type:"structure"`

	// The private IP address of the instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The public IP address of the instance.
	PublicIpAddress *string `locationName:"publicIpAddress" type:"string"`

	// The type of resource (usually Instance).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The name of the SSH key being used to connect to the instance (e.g., LightsailDefaultKeyPair).
	SshKeyName *string `locationName:"sshKeyName" type:"string"`

	// The status code and the state (e.g., running) for the instance.
	State *InstanceState `locationName:"state" type:"structure"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`

	// The user name for connecting to the instance (e.g., ec2-user).
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Instance) SetArn(v string) *Instance {
	s.Arn = &v
	return s
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *Instance) SetBlueprintId(v string) *Instance {
	s.BlueprintId = &v
	return s
}

// SetBlueprintName sets the BlueprintName field's value.
func (s *Instance) SetBlueprintName(v string) *Instance {
	s.BlueprintName = &v
	return s
}

// SetBundleId sets the BundleId field's value.
func (s *Instance) SetBundleId(v string) *Instance {
	s.BundleId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Instance) SetCreatedAt(v time.Time) *Instance {
	s.CreatedAt = &v
	return s
}

// SetHardware sets the Hardware field's value.
func (s *Instance) SetHardware(v *InstanceHardware) *Instance {
	s.Hardware = v
	return s
}

// SetIpv6Address sets the Ipv6Address field's value.
func (s *Instance) SetIpv6Address(v string) *Instance {
	s.Ipv6Address = &v
	return s
}

// SetIsStaticIp sets the IsStaticIp field's value.
func (s *Instance) SetIsStaticIp(v bool) *Instance {
	s.IsStaticIp = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Instance) SetLocation(v *ResourceLocation) *Instance {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *Instance) SetName(v string) *Instance {
	s.Name = &v
	return s
}

// SetNetworking sets the Networking field's value.
func (s *Instance) SetNetworking(v *InstanceNetworking) *Instance {
	s.Networking = v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *Instance) SetPrivateIpAddress(v string) *Instance {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIpAddress sets the PublicIpAddress field's value.
func (s *Instance) SetPublicIpAddress(v string) *Instance {
	s.PublicIpAddress = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Instance) SetResourceType(v string) *Instance {
	s.ResourceType = &v
	return s
}

// SetSshKeyName sets the SshKeyName field's value.
func (s *Instance) SetSshKeyName(v string) *Instance {
	s.SshKeyName = &v
	return s
}

// SetState sets the State field's value.
func (s *Instance) SetState(v *InstanceState) *Instance {
	s.State = v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *Instance) SetSupportCode(v string) *Instance {
	s.SupportCode = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *Instance) SetUsername(v string) *Instance {
	s.Username = &v
	return s
}

// The parameters for gaining temporary access to one of your Amazon Lightsail
// instances.
type InstanceAccessDetails struct {
	_ struct{} `type:"structure"`

	// For SSH access, the public key to use when accessing your instance For OpenSSH
	// clients (e.g., command line SSH), you should save this value to tempkey-cert.pub.
	CertKey *string `locationName:"certKey" type:"string"`

	// For SSH access, the date on which the temporary keys expire.
	ExpiresAt *time.Time `locationName:"expiresAt" type:"timestamp"`

	// The name of this Amazon Lightsail instance.
	InstanceName *string `locationName:"instanceName" type:"string"`

	// The public IP address of the Amazon Lightsail instance.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// For RDP access, the password for your Amazon Lightsail instance. Password
	// will be an empty string if the password for your new instance is not ready
	// yet. When you create an instance, it can take up to 15 minutes for the instance
	// to be ready.
	//
	// If you create an instance using any key pair other than the default (LightsailDefaultKeyPair),
	// password will always be an empty string.
	//
	// If you change the Administrator password on the instance, Lightsail will
	// continue to return the original password value. When accessing the instance
	// using RDP, you need to manually enter the Administrator password after changing
	// it from the default.
	Password *string `locationName:"password" type:"string"`

	// For a Windows Server-based instance, an object with the data you can use
	// to retrieve your password. This is only needed if password is empty and the
	// instance is not new (and therefore the password is not ready yet). When you
	// create an instance, it can take up to 15 minutes for the instance to be ready.
	PasswordData *PasswordData `locationName:"passwordData" type:"structure"`

	// For SSH access, the temporary private key. For OpenSSH clients (e.g., command
	// line SSH), you should save this value to tempkey).
	PrivateKey *string `locationName:"privateKey" type:"string"`

	// The protocol for these Amazon Lightsail instance access details.
	Protocol *string `locationName:"protocol" type:"string" enum:"InstanceAccessProtocol"`

	// The user name to use when logging in to the Amazon Lightsail instance.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation
func (s InstanceAccessDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceAccessDetails) GoString() string {
	return s.String()
}

// SetCertKey sets the CertKey field's value.
func (s *InstanceAccessDetails) SetCertKey(v string) *InstanceAccessDetails {
	s.CertKey = &v
	return s
}

// SetExpiresAt sets the ExpiresAt field's value.
func (s *InstanceAccessDetails) SetExpiresAt(v time.Time) *InstanceAccessDetails {
	s.ExpiresAt = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceAccessDetails) SetInstanceName(v string) *InstanceAccessDetails {
	s.InstanceName = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *InstanceAccessDetails) SetIpAddress(v string) *InstanceAccessDetails {
	s.IpAddress = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *InstanceAccessDetails) SetPassword(v string) *InstanceAccessDetails {
	s.Password = &v
	return s
}

// SetPasswordData sets the PasswordData field's value.
func (s *InstanceAccessDetails) SetPasswordData(v *PasswordData) *InstanceAccessDetails {
	s.PasswordData = v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *InstanceAccessDetails) SetPrivateKey(v string) *InstanceAccessDetails {
	s.PrivateKey = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *InstanceAccessDetails) SetProtocol(v string) *InstanceAccessDetails {
	s.Protocol = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *InstanceAccessDetails) SetUsername(v string) *InstanceAccessDetails {
	s.Username = &v
	return s
}

// Describes the hardware for the instance.
type InstanceHardware struct {
	_ struct{} `type:"structure"`

	// The number of vCPUs the instance has.
	CpuCount *int64 `locationName:"cpuCount" type:"integer"`

	// The disks attached to the instance.
	Disks []*Disk `locationName:"disks" type:"list"`

	// The amount of RAM in GB on the instance (e.g., 1.0).
	RamSizeInGb *float64 `locationName:"ramSizeInGb" type:"float"`
}

// String returns the string representation
func (s InstanceHardware) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceHardware) GoString() string {
	return s.String()
}

// SetCpuCount sets the CpuCount field's value.
func (s *InstanceHardware) SetCpuCount(v int64) *InstanceHardware {
	s.CpuCount = &v
	return s
}

// SetDisks sets the Disks field's value.
func (s *InstanceHardware) SetDisks(v []*Disk) *InstanceHardware {
	s.Disks = v
	return s
}

// SetRamSizeInGb sets the RamSizeInGb field's value.
func (s *InstanceHardware) SetRamSizeInGb(v float64) *InstanceHardware {
	s.RamSizeInGb = &v
	return s
}

// Describes information about the health of the instance.
type InstanceHealthSummary struct {
	_ struct{} `type:"structure"`

	// Describes the overall instance health. Valid values are below.
	InstanceHealth *string `locationName:"instanceHealth" type:"string" enum:"InstanceHealthState"`

	// More information about the instance health. If the instanceHealth is healthy,
	// then an instanceHealthReason value is not provided.
	//
	// If instanceHealth is initial, the instanceHealthReason value can be one of
	// the following:
	//
	//    * Lb.RegistrationInProgress - The target instance is in the process of
	//    being registered with the load balancer.
	//
	//    * Lb.InitialHealthChecking - The Lightsail load balancer is still sending
	//    the target instance the minimum number of health checks required to determine
	//    its health status.
	//
	// If instanceHealth is unhealthy, the instanceHealthReason value can be one
	// of the following:
	//
	//    * Instance.ResponseCodeMismatch - The health checks did not return an
	//    expected HTTP code.
	//
	//    * Instance.Timeout - The health check requests timed out.
	//
	//    * Instance.FailedHealthChecks - The health checks failed because the connection
	//    to the target instance timed out, the target instance response was malformed,
	//    or the target instance failed the health check for an unknown reason.
	//
	//    * Lb.InternalError - The health checks failed due to an internal error.
	//
	// If instanceHealth is unused, the instanceHealthReason value can be one of
	// the following:
	//
	//    * Instance.NotRegistered - The target instance is not registered with
	//    the target group.
	//
	//    * Instance.NotInUse - The target group is not used by any load balancer,
	//    or the target instance is in an Availability Zone that is not enabled
	//    for its load balancer.
	//
	//    * Instance.IpUnusable - The target IP address is reserved for use by a
	//    Lightsail load balancer.
	//
	//    * Instance.InvalidState - The target is in the stopped or terminated state.
	//
	// If instanceHealth is draining, the instanceHealthReason value can be one
	// of the following:
	//
	//    * Instance.DeregistrationInProgress - The target instance is in the process
	//    of being deregistered and the deregistration delay period has not expired.
	InstanceHealthReason *string `locationName:"instanceHealthReason" type:"string" enum:"InstanceHealthReason"`

	// The name of the Lightsail instance for which you are requesting health check
	// data.
	InstanceName *string `locationName:"instanceName" type:"string"`
}

// String returns the string representation
func (s InstanceHealthSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceHealthSummary) GoString() string {
	return s.String()
}

// SetInstanceHealth sets the InstanceHealth field's value.
func (s *InstanceHealthSummary) SetInstanceHealth(v string) *InstanceHealthSummary {
	s.InstanceHealth = &v
	return s
}

// SetInstanceHealthReason sets the InstanceHealthReason field's value.
func (s *InstanceHealthSummary) SetInstanceHealthReason(v string) *InstanceHealthSummary {
	s.InstanceHealthReason = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceHealthSummary) SetInstanceName(v string) *InstanceHealthSummary {
	s.InstanceName = &v
	return s
}

// Describes monthly data transfer rates and port information for an instance.
type InstanceNetworking struct {
	_ struct{} `type:"structure"`

	// The amount of data in GB allocated for monthly data transfers.
	MonthlyTransfer *MonthlyTransfer `locationName:"monthlyTransfer" type:"structure"`

	// An array of key-value pairs containing information about the ports on the
	// instance.
	Ports []*InstancePortInfo `locationName:"ports" type:"list"`
}

// String returns the string representation
func (s InstanceNetworking) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceNetworking) GoString() string {
	return s.String()
}

// SetMonthlyTransfer sets the MonthlyTransfer field's value.
func (s *InstanceNetworking) SetMonthlyTransfer(v *MonthlyTransfer) *InstanceNetworking {
	s.MonthlyTransfer = v
	return s
}

// SetPorts sets the Ports field's value.
func (s *InstanceNetworking) SetPorts(v []*InstancePortInfo) *InstanceNetworking {
	s.Ports = v
	return s
}

// Describes information about the instance ports.
type InstancePortInfo struct {
	_ struct{} `type:"structure"`

	// The access direction (inbound or outbound).
	AccessDirection *string `locationName:"accessDirection" type:"string" enum:"AccessDirection"`

	// The location from which access is allowed (e.g., Anywhere (0.0.0.0/0)).
	AccessFrom *string `locationName:"accessFrom" type:"string"`

	// The type of access (Public or Private).
	AccessType *string `locationName:"accessType" type:"string" enum:"PortAccessType"`

	// The common name.
	CommonName *string `locationName:"commonName" type:"string"`

	// The first port in the range.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The protocol being used. Can be one of the following.
	//
	//    * tcp - Transmission Control Protocol (TCP) provides reliable, ordered,
	//    and error-checked delivery of streamed data between applications running
	//    on hosts communicating by an IP network. If you have an application that
	//    doesn't require reliable data stream service, use UDP instead.
	//
	//    * all - All transport layer protocol types. For more general information,
	//    see Transport layer (https://en.wikipedia.org/wiki/Transport_layer) on
	//    Wikipedia.
	//
	//    * udp - With User Datagram Protocol (UDP), computer applications can send
	//    messages (or datagrams) to other hosts on an Internet Protocol (IP) network.
	//    Prior communications are not required to set up transmission channels
	//    or data paths. Applications that don't require reliable data stream service
	//    can use UDP, which provides a connectionless datagram service that emphasizes
	//    reduced latency over reliability. If you do require reliable data stream
	//    service, use TCP instead.
	Protocol *string `locationName:"protocol" type:"string" enum:"NetworkProtocol"`

	// The last port in the range.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s InstancePortInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstancePortInfo) GoString() string {
	return s.String()
}

// SetAccessDirection sets the AccessDirection field's value.
func (s *InstancePortInfo) SetAccessDirection(v string) *InstancePortInfo {
	s.AccessDirection = &v
	return s
}

// SetAccessFrom sets the AccessFrom field's value.
func (s *InstancePortInfo) SetAccessFrom(v string) *InstancePortInfo {
	s.AccessFrom = &v
	return s
}

// SetAccessType sets the AccessType field's value.
func (s *InstancePortInfo) SetAccessType(v string) *InstancePortInfo {
	s.AccessType = &v
	return s
}

// SetCommonName sets the CommonName field's value.
func (s *InstancePortInfo) SetCommonName(v string) *InstancePortInfo {
	s.CommonName = &v
	return s
}

// SetFromPort sets the FromPort field's value.
func (s *InstancePortInfo) SetFromPort(v int64) *InstancePortInfo {
	s.FromPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *InstancePortInfo) SetProtocol(v string) *InstancePortInfo {
	s.Protocol = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *InstancePortInfo) SetToPort(v int64) *InstancePortInfo {
	s.ToPort = &v
	return s
}

// Describes the port state.
type InstancePortState struct {
	_ struct{} `type:"structure"`

	// The first port in the range.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The protocol being used. Can be one of the following.
	//
	//    * tcp - Transmission Control Protocol (TCP) provides reliable, ordered,
	//    and error-checked delivery of streamed data between applications running
	//    on hosts communicating by an IP network. If you have an application that
	//    doesn't require reliable data stream service, use UDP instead.
	//
	//    * all - All transport layer protocol types. For more general information,
	//    see Transport layer (https://en.wikipedia.org/wiki/Transport_layer) on
	//    Wikipedia.
	//
	//    * udp - With User Datagram Protocol (UDP), computer applications can send
	//    messages (or datagrams) to other hosts on an Internet Protocol (IP) network.
	//    Prior communications are not required to set up transmission channels
	//    or data paths. Applications that don't require reliable data stream service
	//    can use UDP, which provides a connectionless datagram service that emphasizes
	//    reduced latency over reliability. If you do require reliable data stream
	//    service, use TCP instead.
	Protocol *string `locationName:"protocol" type:"string" enum:"NetworkProtocol"`

	// Specifies whether the instance port is open or closed.
	State *string `locationName:"state" type:"string" enum:"PortState"`

	// The last port in the range.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s InstancePortState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstancePortState) GoString() string {
	return s.String()
}

// SetFromPort sets the FromPort field's value.
func (s *InstancePortState) SetFromPort(v int64) *InstancePortState {
	s.FromPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *InstancePortState) SetProtocol(v string) *InstancePortState {
	s.Protocol = &v
	return s
}

// SetState sets the State field's value.
func (s *InstancePortState) SetState(v string) *InstancePortState {
	s.State = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *InstancePortState) SetToPort(v int64) *InstancePortState {
	s.ToPort = &v
	return s
}

// Describes the snapshot of the virtual private server, or instance.
type InstanceSnapshot struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the snapshot (e.g., arn:aws:lightsail:us-east-2:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The timestamp when the snapshot was created (e.g., 1479907467.024).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// An array of disk objects containing information about all block storage disks.
	FromAttachedDisks []*Disk `locationName:"fromAttachedDisks" type:"list"`

	// The blueprint ID from which you created the snapshot (e.g., os_debian_8_3).
	// A blueprint is a virtual private server (or instance) image used to create
	// instances quickly.
	FromBlueprintId *string `locationName:"fromBlueprintId" type:"string"`

	// The bundle ID from which you created the snapshot (e.g., micro_1_0).
	FromBundleId *string `locationName:"fromBundleId" type:"string"`

	// The Amazon Resource Name (ARN) of the instance from which the snapshot was
	// created (e.g., arn:aws:lightsail:us-east-2:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE).
	FromInstanceArn *string `locationName:"fromInstanceArn" type:"string"`

	// The instance from which the snapshot was created.
	FromInstanceName *string `locationName:"fromInstanceName" type:"string"`

	// The region name and Availability Zone where you created the snapshot.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the snapshot.
	Name *string `locationName:"name" type:"string"`

	// The progress of the snapshot.
	Progress *string `locationName:"progress" type:"string"`

	// The type of resource (usually InstanceSnapshot).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The size in GB of the SSD.
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`

	// The state the snapshot is in.
	State *string `locationName:"state" type:"string" enum:"InstanceSnapshotState"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s InstanceSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceSnapshot) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InstanceSnapshot) SetArn(v string) *InstanceSnapshot {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *InstanceSnapshot) SetCreatedAt(v time.Time) *InstanceSnapshot {
	s.CreatedAt = &v
	return s
}

// SetFromAttachedDisks sets the FromAttachedDisks field's value.
func (s *InstanceSnapshot) SetFromAttachedDisks(v []*Disk) *InstanceSnapshot {
	s.FromAttachedDisks = v
	return s
}

// SetFromBlueprintId sets the FromBlueprintId field's value.
func (s *InstanceSnapshot) SetFromBlueprintId(v string) *InstanceSnapshot {
	s.FromBlueprintId = &v
	return s
}

// SetFromBundleId sets the FromBundleId field's value.
func (s *InstanceSnapshot) SetFromBundleId(v string) *InstanceSnapshot {
	s.FromBundleId = &v
	return s
}

// SetFromInstanceArn sets the FromInstanceArn field's value.
func (s *InstanceSnapshot) SetFromInstanceArn(v string) *InstanceSnapshot {
	s.FromInstanceArn = &v
	return s
}

// SetFromInstanceName sets the FromInstanceName field's value.
func (s *InstanceSnapshot) SetFromInstanceName(v string) *InstanceSnapshot {
	s.FromInstanceName = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *InstanceSnapshot) SetLocation(v *ResourceLocation) *InstanceSnapshot {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceSnapshot) SetName(v string) *InstanceSnapshot {
	s.Name = &v
	return s
}

// SetProgress sets the Progress field's value.
func (s *InstanceSnapshot) SetProgress(v string) *InstanceSnapshot {
	s.Progress = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *InstanceSnapshot) SetResourceType(v string) *InstanceSnapshot {
	s.ResourceType = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *InstanceSnapshot) SetSizeInGb(v int64) *InstanceSnapshot {
	s.SizeInGb = &v
	return s
}

// SetState sets the State field's value.
func (s *InstanceSnapshot) SetState(v string) *InstanceSnapshot {
	s.State = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *InstanceSnapshot) SetSupportCode(v string) *InstanceSnapshot {
	s.SupportCode = &v
	return s
}

// Describes the virtual private server (or instance) status.
type InstanceState struct {
	_ struct{} `type:"structure"`

	// The status code for the instance.
	Code *int64 `locationName:"code" type:"integer"`

	// The state of the instance (e.g., running or pending).
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s InstanceState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceState) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *InstanceState) SetCode(v int64) *InstanceState {
	s.Code = &v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceState) SetName(v string) *InstanceState {
	s.Name = &v
	return s
}

type IsVpcPeeredInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s IsVpcPeeredInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IsVpcPeeredInput) GoString() string {
	return s.String()
}

type IsVpcPeeredOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the Lightsail VPC is peered; otherwise, false.
	IsPeered *bool `locationName:"isPeered" type:"boolean"`
}

// String returns the string representation
func (s IsVpcPeeredOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IsVpcPeeredOutput) GoString() string {
	return s.String()
}

// SetIsPeered sets the IsPeered field's value.
func (s *IsVpcPeeredOutput) SetIsPeered(v bool) *IsVpcPeeredOutput {
	s.IsPeered = &v
	return s
}

// Describes the SSH key pair.
type KeyPair struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the key pair (e.g., arn:aws:lightsail:us-east-2:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The timestamp when the key pair was created (e.g., 1479816991.349).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The RSA fingerprint of the key pair.
	Fingerprint *string `locationName:"fingerprint" type:"string"`

	// The region name and Availability Zone where the key pair was created.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The friendly name of the SSH key pair.
	Name *string `locationName:"name" type:"string"`

	// The resource type (usually KeyPair).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s KeyPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPair) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *KeyPair) SetArn(v string) *KeyPair {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *KeyPair) SetCreatedAt(v time.Time) *KeyPair {
	s.CreatedAt = &v
	return s
}

// SetFingerprint sets the Fingerprint field's value.
func (s *KeyPair) SetFingerprint(v string) *KeyPair {
	s.Fingerprint = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *KeyPair) SetLocation(v *ResourceLocation) *KeyPair {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *KeyPair) SetName(v string) *KeyPair {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *KeyPair) SetResourceType(v string) *KeyPair {
	s.ResourceType = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *KeyPair) SetSupportCode(v string) *KeyPair {
	s.SupportCode = &v
	return s
}

// Describes the Lightsail load balancer.
type LoadBalancer struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the load balancer.
	Arn *string `locationName:"arn" type:"string"`

	// A string to string map of the configuration options for your load balancer.
	// Valid values are listed below.
	ConfigurationOptions map[string]*string `locationName:"configurationOptions" type:"map"`

	// The date when your load balancer was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The DNS name of your Lightsail load balancer.
	DnsName *string `locationName:"dnsName" type:"string"`

	// The path you specified to perform your health checks. If no path is specified,
	// the load balancer tries to make a request to the default (root) page.
	HealthCheckPath *string `locationName:"healthCheckPath" type:"string"`

	// An array of InstanceHealthSummary objects describing the health of the load
	// balancer.
	InstanceHealthSummary []*InstanceHealthSummary `locationName:"instanceHealthSummary" type:"list"`

	// The port where the load balancer will direct traffic to your Lightsail instances.
	// For HTTP traffic, it's port 80. For HTTPS traffic, it's port 443.
	InstancePort *int64 `locationName:"instancePort" type:"integer"`

	// The AWS Region where your load balancer was created (e.g., us-east-2a). Lightsail
	// automatically creates your load balancer across Availability Zones.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the load balancer (e.g., my-load-balancer).
	Name *string `locationName:"name" type:"string"`

	// The protocol you have enabled for your load balancer. Valid values are below.
	//
	// You can't just have HTTP_HTTPS, but you can have just HTTP.
	Protocol *string `locationName:"protocol" type:"string" enum:"LoadBalancerProtocol"`

	// An array of public port settings for your load balancer. For HTTP, use port
	// 80. For HTTPS, use port 443.
	PublicPorts []*int64 `locationName:"publicPorts" type:"list"`

	// The resource type (e.g., LoadBalancer.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The status of your load balancer. Valid values are below.
	State *string `locationName:"state" type:"string" enum:"LoadBalancerState"`

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail load balancer. This code enables our support
	// team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`

	// An array of LoadBalancerTlsCertificateSummary objects that provide additional
	// information about the SSL/TLS certificates. For example, if true, the certificate
	// is attached to the load balancer.
	TlsCertificateSummaries []*LoadBalancerTlsCertificateSummary `locationName:"tlsCertificateSummaries" type:"list"`
}

// String returns the string representation
func (s LoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *LoadBalancer) SetArn(v string) *LoadBalancer {
	s.Arn = &v
	return s
}

// SetConfigurationOptions sets the ConfigurationOptions field's value.
func (s *LoadBalancer) SetConfigurationOptions(v map[string]*string) *LoadBalancer {
	s.ConfigurationOptions = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *LoadBalancer) SetCreatedAt(v time.Time) *LoadBalancer {
	s.CreatedAt = &v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *LoadBalancer) SetDnsName(v string) *LoadBalancer {
	s.DnsName = &v
	return s
}

// SetHealthCheckPath sets the HealthCheckPath field's value.
func (s *LoadBalancer) SetHealthCheckPath(v string) *LoadBalancer {
	s.HealthCheckPath = &v
	return s
}

// SetInstanceHealthSummary sets the InstanceHealthSummary field's value.
func (s *LoadBalancer) SetInstanceHealthSummary(v []*InstanceHealthSummary) *LoadBalancer {
	s.InstanceHealthSummary = v
	return s
}

// SetInstancePort sets the InstancePort field's value.
func (s *LoadBalancer) SetInstancePort(v int64) *LoadBalancer {
	s.InstancePort = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *LoadBalancer) SetLocation(v *ResourceLocation) *LoadBalancer {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *LoadBalancer) SetName(v string) *LoadBalancer {
	s.Name = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *LoadBalancer) SetProtocol(v string) *LoadBalancer {
	s.Protocol = &v
	return s
}

// SetPublicPorts sets the PublicPorts field's value.
func (s *LoadBalancer) SetPublicPorts(v []*int64) *LoadBalancer {
	s.PublicPorts = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *LoadBalancer) SetResourceType(v string) *LoadBalancer {
	s.ResourceType = &v
	return s
}

// SetState sets the State field's value.
func (s *LoadBalancer) SetState(v string) *LoadBalancer {
	s.State = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *LoadBalancer) SetSupportCode(v string) *LoadBalancer {
	s.SupportCode = &v
	return s
}

// SetTlsCertificateSummaries sets the TlsCertificateSummaries field's value.
func (s *LoadBalancer) SetTlsCertificateSummaries(v []*LoadBalancerTlsCertificateSummary) *LoadBalancer {
	s.TlsCertificateSummaries = v
	return s
}

// Describes a load balancer SSL/TLS certificate.
//
// TLS is just an updated, more secure version of Secure Socket Layer (SSL).
type LoadBalancerTlsCertificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SSL/TLS certificate.
	Arn *string `locationName:"arn" type:"string"`

	// The time when you created your SSL/TLS certificate.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The domain name for your SSL/TLS certificate.
	DomainName *string `locationName:"domainName" type:"string"`

	// An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing
	// the records.
	DomainValidationRecords []*LoadBalancerTlsCertificateDomainValidationRecord `locationName:"domainValidationRecords" type:"list"`

	// The reason for the SSL/TLS certificate validation failure.
	FailureReason *string `locationName:"failureReason" type:"string" enum:"LoadBalancerTlsCertificateFailureReason"`

	// When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
	IsAttached *bool `locationName:"isAttached" type:"boolean"`

	// The time when the SSL/TLS certificate was issued.
	IssuedAt *time.Time `locationName:"issuedAt" type:"timestamp"`

	// The issuer of the certificate.
	Issuer *string `locationName:"issuer" type:"string"`

	// The algorithm that was used to generate the key pair (the public and private
	// key).
	KeyAlgorithm *string `locationName:"keyAlgorithm" type:"string"`

	// The load balancer name where your SSL/TLS certificate is attached.
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string"`

	// The AWS Region and Availability Zone where you created your certificate.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the SSL/TLS certificate (e.g., my-certificate).
	Name *string `locationName:"name" type:"string"`

	// The timestamp when the SSL/TLS certificate expires.
	NotAfter *time.Time `locationName:"notAfter" type:"timestamp"`

	// The timestamp when the SSL/TLS certificate is first valid.
	NotBefore *time.Time `locationName:"notBefore" type:"timestamp"`

	// An object containing information about the status of Lightsail's managed
	// renewal for the certificate.
	RenewalSummary *LoadBalancerTlsCertificateRenewalSummary `locationName:"renewalSummary" type:"structure"`

	// The resource type (e.g., LoadBalancerTlsCertificate).
	//
	//    * Instance - A Lightsail instance (a virtual private server)
	//
	//    * StaticIp - A static IP address
	//
	//    * KeyPair - The key pair used to connect to a Lightsail instance
	//
	//    * InstanceSnapshot - A Lightsail instance snapshot
	//
	//    * Domain - A DNS zone
	//
	//    * PeeredVpc - A peered VPC
	//
	//    * LoadBalancer - A Lightsail load balancer
	//
	//    * LoadBalancerTlsCertificate - An SSL/TLS certificate associated with
	//    a Lightsail load balancer
	//
	//    * Disk - A Lightsail block storage disk
	//
	//    * DiskSnapshot - A block storage disk snapshot
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The reason the certificate was revoked. Valid values are below.
	RevocationReason *string `locationName:"revocationReason" type:"string" enum:"LoadBalancerTlsCertificateRevocationReason"`

	// The timestamp when the SSL/TLS certificate was revoked.
	RevokedAt *time.Time `locationName:"revokedAt" type:"timestamp"`

	// The serial number of the certificate.
	Serial *string `locationName:"serial" type:"string"`

	// The algorithm that was used to sign the certificate.
	SignatureAlgorithm *string `locationName:"signatureAlgorithm" type:"string"`

	// The status of the SSL/TLS certificate. Valid values are below.
	Status *string `locationName:"status" type:"string" enum:"LoadBalancerTlsCertificateStatus"`

	// The name of the entity that is associated with the public key contained in
	// the certificate.
	Subject *string `locationName:"subject" type:"string"`

	// One or more domains or subdomains included in the certificate. This list
	// contains the domain names that are bound to the public key that is contained
	// in the certificate. The subject alternative names include the canonical domain
	// name (CNAME) of the certificate and additional domain names that can be used
	// to connect to the website, such as example.com, www.example.com, or m.example.com.
	SubjectAlternativeNames []*string `locationName:"subjectAlternativeNames" type:"list"`

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail load balancer or SSL/TLS certificate. This
	// code enables our support team to look up your Lightsail information more
	// easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s LoadBalancerTlsCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerTlsCertificate) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *LoadBalancerTlsCertificate) SetArn(v string) *LoadBalancerTlsCertificate {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *LoadBalancerTlsCertificate) SetCreatedAt(v time.Time) *LoadBalancerTlsCertificate {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *LoadBalancerTlsCertificate) SetDomainName(v string) *LoadBalancerTlsCertificate {
	s.DomainName = &v
	return s
}

// SetDomainValidationRecords sets the DomainValidationRecords field's value.
func (s *LoadBalancerTlsCertificate) SetDomainValidationRecords(v []*LoadBalancerTlsCertificateDomainValidationRecord) *LoadBalancerTlsCertificate {
	s.DomainValidationRecords = v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *LoadBalancerTlsCertificate) SetFailureReason(v string) *LoadBalancerTlsCertificate {
	s.FailureReason = &v
	return s
}

// SetIsAttached sets the IsAttached field's value.
func (s *LoadBalancerTlsCertificate) SetIsAttached(v bool) *LoadBalancerTlsCertificate {
	s.IsAttached = &v
	return s
}

// SetIssuedAt sets the IssuedAt field's value.
func (s *LoadBalancerTlsCertificate) SetIssuedAt(v time.Time) *LoadBalancerTlsCertificate {
	s.IssuedAt = &v
	return s
}

// SetIssuer sets the Issuer field's value.
func (s *LoadBalancerTlsCertificate) SetIssuer(v string) *LoadBalancerTlsCertificate {
	s.Issuer = &v
	return s
}

// SetKeyAlgorithm sets the KeyAlgorithm field's value.
func (s *LoadBalancerTlsCertificate) SetKeyAlgorithm(v string) *LoadBalancerTlsCertificate {
	s.KeyAlgorithm = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *LoadBalancerTlsCertificate) SetLoadBalancerName(v string) *LoadBalancerTlsCertificate {
	s.LoadBalancerName = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *LoadBalancerTlsCertificate) SetLocation(v *ResourceLocation) *LoadBalancerTlsCertificate {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *LoadBalancerTlsCertificate) SetName(v string) *LoadBalancerTlsCertificate {
	s.Name = &v
	return s
}

// SetNotAfter sets the NotAfter field's value.
func (s *LoadBalancerTlsCertificate) SetNotAfter(v time.Time) *LoadBalancerTlsCertificate {
	s.NotAfter = &v
	return s
}

// SetNotBefore sets the NotBefore field's value.
func (s *LoadBalancerTlsCertificate) SetNotBefore(v time.Time) *LoadBalancerTlsCertificate {
	s.NotBefore = &v
	return s
}

// SetRenewalSummary sets the RenewalSummary field's value.
func (s *LoadBalancerTlsCertificate) SetRenewalSummary(v *LoadBalancerTlsCertificateRenewalSummary) *LoadBalancerTlsCertificate {
	s.RenewalSummary = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *LoadBalancerTlsCertificate) SetResourceType(v string) *LoadBalancerTlsCertificate {
	s.ResourceType = &v
	return s
}

// SetRevocationReason sets the RevocationReason field's value.
func (s *LoadBalancerTlsCertificate) SetRevocationReason(v string) *LoadBalancerTlsCertificate {
	s.RevocationReason = &v
	return s
}

// SetRevokedAt sets the RevokedAt field's value.
func (s *LoadBalancerTlsCertificate) SetRevokedAt(v time.Time) *LoadBalancerTlsCertificate {
	s.RevokedAt = &v
	return s
}

// SetSerial sets the Serial field's value.
func (s *LoadBalancerTlsCertificate) SetSerial(v string) *LoadBalancerTlsCertificate {
	s.Serial = &v
	return s
}

// SetSignatureAlgorithm sets the SignatureAlgorithm field's value.
func (s *LoadBalancerTlsCertificate) SetSignatureAlgorithm(v string) *LoadBalancerTlsCertificate {
	s.SignatureAlgorithm = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LoadBalancerTlsCertificate) SetStatus(v string) *LoadBalancerTlsCertificate {
	s.Status = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *LoadBalancerTlsCertificate) SetSubject(v string) *LoadBalancerTlsCertificate {
	s.Subject = &v
	return s
}

// SetSubjectAlternativeNames sets the SubjectAlternativeNames field's value.
func (s *LoadBalancerTlsCertificate) SetSubjectAlternativeNames(v []*string) *LoadBalancerTlsCertificate {
	s.SubjectAlternativeNames = v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *LoadBalancerTlsCertificate) SetSupportCode(v string) *LoadBalancerTlsCertificate {
	s.SupportCode = &v
	return s
}

// Contains information about the domain names on an SSL/TLS certificate that
// you will use to validate domain ownership.
type LoadBalancerTlsCertificateDomainValidationOption struct {
	_ struct{} `type:"structure"`

	// The fully qualified domain name in the certificate request.
	DomainName *string `locationName:"domainName" type:"string"`

	// The status of the domain validation. Valid values are listed below.
	ValidationStatus *string `locationName:"validationStatus" type:"string" enum:"LoadBalancerTlsCertificateDomainStatus"`
}

// String returns the string representation
func (s LoadBalancerTlsCertificateDomainValidationOption) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerTlsCertificateDomainValidationOption) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *LoadBalancerTlsCertificateDomainValidationOption) SetDomainName(v string) *LoadBalancerTlsCertificateDomainValidationOption {
	s.DomainName = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *LoadBalancerTlsCertificateDomainValidationOption) SetValidationStatus(v string) *LoadBalancerTlsCertificateDomainValidationOption {
	s.ValidationStatus = &v
	return s
}

// Describes the validation record of each domain name in the SSL/TLS certificate.
type LoadBalancerTlsCertificateDomainValidationRecord struct {
	_ struct{} `type:"structure"`

	// The domain name against which your SSL/TLS certificate was validated.
	DomainName *string `locationName:"domainName" type:"string"`

	// A fully qualified domain name in the certificate. For example, example.com.
	Name *string `locationName:"name" type:"string"`

	// The type of validation record. For example, CNAME for domain validation.
	Type *string `locationName:"type" type:"string"`

	// The validation status. Valid values are listed below.
	ValidationStatus *string `locationName:"validationStatus" type:"string" enum:"LoadBalancerTlsCertificateDomainStatus"`

	// The value for that type.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s LoadBalancerTlsCertificateDomainValidationRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerTlsCertificateDomainValidationRecord) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *LoadBalancerTlsCertificateDomainValidationRecord) SetDomainName(v string) *LoadBalancerTlsCertificateDomainValidationRecord {
	s.DomainName = &v
	return s
}

// SetName sets the Name field's value.
func (s *LoadBalancerTlsCertificateDomainValidationRecord) SetName(v string) *LoadBalancerTlsCertificateDomainValidationRecord {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *LoadBalancerTlsCertificateDomainValidationRecord) SetType(v string) *LoadBalancerTlsCertificateDomainValidationRecord {
	s.Type = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *LoadBalancerTlsCertificateDomainValidationRecord) SetValidationStatus(v string) *LoadBalancerTlsCertificateDomainValidationRecord {
	s.ValidationStatus = &v
	return s
}

// SetValue sets the Value field's value.
func (s *LoadBalancerTlsCertificateDomainValidationRecord) SetValue(v string) *LoadBalancerTlsCertificateDomainValidationRecord {
	s.Value = &v
	return s
}

// Contains information about the status of Lightsail's managed renewal for
// the certificate.
type LoadBalancerTlsCertificateRenewalSummary struct {
	_ struct{} `type:"structure"`

	// Contains information about the validation of each domain name in the certificate,
	// as it pertains to Lightsail's managed renewal. This is different from the
	// initial validation that occurs as a result of the RequestCertificate request.
	DomainValidationOptions []*LoadBalancerTlsCertificateDomainValidationOption `locationName:"domainValidationOptions" type:"list"`

	// The status of Lightsail's managed renewal of the certificate. Valid values
	// are listed below.
	RenewalStatus *string `locationName:"renewalStatus" type:"string" enum:"LoadBalancerTlsCertificateRenewalStatus"`
}

// String returns the string representation
func (s LoadBalancerTlsCertificateRenewalSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerTlsCertificateRenewalSummary) GoString() string {
	return s.String()
}

// SetDomainValidationOptions sets the DomainValidationOptions field's value.
func (s *LoadBalancerTlsCertificateRenewalSummary) SetDomainValidationOptions(v []*LoadBalancerTlsCertificateDomainValidationOption) *LoadBalancerTlsCertificateRenewalSummary {
	s.DomainValidationOptions = v
	return s
}

// SetRenewalStatus sets the RenewalStatus field's value.
func (s *LoadBalancerTlsCertificateRenewalSummary) SetRenewalStatus(v string) *LoadBalancerTlsCertificateRenewalSummary {
	s.RenewalStatus = &v
	return s
}

// Provides a summary of SSL/TLS certificate metadata.
type LoadBalancerTlsCertificateSummary struct {
	_ struct{} `type:"structure"`

	// When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
	IsAttached *bool `locationName:"isAttached" type:"boolean"`

	// The name of the SSL/TLS certificate.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s LoadBalancerTlsCertificateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerTlsCertificateSummary) GoString() string {
	return s.String()
}

// SetIsAttached sets the IsAttached field's value.
func (s *LoadBalancerTlsCertificateSummary) SetIsAttached(v bool) *LoadBalancerTlsCertificateSummary {
	s.IsAttached = &v
	return s
}

// SetName sets the Name field's value.
func (s *LoadBalancerTlsCertificateSummary) SetName(v string) *LoadBalancerTlsCertificateSummary {
	s.Name = &v
	return s
}

// Describes a database log event.
type LogEvent struct {
	_ struct{} `type:"structure"`

	// The timestamp when the database log event was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The message of the database log event.
	Message *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LogEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogEvent) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *LogEvent) SetCreatedAt(v time.Time) *LogEvent {
	s.CreatedAt = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *LogEvent) SetMessage(v string) *LogEvent {
	s.Message = &v
	return s
}

// Describes the metric data point.
type MetricDatapoint struct {
	_ struct{} `type:"structure"`

	// The average.
	Average *float64 `locationName:"average" type:"double"`

	// The maximum.
	Maximum *float64 `locationName:"maximum" type:"double"`

	// The minimum.
	Minimum *float64 `locationName:"minimum" type:"double"`

	// The sample count.
	SampleCount *float64 `locationName:"sampleCount" type:"double"`

	// The sum.
	Sum *float64 `locationName:"sum" type:"double"`

	// The timestamp (e.g., 1479816991.349).
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp"`

	// The unit.
	Unit *string `locationName:"unit" type:"string" enum:"MetricUnit"`
}

// String returns the string representation
func (s MetricDatapoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricDatapoint) GoString() string {
	return s.String()
}

// SetAverage sets the Average field's value.
func (s *MetricDatapoint) SetAverage(v float64) *MetricDatapoint {
	s.Average = &v
	return s
}

// SetMaximum sets the Maximum field's value.
func (s *MetricDatapoint) SetMaximum(v float64) *MetricDatapoint {
	s.Maximum = &v
	return s
}

// SetMinimum sets the Minimum field's value.
func (s *MetricDatapoint) SetMinimum(v float64) *MetricDatapoint {
	s.Minimum = &v
	return s
}

// SetSampleCount sets the SampleCount field's value.
func (s *MetricDatapoint) SetSampleCount(v float64) *MetricDatapoint {
	s.SampleCount = &v
	return s
}

// SetSum sets the Sum field's value.
func (s *MetricDatapoint) SetSum(v float64) *MetricDatapoint {
	s.Sum = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *MetricDatapoint) SetTimestamp(v time.Time) *MetricDatapoint {
	s.Timestamp = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *MetricDatapoint) SetUnit(v string) *MetricDatapoint {
	s.Unit = &v
	return s
}

// Describes the monthly data transfer in and out of your virtual private server
// (or instance).
type MonthlyTransfer struct {
	_ struct{} `type:"structure"`

	// The amount allocated per month (in GB).
	GbPerMonthAllocated *int64 `locationName:"gbPerMonthAllocated" type:"integer"`
}

// String returns the string representation
func (s MonthlyTransfer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MonthlyTransfer) GoString() string {
	return s.String()
}

// SetGbPerMonthAllocated sets the GbPerMonthAllocated field's value.
func (s *MonthlyTransfer) SetGbPerMonthAllocated(v int64) *MonthlyTransfer {
	s.GbPerMonthAllocated = &v
	return s
}

type OpenInstancePublicPortsInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance for which you want to open the public ports.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// An array of key-value pairs containing information about the port mappings.
	//
	// PortInfo is a required field
	PortInfo *PortInfo `locationName:"portInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s OpenInstancePublicPortsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenInstancePublicPortsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenInstancePublicPortsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenInstancePublicPortsInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.PortInfo == nil {
		invalidParams.Add(request.NewErrParamRequired("PortInfo"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *OpenInstancePublicPortsInput) SetInstanceName(v string) *OpenInstancePublicPortsInput {
	s.InstanceName = &v
	return s
}

// SetPortInfo sets the PortInfo field's value.
func (s *OpenInstancePublicPortsInput) SetPortInfo(v *PortInfo) *OpenInstancePublicPortsInput {
	s.PortInfo = v
	return s
}

type OpenInstancePublicPortsOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s OpenInstancePublicPortsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenInstancePublicPortsOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *OpenInstancePublicPortsOutput) SetOperation(v *Operation) *OpenInstancePublicPortsOutput {
	s.Operation = v
	return s
}

// Describes the API operation.
type Operation struct {
	_ struct{} `type:"structure"`

	// The timestamp when the operation was initialized (e.g., 1479816991.349).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The error code.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The error details.
	ErrorDetails *string `locationName:"errorDetails" type:"string"`

	// The ID of the operation.
	Id *string `locationName:"id" type:"string"`

	// A Boolean value indicating whether the operation is terminal.
	IsTerminal *bool `locationName:"isTerminal" type:"boolean"`

	// The region and Availability Zone.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// Details about the operation (e.g., Debian-1GB-Ohio-1).
	OperationDetails *string `locationName:"operationDetails" type:"string"`

	// The type of operation.
	OperationType *string `locationName:"operationType" type:"string" enum:"OperationType"`

	// The resource name.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The resource type.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The status of the operation.
	Status *string `locationName:"status" type:"string" enum:"OperationStatus"`

	// The timestamp when the status was changed (e.g., 1479816991.349).
	StatusChangedAt *time.Time `locationName:"statusChangedAt" type:"timestamp"`
}

// String returns the string representation
func (s Operation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Operation) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Operation) SetCreatedAt(v time.Time) *Operation {
	s.CreatedAt = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Operation) SetErrorCode(v string) *Operation {
	s.ErrorCode = &v
	return s
}

// SetErrorDetails sets the ErrorDetails field's value.
func (s *Operation) SetErrorDetails(v string) *Operation {
	s.ErrorDetails = &v
	return s
}

// SetId sets the Id field's value.
func (s *Operation) SetId(v string) *Operation {
	s.Id = &v
	return s
}

// SetIsTerminal sets the IsTerminal field's value.
func (s *Operation) SetIsTerminal(v bool) *Operation {
	s.IsTerminal = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *Operation) SetLocation(v *ResourceLocation) *Operation {
	s.Location = v
	return s
}

// SetOperationDetails sets the OperationDetails field's value.
func (s *Operation) SetOperationDetails(v string) *Operation {
	s.OperationDetails = &v
	return s
}

// SetOperationType sets the OperationType field's value.
func (s *Operation) SetOperationType(v string) *Operation {
	s.OperationType = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *Operation) SetResourceName(v string) *Operation {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Operation) SetResourceType(v string) *Operation {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Operation) SetStatus(v string) *Operation {
	s.Status = &v
	return s
}

// SetStatusChangedAt sets the StatusChangedAt field's value.
func (s *Operation) SetStatusChangedAt(v time.Time) *Operation {
	s.StatusChangedAt = &v
	return s
}

// The password data for the Windows Server-based instance, including the ciphertext
// and the key pair name.
type PasswordData struct {
	_ struct{} `type:"structure"`

	// The encrypted password. Ciphertext will be an empty string if access to your
	// new instance is not ready yet. When you create an instance, it can take up
	// to 15 minutes for the instance to be ready.
	//
	// If you use the default key pair (LightsailDefaultKeyPair), the decrypted
	// password will be available in the password field.
	//
	// If you are using a custom key pair, you need to use your own means of decryption.
	//
	// If you change the Administrator password on the instance, Lightsail will
	// continue to return the original ciphertext value. When accessing the instance
	// using RDP, you need to manually enter the Administrator password after changing
	// it from the default.
	Ciphertext *string `locationName:"ciphertext" type:"string"`

	// The name of the key pair that you used when creating your instance. If no
	// key pair name was specified when creating the instance, Lightsail uses the
	// default key pair (LightsailDefaultKeyPair).
	//
	// If you are using a custom key pair, you need to use your own means of decrypting
	// your password using the ciphertext. Lightsail creates the ciphertext by encrypting
	// your password with the public key part of this key pair.
	KeyPairName *string `locationName:"keyPairName" type:"string"`
}

// String returns the string representation
func (s PasswordData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PasswordData) GoString() string {
	return s.String()
}

// SetCiphertext sets the Ciphertext field's value.
func (s *PasswordData) SetCiphertext(v string) *PasswordData {
	s.Ciphertext = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *PasswordData) SetKeyPairName(v string) *PasswordData {
	s.KeyPairName = &v
	return s
}

type PeerVpcInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PeerVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PeerVpcInput) GoString() string {
	return s.String()
}

type PeerVpcOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s PeerVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PeerVpcOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *PeerVpcOutput) SetOperation(v *Operation) *PeerVpcOutput {
	s.Operation = v
	return s
}

// Describes a pending database maintenance action.
type PendingMaintenanceAction struct {
	_ struct{} `type:"structure"`

	// The type of pending database maintenance action.
	Action *string `locationName:"action" type:"string"`

	// The effective date of the pending database maintenance action.
	CurrentApplyDate *time.Time `locationName:"currentApplyDate" type:"timestamp"`

	// Additional detail about the pending database maintenance action.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s PendingMaintenanceAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingMaintenanceAction) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *PendingMaintenanceAction) SetAction(v string) *PendingMaintenanceAction {
	s.Action = &v
	return s
}

// SetCurrentApplyDate sets the CurrentApplyDate field's value.
func (s *PendingMaintenanceAction) SetCurrentApplyDate(v time.Time) *PendingMaintenanceAction {
	s.CurrentApplyDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PendingMaintenanceAction) SetDescription(v string) *PendingMaintenanceAction {
	s.Description = &v
	return s
}

// Describes a pending database value modification.
type PendingModifiedRelationalDatabaseValues struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether automated backup retention is enabled.
	BackupRetentionEnabled *bool `locationName:"backupRetentionEnabled" type:"boolean"`

	// The database engine version.
	EngineVersion *string `locationName:"engineVersion" type:"string"`

	// The password for the master user of the database.
	MasterUserPassword *string `locationName:"masterUserPassword" type:"string"`
}

// String returns the string representation
func (s PendingModifiedRelationalDatabaseValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingModifiedRelationalDatabaseValues) GoString() string {
	return s.String()
}

// SetBackupRetentionEnabled sets the BackupRetentionEnabled field's value.
func (s *PendingModifiedRelationalDatabaseValues) SetBackupRetentionEnabled(v bool) *PendingModifiedRelationalDatabaseValues {
	s.BackupRetentionEnabled = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *PendingModifiedRelationalDatabaseValues) SetEngineVersion(v string) *PendingModifiedRelationalDatabaseValues {
	s.EngineVersion = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *PendingModifiedRelationalDatabaseValues) SetMasterUserPassword(v string) *PendingModifiedRelationalDatabaseValues {
	s.MasterUserPassword = &v
	return s
}

// Describes information about the ports on your virtual private server (or
// instance).
type PortInfo struct {
	_ struct{} `type:"structure"`

	// The first port in the range.
	FromPort *int64 `locationName:"fromPort" type:"integer"`

	// The protocol.
	Protocol *string `locationName:"protocol" type:"string" enum:"NetworkProtocol"`

	// The last port in the range.
	ToPort *int64 `locationName:"toPort" type:"integer"`
}

// String returns the string representation
func (s PortInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortInfo) GoString() string {
	return s.String()
}

// SetFromPort sets the FromPort field's value.
func (s *PortInfo) SetFromPort(v int64) *PortInfo {
	s.FromPort = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *PortInfo) SetProtocol(v string) *PortInfo {
	s.Protocol = &v
	return s
}

// SetToPort sets the ToPort field's value.
func (s *PortInfo) SetToPort(v int64) *PortInfo {
	s.ToPort = &v
	return s
}

type PutInstancePublicPortsInput struct {
	_ struct{} `type:"structure"`

	// The Lightsail instance name of the public port(s) you are setting.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// Specifies information about the public port(s).
	//
	// PortInfos is a required field
	PortInfos []*PortInfo `locationName:"portInfos" type:"list" required:"true"`
}

// String returns the string representation
func (s PutInstancePublicPortsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutInstancePublicPortsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutInstancePublicPortsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutInstancePublicPortsInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.PortInfos == nil {
		invalidParams.Add(request.NewErrParamRequired("PortInfos"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *PutInstancePublicPortsInput) SetInstanceName(v string) *PutInstancePublicPortsInput {
	s.InstanceName = &v
	return s
}

// SetPortInfos sets the PortInfos field's value.
func (s *PutInstancePublicPortsInput) SetPortInfos(v []*PortInfo) *PutInstancePublicPortsInput {
	s.PortInfos = v
	return s
}

type PutInstancePublicPortsOutput struct {
	_ struct{} `type:"structure"`

	// Describes metadata about the operation you just executed.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s PutInstancePublicPortsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutInstancePublicPortsOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *PutInstancePublicPortsOutput) SetOperation(v *Operation) *PutInstancePublicPortsOutput {
	s.Operation = v
	return s
}

type RebootInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to reboot.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s RebootInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *RebootInstanceInput) SetInstanceName(v string) *RebootInstanceInput {
	s.InstanceName = &v
	return s
}

type RebootInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s RebootInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootInstanceOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *RebootInstanceOutput) SetOperations(v []*Operation) *RebootInstanceOutput {
	s.Operations = v
	return s
}

type RebootRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of your database to reboot.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s RebootRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootRelationalDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootRelationalDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootRelationalDatabaseInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *RebootRelationalDatabaseInput) SetRelationalDatabaseName(v string) *RebootRelationalDatabaseInput {
	s.RelationalDatabaseName = &v
	return s
}

type RebootRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your reboot relational database request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s RebootRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootRelationalDatabaseOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *RebootRelationalDatabaseOutput) SetOperations(v []*Operation) *RebootRelationalDatabaseOutput {
	s.Operations = v
	return s
}

// Describes the AWS Region.
type Region struct {
	_ struct{} `type:"structure"`

	// The Availability Zones. Follows the format us-east-2a (case-sensitive).
	AvailabilityZones []*AvailabilityZone `locationName:"availabilityZones" type:"list"`

	// The continent code (e.g., NA, meaning North America).
	ContinentCode *string `locationName:"continentCode" type:"string"`

	// The description of the AWS Region (e.g., This region is recommended to serve
	// users in the eastern United States and eastern Canada).
	Description *string `locationName:"description" type:"string"`

	// The display name (e.g., Ohio).
	DisplayName *string `locationName:"displayName" type:"string"`

	// The region name (e.g., us-east-2).
	Name *string `locationName:"name" type:"string" enum:"RegionName"`

	// The Availability Zones for databases. Follows the format us-east-2a (case-sensitive).
	RelationalDatabaseAvailabilityZones []*AvailabilityZone `locationName:"relationalDatabaseAvailabilityZones" type:"list"`
}

// String returns the string representation
func (s Region) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Region) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *Region) SetAvailabilityZones(v []*AvailabilityZone) *Region {
	s.AvailabilityZones = v
	return s
}

// SetContinentCode sets the ContinentCode field's value.
func (s *Region) SetContinentCode(v string) *Region {
	s.ContinentCode = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Region) SetDescription(v string) *Region {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Region) SetDisplayName(v string) *Region {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *Region) SetName(v string) *Region {
	s.Name = &v
	return s
}

// SetRelationalDatabaseAvailabilityZones sets the RelationalDatabaseAvailabilityZones field's value.
func (s *Region) SetRelationalDatabaseAvailabilityZones(v []*AvailabilityZone) *Region {
	s.RelationalDatabaseAvailabilityZones = v
	return s
}

// Describes a database.
type RelationalDatabase struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the database.
	Arn *string `locationName:"arn" type:"string"`

	// A Boolean value indicating whether automated backup retention is enabled
	// for the database.
	BackupRetentionEnabled *bool `locationName:"backupRetentionEnabled" type:"boolean"`

	// The timestamp when the database was created. Formatted in Unix time.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The database software (for example, MySQL).
	Engine *string `locationName:"engine" type:"string"`

	// The database engine version (for example, 5.7.23).
	EngineVersion *string `locationName:"engineVersion" type:"string"`

	// Describes the hardware of the database.
	Hardware *RelationalDatabaseHardware `locationName:"hardware" type:"structure"`

	// The latest point in time to which the database can be restored. Formatted
	// in Unix time.
	LatestRestorableTime *time.Time `locationName:"latestRestorableTime" type:"timestamp"`

	// The Region name and Availability Zone where the database is located.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the master database created when the Lightsail database resource
	// is created.
	MasterDatabaseName *string `locationName:"masterDatabaseName" type:"string"`

	// The master endpoint for the database.
	MasterEndpoint *RelationalDatabaseEndpoint `locationName:"masterEndpoint" type:"structure"`

	// The master user name of the database.
	MasterUsername *string `locationName:"masterUsername" type:"string"`

	// The unique name of the database resource in Lightsail.
	Name *string `locationName:"name" type:"string"`

	// The status of parameter updates for the database.
	ParameterApplyStatus *string `locationName:"parameterApplyStatus" type:"string"`

	// Describes the pending maintenance actions for the database.
	PendingMaintenanceActions []*PendingMaintenanceAction `locationName:"pendingMaintenanceActions" type:"list"`

	// Describes pending database value modifications.
	PendingModifiedValues *PendingModifiedRelationalDatabaseValues `locationName:"pendingModifiedValues" type:"structure"`

	// The daily time range during which automated backups are created for the database
	// (for example, 16:00-16:30).
	PreferredBackupWindow *string `locationName:"preferredBackupWindow" type:"string"`

	// The weekly time range during which system maintenance can occur on the database.
	//
	// In the format ddd:hh24:mi-ddd:hh24:mi. For example, Tue:17:00-Tue:17:30.
	PreferredMaintenanceWindow *string `locationName:"preferredMaintenanceWindow" type:"string"`

	// A Boolean value indicating whether the database is publicly accessible.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The blueprint ID for the database. A blueprint describes the major engine
	// version of a database.
	RelationalDatabaseBlueprintId *string `locationName:"relationalDatabaseBlueprintId" type:"string"`

	// The bundle ID for the database. A bundle describes the performance specifications
	// for your database.
	RelationalDatabaseBundleId *string `locationName:"relationalDatabaseBundleId" type:"string"`

	// The Lightsail resource type for the database (for example, RelationalDatabase).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// Describes the secondary Availability Zone of a high availability database.
	//
	// The secondary database is used for failover support of a high availability
	// database.
	SecondaryAvailabilityZone *string `locationName:"secondaryAvailabilityZone" type:"string"`

	// Describes the current state of the database.
	State *string `locationName:"state" type:"string"`

	// The support code for the database. Include this code in your email to support
	// when you have questions about a database in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s RelationalDatabase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelationalDatabase) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RelationalDatabase) SetArn(v string) *RelationalDatabase {
	s.Arn = &v
	return s
}

// SetBackupRetentionEnabled sets the BackupRetentionEnabled field's value.
func (s *RelationalDatabase) SetBackupRetentionEnabled(v bool) *RelationalDatabase {
	s.BackupRetentionEnabled = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RelationalDatabase) SetCreatedAt(v time.Time) *RelationalDatabase {
	s.CreatedAt = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *RelationalDatabase) SetEngine(v string) *RelationalDatabase {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *RelationalDatabase) SetEngineVersion(v string) *RelationalDatabase {
	s.EngineVersion = &v
	return s
}

// SetHardware sets the Hardware field's value.
func (s *RelationalDatabase) SetHardware(v *RelationalDatabaseHardware) *RelationalDatabase {
	s.Hardware = v
	return s
}

// SetLatestRestorableTime sets the LatestRestorableTime field's value.
func (s *RelationalDatabase) SetLatestRestorableTime(v time.Time) *RelationalDatabase {
	s.LatestRestorableTime = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *RelationalDatabase) SetLocation(v *ResourceLocation) *RelationalDatabase {
	s.Location = v
	return s
}

// SetMasterDatabaseName sets the MasterDatabaseName field's value.
func (s *RelationalDatabase) SetMasterDatabaseName(v string) *RelationalDatabase {
	s.MasterDatabaseName = &v
	return s
}

// SetMasterEndpoint sets the MasterEndpoint field's value.
func (s *RelationalDatabase) SetMasterEndpoint(v *RelationalDatabaseEndpoint) *RelationalDatabase {
	s.MasterEndpoint = v
	return s
}

// SetMasterUsername sets the MasterUsername field's value.
func (s *RelationalDatabase) SetMasterUsername(v string) *RelationalDatabase {
	s.MasterUsername = &v
	return s
}

// SetName sets the Name field's value.
func (s *RelationalDatabase) SetName(v string) *RelationalDatabase {
	s.Name = &v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *RelationalDatabase) SetParameterApplyStatus(v string) *RelationalDatabase {
	s.ParameterApplyStatus = &v
	return s
}

// SetPendingMaintenanceActions sets the PendingMaintenanceActions field's value.
func (s *RelationalDatabase) SetPendingMaintenanceActions(v []*PendingMaintenanceAction) *RelationalDatabase {
	s.PendingMaintenanceActions = v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *RelationalDatabase) SetPendingModifiedValues(v *PendingModifiedRelationalDatabaseValues) *RelationalDatabase {
	s.PendingModifiedValues = v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *RelationalDatabase) SetPreferredBackupWindow(v string) *RelationalDatabase {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *RelationalDatabase) SetPreferredMaintenanceWindow(v string) *RelationalDatabase {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *RelationalDatabase) SetPubliclyAccessible(v bool) *RelationalDatabase {
	s.PubliclyAccessible = &v
	return s
}

// SetRelationalDatabaseBlueprintId sets the RelationalDatabaseBlueprintId field's value.
func (s *RelationalDatabase) SetRelationalDatabaseBlueprintId(v string) *RelationalDatabase {
	s.RelationalDatabaseBlueprintId = &v
	return s
}

// SetRelationalDatabaseBundleId sets the RelationalDatabaseBundleId field's value.
func (s *RelationalDatabase) SetRelationalDatabaseBundleId(v string) *RelationalDatabase {
	s.RelationalDatabaseBundleId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *RelationalDatabase) SetResourceType(v string) *RelationalDatabase {
	s.ResourceType = &v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *RelationalDatabase) SetSecondaryAvailabilityZone(v string) *RelationalDatabase {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetState sets the State field's value.
func (s *RelationalDatabase) SetState(v string) *RelationalDatabase {
	s.State = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *RelationalDatabase) SetSupportCode(v string) *RelationalDatabase {
	s.SupportCode = &v
	return s
}

// Describes a database image, or blueprint. A blueprint describes the major
// engine version of a database.
type RelationalDatabaseBlueprint struct {
	_ struct{} `type:"structure"`

	// The ID for the database blueprint.
	BlueprintId *string `locationName:"blueprintId" type:"string"`

	// The database software of the database blueprint (for example, MySQL).
	Engine *string `locationName:"engine" type:"string" enum:"RelationalDatabaseEngine"`

	// The description of the database engine for the database blueprint.
	EngineDescription *string `locationName:"engineDescription" type:"string"`

	// The database engine version for the database blueprint (for example, 5.7.23).
	EngineVersion *string `locationName:"engineVersion" type:"string"`

	// The description of the database engine version for the database blueprint.
	EngineVersionDescription *string `locationName:"engineVersionDescription" type:"string"`

	// A Boolean value indicating whether the engine version is the default for
	// the database blueprint.
	IsEngineDefault *bool `locationName:"isEngineDefault" type:"boolean"`
}

// String returns the string representation
func (s RelationalDatabaseBlueprint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelationalDatabaseBlueprint) GoString() string {
	return s.String()
}

// SetBlueprintId sets the BlueprintId field's value.
func (s *RelationalDatabaseBlueprint) SetBlueprintId(v string) *RelationalDatabaseBlueprint {
	s.BlueprintId = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *RelationalDatabaseBlueprint) SetEngine(v string) *RelationalDatabaseBlueprint {
	s.Engine = &v
	return s
}

// SetEngineDescription sets the EngineDescription field's value.
func (s *RelationalDatabaseBlueprint) SetEngineDescription(v string) *RelationalDatabaseBlueprint {
	s.EngineDescription = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *RelationalDatabaseBlueprint) SetEngineVersion(v string) *RelationalDatabaseBlueprint {
	s.EngineVersion = &v
	return s
}

// SetEngineVersionDescription sets the EngineVersionDescription field's value.
func (s *RelationalDatabaseBlueprint) SetEngineVersionDescription(v string) *RelationalDatabaseBlueprint {
	s.EngineVersionDescription = &v
	return s
}

// SetIsEngineDefault sets the IsEngineDefault field's value.
func (s *RelationalDatabaseBlueprint) SetIsEngineDefault(v bool) *RelationalDatabaseBlueprint {
	s.IsEngineDefault = &v
	return s
}

// Describes a database bundle. A bundle describes the performance specifications
// of the database.
type RelationalDatabaseBundle struct {
	_ struct{} `type:"structure"`

	// The ID for the database bundle.
	BundleId *string `locationName:"bundleId" type:"string"`

	// The number of virtual CPUs (vCPUs) for the database bundle.
	CpuCount *int64 `locationName:"cpuCount" type:"integer"`

	// The size of the disk for the database bundle.
	DiskSizeInGb *int64 `locationName:"diskSizeInGb" type:"integer"`

	// A Boolean value indicating whether the database bundle is active.
	IsActive *bool `locationName:"isActive" type:"boolean"`

	// A Boolean value indicating whether the database bundle is encrypted.
	IsEncrypted *bool `locationName:"isEncrypted" type:"boolean"`

	// The name for the database bundle.
	Name *string `locationName:"name" type:"string"`

	// The cost of the database bundle in US currency.
	Price *float64 `locationName:"price" type:"float"`

	// The amount of RAM in GB (for example, 2.0) for the database bundle.
	RamSizeInGb *float64 `locationName:"ramSizeInGb" type:"float"`

	// The data transfer rate per month in GB for the database bundle.
	TransferPerMonthInGb *int64 `locationName:"transferPerMonthInGb" type:"integer"`
}

// String returns the string representation
func (s RelationalDatabaseBundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelationalDatabaseBundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *RelationalDatabaseBundle) SetBundleId(v string) *RelationalDatabaseBundle {
	s.BundleId = &v
	return s
}

// SetCpuCount sets the CpuCount field's value.
func (s *RelationalDatabaseBundle) SetCpuCount(v int64) *RelationalDatabaseBundle {
	s.CpuCount = &v
	return s
}

// SetDiskSizeInGb sets the DiskSizeInGb field's value.
func (s *RelationalDatabaseBundle) SetDiskSizeInGb(v int64) *RelationalDatabaseBundle {
	s.DiskSizeInGb = &v
	return s
}

// SetIsActive sets the IsActive field's value.
func (s *RelationalDatabaseBundle) SetIsActive(v bool) *RelationalDatabaseBundle {
	s.IsActive = &v
	return s
}

// SetIsEncrypted sets the IsEncrypted field's value.
func (s *RelationalDatabaseBundle) SetIsEncrypted(v bool) *RelationalDatabaseBundle {
	s.IsEncrypted = &v
	return s
}

// SetName sets the Name field's value.
func (s *RelationalDatabaseBundle) SetName(v string) *RelationalDatabaseBundle {
	s.Name = &v
	return s
}

// SetPrice sets the Price field's value.
func (s *RelationalDatabaseBundle) SetPrice(v float64) *RelationalDatabaseBundle {
	s.Price = &v
	return s
}

// SetRamSizeInGb sets the RamSizeInGb field's value.
func (s *RelationalDatabaseBundle) SetRamSizeInGb(v float64) *RelationalDatabaseBundle {
	s.RamSizeInGb = &v
	return s
}

// SetTransferPerMonthInGb sets the TransferPerMonthInGb field's value.
func (s *RelationalDatabaseBundle) SetTransferPerMonthInGb(v int64) *RelationalDatabaseBundle {
	s.TransferPerMonthInGb = &v
	return s
}

// Describes an endpoint for a database.
type RelationalDatabaseEndpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the database.
	Address *string `locationName:"address" type:"string"`

	// Specifies the port that the database is listening on.
	Port *int64 `locationName:"port" type:"integer"`
}

// String returns the string representation
func (s RelationalDatabaseEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelationalDatabaseEndpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *RelationalDatabaseEndpoint) SetAddress(v string) *RelationalDatabaseEndpoint {
	s.Address = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RelationalDatabaseEndpoint) SetPort(v int64) *RelationalDatabaseEndpoint {
	s.Port = &v
	return s
}

// Describes an event for a database.
type RelationalDatabaseEvent struct {
	_ struct{} `type:"structure"`

	// The timestamp when the database event was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The category that the database event belongs to.
	EventCategories []*string `locationName:"eventCategories" type:"list"`

	// The message of the database event.
	Message *string `locationName:"message" type:"string"`

	// The database that the database event relates to.
	Resource *string `locationName:"resource" type:"string"`
}

// String returns the string representation
func (s RelationalDatabaseEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelationalDatabaseEvent) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RelationalDatabaseEvent) SetCreatedAt(v time.Time) *RelationalDatabaseEvent {
	s.CreatedAt = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *RelationalDatabaseEvent) SetEventCategories(v []*string) *RelationalDatabaseEvent {
	s.EventCategories = v
	return s
}

// SetMessage sets the Message field's value.
func (s *RelationalDatabaseEvent) SetMessage(v string) *RelationalDatabaseEvent {
	s.Message = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *RelationalDatabaseEvent) SetResource(v string) *RelationalDatabaseEvent {
	s.Resource = &v
	return s
}

// Describes the hardware of a database.
type RelationalDatabaseHardware struct {
	_ struct{} `type:"structure"`

	// The number of vCPUs for the database.
	CpuCount *int64 `locationName:"cpuCount" type:"integer"`

	// The size of the disk for the database.
	DiskSizeInGb *int64 `locationName:"diskSizeInGb" type:"integer"`

	// The amount of RAM in GB for the database.
	RamSizeInGb *float64 `locationName:"ramSizeInGb" type:"float"`
}

// String returns the string representation
func (s RelationalDatabaseHardware) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelationalDatabaseHardware) GoString() string {
	return s.String()
}

// SetCpuCount sets the CpuCount field's value.
func (s *RelationalDatabaseHardware) SetCpuCount(v int64) *RelationalDatabaseHardware {
	s.CpuCount = &v
	return s
}

// SetDiskSizeInGb sets the DiskSizeInGb field's value.
func (s *RelationalDatabaseHardware) SetDiskSizeInGb(v int64) *RelationalDatabaseHardware {
	s.DiskSizeInGb = &v
	return s
}

// SetRamSizeInGb sets the RamSizeInGb field's value.
func (s *RelationalDatabaseHardware) SetRamSizeInGb(v float64) *RelationalDatabaseHardware {
	s.RamSizeInGb = &v
	return s
}

// Describes the parameters of a database.
type RelationalDatabaseParameter struct {
	_ struct{} `type:"structure"`

	// Specifies the valid range of values for the parameter.
	AllowedValues *string `locationName:"allowedValues" type:"string"`

	// Indicates when parameter updates are applied.
	//
	// Can be immediate or pending-reboot.
	ApplyMethod *string `locationName:"applyMethod" type:"string"`

	// Specifies the engine-specific parameter type.
	ApplyType *string `locationName:"applyType" type:"string"`

	// Specifies the valid data type for the parameter.
	DataType *string `locationName:"dataType" type:"string"`

	// Provides a description of the parameter.
	Description *string `locationName:"description" type:"string"`

	// A Boolean value indicating whether the parameter can be modified.
	IsModifiable *bool `locationName:"isModifiable" type:"boolean"`

	// Specifies the name of the parameter.
	ParameterName *string `locationName:"parameterName" type:"string"`

	// Specifies the value of the parameter.
	ParameterValue *string `locationName:"parameterValue" type:"string"`
}

// String returns the string representation
func (s RelationalDatabaseParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelationalDatabaseParameter) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *RelationalDatabaseParameter) SetAllowedValues(v string) *RelationalDatabaseParameter {
	s.AllowedValues = &v
	return s
}

// SetApplyMethod sets the ApplyMethod field's value.
func (s *RelationalDatabaseParameter) SetApplyMethod(v string) *RelationalDatabaseParameter {
	s.ApplyMethod = &v
	return s
}

// SetApplyType sets the ApplyType field's value.
func (s *RelationalDatabaseParameter) SetApplyType(v string) *RelationalDatabaseParameter {
	s.ApplyType = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *RelationalDatabaseParameter) SetDataType(v string) *RelationalDatabaseParameter {
	s.DataType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RelationalDatabaseParameter) SetDescription(v string) *RelationalDatabaseParameter {
	s.Description = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *RelationalDatabaseParameter) SetIsModifiable(v bool) *RelationalDatabaseParameter {
	s.IsModifiable = &v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *RelationalDatabaseParameter) SetParameterName(v string) *RelationalDatabaseParameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *RelationalDatabaseParameter) SetParameterValue(v string) *RelationalDatabaseParameter {
	s.ParameterValue = &v
	return s
}

// Describes a database snapshot.
type RelationalDatabaseSnapshot struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the database snapshot.
	Arn *string `locationName:"arn" type:"string"`

	// The timestamp when the database snapshot was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The software of the database snapshot (for example, MySQL)
	Engine *string `locationName:"engine" type:"string"`

	// The database engine version for the database snapshot (for example, 5.7.23).
	EngineVersion *string `locationName:"engineVersion" type:"string"`

	// The Amazon Resource Name (ARN) of the database from which the database snapshot
	// was created.
	FromRelationalDatabaseArn *string `locationName:"fromRelationalDatabaseArn" type:"string"`

	// The blueprint ID of the database from which the database snapshot was created.
	// A blueprint describes the major engine version of a database.
	FromRelationalDatabaseBlueprintId *string `locationName:"fromRelationalDatabaseBlueprintId" type:"string"`

	// The bundle ID of the database from which the database snapshot was created.
	FromRelationalDatabaseBundleId *string `locationName:"fromRelationalDatabaseBundleId" type:"string"`

	// The name of the source database from which the database snapshot was created.
	FromRelationalDatabaseName *string `locationName:"fromRelationalDatabaseName" type:"string"`

	// The Region name and Availability Zone where the database snapshot is located.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the database snapshot.
	Name *string `locationName:"name" type:"string"`

	// The Lightsail resource type.
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The size of the disk in GB (for example, 32) for the database snapshot.
	SizeInGb *int64 `locationName:"sizeInGb" type:"integer"`

	// The state of the database snapshot.
	State *string `locationName:"state" type:"string"`

	// The support code for the database snapshot. Include this code in your email
	// to support when you have questions about a database snapshot in Lightsail.
	// This code enables our support team to look up your Lightsail information
	// more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s RelationalDatabaseSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RelationalDatabaseSnapshot) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RelationalDatabaseSnapshot) SetArn(v string) *RelationalDatabaseSnapshot {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RelationalDatabaseSnapshot) SetCreatedAt(v time.Time) *RelationalDatabaseSnapshot {
	s.CreatedAt = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *RelationalDatabaseSnapshot) SetEngine(v string) *RelationalDatabaseSnapshot {
	s.Engine = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *RelationalDatabaseSnapshot) SetEngineVersion(v string) *RelationalDatabaseSnapshot {
	s.EngineVersion = &v
	return s
}

// SetFromRelationalDatabaseArn sets the FromRelationalDatabaseArn field's value.
func (s *RelationalDatabaseSnapshot) SetFromRelationalDatabaseArn(v string) *RelationalDatabaseSnapshot {
	s.FromRelationalDatabaseArn = &v
	return s
}

// SetFromRelationalDatabaseBlueprintId sets the FromRelationalDatabaseBlueprintId field's value.
func (s *RelationalDatabaseSnapshot) SetFromRelationalDatabaseBlueprintId(v string) *RelationalDatabaseSnapshot {
	s.FromRelationalDatabaseBlueprintId = &v
	return s
}

// SetFromRelationalDatabaseBundleId sets the FromRelationalDatabaseBundleId field's value.
func (s *RelationalDatabaseSnapshot) SetFromRelationalDatabaseBundleId(v string) *RelationalDatabaseSnapshot {
	s.FromRelationalDatabaseBundleId = &v
	return s
}

// SetFromRelationalDatabaseName sets the FromRelationalDatabaseName field's value.
func (s *RelationalDatabaseSnapshot) SetFromRelationalDatabaseName(v string) *RelationalDatabaseSnapshot {
	s.FromRelationalDatabaseName = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *RelationalDatabaseSnapshot) SetLocation(v *ResourceLocation) *RelationalDatabaseSnapshot {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *RelationalDatabaseSnapshot) SetName(v string) *RelationalDatabaseSnapshot {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *RelationalDatabaseSnapshot) SetResourceType(v string) *RelationalDatabaseSnapshot {
	s.ResourceType = &v
	return s
}

// SetSizeInGb sets the SizeInGb field's value.
func (s *RelationalDatabaseSnapshot) SetSizeInGb(v int64) *RelationalDatabaseSnapshot {
	s.SizeInGb = &v
	return s
}

// SetState sets the State field's value.
func (s *RelationalDatabaseSnapshot) SetState(v string) *RelationalDatabaseSnapshot {
	s.State = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *RelationalDatabaseSnapshot) SetSupportCode(v string) *RelationalDatabaseSnapshot {
	s.SupportCode = &v
	return s
}

type ReleaseStaticIpInput struct {
	_ struct{} `type:"structure"`

	// The name of the static IP to delete.
	//
	// StaticIpName is a required field
	StaticIpName *string `locationName:"staticIpName" type:"string" required:"true"`
}

// String returns the string representation
func (s ReleaseStaticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReleaseStaticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReleaseStaticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReleaseStaticIpInput"}
	if s.StaticIpName == nil {
		invalidParams.Add(request.NewErrParamRequired("StaticIpName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStaticIpName sets the StaticIpName field's value.
func (s *ReleaseStaticIpInput) SetStaticIpName(v string) *ReleaseStaticIpInput {
	s.StaticIpName = &v
	return s
}

type ReleaseStaticIpOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s ReleaseStaticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReleaseStaticIpOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *ReleaseStaticIpOutput) SetOperations(v []*Operation) *ReleaseStaticIpOutput {
	s.Operations = v
	return s
}

// Describes the resource location.
type ResourceLocation struct {
	_ struct{} `type:"structure"`

	// The Availability Zone. Follows the format us-east-2a (case-sensitive).
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The AWS Region name.
	RegionName *string `locationName:"regionName" type:"string" enum:"RegionName"`
}

// String returns the string representation
func (s ResourceLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceLocation) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ResourceLocation) SetAvailabilityZone(v string) *ResourceLocation {
	s.AvailabilityZone = &v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *ResourceLocation) SetRegionName(v string) *ResourceLocation {
	s.RegionName = &v
	return s
}

type StartInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance (a virtual private server) to start.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s StartInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceName sets the InstanceName field's value.
func (s *StartInstanceInput) SetInstanceName(v string) *StartInstanceInput {
	s.InstanceName = &v
	return s
}

type StartInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s StartInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartInstanceOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *StartInstanceOutput) SetOperations(v []*Operation) *StartInstanceOutput {
	s.Operations = v
	return s
}

type StartRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of your database to start.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s StartRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartRelationalDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartRelationalDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartRelationalDatabaseInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *StartRelationalDatabaseInput) SetRelationalDatabaseName(v string) *StartRelationalDatabaseInput {
	s.RelationalDatabaseName = &v
	return s
}

type StartRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your start relational database request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s StartRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartRelationalDatabaseOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *StartRelationalDatabaseOutput) SetOperations(v []*Operation) *StartRelationalDatabaseOutput {
	s.Operations = v
	return s
}

// Describes the static IP.
type StaticIp struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the static IP (e.g., arn:aws:lightsail:us-east-2:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE).
	Arn *string `locationName:"arn" type:"string"`

	// The instance where the static IP is attached (e.g., Amazon_Linux-1GB-Ohio-1).
	AttachedTo *string `locationName:"attachedTo" type:"string"`

	// The timestamp when the static IP was created (e.g., 1479735304.222).
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The static IP address.
	IpAddress *string `locationName:"ipAddress" type:"string"`

	// A Boolean value indicating whether the static IP is attached.
	IsAttached *bool `locationName:"isAttached" type:"boolean"`

	// The region and Availability Zone where the static IP was created.
	Location *ResourceLocation `locationName:"location" type:"structure"`

	// The name of the static IP (e.g., StaticIP-Ohio-EXAMPLE).
	Name *string `locationName:"name" type:"string"`

	// The resource type (usually StaticIp).
	ResourceType *string `locationName:"resourceType" type:"string" enum:"ResourceType"`

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string `locationName:"supportCode" type:"string"`
}

// String returns the string representation
func (s StaticIp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StaticIp) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StaticIp) SetArn(v string) *StaticIp {
	s.Arn = &v
	return s
}

// SetAttachedTo sets the AttachedTo field's value.
func (s *StaticIp) SetAttachedTo(v string) *StaticIp {
	s.AttachedTo = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *StaticIp) SetCreatedAt(v time.Time) *StaticIp {
	s.CreatedAt = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *StaticIp) SetIpAddress(v string) *StaticIp {
	s.IpAddress = &v
	return s
}

// SetIsAttached sets the IsAttached field's value.
func (s *StaticIp) SetIsAttached(v bool) *StaticIp {
	s.IsAttached = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *StaticIp) SetLocation(v *ResourceLocation) *StaticIp {
	s.Location = v
	return s
}

// SetName sets the Name field's value.
func (s *StaticIp) SetName(v string) *StaticIp {
	s.Name = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StaticIp) SetResourceType(v string) *StaticIp {
	s.ResourceType = &v
	return s
}

// SetSupportCode sets the SupportCode field's value.
func (s *StaticIp) SetSupportCode(v string) *StaticIp {
	s.SupportCode = &v
	return s
}

type StopInstanceInput struct {
	_ struct{} `type:"structure"`

	// When set to True, forces a Lightsail instance that is stuck in a stopping
	// state to stop.
	//
	// Only use the force parameter if your instance is stuck in the stopping state.
	// In any other state, your instance should stop normally without adding this
	// parameter to your API request.
	Force *bool `locationName:"force" type:"boolean"`

	// The name of the instance (a virtual private server) to stop.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s StopInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopInstanceInput"}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *StopInstanceInput) SetForce(v bool) *StopInstanceInput {
	s.Force = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *StopInstanceInput) SetInstanceName(v string) *StopInstanceInput {
	s.InstanceName = &v
	return s
}

type StopInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s StopInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopInstanceOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *StopInstanceOutput) SetOperations(v []*Operation) *StopInstanceOutput {
	s.Operations = v
	return s
}

type StopRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The name of your database to stop.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// The name of your new database snapshot to be created before stopping your
	// database.
	RelationalDatabaseSnapshotName *string `locationName:"relationalDatabaseSnapshotName" type:"string"`
}

// String returns the string representation
func (s StopRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopRelationalDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopRelationalDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopRelationalDatabaseInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *StopRelationalDatabaseInput) SetRelationalDatabaseName(v string) *StopRelationalDatabaseInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetRelationalDatabaseSnapshotName sets the RelationalDatabaseSnapshotName field's value.
func (s *StopRelationalDatabaseInput) SetRelationalDatabaseSnapshotName(v string) *StopRelationalDatabaseInput {
	s.RelationalDatabaseSnapshotName = &v
	return s
}

type StopRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your stop relational database request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s StopRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopRelationalDatabaseOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *StopRelationalDatabaseOutput) SetOperations(v []*Operation) *StopRelationalDatabaseOutput {
	s.Operations = v
	return s
}

type UnpeerVpcInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnpeerVpcInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnpeerVpcInput) GoString() string {
	return s.String()
}

type UnpeerVpcOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s UnpeerVpcOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnpeerVpcOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *UnpeerVpcOutput) SetOperation(v *Operation) *UnpeerVpcOutput {
	s.Operation = v
	return s
}

type UpdateDomainEntryInput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the domain entry.
	//
	// DomainEntry is a required field
	DomainEntry *DomainEntry `locationName:"domainEntry" type:"structure" required:"true"`

	// The name of the domain recordset to update.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainEntryInput"}
	if s.DomainEntry == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainEntry"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainEntry sets the DomainEntry field's value.
func (s *UpdateDomainEntryInput) SetDomainEntry(v *DomainEntry) *UpdateDomainEntryInput {
	s.DomainEntry = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainEntryInput) SetDomainName(v string) *UpdateDomainEntryInput {
	s.DomainName = &v
	return s
}

type UpdateDomainEntryOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s UpdateDomainEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainEntryOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *UpdateDomainEntryOutput) SetOperations(v []*Operation) *UpdateDomainEntryOutput {
	s.Operations = v
	return s
}

type UpdateLoadBalancerAttributeInput struct {
	_ struct{} `type:"structure"`

	// The name of the attribute you want to update. Valid values are below.
	//
	// AttributeName is a required field
	AttributeName *string `locationName:"attributeName" type:"string" required:"true" enum:"LoadBalancerAttributeName"`

	// The value that you want to specify for the attribute name.
	//
	// AttributeValue is a required field
	AttributeValue *string `locationName:"attributeValue" min:"1" type:"string" required:"true"`

	// The name of the load balancer that you want to modify (e.g., my-load-balancer.
	//
	// LoadBalancerName is a required field
	LoadBalancerName *string `locationName:"loadBalancerName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateLoadBalancerAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLoadBalancerAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLoadBalancerAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLoadBalancerAttributeInput"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeValue == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeValue"))
	}
	if s.AttributeValue != nil && len(*s.AttributeValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeValue", 1))
	}
	if s.LoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *UpdateLoadBalancerAttributeInput) SetAttributeName(v string) *UpdateLoadBalancerAttributeInput {
	s.AttributeName = &v
	return s
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *UpdateLoadBalancerAttributeInput) SetAttributeValue(v string) *UpdateLoadBalancerAttributeInput {
	s.AttributeValue = &v
	return s
}

// SetLoadBalancerName sets the LoadBalancerName field's value.
func (s *UpdateLoadBalancerAttributeInput) SetLoadBalancerName(v string) *UpdateLoadBalancerAttributeInput {
	s.LoadBalancerName = &v
	return s
}

type UpdateLoadBalancerAttributeOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s UpdateLoadBalancerAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLoadBalancerAttributeOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *UpdateLoadBalancerAttributeOutput) SetOperations(v []*Operation) *UpdateLoadBalancerAttributeOutput {
	s.Operations = v
	return s
}

type UpdateRelationalDatabaseInput struct {
	_ struct{} `type:"structure"`

	// When true, applies changes immediately. When false, applies changes during
	// the preferred maintenance window. Some changes may cause an outage.
	//
	// Default: false
	ApplyImmediately *bool `locationName:"applyImmediately" type:"boolean"`

	// When true, disables automated backup retention for your database.
	//
	// Disabling backup retention deletes all automated database backups. Before
	// disabling this, you may want to create a snapshot of your database using
	// the create relational database snapshot operation.
	//
	// Updates are applied during the next maintenance window because this can result
	// in an outage.
	DisableBackupRetention *bool `locationName:"disableBackupRetention" type:"boolean"`

	// When true, enables automated backup retention for your database.
	//
	// Updates are applied during the next maintenance window because this can result
	// in an outage.
	EnableBackupRetention *bool `locationName:"enableBackupRetention" type:"boolean"`

	// The password for the master user of your database. The password can include
	// any printable ASCII character except "/", """, or "@".
	//
	// Constraints: Must contain 8 to 41 characters.
	MasterUserPassword *string `locationName:"masterUserPassword" type:"string"`

	// The daily time range during which automated backups are created for your
	// database if automated backups are enabled.
	//
	// Constraints:
	//
	//    * Must be in the hh24:mi-hh24:mi format.
	//
	// Example: 16:00-16:30
	//
	//    * Specified in Universal Coordinated Time (UTC).
	//
	//    * Must not conflict with the preferred maintenance window.
	//
	//    * Must be at least 30 minutes.
	PreferredBackupWindow *string `locationName:"preferredBackupWindow" type:"string"`

	// The weekly time range during which system maintenance can occur on your database.
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week.
	//
	// Constraints:
	//
	//    * Must be in the ddd:hh24:mi-ddd:hh24:mi format.
	//
	//    * Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
	//
	//    * Must be at least 30 minutes.
	//
	//    * Specified in Universal Coordinated Time (UTC).
	//
	//    * Example: Tue:17:00-Tue:17:30
	PreferredMaintenanceWindow *string `locationName:"preferredMaintenanceWindow" type:"string"`

	// Specifies the accessibility options for your database. A value of true specifies
	// a database that is available to resources outside of your Lightsail account.
	// A value of false specifies a database that is available only to your Lightsail
	// resources in the same region as your database.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// The name of your database to update.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`

	// When true, the master user password is changed to a new strong password generated
	// by Lightsail.
	//
	// Use the get relational database master user password operation to get the
	// new password.
	RotateMasterUserPassword *bool `locationName:"rotateMasterUserPassword" type:"boolean"`
}

// String returns the string representation
func (s UpdateRelationalDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRelationalDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRelationalDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRelationalDatabaseInput"}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *UpdateRelationalDatabaseInput) SetApplyImmediately(v bool) *UpdateRelationalDatabaseInput {
	s.ApplyImmediately = &v
	return s
}

// SetDisableBackupRetention sets the DisableBackupRetention field's value.
func (s *UpdateRelationalDatabaseInput) SetDisableBackupRetention(v bool) *UpdateRelationalDatabaseInput {
	s.DisableBackupRetention = &v
	return s
}

// SetEnableBackupRetention sets the EnableBackupRetention field's value.
func (s *UpdateRelationalDatabaseInput) SetEnableBackupRetention(v bool) *UpdateRelationalDatabaseInput {
	s.EnableBackupRetention = &v
	return s
}

// SetMasterUserPassword sets the MasterUserPassword field's value.
func (s *UpdateRelationalDatabaseInput) SetMasterUserPassword(v string) *UpdateRelationalDatabaseInput {
	s.MasterUserPassword = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *UpdateRelationalDatabaseInput) SetPreferredBackupWindow(v string) *UpdateRelationalDatabaseInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *UpdateRelationalDatabaseInput) SetPreferredMaintenanceWindow(v string) *UpdateRelationalDatabaseInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *UpdateRelationalDatabaseInput) SetPubliclyAccessible(v bool) *UpdateRelationalDatabaseInput {
	s.PubliclyAccessible = &v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *UpdateRelationalDatabaseInput) SetRelationalDatabaseName(v string) *UpdateRelationalDatabaseInput {
	s.RelationalDatabaseName = &v
	return s
}

// SetRotateMasterUserPassword sets the RotateMasterUserPassword field's value.
func (s *UpdateRelationalDatabaseInput) SetRotateMasterUserPassword(v bool) *UpdateRelationalDatabaseInput {
	s.RotateMasterUserPassword = &v
	return s
}

type UpdateRelationalDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your update relational database request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s UpdateRelationalDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRelationalDatabaseOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *UpdateRelationalDatabaseOutput) SetOperations(v []*Operation) *UpdateRelationalDatabaseOutput {
	s.Operations = v
	return s
}

type UpdateRelationalDatabaseParametersInput struct {
	_ struct{} `type:"structure"`

	// The database parameters to update.
	//
	// Parameters is a required field
	Parameters []*RelationalDatabaseParameter `locationName:"parameters" type:"list" required:"true"`

	// The name of your database for which to update parameters.
	//
	// RelationalDatabaseName is a required field
	RelationalDatabaseName *string `locationName:"relationalDatabaseName" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRelationalDatabaseParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRelationalDatabaseParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRelationalDatabaseParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRelationalDatabaseParametersInput"}
	if s.Parameters == nil {
		invalidParams.Add(request.NewErrParamRequired("Parameters"))
	}
	if s.RelationalDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("RelationalDatabaseName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *UpdateRelationalDatabaseParametersInput) SetParameters(v []*RelationalDatabaseParameter) *UpdateRelationalDatabaseParametersInput {
	s.Parameters = v
	return s
}

// SetRelationalDatabaseName sets the RelationalDatabaseName field's value.
func (s *UpdateRelationalDatabaseParametersInput) SetRelationalDatabaseName(v string) *UpdateRelationalDatabaseParametersInput {
	s.RelationalDatabaseName = &v
	return s
}

type UpdateRelationalDatabaseParametersOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the result of your update relational database parameters
	// request.
	Operations []*Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s UpdateRelationalDatabaseParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRelationalDatabaseParametersOutput) GoString() string {
	return s.String()
}

// SetOperations sets the Operations field's value.
func (s *UpdateRelationalDatabaseParametersOutput) SetOperations(v []*Operation) *UpdateRelationalDatabaseParametersOutput {
	s.Operations = v
	return s
}

const (
	// AccessDirectionInbound is a AccessDirection enum value
	AccessDirectionInbound = "inbound"

	// AccessDirectionOutbound is a AccessDirection enum value
	AccessDirectionOutbound = "outbound"
)

const (
	// BlueprintTypeOs is a BlueprintType enum value
	BlueprintTypeOs = "os"

	// BlueprintTypeApp is a BlueprintType enum value
	BlueprintTypeApp = "app"
)

const (
	// DiskSnapshotStatePending is a DiskSnapshotState enum value
	DiskSnapshotStatePending = "pending"

	// DiskSnapshotStateCompleted is a DiskSnapshotState enum value
	DiskSnapshotStateCompleted = "completed"

	// DiskSnapshotStateError is a DiskSnapshotState enum value
	DiskSnapshotStateError = "error"

	// DiskSnapshotStateUnknown is a DiskSnapshotState enum value
	DiskSnapshotStateUnknown = "unknown"
)

const (
	// DiskStatePending is a DiskState enum value
	DiskStatePending = "pending"

	// DiskStateError is a DiskState enum value
	DiskStateError = "error"

	// DiskStateAvailable is a DiskState enum value
	DiskStateAvailable = "available"

	// DiskStateInUse is a DiskState enum value
	DiskStateInUse = "in-use"

	// DiskStateUnknown is a DiskState enum value
	DiskStateUnknown = "unknown"
)

const (
	// InstanceAccessProtocolSsh is a InstanceAccessProtocol enum value
	InstanceAccessProtocolSsh = "ssh"

	// InstanceAccessProtocolRdp is a InstanceAccessProtocol enum value
	InstanceAccessProtocolRdp = "rdp"
)

const (
	// InstanceHealthReasonLbRegistrationInProgress is a InstanceHealthReason enum value
	InstanceHealthReasonLbRegistrationInProgress = "Lb.RegistrationInProgress"

	// InstanceHealthReasonLbInitialHealthChecking is a InstanceHealthReason enum value
	InstanceHealthReasonLbInitialHealthChecking = "Lb.InitialHealthChecking"

	// InstanceHealthReasonLbInternalError is a InstanceHealthReason enum value
	InstanceHealthReasonLbInternalError = "Lb.InternalError"

	// InstanceHealthReasonInstanceResponseCodeMismatch is a InstanceHealthReason enum value
	InstanceHealthReasonInstanceResponseCodeMismatch = "Instance.ResponseCodeMismatch"

	// InstanceHealthReasonInstanceTimeout is a InstanceHealthReason enum value
	InstanceHealthReasonInstanceTimeout = "Instance.Timeout"

	// InstanceHealthReasonInstanceFailedHealthChecks is a InstanceHealthReason enum value
	InstanceHealthReasonInstanceFailedHealthChecks = "Instance.FailedHealthChecks"

	// InstanceHealthReasonInstanceNotRegistered is a InstanceHealthReason enum value
	InstanceHealthReasonInstanceNotRegistered = "Instance.NotRegistered"

	// InstanceHealthReasonInstanceNotInUse is a InstanceHealthReason enum value
	InstanceHealthReasonInstanceNotInUse = "Instance.NotInUse"

	// InstanceHealthReasonInstanceDeregistrationInProgress is a InstanceHealthReason enum value
	InstanceHealthReasonInstanceDeregistrationInProgress = "Instance.DeregistrationInProgress"

	// InstanceHealthReasonInstanceInvalidState is a InstanceHealthReason enum value
	InstanceHealthReasonInstanceInvalidState = "Instance.InvalidState"

	// InstanceHealthReasonInstanceIpUnusable is a InstanceHealthReason enum value
	InstanceHealthReasonInstanceIpUnusable = "Instance.IpUnusable"
)

const (
	// InstanceHealthStateInitial is a InstanceHealthState enum value
	InstanceHealthStateInitial = "initial"

	// InstanceHealthStateHealthy is a InstanceHealthState enum value
	InstanceHealthStateHealthy = "healthy"

	// InstanceHealthStateUnhealthy is a InstanceHealthState enum value
	InstanceHealthStateUnhealthy = "unhealthy"

	// InstanceHealthStateUnused is a InstanceHealthState enum value
	InstanceHealthStateUnused = "unused"

	// InstanceHealthStateDraining is a InstanceHealthState enum value
	InstanceHealthStateDraining = "draining"

	// InstanceHealthStateUnavailable is a InstanceHealthState enum value
	InstanceHealthStateUnavailable = "unavailable"
)

const (
	// InstanceMetricNameCpuutilization is a InstanceMetricName enum value
	InstanceMetricNameCpuutilization = "CPUUtilization"

	// InstanceMetricNameNetworkIn is a InstanceMetricName enum value
	InstanceMetricNameNetworkIn = "NetworkIn"

	// InstanceMetricNameNetworkOut is a InstanceMetricName enum value
	InstanceMetricNameNetworkOut = "NetworkOut"

	// InstanceMetricNameStatusCheckFailed is a InstanceMetricName enum value
	InstanceMetricNameStatusCheckFailed = "StatusCheckFailed"

	// InstanceMetricNameStatusCheckFailedInstance is a InstanceMetricName enum value
	InstanceMetricNameStatusCheckFailedInstance = "StatusCheckFailed_Instance"

	// InstanceMetricNameStatusCheckFailedSystem is a InstanceMetricName enum value
	InstanceMetricNameStatusCheckFailedSystem = "StatusCheckFailed_System"
)

const (
	// InstancePlatformLinuxUnix is a InstancePlatform enum value
	InstancePlatformLinuxUnix = "LINUX_UNIX"

	// InstancePlatformWindows is a InstancePlatform enum value
	InstancePlatformWindows = "WINDOWS"
)

const (
	// InstanceSnapshotStatePending is a InstanceSnapshotState enum value
	InstanceSnapshotStatePending = "pending"

	// InstanceSnapshotStateError is a InstanceSnapshotState enum value
	InstanceSnapshotStateError = "error"

	// InstanceSnapshotStateAvailable is a InstanceSnapshotState enum value
	InstanceSnapshotStateAvailable = "available"
)

const (
	// LoadBalancerAttributeNameHealthCheckPath is a LoadBalancerAttributeName enum value
	LoadBalancerAttributeNameHealthCheckPath = "HealthCheckPath"

	// LoadBalancerAttributeNameSessionStickinessEnabled is a LoadBalancerAttributeName enum value
	LoadBalancerAttributeNameSessionStickinessEnabled = "SessionStickinessEnabled"

	// LoadBalancerAttributeNameSessionStickinessLbCookieDurationSeconds is a LoadBalancerAttributeName enum value
	LoadBalancerAttributeNameSessionStickinessLbCookieDurationSeconds = "SessionStickiness_LB_CookieDurationSeconds"
)

const (
	// LoadBalancerMetricNameClientTlsnegotiationErrorCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameClientTlsnegotiationErrorCount = "ClientTLSNegotiationErrorCount"

	// LoadBalancerMetricNameHealthyHostCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameHealthyHostCount = "HealthyHostCount"

	// LoadBalancerMetricNameUnhealthyHostCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameUnhealthyHostCount = "UnhealthyHostCount"

	// LoadBalancerMetricNameHttpcodeLb4xxCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameHttpcodeLb4xxCount = "HTTPCode_LB_4XX_Count"

	// LoadBalancerMetricNameHttpcodeLb5xxCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameHttpcodeLb5xxCount = "HTTPCode_LB_5XX_Count"

	// LoadBalancerMetricNameHttpcodeInstance2xxCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameHttpcodeInstance2xxCount = "HTTPCode_Instance_2XX_Count"

	// LoadBalancerMetricNameHttpcodeInstance3xxCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameHttpcodeInstance3xxCount = "HTTPCode_Instance_3XX_Count"

	// LoadBalancerMetricNameHttpcodeInstance4xxCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameHttpcodeInstance4xxCount = "HTTPCode_Instance_4XX_Count"

	// LoadBalancerMetricNameHttpcodeInstance5xxCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameHttpcodeInstance5xxCount = "HTTPCode_Instance_5XX_Count"

	// LoadBalancerMetricNameInstanceResponseTime is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameInstanceResponseTime = "InstanceResponseTime"

	// LoadBalancerMetricNameRejectedConnectionCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameRejectedConnectionCount = "RejectedConnectionCount"

	// LoadBalancerMetricNameRequestCount is a LoadBalancerMetricName enum value
	LoadBalancerMetricNameRequestCount = "RequestCount"
)

const (
	// LoadBalancerProtocolHttpHttps is a LoadBalancerProtocol enum value
	LoadBalancerProtocolHttpHttps = "HTTP_HTTPS"

	// LoadBalancerProtocolHttp is a LoadBalancerProtocol enum value
	LoadBalancerProtocolHttp = "HTTP"
)

const (
	// LoadBalancerStateActive is a LoadBalancerState enum value
	LoadBalancerStateActive = "active"

	// LoadBalancerStateProvisioning is a LoadBalancerState enum value
	LoadBalancerStateProvisioning = "provisioning"

	// LoadBalancerStateActiveImpaired is a LoadBalancerState enum value
	LoadBalancerStateActiveImpaired = "active_impaired"

	// LoadBalancerStateFailed is a LoadBalancerState enum value
	LoadBalancerStateFailed = "failed"

	// LoadBalancerStateUnknown is a LoadBalancerState enum value
	LoadBalancerStateUnknown = "unknown"
)

const (
	// LoadBalancerTlsCertificateDomainStatusPendingValidation is a LoadBalancerTlsCertificateDomainStatus enum value
	LoadBalancerTlsCertificateDomainStatusPendingValidation = "PENDING_VALIDATION"

	// LoadBalancerTlsCertificateDomainStatusFailed is a LoadBalancerTlsCertificateDomainStatus enum value
	LoadBalancerTlsCertificateDomainStatusFailed = "FAILED"

	// LoadBalancerTlsCertificateDomainStatusSuccess is a LoadBalancerTlsCertificateDomainStatus enum value
	LoadBalancerTlsCertificateDomainStatusSuccess = "SUCCESS"
)

const (
	// LoadBalancerTlsCertificateFailureReasonNoAvailableContacts is a LoadBalancerTlsCertificateFailureReason enum value
	LoadBalancerTlsCertificateFailureReasonNoAvailableContacts = "NO_AVAILABLE_CONTACTS"

	// LoadBalancerTlsCertificateFailureReasonAdditionalVerificationRequired is a LoadBalancerTlsCertificateFailureReason enum value
	LoadBalancerTlsCertificateFailureReasonAdditionalVerificationRequired = "ADDITIONAL_VERIFICATION_REQUIRED"

	// LoadBalancerTlsCertificateFailureReasonDomainNotAllowed is a LoadBalancerTlsCertificateFailureReason enum value
	LoadBalancerTlsCertificateFailureReasonDomainNotAllowed = "DOMAIN_NOT_ALLOWED"

	// LoadBalancerTlsCertificateFailureReasonInvalidPublicDomain is a LoadBalancerTlsCertificateFailureReason enum value
	LoadBalancerTlsCertificateFailureReasonInvalidPublicDomain = "INVALID_PUBLIC_DOMAIN"

	// LoadBalancerTlsCertificateFailureReasonOther is a LoadBalancerTlsCertificateFailureReason enum value
	LoadBalancerTlsCertificateFailureReasonOther = "OTHER"
)

const (
	// LoadBalancerTlsCertificateRenewalStatusPendingAutoRenewal is a LoadBalancerTlsCertificateRenewalStatus enum value
	LoadBalancerTlsCertificateRenewalStatusPendingAutoRenewal = "PENDING_AUTO_RENEWAL"

	// LoadBalancerTlsCertificateRenewalStatusPendingValidation is a LoadBalancerTlsCertificateRenewalStatus enum value
	LoadBalancerTlsCertificateRenewalStatusPendingValidation = "PENDING_VALIDATION"

	// LoadBalancerTlsCertificateRenewalStatusSuccess is a LoadBalancerTlsCertificateRenewalStatus enum value
	LoadBalancerTlsCertificateRenewalStatusSuccess = "SUCCESS"

	// LoadBalancerTlsCertificateRenewalStatusFailed is a LoadBalancerTlsCertificateRenewalStatus enum value
	LoadBalancerTlsCertificateRenewalStatusFailed = "FAILED"
)

const (
	// LoadBalancerTlsCertificateRevocationReasonUnspecified is a LoadBalancerTlsCertificateRevocationReason enum value
	LoadBalancerTlsCertificateRevocationReasonUnspecified = "UNSPECIFIED"

	// LoadBalancerTlsCertificateRevocationReasonKeyCompromise is a LoadBalancerTlsCertificateRevocationReason enum value
	LoadBalancerTlsCertificateRevocationReasonKeyCompromise = "KEY_COMPROMISE"

	// LoadBalancerTlsCertificateRevocationReasonCaCompromise is a LoadBalancerTlsCertificateRevocationReason enum value
	LoadBalancerTlsCertificateRevocationReasonCaCompromise = "CA_COMPROMISE"

	// LoadBalancerTlsCertificateRevocationReasonAffiliationChanged is a LoadBalancerTlsCertificateRevocationReason enum value
	LoadBalancerTlsCertificateRevocationReasonAffiliationChanged = "AFFILIATION_CHANGED"

	// LoadBalancerTlsCertificateRevocationReasonSuperceded is a LoadBalancerTlsCertificateRevocationReason enum value
	LoadBalancerTlsCertificateRevocationReasonSuperceded = "SUPERCEDED"

	// LoadBalancerTlsCertificateRevocationReasonCessationOfOperation is a LoadBalancerTlsCertificateRevocationReason enum value
	LoadBalancerTlsCertificateRevocationReasonCessationOfOperation = "CESSATION_OF_OPERATION"

	// LoadBalancerTlsCertificateRevocationReasonCertificateHold is a LoadBalancerTlsCertificateRevocationReason enum value
	LoadBalancerTlsCertificateRevocationReasonCertificateHold = "CERTIFICATE_HOLD"

	// LoadBalancerTlsCertificateRevocationReasonRemoveFromCrl is a LoadBalancerTlsCertificateRevocationReason enum value
	LoadBalancerTlsCertificateRevocationReasonRemoveFromCrl = "REMOVE_FROM_CRL"

	// LoadBalancerTlsCertificateRevocationReasonPrivilegeWithdrawn is a LoadBalancerTlsCertificateRevocationReason enum value
	LoadBalancerTlsCertificateRevocationReasonPrivilegeWithdrawn = "PRIVILEGE_WITHDRAWN"

	// LoadBalancerTlsCertificateRevocationReasonAACompromise is a LoadBalancerTlsCertificateRevocationReason enum value
	LoadBalancerTlsCertificateRevocationReasonAACompromise = "A_A_COMPROMISE"
)

const (
	// LoadBalancerTlsCertificateStatusPendingValidation is a LoadBalancerTlsCertificateStatus enum value
	LoadBalancerTlsCertificateStatusPendingValidation = "PENDING_VALIDATION"

	// LoadBalancerTlsCertificateStatusIssued is a LoadBalancerTlsCertificateStatus enum value
	LoadBalancerTlsCertificateStatusIssued = "ISSUED"

	// LoadBalancerTlsCertificateStatusInactive is a LoadBalancerTlsCertificateStatus enum value
	LoadBalancerTlsCertificateStatusInactive = "INACTIVE"

	// LoadBalancerTlsCertificateStatusExpired is a LoadBalancerTlsCertificateStatus enum value
	LoadBalancerTlsCertificateStatusExpired = "EXPIRED"

	// LoadBalancerTlsCertificateStatusValidationTimedOut is a LoadBalancerTlsCertificateStatus enum value
	LoadBalancerTlsCertificateStatusValidationTimedOut = "VALIDATION_TIMED_OUT"

	// LoadBalancerTlsCertificateStatusRevoked is a LoadBalancerTlsCertificateStatus enum value
	LoadBalancerTlsCertificateStatusRevoked = "REVOKED"

	// LoadBalancerTlsCertificateStatusFailed is a LoadBalancerTlsCertificateStatus enum value
	LoadBalancerTlsCertificateStatusFailed = "FAILED"

	// LoadBalancerTlsCertificateStatusUnknown is a LoadBalancerTlsCertificateStatus enum value
	LoadBalancerTlsCertificateStatusUnknown = "UNKNOWN"
)

const (
	// MetricStatisticMinimum is a MetricStatistic enum value
	MetricStatisticMinimum = "Minimum"

	// MetricStatisticMaximum is a MetricStatistic enum value
	MetricStatisticMaximum = "Maximum"

	// MetricStatisticSum is a MetricStatistic enum value
	MetricStatisticSum = "Sum"

	// MetricStatisticAverage is a MetricStatistic enum value
	MetricStatisticAverage = "Average"

	// MetricStatisticSampleCount is a MetricStatistic enum value
	MetricStatisticSampleCount = "SampleCount"
)

const (
	// MetricUnitSeconds is a MetricUnit enum value
	MetricUnitSeconds = "Seconds"

	// MetricUnitMicroseconds is a MetricUnit enum value
	MetricUnitMicroseconds = "Microseconds"

	// MetricUnitMilliseconds is a MetricUnit enum value
	MetricUnitMilliseconds = "Milliseconds"

	// MetricUnitBytes is a MetricUnit enum value
	MetricUnitBytes = "Bytes"

	// MetricUnitKilobytes is a MetricUnit enum value
	MetricUnitKilobytes = "Kilobytes"

	// MetricUnitMegabytes is a MetricUnit enum value
	MetricUnitMegabytes = "Megabytes"

	// MetricUnitGigabytes is a MetricUnit enum value
	MetricUnitGigabytes = "Gigabytes"

	// MetricUnitTerabytes is a MetricUnit enum value
	MetricUnitTerabytes = "Terabytes"

	// MetricUnitBits is a MetricUnit enum value
	MetricUnitBits = "Bits"

	// MetricUnitKilobits is a MetricUnit enum value
	MetricUnitKilobits = "Kilobits"

	// MetricUnitMegabits is a MetricUnit enum value
	MetricUnitMegabits = "Megabits"

	// MetricUnitGigabits is a MetricUnit enum value
	MetricUnitGigabits = "Gigabits"

	// MetricUnitTerabits is a MetricUnit enum value
	MetricUnitTerabits = "Terabits"

	// MetricUnitPercent is a MetricUnit enum value
	MetricUnitPercent = "Percent"

	// MetricUnitCount is a MetricUnit enum value
	MetricUnitCount = "Count"

	// MetricUnitBytesSecond is a MetricUnit enum value
	MetricUnitBytesSecond = "Bytes/Second"

	// MetricUnitKilobytesSecond is a MetricUnit enum value
	MetricUnitKilobytesSecond = "Kilobytes/Second"

	// MetricUnitMegabytesSecond is a MetricUnit enum value
	MetricUnitMegabytesSecond = "Megabytes/Second"

	// MetricUnitGigabytesSecond is a MetricUnit enum value
	MetricUnitGigabytesSecond = "Gigabytes/Second"

	// MetricUnitTerabytesSecond is a MetricUnit enum value
	MetricUnitTerabytesSecond = "Terabytes/Second"

	// MetricUnitBitsSecond is a MetricUnit enum value
	MetricUnitBitsSecond = "Bits/Second"

	// MetricUnitKilobitsSecond is a MetricUnit enum value
	MetricUnitKilobitsSecond = "Kilobits/Second"

	// MetricUnitMegabitsSecond is a MetricUnit enum value
	MetricUnitMegabitsSecond = "Megabits/Second"

	// MetricUnitGigabitsSecond is a MetricUnit enum value
	MetricUnitGigabitsSecond = "Gigabits/Second"

	// MetricUnitTerabitsSecond is a MetricUnit enum value
	MetricUnitTerabitsSecond = "Terabits/Second"

	// MetricUnitCountSecond is a MetricUnit enum value
	MetricUnitCountSecond = "Count/Second"

	// MetricUnitNone is a MetricUnit enum value
	MetricUnitNone = "None"
)

const (
	// NetworkProtocolTcp is a NetworkProtocol enum value
	NetworkProtocolTcp = "tcp"

	// NetworkProtocolAll is a NetworkProtocol enum value
	NetworkProtocolAll = "all"

	// NetworkProtocolUdp is a NetworkProtocol enum value
	NetworkProtocolUdp = "udp"
)

const (
	// OperationStatusNotStarted is a OperationStatus enum value
	OperationStatusNotStarted = "NotStarted"

	// OperationStatusStarted is a OperationStatus enum value
	OperationStatusStarted = "Started"

	// OperationStatusFailed is a OperationStatus enum value
	OperationStatusFailed = "Failed"

	// OperationStatusCompleted is a OperationStatus enum value
	OperationStatusCompleted = "Completed"

	// OperationStatusSucceeded is a OperationStatus enum value
	OperationStatusSucceeded = "Succeeded"
)

const (
	// OperationTypeDeleteInstance is a OperationType enum value
	OperationTypeDeleteInstance = "DeleteInstance"

	// OperationTypeCreateInstance is a OperationType enum value
	OperationTypeCreateInstance = "CreateInstance"

	// OperationTypeStopInstance is a OperationType enum value
	OperationTypeStopInstance = "StopInstance"

	// OperationTypeStartInstance is a OperationType enum value
	OperationTypeStartInstance = "StartInstance"

	// OperationTypeRebootInstance is a OperationType enum value
	OperationTypeRebootInstance = "RebootInstance"

	// OperationTypeOpenInstancePublicPorts is a OperationType enum value
	OperationTypeOpenInstancePublicPorts = "OpenInstancePublicPorts"

	// OperationTypePutInstancePublicPorts is a OperationType enum value
	OperationTypePutInstancePublicPorts = "PutInstancePublicPorts"

	// OperationTypeCloseInstancePublicPorts is a OperationType enum value
	OperationTypeCloseInstancePublicPorts = "CloseInstancePublicPorts"

	// OperationTypeAllocateStaticIp is a OperationType enum value
	OperationTypeAllocateStaticIp = "AllocateStaticIp"

	// OperationTypeReleaseStaticIp is a OperationType enum value
	OperationTypeReleaseStaticIp = "ReleaseStaticIp"

	// OperationTypeAttachStaticIp is a OperationType enum value
	OperationTypeAttachStaticIp = "AttachStaticIp"

	// OperationTypeDetachStaticIp is a OperationType enum value
	OperationTypeDetachStaticIp = "DetachStaticIp"

	// OperationTypeUpdateDomainEntry is a OperationType enum value
	OperationTypeUpdateDomainEntry = "UpdateDomainEntry"

	// OperationTypeDeleteDomainEntry is a OperationType enum value
	OperationTypeDeleteDomainEntry = "DeleteDomainEntry"

	// OperationTypeCreateDomain is a OperationType enum value
	OperationTypeCreateDomain = "CreateDomain"

	// OperationTypeDeleteDomain is a OperationType enum value
	OperationTypeDeleteDomain = "DeleteDomain"

	// OperationTypeCreateInstanceSnapshot is a OperationType enum value
	OperationTypeCreateInstanceSnapshot = "CreateInstanceSnapshot"

	// OperationTypeDeleteInstanceSnapshot is a OperationType enum value
	OperationTypeDeleteInstanceSnapshot = "DeleteInstanceSnapshot"

	// OperationTypeCreateInstancesFromSnapshot is a OperationType enum value
	OperationTypeCreateInstancesFromSnapshot = "CreateInstancesFromSnapshot"

	// OperationTypeCreateLoadBalancer is a OperationType enum value
	OperationTypeCreateLoadBalancer = "CreateLoadBalancer"

	// OperationTypeDeleteLoadBalancer is a OperationType enum value
	OperationTypeDeleteLoadBalancer = "DeleteLoadBalancer"

	// OperationTypeAttachInstancesToLoadBalancer is a OperationType enum value
	OperationTypeAttachInstancesToLoadBalancer = "AttachInstancesToLoadBalancer"

	// OperationTypeDetachInstancesFromLoadBalancer is a OperationType enum value
	OperationTypeDetachInstancesFromLoadBalancer = "DetachInstancesFromLoadBalancer"

	// OperationTypeUpdateLoadBalancerAttribute is a OperationType enum value
	OperationTypeUpdateLoadBalancerAttribute = "UpdateLoadBalancerAttribute"

	// OperationTypeCreateLoadBalancerTlsCertificate is a OperationType enum value
	OperationTypeCreateLoadBalancerTlsCertificate = "CreateLoadBalancerTlsCertificate"

	// OperationTypeDeleteLoadBalancerTlsCertificate is a OperationType enum value
	OperationTypeDeleteLoadBalancerTlsCertificate = "DeleteLoadBalancerTlsCertificate"

	// OperationTypeAttachLoadBalancerTlsCertificate is a OperationType enum value
	OperationTypeAttachLoadBalancerTlsCertificate = "AttachLoadBalancerTlsCertificate"

	// OperationTypeCreateDisk is a OperationType enum value
	OperationTypeCreateDisk = "CreateDisk"

	// OperationTypeDeleteDisk is a OperationType enum value
	OperationTypeDeleteDisk = "DeleteDisk"

	// OperationTypeAttachDisk is a OperationType enum value
	OperationTypeAttachDisk = "AttachDisk"

	// OperationTypeDetachDisk is a OperationType enum value
	OperationTypeDetachDisk = "DetachDisk"

	// OperationTypeCreateDiskSnapshot is a OperationType enum value
	OperationTypeCreateDiskSnapshot = "CreateDiskSnapshot"

	// OperationTypeDeleteDiskSnapshot is a OperationType enum value
	OperationTypeDeleteDiskSnapshot = "DeleteDiskSnapshot"

	// OperationTypeCreateDiskFromSnapshot is a OperationType enum value
	OperationTypeCreateDiskFromSnapshot = "CreateDiskFromSnapshot"
)

const (
	// PortAccessTypePublic is a PortAccessType enum value
	PortAccessTypePublic = "Public"

	// PortAccessTypePrivate is a PortAccessType enum value
	PortAccessTypePrivate = "Private"
)

const (
	// PortStateOpen is a PortState enum value
	PortStateOpen = "open"

	// PortStateClosed is a PortState enum value
	PortStateClosed = "closed"
)

const (
	// RegionNameUsEast1 is a RegionName enum value
	RegionNameUsEast1 = "us-east-1"

	// RegionNameUsEast2 is a RegionName enum value
	RegionNameUsEast2 = "us-east-2"

	// RegionNameUsWest1 is a RegionName enum value
	RegionNameUsWest1 = "us-west-1"

	// RegionNameUsWest2 is a RegionName enum value
	RegionNameUsWest2 = "us-west-2"

	// RegionNameEuWest1 is a RegionName enum value
	RegionNameEuWest1 = "eu-west-1"

	// RegionNameEuWest2 is a RegionName enum value
	RegionNameEuWest2 = "eu-west-2"

	// RegionNameEuWest3 is a RegionName enum value
	RegionNameEuWest3 = "eu-west-3"

	// RegionNameEuCentral1 is a RegionName enum value
	RegionNameEuCentral1 = "eu-central-1"

	// RegionNameCaCentral1 is a RegionName enum value
	RegionNameCaCentral1 = "ca-central-1"

	// RegionNameApSouth1 is a RegionName enum value
	RegionNameApSouth1 = "ap-south-1"

	// RegionNameApSoutheast1 is a RegionName enum value
	RegionNameApSoutheast1 = "ap-southeast-1"

	// RegionNameApSoutheast2 is a RegionName enum value
	RegionNameApSoutheast2 = "ap-southeast-2"

	// RegionNameApNortheast1 is a RegionName enum value
	RegionNameApNortheast1 = "ap-northeast-1"

	// RegionNameApNortheast2 is a RegionName enum value
	RegionNameApNortheast2 = "ap-northeast-2"
)

const (
	// RelationalDatabaseEngineMysql is a RelationalDatabaseEngine enum value
	RelationalDatabaseEngineMysql = "mysql"
)

const (
	// RelationalDatabaseMetricNameCpuutilization is a RelationalDatabaseMetricName enum value
	RelationalDatabaseMetricNameCpuutilization = "CPUUtilization"

	// RelationalDatabaseMetricNameDatabaseConnections is a RelationalDatabaseMetricName enum value
	RelationalDatabaseMetricNameDatabaseConnections = "DatabaseConnections"

	// RelationalDatabaseMetricNameDiskQueueDepth is a RelationalDatabaseMetricName enum value
	RelationalDatabaseMetricNameDiskQueueDepth = "DiskQueueDepth"

	// RelationalDatabaseMetricNameFreeStorageSpace is a RelationalDatabaseMetricName enum value
	RelationalDatabaseMetricNameFreeStorageSpace = "FreeStorageSpace"

	// RelationalDatabaseMetricNameNetworkReceiveThroughput is a RelationalDatabaseMetricName enum value
	RelationalDatabaseMetricNameNetworkReceiveThroughput = "NetworkReceiveThroughput"

	// RelationalDatabaseMetricNameNetworkTransmitThroughput is a RelationalDatabaseMetricName enum value
	RelationalDatabaseMetricNameNetworkTransmitThroughput = "NetworkTransmitThroughput"
)

const (
	// RelationalDatabasePasswordVersionCurrent is a RelationalDatabasePasswordVersion enum value
	RelationalDatabasePasswordVersionCurrent = "CURRENT"

	// RelationalDatabasePasswordVersionPrevious is a RelationalDatabasePasswordVersion enum value
	RelationalDatabasePasswordVersionPrevious = "PREVIOUS"

	// RelationalDatabasePasswordVersionPending is a RelationalDatabasePasswordVersion enum value
	RelationalDatabasePasswordVersionPending = "PENDING"
)

const (
	// ResourceTypeInstance is a ResourceType enum value
	ResourceTypeInstance = "Instance"

	// ResourceTypeStaticIp is a ResourceType enum value
	ResourceTypeStaticIp = "StaticIp"

	// ResourceTypeKeyPair is a ResourceType enum value
	ResourceTypeKeyPair = "KeyPair"

	// ResourceTypeInstanceSnapshot is a ResourceType enum value
	ResourceTypeInstanceSnapshot = "InstanceSnapshot"

	// ResourceTypeDomain is a ResourceType enum value
	ResourceTypeDomain = "Domain"

	// ResourceTypePeeredVpc is a ResourceType enum value
	ResourceTypePeeredVpc = "PeeredVpc"

	// ResourceTypeLoadBalancer is a ResourceType enum value
	ResourceTypeLoadBalancer = "LoadBalancer"

	// ResourceTypeLoadBalancerTlsCertificate is a ResourceType enum value
	ResourceTypeLoadBalancerTlsCertificate = "LoadBalancerTlsCertificate"

	// ResourceTypeDisk is a ResourceType enum value
	ResourceTypeDisk = "Disk"

	// ResourceTypeDiskSnapshot is a ResourceType enum value
	ResourceTypeDiskSnapshot = "DiskSnapshot"

	// ResourceTypeRelationalDatabase is a ResourceType enum value
	ResourceTypeRelationalDatabase = "RelationalDatabase"

	// ResourceTypeRelationalDatabaseSnapshot is a ResourceType enum value
	ResourceTypeRelationalDatabaseSnapshot = "RelationalDatabaseSnapshot"
)
