// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/analytics/admin/v1alpha/resources.proto

package admin

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The category selected for this property, used for industry benchmarking.
type IndustryCategory int32

const (
	// Industry category unspecified
	IndustryCategory_INDUSTRY_CATEGORY_UNSPECIFIED IndustryCategory = 0
	// Automotive
	IndustryCategory_AUTOMOTIVE IndustryCategory = 1
	// Business and industrial markets
	IndustryCategory_BUSINESS_AND_INDUSTRIAL_MARKETS IndustryCategory = 2
	// Finance
	IndustryCategory_FINANCE IndustryCategory = 3
	// Healthcare
	IndustryCategory_HEALTHCARE IndustryCategory = 4
	// Technology
	IndustryCategory_TECHNOLOGY IndustryCategory = 5
	// Travel
	IndustryCategory_TRAVEL IndustryCategory = 6
	// Other
	IndustryCategory_OTHER IndustryCategory = 7
	// Arts and entertainment
	IndustryCategory_ARTS_AND_ENTERTAINMENT IndustryCategory = 8
	// Beauty and fitness
	IndustryCategory_BEAUTY_AND_FITNESS IndustryCategory = 9
	// Books and literature
	IndustryCategory_BOOKS_AND_LITERATURE IndustryCategory = 10
	// Food and drink
	IndustryCategory_FOOD_AND_DRINK IndustryCategory = 11
	// Games
	IndustryCategory_GAMES IndustryCategory = 12
	// Hobbies and leisure
	IndustryCategory_HOBBIES_AND_LEISURE IndustryCategory = 13
	// Home and garden
	IndustryCategory_HOME_AND_GARDEN IndustryCategory = 14
	// Internet and telecom
	IndustryCategory_INTERNET_AND_TELECOM IndustryCategory = 15
	// Law and government
	IndustryCategory_LAW_AND_GOVERNMENT IndustryCategory = 16
	// News
	IndustryCategory_NEWS IndustryCategory = 17
	// Online communities
	IndustryCategory_ONLINE_COMMUNITIES IndustryCategory = 18
	// People and society
	IndustryCategory_PEOPLE_AND_SOCIETY IndustryCategory = 19
	// Pets and animals
	IndustryCategory_PETS_AND_ANIMALS IndustryCategory = 20
	// Real estate
	IndustryCategory_REAL_ESTATE IndustryCategory = 21
	// Reference
	IndustryCategory_REFERENCE IndustryCategory = 22
	// Science
	IndustryCategory_SCIENCE IndustryCategory = 23
	// Sports
	IndustryCategory_SPORTS IndustryCategory = 24
	// Jobs and education
	IndustryCategory_JOBS_AND_EDUCATION IndustryCategory = 25
	// Shopping
	IndustryCategory_SHOPPING IndustryCategory = 26
)

// Enum value maps for IndustryCategory.
var (
	IndustryCategory_name = map[int32]string{
		0:  "INDUSTRY_CATEGORY_UNSPECIFIED",
		1:  "AUTOMOTIVE",
		2:  "BUSINESS_AND_INDUSTRIAL_MARKETS",
		3:  "FINANCE",
		4:  "HEALTHCARE",
		5:  "TECHNOLOGY",
		6:  "TRAVEL",
		7:  "OTHER",
		8:  "ARTS_AND_ENTERTAINMENT",
		9:  "BEAUTY_AND_FITNESS",
		10: "BOOKS_AND_LITERATURE",
		11: "FOOD_AND_DRINK",
		12: "GAMES",
		13: "HOBBIES_AND_LEISURE",
		14: "HOME_AND_GARDEN",
		15: "INTERNET_AND_TELECOM",
		16: "LAW_AND_GOVERNMENT",
		17: "NEWS",
		18: "ONLINE_COMMUNITIES",
		19: "PEOPLE_AND_SOCIETY",
		20: "PETS_AND_ANIMALS",
		21: "REAL_ESTATE",
		22: "REFERENCE",
		23: "SCIENCE",
		24: "SPORTS",
		25: "JOBS_AND_EDUCATION",
		26: "SHOPPING",
	}
	IndustryCategory_value = map[string]int32{
		"INDUSTRY_CATEGORY_UNSPECIFIED":   0,
		"AUTOMOTIVE":                      1,
		"BUSINESS_AND_INDUSTRIAL_MARKETS": 2,
		"FINANCE":                         3,
		"HEALTHCARE":                      4,
		"TECHNOLOGY":                      5,
		"TRAVEL":                          6,
		"OTHER":                           7,
		"ARTS_AND_ENTERTAINMENT":          8,
		"BEAUTY_AND_FITNESS":              9,
		"BOOKS_AND_LITERATURE":            10,
		"FOOD_AND_DRINK":                  11,
		"GAMES":                           12,
		"HOBBIES_AND_LEISURE":             13,
		"HOME_AND_GARDEN":                 14,
		"INTERNET_AND_TELECOM":            15,
		"LAW_AND_GOVERNMENT":              16,
		"NEWS":                            17,
		"ONLINE_COMMUNITIES":              18,
		"PEOPLE_AND_SOCIETY":              19,
		"PETS_AND_ANIMALS":                20,
		"REAL_ESTATE":                     21,
		"REFERENCE":                       22,
		"SCIENCE":                         23,
		"SPORTS":                          24,
		"JOBS_AND_EDUCATION":              25,
		"SHOPPING":                        26,
	}
)

func (x IndustryCategory) Enum() *IndustryCategory {
	p := new(IndustryCategory)
	*p = x
	return p
}

func (x IndustryCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IndustryCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[0].Descriptor()
}

func (IndustryCategory) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[0]
}

func (x IndustryCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IndustryCategory.Descriptor instead.
func (IndustryCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{0}
}

// Maximum access settings that Firebase user receive on the linked Analytics
// property.
type MaximumUserAccess int32

const (
	// Unspecified maximum user access.
	MaximumUserAccess_MAXIMUM_USER_ACCESS_UNSPECIFIED MaximumUserAccess = 0
	// Firebase users have no access to the Analytics property.
	MaximumUserAccess_NO_ACCESS MaximumUserAccess = 1
	// Firebase users have Read & Analyze access to the Analytics property.
	MaximumUserAccess_READ_AND_ANALYZE MaximumUserAccess = 2
	// Firebase users have edit access to the Analytics property, but may not
	// manage the Firebase link.
	MaximumUserAccess_EDITOR_WITHOUT_LINK_MANAGEMENT MaximumUserAccess = 3
	// Firebase users have edit access to the Analytics property and may manage
	// the Firebase link.
	MaximumUserAccess_EDITOR_INCLUDING_LINK_MANAGEMENT MaximumUserAccess = 4
)

// Enum value maps for MaximumUserAccess.
var (
	MaximumUserAccess_name = map[int32]string{
		0: "MAXIMUM_USER_ACCESS_UNSPECIFIED",
		1: "NO_ACCESS",
		2: "READ_AND_ANALYZE",
		3: "EDITOR_WITHOUT_LINK_MANAGEMENT",
		4: "EDITOR_INCLUDING_LINK_MANAGEMENT",
	}
	MaximumUserAccess_value = map[string]int32{
		"MAXIMUM_USER_ACCESS_UNSPECIFIED":  0,
		"NO_ACCESS":                        1,
		"READ_AND_ANALYZE":                 2,
		"EDITOR_WITHOUT_LINK_MANAGEMENT":   3,
		"EDITOR_INCLUDING_LINK_MANAGEMENT": 4,
	}
)

func (x MaximumUserAccess) Enum() *MaximumUserAccess {
	p := new(MaximumUserAccess)
	*p = x
	return p
}

func (x MaximumUserAccess) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MaximumUserAccess) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_resources_proto_enumTypes[1].Descriptor()
}

func (MaximumUserAccess) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_resources_proto_enumTypes[1]
}

func (x MaximumUserAccess) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MaximumUserAccess.Descriptor instead.
func (MaximumUserAccess) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{1}
}

// A resource message representing a Google Analytics account.
type Account struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this account.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when this account was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when account payload fields were last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Human-readable display name for this account.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Country of business. Must be a non-deprecated code for a UN M.49 region.
	// https://unicode.org/cldr/charts/latest/supplemental/territory_containment_un_m_49.html
	CountryCode string `protobuf:"bytes,5,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Output only. Indicates whether this Account is soft-deleted or not. Deleted
	// accounts are excluded from List results unless specifically requested.
	Deleted bool `protobuf:"varint,6,opt,name=deleted,proto3" json:"deleted,omitempty"`
}

func (x *Account) Reset() {
	*x = Account{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Account) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Account) ProtoMessage() {}

func (x *Account) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Account.ProtoReflect.Descriptor instead.
func (*Account) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{0}
}

func (x *Account) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Account) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Account) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Account) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Account) GetCountryCode() string {
	if x != nil {
		return x.CountryCode
	}
	return ""
}

func (x *Account) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

// A resource message representing a Google Analytics App+Web property.
type Property struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this property.
	// Format: properties/{property_id}
	// Example: "properties/1000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when the entity was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when entity payload fields were last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Immutable. Resource name of this property's logical parent.
	//
	// Note: The Property-Moving UI can be used to change the parent.
	// Format: accounts/{account}
	// Example: "accounts/100"
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Human-readable display name for this property.
	//
	// The max allowed display name length is 100 UTF-16 code units.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Industry associated with this property
	// Example: AUTOMOTIVE, FOOD_AND_DRINK
	IndustryCategory IndustryCategory `protobuf:"varint,6,opt,name=industry_category,json=industryCategory,proto3,enum=google.analytics.admin.v1alpha.IndustryCategory" json:"industry_category,omitempty"`
	// Reporting Time Zone, used as the day boundary for reports, regardless of
	// where the data originates. If the time zone honors DST, Analytics will
	// automatically adjust for the changes.
	//
	// NOTE: Changing the time zone only affects data going forward, and is not
	// applied retroactively.
	//
	// Format: https://www.iana.org/time-zones
	// Example: "America/Los_Angeles"
	TimeZone string `protobuf:"bytes,7,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// The currency type used in reports involving monetary values.
	//
	//
	// Format: https://en.wikipedia.org/wiki/ISO_4217
	// Examples: "USD", "EUR", "JPY"
	CurrencyCode string `protobuf:"bytes,8,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Output only. Indicates whether this Property is soft-deleted or not. Deleted properties
	// are excluded from List results unless specifically requested.
	Deleted bool `protobuf:"varint,9,opt,name=deleted,proto3" json:"deleted,omitempty"`
}

func (x *Property) Reset() {
	*x = Property{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Property) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Property) ProtoMessage() {}

func (x *Property) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Property.ProtoReflect.Descriptor instead.
func (*Property) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{1}
}

func (x *Property) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Property) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Property) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Property) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *Property) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Property) GetIndustryCategory() IndustryCategory {
	if x != nil {
		return x.IndustryCategory
	}
	return IndustryCategory_INDUSTRY_CATEGORY_UNSPECIFIED
}

func (x *Property) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *Property) GetCurrencyCode() string {
	if x != nil {
		return x.CurrencyCode
	}
	return ""
}

func (x *Property) GetDeleted() bool {
	if x != nil {
		return x.Deleted
	}
	return false
}

// A resource message representing a Google Analytics Android app stream.
type AndroidAppDataStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this Data Stream.
	// Format: properties/{property_id}/androidAppDataStreams/{stream_id}
	// Example: "properties/1000/androidAppDataStreams/2000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. ID of the corresponding Android app in Firebase, if any.
	// This ID can change if the Android app is deleted and recreated.
	FirebaseAppId string `protobuf:"bytes,2,opt,name=firebase_app_id,json=firebaseAppId,proto3" json:"firebase_app_id,omitempty"`
	// Output only. Time when this stream was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when stream payload fields were last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Immutable. The package name for the app being measured.
	// Example: "com.example.myandroidapp"
	PackageName string `protobuf:"bytes,5,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	// Human-readable display name for the Data Stream.
	//
	// The max allowed display name length is 255 UTF-16 code units.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *AndroidAppDataStream) Reset() {
	*x = AndroidAppDataStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AndroidAppDataStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AndroidAppDataStream) ProtoMessage() {}

func (x *AndroidAppDataStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AndroidAppDataStream.ProtoReflect.Descriptor instead.
func (*AndroidAppDataStream) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{2}
}

func (x *AndroidAppDataStream) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AndroidAppDataStream) GetFirebaseAppId() string {
	if x != nil {
		return x.FirebaseAppId
	}
	return ""
}

func (x *AndroidAppDataStream) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AndroidAppDataStream) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AndroidAppDataStream) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *AndroidAppDataStream) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// A resource message representing a Google Analytics IOS app stream.
type IosAppDataStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this Data Stream.
	// Format: properties/{property_id}/iosAppDataStreams/{stream_id}
	// Example: "properties/1000/iosAppDataStreams/2000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. ID of the corresponding iOS app in Firebase, if any.
	// This ID can change if the iOS app is deleted and recreated.
	FirebaseAppId string `protobuf:"bytes,2,opt,name=firebase_app_id,json=firebaseAppId,proto3" json:"firebase_app_id,omitempty"`
	// Output only. Time when this stream was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when stream payload fields were last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Immutable. The Apple App Store Bundle ID for the app
	// Example: "com.example.myiosapp"
	BundleId string `protobuf:"bytes,5,opt,name=bundle_id,json=bundleId,proto3" json:"bundle_id,omitempty"`
	// Human-readable display name for the Data Stream.
	//
	// The max allowed display name length is 255 UTF-16 code units.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *IosAppDataStream) Reset() {
	*x = IosAppDataStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IosAppDataStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IosAppDataStream) ProtoMessage() {}

func (x *IosAppDataStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IosAppDataStream.ProtoReflect.Descriptor instead.
func (*IosAppDataStream) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{3}
}

func (x *IosAppDataStream) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IosAppDataStream) GetFirebaseAppId() string {
	if x != nil {
		return x.FirebaseAppId
	}
	return ""
}

func (x *IosAppDataStream) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *IosAppDataStream) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *IosAppDataStream) GetBundleId() string {
	if x != nil {
		return x.BundleId
	}
	return ""
}

func (x *IosAppDataStream) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// A resource message representing a Google Analytics web stream.
type WebDataStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this Data Stream.
	// Format: properties/{property_id}/webDataStreams/{stream_id}
	// Example: "properties/1000/webDataStreams/2000"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Analytics "Measurement ID", without the "G-" prefix.
	// Example: "G-1A2BCD345E" would just be "1A2BCD345E"
	MeasurementId string `protobuf:"bytes,2,opt,name=measurement_id,json=measurementId,proto3" json:"measurement_id,omitempty"`
	// Output only. ID of the corresponding web app in Firebase, if any.
	// This ID can change if the web app is deleted and recreated.
	FirebaseAppId string `protobuf:"bytes,3,opt,name=firebase_app_id,json=firebaseAppId,proto3" json:"firebase_app_id,omitempty"`
	// Output only. Time when this stream was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when stream payload fields were last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Immutable. Domain name of the web app being measured, or empty.
	// Example: "http://www.google.com", "https://www.google.com"
	DefaultUri string `protobuf:"bytes,6,opt,name=default_uri,json=defaultUri,proto3" json:"default_uri,omitempty"`
	// Required. Human-readable display name for the Data Stream.
	//
	// The max allowed display name length is 100 UTF-16 code units.
	DisplayName string `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *WebDataStream) Reset() {
	*x = WebDataStream{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebDataStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebDataStream) ProtoMessage() {}

func (x *WebDataStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebDataStream.ProtoReflect.Descriptor instead.
func (*WebDataStream) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{4}
}

func (x *WebDataStream) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *WebDataStream) GetMeasurementId() string {
	if x != nil {
		return x.MeasurementId
	}
	return ""
}

func (x *WebDataStream) GetFirebaseAppId() string {
	if x != nil {
		return x.FirebaseAppId
	}
	return ""
}

func (x *WebDataStream) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *WebDataStream) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *WebDataStream) GetDefaultUri() string {
	if x != nil {
		return x.DefaultUri
	}
	return ""
}

func (x *WebDataStream) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// A resource message representing a user's permissions on an Account or
// Property resource.
type UserLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Example format: properties/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Email address of the user to link
	EmailAddress string `protobuf:"bytes,2,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	// Roles directly assigned to this user for this account or property.
	//
	// Valid values:
	// predefinedRoles/read
	// predefinedRoles/collaborate
	// predefinedRoles/edit
	// predefinedRoles/manage-users
	//
	// Excludes roles that are inherited from a higher-level entity, group,
	// or organization admin role.
	//
	// A UserLink that is updated to have an empty list of direct_roles will be
	// deleted.
	DirectRoles []string `protobuf:"bytes,3,rep,name=direct_roles,json=directRoles,proto3" json:"direct_roles,omitempty"`
}

func (x *UserLink) Reset() {
	*x = UserLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserLink) ProtoMessage() {}

func (x *UserLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserLink.ProtoReflect.Descriptor instead.
func (*UserLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{5}
}

func (x *UserLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UserLink) GetEmailAddress() string {
	if x != nil {
		return x.EmailAddress
	}
	return ""
}

func (x *UserLink) GetDirectRoles() []string {
	if x != nil {
		return x.DirectRoles
	}
	return nil
}

// Read-only resource used to summarize a principal's effective roles.
type AuditUserLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Example format: properties/1234/userLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Email address of the linked user
	EmailAddress string `protobuf:"bytes,2,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	// Roles directly assigned to this user for this entity.
	//
	// Format: predefinedRoles/read
	//
	// Excludes roles that are inherited from an account (if this is for a
	// property), group, or organization admin role.
	DirectRoles []string `protobuf:"bytes,3,rep,name=direct_roles,json=directRoles,proto3" json:"direct_roles,omitempty"`
	// Union of all permissions a user has at this account or property (includes
	// direct permissions, group-inherited permissions, etc.).
	//
	// Format: predefinedRoles/read
	EffectiveRoles []string `protobuf:"bytes,4,rep,name=effective_roles,json=effectiveRoles,proto3" json:"effective_roles,omitempty"`
}

func (x *AuditUserLink) Reset() {
	*x = AuditUserLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditUserLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditUserLink) ProtoMessage() {}

func (x *AuditUserLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditUserLink.ProtoReflect.Descriptor instead.
func (*AuditUserLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{6}
}

func (x *AuditUserLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AuditUserLink) GetEmailAddress() string {
	if x != nil {
		return x.EmailAddress
	}
	return ""
}

func (x *AuditUserLink) GetDirectRoles() []string {
	if x != nil {
		return x.DirectRoles
	}
	return nil
}

func (x *AuditUserLink) GetEffectiveRoles() []string {
	if x != nil {
		return x.EffectiveRoles
	}
	return nil
}

// Singleton resource under a WebDataStream, configuring measurement of
// additional site interactions and content.
type EnhancedMeasurementSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of this Data Stream.
	// Format:
	// properties/{property_id}/webDataStreams/{stream_id}/enhancedMeasurementSettings
	// Example: "properties/1000/webDataStreams/2000/enhancedMeasurementSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Indicates whether Enhanced Measurement Settings will be used to
	// automatically measure interactions and content on this web stream.
	//
	// Changing this value does not affect the settings themselves, but determines
	// whether they are respected.
	StreamEnabled bool `protobuf:"varint,2,opt,name=stream_enabled,json=streamEnabled,proto3" json:"stream_enabled,omitempty"`
	// Output only. If enabled, capture a page view event each time a page loads or the
	// website changes the browser history state.
	PageViewsEnabled bool `protobuf:"varint,3,opt,name=page_views_enabled,json=pageViewsEnabled,proto3" json:"page_views_enabled,omitempty"`
	// If enabled, capture scroll events each time a visitor gets to the bottom of
	// a page.
	ScrollsEnabled bool `protobuf:"varint,4,opt,name=scrolls_enabled,json=scrollsEnabled,proto3" json:"scrolls_enabled,omitempty"`
	// If enabled, capture an outbound click event each time a visitor clicks a
	// link that leads them away from your domain.
	OutboundClicksEnabled bool `protobuf:"varint,5,opt,name=outbound_clicks_enabled,json=outboundClicksEnabled,proto3" json:"outbound_clicks_enabled,omitempty"`
	// Capture events when your visitors view content on your site that has
	// structured data (eg, articles, blog posts, product details screens, etc.).
	ContentViewsEnabled bool `protobuf:"varint,6,opt,name=content_views_enabled,json=contentViewsEnabled,proto3" json:"content_views_enabled,omitempty"`
	// If enabled, capture a view search results event each time a visitor
	// performs a search on your site (based on a query parameter).
	SiteSearchEnabled bool `protobuf:"varint,7,opt,name=site_search_enabled,json=siteSearchEnabled,proto3" json:"site_search_enabled,omitempty"`
	// If enabled, capture a view search results event each time a visitor
	// interacts with a form on your site.
	FormInteractionsEnabled bool `protobuf:"varint,8,opt,name=form_interactions_enabled,json=formInteractionsEnabled,proto3" json:"form_interactions_enabled,omitempty"`
	// If enabled, capture video play, progress, and complete events as visitors
	// view embedded videos on your site.
	VideoEngagementEnabled bool `protobuf:"varint,9,opt,name=video_engagement_enabled,json=videoEngagementEnabled,proto3" json:"video_engagement_enabled,omitempty"`
	// If enabled, capture a file download event each time a link is clicked with
	// a common document, compressed file, application, video, or audio extension.
	FileDownloadsEnabled bool `protobuf:"varint,10,opt,name=file_downloads_enabled,json=fileDownloadsEnabled,proto3" json:"file_downloads_enabled,omitempty"`
	// If enabled, capture a click event each time a visitor clicks a link or
	// element that has data attributes beginning with "data-ga".
	DataTaggedElementClicksEnabled bool `protobuf:"varint,11,opt,name=data_tagged_element_clicks_enabled,json=dataTaggedElementClicksEnabled,proto3" json:"data_tagged_element_clicks_enabled,omitempty"`
	// If enabled, capture a page view event each time a page loads.
	PageLoadsEnabled bool `protobuf:"varint,12,opt,name=page_loads_enabled,json=pageLoadsEnabled,proto3" json:"page_loads_enabled,omitempty"`
	// If enabled, capture a page view event each time the website changes the
	// browser history state.
	PageChangesEnabled bool `protobuf:"varint,13,opt,name=page_changes_enabled,json=pageChangesEnabled,proto3" json:"page_changes_enabled,omitempty"`
	// Capture events when your visitors view content on your site that has
	// articles or blog posts.
	ArticlesAndBlogsEnabled bool `protobuf:"varint,14,opt,name=articles_and_blogs_enabled,json=articlesAndBlogsEnabled,proto3" json:"articles_and_blogs_enabled,omitempty"`
	// Capture events when your visitors view content on your site that has
	// product details screens, etc.
	ProductsAndEcommerceEnabled bool `protobuf:"varint,15,opt,name=products_and_ecommerce_enabled,json=productsAndEcommerceEnabled,proto3" json:"products_and_ecommerce_enabled,omitempty"`
	// Required. URL query parameters to interpret as site search parameters.
	// Max length is 1024 characters. Must not be empty.
	SearchQueryParameter string `protobuf:"bytes,16,opt,name=search_query_parameter,json=searchQueryParameter,proto3" json:"search_query_parameter,omitempty"`
	// Additional URL query parameters.
	// Max length is 1024 characters.
	UrlQueryParameter string `protobuf:"bytes,17,opt,name=url_query_parameter,json=urlQueryParameter,proto3" json:"url_query_parameter,omitempty"`
	// Domains to exclude from measurement. Max length is 1024 characters.
	ExcludedDomains string `protobuf:"bytes,18,opt,name=excluded_domains,json=excludedDomains,proto3" json:"excluded_domains,omitempty"`
}

func (x *EnhancedMeasurementSettings) Reset() {
	*x = EnhancedMeasurementSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnhancedMeasurementSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnhancedMeasurementSettings) ProtoMessage() {}

func (x *EnhancedMeasurementSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnhancedMeasurementSettings.ProtoReflect.Descriptor instead.
func (*EnhancedMeasurementSettings) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{7}
}

func (x *EnhancedMeasurementSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EnhancedMeasurementSettings) GetStreamEnabled() bool {
	if x != nil {
		return x.StreamEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetPageViewsEnabled() bool {
	if x != nil {
		return x.PageViewsEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetScrollsEnabled() bool {
	if x != nil {
		return x.ScrollsEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetOutboundClicksEnabled() bool {
	if x != nil {
		return x.OutboundClicksEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetContentViewsEnabled() bool {
	if x != nil {
		return x.ContentViewsEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetSiteSearchEnabled() bool {
	if x != nil {
		return x.SiteSearchEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetFormInteractionsEnabled() bool {
	if x != nil {
		return x.FormInteractionsEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetVideoEngagementEnabled() bool {
	if x != nil {
		return x.VideoEngagementEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetFileDownloadsEnabled() bool {
	if x != nil {
		return x.FileDownloadsEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetDataTaggedElementClicksEnabled() bool {
	if x != nil {
		return x.DataTaggedElementClicksEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetPageLoadsEnabled() bool {
	if x != nil {
		return x.PageLoadsEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetPageChangesEnabled() bool {
	if x != nil {
		return x.PageChangesEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetArticlesAndBlogsEnabled() bool {
	if x != nil {
		return x.ArticlesAndBlogsEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetProductsAndEcommerceEnabled() bool {
	if x != nil {
		return x.ProductsAndEcommerceEnabled
	}
	return false
}

func (x *EnhancedMeasurementSettings) GetSearchQueryParameter() string {
	if x != nil {
		return x.SearchQueryParameter
	}
	return ""
}

func (x *EnhancedMeasurementSettings) GetUrlQueryParameter() string {
	if x != nil {
		return x.UrlQueryParameter
	}
	return ""
}

func (x *EnhancedMeasurementSettings) GetExcludedDomains() string {
	if x != nil {
		return x.ExcludedDomains
	}
	return ""
}

// A link between an App+Web property and a Firebase project.
type FirebaseLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Example format: properties/1234/firebaseLinks/5678
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. Firebase project resource name. When creating a FirebaseLink, you may
	// provide this resource name using either a project number or project ID.
	// Once this resource has been created, returned FirebaseLinks will always
	// have a project_name that contains a project number.
	//
	// Format: 'projects/{project number}'
	// Example: 'projects/1234'
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// Output only. Time when this FirebaseLink was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Maximum user access to the App + Web property allowed to admins of
	// the linked Firebase project.
	MaximumUserAccess MaximumUserAccess `protobuf:"varint,4,opt,name=maximum_user_access,json=maximumUserAccess,proto3,enum=google.analytics.admin.v1alpha.MaximumUserAccess" json:"maximum_user_access,omitempty"`
}

func (x *FirebaseLink) Reset() {
	*x = FirebaseLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FirebaseLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FirebaseLink) ProtoMessage() {}

func (x *FirebaseLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FirebaseLink.ProtoReflect.Descriptor instead.
func (*FirebaseLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{8}
}

func (x *FirebaseLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FirebaseLink) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *FirebaseLink) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *FirebaseLink) GetMaximumUserAccess() MaximumUserAccess {
	if x != nil {
		return x.MaximumUserAccess
	}
	return MaximumUserAccess_MAXIMUM_USER_ACCESS_UNSPECIFIED
}

// Read-only resource with the tag for sending data from a website to a
// WebDataStream.
type GlobalSiteTag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. JavaScript code snippet to be pasted as the first item into the head tag of
	// every webpage to measure.
	Snippet string `protobuf:"bytes,1,opt,name=snippet,proto3" json:"snippet,omitempty"`
}

func (x *GlobalSiteTag) Reset() {
	*x = GlobalSiteTag{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GlobalSiteTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalSiteTag) ProtoMessage() {}

func (x *GlobalSiteTag) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalSiteTag.ProtoReflect.Descriptor instead.
func (*GlobalSiteTag) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{9}
}

func (x *GlobalSiteTag) GetSnippet() string {
	if x != nil {
		return x.Snippet
	}
	return ""
}

// A link between an App+Web property and a Google Ads account.
type GoogleAdsLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Format: properties/{propertyId}/googleAdsLinks/{googleAdsLinkId}
	//
	// Note: googleAdsLinkId is not the Google Ads customer ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. Format: properties/{propertyId}
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// Immutable. Google Ads customer ID.
	CustomerId string `protobuf:"bytes,3,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Output only. If true, this link is for a Google Ads manager account.
	CanManageClients bool `protobuf:"varint,4,opt,name=can_manage_clients,json=canManageClients,proto3" json:"can_manage_clients,omitempty"`
	// Enable personalized advertising features with this integration.
	// Automatically publish my Google Analytics audience lists and Google
	// Analytics remarketing events/parameters to the linked Google Ads account.
	// If this field is not set on create/update it will be defaulted to true.
	AdsPersonalizationEnabled *wrapperspb.BoolValue `protobuf:"bytes,5,opt,name=ads_personalization_enabled,json=adsPersonalizationEnabled,proto3" json:"ads_personalization_enabled,omitempty"`
	// Output only. Email address of the user that created the link.
	// An empty string will be returned if the email address can't be retrieved.
	EmailAddress string `protobuf:"bytes,6,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	// Output only. Time when this link was originally created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when this link was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *GoogleAdsLink) Reset() {
	*x = GoogleAdsLink{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GoogleAdsLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GoogleAdsLink) ProtoMessage() {}

func (x *GoogleAdsLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GoogleAdsLink.ProtoReflect.Descriptor instead.
func (*GoogleAdsLink) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{10}
}

func (x *GoogleAdsLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GoogleAdsLink) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GoogleAdsLink) GetCustomerId() string {
	if x != nil {
		return x.CustomerId
	}
	return ""
}

func (x *GoogleAdsLink) GetCanManageClients() bool {
	if x != nil {
		return x.CanManageClients
	}
	return false
}

func (x *GoogleAdsLink) GetAdsPersonalizationEnabled() *wrapperspb.BoolValue {
	if x != nil {
		return x.AdsPersonalizationEnabled
	}
	return nil
}

func (x *GoogleAdsLink) GetEmailAddress() string {
	if x != nil {
		return x.EmailAddress
	}
	return ""
}

func (x *GoogleAdsLink) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GoogleAdsLink) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A resource message representing data sharing settings of a Google Analytics
// account.
type DataSharingSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name.
	// Format: accounts/{account}/dataSharingSettings
	// Example: "accounts/1000/dataSharingSettings"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Allows Google support to access the data in order to help troubleshoot
	// issues.
	SharingWithGoogleSupportEnabled bool `protobuf:"varint,2,opt,name=sharing_with_google_support_enabled,json=sharingWithGoogleSupportEnabled,proto3" json:"sharing_with_google_support_enabled,omitempty"`
	// Allows Google sales teams that are assigned to the customer to access the
	// data in order to suggest configuration changes to improve results.
	// Sales team restrictions still apply when enabled.
	SharingWithGoogleAssignedSalesEnabled bool `protobuf:"varint,3,opt,name=sharing_with_google_assigned_sales_enabled,json=sharingWithGoogleAssignedSalesEnabled,proto3" json:"sharing_with_google_assigned_sales_enabled,omitempty"`
	// Allows any of Google sales to access the data in order to suggest
	// configuration changes to improve results.
	SharingWithGoogleAnySalesEnabled bool `protobuf:"varint,4,opt,name=sharing_with_google_any_sales_enabled,json=sharingWithGoogleAnySalesEnabled,proto3" json:"sharing_with_google_any_sales_enabled,omitempty"`
	// Allows Google to use the data to improve other Google products or services.
	SharingWithGoogleProductsEnabled bool `protobuf:"varint,5,opt,name=sharing_with_google_products_enabled,json=sharingWithGoogleProductsEnabled,proto3" json:"sharing_with_google_products_enabled,omitempty"`
	// Allows Google to share the data anonymously in aggregate form with others.
	SharingWithOthersEnabled bool `protobuf:"varint,6,opt,name=sharing_with_others_enabled,json=sharingWithOthersEnabled,proto3" json:"sharing_with_others_enabled,omitempty"`
}

func (x *DataSharingSettings) Reset() {
	*x = DataSharingSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DataSharingSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataSharingSettings) ProtoMessage() {}

func (x *DataSharingSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataSharingSettings.ProtoReflect.Descriptor instead.
func (*DataSharingSettings) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP(), []int{11}
}

func (x *DataSharingSettings) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DataSharingSettings) GetSharingWithGoogleSupportEnabled() bool {
	if x != nil {
		return x.SharingWithGoogleSupportEnabled
	}
	return false
}

func (x *DataSharingSettings) GetSharingWithGoogleAssignedSalesEnabled() bool {
	if x != nil {
		return x.SharingWithGoogleAssignedSalesEnabled
	}
	return false
}

func (x *DataSharingSettings) GetSharingWithGoogleAnySalesEnabled() bool {
	if x != nil {
		return x.SharingWithGoogleAnySalesEnabled
	}
	return false
}

func (x *DataSharingSettings) GetSharingWithGoogleProductsEnabled() bool {
	if x != nil {
		return x.SharingWithGoogleProductsEnabled
	}
	return false
}

func (x *DataSharingSettings) GetSharingWithOthersEnabled() bool {
	if x != nil {
		return x.SharingWithOthersEnabled
	}
	return false
}

var File_google_analytics_admin_v1alpha_resources_proto protoreflect.FileDescriptor

var file_google_analytics_admin_v1alpha_resources_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77,
	0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd0, 0x02,
	0x0a, 0x07, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x3a, 0x3e, 0xea, 0x41, 0x3b, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d,
	0x22, 0xf0, 0x03, 0x0a, 0x08, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x5d, 0x0a, 0x11, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x75,
	0x73, 0x74, 0x72, 0x79, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x10, 0x69, 0x6e,
	0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x1b,
	0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x1d, 0x0a, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x3a,
	0x42, 0xea, 0x41, 0x3f, 0x0a, 0x26, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x12, 0x15, 0x70, 0x72,
	0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x79, 0x7d, 0x22, 0xab, 0x03, 0x0a, 0x14, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41,
	0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73,
	0x65, 0x5f, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x41, 0x70, 0x70,
	0x49, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x3a, 0x7e, 0xea, 0x41, 0x7b, 0x0a, 0x32, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70,
	0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x45, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
	0x7d, 0x2f, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64,
	0x5f, 0x61, 0x70, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x7d, 0x22, 0x98, 0x03, 0x0a, 0x10, 0x49, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2b, 0x0a, 0x0f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66,
	0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x41, 0x70, 0x70, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x23, 0x0a, 0x09, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x62, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x3a, 0x72, 0xea, 0x41, 0x6f, 0x0a, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6f, 0x73,
	0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x3d, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x7d, 0x2f, 0x69, 0x6f, 0x73, 0x41, 0x70, 0x70, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x7b, 0x69, 0x6f, 0x73, 0x5f, 0x61, 0x70, 0x70, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x7d, 0x22, 0xbd, 0x03, 0x0a,
	0x0d, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x6d, 0x65, 0x61, 0x73, 0x75,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x0f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x41, 0x70, 0x70, 0x49, 0x64,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a,
	0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x55, 0x72, 0x69, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x3a, 0x68, 0xea, 0x41, 0x65, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x77, 0x65, 0x62, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73, 0x2f, 0x7b, 0x77, 0x65, 0x62, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x7d, 0x22, 0xeb, 0x01, 0x0a,
	0x08, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x6f, 0x6c,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x52, 0x6f, 0x6c, 0x65, 0x73, 0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x26, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x73, 0x65, 0x72, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x28, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x2f, 0x7b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x7d, 0x12, 0x2b, 0x70,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x79, 0x7d, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x7d, 0x22, 0x94, 0x01, 0x0a, 0x0d, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f,
	0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0e, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52, 0x6f, 0x6c, 0x65,
	0x73, 0x22, 0xdb, 0x08, 0x0a, 0x1b, 0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0d, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x31, 0x0a, 0x12, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x10, 0x70, 0x61, 0x67, 0x65, 0x56, 0x69, 0x65, 0x77, 0x73, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x63, 0x72, 0x6f, 0x6c, 0x6c, 0x73, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x73,
	0x63, 0x72, 0x6f, 0x6c, 0x6c, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x36, 0x0a,
	0x17, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x73,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15,
	0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x5f, 0x76, 0x69, 0x65, 0x77, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x56, 0x69, 0x65,
	0x77, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x73, 0x69, 0x74,
	0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x73, 0x69, 0x74, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x3a, 0x0a, 0x19, 0x66, 0x6f, 0x72,
	0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x66, 0x6f,
	0x72, 0x6d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x38, 0x0a, 0x18, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x65,
	0x6e, 0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x45, 0x6e,
	0x67, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x34, 0x0a, 0x16, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x14, 0x66, 0x69, 0x6c, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4a, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x61,
	0x67, 0x67, 0x65, 0x64, 0x5f, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x69,
	0x63, 0x6b, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x1e, 0x64, 0x61, 0x74, 0x61, 0x54, 0x61, 0x67, 0x67, 0x65, 0x64, 0x45, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x2c, 0x0a, 0x12, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x70,
	0x61, 0x67, 0x65, 0x4c, 0x6f, 0x61, 0x64, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x30, 0x0a, 0x14, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x70,
	0x61, 0x67, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x12, 0x3b, 0x0a, 0x1a, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x5f, 0x61, 0x6e,
	0x64, 0x5f, 0x62, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x41,
	0x6e, 0x64, 0x42, 0x6c, 0x6f, 0x67, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x43,
	0x0a, 0x1e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1b, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
	0x41, 0x6e, 0x64, 0x45, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x12, 0x39, 0x0a, 0x16, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x2e,
	0x0a, 0x13, 0x75, 0x72, 0x6c, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x75, 0x72, 0x6c,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x29,
	0x0a, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x6d, 0x61, 0x69,
	0x6e, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x64, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x3a, 0x93, 0x01, 0xea, 0x41, 0x8f, 0x01,
	0x0a, 0x39, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x52, 0x70, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x79, 0x7d, 0x2f, 0x77, 0x65, 0x62, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x73, 0x2f, 0x7b, 0x77, 0x65, 0x62, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x7d, 0x2f, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x4d, 0x65, 0x61, 0x73,
	0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22,
	0xd1, 0x02, 0x0a, 0x0c, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x61, 0x0a, 0x13, 0x6d, 0x61,
	0x78, 0x69, 0x6d, 0x75, 0x6d, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4d, 0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d,
	0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x69,
	0x6d, 0x75, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x3a, 0x64, 0xea,
	0x41, 0x61, 0x0a, 0x2a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x46, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x33,
	0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x4c, 0x69,
	0x6e, 0x6b, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x72, 0x65, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x7d, 0x22, 0x85, 0x01, 0x0a, 0x0d, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69,
	0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x07, 0x73, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x3a, 0x55, 0xea, 0x41, 0x52, 0x0a, 0x2b, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53,
	0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x12, 0x23, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f, 0x67, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x74, 0x65, 0x54, 0x61, 0x67, 0x22, 0x92, 0x04, 0x0a, 0x0d,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x12, 0x63, 0x61, 0x6e,
	0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x63, 0x61, 0x6e, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x5a, 0x0a, 0x1b,
	0x61, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x19, 0x61,
	0x64, 0x73, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x65, 0x6d, 0x61, 0x69,
	0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x3a, 0x68, 0xea, 0x41, 0x65, 0x0a, 0x2b, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x7d, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x64, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x7d,
	0x22, 0x97, 0x04, 0x0a, 0x13, 0x44, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x4c, 0x0a, 0x23, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x74,
	0x68, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1f,
	0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x74, 0x68, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12,
	0x59, 0x0a, 0x2a, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f,
	0x73, 0x61, 0x6c, 0x65, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x25, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x74, 0x68,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x53, 0x61,
	0x6c, 0x65, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4f, 0x0a, 0x25, 0x73, 0x68,
	0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5f, 0x61, 0x6e, 0x79, 0x5f, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x20, 0x73, 0x68, 0x61, 0x72, 0x69,
	0x6e, 0x67, 0x57, 0x69, 0x74, 0x68, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x6e, 0x79, 0x53,
	0x61, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x4e, 0x0a, 0x24, 0x73,
	0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x20, 0x73, 0x68, 0x61, 0x72, 0x69,
	0x6e, 0x67, 0x57, 0x69, 0x74, 0x68, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x3d, 0x0a, 0x1b, 0x73,
	0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x6f, 0x74, 0x68, 0x65,
	0x72, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x18, 0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x57, 0x69, 0x74, 0x68, 0x4f, 0x74, 0x68,
	0x65, 0x72, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x3a, 0x5e, 0xea, 0x41, 0x5b, 0x0a,
	0x31, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x26, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x68, 0x61, 0x72, 0x69,
	0x6e, 0x67, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2a, 0xaa, 0x04, 0x0a, 0x10, 0x49,
	0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12,
	0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x44, 0x55, 0x53, 0x54, 0x52, 0x59, 0x5f, 0x43, 0x41, 0x54, 0x45,
	0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x4f, 0x54, 0x49, 0x56, 0x45,
	0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x42, 0x55, 0x53, 0x49, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x41,
	0x4e, 0x44, 0x5f, 0x49, 0x4e, 0x44, 0x55, 0x53, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x5f, 0x4d, 0x41,
	0x52, 0x4b, 0x45, 0x54, 0x53, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x49, 0x4e, 0x41, 0x4e,
	0x43, 0x45, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x43, 0x41,
	0x52, 0x45, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x54, 0x45, 0x43, 0x48, 0x4e, 0x4f, 0x4c, 0x4f,
	0x47, 0x59, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x54, 0x52, 0x41, 0x56, 0x45, 0x4c, 0x10, 0x06,
	0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x07, 0x12, 0x1a, 0x0a, 0x16, 0x41,
	0x52, 0x54, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x54, 0x41, 0x49,
	0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x08, 0x12, 0x16, 0x0a, 0x12, 0x42, 0x45, 0x41, 0x55, 0x54,
	0x59, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x46, 0x49, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x10, 0x09, 0x12,
	0x18, 0x0a, 0x14, 0x42, 0x4f, 0x4f, 0x4b, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4c, 0x49, 0x54,
	0x45, 0x52, 0x41, 0x54, 0x55, 0x52, 0x45, 0x10, 0x0a, 0x12, 0x12, 0x0a, 0x0e, 0x46, 0x4f, 0x4f,
	0x44, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x44, 0x52, 0x49, 0x4e, 0x4b, 0x10, 0x0b, 0x12, 0x09, 0x0a,
	0x05, 0x47, 0x41, 0x4d, 0x45, 0x53, 0x10, 0x0c, 0x12, 0x17, 0x0a, 0x13, 0x48, 0x4f, 0x42, 0x42,
	0x49, 0x45, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x49, 0x53, 0x55, 0x52, 0x45, 0x10,
	0x0d, 0x12, 0x13, 0x0a, 0x0f, 0x48, 0x4f, 0x4d, 0x45, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x47, 0x41,
	0x52, 0x44, 0x45, 0x4e, 0x10, 0x0e, 0x12, 0x18, 0x0a, 0x14, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e,
	0x45, 0x54, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x54, 0x45, 0x4c, 0x45, 0x43, 0x4f, 0x4d, 0x10, 0x0f,
	0x12, 0x16, 0x0a, 0x12, 0x4c, 0x41, 0x57, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x47, 0x4f, 0x56, 0x45,
	0x52, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x10, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x45, 0x57, 0x53,
	0x10, 0x11, 0x12, 0x16, 0x0a, 0x12, 0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x43, 0x4f, 0x4d,
	0x4d, 0x55, 0x4e, 0x49, 0x54, 0x49, 0x45, 0x53, 0x10, 0x12, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x45,
	0x4f, 0x50, 0x4c, 0x45, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x53, 0x4f, 0x43, 0x49, 0x45, 0x54, 0x59,
	0x10, 0x13, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x45, 0x54, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41,
	0x4e, 0x49, 0x4d, 0x41, 0x4c, 0x53, 0x10, 0x14, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x41, 0x4c,
	0x5f, 0x45, 0x53, 0x54, 0x41, 0x54, 0x45, 0x10, 0x15, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x46,
	0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x16, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x43, 0x49, 0x45,
	0x4e, 0x43, 0x45, 0x10, 0x17, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x50, 0x4f, 0x52, 0x54, 0x53, 0x10,
	0x18, 0x12, 0x16, 0x0a, 0x12, 0x4a, 0x4f, 0x42, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x45, 0x44,
	0x55, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x19, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x48, 0x4f,
	0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x1a, 0x2a, 0xa7, 0x01, 0x0a, 0x11, 0x4d, 0x61, 0x78, 0x69,
	0x6d, 0x75, 0x6d, 0x55, 0x73, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x23, 0x0a,
	0x1f, 0x4d, 0x41, 0x58, 0x49, 0x4d, 0x55, 0x4d, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x41, 0x43,
	0x43, 0x45, 0x53, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10,
	0x01, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x4e,
	0x41, 0x4c, 0x59, 0x5a, 0x45, 0x10, 0x02, 0x12, 0x22, 0x0a, 0x1e, 0x45, 0x44, 0x49, 0x54, 0x4f,
	0x52, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x4f, 0x55, 0x54, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x4d,
	0x41, 0x4e, 0x41, 0x47, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x24, 0x0a, 0x20, 0x45,
	0x44, 0x49, 0x54, 0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x49, 0x4e, 0x47, 0x5f,
	0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10,
	0x04, 0x42, 0x7b, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x3b, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_admin_v1alpha_resources_proto_rawDescOnce sync.Once
	file_google_analytics_admin_v1alpha_resources_proto_rawDescData = file_google_analytics_admin_v1alpha_resources_proto_rawDesc
)

func file_google_analytics_admin_v1alpha_resources_proto_rawDescGZIP() []byte {
	file_google_analytics_admin_v1alpha_resources_proto_rawDescOnce.Do(func() {
		file_google_analytics_admin_v1alpha_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_admin_v1alpha_resources_proto_rawDescData)
	})
	return file_google_analytics_admin_v1alpha_resources_proto_rawDescData
}

var file_google_analytics_admin_v1alpha_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_analytics_admin_v1alpha_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_analytics_admin_v1alpha_resources_proto_goTypes = []interface{}{
	(IndustryCategory)(0),               // 0: google.analytics.admin.v1alpha.IndustryCategory
	(MaximumUserAccess)(0),              // 1: google.analytics.admin.v1alpha.MaximumUserAccess
	(*Account)(nil),                     // 2: google.analytics.admin.v1alpha.Account
	(*Property)(nil),                    // 3: google.analytics.admin.v1alpha.Property
	(*AndroidAppDataStream)(nil),        // 4: google.analytics.admin.v1alpha.AndroidAppDataStream
	(*IosAppDataStream)(nil),            // 5: google.analytics.admin.v1alpha.IosAppDataStream
	(*WebDataStream)(nil),               // 6: google.analytics.admin.v1alpha.WebDataStream
	(*UserLink)(nil),                    // 7: google.analytics.admin.v1alpha.UserLink
	(*AuditUserLink)(nil),               // 8: google.analytics.admin.v1alpha.AuditUserLink
	(*EnhancedMeasurementSettings)(nil), // 9: google.analytics.admin.v1alpha.EnhancedMeasurementSettings
	(*FirebaseLink)(nil),                // 10: google.analytics.admin.v1alpha.FirebaseLink
	(*GlobalSiteTag)(nil),               // 11: google.analytics.admin.v1alpha.GlobalSiteTag
	(*GoogleAdsLink)(nil),               // 12: google.analytics.admin.v1alpha.GoogleAdsLink
	(*DataSharingSettings)(nil),         // 13: google.analytics.admin.v1alpha.DataSharingSettings
	(*timestamppb.Timestamp)(nil),       // 14: google.protobuf.Timestamp
	(*wrapperspb.BoolValue)(nil),        // 15: google.protobuf.BoolValue
}
var file_google_analytics_admin_v1alpha_resources_proto_depIdxs = []int32{
	14, // 0: google.analytics.admin.v1alpha.Account.create_time:type_name -> google.protobuf.Timestamp
	14, // 1: google.analytics.admin.v1alpha.Account.update_time:type_name -> google.protobuf.Timestamp
	14, // 2: google.analytics.admin.v1alpha.Property.create_time:type_name -> google.protobuf.Timestamp
	14, // 3: google.analytics.admin.v1alpha.Property.update_time:type_name -> google.protobuf.Timestamp
	0,  // 4: google.analytics.admin.v1alpha.Property.industry_category:type_name -> google.analytics.admin.v1alpha.IndustryCategory
	14, // 5: google.analytics.admin.v1alpha.AndroidAppDataStream.create_time:type_name -> google.protobuf.Timestamp
	14, // 6: google.analytics.admin.v1alpha.AndroidAppDataStream.update_time:type_name -> google.protobuf.Timestamp
	14, // 7: google.analytics.admin.v1alpha.IosAppDataStream.create_time:type_name -> google.protobuf.Timestamp
	14, // 8: google.analytics.admin.v1alpha.IosAppDataStream.update_time:type_name -> google.protobuf.Timestamp
	14, // 9: google.analytics.admin.v1alpha.WebDataStream.create_time:type_name -> google.protobuf.Timestamp
	14, // 10: google.analytics.admin.v1alpha.WebDataStream.update_time:type_name -> google.protobuf.Timestamp
	14, // 11: google.analytics.admin.v1alpha.FirebaseLink.create_time:type_name -> google.protobuf.Timestamp
	1,  // 12: google.analytics.admin.v1alpha.FirebaseLink.maximum_user_access:type_name -> google.analytics.admin.v1alpha.MaximumUserAccess
	15, // 13: google.analytics.admin.v1alpha.GoogleAdsLink.ads_personalization_enabled:type_name -> google.protobuf.BoolValue
	14, // 14: google.analytics.admin.v1alpha.GoogleAdsLink.create_time:type_name -> google.protobuf.Timestamp
	14, // 15: google.analytics.admin.v1alpha.GoogleAdsLink.update_time:type_name -> google.protobuf.Timestamp
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_analytics_admin_v1alpha_resources_proto_init() }
func file_google_analytics_admin_v1alpha_resources_proto_init() {
	if File_google_analytics_admin_v1alpha_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Account); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Property); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AndroidAppDataStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IosAppDataStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebDataStream); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditUserLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnhancedMeasurementSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FirebaseLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GlobalSiteTag); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GoogleAdsLink); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DataSharingSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_admin_v1alpha_resources_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_analytics_admin_v1alpha_resources_proto_goTypes,
		DependencyIndexes: file_google_analytics_admin_v1alpha_resources_proto_depIdxs,
		EnumInfos:         file_google_analytics_admin_v1alpha_resources_proto_enumTypes,
		MessageInfos:      file_google_analytics_admin_v1alpha_resources_proto_msgTypes,
	}.Build()
	File_google_analytics_admin_v1alpha_resources_proto = out.File
	file_google_analytics_admin_v1alpha_resources_proto_rawDesc = nil
	file_google_analytics_admin_v1alpha_resources_proto_goTypes = nil
	file_google_analytics_admin_v1alpha_resources_proto_depIdxs = nil
}
