// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/notebooks/v1beta1/instance.proto

package notebooks

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Definition of the types of hardware accelerators that can be used on this
// instance.
type Instance_AcceleratorType int32

const (
	// Accelerator type is not specified.
	Instance_ACCELERATOR_TYPE_UNSPECIFIED Instance_AcceleratorType = 0
	// Accelerator type is Nvidia Tesla K80.
	Instance_NVIDIA_TESLA_K80 Instance_AcceleratorType = 1
	// Accelerator type is Nvidia Tesla P100.
	Instance_NVIDIA_TESLA_P100 Instance_AcceleratorType = 2
	// Accelerator type is Nvidia Tesla V100.
	Instance_NVIDIA_TESLA_V100 Instance_AcceleratorType = 3
	// Accelerator type is Nvidia Tesla P_4.
	Instance_NVIDIA_TESLA_P4 Instance_AcceleratorType = 4
	// Accelerator type is Nvidia Tesla T4.
	Instance_NVIDIA_TESLA_T4 Instance_AcceleratorType = 5
	// Accelerator type is NVIDIA Tesla T4 Virtual Workstations.
	Instance_NVIDIA_TESLA_T4_VWS Instance_AcceleratorType = 8
	// Accelerator type is NVIDIA Tesla P100 Virtual Workstations.
	Instance_NVIDIA_TESLA_P100_VWS Instance_AcceleratorType = 9
	// Accelerator type is NVIDIA Tesla P_4 Virtual Workstations.
	Instance_NVIDIA_TESLA_P4_VWS Instance_AcceleratorType = 10
	// (Coming soon) Accelerator type is TPU V2.
	Instance_TPU_V2 Instance_AcceleratorType = 6
	// (Coming soon) Accelerator type is TPU V3.
	Instance_TPU_V3 Instance_AcceleratorType = 7
)

// Enum value maps for Instance_AcceleratorType.
var (
	Instance_AcceleratorType_name = map[int32]string{
		0:  "ACCELERATOR_TYPE_UNSPECIFIED",
		1:  "NVIDIA_TESLA_K80",
		2:  "NVIDIA_TESLA_P100",
		3:  "NVIDIA_TESLA_V100",
		4:  "NVIDIA_TESLA_P4",
		5:  "NVIDIA_TESLA_T4",
		8:  "NVIDIA_TESLA_T4_VWS",
		9:  "NVIDIA_TESLA_P100_VWS",
		10: "NVIDIA_TESLA_P4_VWS",
		6:  "TPU_V2",
		7:  "TPU_V3",
	}
	Instance_AcceleratorType_value = map[string]int32{
		"ACCELERATOR_TYPE_UNSPECIFIED": 0,
		"NVIDIA_TESLA_K80":             1,
		"NVIDIA_TESLA_P100":            2,
		"NVIDIA_TESLA_V100":            3,
		"NVIDIA_TESLA_P4":              4,
		"NVIDIA_TESLA_T4":              5,
		"NVIDIA_TESLA_T4_VWS":          8,
		"NVIDIA_TESLA_P100_VWS":        9,
		"NVIDIA_TESLA_P4_VWS":          10,
		"TPU_V2":                       6,
		"TPU_V3":                       7,
	}
)

func (x Instance_AcceleratorType) Enum() *Instance_AcceleratorType {
	p := new(Instance_AcceleratorType)
	*p = x
	return p
}

func (x Instance_AcceleratorType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_AcceleratorType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1beta1_instance_proto_enumTypes[0].Descriptor()
}

func (Instance_AcceleratorType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1beta1_instance_proto_enumTypes[0]
}

func (x Instance_AcceleratorType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_AcceleratorType.Descriptor instead.
func (Instance_AcceleratorType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1beta1_instance_proto_rawDescGZIP(), []int{0, 0}
}

// The definition of the states of this instance.
type Instance_State int32

const (
	// State is not specified.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// The control logic is starting the instance.
	Instance_STARTING Instance_State = 1
	// The control logic is installing required frameworks and registering the
	// instance with notebook proxy
	Instance_PROVISIONING Instance_State = 2
	// The instance is running.
	Instance_ACTIVE Instance_State = 3
	// The control logic is stopping the instance.
	Instance_STOPPING Instance_State = 4
	// The instance is stopped.
	Instance_STOPPED Instance_State = 5
	// The instance is deleted.
	Instance_DELETED Instance_State = 6
)

// Enum value maps for Instance_State.
var (
	Instance_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTING",
		2: "PROVISIONING",
		3: "ACTIVE",
		4: "STOPPING",
		5: "STOPPED",
		6: "DELETED",
	}
	Instance_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTING":          1,
		"PROVISIONING":      2,
		"ACTIVE":            3,
		"STOPPING":          4,
		"STOPPED":           5,
		"DELETED":           6,
	}
)

func (x Instance_State) Enum() *Instance_State {
	p := new(Instance_State)
	*p = x
	return p
}

func (x Instance_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1beta1_instance_proto_enumTypes[1].Descriptor()
}

func (Instance_State) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1beta1_instance_proto_enumTypes[1]
}

func (x Instance_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_State.Descriptor instead.
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1beta1_instance_proto_rawDescGZIP(), []int{0, 1}
}

// Possible disk types for notebook instances.
type Instance_DiskType int32

const (
	// Disk type not set.
	Instance_DISK_TYPE_UNSPECIFIED Instance_DiskType = 0
	// Standard persistent disk type.
	Instance_PD_STANDARD Instance_DiskType = 1
	// SSD persistent disk type.
	Instance_PD_SSD Instance_DiskType = 2
)

// Enum value maps for Instance_DiskType.
var (
	Instance_DiskType_name = map[int32]string{
		0: "DISK_TYPE_UNSPECIFIED",
		1: "PD_STANDARD",
		2: "PD_SSD",
	}
	Instance_DiskType_value = map[string]int32{
		"DISK_TYPE_UNSPECIFIED": 0,
		"PD_STANDARD":           1,
		"PD_SSD":                2,
	}
)

func (x Instance_DiskType) Enum() *Instance_DiskType {
	p := new(Instance_DiskType)
	*p = x
	return p
}

func (x Instance_DiskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_DiskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1beta1_instance_proto_enumTypes[2].Descriptor()
}

func (Instance_DiskType) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1beta1_instance_proto_enumTypes[2]
}

func (x Instance_DiskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_DiskType.Descriptor instead.
func (Instance_DiskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1beta1_instance_proto_rawDescGZIP(), []int{0, 2}
}

// Definition of the disk encryption options.
type Instance_DiskEncryption int32

const (
	// Disk encryption is not specified.
	Instance_DISK_ENCRYPTION_UNSPECIFIED Instance_DiskEncryption = 0
	// Use Google managed encryption keys to encrypt the boot disk.
	Instance_GMEK Instance_DiskEncryption = 1
	// Use customer managed encryption keys to encrypt the boot disk.
	Instance_CMEK Instance_DiskEncryption = 2
)

// Enum value maps for Instance_DiskEncryption.
var (
	Instance_DiskEncryption_name = map[int32]string{
		0: "DISK_ENCRYPTION_UNSPECIFIED",
		1: "GMEK",
		2: "CMEK",
	}
	Instance_DiskEncryption_value = map[string]int32{
		"DISK_ENCRYPTION_UNSPECIFIED": 0,
		"GMEK":                        1,
		"CMEK":                        2,
	}
)

func (x Instance_DiskEncryption) Enum() *Instance_DiskEncryption {
	p := new(Instance_DiskEncryption)
	*p = x
	return p
}

func (x Instance_DiskEncryption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_DiskEncryption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v1beta1_instance_proto_enumTypes[3].Descriptor()
}

func (Instance_DiskEncryption) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v1beta1_instance_proto_enumTypes[3]
}

func (x Instance_DiskEncryption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_DiskEncryption.Descriptor instead.
func (Instance_DiskEncryption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1beta1_instance_proto_rawDescGZIP(), []int{0, 3}
}

// The definition of a notebook instance.
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of this notebook instance. Format:
	// `projects/{project_id}/locations/{location}/instances/{instance_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of the environment; can be one of VM image, or container image.
	//
	// Types that are assignable to Environment:
	//	*Instance_VmImage
	//	*Instance_ContainerImage
	Environment isInstance_Environment `protobuf_oneof:"environment"`
	// Path to a Bash script that automatically runs after a notebook instance
	// fully boots up. The path must be a URL or
	// Cloud Storage path (`gs://path-to-file/file-name`).
	PostStartupScript string `protobuf:"bytes,4,opt,name=post_startup_script,json=postStartupScript,proto3" json:"post_startup_script,omitempty"`
	// Output only. The proxy endpoint that is used to access the Jupyter notebook.
	ProxyUri string `protobuf:"bytes,5,opt,name=proxy_uri,json=proxyUri,proto3" json:"proxy_uri,omitempty"`
	// Input only. The owner of this instance after creation. Format: `alias@example.com`
	//
	// Currently supports one owner only. If not specified, all of the service
	// account users of your VM instance's service account can use
	// the instance.
	InstanceOwners []string `protobuf:"bytes,6,rep,name=instance_owners,json=instanceOwners,proto3" json:"instance_owners,omitempty"`
	// The service account on this instance, giving access to other Google
	// Cloud services.
	// You can use any service account within the same project, but you
	// must have the service account user permission to use the instance.
	//
	// If not specified, the [Compute Engine default service
	// account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
	// is used.
	ServiceAccount string `protobuf:"bytes,7,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Required. The [Compute Engine machine type](https://cloud.google.com/compute/docs/machine-types) of this
	// instance.
	MachineType string `protobuf:"bytes,8,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// The hardware accelerator used on this instance. If you use
	// accelerators, make sure that your configuration has
	// [enough vCPUs and memory to support the `machine_type` you
	// have selected](https://cloud.google.com/compute/docs/gpus/#gpus-list).
	AcceleratorConfig *Instance_AcceleratorConfig `protobuf:"bytes,9,opt,name=accelerator_config,json=acceleratorConfig,proto3" json:"accelerator_config,omitempty"`
	// Output only. The state of this instance.
	State Instance_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.notebooks.v1beta1.Instance_State" json:"state,omitempty"`
	// Whether the end user authorizes Google Cloud to install GPU driver
	// on this instance.
	// If this field is empty or set to false, the GPU driver won't be installed.
	// Only applicable to instances with GPUs.
	InstallGpuDriver bool `protobuf:"varint,11,opt,name=install_gpu_driver,json=installGpuDriver,proto3" json:"install_gpu_driver,omitempty"`
	// Specify a custom Cloud Storage path where the GPU driver is stored.
	// If not specified, we'll automatically choose from official GPU drivers.
	CustomGpuDriverPath string `protobuf:"bytes,12,opt,name=custom_gpu_driver_path,json=customGpuDriverPath,proto3" json:"custom_gpu_driver_path,omitempty"`
	// Input only. The type of the boot disk attached to this instance, defaults to
	// standard persistent disk (`PD_STANDARD`).
	BootDiskType Instance_DiskType `protobuf:"varint,13,opt,name=boot_disk_type,json=bootDiskType,proto3,enum=google.cloud.notebooks.v1beta1.Instance_DiskType" json:"boot_disk_type,omitempty"`
	// Input only. The size of the boot disk in GB attached to this instance, up to a maximum
	// of 64000&nbsp;GB (64&nbsp;TB). The minimum recommended value is
	// 100&nbsp;GB. If not specified, this defaults to 100.
	BootDiskSizeGb int64 `protobuf:"varint,14,opt,name=boot_disk_size_gb,json=bootDiskSizeGb,proto3" json:"boot_disk_size_gb,omitempty"`
	// Input only. The type of the data disk attached to this instance, defaults to
	// standard persistent disk (`PD_STANDARD`).
	DataDiskType Instance_DiskType `protobuf:"varint,25,opt,name=data_disk_type,json=dataDiskType,proto3,enum=google.cloud.notebooks.v1beta1.Instance_DiskType" json:"data_disk_type,omitempty"`
	// Input only. The size of the data disk in GB attached to this instance, up to a maximum
	// of 64000&nbsp;GB (64&nbsp;TB). You can choose the size of the data disk
	// based on how big your notebooks and data are. If not specified, this
	// defaults to 100.
	DataDiskSizeGb int64 `protobuf:"varint,26,opt,name=data_disk_size_gb,json=dataDiskSizeGb,proto3" json:"data_disk_size_gb,omitempty"`
	// Input only. If true, the data disk will not be auto deleted when deleting the instance.
	NoRemoveDataDisk bool `protobuf:"varint,27,opt,name=no_remove_data_disk,json=noRemoveDataDisk,proto3" json:"no_remove_data_disk,omitempty"`
	// Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
	DiskEncryption Instance_DiskEncryption `protobuf:"varint,15,opt,name=disk_encryption,json=diskEncryption,proto3,enum=google.cloud.notebooks.v1beta1.Instance_DiskEncryption" json:"disk_encryption,omitempty"`
	// Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption
	// is CMEK.
	// Format:
	// `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}`
	//
	// Learn more about [using your own encryption keys]( https://cloud.google.com/kms/docs/quickstart).
	KmsKey string `protobuf:"bytes,16,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
	// If true, no public IP will be assigned to this instance.
	NoPublicIp bool `protobuf:"varint,17,opt,name=no_public_ip,json=noPublicIp,proto3" json:"no_public_ip,omitempty"`
	// If true, the notebook instance will not register with the proxy.
	NoProxyAccess bool `protobuf:"varint,18,opt,name=no_proxy_access,json=noProxyAccess,proto3" json:"no_proxy_access,omitempty"`
	// The name of the VPC that this instance is in.
	// Format:
	// `projects/{project_id}/global/networks/{network_id}`
	Network string `protobuf:"bytes,19,opt,name=network,proto3" json:"network,omitempty"`
	// The name of the subnet that this instance is in.
	// Format:
	// `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
	Subnet string `protobuf:"bytes,20,opt,name=subnet,proto3" json:"subnet,omitempty"`
	// Labels to apply to this instance.
	// These can be later modified by the setLabels method.
	Labels map[string]string `protobuf:"bytes,21,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Custom metadata to apply to this instance.
	Metadata map[string]string `protobuf:"bytes,22,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Instance creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,23,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Instance update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,24,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1beta1_instance_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1beta1_instance_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1beta1_instance_proto_rawDescGZIP(), []int{0}
}

func (x *Instance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Instance) GetEnvironment() isInstance_Environment {
	if m != nil {
		return m.Environment
	}
	return nil
}

func (x *Instance) GetVmImage() *VmImage {
	if x, ok := x.GetEnvironment().(*Instance_VmImage); ok {
		return x.VmImage
	}
	return nil
}

func (x *Instance) GetContainerImage() *ContainerImage {
	if x, ok := x.GetEnvironment().(*Instance_ContainerImage); ok {
		return x.ContainerImage
	}
	return nil
}

func (x *Instance) GetPostStartupScript() string {
	if x != nil {
		return x.PostStartupScript
	}
	return ""
}

func (x *Instance) GetProxyUri() string {
	if x != nil {
		return x.ProxyUri
	}
	return ""
}

func (x *Instance) GetInstanceOwners() []string {
	if x != nil {
		return x.InstanceOwners
	}
	return nil
}

func (x *Instance) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Instance) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *Instance) GetAcceleratorConfig() *Instance_AcceleratorConfig {
	if x != nil {
		return x.AcceleratorConfig
	}
	return nil
}

func (x *Instance) GetState() Instance_State {
	if x != nil {
		return x.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (x *Instance) GetInstallGpuDriver() bool {
	if x != nil {
		return x.InstallGpuDriver
	}
	return false
}

func (x *Instance) GetCustomGpuDriverPath() string {
	if x != nil {
		return x.CustomGpuDriverPath
	}
	return ""
}

func (x *Instance) GetBootDiskType() Instance_DiskType {
	if x != nil {
		return x.BootDiskType
	}
	return Instance_DISK_TYPE_UNSPECIFIED
}

func (x *Instance) GetBootDiskSizeGb() int64 {
	if x != nil {
		return x.BootDiskSizeGb
	}
	return 0
}

func (x *Instance) GetDataDiskType() Instance_DiskType {
	if x != nil {
		return x.DataDiskType
	}
	return Instance_DISK_TYPE_UNSPECIFIED
}

func (x *Instance) GetDataDiskSizeGb() int64 {
	if x != nil {
		return x.DataDiskSizeGb
	}
	return 0
}

func (x *Instance) GetNoRemoveDataDisk() bool {
	if x != nil {
		return x.NoRemoveDataDisk
	}
	return false
}

func (x *Instance) GetDiskEncryption() Instance_DiskEncryption {
	if x != nil {
		return x.DiskEncryption
	}
	return Instance_DISK_ENCRYPTION_UNSPECIFIED
}

func (x *Instance) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

func (x *Instance) GetNoPublicIp() bool {
	if x != nil {
		return x.NoPublicIp
	}
	return false
}

func (x *Instance) GetNoProxyAccess() bool {
	if x != nil {
		return x.NoProxyAccess
	}
	return false
}

func (x *Instance) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *Instance) GetSubnet() string {
	if x != nil {
		return x.Subnet
	}
	return ""
}

func (x *Instance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Instance) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Instance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Instance) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isInstance_Environment interface {
	isInstance_Environment()
}

type Instance_VmImage struct {
	// Use a Compute Engine VM image to start the notebook instance.
	VmImage *VmImage `protobuf:"bytes,2,opt,name=vm_image,json=vmImage,proto3,oneof"`
}

type Instance_ContainerImage struct {
	// Use a container image to start the notebook instance.
	ContainerImage *ContainerImage `protobuf:"bytes,3,opt,name=container_image,json=containerImage,proto3,oneof"`
}

func (*Instance_VmImage) isInstance_Environment() {}

func (*Instance_ContainerImage) isInstance_Environment() {}

// Definition of a hardware accelerator. Note that not all combinations
// of `type` and `core_count` are valid. Check [GPUs on
// Compute Engine](/compute/docs/gpus/#gpus-list) to find a valid
// combination. TPUs are not supported.
type Instance_AcceleratorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of this accelerator.
	Type Instance_AcceleratorType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.notebooks.v1beta1.Instance_AcceleratorType" json:"type,omitempty"`
	// Count of cores of this accelerator.
	CoreCount int64 `protobuf:"varint,2,opt,name=core_count,json=coreCount,proto3" json:"core_count,omitempty"`
}

func (x *Instance_AcceleratorConfig) Reset() {
	*x = Instance_AcceleratorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v1beta1_instance_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance_AcceleratorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_AcceleratorConfig) ProtoMessage() {}

func (x *Instance_AcceleratorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v1beta1_instance_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_AcceleratorConfig.ProtoReflect.Descriptor instead.
func (*Instance_AcceleratorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v1beta1_instance_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Instance_AcceleratorConfig) GetType() Instance_AcceleratorType {
	if x != nil {
		return x.Type
	}
	return Instance_ACCELERATOR_TYPE_UNSPECIFIED
}

func (x *Instance_AcceleratorConfig) GetCoreCount() int64 {
	if x != nil {
		return x.CoreCount
	}
	return 0
}

var File_google_cloud_notebooks_v1beta1_instance_proto protoreflect.FileDescriptor

var file_google_cloud_notebooks_v1beta1_instance_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f,
	0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x88, 0x13, 0x0a,
	0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x44, 0x0a, 0x08, 0x76, 0x6d, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x6d, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x48, 0x00, 0x52,
	0x07, 0x76, 0x6d, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x59, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x70, 0x6f, 0x73, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x75, 0x70, 0x53, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x55, 0x72, 0x69, 0x12, 0x2c, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x04, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x77, 0x6e,
	0x65, 0x72, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0c,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x69, 0x0a, 0x12, 0x61, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x61, 0x63,
	0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6c, 0x6c, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x47,
	0x70, 0x75, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x12, 0x33, 0x0a, 0x16, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x47, 0x70, 0x75, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x5c, 0x0a,
	0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0c, 0x62,
	0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x11, 0x62,
	0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0e, 0x62, 0x6f, 0x6f,
	0x74, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x5c, 0x0a, 0x0e, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x19, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x44, 0x69,
	0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0c, 0x64, 0x61, 0x74,
	0x61, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x11, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x1a,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x44,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x32, 0x0a, 0x13, 0x6e, 0x6f, 0x5f,
	0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b,
	0x18, 0x1b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x10, 0x6e, 0x6f, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x65, 0x0a,
	0x0f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x04, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x12, 0x20, 0x0a, 0x0c, 0x6e, 0x6f, 0x5f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x5f,
	0x69, 0x70, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x6e, 0x6f, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x49, 0x70, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79,
	0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x6e,
	0x6f, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x12, 0x4c,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x52, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x1a, 0x80, 0x01, 0x0a, 0x11, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72,
	0x61, 0x74, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6f, 0x72, 0x65,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x6f,
	0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x86, 0x02, 0x0a, 0x0f, 0x41, 0x63, 0x63, 0x65, 0x6c, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x43, 0x43, 0x45, 0x4c, 0x45, 0x52, 0x41, 0x54,
	0x4f, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f,
	0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x4b, 0x38, 0x30, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x4e,
	0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x31, 0x30, 0x30,
	0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53,
	0x4c, 0x41, 0x5f, 0x56, 0x31, 0x30, 0x30, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x4e, 0x56, 0x49,
	0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x34, 0x10, 0x04, 0x12, 0x13,
	0x0a, 0x0f, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x54,
	0x34, 0x10, 0x05, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45,
	0x53, 0x4c, 0x41, 0x5f, 0x54, 0x34, 0x5f, 0x56, 0x57, 0x53, 0x10, 0x08, 0x12, 0x19, 0x0a, 0x15,
	0x4e, 0x56, 0x49, 0x44, 0x49, 0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x31, 0x30,
	0x30, 0x5f, 0x56, 0x57, 0x53, 0x10, 0x09, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x56, 0x49, 0x44, 0x49,
	0x41, 0x5f, 0x54, 0x45, 0x53, 0x4c, 0x41, 0x5f, 0x50, 0x34, 0x5f, 0x56, 0x57, 0x53, 0x10, 0x0a,
	0x12, 0x0a, 0x0a, 0x06, 0x54, 0x50, 0x55, 0x5f, 0x56, 0x32, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06,
	0x54, 0x50, 0x55, 0x5f, 0x56, 0x33, 0x10, 0x07, 0x22, 0x72, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53,
	0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47,
	0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44, 0x10, 0x05, 0x12,
	0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x06, 0x22, 0x42, 0x0a, 0x08,
	0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49, 0x53, 0x4b,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41,
	0x52, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x44, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x02,
	0x22, 0x45, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x6b, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59,
	0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x47, 0x4d, 0x45, 0x4b, 0x10, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x43, 0x4d, 0x45, 0x4b, 0x10, 0x02, 0x3a, 0x4f, 0xea, 0x41, 0x4c, 0x0a, 0x21, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x42, 0x0d, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0xe4, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0d,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x5c, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x6f, 0x74, 0x65,
	0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_notebooks_v1beta1_instance_proto_rawDescOnce sync.Once
	file_google_cloud_notebooks_v1beta1_instance_proto_rawDescData = file_google_cloud_notebooks_v1beta1_instance_proto_rawDesc
)

func file_google_cloud_notebooks_v1beta1_instance_proto_rawDescGZIP() []byte {
	file_google_cloud_notebooks_v1beta1_instance_proto_rawDescOnce.Do(func() {
		file_google_cloud_notebooks_v1beta1_instance_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_notebooks_v1beta1_instance_proto_rawDescData)
	})
	return file_google_cloud_notebooks_v1beta1_instance_proto_rawDescData
}

var file_google_cloud_notebooks_v1beta1_instance_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_notebooks_v1beta1_instance_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_notebooks_v1beta1_instance_proto_goTypes = []interface{}{
	(Instance_AcceleratorType)(0),      // 0: google.cloud.notebooks.v1beta1.Instance.AcceleratorType
	(Instance_State)(0),                // 1: google.cloud.notebooks.v1beta1.Instance.State
	(Instance_DiskType)(0),             // 2: google.cloud.notebooks.v1beta1.Instance.DiskType
	(Instance_DiskEncryption)(0),       // 3: google.cloud.notebooks.v1beta1.Instance.DiskEncryption
	(*Instance)(nil),                   // 4: google.cloud.notebooks.v1beta1.Instance
	(*Instance_AcceleratorConfig)(nil), // 5: google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig
	nil,                                // 6: google.cloud.notebooks.v1beta1.Instance.LabelsEntry
	nil,                                // 7: google.cloud.notebooks.v1beta1.Instance.MetadataEntry
	(*VmImage)(nil),                    // 8: google.cloud.notebooks.v1beta1.VmImage
	(*ContainerImage)(nil),             // 9: google.cloud.notebooks.v1beta1.ContainerImage
	(*timestamppb.Timestamp)(nil),      // 10: google.protobuf.Timestamp
}
var file_google_cloud_notebooks_v1beta1_instance_proto_depIdxs = []int32{
	8,  // 0: google.cloud.notebooks.v1beta1.Instance.vm_image:type_name -> google.cloud.notebooks.v1beta1.VmImage
	9,  // 1: google.cloud.notebooks.v1beta1.Instance.container_image:type_name -> google.cloud.notebooks.v1beta1.ContainerImage
	5,  // 2: google.cloud.notebooks.v1beta1.Instance.accelerator_config:type_name -> google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig
	1,  // 3: google.cloud.notebooks.v1beta1.Instance.state:type_name -> google.cloud.notebooks.v1beta1.Instance.State
	2,  // 4: google.cloud.notebooks.v1beta1.Instance.boot_disk_type:type_name -> google.cloud.notebooks.v1beta1.Instance.DiskType
	2,  // 5: google.cloud.notebooks.v1beta1.Instance.data_disk_type:type_name -> google.cloud.notebooks.v1beta1.Instance.DiskType
	3,  // 6: google.cloud.notebooks.v1beta1.Instance.disk_encryption:type_name -> google.cloud.notebooks.v1beta1.Instance.DiskEncryption
	6,  // 7: google.cloud.notebooks.v1beta1.Instance.labels:type_name -> google.cloud.notebooks.v1beta1.Instance.LabelsEntry
	7,  // 8: google.cloud.notebooks.v1beta1.Instance.metadata:type_name -> google.cloud.notebooks.v1beta1.Instance.MetadataEntry
	10, // 9: google.cloud.notebooks.v1beta1.Instance.create_time:type_name -> google.protobuf.Timestamp
	10, // 10: google.cloud.notebooks.v1beta1.Instance.update_time:type_name -> google.protobuf.Timestamp
	0,  // 11: google.cloud.notebooks.v1beta1.Instance.AcceleratorConfig.type:type_name -> google.cloud.notebooks.v1beta1.Instance.AcceleratorType
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_notebooks_v1beta1_instance_proto_init() }
func file_google_cloud_notebooks_v1beta1_instance_proto_init() {
	if File_google_cloud_notebooks_v1beta1_instance_proto != nil {
		return
	}
	file_google_cloud_notebooks_v1beta1_environment_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_notebooks_v1beta1_instance_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v1beta1_instance_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance_AcceleratorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_notebooks_v1beta1_instance_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Instance_VmImage)(nil),
		(*Instance_ContainerImage)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_notebooks_v1beta1_instance_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_notebooks_v1beta1_instance_proto_goTypes,
		DependencyIndexes: file_google_cloud_notebooks_v1beta1_instance_proto_depIdxs,
		EnumInfos:         file_google_cloud_notebooks_v1beta1_instance_proto_enumTypes,
		MessageInfos:      file_google_cloud_notebooks_v1beta1_instance_proto_msgTypes,
	}.Build()
	File_google_cloud_notebooks_v1beta1_instance_proto = out.File
	file_google_cloud_notebooks_v1beta1_instance_proto_rawDesc = nil
	file_google_cloud_notebooks_v1beta1_instance_proto_goTypes = nil
	file_google_cloud_notebooks_v1beta1_instance_proto_depIdxs = nil
}
