package digitaltwinsapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/digitaltwins/2020-05-31/digitaltwins"
	"github.com/Azure/go-autorest/autorest"
)

// ModelsClientAPI contains the set of methods on the ModelsClient type.
type ModelsClientAPI interface {
	Add(ctx context.Context, models []interface{}) (result digitaltwins.ListModelData, err error)
	Delete(ctx context.Context, ID string) (result autorest.Response, err error)
	GetByID(ctx context.Context, ID string, includeModelDefinition *bool) (result digitaltwins.ModelData, err error)
	List(ctx context.Context, dependenciesFor []string, includeModelDefinition *bool, maxItemCount *int32) (result digitaltwins.PagedModelDataCollectionPage, err error)
	ListComplete(ctx context.Context, dependenciesFor []string, includeModelDefinition *bool, maxItemCount *int32) (result digitaltwins.PagedModelDataCollectionIterator, err error)
	Update(ctx context.Context, ID string, updateModel []interface{}) (result autorest.Response, err error)
}

var _ ModelsClientAPI = (*digitaltwins.ModelsClient)(nil)

// QueryClientAPI contains the set of methods on the QueryClient type.
type QueryClientAPI interface {
	QueryTwins(ctx context.Context, querySpecification digitaltwins.QuerySpecification) (result digitaltwins.QueryResult, err error)
}

var _ QueryClientAPI = (*digitaltwins.QueryClient)(nil)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	Add(ctx context.Context, ID string, twin interface{}, ifNoneMatch string) (result digitaltwins.SetObject, err error)
	AddRelationship(ctx context.Context, ID string, relationshipID string, relationship *interface{}, ifNoneMatch string) (result digitaltwins.SetObject, err error)
	Delete(ctx context.Context, ID string, ifMatch string) (result autorest.Response, err error)
	DeleteRelationship(ctx context.Context, ID string, relationshipID string, ifMatch string) (result autorest.Response, err error)
	GetByID(ctx context.Context, ID string) (result digitaltwins.SetObject, err error)
	GetComponent(ctx context.Context, ID string, componentPath string) (result digitaltwins.SetObject, err error)
	GetRelationshipByID(ctx context.Context, ID string, relationshipID string) (result digitaltwins.SetObject, err error)
	ListIncomingRelationships(ctx context.Context, ID string) (result digitaltwins.IncomingRelationshipCollectionPage, err error)
	ListIncomingRelationshipsComplete(ctx context.Context, ID string) (result digitaltwins.IncomingRelationshipCollectionIterator, err error)
	ListRelationships(ctx context.Context, ID string, relationshipName string) (result digitaltwins.RelationshipCollectionPage, err error)
	ListRelationshipsComplete(ctx context.Context, ID string, relationshipName string) (result digitaltwins.RelationshipCollectionIterator, err error)
	SendComponentTelemetry(ctx context.Context, ID string, componentPath string, telemetry interface{}, dtID string, dtTimestamp string) (result autorest.Response, err error)
	SendTelemetry(ctx context.Context, ID string, telemetry interface{}, dtID string, dtTimestamp string) (result autorest.Response, err error)
	Update(ctx context.Context, ID string, patchDocument []interface{}, ifMatch string) (result autorest.Response, err error)
	UpdateComponent(ctx context.Context, ID string, componentPath string, patchDocument []interface{}, ifMatch string) (result autorest.Response, err error)
	UpdateRelationship(ctx context.Context, ID string, relationshipID string, patchDocument []interface{}, ifMatch string) (result autorest.Response, err error)
}

var _ ClientAPI = (*digitaltwins.Client)(nil)

// EventRoutesClientAPI contains the set of methods on the EventRoutesClient type.
type EventRoutesClientAPI interface {
	Add(ctx context.Context, ID string, eventRoute *digitaltwins.EventRoute) (result autorest.Response, err error)
	Delete(ctx context.Context, ID string) (result autorest.Response, err error)
	GetByID(ctx context.Context, ID string) (result digitaltwins.EventRoute, err error)
	List(ctx context.Context, maxItemCount *int32) (result digitaltwins.EventRouteCollectionPage, err error)
	ListComplete(ctx context.Context, maxItemCount *int32) (result digitaltwins.EventRouteCollectionIterator, err error)
}

var _ EventRoutesClientAPI = (*digitaltwins.EventRoutesClient)(nil)
