package storagetables

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// TableClient is the client for the Table methods of the Storagetables service.
type TableClient struct {
	BaseClient
}

// NewTableClient creates an instance of the TableClient client.
func NewTableClient(URL string) TableClient {
	return TableClient{New(URL)}
}

// Create creates a new table under the given account.
// Parameters:
// tableProperties - the Table properties.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
// formatParameter - specifies the media type for the response.
// responsePreference - specifies whether the response should include the inserted entity in the payload.
// Possible values are return-no-content and return-content.
func (client TableClient) Create(ctx context.Context, tableProperties TableProperties, requestID string, formatParameter OdataMetadataFormat, responsePreference ResponseFormat) (result TableResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.Create")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreatePreparer(ctx, tableProperties, requestID, formatParameter, responsePreference)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "Create", resp, "Failure responding to request")
	}

	return
}

// CreatePreparer prepares the Create request.
func (client TableClient) CreatePreparer(ctx context.Context, tableProperties TableProperties, requestID string, formatParameter OdataMetadataFormat, responsePreference ResponseFormat) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	queryParameters := map[string]interface{}{}
	if len(string(formatParameter)) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json;odata=nometadata; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/Tables"),
		autorest.WithJSON(tableProperties),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"),
		autorest.WithHeader("DataServiceVersion", "3.0"))
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	if len(string(responsePreference)) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Prefer", autorest.String(responsePreference)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) CreateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client TableClient) CreateResponder(resp *http.Response) (result TableResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete operation permanently deletes the specified table.
// Parameters:
// table - the name of the table.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
func (client TableClient) Delete(ctx context.Context, table string, requestID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, table, requestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client TableClient) DeletePreparer(ctx context.Context, table string, requestID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	pathParameters := map[string]interface{}{
		"table": autorest.Encode("path", table),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/Tables('{table}')", pathParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"))
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client TableClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteEntity deletes the specified entity in a table.
// Parameters:
// table - the name of the table.
// partitionKey - the partition key of the entity.
// rowKey - the row key of the entity.
// ifMatch - match condition for an entity to be deleted. If specified and a matching entity is not found, an
// error will be raised. To force an unconditional delete, set to the wildcard character (*).
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
// formatParameter - specifies the media type for the response.
func (client TableClient) DeleteEntity(ctx context.Context, table string, partitionKey string, rowKey string, ifMatch string, timeout *int32, requestID string, formatParameter OdataMetadataFormat) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.DeleteEntity")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.TableClient", "DeleteEntity", err.Error())
	}

	req, err := client.DeleteEntityPreparer(ctx, table, partitionKey, rowKey, ifMatch, timeout, requestID, formatParameter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "DeleteEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteEntitySender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "DeleteEntity", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "DeleteEntity", resp, "Failure responding to request")
	}

	return
}

// DeleteEntityPreparer prepares the DeleteEntity request.
func (client TableClient) DeleteEntityPreparer(ctx context.Context, table string, partitionKey string, rowKey string, ifMatch string, timeout *int32, requestID string, formatParameter OdataMetadataFormat) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	pathParameters := map[string]interface{}{
		"partitionKey": autorest.Encode("path", partitionKey),
		"rowKey":       autorest.Encode("path", rowKey),
		"table":        autorest.Encode("path", table),
	}

	queryParameters := map[string]interface{}{}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}
	if len(string(formatParameter)) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"),
		autorest.WithHeader("DataServiceVersion", "3.0"),
		autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteEntitySender sends the DeleteEntity request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) DeleteEntitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteEntityResponder handles the response to the DeleteEntity request. The method always
// closes the http.Response Body.
func (client TableClient) DeleteEntityResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetAccessPolicy retrieves details about any stored access policies specified on the table that may be used with
// Shared Access Signatures.
// Parameters:
// table - the name of the table.
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
func (client TableClient) GetAccessPolicy(ctx context.Context, table string, timeout *int32, requestID string) (result ListSignedIdentifier, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.GetAccessPolicy")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.TableClient", "GetAccessPolicy", err.Error())
	}

	req, err := client.GetAccessPolicyPreparer(ctx, table, timeout, requestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "GetAccessPolicy", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAccessPolicySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "GetAccessPolicy", resp, "Failure sending request")
		return
	}

	result, err = client.GetAccessPolicyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "GetAccessPolicy", resp, "Failure responding to request")
	}

	return
}

// GetAccessPolicyPreparer prepares the GetAccessPolicy request.
func (client TableClient) GetAccessPolicyPreparer(ctx context.Context, table string, timeout *int32, requestID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	pathParameters := map[string]interface{}{
		"table": autorest.Encode("path", table),
	}

	queryParameters := map[string]interface{}{
		"comp": autorest.Encode("query", "acl"),
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/{table}", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"))
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAccessPolicySender sends the GetAccessPolicy request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) GetAccessPolicySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAccessPolicyResponder handles the response to the GetAccessPolicy request. The method always
// closes the http.Response Body.
func (client TableClient) GetAccessPolicyResponder(resp *http.Response) (result ListSignedIdentifier, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// InsertEntity insert entity in a table.
// Parameters:
// table - the name of the table.
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
// formatParameter - specifies the media type for the response.
// tableEntityProperties - the properties for the table entity.
// responsePreference - specifies whether the response should include the inserted entity in the payload.
// Possible values are return-no-content and return-content.
func (client TableClient) InsertEntity(ctx context.Context, table string, timeout *int32, requestID string, formatParameter OdataMetadataFormat, tableEntityProperties map[string]interface{}, responsePreference ResponseFormat) (result SetSetObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.InsertEntity")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.TableClient", "InsertEntity", err.Error())
	}

	req, err := client.InsertEntityPreparer(ctx, table, timeout, requestID, formatParameter, tableEntityProperties, responsePreference)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "InsertEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.InsertEntitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "InsertEntity", resp, "Failure sending request")
		return
	}

	result, err = client.InsertEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "InsertEntity", resp, "Failure responding to request")
	}

	return
}

// InsertEntityPreparer prepares the InsertEntity request.
func (client TableClient) InsertEntityPreparer(ctx context.Context, table string, timeout *int32, requestID string, formatParameter OdataMetadataFormat, tableEntityProperties map[string]interface{}, responsePreference ResponseFormat) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	pathParameters := map[string]interface{}{
		"table": autorest.Encode("path", table),
	}

	queryParameters := map[string]interface{}{}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}
	if len(string(formatParameter)) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json;odata=nometadata; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/{table}", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"),
		autorest.WithHeader("DataServiceVersion", "3.0"))
	if tableEntityProperties != nil && len(tableEntityProperties) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(tableEntityProperties))
	}
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	if len(string(responsePreference)) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Prefer", autorest.String(responsePreference)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// InsertEntitySender sends the InsertEntity request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) InsertEntitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// InsertEntityResponder handles the response to the InsertEntity request. The method always
// closes the http.Response Body.
func (client TableClient) InsertEntityResponder(resp *http.Response) (result SetSetObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MergeEntity merge entity in a table.
// Parameters:
// table - the name of the table.
// partitionKey - the partition key of the entity.
// rowKey - the row key of the entity.
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
// formatParameter - specifies the media type for the response.
// tableEntityProperties - the properties for the table entity.
// ifMatch - match condition for an entity to be updated. If specified and a matching entity is not found, an
// error will be raised. To force an unconditional update, set to the wildcard character (*). If not specified,
// an insert will be performed when no existing entity is found to update and a merge will be performed if an
// existing entity is found.
func (client TableClient) MergeEntity(ctx context.Context, table string, partitionKey string, rowKey string, timeout *int32, requestID string, formatParameter OdataMetadataFormat, tableEntityProperties map[string]interface{}, ifMatch string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.MergeEntity")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.TableClient", "MergeEntity", err.Error())
	}

	req, err := client.MergeEntityPreparer(ctx, table, partitionKey, rowKey, timeout, requestID, formatParameter, tableEntityProperties, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "MergeEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.MergeEntitySender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "MergeEntity", resp, "Failure sending request")
		return
	}

	result, err = client.MergeEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "MergeEntity", resp, "Failure responding to request")
	}

	return
}

// MergeEntityPreparer prepares the MergeEntity request.
func (client TableClient) MergeEntityPreparer(ctx context.Context, table string, partitionKey string, rowKey string, timeout *int32, requestID string, formatParameter OdataMetadataFormat, tableEntityProperties map[string]interface{}, ifMatch string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	pathParameters := map[string]interface{}{
		"partitionKey": autorest.Encode("path", partitionKey),
		"rowKey":       autorest.Encode("path", rowKey),
		"table":        autorest.Encode("path", table),
	}

	queryParameters := map[string]interface{}{}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}
	if len(string(formatParameter)) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"),
		autorest.WithHeader("DataServiceVersion", "3.0"))
	if tableEntityProperties != nil && len(tableEntityProperties) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(tableEntityProperties))
	}
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MergeEntitySender sends the MergeEntity request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) MergeEntitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// MergeEntityResponder handles the response to the MergeEntity request. The method always
// closes the http.Response Body.
func (client TableClient) MergeEntityResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Query queries tables under the given account.
// Parameters:
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
// formatParameter - specifies the media type for the response.
// top - maximum number of records to return.
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// filter - oData filter expression.
// nextTableName - a table query continuation token from a previous call.
func (client TableClient) Query(ctx context.Context, requestID string, formatParameter OdataMetadataFormat, top *int32, selectParameter string, filter string, nextTableName string) (result TableQueryResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.Query")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.TableClient", "Query", err.Error())
	}

	req, err := client.QueryPreparer(ctx, requestID, formatParameter, top, selectParameter, filter, nextTableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "Query", nil, "Failure preparing request")
		return
	}

	resp, err := client.QuerySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "Query", resp, "Failure sending request")
		return
	}

	result, err = client.QueryResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "Query", resp, "Failure responding to request")
	}

	return
}

// QueryPreparer prepares the Query request.
func (client TableClient) QueryPreparer(ctx context.Context, requestID string, formatParameter OdataMetadataFormat, top *int32, selectParameter string, filter string, nextTableName string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	queryParameters := map[string]interface{}{}
	if len(string(formatParameter)) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(nextTableName) > 0 {
		queryParameters["NextTableName"] = autorest.Encode("query", nextTableName)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPath("/Tables"),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"),
		autorest.WithHeader("DataServiceVersion", "3.0"))
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// QuerySender sends the Query request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) QuerySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// QueryResponder handles the response to the Query request. The method always
// closes the http.Response Body.
func (client TableClient) QueryResponder(resp *http.Response) (result TableQueryResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// QueryEntities queries entities in a table.
// Parameters:
// table - the name of the table.
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
// formatParameter - specifies the media type for the response.
// top - maximum number of records to return.
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// filter - oData filter expression.
// nextPartitionKey - an entity query continuation token from a previous call.
// nextRowKey - an entity query continuation token from a previous call.
func (client TableClient) QueryEntities(ctx context.Context, table string, timeout *int32, requestID string, formatParameter OdataMetadataFormat, top *int32, selectParameter string, filter string, nextPartitionKey string, nextRowKey string) (result TableEntityQueryResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.QueryEntities")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}},
		{TargetValue: top,
			Constraints: []validation.Constraint{{Target: "top", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "top", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.TableClient", "QueryEntities", err.Error())
	}

	req, err := client.QueryEntitiesPreparer(ctx, table, timeout, requestID, formatParameter, top, selectParameter, filter, nextPartitionKey, nextRowKey)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "QueryEntities", nil, "Failure preparing request")
		return
	}

	resp, err := client.QueryEntitiesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "QueryEntities", resp, "Failure sending request")
		return
	}

	result, err = client.QueryEntitiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "QueryEntities", resp, "Failure responding to request")
	}

	return
}

// QueryEntitiesPreparer prepares the QueryEntities request.
func (client TableClient) QueryEntitiesPreparer(ctx context.Context, table string, timeout *int32, requestID string, formatParameter OdataMetadataFormat, top *int32, selectParameter string, filter string, nextPartitionKey string, nextRowKey string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	pathParameters := map[string]interface{}{
		"table": autorest.Encode("path", table),
	}

	queryParameters := map[string]interface{}{}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}
	if len(string(formatParameter)) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(nextPartitionKey) > 0 {
		queryParameters["NextPartitionKey"] = autorest.Encode("query", nextPartitionKey)
	}
	if len(nextRowKey) > 0 {
		queryParameters["NextRowKey"] = autorest.Encode("query", nextRowKey)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/{table}()", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"),
		autorest.WithHeader("DataServiceVersion", "3.0"))
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// QueryEntitiesSender sends the QueryEntities request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) QueryEntitiesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// QueryEntitiesResponder handles the response to the QueryEntities request. The method always
// closes the http.Response Body.
func (client TableClient) QueryEntitiesResponder(resp *http.Response) (result TableEntityQueryResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// QueryEntitiesWithPartitionAndRowKey queries entities in a table.
// Parameters:
// table - the name of the table.
// partitionKey - the partition key of the entity.
// rowKey - the row key of the entity.
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
// formatParameter - specifies the media type for the response.
// selectParameter - select expression using OData notation. Limits the columns on each record to just those
// requested, e.g. "$select=PolicyAssignmentId, ResourceId".
// filter - oData filter expression.
func (client TableClient) QueryEntitiesWithPartitionAndRowKey(ctx context.Context, table string, partitionKey string, rowKey string, timeout *int32, requestID string, formatParameter OdataMetadataFormat, selectParameter string, filter string) (result TableEntityQueryResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.QueryEntitiesWithPartitionAndRowKey")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.TableClient", "QueryEntitiesWithPartitionAndRowKey", err.Error())
	}

	req, err := client.QueryEntitiesWithPartitionAndRowKeyPreparer(ctx, table, partitionKey, rowKey, timeout, requestID, formatParameter, selectParameter, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "QueryEntitiesWithPartitionAndRowKey", nil, "Failure preparing request")
		return
	}

	resp, err := client.QueryEntitiesWithPartitionAndRowKeySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "QueryEntitiesWithPartitionAndRowKey", resp, "Failure sending request")
		return
	}

	result, err = client.QueryEntitiesWithPartitionAndRowKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "QueryEntitiesWithPartitionAndRowKey", resp, "Failure responding to request")
	}

	return
}

// QueryEntitiesWithPartitionAndRowKeyPreparer prepares the QueryEntitiesWithPartitionAndRowKey request.
func (client TableClient) QueryEntitiesWithPartitionAndRowKeyPreparer(ctx context.Context, table string, partitionKey string, rowKey string, timeout *int32, requestID string, formatParameter OdataMetadataFormat, selectParameter string, filter string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	pathParameters := map[string]interface{}{
		"partitionKey": autorest.Encode("path", partitionKey),
		"rowKey":       autorest.Encode("path", rowKey),
		"table":        autorest.Encode("path", table),
	}

	queryParameters := map[string]interface{}{}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}
	if len(string(formatParameter)) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}
	if len(selectParameter) > 0 {
		queryParameters["$select"] = autorest.Encode("query", selectParameter)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"),
		autorest.WithHeader("DataServiceVersion", "3.0"))
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// QueryEntitiesWithPartitionAndRowKeySender sends the QueryEntitiesWithPartitionAndRowKey request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) QueryEntitiesWithPartitionAndRowKeySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// QueryEntitiesWithPartitionAndRowKeyResponder handles the response to the QueryEntitiesWithPartitionAndRowKey request. The method always
// closes the http.Response Body.
func (client TableClient) QueryEntitiesWithPartitionAndRowKeyResponder(resp *http.Response) (result TableEntityQueryResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SetAccessPolicy sets stored access policies for the table that may be used with Shared Access Signatures.
// Parameters:
// table - the name of the table.
// tableACL - the acls for the table.
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
func (client TableClient) SetAccessPolicy(ctx context.Context, table string, tableACL []SignedIdentifier, timeout *int32, requestID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.SetAccessPolicy")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.TableClient", "SetAccessPolicy", err.Error())
	}

	req, err := client.SetAccessPolicyPreparer(ctx, table, tableACL, timeout, requestID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "SetAccessPolicy", nil, "Failure preparing request")
		return
	}

	resp, err := client.SetAccessPolicySender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "SetAccessPolicy", resp, "Failure sending request")
		return
	}

	result, err = client.SetAccessPolicyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "SetAccessPolicy", resp, "Failure responding to request")
	}

	return
}

// SetAccessPolicyPreparer prepares the SetAccessPolicy request.
func (client TableClient) SetAccessPolicyPreparer(ctx context.Context, table string, tableACL []SignedIdentifier, timeout *int32, requestID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	pathParameters := map[string]interface{}{
		"table": autorest.Encode("path", table),
	}

	queryParameters := map[string]interface{}{
		"comp": autorest.Encode("query", "acl"),
	}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/xml; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/{table}", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"))
	if tableACL != nil && len(tableACL) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(tableACL))
	}
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SetAccessPolicySender sends the SetAccessPolicy request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) SetAccessPolicySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SetAccessPolicyResponder handles the response to the SetAccessPolicy request. The method always
// closes the http.Response Body.
func (client TableClient) SetAccessPolicyResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateEntity update entity in a table.
// Parameters:
// table - the name of the table.
// partitionKey - the partition key of the entity.
// rowKey - the row key of the entity.
// timeout - the timeout parameter is expressed in seconds.
// requestID - provides a client-generated, opaque value with a 1 KB character limit that is recorded in the
// analytics logs when analytics logging is enabled.
// formatParameter - specifies the media type for the response.
// tableEntityProperties - the properties for the table entity.
// ifMatch - match condition for an entity to be updated. If specified and a matching entity is not found, an
// error will be raised. To force an unconditional update, set to the wildcard character (*). If not specified,
// an insert will be performed when no existing entity is found to update and a replace will be performed if an
// existing entity is found.
func (client TableClient) UpdateEntity(ctx context.Context, table string, partitionKey string, rowKey string, timeout *int32, requestID string, formatParameter OdataMetadataFormat, tableEntityProperties map[string]interface{}, ifMatch string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TableClient.UpdateEntity")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: timeout,
			Constraints: []validation.Constraint{{Target: "timeout", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "timeout", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("storagetables.TableClient", "UpdateEntity", err.Error())
	}

	req, err := client.UpdateEntityPreparer(ctx, table, partitionKey, rowKey, timeout, requestID, formatParameter, tableEntityProperties, ifMatch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "UpdateEntity", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateEntitySender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "UpdateEntity", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateEntityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagetables.TableClient", "UpdateEntity", resp, "Failure responding to request")
	}

	return
}

// UpdateEntityPreparer prepares the UpdateEntity request.
func (client TableClient) UpdateEntityPreparer(ctx context.Context, table string, partitionKey string, rowKey string, timeout *int32, requestID string, formatParameter OdataMetadataFormat, tableEntityProperties map[string]interface{}, ifMatch string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"url": client.URL,
	}

	pathParameters := map[string]interface{}{
		"partitionKey": autorest.Encode("path", partitionKey),
		"rowKey":       autorest.Encode("path", rowKey),
		"table":        autorest.Encode("path", table),
	}

	queryParameters := map[string]interface{}{}
	if timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *timeout)
	}
	if len(string(formatParameter)) > 0 {
		queryParameters["$format"] = autorest.Encode("query", formatParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithCustomBaseURL("{url}", urlParameters),
		autorest.WithPathParameters("/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("x-ms-version", "2019-02-02"),
		autorest.WithHeader("DataServiceVersion", "3.0"))
	if tableEntityProperties != nil && len(tableEntityProperties) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(tableEntityProperties))
	}
	if len(requestID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("x-ms-client-request-id", autorest.String(requestID)))
	}
	if len(ifMatch) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("If-Match", autorest.String(ifMatch)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateEntitySender sends the UpdateEntity request. The method will close the
// http.Response Body if it receives an error.
func (client TableClient) UpdateEntitySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// UpdateEntityResponder handles the response to the UpdateEntity request. The method always
// closes the http.Response Body.
func (client TableClient) UpdateEntityResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}
