## helm create

create a new chart with the given name

### Synopsis


This command creates a chart directory along with the common files and
directories used in a chart.

For example, 'helm create foo' will create a directory structure that looks
something like this:

	foo/
	  |
	  |- .helmignore        # Contains patterns to ignore when packaging Helm charts.
	  |
	  |- Chart.yaml         # Information about your chart
	  |
	  |- values.yaml        # The default values for your templates
	  |
	  |- charts/            # Charts that this chart depends on
	  |
	  |- templates/         # The template files
	  |
	  |- templates/tests/   # The test files

'helm create' takes a path for an argument. If directories in the given path
do not exist, Helm will attempt to create them as it goes. If the given
destination exists and there are files in that directory, conflicting files
will be overwritten, but other files will be left alone.


```
helm create NAME [flags]
```

### Options

```
  -h, --help             help for create
  -p, --starter string   the named Helm starter scaffold
```

### Options inherited from parent commands

```
      --debug                           enable verbose output
      --home string                     location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     address of Tiller. Overrides $HELM_HOST
      --kube-context string             name of the kubeconfig context to use
      --kubeconfig string               absolute path to the kubeconfig file to use
      --tiller-connection-timeout int   the duration (in seconds) Helm will wait to establish a connection to tiller (default 300)
      --tiller-namespace string         namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm](helm.md)	 - The Helm package manager for Kubernetes.

###### Auto generated by spf13/cobra on 18-Sep-2018
