## helm init

initialize Helm on both client and server

### Synopsis


This command installs Tiller (the Helm server-side component) onto your
Kubernetes Cluster and sets up local configuration in $HELM_HOME (default ~/.helm/).

As with the rest of the Helm commands, 'helm init' discovers Kubernetes clusters
by reading $KUBECONFIG (default '~/.kube/config') and using the default context.

To set up just a local environment, use '--client-only'. That will configure
$HELM_HOME, but not attempt to connect to a Kubernetes cluster and install the Tiller
deployment.

When installing Tiller, 'helm init' will attempt to install the latest released
version. You can specify an alternative image with '--tiller-image'. For those
frequently working on the latest code, the flag '--canary-image' will install
the latest pre-release version of Tiller (e.g. the HEAD commit in the GitHub
repository on the master branch).

To dump a manifest containing the Tiller deployment YAML, combine the
'--dry-run' and '--debug' flags.


```
helm init [flags]
```

### Options

```
      --automount-service-account-token   auto-mount the given service account to tiller (default true)
      --canary-image                      use the canary Tiller image
  -c, --client-only                       if set does not install Tiller
      --dry-run                           do not install local or remote
      --force-upgrade                     force upgrade of Tiller to the current helm version
  -h, --help                              help for init
      --history-max int                   limit the maximum number of revisions saved per release. Use 0 for no limit.
      --local-repo-url string             URL for local repository (default "http://127.0.0.1:8879/charts")
      --net-host                          install Tiller with net=host
      --node-selectors string             labels to specify the node on which Tiller is installed (app=tiller,helm=rocks)
  -o, --output OutputFormat               skip installation and output Tiller's manifest in specified format (json or yaml)
      --override stringArray              override values for the Tiller Deployment manifest (can specify multiple or separate values with commas: key1=val1,key2=val2)
      --replicas int                      amount of tiller instances to run on the cluster (default 1)
      --service-account string            name of service account
      --skip-refresh                      do not refresh (download) the local repository cache
      --stable-repo-url string            URL for stable repository (default "https://kubernetes-charts.storage.googleapis.com")
  -i, --tiller-image string               override Tiller image
      --tiller-tls                        install Tiller with TLS enabled
      --tiller-tls-cert string            path to TLS certificate file to install with Tiller
      --tiller-tls-hostname string        the server name used to verify the hostname on the returned certificates from Tiller
      --tiller-tls-key string             path to TLS key file to install with Tiller
      --tiller-tls-verify                 install Tiller with TLS enabled and to verify remote certificates
      --tls-ca-cert string                path to CA root certificate
      --upgrade                           upgrade if Tiller is already installed
      --wait                              block until Tiller is running and ready to receive requests
```

### Options inherited from parent commands

```
      --debug                           enable verbose output
      --home string                     location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     address of Tiller. Overrides $HELM_HOST
      --kube-context string             name of the kubeconfig context to use
      --kubeconfig string               absolute path to the kubeconfig file to use
      --tiller-connection-timeout int   the duration (in seconds) Helm will wait to establish a connection to tiller (default 300)
      --tiller-namespace string         namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm](helm.md)	 - The Helm package manager for Kubernetes.

###### Auto generated by spf13/cobra on 4-Sep-2018
