# Summary

[Introduction](./introduction.md)
[Quick Start](./user/quick-start.md)
[Concepts](./user/concepts.md)
[Personas](./user/personas.md)
- [Tasks](./tasks/index.md)
    - [Certificate Management](./tasks/certs/index.md)
        - [Using Custom Certificates](./tasks/certs/using-custom-certificates.md)
        - [Generating a Kubeconfig](./tasks/certs/generate-kubeconfig.md)
    - [Kubeadm based bootstrap](./tasks/kubeadm-bootstrap.md)
    - [Upgrading management and workload clusters](./tasks/upgrading-clusters.md)
    - [Upgrading Cluster API components](./tasks/upgrading-cluster-api-versions.md)
    - [Configure a MachineHealthCheck](./tasks/healthcheck.md)
    - [Kubeadm based control plane management](./tasks/kubeadm-control-plane.md)
    - [Updating Machine Infrastructure and Bootstrap Templates](tasks/updating-machine-templates.md)
    - [Using the Cluster Autoscaler](./tasks/cluster-autoscaler.md)
    - [Experimental Features](./tasks/experimental-features/experimental-features.md)
        - [MachinePools](./tasks/experimental-features/machine-pools.md)
        - [ClusterResourceSet](./tasks/experimental-features/cluster-resource-set.md)
        - [ClusterClass](./tasks/experimental-features/cluster-classes.md)
- [clusterctl CLI](./clusterctl/overview.md)
    - [clusterctl Commands](clusterctl/commands/commands.md)
        - [init](clusterctl/commands/init.md)
        - [generate cluster](clusterctl/commands/generate-cluster.md)
        - [generate yaml](clusterctl/commands/generate-yaml.md)
        - [get kubeconfig](clusterctl/commands/get-kubeconfig.md)
        - [describe cluster](clusterctl/commands/describe-cluster.md)
        - [move](./clusterctl/commands/move.md)
        - [upgrade](clusterctl/commands/upgrade.md)
        - [delete](clusterctl/commands/delete.md)
        - [completion](clusterctl/commands/completion.md)
    - [clusterctl Configuration](clusterctl/configuration.md)
    - [clusterctl Provider Contract](clusterctl/provider-contract.md)
    - [clusterctl for Developers](clusterctl/developers.md)
- [Developer Guide](./developer/guide.md)
    - [Repository Layout](./developer/repository-layout.md)
    - [Rapid iterative development with Tilt](./developer/tilt.md)
    - [Testing](./developer/testing.md)
    - [Developing E2E tests](./developer/e2e.md)
    - [Controllers](./developer/architecture/controllers.md)
        - [Bootstrap](./developer/architecture/controllers/bootstrap.md)
        - [Cluster](./developer/architecture/controllers/cluster.md)
        - [Machine](./developer/architecture/controllers/machine.md)
        - [MachineSet](./developer/architecture/controllers/machine-set.md)
        - [MachineDeployment](./developer/architecture/controllers/machine-deployment.md)
        - [MachineHealthCheck](./developer/architecture/controllers/machine-health-check.md)
        - [Control Plane](./developer/architecture/controllers/control-plane.md)
        - [MachinePool](./developer/architecture/controllers/machine-pool.md)
        - [Multi-tenancy](./developer/architecture/controllers/multi-tenancy.md)
        - [Support multiple instances](./developer/architecture/controllers/support-multiple-instances.md)
    - [Provider Implementers](./developer/providers/implementers.md)
        - [v1alpha1 to v1alpha2](./developer/providers/v1alpha1-to-v1alpha2.md)
        - [v1alpha2 to v1alpha3](./developer/providers/v1alpha2-to-v1alpha3.md)
        - [v1alpha3 to v1alpha4](./developer/providers/v1alpha3-to-v1alpha4.md)
        - [v1alpha4 to v1beta1](./developer/providers/v1alpha4-to-v1beta1.md)
        - [Cluster Infrastructure](./developer/providers/cluster-infrastructure.md)
        - [Machine Infrastructure](./developer/providers/machine-infrastructure.md)
        - [Bootstrap](./developer/providers/bootstrap.md)
        - [Implementer's Guide](./developer/providers/implementers-guide/overview.md)
          - [Naming](./developer/providers/implementers-guide/naming.md)
          - [Create Repo and Generate CRDs](./developer/providers/implementers-guide/generate_crds.md)
          - [Create API](./developer/providers/implementers-guide/create_api.md)
          - [Controllers and Reconciliation](./developer/providers/implementers-guide/controllers_and_reconciliation.md)
          - [Building, Running, Testing](./developer/providers/implementers-guide/building_running_and_testing.md)
    - [CustomResourceDefinitions relationships](./developer/crd-relationships.md)
- [Troubleshooting](./user/troubleshooting.md)
- [Reference](./reference/reference.md)
    - [Glossary](./reference/glossary.md)
    - [Provider List](./reference/providers.md)
    - [Ports](./reference/ports.md)
    - [Code of Conduct](./code-of-conduct.md)
    - [Contributing](./CONTRIBUTING.md)
    - [Jobs](./reference/jobs.md)
    - [Code Review in Cluster API](./REVIEWING.md)
    - [Version Support](./reference/versions.md)
    - [Roadmap](./roadmap.md)
