//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha3

import (
	unsafe "unsafe"

	v1 "k8s.io/api/core/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	v1beta1 "sigs.k8s.io/cluster-api-provider-openstack/api/v1beta1"
	apiv1alpha3 "sigs.k8s.io/cluster-api/api/v1alpha3"
	apiv1beta1 "sigs.k8s.io/cluster-api/api/v1beta1"
	errors "sigs.k8s.io/cluster-api/errors"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*Bastion)(nil), (*v1beta1.Bastion)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Bastion_To_v1beta1_Bastion(a.(*Bastion), b.(*v1beta1.Bastion), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Bastion)(nil), (*Bastion)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Bastion_To_v1alpha3_Bastion(a.(*v1beta1.Bastion), b.(*Bastion), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ExternalRouterIPParam)(nil), (*v1beta1.ExternalRouterIPParam)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_ExternalRouterIPParam_To_v1beta1_ExternalRouterIPParam(a.(*ExternalRouterIPParam), b.(*v1beta1.ExternalRouterIPParam), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ExternalRouterIPParam)(nil), (*ExternalRouterIPParam)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ExternalRouterIPParam_To_v1alpha3_ExternalRouterIPParam(a.(*v1beta1.ExternalRouterIPParam), b.(*ExternalRouterIPParam), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Instance)(nil), (*v1beta1.Instance)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Instance_To_v1beta1_Instance(a.(*Instance), b.(*v1beta1.Instance), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Instance)(nil), (*Instance)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Instance_To_v1alpha3_Instance(a.(*v1beta1.Instance), b.(*Instance), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LoadBalancer)(nil), (*v1beta1.LoadBalancer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_LoadBalancer_To_v1beta1_LoadBalancer(a.(*LoadBalancer), b.(*v1beta1.LoadBalancer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.LoadBalancer)(nil), (*LoadBalancer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_LoadBalancer_To_v1alpha3_LoadBalancer(a.(*v1beta1.LoadBalancer), b.(*LoadBalancer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Network)(nil), (*v1beta1.Network)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Network_To_v1beta1_Network(a.(*Network), b.(*v1beta1.Network), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NetworkParam)(nil), (*v1beta1.NetworkParam)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_NetworkParam_To_v1beta1_NetworkParam(a.(*NetworkParam), b.(*v1beta1.NetworkParam), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.NetworkParam)(nil), (*NetworkParam)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_NetworkParam_To_v1alpha3_NetworkParam(a.(*v1beta1.NetworkParam), b.(*NetworkParam), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenStackCluster)(nil), (*v1beta1.OpenStackCluster)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackCluster_To_v1beta1_OpenStackCluster(a.(*OpenStackCluster), b.(*v1beta1.OpenStackCluster), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.OpenStackCluster)(nil), (*OpenStackCluster)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackCluster_To_v1alpha3_OpenStackCluster(a.(*v1beta1.OpenStackCluster), b.(*OpenStackCluster), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenStackClusterList)(nil), (*v1beta1.OpenStackClusterList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackClusterList_To_v1beta1_OpenStackClusterList(a.(*OpenStackClusterList), b.(*v1beta1.OpenStackClusterList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.OpenStackClusterList)(nil), (*OpenStackClusterList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackClusterList_To_v1alpha3_OpenStackClusterList(a.(*v1beta1.OpenStackClusterList), b.(*OpenStackClusterList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenStackClusterStatus)(nil), (*v1beta1.OpenStackClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackClusterStatus_To_v1beta1_OpenStackClusterStatus(a.(*OpenStackClusterStatus), b.(*v1beta1.OpenStackClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenStackMachine)(nil), (*v1beta1.OpenStackMachine)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackMachine_To_v1beta1_OpenStackMachine(a.(*OpenStackMachine), b.(*v1beta1.OpenStackMachine), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.OpenStackMachine)(nil), (*OpenStackMachine)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackMachine_To_v1alpha3_OpenStackMachine(a.(*v1beta1.OpenStackMachine), b.(*OpenStackMachine), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenStackMachineList)(nil), (*v1beta1.OpenStackMachineList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackMachineList_To_v1beta1_OpenStackMachineList(a.(*OpenStackMachineList), b.(*v1beta1.OpenStackMachineList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.OpenStackMachineList)(nil), (*OpenStackMachineList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackMachineList_To_v1alpha3_OpenStackMachineList(a.(*v1beta1.OpenStackMachineList), b.(*OpenStackMachineList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenStackMachineStatus)(nil), (*v1beta1.OpenStackMachineStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackMachineStatus_To_v1beta1_OpenStackMachineStatus(a.(*OpenStackMachineStatus), b.(*v1beta1.OpenStackMachineStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.OpenStackMachineStatus)(nil), (*OpenStackMachineStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackMachineStatus_To_v1alpha3_OpenStackMachineStatus(a.(*v1beta1.OpenStackMachineStatus), b.(*OpenStackMachineStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenStackMachineTemplate)(nil), (*v1beta1.OpenStackMachineTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackMachineTemplate_To_v1beta1_OpenStackMachineTemplate(a.(*OpenStackMachineTemplate), b.(*v1beta1.OpenStackMachineTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.OpenStackMachineTemplate)(nil), (*OpenStackMachineTemplate)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackMachineTemplate_To_v1alpha3_OpenStackMachineTemplate(a.(*v1beta1.OpenStackMachineTemplate), b.(*OpenStackMachineTemplate), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenStackMachineTemplateList)(nil), (*v1beta1.OpenStackMachineTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackMachineTemplateList_To_v1beta1_OpenStackMachineTemplateList(a.(*OpenStackMachineTemplateList), b.(*v1beta1.OpenStackMachineTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.OpenStackMachineTemplateList)(nil), (*OpenStackMachineTemplateList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackMachineTemplateList_To_v1alpha3_OpenStackMachineTemplateList(a.(*v1beta1.OpenStackMachineTemplateList), b.(*OpenStackMachineTemplateList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenStackMachineTemplateResource)(nil), (*v1beta1.OpenStackMachineTemplateResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackMachineTemplateResource_To_v1beta1_OpenStackMachineTemplateResource(a.(*OpenStackMachineTemplateResource), b.(*v1beta1.OpenStackMachineTemplateResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.OpenStackMachineTemplateResource)(nil), (*OpenStackMachineTemplateResource)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackMachineTemplateResource_To_v1alpha3_OpenStackMachineTemplateResource(a.(*v1beta1.OpenStackMachineTemplateResource), b.(*OpenStackMachineTemplateResource), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*OpenStackMachineTemplateSpec)(nil), (*v1beta1.OpenStackMachineTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackMachineTemplateSpec_To_v1beta1_OpenStackMachineTemplateSpec(a.(*OpenStackMachineTemplateSpec), b.(*v1beta1.OpenStackMachineTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.OpenStackMachineTemplateSpec)(nil), (*OpenStackMachineTemplateSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackMachineTemplateSpec_To_v1alpha3_OpenStackMachineTemplateSpec(a.(*v1beta1.OpenStackMachineTemplateSpec), b.(*OpenStackMachineTemplateSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*RootVolume)(nil), (*v1beta1.RootVolume)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_RootVolume_To_v1beta1_RootVolume(a.(*RootVolume), b.(*v1beta1.RootVolume), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.RootVolume)(nil), (*RootVolume)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_RootVolume_To_v1alpha3_RootVolume(a.(*v1beta1.RootVolume), b.(*RootVolume), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Router)(nil), (*v1beta1.Router)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Router_To_v1beta1_Router(a.(*Router), b.(*v1beta1.Router), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Router)(nil), (*Router)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Router_To_v1alpha3_Router(a.(*v1beta1.Router), b.(*Router), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SecurityGroup)(nil), (*v1beta1.SecurityGroup)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_SecurityGroup_To_v1beta1_SecurityGroup(a.(*SecurityGroup), b.(*v1beta1.SecurityGroup), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.SecurityGroup)(nil), (*SecurityGroup)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_SecurityGroup_To_v1alpha3_SecurityGroup(a.(*v1beta1.SecurityGroup), b.(*SecurityGroup), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SecurityGroupFilter)(nil), (*v1beta1.SecurityGroupFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_SecurityGroupFilter_To_v1beta1_SecurityGroupFilter(a.(*SecurityGroupFilter), b.(*v1beta1.SecurityGroupFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.SecurityGroupFilter)(nil), (*SecurityGroupFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_SecurityGroupFilter_To_v1alpha3_SecurityGroupFilter(a.(*v1beta1.SecurityGroupFilter), b.(*SecurityGroupFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SecurityGroupParam)(nil), (*v1beta1.SecurityGroupParam)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_SecurityGroupParam_To_v1beta1_SecurityGroupParam(a.(*SecurityGroupParam), b.(*v1beta1.SecurityGroupParam), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.SecurityGroupParam)(nil), (*SecurityGroupParam)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_SecurityGroupParam_To_v1alpha3_SecurityGroupParam(a.(*v1beta1.SecurityGroupParam), b.(*SecurityGroupParam), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SecurityGroupRule)(nil), (*v1beta1.SecurityGroupRule)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_SecurityGroupRule_To_v1beta1_SecurityGroupRule(a.(*SecurityGroupRule), b.(*v1beta1.SecurityGroupRule), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.SecurityGroupRule)(nil), (*SecurityGroupRule)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_SecurityGroupRule_To_v1alpha3_SecurityGroupRule(a.(*v1beta1.SecurityGroupRule), b.(*SecurityGroupRule), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Subnet)(nil), (*v1beta1.Subnet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Subnet_To_v1beta1_Subnet(a.(*Subnet), b.(*v1beta1.Subnet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Subnet)(nil), (*Subnet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Subnet_To_v1alpha3_Subnet(a.(*v1beta1.Subnet), b.(*Subnet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*SubnetParam)(nil), (*v1beta1.SubnetParam)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_SubnetParam_To_v1beta1_SubnetParam(a.(*SubnetParam), b.(*v1beta1.SubnetParam), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.SubnetParam)(nil), (*SubnetParam)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_SubnetParam_To_v1alpha3_SubnetParam(a.(*v1beta1.SubnetParam), b.(*SubnetParam), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*[]Network)(nil), (*[]v1beta1.Network)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_Slice_v1alpha3_Network_To_Slice_v1beta1_Network(a.(*[]Network), b.(*[]v1beta1.Network), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*[]v1beta1.Network)(nil), (*[]Network)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_Slice_v1beta1_Network_To_Slice_v1alpha3_Network(a.(*[]v1beta1.Network), b.(*[]Network), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*apiv1alpha3.APIEndpoint)(nil), (*apiv1beta1.APIEndpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_APIEndpoint_To_v1beta1_APIEndpoint(a.(*apiv1alpha3.APIEndpoint), b.(*apiv1beta1.APIEndpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*Filter)(nil), (*v1beta1.NetworkFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_Filter_To_v1beta1_NetworkFilter(a.(*Filter), b.(*v1beta1.NetworkFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*OpenStackClusterSpec)(nil), (*v1beta1.OpenStackClusterSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackClusterSpec_To_v1beta1_OpenStackClusterSpec(a.(*OpenStackClusterSpec), b.(*v1beta1.OpenStackClusterSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*OpenStackMachineSpec)(nil), (*v1beta1.OpenStackMachineSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_OpenStackMachineSpec_To_v1beta1_OpenStackMachineSpec(a.(*OpenStackMachineSpec), b.(*v1beta1.OpenStackMachineSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*SubnetFilter)(nil), (*v1beta1.SubnetFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha3_SubnetFilter_To_v1beta1_SubnetFilter(a.(*SubnetFilter), b.(*v1beta1.SubnetFilter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*apiv1beta1.APIEndpoint)(nil), (*apiv1alpha3.APIEndpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_APIEndpoint_To_v1alpha3_APIEndpoint(a.(*apiv1beta1.APIEndpoint), b.(*apiv1alpha3.APIEndpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.NetworkFilter)(nil), (*Filter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_NetworkFilter_To_v1alpha3_Filter(a.(*v1beta1.NetworkFilter), b.(*Filter), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.Network)(nil), (*Network)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Network_To_v1alpha3_Network(a.(*v1beta1.Network), b.(*Network), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.OpenStackClusterSpec)(nil), (*OpenStackClusterSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackClusterSpec_To_v1alpha3_OpenStackClusterSpec(a.(*v1beta1.OpenStackClusterSpec), b.(*OpenStackClusterSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.OpenStackClusterStatus)(nil), (*OpenStackClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackClusterStatus_To_v1alpha3_OpenStackClusterStatus(a.(*v1beta1.OpenStackClusterStatus), b.(*OpenStackClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.OpenStackMachineSpec)(nil), (*OpenStackMachineSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_OpenStackMachineSpec_To_v1alpha3_OpenStackMachineSpec(a.(*v1beta1.OpenStackMachineSpec), b.(*OpenStackMachineSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.SubnetFilter)(nil), (*SubnetFilter)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_SubnetFilter_To_v1alpha3_SubnetFilter(a.(*v1beta1.SubnetFilter), b.(*SubnetFilter), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha3_Bastion_To_v1beta1_Bastion(in *Bastion, out *v1beta1.Bastion, s conversion.Scope) error {
	out.Enabled = in.Enabled
	if err := Convert_v1alpha3_OpenStackMachineSpec_To_v1beta1_OpenStackMachineSpec(&in.Instance, &out.Instance, s); err != nil {
		return err
	}
	out.AvailabilityZone = in.AvailabilityZone
	return nil
}

// Convert_v1alpha3_Bastion_To_v1beta1_Bastion is an autogenerated conversion function.
func Convert_v1alpha3_Bastion_To_v1beta1_Bastion(in *Bastion, out *v1beta1.Bastion, s conversion.Scope) error {
	return autoConvert_v1alpha3_Bastion_To_v1beta1_Bastion(in, out, s)
}

func autoConvert_v1beta1_Bastion_To_v1alpha3_Bastion(in *v1beta1.Bastion, out *Bastion, s conversion.Scope) error {
	out.Enabled = in.Enabled
	if err := Convert_v1beta1_OpenStackMachineSpec_To_v1alpha3_OpenStackMachineSpec(&in.Instance, &out.Instance, s); err != nil {
		return err
	}
	out.AvailabilityZone = in.AvailabilityZone
	return nil
}

// Convert_v1beta1_Bastion_To_v1alpha3_Bastion is an autogenerated conversion function.
func Convert_v1beta1_Bastion_To_v1alpha3_Bastion(in *v1beta1.Bastion, out *Bastion, s conversion.Scope) error {
	return autoConvert_v1beta1_Bastion_To_v1alpha3_Bastion(in, out, s)
}

func autoConvert_v1alpha3_ExternalRouterIPParam_To_v1beta1_ExternalRouterIPParam(in *ExternalRouterIPParam, out *v1beta1.ExternalRouterIPParam, s conversion.Scope) error {
	out.FixedIP = in.FixedIP
	if err := Convert_v1alpha3_SubnetParam_To_v1beta1_SubnetParam(&in.Subnet, &out.Subnet, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_ExternalRouterIPParam_To_v1beta1_ExternalRouterIPParam is an autogenerated conversion function.
func Convert_v1alpha3_ExternalRouterIPParam_To_v1beta1_ExternalRouterIPParam(in *ExternalRouterIPParam, out *v1beta1.ExternalRouterIPParam, s conversion.Scope) error {
	return autoConvert_v1alpha3_ExternalRouterIPParam_To_v1beta1_ExternalRouterIPParam(in, out, s)
}

func autoConvert_v1beta1_ExternalRouterIPParam_To_v1alpha3_ExternalRouterIPParam(in *v1beta1.ExternalRouterIPParam, out *ExternalRouterIPParam, s conversion.Scope) error {
	out.FixedIP = in.FixedIP
	if err := Convert_v1beta1_SubnetParam_To_v1alpha3_SubnetParam(&in.Subnet, &out.Subnet, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_ExternalRouterIPParam_To_v1alpha3_ExternalRouterIPParam is an autogenerated conversion function.
func Convert_v1beta1_ExternalRouterIPParam_To_v1alpha3_ExternalRouterIPParam(in *v1beta1.ExternalRouterIPParam, out *ExternalRouterIPParam, s conversion.Scope) error {
	return autoConvert_v1beta1_ExternalRouterIPParam_To_v1alpha3_ExternalRouterIPParam(in, out, s)
}

func autoConvert_v1alpha3_Instance_To_v1beta1_Instance(in *Instance, out *v1beta1.Instance, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.Trunk = in.Trunk
	out.FailureDomain = in.FailureDomain
	out.SecurityGroups = (*[]string)(unsafe.Pointer(in.SecurityGroups))
	if in.Networks != nil {
		in, out := &in.Networks, &out.Networks
		*out = new([]v1beta1.Network)
		if err := Convert_Slice_v1alpha3_Network_To_Slice_v1beta1_Network(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Networks = nil
	}
	out.Subnet = in.Subnet
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	out.Image = in.Image
	out.Flavor = in.Flavor
	out.SSHKeyName = in.SSHKeyName
	out.UserData = in.UserData
	out.Metadata = *(*map[string]string)(unsafe.Pointer(&in.Metadata))
	out.ConfigDrive = (*bool)(unsafe.Pointer(in.ConfigDrive))
	out.RootVolume = (*v1beta1.RootVolume)(unsafe.Pointer(in.RootVolume))
	out.ServerGroupID = in.ServerGroupID
	out.State = v1beta1.InstanceState(in.State)
	out.IP = in.IP
	out.FloatingIP = in.FloatingIP
	return nil
}

// Convert_v1alpha3_Instance_To_v1beta1_Instance is an autogenerated conversion function.
func Convert_v1alpha3_Instance_To_v1beta1_Instance(in *Instance, out *v1beta1.Instance, s conversion.Scope) error {
	return autoConvert_v1alpha3_Instance_To_v1beta1_Instance(in, out, s)
}

func autoConvert_v1beta1_Instance_To_v1alpha3_Instance(in *v1beta1.Instance, out *Instance, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.Trunk = in.Trunk
	out.FailureDomain = in.FailureDomain
	out.SecurityGroups = (*[]string)(unsafe.Pointer(in.SecurityGroups))
	if in.Networks != nil {
		in, out := &in.Networks, &out.Networks
		*out = new([]Network)
		if err := Convert_Slice_v1beta1_Network_To_Slice_v1alpha3_Network(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Networks = nil
	}
	out.Subnet = in.Subnet
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	out.Image = in.Image
	out.Flavor = in.Flavor
	out.SSHKeyName = in.SSHKeyName
	out.UserData = in.UserData
	out.Metadata = *(*map[string]string)(unsafe.Pointer(&in.Metadata))
	out.ConfigDrive = (*bool)(unsafe.Pointer(in.ConfigDrive))
	out.RootVolume = (*RootVolume)(unsafe.Pointer(in.RootVolume))
	out.ServerGroupID = in.ServerGroupID
	out.State = InstanceState(in.State)
	out.IP = in.IP
	out.FloatingIP = in.FloatingIP
	return nil
}

// Convert_v1beta1_Instance_To_v1alpha3_Instance is an autogenerated conversion function.
func Convert_v1beta1_Instance_To_v1alpha3_Instance(in *v1beta1.Instance, out *Instance, s conversion.Scope) error {
	return autoConvert_v1beta1_Instance_To_v1alpha3_Instance(in, out, s)
}

func autoConvert_v1alpha3_LoadBalancer_To_v1beta1_LoadBalancer(in *LoadBalancer, out *v1beta1.LoadBalancer, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	out.IP = in.IP
	out.InternalIP = in.InternalIP
	return nil
}

// Convert_v1alpha3_LoadBalancer_To_v1beta1_LoadBalancer is an autogenerated conversion function.
func Convert_v1alpha3_LoadBalancer_To_v1beta1_LoadBalancer(in *LoadBalancer, out *v1beta1.LoadBalancer, s conversion.Scope) error {
	return autoConvert_v1alpha3_LoadBalancer_To_v1beta1_LoadBalancer(in, out, s)
}

func autoConvert_v1beta1_LoadBalancer_To_v1alpha3_LoadBalancer(in *v1beta1.LoadBalancer, out *LoadBalancer, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	out.IP = in.IP
	out.InternalIP = in.InternalIP
	return nil
}

// Convert_v1beta1_LoadBalancer_To_v1alpha3_LoadBalancer is an autogenerated conversion function.
func Convert_v1beta1_LoadBalancer_To_v1alpha3_LoadBalancer(in *v1beta1.LoadBalancer, out *LoadBalancer, s conversion.Scope) error {
	return autoConvert_v1beta1_LoadBalancer_To_v1alpha3_LoadBalancer(in, out, s)
}

func autoConvert_v1alpha3_Network_To_v1beta1_Network(in *Network, out *v1beta1.Network, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	out.Subnet = (*v1beta1.Subnet)(unsafe.Pointer(in.Subnet))
	out.Router = (*v1beta1.Router)(unsafe.Pointer(in.Router))
	out.APIServerLoadBalancer = (*v1beta1.LoadBalancer)(unsafe.Pointer(in.APIServerLoadBalancer))
	return nil
}

// Convert_v1alpha3_Network_To_v1beta1_Network is an autogenerated conversion function.
func Convert_v1alpha3_Network_To_v1beta1_Network(in *Network, out *v1beta1.Network, s conversion.Scope) error {
	return autoConvert_v1alpha3_Network_To_v1beta1_Network(in, out, s)
}

func autoConvert_v1beta1_Network_To_v1alpha3_Network(in *v1beta1.Network, out *Network, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	out.Subnet = (*Subnet)(unsafe.Pointer(in.Subnet))
	// WARNING: in.PortOpts requires manual conversion: does not exist in peer-type
	out.Router = (*Router)(unsafe.Pointer(in.Router))
	out.APIServerLoadBalancer = (*LoadBalancer)(unsafe.Pointer(in.APIServerLoadBalancer))
	return nil
}

func autoConvert_v1alpha3_NetworkParam_To_v1beta1_NetworkParam(in *NetworkParam, out *v1beta1.NetworkParam, s conversion.Scope) error {
	out.UUID = in.UUID
	out.FixedIP = in.FixedIP
	if err := Convert_v1alpha3_Filter_To_v1beta1_NetworkFilter(&in.Filter, &out.Filter, s); err != nil {
		return err
	}
	if in.Subnets != nil {
		in, out := &in.Subnets, &out.Subnets
		*out = make([]v1beta1.SubnetParam, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_SubnetParam_To_v1beta1_SubnetParam(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Subnets = nil
	}
	return nil
}

// Convert_v1alpha3_NetworkParam_To_v1beta1_NetworkParam is an autogenerated conversion function.
func Convert_v1alpha3_NetworkParam_To_v1beta1_NetworkParam(in *NetworkParam, out *v1beta1.NetworkParam, s conversion.Scope) error {
	return autoConvert_v1alpha3_NetworkParam_To_v1beta1_NetworkParam(in, out, s)
}

func autoConvert_v1beta1_NetworkParam_To_v1alpha3_NetworkParam(in *v1beta1.NetworkParam, out *NetworkParam, s conversion.Scope) error {
	out.UUID = in.UUID
	out.FixedIP = in.FixedIP
	if err := Convert_v1beta1_NetworkFilter_To_v1alpha3_Filter(&in.Filter, &out.Filter, s); err != nil {
		return err
	}
	if in.Subnets != nil {
		in, out := &in.Subnets, &out.Subnets
		*out = make([]SubnetParam, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_SubnetParam_To_v1alpha3_SubnetParam(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Subnets = nil
	}
	return nil
}

// Convert_v1beta1_NetworkParam_To_v1alpha3_NetworkParam is an autogenerated conversion function.
func Convert_v1beta1_NetworkParam_To_v1alpha3_NetworkParam(in *v1beta1.NetworkParam, out *NetworkParam, s conversion.Scope) error {
	return autoConvert_v1beta1_NetworkParam_To_v1alpha3_NetworkParam(in, out, s)
}

func autoConvert_v1alpha3_OpenStackCluster_To_v1beta1_OpenStackCluster(in *OpenStackCluster, out *v1beta1.OpenStackCluster, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_OpenStackClusterSpec_To_v1beta1_OpenStackClusterSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_OpenStackClusterStatus_To_v1beta1_OpenStackClusterStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_OpenStackCluster_To_v1beta1_OpenStackCluster is an autogenerated conversion function.
func Convert_v1alpha3_OpenStackCluster_To_v1beta1_OpenStackCluster(in *OpenStackCluster, out *v1beta1.OpenStackCluster, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpenStackCluster_To_v1beta1_OpenStackCluster(in, out, s)
}

func autoConvert_v1beta1_OpenStackCluster_To_v1alpha3_OpenStackCluster(in *v1beta1.OpenStackCluster, out *OpenStackCluster, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_OpenStackClusterSpec_To_v1alpha3_OpenStackClusterSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_OpenStackClusterStatus_To_v1alpha3_OpenStackClusterStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_OpenStackCluster_To_v1alpha3_OpenStackCluster is an autogenerated conversion function.
func Convert_v1beta1_OpenStackCluster_To_v1alpha3_OpenStackCluster(in *v1beta1.OpenStackCluster, out *OpenStackCluster, s conversion.Scope) error {
	return autoConvert_v1beta1_OpenStackCluster_To_v1alpha3_OpenStackCluster(in, out, s)
}

func autoConvert_v1alpha3_OpenStackClusterList_To_v1beta1_OpenStackClusterList(in *OpenStackClusterList, out *v1beta1.OpenStackClusterList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.OpenStackCluster, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_OpenStackCluster_To_v1beta1_OpenStackCluster(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_OpenStackClusterList_To_v1beta1_OpenStackClusterList is an autogenerated conversion function.
func Convert_v1alpha3_OpenStackClusterList_To_v1beta1_OpenStackClusterList(in *OpenStackClusterList, out *v1beta1.OpenStackClusterList, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpenStackClusterList_To_v1beta1_OpenStackClusterList(in, out, s)
}

func autoConvert_v1beta1_OpenStackClusterList_To_v1alpha3_OpenStackClusterList(in *v1beta1.OpenStackClusterList, out *OpenStackClusterList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]OpenStackCluster, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_OpenStackCluster_To_v1alpha3_OpenStackCluster(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_OpenStackClusterList_To_v1alpha3_OpenStackClusterList is an autogenerated conversion function.
func Convert_v1beta1_OpenStackClusterList_To_v1alpha3_OpenStackClusterList(in *v1beta1.OpenStackClusterList, out *OpenStackClusterList, s conversion.Scope) error {
	return autoConvert_v1beta1_OpenStackClusterList_To_v1alpha3_OpenStackClusterList(in, out, s)
}

func autoConvert_v1alpha3_OpenStackClusterSpec_To_v1beta1_OpenStackClusterSpec(in *OpenStackClusterSpec, out *v1beta1.OpenStackClusterSpec, s conversion.Scope) error {
	// INFO: in.CloudsSecret opted out of conversion generation
	out.CloudName = in.CloudName
	out.NodeCIDR = in.NodeCIDR
	if err := Convert_v1alpha3_Filter_To_v1beta1_NetworkFilter(&in.Network, &out.Network, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_SubnetFilter_To_v1beta1_SubnetFilter(&in.Subnet, &out.Subnet, s); err != nil {
		return err
	}
	out.DNSNameservers = *(*[]string)(unsafe.Pointer(&in.DNSNameservers))
	if in.ExternalRouterIPs != nil {
		in, out := &in.ExternalRouterIPs, &out.ExternalRouterIPs
		*out = make([]v1beta1.ExternalRouterIPParam, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_ExternalRouterIPParam_To_v1beta1_ExternalRouterIPParam(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.ExternalRouterIPs = nil
	}
	out.ExternalNetworkID = in.ExternalNetworkID
	// WARNING: in.UseOctavia requires manual conversion: does not exist in peer-type
	out.ManagedAPIServerLoadBalancer = in.ManagedAPIServerLoadBalancer
	out.APIServerFloatingIP = in.APIServerFloatingIP
	out.APIServerPort = in.APIServerPort
	out.APIServerLoadBalancerAdditionalPorts = *(*[]int)(unsafe.Pointer(&in.APIServerLoadBalancerAdditionalPorts))
	out.ManagedSecurityGroups = in.ManagedSecurityGroups
	out.DisablePortSecurity = in.DisablePortSecurity
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	if err := Convert_v1alpha3_APIEndpoint_To_v1beta1_APIEndpoint(&in.ControlPlaneEndpoint, &out.ControlPlaneEndpoint, s); err != nil {
		return err
	}
	out.ControlPlaneAvailabilityZones = *(*[]string)(unsafe.Pointer(&in.ControlPlaneAvailabilityZones))
	if in.Bastion != nil {
		in, out := &in.Bastion, &out.Bastion
		*out = new(v1beta1.Bastion)
		if err := Convert_v1alpha3_Bastion_To_v1beta1_Bastion(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Bastion = nil
	}
	return nil
}

func autoConvert_v1beta1_OpenStackClusterSpec_To_v1alpha3_OpenStackClusterSpec(in *v1beta1.OpenStackClusterSpec, out *OpenStackClusterSpec, s conversion.Scope) error {
	out.CloudName = in.CloudName
	out.NodeCIDR = in.NodeCIDR
	if err := Convert_v1beta1_NetworkFilter_To_v1alpha3_Filter(&in.Network, &out.Network, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_SubnetFilter_To_v1alpha3_SubnetFilter(&in.Subnet, &out.Subnet, s); err != nil {
		return err
	}
	out.DNSNameservers = *(*[]string)(unsafe.Pointer(&in.DNSNameservers))
	if in.ExternalRouterIPs != nil {
		in, out := &in.ExternalRouterIPs, &out.ExternalRouterIPs
		*out = make([]ExternalRouterIPParam, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_ExternalRouterIPParam_To_v1alpha3_ExternalRouterIPParam(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.ExternalRouterIPs = nil
	}
	out.ExternalNetworkID = in.ExternalNetworkID
	out.ManagedAPIServerLoadBalancer = in.ManagedAPIServerLoadBalancer
	// WARNING: in.DisableAPIServerFloatingIP requires manual conversion: does not exist in peer-type
	out.APIServerFloatingIP = in.APIServerFloatingIP
	// WARNING: in.APIServerFixedIP requires manual conversion: does not exist in peer-type
	out.APIServerPort = in.APIServerPort
	out.APIServerLoadBalancerAdditionalPorts = *(*[]int)(unsafe.Pointer(&in.APIServerLoadBalancerAdditionalPorts))
	out.ManagedSecurityGroups = in.ManagedSecurityGroups
	// WARNING: in.AllowAllInClusterTraffic requires manual conversion: does not exist in peer-type
	out.DisablePortSecurity = in.DisablePortSecurity
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	if err := Convert_v1beta1_APIEndpoint_To_v1alpha3_APIEndpoint(&in.ControlPlaneEndpoint, &out.ControlPlaneEndpoint, s); err != nil {
		return err
	}
	out.ControlPlaneAvailabilityZones = *(*[]string)(unsafe.Pointer(&in.ControlPlaneAvailabilityZones))
	if in.Bastion != nil {
		in, out := &in.Bastion, &out.Bastion
		*out = new(Bastion)
		if err := Convert_v1beta1_Bastion_To_v1alpha3_Bastion(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Bastion = nil
	}
	// WARNING: in.IdentityRef requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_OpenStackClusterStatus_To_v1beta1_OpenStackClusterStatus(in *OpenStackClusterStatus, out *v1beta1.OpenStackClusterStatus, s conversion.Scope) error {
	out.Ready = in.Ready
	if in.Network != nil {
		in, out := &in.Network, &out.Network
		*out = new(v1beta1.Network)
		if err := Convert_v1alpha3_Network_To_v1beta1_Network(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Network = nil
	}
	if in.ExternalNetwork != nil {
		in, out := &in.ExternalNetwork, &out.ExternalNetwork
		*out = new(v1beta1.Network)
		if err := Convert_v1alpha3_Network_To_v1beta1_Network(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExternalNetwork = nil
	}
	out.FailureDomains = *(*apiv1beta1.FailureDomains)(unsafe.Pointer(&in.FailureDomains))
	out.ControlPlaneSecurityGroup = (*v1beta1.SecurityGroup)(unsafe.Pointer(in.ControlPlaneSecurityGroup))
	out.WorkerSecurityGroup = (*v1beta1.SecurityGroup)(unsafe.Pointer(in.WorkerSecurityGroup))
	out.BastionSecurityGroup = (*v1beta1.SecurityGroup)(unsafe.Pointer(in.BastionSecurityGroup))
	if in.Bastion != nil {
		in, out := &in.Bastion, &out.Bastion
		*out = new(v1beta1.Instance)
		if err := Convert_v1alpha3_Instance_To_v1beta1_Instance(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Bastion = nil
	}
	return nil
}

// Convert_v1alpha3_OpenStackClusterStatus_To_v1beta1_OpenStackClusterStatus is an autogenerated conversion function.
func Convert_v1alpha3_OpenStackClusterStatus_To_v1beta1_OpenStackClusterStatus(in *OpenStackClusterStatus, out *v1beta1.OpenStackClusterStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpenStackClusterStatus_To_v1beta1_OpenStackClusterStatus(in, out, s)
}

func autoConvert_v1beta1_OpenStackClusterStatus_To_v1alpha3_OpenStackClusterStatus(in *v1beta1.OpenStackClusterStatus, out *OpenStackClusterStatus, s conversion.Scope) error {
	out.Ready = in.Ready
	if in.Network != nil {
		in, out := &in.Network, &out.Network
		*out = new(Network)
		if err := Convert_v1beta1_Network_To_v1alpha3_Network(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Network = nil
	}
	if in.ExternalNetwork != nil {
		in, out := &in.ExternalNetwork, &out.ExternalNetwork
		*out = new(Network)
		if err := Convert_v1beta1_Network_To_v1alpha3_Network(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ExternalNetwork = nil
	}
	out.FailureDomains = *(*apiv1alpha3.FailureDomains)(unsafe.Pointer(&in.FailureDomains))
	out.ControlPlaneSecurityGroup = (*SecurityGroup)(unsafe.Pointer(in.ControlPlaneSecurityGroup))
	out.WorkerSecurityGroup = (*SecurityGroup)(unsafe.Pointer(in.WorkerSecurityGroup))
	out.BastionSecurityGroup = (*SecurityGroup)(unsafe.Pointer(in.BastionSecurityGroup))
	if in.Bastion != nil {
		in, out := &in.Bastion, &out.Bastion
		*out = new(Instance)
		if err := Convert_v1beta1_Instance_To_v1alpha3_Instance(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Bastion = nil
	}
	// WARNING: in.FailureReason requires manual conversion: does not exist in peer-type
	// WARNING: in.FailureMessage requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_OpenStackMachine_To_v1beta1_OpenStackMachine(in *OpenStackMachine, out *v1beta1.OpenStackMachine, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_OpenStackMachineSpec_To_v1beta1_OpenStackMachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha3_OpenStackMachineStatus_To_v1beta1_OpenStackMachineStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_OpenStackMachine_To_v1beta1_OpenStackMachine is an autogenerated conversion function.
func Convert_v1alpha3_OpenStackMachine_To_v1beta1_OpenStackMachine(in *OpenStackMachine, out *v1beta1.OpenStackMachine, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpenStackMachine_To_v1beta1_OpenStackMachine(in, out, s)
}

func autoConvert_v1beta1_OpenStackMachine_To_v1alpha3_OpenStackMachine(in *v1beta1.OpenStackMachine, out *OpenStackMachine, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_OpenStackMachineSpec_To_v1alpha3_OpenStackMachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_OpenStackMachineStatus_To_v1alpha3_OpenStackMachineStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_OpenStackMachine_To_v1alpha3_OpenStackMachine is an autogenerated conversion function.
func Convert_v1beta1_OpenStackMachine_To_v1alpha3_OpenStackMachine(in *v1beta1.OpenStackMachine, out *OpenStackMachine, s conversion.Scope) error {
	return autoConvert_v1beta1_OpenStackMachine_To_v1alpha3_OpenStackMachine(in, out, s)
}

func autoConvert_v1alpha3_OpenStackMachineList_To_v1beta1_OpenStackMachineList(in *OpenStackMachineList, out *v1beta1.OpenStackMachineList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.OpenStackMachine, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_OpenStackMachine_To_v1beta1_OpenStackMachine(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_OpenStackMachineList_To_v1beta1_OpenStackMachineList is an autogenerated conversion function.
func Convert_v1alpha3_OpenStackMachineList_To_v1beta1_OpenStackMachineList(in *OpenStackMachineList, out *v1beta1.OpenStackMachineList, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpenStackMachineList_To_v1beta1_OpenStackMachineList(in, out, s)
}

func autoConvert_v1beta1_OpenStackMachineList_To_v1alpha3_OpenStackMachineList(in *v1beta1.OpenStackMachineList, out *OpenStackMachineList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]OpenStackMachine, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_OpenStackMachine_To_v1alpha3_OpenStackMachine(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_OpenStackMachineList_To_v1alpha3_OpenStackMachineList is an autogenerated conversion function.
func Convert_v1beta1_OpenStackMachineList_To_v1alpha3_OpenStackMachineList(in *v1beta1.OpenStackMachineList, out *OpenStackMachineList, s conversion.Scope) error {
	return autoConvert_v1beta1_OpenStackMachineList_To_v1alpha3_OpenStackMachineList(in, out, s)
}

func autoConvert_v1alpha3_OpenStackMachineSpec_To_v1beta1_OpenStackMachineSpec(in *OpenStackMachineSpec, out *v1beta1.OpenStackMachineSpec, s conversion.Scope) error {
	out.ProviderID = (*string)(unsafe.Pointer(in.ProviderID))
	out.InstanceID = (*string)(unsafe.Pointer(in.InstanceID))
	// INFO: in.CloudsSecret opted out of conversion generation
	out.CloudName = in.CloudName
	out.Flavor = in.Flavor
	out.Image = in.Image
	out.SSHKeyName = in.SSHKeyName
	if in.Networks != nil {
		in, out := &in.Networks, &out.Networks
		*out = make([]v1beta1.NetworkParam, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_NetworkParam_To_v1beta1_NetworkParam(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Networks = nil
	}
	out.Subnet = in.Subnet
	out.FloatingIP = in.FloatingIP
	out.SecurityGroups = *(*[]v1beta1.SecurityGroupParam)(unsafe.Pointer(&in.SecurityGroups))
	// WARNING: in.UserDataSecret requires manual conversion: does not exist in peer-type
	out.Trunk = in.Trunk
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	out.ServerMetadata = *(*map[string]string)(unsafe.Pointer(&in.ServerMetadata))
	out.ConfigDrive = (*bool)(unsafe.Pointer(in.ConfigDrive))
	out.RootVolume = (*v1beta1.RootVolume)(unsafe.Pointer(in.RootVolume))
	out.ServerGroupID = in.ServerGroupID
	return nil
}

func autoConvert_v1beta1_OpenStackMachineSpec_To_v1alpha3_OpenStackMachineSpec(in *v1beta1.OpenStackMachineSpec, out *OpenStackMachineSpec, s conversion.Scope) error {
	out.ProviderID = (*string)(unsafe.Pointer(in.ProviderID))
	out.InstanceID = (*string)(unsafe.Pointer(in.InstanceID))
	out.CloudName = in.CloudName
	out.Flavor = in.Flavor
	out.Image = in.Image
	out.SSHKeyName = in.SSHKeyName
	if in.Networks != nil {
		in, out := &in.Networks, &out.Networks
		*out = make([]NetworkParam, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_NetworkParam_To_v1alpha3_NetworkParam(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Networks = nil
	}
	// WARNING: in.Ports requires manual conversion: does not exist in peer-type
	out.Subnet = in.Subnet
	out.FloatingIP = in.FloatingIP
	out.SecurityGroups = *(*[]SecurityGroupParam)(unsafe.Pointer(&in.SecurityGroups))
	out.Trunk = in.Trunk
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	out.ServerMetadata = *(*map[string]string)(unsafe.Pointer(&in.ServerMetadata))
	out.ConfigDrive = (*bool)(unsafe.Pointer(in.ConfigDrive))
	out.RootVolume = (*RootVolume)(unsafe.Pointer(in.RootVolume))
	out.ServerGroupID = in.ServerGroupID
	// WARNING: in.IdentityRef requires manual conversion: does not exist in peer-type
	return nil
}

func autoConvert_v1alpha3_OpenStackMachineStatus_To_v1beta1_OpenStackMachineStatus(in *OpenStackMachineStatus, out *v1beta1.OpenStackMachineStatus, s conversion.Scope) error {
	out.Ready = in.Ready
	out.Addresses = *(*[]v1.NodeAddress)(unsafe.Pointer(&in.Addresses))
	out.InstanceState = (*v1beta1.InstanceState)(unsafe.Pointer(in.InstanceState))
	out.FailureReason = (*errors.MachineStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	return nil
}

// Convert_v1alpha3_OpenStackMachineStatus_To_v1beta1_OpenStackMachineStatus is an autogenerated conversion function.
func Convert_v1alpha3_OpenStackMachineStatus_To_v1beta1_OpenStackMachineStatus(in *OpenStackMachineStatus, out *v1beta1.OpenStackMachineStatus, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpenStackMachineStatus_To_v1beta1_OpenStackMachineStatus(in, out, s)
}

func autoConvert_v1beta1_OpenStackMachineStatus_To_v1alpha3_OpenStackMachineStatus(in *v1beta1.OpenStackMachineStatus, out *OpenStackMachineStatus, s conversion.Scope) error {
	out.Ready = in.Ready
	out.Addresses = *(*[]v1.NodeAddress)(unsafe.Pointer(&in.Addresses))
	out.InstanceState = (*InstanceState)(unsafe.Pointer(in.InstanceState))
	out.FailureReason = (*errors.MachineStatusError)(unsafe.Pointer(in.FailureReason))
	out.FailureMessage = (*string)(unsafe.Pointer(in.FailureMessage))
	return nil
}

// Convert_v1beta1_OpenStackMachineStatus_To_v1alpha3_OpenStackMachineStatus is an autogenerated conversion function.
func Convert_v1beta1_OpenStackMachineStatus_To_v1alpha3_OpenStackMachineStatus(in *v1beta1.OpenStackMachineStatus, out *OpenStackMachineStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_OpenStackMachineStatus_To_v1alpha3_OpenStackMachineStatus(in, out, s)
}

func autoConvert_v1alpha3_OpenStackMachineTemplate_To_v1beta1_OpenStackMachineTemplate(in *OpenStackMachineTemplate, out *v1beta1.OpenStackMachineTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha3_OpenStackMachineTemplateSpec_To_v1beta1_OpenStackMachineTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_OpenStackMachineTemplate_To_v1beta1_OpenStackMachineTemplate is an autogenerated conversion function.
func Convert_v1alpha3_OpenStackMachineTemplate_To_v1beta1_OpenStackMachineTemplate(in *OpenStackMachineTemplate, out *v1beta1.OpenStackMachineTemplate, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpenStackMachineTemplate_To_v1beta1_OpenStackMachineTemplate(in, out, s)
}

func autoConvert_v1beta1_OpenStackMachineTemplate_To_v1alpha3_OpenStackMachineTemplate(in *v1beta1.OpenStackMachineTemplate, out *OpenStackMachineTemplate, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_OpenStackMachineTemplateSpec_To_v1alpha3_OpenStackMachineTemplateSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_OpenStackMachineTemplate_To_v1alpha3_OpenStackMachineTemplate is an autogenerated conversion function.
func Convert_v1beta1_OpenStackMachineTemplate_To_v1alpha3_OpenStackMachineTemplate(in *v1beta1.OpenStackMachineTemplate, out *OpenStackMachineTemplate, s conversion.Scope) error {
	return autoConvert_v1beta1_OpenStackMachineTemplate_To_v1alpha3_OpenStackMachineTemplate(in, out, s)
}

func autoConvert_v1alpha3_OpenStackMachineTemplateList_To_v1beta1_OpenStackMachineTemplateList(in *OpenStackMachineTemplateList, out *v1beta1.OpenStackMachineTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.OpenStackMachineTemplate, len(*in))
		for i := range *in {
			if err := Convert_v1alpha3_OpenStackMachineTemplate_To_v1beta1_OpenStackMachineTemplate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1alpha3_OpenStackMachineTemplateList_To_v1beta1_OpenStackMachineTemplateList is an autogenerated conversion function.
func Convert_v1alpha3_OpenStackMachineTemplateList_To_v1beta1_OpenStackMachineTemplateList(in *OpenStackMachineTemplateList, out *v1beta1.OpenStackMachineTemplateList, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpenStackMachineTemplateList_To_v1beta1_OpenStackMachineTemplateList(in, out, s)
}

func autoConvert_v1beta1_OpenStackMachineTemplateList_To_v1alpha3_OpenStackMachineTemplateList(in *v1beta1.OpenStackMachineTemplateList, out *OpenStackMachineTemplateList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]OpenStackMachineTemplate, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_OpenStackMachineTemplate_To_v1alpha3_OpenStackMachineTemplate(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_OpenStackMachineTemplateList_To_v1alpha3_OpenStackMachineTemplateList is an autogenerated conversion function.
func Convert_v1beta1_OpenStackMachineTemplateList_To_v1alpha3_OpenStackMachineTemplateList(in *v1beta1.OpenStackMachineTemplateList, out *OpenStackMachineTemplateList, s conversion.Scope) error {
	return autoConvert_v1beta1_OpenStackMachineTemplateList_To_v1alpha3_OpenStackMachineTemplateList(in, out, s)
}

func autoConvert_v1alpha3_OpenStackMachineTemplateResource_To_v1beta1_OpenStackMachineTemplateResource(in *OpenStackMachineTemplateResource, out *v1beta1.OpenStackMachineTemplateResource, s conversion.Scope) error {
	if err := Convert_v1alpha3_OpenStackMachineSpec_To_v1beta1_OpenStackMachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_OpenStackMachineTemplateResource_To_v1beta1_OpenStackMachineTemplateResource is an autogenerated conversion function.
func Convert_v1alpha3_OpenStackMachineTemplateResource_To_v1beta1_OpenStackMachineTemplateResource(in *OpenStackMachineTemplateResource, out *v1beta1.OpenStackMachineTemplateResource, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpenStackMachineTemplateResource_To_v1beta1_OpenStackMachineTemplateResource(in, out, s)
}

func autoConvert_v1beta1_OpenStackMachineTemplateResource_To_v1alpha3_OpenStackMachineTemplateResource(in *v1beta1.OpenStackMachineTemplateResource, out *OpenStackMachineTemplateResource, s conversion.Scope) error {
	if err := Convert_v1beta1_OpenStackMachineSpec_To_v1alpha3_OpenStackMachineSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_OpenStackMachineTemplateResource_To_v1alpha3_OpenStackMachineTemplateResource is an autogenerated conversion function.
func Convert_v1beta1_OpenStackMachineTemplateResource_To_v1alpha3_OpenStackMachineTemplateResource(in *v1beta1.OpenStackMachineTemplateResource, out *OpenStackMachineTemplateResource, s conversion.Scope) error {
	return autoConvert_v1beta1_OpenStackMachineTemplateResource_To_v1alpha3_OpenStackMachineTemplateResource(in, out, s)
}

func autoConvert_v1alpha3_OpenStackMachineTemplateSpec_To_v1beta1_OpenStackMachineTemplateSpec(in *OpenStackMachineTemplateSpec, out *v1beta1.OpenStackMachineTemplateSpec, s conversion.Scope) error {
	if err := Convert_v1alpha3_OpenStackMachineTemplateResource_To_v1beta1_OpenStackMachineTemplateResource(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_OpenStackMachineTemplateSpec_To_v1beta1_OpenStackMachineTemplateSpec is an autogenerated conversion function.
func Convert_v1alpha3_OpenStackMachineTemplateSpec_To_v1beta1_OpenStackMachineTemplateSpec(in *OpenStackMachineTemplateSpec, out *v1beta1.OpenStackMachineTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1alpha3_OpenStackMachineTemplateSpec_To_v1beta1_OpenStackMachineTemplateSpec(in, out, s)
}

func autoConvert_v1beta1_OpenStackMachineTemplateSpec_To_v1alpha3_OpenStackMachineTemplateSpec(in *v1beta1.OpenStackMachineTemplateSpec, out *OpenStackMachineTemplateSpec, s conversion.Scope) error {
	if err := Convert_v1beta1_OpenStackMachineTemplateResource_To_v1alpha3_OpenStackMachineTemplateResource(&in.Template, &out.Template, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_OpenStackMachineTemplateSpec_To_v1alpha3_OpenStackMachineTemplateSpec is an autogenerated conversion function.
func Convert_v1beta1_OpenStackMachineTemplateSpec_To_v1alpha3_OpenStackMachineTemplateSpec(in *v1beta1.OpenStackMachineTemplateSpec, out *OpenStackMachineTemplateSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_OpenStackMachineTemplateSpec_To_v1alpha3_OpenStackMachineTemplateSpec(in, out, s)
}

func autoConvert_v1alpha3_RootVolume_To_v1beta1_RootVolume(in *RootVolume, out *v1beta1.RootVolume, s conversion.Scope) error {
	out.SourceType = in.SourceType
	out.SourceUUID = in.SourceUUID
	out.DeviceType = in.DeviceType
	out.Size = in.Size
	return nil
}

// Convert_v1alpha3_RootVolume_To_v1beta1_RootVolume is an autogenerated conversion function.
func Convert_v1alpha3_RootVolume_To_v1beta1_RootVolume(in *RootVolume, out *v1beta1.RootVolume, s conversion.Scope) error {
	return autoConvert_v1alpha3_RootVolume_To_v1beta1_RootVolume(in, out, s)
}

func autoConvert_v1beta1_RootVolume_To_v1alpha3_RootVolume(in *v1beta1.RootVolume, out *RootVolume, s conversion.Scope) error {
	out.SourceType = in.SourceType
	out.SourceUUID = in.SourceUUID
	out.DeviceType = in.DeviceType
	out.Size = in.Size
	return nil
}

// Convert_v1beta1_RootVolume_To_v1alpha3_RootVolume is an autogenerated conversion function.
func Convert_v1beta1_RootVolume_To_v1alpha3_RootVolume(in *v1beta1.RootVolume, out *RootVolume, s conversion.Scope) error {
	return autoConvert_v1beta1_RootVolume_To_v1alpha3_RootVolume(in, out, s)
}

func autoConvert_v1alpha3_Router_To_v1beta1_Router(in *Router, out *v1beta1.Router, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	return nil
}

// Convert_v1alpha3_Router_To_v1beta1_Router is an autogenerated conversion function.
func Convert_v1alpha3_Router_To_v1beta1_Router(in *Router, out *v1beta1.Router, s conversion.Scope) error {
	return autoConvert_v1alpha3_Router_To_v1beta1_Router(in, out, s)
}

func autoConvert_v1beta1_Router_To_v1alpha3_Router(in *v1beta1.Router, out *Router, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	return nil
}

// Convert_v1beta1_Router_To_v1alpha3_Router is an autogenerated conversion function.
func Convert_v1beta1_Router_To_v1alpha3_Router(in *v1beta1.Router, out *Router, s conversion.Scope) error {
	return autoConvert_v1beta1_Router_To_v1alpha3_Router(in, out, s)
}

func autoConvert_v1alpha3_SecurityGroup_To_v1beta1_SecurityGroup(in *SecurityGroup, out *v1beta1.SecurityGroup, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	out.Rules = *(*[]v1beta1.SecurityGroupRule)(unsafe.Pointer(&in.Rules))
	return nil
}

// Convert_v1alpha3_SecurityGroup_To_v1beta1_SecurityGroup is an autogenerated conversion function.
func Convert_v1alpha3_SecurityGroup_To_v1beta1_SecurityGroup(in *SecurityGroup, out *v1beta1.SecurityGroup, s conversion.Scope) error {
	return autoConvert_v1alpha3_SecurityGroup_To_v1beta1_SecurityGroup(in, out, s)
}

func autoConvert_v1beta1_SecurityGroup_To_v1alpha3_SecurityGroup(in *v1beta1.SecurityGroup, out *SecurityGroup, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	out.Rules = *(*[]SecurityGroupRule)(unsafe.Pointer(&in.Rules))
	return nil
}

// Convert_v1beta1_SecurityGroup_To_v1alpha3_SecurityGroup is an autogenerated conversion function.
func Convert_v1beta1_SecurityGroup_To_v1alpha3_SecurityGroup(in *v1beta1.SecurityGroup, out *SecurityGroup, s conversion.Scope) error {
	return autoConvert_v1beta1_SecurityGroup_To_v1alpha3_SecurityGroup(in, out, s)
}

func autoConvert_v1alpha3_SecurityGroupFilter_To_v1beta1_SecurityGroupFilter(in *SecurityGroupFilter, out *v1beta1.SecurityGroupFilter, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.Description = in.Description
	out.TenantID = in.TenantID
	out.ProjectID = in.ProjectID
	out.Limit = in.Limit
	out.Marker = in.Marker
	out.SortKey = in.SortKey
	out.SortDir = in.SortDir
	out.Tags = in.Tags
	out.TagsAny = in.TagsAny
	out.NotTags = in.NotTags
	out.NotTagsAny = in.NotTagsAny
	return nil
}

// Convert_v1alpha3_SecurityGroupFilter_To_v1beta1_SecurityGroupFilter is an autogenerated conversion function.
func Convert_v1alpha3_SecurityGroupFilter_To_v1beta1_SecurityGroupFilter(in *SecurityGroupFilter, out *v1beta1.SecurityGroupFilter, s conversion.Scope) error {
	return autoConvert_v1alpha3_SecurityGroupFilter_To_v1beta1_SecurityGroupFilter(in, out, s)
}

func autoConvert_v1beta1_SecurityGroupFilter_To_v1alpha3_SecurityGroupFilter(in *v1beta1.SecurityGroupFilter, out *SecurityGroupFilter, s conversion.Scope) error {
	out.ID = in.ID
	out.Name = in.Name
	out.Description = in.Description
	out.TenantID = in.TenantID
	out.ProjectID = in.ProjectID
	out.Limit = in.Limit
	out.Marker = in.Marker
	out.SortKey = in.SortKey
	out.SortDir = in.SortDir
	out.Tags = in.Tags
	out.TagsAny = in.TagsAny
	out.NotTags = in.NotTags
	out.NotTagsAny = in.NotTagsAny
	return nil
}

// Convert_v1beta1_SecurityGroupFilter_To_v1alpha3_SecurityGroupFilter is an autogenerated conversion function.
func Convert_v1beta1_SecurityGroupFilter_To_v1alpha3_SecurityGroupFilter(in *v1beta1.SecurityGroupFilter, out *SecurityGroupFilter, s conversion.Scope) error {
	return autoConvert_v1beta1_SecurityGroupFilter_To_v1alpha3_SecurityGroupFilter(in, out, s)
}

func autoConvert_v1alpha3_SecurityGroupParam_To_v1beta1_SecurityGroupParam(in *SecurityGroupParam, out *v1beta1.SecurityGroupParam, s conversion.Scope) error {
	out.UUID = in.UUID
	out.Name = in.Name
	if err := Convert_v1alpha3_SecurityGroupFilter_To_v1beta1_SecurityGroupFilter(&in.Filter, &out.Filter, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_SecurityGroupParam_To_v1beta1_SecurityGroupParam is an autogenerated conversion function.
func Convert_v1alpha3_SecurityGroupParam_To_v1beta1_SecurityGroupParam(in *SecurityGroupParam, out *v1beta1.SecurityGroupParam, s conversion.Scope) error {
	return autoConvert_v1alpha3_SecurityGroupParam_To_v1beta1_SecurityGroupParam(in, out, s)
}

func autoConvert_v1beta1_SecurityGroupParam_To_v1alpha3_SecurityGroupParam(in *v1beta1.SecurityGroupParam, out *SecurityGroupParam, s conversion.Scope) error {
	out.UUID = in.UUID
	out.Name = in.Name
	if err := Convert_v1beta1_SecurityGroupFilter_To_v1alpha3_SecurityGroupFilter(&in.Filter, &out.Filter, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_SecurityGroupParam_To_v1alpha3_SecurityGroupParam is an autogenerated conversion function.
func Convert_v1beta1_SecurityGroupParam_To_v1alpha3_SecurityGroupParam(in *v1beta1.SecurityGroupParam, out *SecurityGroupParam, s conversion.Scope) error {
	return autoConvert_v1beta1_SecurityGroupParam_To_v1alpha3_SecurityGroupParam(in, out, s)
}

func autoConvert_v1alpha3_SecurityGroupRule_To_v1beta1_SecurityGroupRule(in *SecurityGroupRule, out *v1beta1.SecurityGroupRule, s conversion.Scope) error {
	out.Description = in.Description
	out.ID = in.ID
	out.Direction = in.Direction
	out.EtherType = in.EtherType
	out.SecurityGroupID = in.SecurityGroupID
	out.PortRangeMin = in.PortRangeMin
	out.PortRangeMax = in.PortRangeMax
	out.Protocol = in.Protocol
	out.RemoteGroupID = in.RemoteGroupID
	out.RemoteIPPrefix = in.RemoteIPPrefix
	return nil
}

// Convert_v1alpha3_SecurityGroupRule_To_v1beta1_SecurityGroupRule is an autogenerated conversion function.
func Convert_v1alpha3_SecurityGroupRule_To_v1beta1_SecurityGroupRule(in *SecurityGroupRule, out *v1beta1.SecurityGroupRule, s conversion.Scope) error {
	return autoConvert_v1alpha3_SecurityGroupRule_To_v1beta1_SecurityGroupRule(in, out, s)
}

func autoConvert_v1beta1_SecurityGroupRule_To_v1alpha3_SecurityGroupRule(in *v1beta1.SecurityGroupRule, out *SecurityGroupRule, s conversion.Scope) error {
	out.Description = in.Description
	out.ID = in.ID
	out.Direction = in.Direction
	out.EtherType = in.EtherType
	out.SecurityGroupID = in.SecurityGroupID
	out.PortRangeMin = in.PortRangeMin
	out.PortRangeMax = in.PortRangeMax
	out.Protocol = in.Protocol
	out.RemoteGroupID = in.RemoteGroupID
	out.RemoteIPPrefix = in.RemoteIPPrefix
	return nil
}

// Convert_v1beta1_SecurityGroupRule_To_v1alpha3_SecurityGroupRule is an autogenerated conversion function.
func Convert_v1beta1_SecurityGroupRule_To_v1alpha3_SecurityGroupRule(in *v1beta1.SecurityGroupRule, out *SecurityGroupRule, s conversion.Scope) error {
	return autoConvert_v1beta1_SecurityGroupRule_To_v1alpha3_SecurityGroupRule(in, out, s)
}

func autoConvert_v1alpha3_Subnet_To_v1beta1_Subnet(in *Subnet, out *v1beta1.Subnet, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	out.CIDR = in.CIDR
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	return nil
}

// Convert_v1alpha3_Subnet_To_v1beta1_Subnet is an autogenerated conversion function.
func Convert_v1alpha3_Subnet_To_v1beta1_Subnet(in *Subnet, out *v1beta1.Subnet, s conversion.Scope) error {
	return autoConvert_v1alpha3_Subnet_To_v1beta1_Subnet(in, out, s)
}

func autoConvert_v1beta1_Subnet_To_v1alpha3_Subnet(in *v1beta1.Subnet, out *Subnet, s conversion.Scope) error {
	out.Name = in.Name
	out.ID = in.ID
	out.CIDR = in.CIDR
	out.Tags = *(*[]string)(unsafe.Pointer(&in.Tags))
	return nil
}

// Convert_v1beta1_Subnet_To_v1alpha3_Subnet is an autogenerated conversion function.
func Convert_v1beta1_Subnet_To_v1alpha3_Subnet(in *v1beta1.Subnet, out *Subnet, s conversion.Scope) error {
	return autoConvert_v1beta1_Subnet_To_v1alpha3_Subnet(in, out, s)
}

func autoConvert_v1alpha3_SubnetFilter_To_v1beta1_SubnetFilter(in *SubnetFilter, out *v1beta1.SubnetFilter, s conversion.Scope) error {
	out.Name = in.Name
	out.Description = in.Description
	// WARNING: in.EnableDHCP requires manual conversion: does not exist in peer-type
	// WARNING: in.NetworkID requires manual conversion: does not exist in peer-type
	// WARNING: in.TenantID requires manual conversion: does not exist in peer-type
	out.ProjectID = in.ProjectID
	out.IPVersion = in.IPVersion
	out.GatewayIP = in.GatewayIP
	out.CIDR = in.CIDR
	out.IPv6AddressMode = in.IPv6AddressMode
	out.IPv6RAMode = in.IPv6RAMode
	out.ID = in.ID
	// WARNING: in.SubnetPoolID requires manual conversion: does not exist in peer-type
	// WARNING: in.Limit requires manual conversion: does not exist in peer-type
	// WARNING: in.Marker requires manual conversion: does not exist in peer-type
	// WARNING: in.SortKey requires manual conversion: does not exist in peer-type
	// WARNING: in.SortDir requires manual conversion: does not exist in peer-type
	out.Tags = in.Tags
	out.TagsAny = in.TagsAny
	out.NotTags = in.NotTags
	out.NotTagsAny = in.NotTagsAny
	return nil
}

func autoConvert_v1beta1_SubnetFilter_To_v1alpha3_SubnetFilter(in *v1beta1.SubnetFilter, out *SubnetFilter, s conversion.Scope) error {
	out.Name = in.Name
	out.Description = in.Description
	out.ProjectID = in.ProjectID
	out.IPVersion = in.IPVersion
	out.GatewayIP = in.GatewayIP
	out.CIDR = in.CIDR
	out.IPv6AddressMode = in.IPv6AddressMode
	out.IPv6RAMode = in.IPv6RAMode
	out.ID = in.ID
	out.Tags = in.Tags
	out.TagsAny = in.TagsAny
	out.NotTags = in.NotTags
	out.NotTagsAny = in.NotTagsAny
	return nil
}

func autoConvert_v1alpha3_SubnetParam_To_v1beta1_SubnetParam(in *SubnetParam, out *v1beta1.SubnetParam, s conversion.Scope) error {
	out.UUID = in.UUID
	if err := Convert_v1alpha3_SubnetFilter_To_v1beta1_SubnetFilter(&in.Filter, &out.Filter, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha3_SubnetParam_To_v1beta1_SubnetParam is an autogenerated conversion function.
func Convert_v1alpha3_SubnetParam_To_v1beta1_SubnetParam(in *SubnetParam, out *v1beta1.SubnetParam, s conversion.Scope) error {
	return autoConvert_v1alpha3_SubnetParam_To_v1beta1_SubnetParam(in, out, s)
}

func autoConvert_v1beta1_SubnetParam_To_v1alpha3_SubnetParam(in *v1beta1.SubnetParam, out *SubnetParam, s conversion.Scope) error {
	out.UUID = in.UUID
	if err := Convert_v1beta1_SubnetFilter_To_v1alpha3_SubnetFilter(&in.Filter, &out.Filter, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_SubnetParam_To_v1alpha3_SubnetParam is an autogenerated conversion function.
func Convert_v1beta1_SubnetParam_To_v1alpha3_SubnetParam(in *v1beta1.SubnetParam, out *SubnetParam, s conversion.Scope) error {
	return autoConvert_v1beta1_SubnetParam_To_v1alpha3_SubnetParam(in, out, s)
}
