+++
title = "icon"
description = "Display an icon."
+++

Display an icon like `{{% icon cloud %}}`

It uses :

* glyphicons library (bootstrap).[more info here](http://getbootstrap.com/components/#glyphicons)
* fontawesome library [more info here](http://fontawesome.io/)

This `icon` shortcode will display an icon in your page. 

## Usage

| Parameter | Default | Description |
|:--|:--|:--|
| name | **required** | name of icon (see bellow) |
| size | none | size of icon, medium, xx-small, x-small, small, large, x-large, xx-large, 11px, 2em, 20%.... |

{{%alert info%}}
**Tips :**
setting only the name as argument works too : `{{</*icon film*/>}}` instead of `{{</*icon name="film"*/>}}`
{{%/alert%}}

# Demo
	
	{{</* icon name="film" size="large" */>}}

{{<icon name="film" size="large">}}

.

# icons available

- {{< icon name="asterisk" size="large" >}} asterisk
- {{< icon name="plus" size="large" >}} plus
- {{< icon name="euro" size="large" >}} euro
- {{< icon name="eur" size="large" >}} eur
- {{< icon name="minus" size="large" >}} minus
- {{< icon name="cloud" size="large" >}} cloud
- {{< icon name="envelope" size="large" >}} envelope
- {{< icon name="pencil" size="large" >}} pencil
- {{< icon name="glass" size="large" >}} glass
- {{< icon name="music" size="large" >}} music
- {{< icon name="search" size="large" >}} search
- {{< icon name="heart" size="large" >}} heart
- {{< icon name="star" size="large" >}} star
- {{< icon name="star-empty" size="large" >}} star-empty
- {{< icon name="user" size="large" >}} user
- {{< icon name="film" size="large" >}} film
- {{< icon name="th-large" size="large" >}} th-large
- {{< icon name="th" size="large" >}} th
- {{< icon name="th-list" size="large" >}} th-list
- {{< icon name="ok" size="large" >}} ok
- {{< icon name="remove" size="large" >}} remove
- {{< icon name="zoom-in" size="large" >}} zoom-in
- {{< icon name="zoom-out" size="large" >}} zoom-out
- {{< icon name="off" size="large" >}} off
- {{< icon name="signal" size="large" >}} signal
- {{< icon name="cog" size="large" >}} cog
- {{< icon name="trash" size="large" >}} trash
- {{< icon name="home" size="large" >}} home
- {{< icon name="file" size="large" >}} file
- {{< icon name="time" size="large" >}} time
- {{< icon name="road" size="large" >}} road
- {{< icon name="download-alt" size="large" >}} download-alt
- {{< icon name="download" size="large" >}} download
- {{< icon name="upload" size="large" >}} upload
- {{< icon name="inbox" size="large" >}} inbox
- {{< icon name="play-circle" size="large" >}} play-circle
- {{< icon name="repeat" size="large" >}} repeat
- {{< icon name="refresh" size="large" >}} refresh
- {{< icon name="list-alt" size="large" >}} list-alt
- {{< icon name="lock" size="large" >}} lock
- {{< icon name="flag" size="large" >}} flag
- {{< icon name="headphones" size="large" >}} headphones
- {{< icon name="volume-off" size="large" >}} volume-off
- {{< icon name="volume-down" size="large" >}} volume-down
- {{< icon name="volume-up" size="large" >}} volume-up
- {{< icon name="qrcode" size="large" >}} qrcode
- {{< icon name="barcode" size="large" >}} barcode
- {{< icon name="tag" size="large" >}} tag
- {{< icon name="tags" size="large" >}} tags
- {{< icon name="book" size="large" >}} book
- {{< icon name="bookmark" size="large" >}} bookmark
- {{< icon name="print" size="large" >}} print
- {{< icon name="camera" size="large" >}} camera
- {{< icon name="font" size="large" >}} font
- {{< icon name="bold" size="large" >}} bold
- {{< icon name="italic" size="large" >}} italic
- {{< icon name="text-height" size="large" >}} text-height
- {{< icon name="text-width" size="large" >}} text-width
- {{< icon name="align-left" size="large" >}} align-left
- {{< icon name="align-center" size="large" >}} align-center
- {{< icon name="align-right" size="large" >}} align-right
- {{< icon name="align-justify" size="large" >}} align-justify
- {{< icon name="list" size="large" >}} list
- {{< icon name="indent-left" size="large" >}} indent-left
- {{< icon name="indent-right" size="large" >}} indent-right
- {{< icon name="facetime-video" size="large" >}} facetime-video
- {{< icon name="picture" size="large" >}} picture
- {{< icon name="map-marker" size="large" >}} map-marker
- {{< icon name="adjust" size="large" >}} adjust
- {{< icon name="tint" size="large" >}} tint
- {{< icon name="edit" size="large" >}} edit
- {{< icon name="share" size="large" >}} share
- {{< icon name="check" size="large" >}} check
- {{< icon name="move" size="large" >}} move
- {{< icon name="step-backward" size="large" >}} step-backward
- {{< icon name="fast-backward" size="large" >}} fast-backward
- {{< icon name="backward" size="large" >}} backward
- {{< icon name="play" size="large" >}} play
- {{< icon name="pause" size="large" >}} pause
- {{< icon name="stop" size="large" >}} stop
- {{< icon name="forward" size="large" >}} forward
- {{< icon name="fast-forward" size="large" >}} fast-forward
- {{< icon name="step-forward" size="large" >}} step-forward
- {{< icon name="eject" size="large" >}} eject
- {{< icon name="chevron-left" size="large" >}} chevron-left
- {{< icon name="chevron-right" size="large" >}} chevron-right
- {{< icon name="plus-sign" size="large" >}} plus-sign
- {{< icon name="minus-sign" size="large" >}} minus-sign
- {{< icon name="remove-sign" size="large" >}} remove-sign
- {{< icon name="ok-sign" size="large" >}} ok-sign
- {{< icon name="question-sign" size="large" >}} question-sign
- {{< icon name="info-sign" size="large" >}} info-sign
- {{< icon name="screenshot" size="large" >}} screenshot
- {{< icon name="remove-circle" size="large" >}} remove-circle
- {{< icon name="ok-circle" size="large" >}} ok-circle
- {{< icon name="ban-circle" size="large" >}} ban-circle
- {{< icon name="arrow-left" size="large" >}} arrow-left
- {{< icon name="arrow-right" size="large" >}} arrow-right
- {{< icon name="arrow-up" size="large" >}} arrow-up
- {{< icon name="arrow-down" size="large" >}} arrow-down
- {{< icon name="share-alt" size="large" >}} share-alt
- {{< icon name="resize-full" size="large" >}} resize-full
- {{< icon name="resize-small" size="large" >}} resize-small
- {{< icon name="exclamation-sign" size="large" >}} exclamation-sign
- {{< icon name="gift" size="large" >}} gift
- {{< icon name="leaf" size="large" >}} leaf
- {{< icon name="fire" size="large" >}} fire
- {{< icon name="eye-open" size="large" >}} eye-open
- {{< icon name="eye-close" size="large" >}} eye-close
- {{< icon name="warning-sign" size="large" >}} warning-sign
- {{< icon name="plane" size="large" >}} plane
- {{< icon name="calendar" size="large" >}} calendar
- {{< icon name="random" size="large" >}} random
- {{< icon name="comment" size="large" >}} comment
- {{< icon name="magnet" size="large" >}} magnet
- {{< icon name="chevron-up" size="large" >}} chevron-up
- {{< icon name="chevron-down" size="large" >}} chevron-down
- {{< icon name="retweet" size="large" >}} retweet
- {{< icon name="shopping-cart" size="large" >}} shopping-cart
- {{< icon name="folder-close" size="large" >}} folder-close
- {{< icon name="folder-open" size="large" >}} folder-open
- {{< icon name="resize-vertical" size="large" >}} resize-vertical
- {{< icon name="resize-horizontal" size="large" >}} resize-horizontal
- {{< icon name="hdd" size="large" >}} hdd
- {{< icon name="bullhorn" size="large" >}} bullhorn
- {{< icon name="bell" size="large" >}} bell
- {{< icon name="certificate" size="large" >}} certificate
- {{< icon name="thumbs-up" size="large" >}} thumbs-up
- {{< icon name="thumbs-down" size="large" >}} thumbs-down
- {{< icon name="hand-right" size="large" >}} hand-right
- {{< icon name="hand-left" size="large" >}} hand-left
- {{< icon name="hand-up" size="large" >}} hand-up
- {{< icon name="hand-down" size="large" >}} hand-down
- {{< icon name="circle-arrow-right" size="large" >}} circle-arrow-right
- {{< icon name="circle-arrow-left" size="large" >}} circle-arrow-left
- {{< icon name="circle-arrow-up" size="large" >}} circle-arrow-up
- {{< icon name="circle-arrow-down" size="large" >}} circle-arrow-down
- {{< icon name="globe" size="large" >}} globe
- {{< icon name="wrench" size="large" >}} wrench
- {{< icon name="tasks" size="large" >}} tasks
- {{< icon name="filter" size="large" >}} filter
- {{< icon name="briefcase" size="large" >}} briefcase
- {{< icon name="fullscreen" size="large" >}} fullscreen
- {{< icon name="dashboard" size="large" >}} dashboard
- {{< icon name="paperclip" size="large" >}} paperclip
- {{< icon name="heart-empty" size="large" >}} heart-empty
- {{< icon name="link" size="large" >}} link
- {{< icon name="phone" size="large" >}} phone
- {{< icon name="pushpin" size="large" >}} pushpin
- {{< icon name="usd" size="large" >}} usd
- {{< icon name="gbp" size="large" >}} gbp
- {{< icon name="sort" size="large" >}} sort
- {{< icon name="sort-by-alphabet" size="large" >}} sort-by-alphabet
- {{< icon name="sort-by-alphabet-alt" size="large" >}} sort-by-alphabet-alt
- {{< icon name="sort-by-order" size="large" >}} sort-by-order
- {{< icon name="sort-by-order-alt" size="large" >}} sort-by-order-alt
- {{< icon name="sort-by-attributes" size="large" >}} sort-by-attributes
- {{< icon name="sort-by-attributes-alt" size="large" >}} sort-by-attributes-alt
- {{< icon name="unchecked" size="large" >}} unchecked
- {{< icon name="expand" size="large" >}} expand
- {{< icon name="collapse-down" size="large" >}} collapse-down
- {{< icon name="collapse-up" size="large" >}} collapse-up
- {{< icon name="log-in" size="large" >}} log-in
- {{< icon name="flash" size="large" >}} flash
- {{< icon name="log-out" size="large" >}} log-out
- {{< icon name="new-window" size="large" >}} new-window
- {{< icon name="record" size="large" >}} record
- {{< icon name="save" size="large" >}} save
- {{< icon name="open" size="large" >}} open
- {{< icon name="saved" size="large" >}} saved
- {{< icon name="import" size="large" >}} import
- {{< icon name="export" size="large" >}} export
- {{< icon name="send" size="large" >}} send
- {{< icon name="floppy-disk" size="large" >}} floppy-disk
- {{< icon name="floppy-saved" size="large" >}} floppy-saved
- {{< icon name="floppy-remove" size="large" >}} floppy-remove
- {{< icon name="floppy-save" size="large" >}} floppy-save
- {{< icon name="floppy-open" size="large" >}} floppy-open
- {{< icon name="credit-card" size="large" >}} credit-card
- {{< icon name="transfer" size="large" >}} transfer
- {{< icon name="cutlery" size="large" >}} cutlery
- {{< icon name="header" size="large" >}} header
- {{< icon name="compressed" size="large" >}} compressed
- {{< icon name="earphone" size="large" >}} earphone
- {{< icon name="phone-alt" size="large" >}} phone-alt
- {{< icon name="tower" size="large" >}} tower
- {{< icon name="stats" size="large" >}} stats
- {{< icon name="sd-video" size="large" >}} sd-video
- {{< icon name="hd-video" size="large" >}} hd-video
- {{< icon name="subtitles" size="large" >}} subtitles
- {{< icon name="sound-stereo" size="large" >}} sound-stereo
- {{< icon name="sound-dolby" size="large" >}} sound-dolby
- {{< icon name="sound-5-1" size="large" >}} sound-5-1
- {{< icon name="sound-6-1" size="large" >}} sound-6-1
- {{< icon name="sound-7-1" size="large" >}} sound-7-1
- {{< icon name="copyright-mark" size="large" >}} copyright-mark
- {{< icon name="registration-mark" size="large" >}} registration-mark
- {{< icon name="cloud-download" size="large" >}} cloud-download
- {{< icon name="cloud-upload" size="large" >}} cloud-upload
- {{< icon name="tree-conifer" size="large" >}} tree-conifer
- {{< icon name="tree-deciduous" size="large" >}} tree-deciduous
- {{< icon name="cd" size="large" >}} cd
- {{< icon name="save-file" size="large" >}} save-file
- {{< icon name="open-file" size="large" >}} open-file
- {{< icon name="level-up" size="large" >}} level-up
- {{< icon name="copy" size="large" >}} copy
- {{< icon name="paste" size="large" >}} paste
- {{< icon name="alert" size="large" >}} alert
- {{< icon name="equalizer" size="large" >}} equalizer
- {{< icon name="king" size="large" >}} king
- {{< icon name="queen" size="large" >}} queen
- {{< icon name="pawn" size="large" >}} pawn
- {{< icon name="bishop" size="large" >}} bishop
- {{< icon name="knight" size="large" >}} knight
- {{< icon name="baby-formula" size="large" >}} baby-formula
- {{< icon name="tent" size="large" >}} tent
- {{< icon name="blackboard" size="large" >}} blackboard
- {{< icon name="bed" size="large" >}} bed
- {{< icon name="apple" size="large" >}} apple
- {{< icon name="erase" size="large" >}} erase
- {{< icon name="hourglass" size="large" >}} hourglass
- {{< icon name="lamp" size="large" >}} lamp
- {{< icon name="duplicate" size="large" >}} duplicate
- {{< icon name="piggy-bank" size="large" >}} piggy-bank
- {{< icon name="scissors" size="large" >}} scissors
- {{< icon name="bitcoin" size="large" >}} bitcoin
- {{< icon name="btc" size="large" >}} btc
- {{< icon name="xbt" size="large" >}} xbt
- {{< icon name="yen" size="large" >}} yen
- {{< icon name="jpy" size="large" >}} jpy
- {{< icon name="ruble" size="large" >}} ruble
- {{< icon name="rub" size="large" >}} rub
- {{< icon name="scale" size="large" >}} scale
- {{< icon name="ice-lolly" size="large" >}} ice-lolly
- {{< icon name="ice-lolly-tasted" size="large" >}} ice-lolly-tasted
- {{< icon name="education" size="large" >}} education
- {{< icon name="option-horizontal" size="large" >}} option-horizontal
- {{< icon name="option-vertical" size="large" >}} option-vertical
- {{< icon name="menu-hamburger" size="large" >}} menu-hamburger
- {{< icon name="modal-window" size="large" >}} modal-window
- {{< icon name="oil" size="large" >}} oil
- {{< icon name="grain" size="large" >}} grain
- {{< icon name="sunglasses" size="large" >}} sunglasses
- {{< icon name="text-size" size="large" >}} text-size
- {{< icon name="text-color" size="large" >}} text-color
- {{< icon name="text-background" size="large" >}} text-background
- {{< icon name="object-align-top" size="large" >}} object-align-top
- {{< icon name="object-align-bottom" size="large" >}} object-align-bottom
- {{< icon name="object-align-horizontal" size="large" >}} object-align-horizontal
- {{< icon name="object-align-left" size="large" >}} object-align-left
- {{< icon name="object-align-vertical" size="large" >}} object-align-vertical
- {{< icon name="object-align-right" size="large" >}} object-align-right
- {{< icon name="triangle-right" size="large" >}} triangle-right
- {{< icon name="triangle-left" size="large" >}} triangle-left
- {{< icon name="triangle-bottom" size="large" >}} triangle-bottom
- {{< icon name="triangle-top" size="large" >}} triangle-top
- {{< icon name="console" size="large" >}} console
- {{< icon name="superscript" size="large" >}} superscript
- {{< icon name="subscript" size="large" >}} subscript
- {{< icon name="menu-left" size="large" >}} menu-left
- {{< icon name="menu-right" size="large" >}} menu-right
- {{< icon name="menu-down" size="large" >}} menu-down
- {{< icon name="menu-up"  size="large" >}} menu-up


### Web Application Icons

- {{< icon fa-address-book >}} fa-address-book
- {{< icon fa-address-book-o >}} fa-address-book-o
- {{< icon fa-address-card >}} fa-address-card
- {{< icon fa-address-card-o >}} fa-address-card-o
- {{< icon fa-adjust >}} fa-adjust
- {{< icon fa-american-sign-language-interpreting >}} fa-american-sign-language-interpreting
- {{< icon fa-anchor >}} fa-anchor
- {{< icon fa-archive >}} fa-archive
- {{< icon fa-area-chart >}} fa-area-chart
- {{< icon fa-arrows >}} fa-arrows
- {{< icon fa-arrows-h >}} fa-arrows-h
- {{< icon fa-arrows-v >}} fa-arrows-v
- {{< icon fa-asl-interpreting >}} fa-asl-interpreting (alias)
- {{< icon fa-assistive-listening-systems >}} fa-assistive-listening-systems
- {{< icon fa-asterisk >}} fa-asterisk
- {{< icon fa-at >}} fa-at
- {{< icon fa-audio-description >}} fa-audio-description
- {{< icon fa-automobile >}} fa-automobile (alias)
- {{< icon fa-balance-scale >}} fa-balance-scale
- {{< icon fa-ban >}} fa-ban
- {{< icon fa-bank >}} fa-bank (alias)
- {{< icon fa-bar-chart >}} fa-bar-chart
- {{< icon fa-bar-chart-o >}} fa-bar-chart-o (alias)
- {{< icon fa-barcode >}} fa-barcode
- {{< icon fa-bars >}} fa-bars
- {{< icon fa-bath >}} fa-bath
- {{< icon fa-bathtub >}} fa-bathtub (alias)
- {{< icon fa-battery >}} fa-battery (alias)
- {{< icon fa-battery-0 >}} fa-battery-0 (alias)
- {{< icon fa-battery-1 >}} fa-battery-1 (alias)
- {{< icon fa-battery-2 >}} fa-battery-2 (alias)
- {{< icon fa-battery-3 >}} fa-battery-3 (alias)
- {{< icon fa-battery-4 >}} fa-battery-4 (alias)
- {{< icon fa-battery-empty >}} fa-battery-empty
- {{< icon fa-battery-full >}} fa-battery-full
- {{< icon fa-battery-half >}} fa-battery-half
- {{< icon fa-battery-quarter >}} fa-battery-quarter
- {{< icon fa-battery-three-quarters >}} fa-battery-three-quarters
- {{< icon fa-bed >}} fa-bed
- {{< icon fa-beer >}} fa-beer
- {{< icon fa-bell >}} fa-bell
- {{< icon fa-bell-o >}} fa-bell-o
- {{< icon fa-bell-slash >}} fa-bell-slash
- {{< icon fa-bell-slash-o >}} fa-bell-slash-o
- {{< icon fa-bicycle >}} fa-bicycle
- {{< icon fa-binoculars >}} fa-binoculars
- {{< icon fa-birthday-cake >}} fa-birthday-cake
- {{< icon fa-blind >}} fa-blind
- {{< icon fa-bluetooth >}} fa-bluetooth
- {{< icon fa-bluetooth-b >}} fa-bluetooth-b
- {{< icon fa-bolt >}} fa-bolt
- {{< icon fa-bomb >}} fa-bomb
- {{< icon fa-book >}} fa-book
- {{< icon fa-bookmark >}} fa-bookmark
- {{< icon fa-bookmark-o >}} fa-bookmark-o
- {{< icon fa-braille >}} fa-braille
- {{< icon fa-briefcase >}} fa-briefcase
- {{< icon fa-bug >}} fa-bug
- {{< icon fa-building >}} fa-building
- {{< icon fa-building-o >}} fa-building-o
- {{< icon fa-bullhorn >}} fa-bullhorn
- {{< icon fa-bullseye >}} fa-bullseye
- {{< icon fa-bus >}} fa-bus
- {{< icon fa-cab >}} fa-cab (alias)
- {{< icon fa-calculator >}} fa-calculator
- {{< icon fa-calendar >}} fa-calendar
- {{< icon fa-calendar-check-o >}} fa-calendar-check-o
- {{< icon fa-calendar-minus-o >}} fa-calendar-minus-o
- {{< icon fa-calendar-o >}} fa-calendar-o
- {{< icon fa-calendar-plus-o >}} fa-calendar-plus-o
- {{< icon fa-calendar-times-o >}} fa-calendar-times-o
- {{< icon fa-camera >}} fa-camera
- {{< icon fa-camera-retro >}} fa-camera-retro
- {{< icon fa-car >}} fa-car
- {{< icon fa-caret-square-o-down >}} fa-caret-square-o-down
- {{< icon fa-caret-square-o-left >}} fa-caret-square-o-left
- {{< icon fa-caret-square-o-right >}} fa-caret-square-o-right
- {{< icon fa-caret-square-o-up >}} fa-caret-square-o-up
- {{< icon fa-cart-arrow-down >}} fa-cart-arrow-down
- {{< icon fa-cart-plus >}} fa-cart-plus
- {{< icon fa-cc >}} fa-cc
- {{< icon fa-certificate >}} fa-certificate
- {{< icon fa-check >}} fa-check
- {{< icon fa-check-circle >}} fa-check-circle
- {{< icon fa-check-circle-o >}} fa-check-circle-o
- {{< icon fa-check-square >}} fa-check-square
- {{< icon fa-check-square-o >}} fa-check-square-o
- {{< icon fa-child >}} fa-child
- {{< icon fa-circle >}} fa-circle
- {{< icon fa-circle-o >}} fa-circle-o
- {{< icon fa-circle-o-notch >}} fa-circle-o-notch
- {{< icon fa-circle-thin >}} fa-circle-thin
- {{< icon fa-clock-o >}} fa-clock-o
- {{< icon fa-clone >}} fa-clone
- {{< icon fa-close >}} fa-close (alias)
- {{< icon fa-cloud >}} fa-cloud
- {{< icon fa-cloud-download >}} fa-cloud-download
- {{< icon fa-cloud-upload >}} fa-cloud-upload
- {{< icon fa-code >}} fa-code
- {{< icon fa-code-fork >}} fa-code-fork
- {{< icon fa-coffee >}} fa-coffee
- {{< icon fa-cog >}} fa-cog
- {{< icon fa-cogs >}} fa-cogs
- {{< icon fa-comment >}} fa-comment
- {{< icon fa-comment-o >}} fa-comment-o
- {{< icon fa-commenting >}} fa-commenting
- {{< icon fa-commenting-o >}} fa-commenting-o
- {{< icon fa-comments >}} fa-comments
- {{< icon fa-comments-o >}} fa-comments-o
- {{< icon fa-compass >}} fa-compass
- {{< icon fa-copyright >}} fa-copyright
- {{< icon fa-creative-commons >}} fa-creative-commons
- {{< icon fa-credit-card >}} fa-credit-card
- {{< icon fa-credit-card-alt >}} fa-credit-card-alt
- {{< icon fa-crop >}} fa-crop
- {{< icon fa-crosshairs >}} fa-crosshairs
- {{< icon fa-cube >}} fa-cube
- {{< icon fa-cubes >}} fa-cubes
- {{< icon fa-cutlery >}} fa-cutlery
- {{< icon fa-dashboard >}} fa-dashboard (alias)
- {{< icon fa-database >}} fa-database
- {{< icon fa-deaf >}} fa-deaf
- {{< icon fa-deafness >}} fa-deafness (alias)
- {{< icon fa-desktop >}} fa-desktop
- {{< icon fa-diamond >}} fa-diamond
- {{< icon fa-dot-circle-o >}} fa-dot-circle-o
- {{< icon fa-download >}} fa-download
- {{< icon fa-drivers-license >}} fa-drivers-license (alias)
- {{< icon fa-drivers-license-o >}} fa-drivers-license-o (alias)
- {{< icon fa-edit >}} fa-edit (alias)
- {{< icon fa-ellipsis-h >}} fa-ellipsis-h
- {{< icon fa-ellipsis-v >}} fa-ellipsis-v
- {{< icon fa-envelope >}} fa-envelope
- {{< icon fa-envelope-o >}} fa-envelope-o
- {{< icon fa-envelope-open >}} fa-envelope-open
- {{< icon fa-envelope-open-o >}} fa-envelope-open-o
- {{< icon fa-envelope-square >}} fa-envelope-square
- {{< icon fa-eraser >}} fa-eraser
- {{< icon fa-exchange >}} fa-exchange
- {{< icon fa-exclamation >}} fa-exclamation
- {{< icon fa-exclamation-circle >}} fa-exclamation-circle
- {{< icon fa-exclamation-triangle >}} fa-exclamation-triangle
- {{< icon fa-external-link >}} fa-external-link
- {{< icon fa-external-link-square >}} fa-external-link-square
- {{< icon fa-eye >}} fa-eye
- {{< icon fa-eye-slash >}} fa-eye-slash
- {{< icon fa-eyedropper >}} fa-eyedropper
- {{< icon fa-fax >}} fa-fax
- {{< icon fa-feed >}} fa-feed (alias)
- {{< icon fa-female >}} fa-female
- {{< icon fa-fighter-jet >}} fa-fighter-jet
- {{< icon fa-file-archive-o >}} fa-file-archive-o
- {{< icon fa-file-audio-o >}} fa-file-audio-o
- {{< icon fa-file-code-o >}} fa-file-code-o
- {{< icon fa-file-excel-o >}} fa-file-excel-o
- {{< icon fa-file-image-o >}} fa-file-image-o
- {{< icon fa-file-movie-o >}} fa-file-movie-o (alias)
- {{< icon fa-file-pdf-o >}} fa-file-pdf-o
- {{< icon fa-file-photo-o >}} fa-file-photo-o (alias)
- {{< icon fa-file-picture-o >}} fa-file-picture-o (alias)
- {{< icon fa-file-powerpoint-o >}} fa-file-powerpoint-o
- {{< icon fa-file-sound-o >}} fa-file-sound-o (alias)
- {{< icon fa-file-video-o >}} fa-file-video-o
- {{< icon fa-file-word-o >}} fa-file-word-o
- {{< icon fa-file-zip-o >}} fa-file-zip-o (alias)
- {{< icon fa-film >}} fa-film
- {{< icon fa-filter >}} fa-filter
- {{< icon fa-fire >}} fa-fire
- {{< icon fa-fire-extinguisher >}} fa-fire-extinguisher
- {{< icon fa-flag >}} fa-flag
- {{< icon fa-flag-checkered >}} fa-flag-checkered
- {{< icon fa-flag-o >}} fa-flag-o
- {{< icon fa-flash >}} fa-flash (alias)
- {{< icon fa-flask >}} fa-flask
- {{< icon fa-folder >}} fa-folder
- {{< icon fa-folder-o >}} fa-folder-o
- {{< icon fa-folder-open >}} fa-folder-open
- {{< icon fa-folder-open-o >}} fa-folder-open-o
- {{< icon fa-frown-o >}} fa-frown-o
- {{< icon fa-futbol-o >}} fa-futbol-o
- {{< icon fa-gamepad >}} fa-gamepad
- {{< icon fa-gavel >}} fa-gavel
- {{< icon fa-gear >}} fa-gear (alias)
- {{< icon fa-gears >}} fa-gears (alias)
- {{< icon fa-gift >}} fa-gift
- {{< icon fa-glass >}} fa-glass
- {{< icon fa-globe >}} fa-globe
- {{< icon fa-graduation-cap >}} fa-graduation-cap
- {{< icon fa-group >}} fa-group (alias)
- {{< icon fa-hand-grab-o >}} fa-hand-grab-o (alias)
- {{< icon fa-hand-lizard-o >}} fa-hand-lizard-o
- {{< icon fa-hand-paper-o >}} fa-hand-paper-o
- {{< icon fa-hand-peace-o >}} fa-hand-peace-o
- {{< icon fa-hand-pointer-o >}} fa-hand-pointer-o
- {{< icon fa-hand-rock-o >}} fa-hand-rock-o
- {{< icon fa-hand-scissors-o >}} fa-hand-scissors-o
- {{< icon fa-hand-spock-o >}} fa-hand-spock-o
- {{< icon fa-hand-stop-o >}} fa-hand-stop-o (alias)
- {{< icon fa-handshake-o >}} fa-handshake-o
- {{< icon fa-hard-of-hearing >}} fa-hard-of-hearing (alias)
- {{< icon fa-hashtag >}} fa-hashtag
- {{< icon fa-hdd-o >}} fa-hdd-o
- {{< icon fa-headphones >}} fa-headphones
- {{< icon fa-heart >}} fa-heart
- {{< icon fa-heart-o >}} fa-heart-o
- {{< icon fa-heartbeat >}} fa-heartbeat
- {{< icon fa-history >}} fa-history
- {{< icon fa-home >}} fa-home
- {{< icon fa-hotel >}} fa-hotel (alias)
- {{< icon fa-hourglass >}} fa-hourglass
- {{< icon fa-hourglass-1 >}} fa-hourglass-1 (alias)
- {{< icon fa-hourglass-2 >}} fa-hourglass-2 (alias)
- {{< icon fa-hourglass-3 >}} fa-hourglass-3 (alias)
- {{< icon fa-hourglass-end >}} fa-hourglass-end
- {{< icon fa-hourglass-half >}} fa-hourglass-half
- {{< icon fa-hourglass-o >}} fa-hourglass-o
- {{< icon fa-hourglass-start >}} fa-hourglass-start
- {{< icon fa-i-cursor >}} fa-i-cursor
- {{< icon fa-id-badge >}} fa-id-badge
- {{< icon fa-id-card >}} fa-id-card
- {{< icon fa-id-card-o >}} fa-id-card-o
- {{< icon fa-image >}} fa-image (alias)
- {{< icon fa-inbox >}} fa-inbox
- {{< icon fa-industry >}} fa-industry
- {{< icon fa-info >}} fa-info
- {{< icon fa-info-circle >}} fa-info-circle
- {{< icon fa-institution >}} fa-institution (alias)
- {{< icon fa-key >}} fa-key
- {{< icon fa-keyboard-o >}} fa-keyboard-o
- {{< icon fa-language >}} fa-language
- {{< icon fa-laptop >}} fa-laptop
- {{< icon fa-leaf >}} fa-leaf
- {{< icon fa-legal >}} fa-legal (alias)
- {{< icon fa-lemon-o >}} fa-lemon-o
- {{< icon fa-level-down >}} fa-level-down
- {{< icon fa-level-up >}} fa-level-up
- {{< icon fa-life-bouy >}} fa-life-bouy (alias)
- {{< icon fa-life-buoy >}} fa-life-buoy (alias)
- {{< icon fa-life-ring >}} fa-life-ring
- {{< icon fa-life-saver >}} fa-life-saver (alias)
- {{< icon fa-lightbulb-o >}} fa-lightbulb-o
- {{< icon fa-line-chart >}} fa-line-chart
- {{< icon fa-location-arrow >}} fa-location-arrow
- {{< icon fa-lock >}} fa-lock
- {{< icon fa-low-vision >}} fa-low-vision
- {{< icon fa-magic >}} fa-magic
- {{< icon fa-magnet >}} fa-magnet
- {{< icon fa-mail-forward >}} fa-mail-forward (alias)
- {{< icon fa-mail-reply >}} fa-mail-reply (alias)
- {{< icon fa-mail-reply-all >}} fa-mail-reply-all (alias)
- {{< icon fa-male >}} fa-male
- {{< icon fa-map >}} fa-map
- {{< icon fa-map-marker >}} fa-map-marker
- {{< icon fa-map-o >}} fa-map-o
- {{< icon fa-map-pin >}} fa-map-pin
- {{< icon fa-map-signs >}} fa-map-signs
- {{< icon fa-meh-o >}} fa-meh-o
- {{< icon fa-microchip >}} fa-microchip
- {{< icon fa-microphone >}} fa-microphone
- {{< icon fa-microphone-slash >}} fa-microphone-slash
- {{< icon fa-minus >}} fa-minus
- {{< icon fa-minus-circle >}} fa-minus-circle
- {{< icon fa-minus-square >}} fa-minus-square
- {{< icon fa-minus-square-o >}} fa-minus-square-o
- {{< icon fa-mobile >}} fa-mobile
- {{< icon fa-mobile-phone >}} fa-mobile-phone (alias)
- {{< icon fa-money >}} fa-money
- {{< icon fa-moon-o >}} fa-moon-o
- {{< icon fa-mortar-board >}} fa-mortar-board (alias)
- {{< icon fa-motorcycle >}} fa-motorcycle
- {{< icon fa-mouse-pointer >}} fa-mouse-pointer
- {{< icon fa-music >}} fa-music
- {{< icon fa-navicon >}} fa-navicon (alias)
- {{< icon fa-newspaper-o >}} fa-newspaper-o
- {{< icon fa-object-group >}} fa-object-group
- {{< icon fa-object-ungroup >}} fa-object-ungroup
- {{< icon fa-paint-brush >}} fa-paint-brush
- {{< icon fa-paper-plane >}} fa-paper-plane
- {{< icon fa-paper-plane-o >}} fa-paper-plane-o
- {{< icon fa-paw >}} fa-paw
- {{< icon fa-pencil >}} fa-pencil
- {{< icon fa-pencil-square >}} fa-pencil-square
- {{< icon fa-pencil-square-o >}} fa-pencil-square-o
- {{< icon fa-percent >}} fa-percent
- {{< icon fa-phone >}} fa-phone
- {{< icon fa-phone-square >}} fa-phone-square
- {{< icon fa-photo >}} fa-photo (alias)
- {{< icon fa-picture-o >}} fa-picture-o
- {{< icon fa-pie-chart >}} fa-pie-chart
- {{< icon fa-plane >}} fa-plane
- {{< icon fa-plug >}} fa-plug
- {{< icon fa-plus >}} fa-plus
- {{< icon fa-plus-circle >}} fa-plus-circle
- {{< icon fa-plus-square >}} fa-plus-square
- {{< icon fa-plus-square-o >}} fa-plus-square-o
- {{< icon fa-podcast >}} fa-podcast
- {{< icon fa-power-off >}} fa-power-off
- {{< icon fa-print >}} fa-print
- {{< icon fa-puzzle-piece >}} fa-puzzle-piece
- {{< icon fa-qrcode >}} fa-qrcode
- {{< icon fa-question >}} fa-question
- {{< icon fa-question-circle >}} fa-question-circle
- {{< icon fa-question-circle-o >}} fa-question-circle-o
- {{< icon fa-quote-left >}} fa-quote-left
- {{< icon fa-quote-right >}} fa-quote-right
- {{< icon fa-random >}} fa-random
- {{< icon fa-recycle >}} fa-recycle
- {{< icon fa-refresh >}} fa-refresh
- {{< icon fa-registered >}} fa-registered
- {{< icon fa-remove >}} fa-remove (alias)
- {{< icon fa-reorder >}} fa-reorder (alias)
- {{< icon fa-reply >}} fa-reply
- {{< icon fa-reply-all >}} fa-reply-all
- {{< icon fa-retweet >}} fa-retweet
- {{< icon fa-road >}} fa-road
- {{< icon fa-rocket >}} fa-rocket
- {{< icon fa-rss >}} fa-rss
- {{< icon fa-rss-square >}} fa-rss-square
- {{< icon fa-s15 >}} fa-s15 (alias)
- {{< icon fa-search >}} fa-search
- {{< icon fa-search-minus >}} fa-search-minus
- {{< icon fa-search-plus >}} fa-search-plus
- {{< icon fa-send >}} fa-send (alias)
- {{< icon fa-send-o >}} fa-send-o (alias)
- {{< icon fa-server >}} fa-server
- {{< icon fa-share >}} fa-share
- {{< icon fa-share-alt >}} fa-share-alt
- {{< icon fa-share-alt-square >}} fa-share-alt-square
- {{< icon fa-share-square >}} fa-share-square
- {{< icon fa-share-square-o >}} fa-share-square-o
- {{< icon fa-shield >}} fa-shield
- {{< icon fa-ship >}} fa-ship
- {{< icon fa-shopping-bag >}} fa-shopping-bag
- {{< icon fa-shopping-basket >}} fa-shopping-basket
- {{< icon fa-shopping-cart >}} fa-shopping-cart
- {{< icon fa-shower >}} fa-shower
- {{< icon fa-sign-in >}} fa-sign-in
- {{< icon fa-sign-language >}} fa-sign-language
- {{< icon fa-sign-out >}} fa-sign-out
- {{< icon fa-signal >}} fa-signal
- {{< icon fa-signing >}} fa-signing (alias)
- {{< icon fa-sitemap >}} fa-sitemap
- {{< icon fa-sliders >}} fa-sliders
- {{< icon fa-smile-o >}} fa-smile-o
- {{< icon fa-snowflake-o >}} fa-snowflake-o
- {{< icon fa-soccer-ball-o >}} fa-soccer-ball-o (alias)
- {{< icon fa-sort >}} fa-sort
- {{< icon fa-sort-alpha-asc >}} fa-sort-alpha-asc
- {{< icon fa-sort-alpha-desc >}} fa-sort-alpha-desc
- {{< icon fa-sort-amount-asc >}} fa-sort-amount-asc
- {{< icon fa-sort-amount-desc >}} fa-sort-amount-desc
- {{< icon fa-sort-asc >}} fa-sort-asc
- {{< icon fa-sort-desc >}} fa-sort-desc
- {{< icon fa-sort-down >}} fa-sort-down (alias)
- {{< icon fa-sort-numeric-asc >}} fa-sort-numeric-asc
- {{< icon fa-sort-numeric-desc >}} fa-sort-numeric-desc
- {{< icon fa-sort-up >}} fa-sort-up (alias)
- {{< icon fa-space-shuttle >}} fa-space-shuttle
- {{< icon fa-spinner >}} fa-spinner
- {{< icon fa-spoon >}} fa-spoon
- {{< icon fa-square >}} fa-square
- {{< icon fa-square-o >}} fa-square-o
- {{< icon fa-star >}} fa-star
- {{< icon fa-star-half >}} fa-star-half
- {{< icon fa-star-half-empty >}} fa-star-half-empty (alias)
- {{< icon fa-star-half-full >}} fa-star-half-full (alias)
- {{< icon fa-star-half-o >}} fa-star-half-o
- {{< icon fa-star-o >}} fa-star-o
- {{< icon fa-sticky-note >}} fa-sticky-note
- {{< icon fa-sticky-note-o >}} fa-sticky-note-o
- {{< icon fa-street-view >}} fa-street-view
- {{< icon fa-suitcase >}} fa-suitcase
- {{< icon fa-sun-o >}} fa-sun-o
- {{< icon fa-support >}} fa-support (alias)
- {{< icon fa-tablet >}} fa-tablet
- {{< icon fa-tachometer >}} fa-tachometer
- {{< icon fa-tag >}} fa-tag
- {{< icon fa-tags >}} fa-tags
- {{< icon fa-tasks >}} fa-tasks
- {{< icon fa-taxi >}} fa-taxi
- {{< icon fa-television >}} fa-television
- {{< icon fa-terminal >}} fa-terminal
- {{< icon fa-thermometer >}} fa-thermometer (alias)
- {{< icon fa-thermometer-0 >}} fa-thermometer-0 (alias)
- {{< icon fa-thermometer-1 >}} fa-thermometer-1 (alias)
- {{< icon fa-thermometer-2 >}} fa-thermometer-2 (alias)
- {{< icon fa-thermometer-3 >}} fa-thermometer-3 (alias)
- {{< icon fa-thermometer-4 >}} fa-thermometer-4 (alias)
- {{< icon fa-thermometer-empty >}} fa-thermometer-empty
- {{< icon fa-thermometer-full >}} fa-thermometer-full
- {{< icon fa-thermometer-half >}} fa-thermometer-half
- {{< icon fa-thermometer-quarter >}} fa-thermometer-quarter
- {{< icon fa-thermometer-three-quarters >}} fa-thermometer-three-quarters
- {{< icon fa-thumb-tack >}} fa-thumb-tack
- {{< icon fa-thumbs-down >}} fa-thumbs-down
- {{< icon fa-thumbs-o-down >}} fa-thumbs-o-down
- {{< icon fa-thumbs-o-up >}} fa-thumbs-o-up
- {{< icon fa-thumbs-up >}} fa-thumbs-up
- {{< icon fa-ticket >}} fa-ticket
- {{< icon fa-times >}} fa-times
- {{< icon fa-times-circle >}} fa-times-circle
- {{< icon fa-times-circle-o >}} fa-times-circle-o
- {{< icon fa-times-rectangle >}} fa-times-rectangle (alias)
- {{< icon fa-times-rectangle-o >}} fa-times-rectangle-o (alias)
- {{< icon fa-tint >}} fa-tint
- {{< icon fa-toggle-down >}} fa-toggle-down (alias)
- {{< icon fa-toggle-left >}} fa-toggle-left (alias)
- {{< icon fa-toggle-off >}} fa-toggle-off
- {{< icon fa-toggle-on >}} fa-toggle-on
- {{< icon fa-toggle-right >}} fa-toggle-right (alias)
- {{< icon fa-toggle-up >}} fa-toggle-up (alias)
- {{< icon fa-trademark >}} fa-trademark
- {{< icon fa-trash >}} fa-trash
- {{< icon fa-trash-o >}} fa-trash-o
- {{< icon fa-tree >}} fa-tree
- {{< icon fa-trophy >}} fa-trophy
- {{< icon fa-truck >}} fa-truck
- {{< icon fa-tty >}} fa-tty
- {{< icon fa-tv >}} fa-tv (alias)
- {{< icon fa-umbrella >}} fa-umbrella
- {{< icon fa-universal-access >}} fa-universal-access
- {{< icon fa-university >}} fa-university
- {{< icon fa-unlock >}} fa-unlock
- {{< icon fa-unlock-alt >}} fa-unlock-alt
- {{< icon fa-unsorted >}} fa-unsorted (alias)
- {{< icon fa-upload >}} fa-upload
- {{< icon fa-user >}} fa-user
- {{< icon fa-user-circle >}} fa-user-circle
- {{< icon fa-user-circle-o >}} fa-user-circle-o
- {{< icon fa-user-o >}} fa-user-o
- {{< icon fa-user-plus >}} fa-user-plus
- {{< icon fa-user-secret >}} fa-user-secret
- {{< icon fa-user-times >}} fa-user-times
- {{< icon fa-users >}} fa-users
- {{< icon fa-vcard >}} fa-vcard (alias)
- {{< icon fa-vcard-o >}} fa-vcard-o (alias)
- {{< icon fa-video-camera >}} fa-video-camera
- {{< icon fa-volume-control-phone >}} fa-volume-control-phone
- {{< icon fa-volume-down >}} fa-volume-down
- {{< icon fa-volume-off >}} fa-volume-off
- {{< icon fa-volume-up >}} fa-volume-up
- {{< icon fa-warning >}} fa-warning (alias)
- {{< icon fa-wheelchair >}} fa-wheelchair
- {{< icon fa-wheelchair-alt >}} fa-wheelchair-alt
- {{< icon fa-wifi >}} fa-wifi
- {{< icon fa-window-close >}} fa-window-close
- {{< icon fa-window-close-o >}} fa-window-close-o
- {{< icon fa-window-maximize >}} fa-window-maximize
- {{< icon fa-window-minimize >}} fa-window-minimize
- {{< icon fa-window-restore >}} fa-window-restore
- {{< icon fa-wrench >}} fa-wrench

### Accessibility Icons

- {{< icon fa-american-sign-language-interpreting >}} fa-american-sign-language-interpreting
- {{< icon fa-asl-interpreting >}} fa-asl-interpreting (alias)
- {{< icon fa-assistive-listening-systems >}} fa-assistive-listening-systems
- {{< icon fa-audio-description >}} fa-audio-description
- {{< icon fa-blind >}} fa-blind
- {{< icon fa-braille >}} fa-braille
- {{< icon fa-cc >}} fa-cc
- {{< icon fa-deaf >}} fa-deaf
- {{< icon fa-deafness >}} fa-deafness (alias)
- {{< icon fa-hard-of-hearing >}} fa-hard-of-hearing (alias)
- {{< icon fa-low-vision >}} fa-low-vision
- {{< icon fa-question-circle-o >}} fa-question-circle-o
- {{< icon fa-sign-language >}} fa-sign-language
- {{< icon fa-signing >}} fa-signing (alias)
- {{< icon fa-tty >}} fa-tty
- {{< icon fa-universal-access >}} fa-universal-access
- {{< icon fa-volume-control-phone >}} fa-volume-control-phone
- {{< icon fa-wheelchair >}} fa-wheelchair
- {{< icon fa-wheelchair-alt >}} fa-wheelchair-alt

### Hand Icons

- {{< icon fa-hand-grab-o >}} fa-hand-grab-o (alias)
- {{< icon fa-hand-lizard-o >}} fa-hand-lizard-o
- {{< icon fa-hand-o-down >}} fa-hand-o-down
- {{< icon fa-hand-o-left >}} fa-hand-o-left
- {{< icon fa-hand-o-right >}} fa-hand-o-right
- {{< icon fa-hand-o-up >}} fa-hand-o-up
- {{< icon fa-hand-paper-o >}} fa-hand-paper-o
- {{< icon fa-hand-peace-o >}} fa-hand-peace-o
- {{< icon fa-hand-pointer-o >}} fa-hand-pointer-o
- {{< icon fa-hand-rock-o >}} fa-hand-rock-o
- {{< icon fa-hand-scissors-o >}} fa-hand-scissors-o
- {{< icon fa-hand-spock-o >}} fa-hand-spock-o
- {{< icon fa-hand-stop-o >}} fa-hand-stop-o (alias)
- {{< icon fa-thumbs-down >}} fa-thumbs-down
- {{< icon fa-thumbs-o-down >}} fa-thumbs-o-down
- {{< icon fa-thumbs-o-up >}} fa-thumbs-o-up
- {{< icon fa-thumbs-up >}} fa-thumbs-up

### Transportation Icons

- {{< icon fa-ambulance >}} fa-ambulance
- {{< icon fa-automobile >}} fa-automobile (alias)
- {{< icon fa-bicycle >}} fa-bicycle
- {{< icon fa-bus >}} fa-bus
- {{< icon fa-cab >}} fa-cab (alias)
- {{< icon fa-car >}} fa-car
- {{< icon fa-fighter-jet >}} fa-fighter-jet
- {{< icon fa-motorcycle >}} fa-motorcycle
- {{< icon fa-plane >}} fa-plane
- {{< icon fa-rocket >}} fa-rocket
- {{< icon fa-ship >}} fa-ship
- {{< icon fa-space-shuttle >}} fa-space-shuttle
- {{< icon fa-subway >}} fa-subway
- {{< icon fa-taxi >}} fa-taxi
- {{< icon fa-train >}} fa-train
- {{< icon fa-truck >}} fa-truck
- {{< icon fa-wheelchair >}} fa-wheelchair
- {{< icon fa-wheelchair-alt >}} fa-wheelchair-alt

### Gender Icons

- {{< icon fa-genderless >}} fa-genderless
- {{< icon fa-intersex >}} fa-intersex (alias)
- {{< icon fa-mars >}} fa-mars
- {{< icon fa-mars-double >}} fa-mars-double
- {{< icon fa-mars-stroke >}} fa-mars-stroke
- {{< icon fa-mars-stroke-h >}} fa-mars-stroke-h
- {{< icon fa-mars-stroke-v >}} fa-mars-stroke-v
- {{< icon fa-mercury >}} fa-mercury
- {{< icon fa-neuter >}} fa-neuter
- {{< icon fa-transgender >}} fa-transgender
- {{< icon fa-transgender-alt >}} fa-transgender-alt
- {{< icon fa-venus >}} fa-venus
- {{< icon fa-venus-double >}} fa-venus-double
- {{< icon fa-venus-mars >}} fa-venus-mars

### File Type Icons

- {{< icon fa-file >}} fa-file
- {{< icon fa-file-archive-o >}} fa-file-archive-o
- {{< icon fa-file-audio-o >}} fa-file-audio-o
- {{< icon fa-file-code-o >}} fa-file-code-o
- {{< icon fa-file-excel-o >}} fa-file-excel-o
- {{< icon fa-file-image-o >}} fa-file-image-o
- {{< icon fa-file-movie-o >}} fa-file-movie-o (alias)
- {{< icon fa-file-o >}} fa-file-o
- {{< icon fa-file-pdf-o >}} fa-file-pdf-o
- {{< icon fa-file-photo-o >}} fa-file-photo-o (alias)
- {{< icon fa-file-picture-o >}} fa-file-picture-o (alias)
- {{< icon fa-file-powerpoint-o >}} fa-file-powerpoint-o
- {{< icon fa-file-sound-o >}} fa-file-sound-o (alias)
- {{< icon fa-file-text >}} fa-file-text
- {{< icon fa-file-text-o >}} fa-file-text-o
- {{< icon fa-file-video-o >}} fa-file-video-o
- {{< icon fa-file-word-o >}} fa-file-word-o
- {{< icon fa-file-zip-o >}} fa-file-zip-o (alias)

### Spinner Icons

- {{< icon fa-circle-o-notch >}} fa-circle-o-notch
- {{< icon fa-cog >}} fa-cog
- {{< icon fa-gear >}} fa-gear (alias)
- {{< icon fa-refresh >}} fa-refresh
- {{< icon fa-spinner >}} fa-spinner

### Form Control Icons

- {{< icon fa-check-square >}} fa-check-square
- {{< icon fa-check-square-o >}} fa-check-square-o
- {{< icon fa-circle >}} fa-circle
- {{< icon fa-circle-o >}} fa-circle-o
- {{< icon fa-dot-circle-o >}} fa-dot-circle-o
- {{< icon fa-minus-square >}} fa-minus-square
- {{< icon fa-minus-square-o >}} fa-minus-square-o
- {{< icon fa-plus-square >}} fa-plus-square
- {{< icon fa-plus-square-o >}} fa-plus-square-o
- {{< icon fa-square >}} fa-square
- {{< icon fa-square-o >}} fa-square-o

### Payment Icons

- {{< icon fa-cc-amex >}} fa-cc-amex
- {{< icon fa-cc-diners-club >}} fa-cc-diners-club
- {{< icon fa-cc-discover >}} fa-cc-discover
- {{< icon fa-cc-jcb >}} fa-cc-jcb
- {{< icon fa-cc-mastercard >}} fa-cc-mastercard
- {{< icon fa-cc-paypal >}} fa-cc-paypal
- {{< icon fa-cc-stripe >}} fa-cc-stripe
- {{< icon fa-cc-visa >}} fa-cc-visa
- {{< icon fa-credit-card >}} fa-credit-card
- {{< icon fa-credit-card-alt >}} fa-credit-card-alt
- {{< icon fa-google-wallet >}} fa-google-wallet
- {{< icon fa-paypal >}} fa-paypal

### Chart Icons

- {{< icon fa-area-chart >}} fa-area-chart
- {{< icon fa-bar-chart >}} fa-bar-chart
- {{< icon fa-bar-chart-o >}} fa-bar-chart-o (alias)
- {{< icon fa-line-chart >}} fa-line-chart
- {{< icon fa-pie-chart >}} fa-pie-chart

### Currency Icons

- {{< icon fa-bitcoin >}} fa-bitcoin (alias)
- {{< icon fa-btc >}} fa-btc
- {{< icon fa-cny >}} fa-cny (alias)
- {{< icon fa-dollar >}} fa-dollar (alias)
- {{< icon fa-eur >}} fa-eur
- {{< icon fa-euro >}} fa-euro (alias)
- {{< icon fa-gbp >}} fa-gbp
- {{< icon fa-gg >}} fa-gg
- {{< icon fa-gg-circle >}} fa-gg-circle
- {{< icon fa-ils >}} fa-ils
- {{< icon fa-inr >}} fa-inr
- {{< icon fa-jpy >}} fa-jpy
- {{< icon fa-krw >}} fa-krw
- {{< icon fa-money >}} fa-money
- {{< icon fa-rmb >}} fa-rmb (alias)
- {{< icon fa-rouble >}} fa-rouble (alias)
- {{< icon fa-rub >}} fa-rub
- {{< icon fa-ruble >}} fa-ruble (alias)
- {{< icon fa-rupee >}} fa-rupee (alias)
- {{< icon fa-shekel >}} fa-shekel (alias)
- {{< icon fa-sheqel >}} fa-sheqel (alias)
- {{< icon fa-try >}} fa-try
- {{< icon fa-turkish-lira >}} fa-turkish-lira (alias)
- {{< icon fa-usd >}} fa-usd
- {{< icon fa-won >}} fa-won (alias)
- {{< icon fa-yen >}} fa-yen (alias)

### Text Editor Icons

- {{< icon fa-align-center >}} fa-align-center
- {{< icon fa-align-justify >}} fa-align-justify
- {{< icon fa-align-left >}} fa-align-left
- {{< icon fa-align-right >}} fa-align-right
- {{< icon fa-bold >}} fa-bold
- {{< icon fa-chain >}} fa-chain (alias)
- {{< icon fa-chain-broken >}} fa-chain-broken
- {{< icon fa-clipboard >}} fa-clipboard
- {{< icon fa-columns >}} fa-columns
- {{< icon fa-copy >}} fa-copy (alias)
- {{< icon fa-cut >}} fa-cut (alias)
- {{< icon fa-dedent >}} fa-dedent (alias)
- {{< icon fa-eraser >}} fa-eraser
- {{< icon fa-file >}} fa-file
- {{< icon fa-file-o >}} fa-file-o
- {{< icon fa-file-text >}} fa-file-text
- {{< icon fa-file-text-o >}} fa-file-text-o
- {{< icon fa-files-o >}} fa-files-o
- {{< icon fa-floppy-o >}} fa-floppy-o
- {{< icon fa-font >}} fa-font
- {{< icon fa-header >}} fa-header
- {{< icon fa-indent >}} fa-indent
- {{< icon fa-italic >}} fa-italic
- {{< icon fa-link >}} fa-link
- {{< icon fa-list >}} fa-list
- {{< icon fa-list-alt >}} fa-list-alt
- {{< icon fa-list-ol >}} fa-list-ol
- {{< icon fa-list-ul >}} fa-list-ul
- {{< icon fa-outdent >}} fa-outdent
- {{< icon fa-paperclip >}} fa-paperclip
- {{< icon fa-paragraph >}} fa-paragraph
- {{< icon fa-paste >}} fa-paste (alias)
- {{< icon fa-repeat >}} fa-repeat
- {{< icon fa-rotate-left >}} fa-rotate-left (alias)
- {{< icon fa-rotate-right >}} fa-rotate-right (alias)
- {{< icon fa-save >}} fa-save (alias)
- {{< icon fa-scissors >}} fa-scissors
- {{< icon fa-strikethrough >}} fa-strikethrough
- {{< icon fa-subscript >}} fa-subscript
- {{< icon fa-superscript >}} fa-superscript
- {{< icon fa-table >}} fa-table
- {{< icon fa-text-height >}} fa-text-height
- {{< icon fa-text-width >}} fa-text-width
- {{< icon fa-th >}} fa-th
- {{< icon fa-th-large >}} fa-th-large
- {{< icon fa-th-list >}} fa-th-list
- {{< icon fa-underline >}} fa-underline
- {{< icon fa-undo >}} fa-undo
- {{< icon fa-unlink >}} fa-unlink (alias)

### Directional Icons

- {{< icon fa-angle-double-down >}} fa-angle-double-down
- {{< icon fa-angle-double-left >}} fa-angle-double-left
- {{< icon fa-angle-double-right >}} fa-angle-double-right
- {{< icon fa-angle-double-up >}} fa-angle-double-up
- {{< icon fa-angle-down >}} fa-angle-down
- {{< icon fa-angle-left >}} fa-angle-left
- {{< icon fa-angle-right >}} fa-angle-right
- {{< icon fa-angle-up >}} fa-angle-up
- {{< icon fa-arrow-circle-down >}} fa-arrow-circle-down
- {{< icon fa-arrow-circle-left >}} fa-arrow-circle-left
- {{< icon fa-arrow-circle-o-down >}} fa-arrow-circle-o-down
- {{< icon fa-arrow-circle-o-left >}} fa-arrow-circle-o-left
- {{< icon fa-arrow-circle-o-right >}} fa-arrow-circle-o-right
- {{< icon fa-arrow-circle-o-up >}} fa-arrow-circle-o-up
- {{< icon fa-arrow-circle-right >}} fa-arrow-circle-right
- {{< icon fa-arrow-circle-up >}} fa-arrow-circle-up
- {{< icon fa-arrow-down >}} fa-arrow-down
- {{< icon fa-arrow-left >}} fa-arrow-left
- {{< icon fa-arrow-right >}} fa-arrow-right
- {{< icon fa-arrow-up >}} fa-arrow-up
- {{< icon fa-arrows >}} fa-arrows
- {{< icon fa-arrows-alt >}} fa-arrows-alt
- {{< icon fa-arrows-h >}} fa-arrows-h
- {{< icon fa-arrows-v >}} fa-arrows-v
- {{< icon fa-caret-down >}} fa-caret-down
- {{< icon fa-caret-left >}} fa-caret-left
- {{< icon fa-caret-right >}} fa-caret-right
- {{< icon fa-caret-square-o-down >}} fa-caret-square-o-down
- {{< icon fa-caret-square-o-left >}} fa-caret-square-o-left
- {{< icon fa-caret-square-o-right >}} fa-caret-square-o-right
- {{< icon fa-caret-square-o-up >}} fa-caret-square-o-up
- {{< icon fa-caret-up >}} fa-caret-up
- {{< icon fa-chevron-circle-down >}} fa-chevron-circle-down
- {{< icon fa-chevron-circle-left >}} fa-chevron-circle-left
- {{< icon fa-chevron-circle-right >}} fa-chevron-circle-right
- {{< icon fa-chevron-circle-up >}} fa-chevron-circle-up
- {{< icon fa-chevron-down >}} fa-chevron-down
- {{< icon fa-chevron-left >}} fa-chevron-left
- {{< icon fa-chevron-right >}} fa-chevron-right
- {{< icon fa-chevron-up >}} fa-chevron-up
- {{< icon fa-exchange >}} fa-exchange
- {{< icon fa-hand-o-down >}} fa-hand-o-down
- {{< icon fa-hand-o-left >}} fa-hand-o-left
- {{< icon fa-hand-o-right >}} fa-hand-o-right
- {{< icon fa-hand-o-up >}} fa-hand-o-up
- {{< icon fa-long-arrow-down >}} fa-long-arrow-down
- {{< icon fa-long-arrow-left >}} fa-long-arrow-left
- {{< icon fa-long-arrow-right >}} fa-long-arrow-right
- {{< icon fa-long-arrow-up >}} fa-long-arrow-up
- {{< icon fa-toggle-down >}} fa-toggle-down (alias)
- {{< icon fa-toggle-left >}} fa-toggle-left (alias)
- {{< icon fa-toggle-right >}} fa-toggle-right (alias)
- {{< icon fa-toggle-up >}} fa-toggle-up (alias)

### Video Player Icons

- {{< icon fa-arrows-alt >}} fa-arrows-alt
- {{< icon fa-backward >}} fa-backward
- {{< icon fa-compress >}} fa-compress
- {{< icon fa-eject >}} fa-eject
- {{< icon fa-expand >}} fa-expand
- {{< icon fa-fast-backward >}} fa-fast-backward
- {{< icon fa-fast-forward >}} fa-fast-forward
- {{< icon fa-forward >}} fa-forward
- {{< icon fa-pause >}} fa-pause
- {{< icon fa-pause-circle >}} fa-pause-circle
- {{< icon fa-pause-circle-o >}} fa-pause-circle-o
- {{< icon fa-play >}} fa-play
- {{< icon fa-play-circle >}} fa-play-circle
- {{< icon fa-play-circle-o >}} fa-play-circle-o
- {{< icon fa-random >}} fa-random
- {{< icon fa-step-backward >}} fa-step-backward
- {{< icon fa-step-forward >}} fa-step-forward
- {{< icon fa-stop >}} fa-stop
- {{< icon fa-stop-circle >}} fa-stop-circle
- {{< icon fa-stop-circle-o >}} fa-stop-circle-o
- {{< icon fa-youtube-play >}} fa-youtube-play

### Brand Icons

- {{< icon fa-500px >}} fa-500px
- {{< icon fa-adn >}} fa-adn
- {{< icon fa-amazon >}} fa-amazon
- {{< icon fa-android >}} fa-android
- {{< icon fa-angellist >}} fa-angellist
- {{< icon fa-apple >}} fa-apple
- {{< icon fa-bandcamp >}} fa-bandcamp
- {{< icon fa-behance >}} fa-behance
- {{< icon fa-behance-square >}} fa-behance-square
- {{< icon fa-bitbucket >}} fa-bitbucket
- {{< icon fa-bitbucket-square >}} fa-bitbucket-square
- {{< icon fa-bitcoin >}} fa-bitcoin (alias)
- {{< icon fa-black-tie >}} fa-black-tie
- {{< icon fa-bluetooth >}} fa-bluetooth
- {{< icon fa-bluetooth-b >}} fa-bluetooth-b
- {{< icon fa-btc >}} fa-btc
- {{< icon fa-buysellads >}} fa-buysellads
- {{< icon fa-cc-amex >}} fa-cc-amex
- {{< icon fa-cc-diners-club >}} fa-cc-diners-club
- {{< icon fa-cc-discover >}} fa-cc-discover
- {{< icon fa-cc-jcb >}} fa-cc-jcb
- {{< icon fa-cc-mastercard >}} fa-cc-mastercard
- {{< icon fa-cc-paypal >}} fa-cc-paypal
- {{< icon fa-cc-stripe >}} fa-cc-stripe
- {{< icon fa-cc-visa >}} fa-cc-visa
- {{< icon fa-chrome >}} fa-chrome
- {{< icon fa-codepen >}} fa-codepen
- {{< icon fa-codiepie >}} fa-codiepie
- {{< icon fa-connectdevelop >}} fa-connectdevelop
- {{< icon fa-contao >}} fa-contao
- {{< icon fa-css3 >}} fa-css3
- {{< icon fa-dashcube >}} fa-dashcube
- {{< icon fa-delicious >}} fa-delicious
- {{< icon fa-deviantart >}} fa-deviantart
- {{< icon fa-digg >}} fa-digg
- {{< icon fa-dribbble >}} fa-dribbble
- {{< icon fa-dropbox >}} fa-dropbox
- {{< icon fa-drupal >}} fa-drupal
- {{< icon fa-edge >}} fa-edge
- {{< icon fa-eercast >}} fa-eercast
- {{< icon fa-empire >}} fa-empire
- {{< icon fa-envira >}} fa-envira
- {{< icon fa-etsy >}} fa-etsy
- {{< icon fa-expeditedssl >}} fa-expeditedssl
- {{< icon fa-fa >}} fa-fa (alias)
- {{< icon fa-facebook >}} fa-facebook
- {{< icon fa-facebook-f >}} fa-facebook-f (alias)
- {{< icon fa-facebook-official >}} fa-facebook-official
- {{< icon fa-facebook-square >}} fa-facebook-square
- {{< icon fa-firefox >}} fa-firefox
- {{< icon fa-first-order >}} fa-first-order
- {{< icon fa-flickr >}} fa-flickr
- {{< icon fa-font-awesome >}} fa-font-awesome
- {{< icon fa-fonticons >}} fa-fonticons
- {{< icon fa-fort-awesome >}} fa-fort-awesome
- {{< icon fa-forumbee >}} fa-forumbee
- {{< icon fa-foursquare >}} fa-foursquare
- {{< icon fa-free-code-camp >}} fa-free-code-camp
- {{< icon fa-ge >}} fa-ge (alias)
- {{< icon fa-get-pocket >}} fa-get-pocket
- {{< icon fa-gg >}} fa-gg
- {{< icon fa-gg-circle >}} fa-gg-circle
- {{< icon fa-git >}} fa-git
- {{< icon fa-git-square >}} fa-git-square
- {{< icon fa-github >}} fa-github
- {{< icon fa-github-alt >}} fa-github-alt
- {{< icon fa-github-square >}} fa-github-square
- {{< icon fa-gitlab >}} fa-gitlab
- {{< icon fa-gittip >}} fa-gittip (alias)
- {{< icon fa-glide >}} fa-glide
- {{< icon fa-glide-g >}} fa-glide-g
- {{< icon fa-google >}} fa-google
- {{< icon fa-google-plus >}} fa-google-plus
- {{< icon fa-google-plus-circle >}} fa-google-plus-circle (alias)
- {{< icon fa-google-plus-official >}} fa-google-plus-official
- {{< icon fa-google-plus-square >}} fa-google-plus-square
- {{< icon fa-google-wallet >}} fa-google-wallet
- {{< icon fa-gratipay >}} fa-gratipay
- {{< icon fa-grav >}} fa-grav
- {{< icon fa-hacker-news >}} fa-hacker-news
- {{< icon fa-houzz >}} fa-houzz
- {{< icon fa-html5 >}} fa-html5
- {{< icon fa-imdb >}} fa-imdb
- {{< icon fa-instagram >}} fa-instagram
- {{< icon fa-internet-explorer >}} fa-internet-explorer
- {{< icon fa-ioxhost >}} fa-ioxhost
- {{< icon fa-joomla >}} fa-joomla
- {{< icon fa-jsfiddle >}} fa-jsfiddle
- {{< icon fa-lastfm >}} fa-lastfm
- {{< icon fa-lastfm-square >}} fa-lastfm-square
- {{< icon fa-leanpub >}} fa-leanpub
- {{< icon fa-linkedin >}} fa-linkedin
- {{< icon fa-linkedin-square >}} fa-linkedin-square
- {{< icon fa-linode >}} fa-linode
- {{< icon fa-linux >}} fa-linux
- {{< icon fa-maxcdn >}} fa-maxcdn
- {{< icon fa-meanpath >}} fa-meanpath
- {{< icon fa-medium >}} fa-medium
- {{< icon fa-meetup >}} fa-meetup
- {{< icon fa-mixcloud >}} fa-mixcloud
- {{< icon fa-modx >}} fa-modx
- {{< icon fa-odnoklassniki >}} fa-odnoklassniki
- {{< icon fa-odnoklassniki-square >}} fa-odnoklassniki-square
- {{< icon fa-opencart >}} fa-opencart
- {{< icon fa-openid >}} fa-openid
- {{< icon fa-opera >}} fa-opera
- {{< icon fa-optin-monster >}} fa-optin-monster
- {{< icon fa-pagelines >}} fa-pagelines
- {{< icon fa-paypal >}} fa-paypal
- {{< icon fa-pied-piper >}} fa-pied-piper
- {{< icon fa-pied-piper-alt >}} fa-pied-piper-alt
- {{< icon fa-pied-piper-pp >}} fa-pied-piper-pp
- {{< icon fa-pinterest >}} fa-pinterest
- {{< icon fa-pinterest-p >}} fa-pinterest-p
- {{< icon fa-pinterest-square >}} fa-pinterest-square
- {{< icon fa-product-hunt >}} fa-product-hunt
- {{< icon fa-qq >}} fa-qq
- {{< icon fa-quora >}} fa-quora
- {{< icon fa-ra >}} fa-ra (alias)
- {{< icon fa-ravelry >}} fa-ravelry
- {{< icon fa-rebel >}} fa-rebel
- {{< icon fa-reddit >}} fa-reddit
- {{< icon fa-reddit-alien >}} fa-reddit-alien
- {{< icon fa-reddit-square >}} fa-reddit-square
- {{< icon fa-renren >}} fa-renren
- {{< icon fa-resistance >}} fa-resistance (alias)
- {{< icon fa-safari >}} fa-safari
- {{< icon fa-scribd >}} fa-scribd
- {{< icon fa-sellsy >}} fa-sellsy
- {{< icon fa-share-alt >}} fa-share-alt
- {{< icon fa-share-alt-square >}} fa-share-alt-square
- {{< icon fa-shirtsinbulk >}} fa-shirtsinbulk
- {{< icon fa-simplybuilt >}} fa-simplybuilt
- {{< icon fa-skyatlas >}} fa-skyatlas
- {{< icon fa-skype >}} fa-skype
- {{< icon fa-slack >}} fa-slack
- {{< icon fa-slideshare >}} fa-slideshare
- {{< icon fa-snapchat >}} fa-snapchat
- {{< icon fa-snapchat-ghost >}} fa-snapchat-ghost
- {{< icon fa-snapchat-square >}} fa-snapchat-square
- {{< icon fa-soundcloud >}} fa-soundcloud
- {{< icon fa-spotify >}} fa-spotify
- {{< icon fa-stack-exchange >}} fa-stack-exchange
- {{< icon fa-stack-overflow >}} fa-stack-overflow
- {{< icon fa-steam >}} fa-steam
- {{< icon fa-steam-square >}} fa-steam-square
- {{< icon fa-stumbleupon >}} fa-stumbleupon
- {{< icon fa-stumbleupon-circle >}} fa-stumbleupon-circle
- {{< icon fa-superpowers >}} fa-superpowers
- {{< icon fa-telegram >}} fa-telegram
- {{< icon fa-tencent-weibo >}} fa-tencent-weibo
- {{< icon fa-themeisle >}} fa-themeisle
- {{< icon fa-trello >}} fa-trello
- {{< icon fa-tripadvisor >}} fa-tripadvisor
- {{< icon fa-tumblr >}} fa-tumblr
- {{< icon fa-tumblr-square >}} fa-tumblr-square
- {{< icon fa-twitch >}} fa-twitch
- {{< icon fa-twitter >}} fa-twitter
- {{< icon fa-twitter-square >}} fa-twitter-square
- {{< icon fa-usb >}} fa-usb
- {{< icon fa-viacoin >}} fa-viacoin
- {{< icon fa-viadeo >}} fa-viadeo
- {{< icon fa-viadeo-square >}} fa-viadeo-square
- {{< icon fa-vimeo >}} fa-vimeo
- {{< icon fa-vimeo-square >}} fa-vimeo-square
- {{< icon fa-vine >}} fa-vine
- {{< icon fa-vk >}} fa-vk
- {{< icon fa-wechat >}} fa-wechat (alias)
- {{< icon fa-weibo >}} fa-weibo
- {{< icon fa-weixin >}} fa-weixin
- {{< icon fa-whatsapp >}} fa-whatsapp
- {{< icon fa-wikipedia-w >}} fa-wikipedia-w
- {{< icon fa-windows >}} fa-windows
- {{< icon fa-wordpress >}} fa-wordpress
- {{< icon fa-wpbeginner >}} fa-wpbeginner
- {{< icon fa-wpexplorer >}} fa-wpexplorer
- {{< icon fa-wpforms >}} fa-wpforms
- {{< icon fa-xing >}} fa-xing
- {{< icon fa-xing-square >}} fa-xing-square
- {{< icon fa-y-combinator >}} fa-y-combinator
- {{< icon fa-y-combinator-square >}} fa-y-combinator-square (alias)
- {{< icon fa-yahoo >}} fa-yahoo
- {{< icon fa-yc >}} fa-yc (alias)
- {{< icon fa-yc-square >}} fa-yc-square (alias)
- {{< icon fa-yelp >}} fa-yelp
- {{< icon fa-yoast >}} fa-yoast
- {{< icon fa-youtube >}} fa-youtube
- {{< icon fa-youtube-play >}} fa-youtube-play
- {{< icon fa-youtube-square >}} fa-youtube-square

