# Community Future - Proposal to Move to the CNCF Sandbox

## Summary

MetalLB was originally written by Dave Anderson and was later transitioned to a
team of [maintainers](https://metallb.universe.tf/community/maintainers/) that
currently maintain the project. The maintainers come from different companies
and desire a neutral home that can own assets of the project, such as the
domain names.

This proposal is for MetalLB to apply to become a [CNCF Sandbox
Project](https://www.cncf.io/sandbox-projects/).

## Motivation

While Dave Anderson is no longer actively involved with the project, he still
owns the MetalLB domain names. When discussing what to do with them,
transferring them to an individual or the employer of one or more of the
maintainers doesn't seem like an ideal solution. An alternative which is
becoming increasingly common in the open source ecosystem is to use an open
source foundation as a neutral home for those assets.

The CNCF seems like the most natural foundation home for MetalLB given its
coupling to the Kubernetes project, which is also part of the CNCF.

### Goals

- Align with other CNCF ecosystem projects in terms of policies and processes.
- Transfer assets to a neutral third party (i.e. domains).
- Gain more visibility in the CNCF ecosystem to attract others who may be
  interested in contributing to MetalLB development and maintenance.

### Non-Goals

- No changes to the MetalLB code are in scope of this proposal. This
  proposal is only about the community future.
- No changes to committer processes are proposed here. We already have a
  documented [process for adding and removing
  maintainers](https://metallb.universe.tf/community/maintainers/).

## Proposal

Apply to become a [CNCF Sandbox
project](https://www.cncf.io/sandbox-projects/).

The [Goals](#goals) section discusses some of the immediate changes we should
expect, but some of the other services provided by the CNCF may be very
beneficial to MetalLB in the future. The CNCF web site does a nice job
discussing what services they offer projects on the
[Services for CNCF Projects](https://www.cncf.io/services-for-projects/) page.

## Design Details

### Work Items

- (russellb) Write this proposal.
- (everyone) Provide feedback on initial proposal, reach consensus.
- (russellb) If approved, apply through the [proposal form](https://docs.google.com/forms/d/1bJhG1MuM981uQXcnBMv4Mj9yfV5_q5Kwk3qhBCLa_5A/viewform).
- (danderson) If accepted, transfer project assets as appropriate to CNCF. This
  includes transferring domains to CNCF, and likely MetalLB trademark
  assignment to the CNCF. See the CNCF [IP
  Policy](https://github.com/cncf/foundation/blob/master/charter.md#11-ip-policy).
- (russellb) Work with CNCF on any other CNCF onboarding tasks required, such
  as adding CNCF info to the web site footer.

## Alternatives

### Don't Apply to the CNCF Sandbox

This alternative is mostly the status quo, except we would need to decide which
individual or maintainer Dave should transfer domains to.
