// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/privacy/dlp/v2beta1/storage.proto

package dlp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Type of information detected by the API.
type InfoType struct {
	// Name of the information type. For built-in info types, this is provided by
	// the API call ListInfoTypes. For user-defined info types, this is
	// provided by the user. All user-defined info types must have unique names,
	// and cannot conflict with built-in info type names.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *InfoType) Reset()                    { *m = InfoType{} }
func (m *InfoType) String() string            { return proto.CompactTextString(m) }
func (*InfoType) ProtoMessage()               {}
func (*InfoType) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *InfoType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// General identifier of a data field in a storage service.
type FieldId struct {
	// Column name describing the field.
	ColumnName string `protobuf:"bytes,1,opt,name=column_name,json=columnName" json:"column_name,omitempty"`
}

func (m *FieldId) Reset()                    { *m = FieldId{} }
func (m *FieldId) String() string            { return proto.CompactTextString(m) }
func (*FieldId) ProtoMessage()               {}
func (*FieldId) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *FieldId) GetColumnName() string {
	if m != nil {
		return m.ColumnName
	}
	return ""
}

// Datastore partition ID.
// A partition ID identifies a grouping of entities. The grouping is always
// by project and namespace, however the namespace ID may be empty.
//
// A partition ID contains several dimensions:
// project ID and namespace ID.
type PartitionId struct {
	// The ID of the project to which the entities belong.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// If not empty, the ID of the namespace to which the entities belong.
	NamespaceId string `protobuf:"bytes,4,opt,name=namespace_id,json=namespaceId" json:"namespace_id,omitempty"`
}

func (m *PartitionId) Reset()                    { *m = PartitionId{} }
func (m *PartitionId) String() string            { return proto.CompactTextString(m) }
func (*PartitionId) ProtoMessage()               {}
func (*PartitionId) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *PartitionId) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *PartitionId) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

// A representation of a Datastore kind.
type KindExpression struct {
	// The name of the kind.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *KindExpression) Reset()                    { *m = KindExpression{} }
func (m *KindExpression) String() string            { return proto.CompactTextString(m) }
func (*KindExpression) ProtoMessage()               {}
func (*KindExpression) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

func (m *KindExpression) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A reference to a property relative to the Datastore kind expressions.
type PropertyReference struct {
	// The name of the property.
	// If name includes "."s, it may be interpreted as a property name path.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
}

func (m *PropertyReference) Reset()                    { *m = PropertyReference{} }
func (m *PropertyReference) String() string            { return proto.CompactTextString(m) }
func (*PropertyReference) ProtoMessage()               {}
func (*PropertyReference) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *PropertyReference) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A representation of a Datastore property in a projection.
type Projection struct {
	// The property to project.
	Property *PropertyReference `protobuf:"bytes,1,opt,name=property" json:"property,omitempty"`
}

func (m *Projection) Reset()                    { *m = Projection{} }
func (m *Projection) String() string            { return proto.CompactTextString(m) }
func (*Projection) ProtoMessage()               {}
func (*Projection) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *Projection) GetProperty() *PropertyReference {
	if m != nil {
		return m.Property
	}
	return nil
}

// Options defining a data set within Google Cloud Datastore.
type DatastoreOptions struct {
	// A partition ID identifies a grouping of entities. The grouping is always
	// by project and namespace, however the namespace ID may be empty.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId" json:"partition_id,omitempty"`
	// The kind to process.
	Kind *KindExpression `protobuf:"bytes,2,opt,name=kind" json:"kind,omitempty"`
	// Properties to scan. If none are specified, all properties will be scanned
	// by default.
	Projection []*Projection `protobuf:"bytes,3,rep,name=projection" json:"projection,omitempty"`
}

func (m *DatastoreOptions) Reset()                    { *m = DatastoreOptions{} }
func (m *DatastoreOptions) String() string            { return proto.CompactTextString(m) }
func (*DatastoreOptions) ProtoMessage()               {}
func (*DatastoreOptions) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *DatastoreOptions) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *DatastoreOptions) GetKind() *KindExpression {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (m *DatastoreOptions) GetProjection() []*Projection {
	if m != nil {
		return m.Projection
	}
	return nil
}

// Options defining a file or a set of files (path ending with *) within
// a Google Cloud Storage bucket.
type CloudStorageOptions struct {
	FileSet *CloudStorageOptions_FileSet `protobuf:"bytes,1,opt,name=file_set,json=fileSet" json:"file_set,omitempty"`
}

func (m *CloudStorageOptions) Reset()                    { *m = CloudStorageOptions{} }
func (m *CloudStorageOptions) String() string            { return proto.CompactTextString(m) }
func (*CloudStorageOptions) ProtoMessage()               {}
func (*CloudStorageOptions) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *CloudStorageOptions) GetFileSet() *CloudStorageOptions_FileSet {
	if m != nil {
		return m.FileSet
	}
	return nil
}

// Set of files to scan.
type CloudStorageOptions_FileSet struct {
	// The url, in the format `gs://<bucket>/<path>`. Trailing wildcard in the
	// path is allowed.
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
}

func (m *CloudStorageOptions_FileSet) Reset()                    { *m = CloudStorageOptions_FileSet{} }
func (m *CloudStorageOptions_FileSet) String() string            { return proto.CompactTextString(m) }
func (*CloudStorageOptions_FileSet) ProtoMessage()               {}
func (*CloudStorageOptions_FileSet) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7, 0} }

func (m *CloudStorageOptions_FileSet) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// A location in Cloud Storage.
type CloudStoragePath struct {
	// The url, in the format of `gs://bucket/<path>`.
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
}

func (m *CloudStoragePath) Reset()                    { *m = CloudStoragePath{} }
func (m *CloudStoragePath) String() string            { return proto.CompactTextString(m) }
func (*CloudStoragePath) ProtoMessage()               {}
func (*CloudStoragePath) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

func (m *CloudStoragePath) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// Shared message indicating Cloud storage type.
type StorageConfig struct {
	// Types that are valid to be assigned to Type:
	//	*StorageConfig_DatastoreOptions
	//	*StorageConfig_CloudStorageOptions
	Type isStorageConfig_Type `protobuf_oneof:"type"`
}

func (m *StorageConfig) Reset()                    { *m = StorageConfig{} }
func (m *StorageConfig) String() string            { return proto.CompactTextString(m) }
func (*StorageConfig) ProtoMessage()               {}
func (*StorageConfig) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

type isStorageConfig_Type interface {
	isStorageConfig_Type()
}

type StorageConfig_DatastoreOptions struct {
	DatastoreOptions *DatastoreOptions `protobuf:"bytes,2,opt,name=datastore_options,json=datastoreOptions,oneof"`
}
type StorageConfig_CloudStorageOptions struct {
	CloudStorageOptions *CloudStorageOptions `protobuf:"bytes,3,opt,name=cloud_storage_options,json=cloudStorageOptions,oneof"`
}

func (*StorageConfig_DatastoreOptions) isStorageConfig_Type()    {}
func (*StorageConfig_CloudStorageOptions) isStorageConfig_Type() {}

func (m *StorageConfig) GetType() isStorageConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *StorageConfig) GetDatastoreOptions() *DatastoreOptions {
	if x, ok := m.GetType().(*StorageConfig_DatastoreOptions); ok {
		return x.DatastoreOptions
	}
	return nil
}

func (m *StorageConfig) GetCloudStorageOptions() *CloudStorageOptions {
	if x, ok := m.GetType().(*StorageConfig_CloudStorageOptions); ok {
		return x.CloudStorageOptions
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StorageConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StorageConfig_OneofMarshaler, _StorageConfig_OneofUnmarshaler, _StorageConfig_OneofSizer, []interface{}{
		(*StorageConfig_DatastoreOptions)(nil),
		(*StorageConfig_CloudStorageOptions)(nil),
	}
}

func _StorageConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StorageConfig)
	// type
	switch x := m.Type.(type) {
	case *StorageConfig_DatastoreOptions:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatastoreOptions); err != nil {
			return err
		}
	case *StorageConfig_CloudStorageOptions:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudStorageOptions); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StorageConfig.Type has unexpected type %T", x)
	}
	return nil
}

func _StorageConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StorageConfig)
	switch tag {
	case 2: // type.datastore_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatastoreOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_DatastoreOptions{msg}
		return true, err
	case 3: // type.cloud_storage_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudStorageOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_CloudStorageOptions{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StorageConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StorageConfig)
	// type
	switch x := m.Type.(type) {
	case *StorageConfig_DatastoreOptions:
		s := proto.Size(x.DatastoreOptions)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageConfig_CloudStorageOptions:
		s := proto.Size(x.CloudStorageOptions)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Record key for a finding in a Cloud Storage file.
type CloudStorageKey struct {
	// Path to the file.
	FilePath string `protobuf:"bytes,1,opt,name=file_path,json=filePath" json:"file_path,omitempty"`
	// Byte offset of the referenced data in the file.
	StartOffset int64 `protobuf:"varint,2,opt,name=start_offset,json=startOffset" json:"start_offset,omitempty"`
}

func (m *CloudStorageKey) Reset()                    { *m = CloudStorageKey{} }
func (m *CloudStorageKey) String() string            { return proto.CompactTextString(m) }
func (*CloudStorageKey) ProtoMessage()               {}
func (*CloudStorageKey) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *CloudStorageKey) GetFilePath() string {
	if m != nil {
		return m.FilePath
	}
	return ""
}

func (m *CloudStorageKey) GetStartOffset() int64 {
	if m != nil {
		return m.StartOffset
	}
	return 0
}

// Record key for a finding in Cloud Datastore.
type DatastoreKey struct {
	// Datastore entity key.
	EntityKey *Key `protobuf:"bytes,1,opt,name=entity_key,json=entityKey" json:"entity_key,omitempty"`
}

func (m *DatastoreKey) Reset()                    { *m = DatastoreKey{} }
func (m *DatastoreKey) String() string            { return proto.CompactTextString(m) }
func (*DatastoreKey) ProtoMessage()               {}
func (*DatastoreKey) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{11} }

func (m *DatastoreKey) GetEntityKey() *Key {
	if m != nil {
		return m.EntityKey
	}
	return nil
}

// A unique identifier for a Datastore entity.
// If a key's partition ID or any of its path kinds or names are
// reserved/read-only, the key is reserved/read-only.
// A reserved/read-only key is forbidden in certain documented contexts.
type Key struct {
	// Entities are partitioned into subsets, currently identified by a project
	// ID and namespace ID.
	// Queries are scoped to a single partition.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId" json:"partition_id,omitempty"`
	// The entity path.
	// An entity path consists of one or more elements composed of a kind and a
	// string or numerical identifier, which identify entities. The first
	// element identifies a _root entity_, the second element identifies
	// a _child_ of the root entity, the third element identifies a child of the
	// second entity, and so forth. The entities identified by all prefixes of
	// the path are called the element's _ancestors_.
	//
	// A path can never be empty, and a path can have at most 100 elements.
	Path []*Key_PathElement `protobuf:"bytes,2,rep,name=path" json:"path,omitempty"`
}

func (m *Key) Reset()                    { *m = Key{} }
func (m *Key) String() string            { return proto.CompactTextString(m) }
func (*Key) ProtoMessage()               {}
func (*Key) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12} }

func (m *Key) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *Key) GetPath() []*Key_PathElement {
	if m != nil {
		return m.Path
	}
	return nil
}

// A (kind, ID/name) pair used to construct a key path.
//
// If either name or ID is set, the element is complete.
// If neither is set, the element is incomplete.
type Key_PathElement struct {
	// The kind of the entity.
	// A kind matching regex `__.*__` is reserved/read-only.
	// A kind must not contain more than 1500 bytes when UTF-8 encoded.
	// Cannot be `""`.
	Kind string `protobuf:"bytes,1,opt,name=kind" json:"kind,omitempty"`
	// The type of ID.
	//
	// Types that are valid to be assigned to IdType:
	//	*Key_PathElement_Id
	//	*Key_PathElement_Name
	IdType isKey_PathElement_IdType `protobuf_oneof:"id_type"`
}

func (m *Key_PathElement) Reset()                    { *m = Key_PathElement{} }
func (m *Key_PathElement) String() string            { return proto.CompactTextString(m) }
func (*Key_PathElement) ProtoMessage()               {}
func (*Key_PathElement) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{12, 0} }

type isKey_PathElement_IdType interface {
	isKey_PathElement_IdType()
}

type Key_PathElement_Id struct {
	Id int64 `protobuf:"varint,2,opt,name=id,oneof"`
}
type Key_PathElement_Name struct {
	Name string `protobuf:"bytes,3,opt,name=name,oneof"`
}

func (*Key_PathElement_Id) isKey_PathElement_IdType()   {}
func (*Key_PathElement_Name) isKey_PathElement_IdType() {}

func (m *Key_PathElement) GetIdType() isKey_PathElement_IdType {
	if m != nil {
		return m.IdType
	}
	return nil
}

func (m *Key_PathElement) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *Key_PathElement) GetId() int64 {
	if x, ok := m.GetIdType().(*Key_PathElement_Id); ok {
		return x.Id
	}
	return 0
}

func (m *Key_PathElement) GetName() string {
	if x, ok := m.GetIdType().(*Key_PathElement_Name); ok {
		return x.Name
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Key_PathElement) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Key_PathElement_OneofMarshaler, _Key_PathElement_OneofUnmarshaler, _Key_PathElement_OneofSizer, []interface{}{
		(*Key_PathElement_Id)(nil),
		(*Key_PathElement_Name)(nil),
	}
}

func _Key_PathElement_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Key_PathElement)
	// id_type
	switch x := m.IdType.(type) {
	case *Key_PathElement_Id:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Id))
	case *Key_PathElement_Name:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Name)
	case nil:
	default:
		return fmt.Errorf("Key_PathElement.IdType has unexpected type %T", x)
	}
	return nil
}

func _Key_PathElement_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Key_PathElement)
	switch tag {
	case 2: // id_type.id
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.IdType = &Key_PathElement_Id{int64(x)}
		return true, err
	case 3: // id_type.name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.IdType = &Key_PathElement_Name{x}
		return true, err
	default:
		return false, nil
	}
}

func _Key_PathElement_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Key_PathElement)
	// id_type
	switch x := m.IdType.(type) {
	case *Key_PathElement_Id:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Id))
	case *Key_PathElement_Name:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Name)))
		n += len(x.Name)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message for a unique key indicating a record that contains a finding.
type RecordKey struct {
	// Types that are valid to be assigned to Type:
	//	*RecordKey_CloudStorageKey
	//	*RecordKey_DatastoreKey
	Type isRecordKey_Type `protobuf_oneof:"type"`
}

func (m *RecordKey) Reset()                    { *m = RecordKey{} }
func (m *RecordKey) String() string            { return proto.CompactTextString(m) }
func (*RecordKey) ProtoMessage()               {}
func (*RecordKey) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{13} }

type isRecordKey_Type interface {
	isRecordKey_Type()
}

type RecordKey_CloudStorageKey struct {
	CloudStorageKey *CloudStorageKey `protobuf:"bytes,1,opt,name=cloud_storage_key,json=cloudStorageKey,oneof"`
}
type RecordKey_DatastoreKey struct {
	DatastoreKey *DatastoreKey `protobuf:"bytes,2,opt,name=datastore_key,json=datastoreKey,oneof"`
}

func (*RecordKey_CloudStorageKey) isRecordKey_Type() {}
func (*RecordKey_DatastoreKey) isRecordKey_Type()    {}

func (m *RecordKey) GetType() isRecordKey_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *RecordKey) GetCloudStorageKey() *CloudStorageKey {
	if x, ok := m.GetType().(*RecordKey_CloudStorageKey); ok {
		return x.CloudStorageKey
	}
	return nil
}

func (m *RecordKey) GetDatastoreKey() *DatastoreKey {
	if x, ok := m.GetType().(*RecordKey_DatastoreKey); ok {
		return x.DatastoreKey
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RecordKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RecordKey_OneofMarshaler, _RecordKey_OneofUnmarshaler, _RecordKey_OneofSizer, []interface{}{
		(*RecordKey_CloudStorageKey)(nil),
		(*RecordKey_DatastoreKey)(nil),
	}
}

func _RecordKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RecordKey)
	// type
	switch x := m.Type.(type) {
	case *RecordKey_CloudStorageKey:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudStorageKey); err != nil {
			return err
		}
	case *RecordKey_DatastoreKey:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatastoreKey); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RecordKey.Type has unexpected type %T", x)
	}
	return nil
}

func _RecordKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RecordKey)
	switch tag {
	case 1: // type.cloud_storage_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudStorageKey)
		err := b.DecodeMessage(msg)
		m.Type = &RecordKey_CloudStorageKey{msg}
		return true, err
	case 2: // type.datastore_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatastoreKey)
		err := b.DecodeMessage(msg)
		m.Type = &RecordKey_DatastoreKey{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RecordKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RecordKey)
	// type
	switch x := m.Type.(type) {
	case *RecordKey_CloudStorageKey:
		s := proto.Size(x.CloudStorageKey)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RecordKey_DatastoreKey:
		s := proto.Size(x.DatastoreKey)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*InfoType)(nil), "google.privacy.dlp.v2beta1.InfoType")
	proto.RegisterType((*FieldId)(nil), "google.privacy.dlp.v2beta1.FieldId")
	proto.RegisterType((*PartitionId)(nil), "google.privacy.dlp.v2beta1.PartitionId")
	proto.RegisterType((*KindExpression)(nil), "google.privacy.dlp.v2beta1.KindExpression")
	proto.RegisterType((*PropertyReference)(nil), "google.privacy.dlp.v2beta1.PropertyReference")
	proto.RegisterType((*Projection)(nil), "google.privacy.dlp.v2beta1.Projection")
	proto.RegisterType((*DatastoreOptions)(nil), "google.privacy.dlp.v2beta1.DatastoreOptions")
	proto.RegisterType((*CloudStorageOptions)(nil), "google.privacy.dlp.v2beta1.CloudStorageOptions")
	proto.RegisterType((*CloudStorageOptions_FileSet)(nil), "google.privacy.dlp.v2beta1.CloudStorageOptions.FileSet")
	proto.RegisterType((*CloudStoragePath)(nil), "google.privacy.dlp.v2beta1.CloudStoragePath")
	proto.RegisterType((*StorageConfig)(nil), "google.privacy.dlp.v2beta1.StorageConfig")
	proto.RegisterType((*CloudStorageKey)(nil), "google.privacy.dlp.v2beta1.CloudStorageKey")
	proto.RegisterType((*DatastoreKey)(nil), "google.privacy.dlp.v2beta1.DatastoreKey")
	proto.RegisterType((*Key)(nil), "google.privacy.dlp.v2beta1.Key")
	proto.RegisterType((*Key_PathElement)(nil), "google.privacy.dlp.v2beta1.Key.PathElement")
	proto.RegisterType((*RecordKey)(nil), "google.privacy.dlp.v2beta1.RecordKey")
}

func init() { proto.RegisterFile("google/privacy/dlp/v2beta1/storage.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 762 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0x8e, 0x93, 0x68, 0xdb, 0x1c, 0x67, 0xd9, 0xd4, 0x0b, 0x52, 0x94, 0x85, 0xfd, 0xb1, 0xd0,
	0x6e, 0xb4, 0x05, 0x5b, 0x84, 0x0b, 0x2e, 0x10, 0x45, 0x4a, 0x7f, 0x48, 0x88, 0xd4, 0x04, 0xb7,
	0x02, 0x01, 0x17, 0xd6, 0xd4, 0x33, 0x71, 0x87, 0x3a, 0x33, 0x23, 0x7b, 0x5a, 0xe1, 0x17, 0x40,
	0x3c, 0x0b, 0x2f, 0xc1, 0x83, 0x70, 0x8f, 0x78, 0x0c, 0x34, 0x3f, 0x49, 0xdc, 0x1f, 0xd2, 0x22,
	0xed, 0xdd, 0xe4, 0xe4, 0x9c, 0xef, 0xcc, 0xf9, 0xbe, 0xef, 0x8c, 0xa1, 0x9f, 0x72, 0x9e, 0x66,
	0x24, 0x14, 0x39, 0xbd, 0x42, 0x49, 0x19, 0xe2, 0x4c, 0x84, 0x57, 0x83, 0x33, 0x22, 0xd1, 0x67,
	0x61, 0x21, 0x79, 0x8e, 0x52, 0x12, 0x88, 0x9c, 0x4b, 0xee, 0xf5, 0x4c, 0x66, 0x60, 0x33, 0x03,
	0x9c, 0x89, 0xc0, 0x66, 0xf6, 0x3e, 0xb4, 0x28, 0x48, 0xd0, 0x10, 0x31, 0xc6, 0x25, 0x92, 0x94,
	0xb3, 0xc2, 0x54, 0xfa, 0xcf, 0x61, 0x7b, 0xcc, 0xe6, 0xfc, 0xb4, 0x14, 0xc4, 0xf3, 0xa0, 0xc9,
	0xd0, 0x82, 0x74, 0x9d, 0x97, 0x4e, 0xbf, 0x15, 0xe9, 0xb3, 0xff, 0x16, 0xb6, 0x8e, 0x28, 0xc9,
	0xf0, 0x18, 0x7b, 0x2f, 0xc0, 0x4d, 0x78, 0x76, 0xb9, 0x60, 0x71, 0x25, 0x0b, 0x4c, 0xe8, 0x58,
	0xe5, 0x4e, 0xc1, 0x9d, 0xa1, 0x5c, 0x52, 0x85, 0x3f, 0xc6, 0xde, 0x47, 0x00, 0x22, 0xe7, 0xbf,
	0x90, 0x44, 0xc6, 0x14, 0x77, 0xeb, 0x3a, 0xbd, 0x65, 0x23, 0x63, 0xec, 0xbd, 0x82, 0xb6, 0xc2,
	0x29, 0x04, 0x4a, 0x88, 0x4a, 0x68, 0xea, 0x04, 0x77, 0x15, 0x1b, 0x63, 0xff, 0x63, 0x78, 0x6f,
	0x42, 0x19, 0x3e, 0xfc, 0x55, 0xe4, 0xa4, 0x28, 0x28, 0x67, 0x77, 0x5e, 0xf1, 0x0d, 0xec, 0xcc,
	0x72, 0x2e, 0x48, 0x2e, 0xcb, 0x88, 0xcc, 0x49, 0x4e, 0x58, 0xb2, 0x9e, 0xa5, 0x5e, 0x49, 0xfc,
	0x01, 0x60, 0x66, 0xda, 0x2b, 0xa8, 0x31, 0x6c, 0x0b, 0x5b, 0xa6, 0xe1, 0xdc, 0xc1, 0xa7, 0xc1,
	0x7f, 0xd3, 0x18, 0xdc, 0x6a, 0x11, 0xad, 0xca, 0xfd, 0xbf, 0x1d, 0xe8, 0x1c, 0x20, 0x89, 0x94,
	0x28, 0x64, 0x2a, 0x34, 0xbf, 0xde, 0xb7, 0xd0, 0x16, 0x4b, 0x36, 0xd4, 0x7c, 0xa6, 0xc7, 0x9b,
	0x8d, 0x3d, 0xd6, 0xec, 0x45, 0xae, 0xa8, 0x50, 0xb9, 0x07, 0xcd, 0x0b, 0xca, 0x0c, 0x89, 0xee,
	0xe0, 0xed, 0x26, 0x8c, 0xeb, 0x84, 0x45, 0xba, 0xce, 0x3b, 0x5a, 0x49, 0x41, 0x39, 0xeb, 0x36,
	0x5e, 0x36, 0xfa, 0xee, 0xe0, 0xf5, 0x3d, 0xd3, 0xda, 0xec, 0xa8, 0x52, 0xe9, 0xff, 0xe6, 0xc0,
	0xd3, 0xfd, 0x8c, 0x5f, 0xe2, 0x13, 0x63, 0xbf, 0xe5, 0xac, 0x11, 0x6c, 0xcf, 0x69, 0x46, 0xe2,
	0x82, 0x48, 0x3b, 0xe7, 0x17, 0x9b, 0xd0, 0xef, 0x80, 0x08, 0x8e, 0x68, 0x46, 0x4e, 0x88, 0x8c,
	0xb6, 0xe6, 0xe6, 0xd0, 0x7b, 0xa6, 0x9c, 0xa7, 0x8f, 0x5e, 0x07, 0x1a, 0x97, 0x79, 0x66, 0x45,
	0x57, 0x47, 0xff, 0x35, 0x74, 0xaa, 0x20, 0x33, 0x24, 0xcf, 0x95, 0xe4, 0x02, 0xc9, 0xf3, 0xa5,
	0x37, 0xd4, 0xd9, 0xff, 0xcb, 0x81, 0xc7, 0x36, 0x67, 0x9f, 0xb3, 0x39, 0x4d, 0xbd, 0x9f, 0x61,
	0x07, 0x2f, 0xa5, 0x8a, 0xb9, 0x69, 0x6e, 0x79, 0xfd, 0x64, 0xd3, 0x9d, 0x6f, 0xea, 0x3b, 0xaa,
	0x45, 0x1d, 0x7c, 0x53, 0x73, 0x02, 0x1f, 0x24, 0xea, 0x5a, 0xb1, 0x5d, 0xcf, 0x55, 0x83, 0x86,
	0x6e, 0x10, 0xfe, 0x4f, 0x52, 0x46, 0xb5, 0xe8, 0x69, 0x72, 0x3b, 0x3c, 0x7c, 0x04, 0x4d, 0x59,
	0x0a, 0xe2, 0x7f, 0x07, 0x4f, 0xaa, 0x55, 0x13, 0x52, 0x7a, 0xcf, 0xa0, 0xa5, 0x95, 0xa8, 0x30,
	0xa1, 0xa5, 0xd1, 0x0c, 0xbd, 0x82, 0x76, 0x21, 0x51, 0x2e, 0x63, 0x3e, 0x9f, 0x2b, 0xa9, 0xd4,
	0xd8, 0x8d, 0xc8, 0xd5, 0xb1, 0xa9, 0x0e, 0xf9, 0xc7, 0xd0, 0x5e, 0x4d, 0xaa, 0xf0, 0xf6, 0x00,
	0x08, 0x93, 0x54, 0x96, 0xf1, 0x05, 0x59, 0xee, 0xc9, 0x8b, 0x8d, 0xfe, 0x23, 0x65, 0xd4, 0x32,
	0x25, 0x13, 0x52, 0xfa, 0xff, 0x38, 0xd0, 0x50, 0x38, 0xef, 0x72, 0x1b, 0xbe, 0xb6, 0x42, 0xd7,
	0xb5, 0x8f, 0x77, 0xef, 0xb9, 0x4d, 0xa0, 0x46, 0x3f, 0xcc, 0xc8, 0x82, 0x30, 0x69, 0x5c, 0xd1,
	0x3b, 0x55, 0x0f, 0xd5, 0x2a, 0xa8, 0x8c, 0xa3, 0xb7, 0xcb, 0x1a, 0x47, 0x6f, 0x4c, 0x07, 0xea,
	0xf6, 0xd1, 0x6a, 0x8c, 0x6a, 0x51, 0x9d, 0x62, 0xef, 0x7d, 0xfb, 0xa2, 0x28, 0x29, 0x5b, 0xa3,
	0x9a, 0x79, 0x53, 0x86, 0x2d, 0xd8, 0xa2, 0x38, 0xd6, 0x6a, 0xfc, 0xe9, 0x40, 0x2b, 0x22, 0x09,
	0xcf, 0xb1, 0x1a, 0xf8, 0x47, 0xd8, 0xb9, 0x6e, 0x85, 0x35, 0x7f, 0xbb, 0x0f, 0xb5, 0xc1, 0x84,
	0x94, 0xa3, 0x5a, 0xf4, 0x24, 0xb9, 0xa1, 0xf1, 0x14, 0x1e, 0xaf, 0x2d, 0xac, 0x60, 0x8d, 0x7d,
	0xfb, 0x0f, 0xb2, 0xaf, 0xc1, 0x6c, 0xe3, 0xca, 0xef, 0xa5, 0x9f, 0x86, 0xbf, 0x3b, 0xf0, 0x3c,
	0xe1, 0x8b, 0x0d, 0x38, 0x43, 0x38, 0xc8, 0xc4, 0x72, 0xe9, 0x9c, 0x9f, 0xbe, 0xb2, 0x99, 0x29,
	0xcf, 0x10, 0x4b, 0x03, 0x9e, 0xa7, 0x61, 0x4a, 0x98, 0xfe, 0xb2, 0x84, 0xe6, 0x2f, 0x24, 0x68,
	0x71, 0xd7, 0x07, 0xec, 0x4b, 0x9c, 0x89, 0x3f, 0xea, 0xdd, 0x6f, 0x4c, 0xbd, 0x1e, 0x3a, 0x38,
	0xc8, 0x44, 0xf0, 0xfd, 0x60, 0xa8, 0xfe, 0x3e, 0x7b, 0xa4, 0x41, 0x3e, 0xff, 0x37, 0x00, 0x00,
	0xff, 0xff, 0x86, 0xa8, 0xf9, 0x3f, 0x04, 0x07, 0x00, 0x00,
}
