// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/container/v1/cluster_service.proto

/*
Package container is a generated protocol buffer package.

It is generated from these files:
	google/container/v1/cluster_service.proto

It has these top-level messages:
	NodeConfig
	MasterAuth
	AddonsConfig
	HttpLoadBalancing
	HorizontalPodAutoscaling
	LegacyAbac
	Cluster
	ClusterUpdate
	Operation
	CreateClusterRequest
	GetClusterRequest
	UpdateClusterRequest
	SetMasterAuthRequest
	DeleteClusterRequest
	ListClustersRequest
	ListClustersResponse
	GetOperationRequest
	ListOperationsRequest
	CancelOperationRequest
	ListOperationsResponse
	GetServerConfigRequest
	ServerConfig
	CreateNodePoolRequest
	DeleteNodePoolRequest
	ListNodePoolsRequest
	GetNodePoolRequest
	NodePool
	NodeManagement
	AutoUpgradeOptions
	SetNodePoolManagementRequest
	RollbackNodePoolUpgradeRequest
	ListNodePoolsResponse
	NodePoolAutoscaling
	SetLabelsRequest
	SetLegacyAbacRequest
	StartIPRotationRequest
	CompleteIPRotationRequest
*/
package container

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The current status of the cluster.
type Cluster_Status int32

const (
	// Not set.
	Cluster_STATUS_UNSPECIFIED Cluster_Status = 0
	// The PROVISIONING state indicates the cluster is being created.
	Cluster_PROVISIONING Cluster_Status = 1
	// The RUNNING state indicates the cluster has been created and is fully
	// usable.
	Cluster_RUNNING Cluster_Status = 2
	// The RECONCILING state indicates that some work is actively being done on
	// the cluster, such as upgrading the master or node software. Details can
	// be found in the `statusMessage` field.
	Cluster_RECONCILING Cluster_Status = 3
	// The STOPPING state indicates the cluster is being deleted.
	Cluster_STOPPING Cluster_Status = 4
	// The ERROR state indicates the cluster may be unusable. Details
	// can be found in the `statusMessage` field.
	Cluster_ERROR Cluster_Status = 5
)

var Cluster_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RECONCILING",
	4: "STOPPING",
	5: "ERROR",
}
var Cluster_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RECONCILING":        3,
	"STOPPING":           4,
	"ERROR":              5,
}

func (x Cluster_Status) String() string {
	return proto.EnumName(Cluster_Status_name, int32(x))
}
func (Cluster_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{6, 0} }

// Current status of the operation.
type Operation_Status int32

const (
	// Not set.
	Operation_STATUS_UNSPECIFIED Operation_Status = 0
	// The operation has been created.
	Operation_PENDING Operation_Status = 1
	// The operation is currently running.
	Operation_RUNNING Operation_Status = 2
	// The operation is done, either cancelled or completed.
	Operation_DONE Operation_Status = 3
	// The operation is aborting.
	Operation_ABORTING Operation_Status = 4
)

var Operation_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PENDING",
	2: "RUNNING",
	3: "DONE",
	4: "ABORTING",
}
var Operation_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PENDING":            1,
	"RUNNING":            2,
	"DONE":               3,
	"ABORTING":           4,
}

func (x Operation_Status) String() string {
	return proto.EnumName(Operation_Status_name, int32(x))
}
func (Operation_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8, 0} }

// Operation type.
type Operation_Type int32

const (
	// Not set.
	Operation_TYPE_UNSPECIFIED Operation_Type = 0
	// Cluster create.
	Operation_CREATE_CLUSTER Operation_Type = 1
	// Cluster delete.
	Operation_DELETE_CLUSTER Operation_Type = 2
	// A master upgrade.
	Operation_UPGRADE_MASTER Operation_Type = 3
	// A node upgrade.
	Operation_UPGRADE_NODES Operation_Type = 4
	// Cluster repair.
	Operation_REPAIR_CLUSTER Operation_Type = 5
	// Cluster update.
	Operation_UPDATE_CLUSTER Operation_Type = 6
	// Node pool create.
	Operation_CREATE_NODE_POOL Operation_Type = 7
	// Node pool delete.
	Operation_DELETE_NODE_POOL Operation_Type = 8
	// Set node pool management.
	Operation_SET_NODE_POOL_MANAGEMENT Operation_Type = 9
	// Automatic node pool repair.
	Operation_AUTO_REPAIR_NODES Operation_Type = 10
	// Automatic node upgrade.
	Operation_AUTO_UPGRADE_NODES Operation_Type = 11
	// Set labels.
	Operation_SET_LABELS Operation_Type = 12
	// Set/generate master auth materials
	Operation_SET_MASTER_AUTH Operation_Type = 13
)

var Operation_Type_name = map[int32]string{
	0:  "TYPE_UNSPECIFIED",
	1:  "CREATE_CLUSTER",
	2:  "DELETE_CLUSTER",
	3:  "UPGRADE_MASTER",
	4:  "UPGRADE_NODES",
	5:  "REPAIR_CLUSTER",
	6:  "UPDATE_CLUSTER",
	7:  "CREATE_NODE_POOL",
	8:  "DELETE_NODE_POOL",
	9:  "SET_NODE_POOL_MANAGEMENT",
	10: "AUTO_REPAIR_NODES",
	11: "AUTO_UPGRADE_NODES",
	12: "SET_LABELS",
	13: "SET_MASTER_AUTH",
}
var Operation_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":         0,
	"CREATE_CLUSTER":           1,
	"DELETE_CLUSTER":           2,
	"UPGRADE_MASTER":           3,
	"UPGRADE_NODES":            4,
	"REPAIR_CLUSTER":           5,
	"UPDATE_CLUSTER":           6,
	"CREATE_NODE_POOL":         7,
	"DELETE_NODE_POOL":         8,
	"SET_NODE_POOL_MANAGEMENT": 9,
	"AUTO_REPAIR_NODES":        10,
	"AUTO_UPGRADE_NODES":       11,
	"SET_LABELS":               12,
	"SET_MASTER_AUTH":          13,
}

func (x Operation_Type) String() string {
	return proto.EnumName(Operation_Type_name, int32(x))
}
func (Operation_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8, 1} }

// operation type - what type of key rotation are we performing
type SetMasterAuthRequest_Action int32

const (
	// Operation is unknown and will error out
	SetMasterAuthRequest_UNKNOWN SetMasterAuthRequest_Action = 0
	// Set the password to a user generated value.
	SetMasterAuthRequest_SET_PASSWORD SetMasterAuthRequest_Action = 1
	// Generate a new password and set it to that.
	SetMasterAuthRequest_GENERATE_PASSWORD SetMasterAuthRequest_Action = 2
)

var SetMasterAuthRequest_Action_name = map[int32]string{
	0: "UNKNOWN",
	1: "SET_PASSWORD",
	2: "GENERATE_PASSWORD",
}
var SetMasterAuthRequest_Action_value = map[string]int32{
	"UNKNOWN":           0,
	"SET_PASSWORD":      1,
	"GENERATE_PASSWORD": 2,
}

func (x SetMasterAuthRequest_Action) String() string {
	return proto.EnumName(SetMasterAuthRequest_Action_name, int32(x))
}
func (SetMasterAuthRequest_Action) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{12, 0}
}

// The current status of the node pool instance.
type NodePool_Status int32

const (
	// Not set.
	NodePool_STATUS_UNSPECIFIED NodePool_Status = 0
	// The PROVISIONING state indicates the node pool is being created.
	NodePool_PROVISIONING NodePool_Status = 1
	// The RUNNING state indicates the node pool has been created
	// and is fully usable.
	NodePool_RUNNING NodePool_Status = 2
	// The RUNNING_WITH_ERROR state indicates the node pool has been created
	// and is partially usable. Some error state has occurred and some
	// functionality may be impaired. Customer may need to reissue a request
	// or trigger a new update.
	NodePool_RUNNING_WITH_ERROR NodePool_Status = 3
	// The RECONCILING state indicates that some work is actively being done on
	// the node pool, such as upgrading node software. Details can
	// be found in the `statusMessage` field.
	NodePool_RECONCILING NodePool_Status = 4
	// The STOPPING state indicates the node pool is being deleted.
	NodePool_STOPPING NodePool_Status = 5
	// The ERROR state indicates the node pool may be unusable. Details
	// can be found in the `statusMessage` field.
	NodePool_ERROR NodePool_Status = 6
)

var NodePool_Status_name = map[int32]string{
	0: "STATUS_UNSPECIFIED",
	1: "PROVISIONING",
	2: "RUNNING",
	3: "RUNNING_WITH_ERROR",
	4: "RECONCILING",
	5: "STOPPING",
	6: "ERROR",
}
var NodePool_Status_value = map[string]int32{
	"STATUS_UNSPECIFIED": 0,
	"PROVISIONING":       1,
	"RUNNING":            2,
	"RUNNING_WITH_ERROR": 3,
	"RECONCILING":        4,
	"STOPPING":           5,
	"ERROR":              6,
}

func (x NodePool_Status) String() string {
	return proto.EnumName(NodePool_Status_name, int32(x))
}
func (NodePool_Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{26, 0} }

// Parameters that describe the nodes in a cluster.
type NodeConfig struct {
	// The name of a Google Compute Engine [machine
	// type](/compute/docs/machine-types) (e.g.
	// `n1-standard-1`).
	//
	// If unspecified, the default machine type is
	// `n1-standard-1`.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType" json:"machine_type,omitempty"`
	// Size of the disk attached to each node, specified in GB.
	// The smallest allowed disk size is 10GB.
	//
	// If unspecified, the default disk size is 100GB.
	DiskSizeGb int32 `protobuf:"varint,2,opt,name=disk_size_gb,json=diskSizeGb" json:"disk_size_gb,omitempty"`
	// The set of Google API scopes to be made available on all of the
	// node VMs under the "default" service account.
	//
	// The following scopes are recommended, but not required, and by default are
	// not included:
	//
	// * `https://www.googleapis.com/auth/compute` is required for mounting
	// persistent storage on your nodes.
	// * `https://www.googleapis.com/auth/devstorage.read_only` is required for
	// communicating with **gcr.io**
	// (the [Google Container Registry](/container-registry/)).
	//
	// If unspecified, no scopes are added, unless Cloud Logging or Cloud
	// Monitoring are enabled, in which case their required scopes will be added.
	OauthScopes []string `protobuf:"bytes,3,rep,name=oauth_scopes,json=oauthScopes" json:"oauth_scopes,omitempty"`
	// The Google Cloud Platform Service Account to be used by the node VMs. If
	// no Service Account is specified, the "default" service account is used.
	ServiceAccount string `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount" json:"service_account,omitempty"`
	// The metadata key/value pairs assigned to instances in the cluster.
	//
	// Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less than 128 bytes
	// in length. These are reflected as part of a URL in the metadata server.
	// Additionally, to avoid ambiguity, keys must not conflict with any other
	// metadata keys for the project or be one of the four reserved keys:
	// "instance-template", "kube-env", "startup-script", and "user-data"
	//
	// Values are free-form strings, and only have meaning as interpreted by
	// the image running in the instance. The only restriction placed on them is
	// that each value's size must be less than or equal to 32 KB.
	//
	// The total size of all keys and values must be less than 512 KB.
	Metadata map[string]string `protobuf:"bytes,4,rep,name=metadata" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The image type to use for this node. Note that for a given image type,
	// the latest version of it will be used.
	ImageType string `protobuf:"bytes,5,opt,name=image_type,json=imageType" json:"image_type,omitempty"`
	// The map of Kubernetes labels (key/value pairs) to be applied to each node.
	// These will added in addition to any default label(s) that
	// Kubernetes may apply to the node.
	// In case of conflict in label keys, the applied set may differ depending on
	// the Kubernetes version -- it's best to assume the behavior is undefined
	// and conflicts should be avoided.
	// For more information, including usage and the valid values, see:
	// http://kubernetes.io/v1.1/docs/user-guide/labels.html
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The number of local SSD disks to be attached to the node.
	//
	// The limit for this value is dependant upon the maximum number of
	// disks available on a machine per zone. See:
	// https://cloud.google.com/compute/docs/disks/local-ssd#local_ssd_limits
	// for more information.
	LocalSsdCount int32 `protobuf:"varint,7,opt,name=local_ssd_count,json=localSsdCount" json:"local_ssd_count,omitempty"`
	// The list of instance tags applied to all nodes. Tags are used to identify
	// valid sources or targets for network firewalls and are specified by
	// the client during cluster or node pool creation. Each tag within the list
	// must comply with RFC1035.
	Tags []string `protobuf:"bytes,8,rep,name=tags" json:"tags,omitempty"`
	// Whether the nodes are created as preemptible VM instances. See:
	// https://cloud.google.com/compute/docs/instances/preemptible for more
	// information about preemptible VM instances.
	Preemptible bool `protobuf:"varint,10,opt,name=preemptible" json:"preemptible,omitempty"`
}

func (m *NodeConfig) Reset()                    { *m = NodeConfig{} }
func (m *NodeConfig) String() string            { return proto.CompactTextString(m) }
func (*NodeConfig) ProtoMessage()               {}
func (*NodeConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *NodeConfig) GetMachineType() string {
	if m != nil {
		return m.MachineType
	}
	return ""
}

func (m *NodeConfig) GetDiskSizeGb() int32 {
	if m != nil {
		return m.DiskSizeGb
	}
	return 0
}

func (m *NodeConfig) GetOauthScopes() []string {
	if m != nil {
		return m.OauthScopes
	}
	return nil
}

func (m *NodeConfig) GetServiceAccount() string {
	if m != nil {
		return m.ServiceAccount
	}
	return ""
}

func (m *NodeConfig) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *NodeConfig) GetImageType() string {
	if m != nil {
		return m.ImageType
	}
	return ""
}

func (m *NodeConfig) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *NodeConfig) GetLocalSsdCount() int32 {
	if m != nil {
		return m.LocalSsdCount
	}
	return 0
}

func (m *NodeConfig) GetTags() []string {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *NodeConfig) GetPreemptible() bool {
	if m != nil {
		return m.Preemptible
	}
	return false
}

// The authentication information for accessing the master endpoint.
// Authentication can be done using HTTP basic auth or using client
// certificates.
type MasterAuth struct {
	// The username to use for HTTP basic authentication to the master endpoint.
	// For clusters v1.6.0 and later, you can disable basic authentication by
	// providing an empty username.
	Username string `protobuf:"bytes,1,opt,name=username" json:"username,omitempty"`
	// The password to use for HTTP basic authentication to the master endpoint.
	// Because the master endpoint is open to the Internet, you should create a
	// strong password.  If a password is provided for cluster creation, username
	// must be non-empty.
	Password string `protobuf:"bytes,2,opt,name=password" json:"password,omitempty"`
	// [Output only] Base64-encoded public certificate that is the root of
	// trust for the cluster.
	ClusterCaCertificate string `protobuf:"bytes,100,opt,name=cluster_ca_certificate,json=clusterCaCertificate" json:"cluster_ca_certificate,omitempty"`
	// [Output only] Base64-encoded public certificate used by clients to
	// authenticate to the cluster endpoint.
	ClientCertificate string `protobuf:"bytes,101,opt,name=client_certificate,json=clientCertificate" json:"client_certificate,omitempty"`
	// [Output only] Base64-encoded private key used by clients to authenticate
	// to the cluster endpoint.
	ClientKey string `protobuf:"bytes,102,opt,name=client_key,json=clientKey" json:"client_key,omitempty"`
}

func (m *MasterAuth) Reset()                    { *m = MasterAuth{} }
func (m *MasterAuth) String() string            { return proto.CompactTextString(m) }
func (*MasterAuth) ProtoMessage()               {}
func (*MasterAuth) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *MasterAuth) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *MasterAuth) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

func (m *MasterAuth) GetClusterCaCertificate() string {
	if m != nil {
		return m.ClusterCaCertificate
	}
	return ""
}

func (m *MasterAuth) GetClientCertificate() string {
	if m != nil {
		return m.ClientCertificate
	}
	return ""
}

func (m *MasterAuth) GetClientKey() string {
	if m != nil {
		return m.ClientKey
	}
	return ""
}

// Configuration for the addons that can be automatically spun up in the
// cluster, enabling additional functionality.
type AddonsConfig struct {
	// Configuration for the HTTP (L7) load balancing controller addon, which
	// makes it easy to set up HTTP load balancers for services in a cluster.
	HttpLoadBalancing *HttpLoadBalancing `protobuf:"bytes,1,opt,name=http_load_balancing,json=httpLoadBalancing" json:"http_load_balancing,omitempty"`
	// Configuration for the horizontal pod autoscaling feature, which
	// increases or decreases the number of replica pods a replication controller
	// has based on the resource usage of the existing pods.
	HorizontalPodAutoscaling *HorizontalPodAutoscaling `protobuf:"bytes,2,opt,name=horizontal_pod_autoscaling,json=horizontalPodAutoscaling" json:"horizontal_pod_autoscaling,omitempty"`
}

func (m *AddonsConfig) Reset()                    { *m = AddonsConfig{} }
func (m *AddonsConfig) String() string            { return proto.CompactTextString(m) }
func (*AddonsConfig) ProtoMessage()               {}
func (*AddonsConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *AddonsConfig) GetHttpLoadBalancing() *HttpLoadBalancing {
	if m != nil {
		return m.HttpLoadBalancing
	}
	return nil
}

func (m *AddonsConfig) GetHorizontalPodAutoscaling() *HorizontalPodAutoscaling {
	if m != nil {
		return m.HorizontalPodAutoscaling
	}
	return nil
}

// Configuration options for the HTTP (L7) load balancing controller addon,
// which makes it easy to set up HTTP load balancers for services in a cluster.
type HttpLoadBalancing struct {
	// Whether the HTTP Load Balancing controller is enabled in the cluster.
	// When enabled, it runs a small pod in the cluster that manages the load
	// balancers.
	Disabled bool `protobuf:"varint,1,opt,name=disabled" json:"disabled,omitempty"`
}

func (m *HttpLoadBalancing) Reset()                    { *m = HttpLoadBalancing{} }
func (m *HttpLoadBalancing) String() string            { return proto.CompactTextString(m) }
func (*HttpLoadBalancing) ProtoMessage()               {}
func (*HttpLoadBalancing) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *HttpLoadBalancing) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration options for the horizontal pod autoscaling feature, which
// increases or decreases the number of replica pods a replication controller
// has based on the resource usage of the existing pods.
type HorizontalPodAutoscaling struct {
	// Whether the Horizontal Pod Autoscaling feature is enabled in the cluster.
	// When enabled, it ensures that a Heapster pod is running in the cluster,
	// which is also used by the Cloud Monitoring service.
	Disabled bool `protobuf:"varint,1,opt,name=disabled" json:"disabled,omitempty"`
}

func (m *HorizontalPodAutoscaling) Reset()                    { *m = HorizontalPodAutoscaling{} }
func (m *HorizontalPodAutoscaling) String() string            { return proto.CompactTextString(m) }
func (*HorizontalPodAutoscaling) ProtoMessage()               {}
func (*HorizontalPodAutoscaling) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *HorizontalPodAutoscaling) GetDisabled() bool {
	if m != nil {
		return m.Disabled
	}
	return false
}

// Configuration for the legacy Attribute Based Access Control authorization
// mode.
type LegacyAbac struct {
	// Whether the ABAC authorizer is enabled for this cluster. When enabled,
	// identities in the system, including service accounts, nodes, and
	// controllers, will have statically granted permissions beyond those
	// provided by the RBAC configuration or IAM.
	Enabled bool `protobuf:"varint,1,opt,name=enabled" json:"enabled,omitempty"`
}

func (m *LegacyAbac) Reset()                    { *m = LegacyAbac{} }
func (m *LegacyAbac) String() string            { return proto.CompactTextString(m) }
func (*LegacyAbac) ProtoMessage()               {}
func (*LegacyAbac) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *LegacyAbac) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// A Google Container Engine cluster.
type Cluster struct {
	// The name of this cluster. The name must be unique within this project
	// and zone, and can be up to 40 characters with the following restrictions:
	//
	// * Lowercase letters, numbers, and hyphens only.
	// * Must start with a letter.
	// * Must end with a number or a letter.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// An optional description of this cluster.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// The number of nodes to create in this cluster. You must ensure that your
	// Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "node_config") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount" json:"initial_node_count,omitempty"`
	// Parameters used in creating the cluster's nodes.
	// See `nodeConfig` for the description of its properties.
	// For requests, this field should only be used in lieu of a
	// "node_pool" object, since this configuration (along with the
	// "initial_node_count") will be used to create a "NodePool" object with an
	// auto-generated name. Do not use this and a node_pool at the same time.
	// For responses, this field will be populated with the node configuration of
	// the first node pool.
	//
	// If unspecified, the defaults are used.
	NodeConfig *NodeConfig `protobuf:"bytes,4,opt,name=node_config,json=nodeConfig" json:"node_config,omitempty"`
	// The authentication information for accessing the master endpoint.
	MasterAuth *MasterAuth `protobuf:"bytes,5,opt,name=master_auth,json=masterAuth" json:"master_auth,omitempty"`
	// The logging service the cluster should use to write logs.
	// Currently available options:
	//
	// * `logging.googleapis.com` - the Google Cloud Logging service.
	// * `none` - no logs will be exported from the cluster.
	// * if left as an empty string,`logging.googleapis.com` will be used.
	LoggingService string `protobuf:"bytes,6,opt,name=logging_service,json=loggingService" json:"logging_service,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * `monitoring.googleapis.com` - the Google Cloud Monitoring service.
	// * `none` - no metrics will be exported from the cluster.
	// * if left as an empty string, `monitoring.googleapis.com` will be used.
	MonitoringService string `protobuf:"bytes,7,opt,name=monitoring_service,json=monitoringService" json:"monitoring_service,omitempty"`
	// The name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// cluster is connected. If left unspecified, the `default` network
	// will be used.
	Network string `protobuf:"bytes,8,opt,name=network" json:"network,omitempty"`
	// The IP address range of the container pods in this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `10.96.0.0/14`). Leave blank to have
	// one automatically chosen or specify a `/14` block in `10.0.0.0/8`.
	ClusterIpv4Cidr string `protobuf:"bytes,9,opt,name=cluster_ipv4_cidr,json=clusterIpv4Cidr" json:"cluster_ipv4_cidr,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	AddonsConfig *AddonsConfig `protobuf:"bytes,10,opt,name=addons_config,json=addonsConfig" json:"addons_config,omitempty"`
	// The name of the Google Compute Engine
	// [subnetwork](/compute/docs/subnetworks) to which the
	// cluster is connected.
	Subnetwork string `protobuf:"bytes,11,opt,name=subnetwork" json:"subnetwork,omitempty"`
	// The node pools associated with this cluster.
	// This field should not be set if "node_config" or "initial_node_count" are
	// specified.
	NodePools []*NodePool `protobuf:"bytes,12,rep,name=node_pools,json=nodePools" json:"node_pools,omitempty"`
	// The list of Google Compute Engine
	// [locations](/compute/docs/zones#available) in which the cluster's nodes
	// should be located.
	Locations []string `protobuf:"bytes,13,rep,name=locations" json:"locations,omitempty"`
	// Kubernetes alpha features are enabled on this cluster. This includes alpha
	// API groups (e.g. v1alpha1) and features that may not be production ready in
	// the kubernetes version of the master and nodes.
	// The cluster has no SLA for uptime and master/node upgrades are disabled.
	// Alpha enabled clusters are automatically deleted thirty days after
	// creation.
	EnableKubernetesAlpha bool `protobuf:"varint,14,opt,name=enable_kubernetes_alpha,json=enableKubernetesAlpha" json:"enable_kubernetes_alpha,omitempty"`
	// The resource labels for the cluster to use to annotate any related
	// Google Compute Engine resources.
	ResourceLabels map[string]string `protobuf:"bytes,15,rep,name=resource_labels,json=resourceLabels" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The fingerprint of the set of labels for this cluster.
	LabelFingerprint string `protobuf:"bytes,16,opt,name=label_fingerprint,json=labelFingerprint" json:"label_fingerprint,omitempty"`
	// Configuration for the legacy ABAC authorization mode.
	LegacyAbac *LegacyAbac `protobuf:"bytes,18,opt,name=legacy_abac,json=legacyAbac" json:"legacy_abac,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink" json:"self_link,omitempty"`
	// [Output only] The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,101,opt,name=zone" json:"zone,omitempty"`
	// [Output only] The IP address of this cluster's master endpoint.
	// The endpoint can be accessed from the internet at
	// `https://username:password@endpoint/`.
	//
	// See the `masterAuth` property of this resource for username and
	// password information.
	Endpoint string `protobuf:"bytes,102,opt,name=endpoint" json:"endpoint,omitempty"`
	// The initial Kubernetes version for this cluster.  Valid versions are those
	// found in validMasterVersions returned by getServerConfig.  The version can
	// be upgraded over time; such upgrades are reflected in
	// currentMasterVersion and currentNodeVersion.
	InitialClusterVersion string `protobuf:"bytes,103,opt,name=initial_cluster_version,json=initialClusterVersion" json:"initial_cluster_version,omitempty"`
	// [Output only] The current software version of the master endpoint.
	CurrentMasterVersion string `protobuf:"bytes,104,opt,name=current_master_version,json=currentMasterVersion" json:"current_master_version,omitempty"`
	// [Output only] The current version of the node software components.
	// If they are currently at multiple versions because they're in the process
	// of being upgraded, this reflects the minimum version of all nodes.
	CurrentNodeVersion string `protobuf:"bytes,105,opt,name=current_node_version,json=currentNodeVersion" json:"current_node_version,omitempty"`
	// [Output only] The time the cluster was created, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	CreateTime string `protobuf:"bytes,106,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// [Output only] The current status of this cluster.
	Status Cluster_Status `protobuf:"varint,107,opt,name=status,enum=google.container.v1.Cluster_Status" json:"status,omitempty"`
	// [Output only] Additional information about the current status of this
	// cluster, if available.
	StatusMessage string `protobuf:"bytes,108,opt,name=status_message,json=statusMessage" json:"status_message,omitempty"`
	// [Output only] The size of the address space on each node for hosting
	// containers. This is provisioned from within the `container_ipv4_cidr`
	// range.
	NodeIpv4CidrSize int32 `protobuf:"varint,109,opt,name=node_ipv4_cidr_size,json=nodeIpv4CidrSize" json:"node_ipv4_cidr_size,omitempty"`
	// [Output only] The IP address range of the Kubernetes services in
	// this cluster, in
	// [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
	// notation (e.g. `1.2.3.4/29`). Service addresses are
	// typically put in the last `/16` from the container CIDR.
	ServicesIpv4Cidr string `protobuf:"bytes,110,opt,name=services_ipv4_cidr,json=servicesIpv4Cidr" json:"services_ipv4_cidr,omitempty"`
	// [Output only] The resource URLs of [instance
	// groups](/compute/docs/instance-groups/) associated with this
	// cluster.
	InstanceGroupUrls []string `protobuf:"bytes,111,rep,name=instance_group_urls,json=instanceGroupUrls" json:"instance_group_urls,omitempty"`
	// [Output only] The number of nodes currently in the cluster.
	CurrentNodeCount int32 `protobuf:"varint,112,opt,name=current_node_count,json=currentNodeCount" json:"current_node_count,omitempty"`
	// [Output only] The time the cluster will be automatically
	// deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	ExpireTime string `protobuf:"bytes,113,opt,name=expire_time,json=expireTime" json:"expire_time,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Cluster) GetInitialNodeCount() int32 {
	if m != nil {
		return m.InitialNodeCount
	}
	return 0
}

func (m *Cluster) GetNodeConfig() *NodeConfig {
	if m != nil {
		return m.NodeConfig
	}
	return nil
}

func (m *Cluster) GetMasterAuth() *MasterAuth {
	if m != nil {
		return m.MasterAuth
	}
	return nil
}

func (m *Cluster) GetLoggingService() string {
	if m != nil {
		return m.LoggingService
	}
	return ""
}

func (m *Cluster) GetMonitoringService() string {
	if m != nil {
		return m.MonitoringService
	}
	return ""
}

func (m *Cluster) GetNetwork() string {
	if m != nil {
		return m.Network
	}
	return ""
}

func (m *Cluster) GetClusterIpv4Cidr() string {
	if m != nil {
		return m.ClusterIpv4Cidr
	}
	return ""
}

func (m *Cluster) GetAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.AddonsConfig
	}
	return nil
}

func (m *Cluster) GetSubnetwork() string {
	if m != nil {
		return m.Subnetwork
	}
	return ""
}

func (m *Cluster) GetNodePools() []*NodePool {
	if m != nil {
		return m.NodePools
	}
	return nil
}

func (m *Cluster) GetLocations() []string {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *Cluster) GetEnableKubernetesAlpha() bool {
	if m != nil {
		return m.EnableKubernetesAlpha
	}
	return false
}

func (m *Cluster) GetResourceLabels() map[string]string {
	if m != nil {
		return m.ResourceLabels
	}
	return nil
}

func (m *Cluster) GetLabelFingerprint() string {
	if m != nil {
		return m.LabelFingerprint
	}
	return ""
}

func (m *Cluster) GetLegacyAbac() *LegacyAbac {
	if m != nil {
		return m.LegacyAbac
	}
	return nil
}

func (m *Cluster) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

func (m *Cluster) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Cluster) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Cluster) GetInitialClusterVersion() string {
	if m != nil {
		return m.InitialClusterVersion
	}
	return ""
}

func (m *Cluster) GetCurrentMasterVersion() string {
	if m != nil {
		return m.CurrentMasterVersion
	}
	return ""
}

func (m *Cluster) GetCurrentNodeVersion() string {
	if m != nil {
		return m.CurrentNodeVersion
	}
	return ""
}

func (m *Cluster) GetCreateTime() string {
	if m != nil {
		return m.CreateTime
	}
	return ""
}

func (m *Cluster) GetStatus() Cluster_Status {
	if m != nil {
		return m.Status
	}
	return Cluster_STATUS_UNSPECIFIED
}

func (m *Cluster) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Cluster) GetNodeIpv4CidrSize() int32 {
	if m != nil {
		return m.NodeIpv4CidrSize
	}
	return 0
}

func (m *Cluster) GetServicesIpv4Cidr() string {
	if m != nil {
		return m.ServicesIpv4Cidr
	}
	return ""
}

func (m *Cluster) GetInstanceGroupUrls() []string {
	if m != nil {
		return m.InstanceGroupUrls
	}
	return nil
}

func (m *Cluster) GetCurrentNodeCount() int32 {
	if m != nil {
		return m.CurrentNodeCount
	}
	return 0
}

func (m *Cluster) GetExpireTime() string {
	if m != nil {
		return m.ExpireTime
	}
	return ""
}

// ClusterUpdate describes an update to the cluster. Exactly one update can
// be applied to a cluster with each request, so at most one field can be
// provided.
type ClusterUpdate struct {
	// The Kubernetes version to change the nodes to (typically an
	// upgrade). Use `-` to upgrade to the latest version supported by
	// the server.
	DesiredNodeVersion string `protobuf:"bytes,4,opt,name=desired_node_version,json=desiredNodeVersion" json:"desired_node_version,omitempty"`
	// The monitoring service the cluster should use to write metrics.
	// Currently available options:
	//
	// * "monitoring.googleapis.com" - the Google Cloud Monitoring service
	// * "none" - no metrics will be exported from the cluster
	DesiredMonitoringService string `protobuf:"bytes,5,opt,name=desired_monitoring_service,json=desiredMonitoringService" json:"desired_monitoring_service,omitempty"`
	// Configurations for the various addons available to run in the cluster.
	DesiredAddonsConfig *AddonsConfig `protobuf:"bytes,6,opt,name=desired_addons_config,json=desiredAddonsConfig" json:"desired_addons_config,omitempty"`
	// The node pool to be upgraded. This field is mandatory if
	// "desired_node_version", "desired_image_family" or
	// "desired_node_pool_autoscaling" is specified and there is more than one
	// node pool on the cluster.
	DesiredNodePoolId string `protobuf:"bytes,7,opt,name=desired_node_pool_id,json=desiredNodePoolId" json:"desired_node_pool_id,omitempty"`
	// The desired image type for the node pool.
	// NOTE: Set the "desired_node_pool" field as well.
	DesiredImageType string `protobuf:"bytes,8,opt,name=desired_image_type,json=desiredImageType" json:"desired_image_type,omitempty"`
	// Autoscaler configuration for the node pool specified in
	// desired_node_pool_id. If there is only one pool in the
	// cluster and desired_node_pool_id is not provided then
	// the change applies to that single node pool.
	DesiredNodePoolAutoscaling *NodePoolAutoscaling `protobuf:"bytes,9,opt,name=desired_node_pool_autoscaling,json=desiredNodePoolAutoscaling" json:"desired_node_pool_autoscaling,omitempty"`
	// The desired list of Google Compute Engine
	// [locations](/compute/docs/zones#available) in which the cluster's nodes
	// should be located. Changing the locations a cluster is in will result
	// in nodes being either created or removed from the cluster, depending on
	// whether locations are being added or removed.
	//
	// This list must always include the cluster's primary zone.
	DesiredLocations []string `protobuf:"bytes,10,rep,name=desired_locations,json=desiredLocations" json:"desired_locations,omitempty"`
	// The Kubernetes version to change the master to. The only valid value is the
	// latest supported version. Use "-" to have the server automatically select
	// the latest version.
	DesiredMasterVersion string `protobuf:"bytes,100,opt,name=desired_master_version,json=desiredMasterVersion" json:"desired_master_version,omitempty"`
}

func (m *ClusterUpdate) Reset()                    { *m = ClusterUpdate{} }
func (m *ClusterUpdate) String() string            { return proto.CompactTextString(m) }
func (*ClusterUpdate) ProtoMessage()               {}
func (*ClusterUpdate) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ClusterUpdate) GetDesiredNodeVersion() string {
	if m != nil {
		return m.DesiredNodeVersion
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredMonitoringService() string {
	if m != nil {
		return m.DesiredMonitoringService
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredAddonsConfig() *AddonsConfig {
	if m != nil {
		return m.DesiredAddonsConfig
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredNodePoolId() string {
	if m != nil {
		return m.DesiredNodePoolId
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredImageType() string {
	if m != nil {
		return m.DesiredImageType
	}
	return ""
}

func (m *ClusterUpdate) GetDesiredNodePoolAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.DesiredNodePoolAutoscaling
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredLocations() []string {
	if m != nil {
		return m.DesiredLocations
	}
	return nil
}

func (m *ClusterUpdate) GetDesiredMasterVersion() string {
	if m != nil {
		return m.DesiredMasterVersion
	}
	return ""
}

// This operation resource represents operations that may have happened or are
// happening on the cluster. All fields are output only.
type Operation struct {
	// The server-assigned ID for the operation.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the operation
	// is taking place.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The operation type.
	OperationType Operation_Type `protobuf:"varint,3,opt,name=operation_type,json=operationType,enum=google.container.v1.Operation_Type" json:"operation_type,omitempty"`
	// The current status of the operation.
	Status Operation_Status `protobuf:"varint,4,opt,name=status,enum=google.container.v1.Operation_Status" json:"status,omitempty"`
	// Detailed operation progress, if available.
	Detail string `protobuf:"bytes,8,opt,name=detail" json:"detail,omitempty"`
	// If an error has occurred, a textual description of the error.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage" json:"status_message,omitempty"`
	// Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,6,opt,name=self_link,json=selfLink" json:"self_link,omitempty"`
	// Server-defined URL for the target of the operation.
	TargetLink string `protobuf:"bytes,7,opt,name=target_link,json=targetLink" json:"target_link,omitempty"`
}

func (m *Operation) Reset()                    { *m = Operation{} }
func (m *Operation) String() string            { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()               {}
func (*Operation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Operation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Operation) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Operation) GetOperationType() Operation_Type {
	if m != nil {
		return m.OperationType
	}
	return Operation_TYPE_UNSPECIFIED
}

func (m *Operation) GetStatus() Operation_Status {
	if m != nil {
		return m.Status
	}
	return Operation_STATUS_UNSPECIFIED
}

func (m *Operation) GetDetail() string {
	if m != nil {
		return m.Detail
	}
	return ""
}

func (m *Operation) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Operation) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

func (m *Operation) GetTargetLink() string {
	if m != nil {
		return m.TargetLink
	}
	return ""
}

// CreateClusterRequest creates a cluster.
type CreateClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// A [cluster
	// resource](/container-engine/reference/rest/v1/projects.zones.clusters)
	Cluster *Cluster `protobuf:"bytes,3,opt,name=cluster" json:"cluster,omitempty"`
}

func (m *CreateClusterRequest) Reset()                    { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()               {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *CreateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

// GetClusterRequest gets the settings of a cluster.
type GetClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to retrieve.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
}

func (m *GetClusterRequest) Reset()                    { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()               {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *GetClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *GetClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// UpdateClusterRequest updates the settings of a cluster.
type UpdateClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// A description of the update.
	Update *ClusterUpdate `protobuf:"bytes,4,opt,name=update" json:"update,omitempty"`
}

func (m *UpdateClusterRequest) Reset()                    { *m = UpdateClusterRequest{} }
func (m *UpdateClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateClusterRequest) ProtoMessage()               {}
func (*UpdateClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *UpdateClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *UpdateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *UpdateClusterRequest) GetUpdate() *ClusterUpdate {
	if m != nil {
		return m.Update
	}
	return nil
}

// SetMasterAuthRequest updates the admin password of a cluster.
type SetMasterAuthRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to upgrade.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The exact form of action to be taken on the master auth
	Action SetMasterAuthRequest_Action `protobuf:"varint,4,opt,name=action,enum=google.container.v1.SetMasterAuthRequest_Action" json:"action,omitempty"`
	// A description of the update.
	Update *MasterAuth `protobuf:"bytes,5,opt,name=update" json:"update,omitempty"`
}

func (m *SetMasterAuthRequest) Reset()                    { *m = SetMasterAuthRequest{} }
func (m *SetMasterAuthRequest) String() string            { return proto.CompactTextString(m) }
func (*SetMasterAuthRequest) ProtoMessage()               {}
func (*SetMasterAuthRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *SetMasterAuthRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetMasterAuthRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetMasterAuthRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetMasterAuthRequest) GetAction() SetMasterAuthRequest_Action {
	if m != nil {
		return m.Action
	}
	return SetMasterAuthRequest_UNKNOWN
}

func (m *SetMasterAuthRequest) GetUpdate() *MasterAuth {
	if m != nil {
		return m.Update
	}
	return nil
}

// DeleteClusterRequest deletes a cluster.
type DeleteClusterRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to delete.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
}

func (m *DeleteClusterRequest) Reset()                    { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()               {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *DeleteClusterRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteClusterRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *DeleteClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// ListClustersRequest lists clusters.
type ListClustersRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides, or "-" for all zones.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
}

func (m *ListClustersRequest) Reset()                    { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string            { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()               {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ListClustersRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListClustersRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// ListClustersResponse is the result of ListClustersRequest.
type ListClustersResponse struct {
	// A list of clusters in the project in the specified zone, or
	// across all ones.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters" json:"clusters,omitempty"`
	// If any zones are listed here, the list of clusters returned
	// may be missing those zones.
	MissingZones []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones" json:"missing_zones,omitempty"`
}

func (m *ListClustersResponse) Reset()                    { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string            { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()               {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetMissingZones() []string {
	if m != nil {
		return m.MissingZones
	}
	return nil
}

// GetOperationRequest gets a single operation.
type GetOperationRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The server-assigned `name` of the operation.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
}

func (m *GetOperationRequest) Reset()                    { *m = GetOperationRequest{} }
func (m *GetOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*GetOperationRequest) ProtoMessage()               {}
func (*GetOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *GetOperationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetOperationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *GetOperationRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

// ListOperationsRequest lists operations.
type ListOperationsRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine [zone](/compute/docs/zones#available)
	// to return operations for, or `-` for all zones.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
}

func (m *ListOperationsRequest) Reset()                    { *m = ListOperationsRequest{} }
func (m *ListOperationsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListOperationsRequest) ProtoMessage()               {}
func (*ListOperationsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *ListOperationsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListOperationsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// CancelOperationRequest cancels a single operation.
type CancelOperationRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the operation resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The server-assigned `name` of the operation.
	OperationId string `protobuf:"bytes,3,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
}

func (m *CancelOperationRequest) Reset()                    { *m = CancelOperationRequest{} }
func (m *CancelOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelOperationRequest) ProtoMessage()               {}
func (*CancelOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *CancelOperationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CancelOperationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CancelOperationRequest) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

// ListOperationsResponse is the result of ListOperationsRequest.
type ListOperationsResponse struct {
	// A list of operations in the project in the specified zone.
	Operations []*Operation `protobuf:"bytes,1,rep,name=operations" json:"operations,omitempty"`
	// If any zones are listed here, the list of operations returned
	// may be missing the operations from those zones.
	MissingZones []string `protobuf:"bytes,2,rep,name=missing_zones,json=missingZones" json:"missing_zones,omitempty"`
}

func (m *ListOperationsResponse) Reset()                    { *m = ListOperationsResponse{} }
func (m *ListOperationsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListOperationsResponse) ProtoMessage()               {}
func (*ListOperationsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *ListOperationsResponse) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ListOperationsResponse) GetMissingZones() []string {
	if m != nil {
		return m.MissingZones
	}
	return nil
}

// Gets the current Container Engine service configuration.
type GetServerConfigRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine [zone](/compute/docs/zones#available)
	// to return operations for.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
}

func (m *GetServerConfigRequest) Reset()                    { *m = GetServerConfigRequest{} }
func (m *GetServerConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServerConfigRequest) ProtoMessage()               {}
func (*GetServerConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *GetServerConfigRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetServerConfigRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

// Container Engine service configuration.
type ServerConfig struct {
	// Version of Kubernetes the service deploys by default.
	DefaultClusterVersion string `protobuf:"bytes,1,opt,name=default_cluster_version,json=defaultClusterVersion" json:"default_cluster_version,omitempty"`
	// List of valid node upgrade target versions.
	ValidNodeVersions []string `protobuf:"bytes,3,rep,name=valid_node_versions,json=validNodeVersions" json:"valid_node_versions,omitempty"`
	// Default image type.
	DefaultImageType string `protobuf:"bytes,4,opt,name=default_image_type,json=defaultImageType" json:"default_image_type,omitempty"`
	// List of valid image types.
	ValidImageTypes []string `protobuf:"bytes,5,rep,name=valid_image_types,json=validImageTypes" json:"valid_image_types,omitempty"`
	// List of valid master versions.
	ValidMasterVersions []string `protobuf:"bytes,6,rep,name=valid_master_versions,json=validMasterVersions" json:"valid_master_versions,omitempty"`
}

func (m *ServerConfig) Reset()                    { *m = ServerConfig{} }
func (m *ServerConfig) String() string            { return proto.CompactTextString(m) }
func (*ServerConfig) ProtoMessage()               {}
func (*ServerConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *ServerConfig) GetDefaultClusterVersion() string {
	if m != nil {
		return m.DefaultClusterVersion
	}
	return ""
}

func (m *ServerConfig) GetValidNodeVersions() []string {
	if m != nil {
		return m.ValidNodeVersions
	}
	return nil
}

func (m *ServerConfig) GetDefaultImageType() string {
	if m != nil {
		return m.DefaultImageType
	}
	return ""
}

func (m *ServerConfig) GetValidImageTypes() []string {
	if m != nil {
		return m.ValidImageTypes
	}
	return nil
}

func (m *ServerConfig) GetValidMasterVersions() []string {
	if m != nil {
		return m.ValidMasterVersions
	}
	return nil
}

// CreateNodePoolRequest creates a node pool for a cluster.
type CreateNodePoolRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The node pool to create.
	NodePool *NodePool `protobuf:"bytes,4,opt,name=node_pool,json=nodePool" json:"node_pool,omitempty"`
}

func (m *CreateNodePoolRequest) Reset()                    { *m = CreateNodePoolRequest{} }
func (m *CreateNodePoolRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateNodePoolRequest) ProtoMessage()               {}
func (*CreateNodePoolRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *CreateNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CreateNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CreateNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateNodePoolRequest) GetNodePool() *NodePool {
	if m != nil {
		return m.NodePool
	}
	return nil
}

// DeleteNodePoolRequest deletes a node pool for a cluster.
type DeleteNodePoolRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool to delete.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
}

func (m *DeleteNodePoolRequest) Reset()                    { *m = DeleteNodePoolRequest{} }
func (m *DeleteNodePoolRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteNodePoolRequest) ProtoMessage()               {}
func (*DeleteNodePoolRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *DeleteNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *DeleteNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *DeleteNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

// ListNodePoolsRequest lists the node pool(s) for a cluster.
type ListNodePoolsRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
}

func (m *ListNodePoolsRequest) Reset()                    { *m = ListNodePoolsRequest{} }
func (m *ListNodePoolsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListNodePoolsRequest) ProtoMessage()               {}
func (*ListNodePoolsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *ListNodePoolsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListNodePoolsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ListNodePoolsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// GetNodePoolRequest retrieves a node pool for a cluster.
type GetNodePoolRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
}

func (m *GetNodePoolRequest) Reset()                    { *m = GetNodePoolRequest{} }
func (m *GetNodePoolRequest) String() string            { return proto.CompactTextString(m) }
func (*GetNodePoolRequest) ProtoMessage()               {}
func (*GetNodePoolRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *GetNodePoolRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetNodePoolRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *GetNodePoolRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *GetNodePoolRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

// NodePool contains the name and configuration for a cluster's node pool.
// Node pools are a set of nodes (i.e. VM's), with a common configuration and
// specification, under the control of the cluster master. They may have a set
// of Kubernetes labels applied to them, which may be used to reference them
// during pod scheduling. They may also be resized up or down, to accommodate
// the workload.
type NodePool struct {
	// The name of the node pool.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The node configuration of the pool.
	Config *NodeConfig `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
	// The initial node count for the pool. You must ensure that your
	// Compute Engine <a href="/compute/docs/resource-quotas">resource quota</a>
	// is sufficient for this number of instances. You must also have available
	// firewall and routes quota.
	InitialNodeCount int32 `protobuf:"varint,3,opt,name=initial_node_count,json=initialNodeCount" json:"initial_node_count,omitempty"`
	// [Output only] Server-defined URL for the resource.
	SelfLink string `protobuf:"bytes,100,opt,name=self_link,json=selfLink" json:"self_link,omitempty"`
	// [Output only] The version of the Kubernetes of this node.
	Version string `protobuf:"bytes,101,opt,name=version" json:"version,omitempty"`
	// [Output only] The resource URLs of [instance
	// groups](/compute/docs/instance-groups/) associated with this
	// node pool.
	InstanceGroupUrls []string `protobuf:"bytes,102,rep,name=instance_group_urls,json=instanceGroupUrls" json:"instance_group_urls,omitempty"`
	// [Output only] The status of the nodes in this pool instance.
	Status NodePool_Status `protobuf:"varint,103,opt,name=status,enum=google.container.v1.NodePool_Status" json:"status,omitempty"`
	// [Output only] Additional information about the current status of this
	// node pool instance, if available.
	StatusMessage string `protobuf:"bytes,104,opt,name=status_message,json=statusMessage" json:"status_message,omitempty"`
	// Autoscaler configuration for this NodePool. Autoscaler is enabled
	// only if a valid configuration is present.
	Autoscaling *NodePoolAutoscaling `protobuf:"bytes,4,opt,name=autoscaling" json:"autoscaling,omitempty"`
	// NodeManagement configuration for this NodePool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management" json:"management,omitempty"`
}

func (m *NodePool) Reset()                    { *m = NodePool{} }
func (m *NodePool) String() string            { return proto.CompactTextString(m) }
func (*NodePool) ProtoMessage()               {}
func (*NodePool) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *NodePool) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NodePool) GetConfig() *NodeConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *NodePool) GetInitialNodeCount() int32 {
	if m != nil {
		return m.InitialNodeCount
	}
	return 0
}

func (m *NodePool) GetSelfLink() string {
	if m != nil {
		return m.SelfLink
	}
	return ""
}

func (m *NodePool) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *NodePool) GetInstanceGroupUrls() []string {
	if m != nil {
		return m.InstanceGroupUrls
	}
	return nil
}

func (m *NodePool) GetStatus() NodePool_Status {
	if m != nil {
		return m.Status
	}
	return NodePool_STATUS_UNSPECIFIED
}

func (m *NodePool) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *NodePool) GetAutoscaling() *NodePoolAutoscaling {
	if m != nil {
		return m.Autoscaling
	}
	return nil
}

func (m *NodePool) GetManagement() *NodeManagement {
	if m != nil {
		return m.Management
	}
	return nil
}

// NodeManagement defines the set of node management services turned on for the
// node pool.
type NodeManagement struct {
	// A flag that specifies whether node auto-upgrade is enabled for the node
	// pool. If enabled, node auto-upgrade helps keep the nodes in your node pool
	// up to date with the latest release version of Kubernetes.
	AutoUpgrade bool `protobuf:"varint,1,opt,name=auto_upgrade,json=autoUpgrade" json:"auto_upgrade,omitempty"`
	// A flag that specifies whether the node auto-repair is enabled for the node
	// pool. If enabled, the nodes in this node pool will be monitored and, if
	// they fail health checks too many times, an automatic repair action will be
	// triggered.
	AutoRepair bool `protobuf:"varint,2,opt,name=auto_repair,json=autoRepair" json:"auto_repair,omitempty"`
	// Specifies the Auto Upgrade knobs for the node pool.
	UpgradeOptions *AutoUpgradeOptions `protobuf:"bytes,10,opt,name=upgrade_options,json=upgradeOptions" json:"upgrade_options,omitempty"`
}

func (m *NodeManagement) Reset()                    { *m = NodeManagement{} }
func (m *NodeManagement) String() string            { return proto.CompactTextString(m) }
func (*NodeManagement) ProtoMessage()               {}
func (*NodeManagement) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *NodeManagement) GetAutoUpgrade() bool {
	if m != nil {
		return m.AutoUpgrade
	}
	return false
}

func (m *NodeManagement) GetAutoRepair() bool {
	if m != nil {
		return m.AutoRepair
	}
	return false
}

func (m *NodeManagement) GetUpgradeOptions() *AutoUpgradeOptions {
	if m != nil {
		return m.UpgradeOptions
	}
	return nil
}

// AutoUpgradeOptions defines the set of options for the user to control how
// the Auto Upgrades will proceed.
type AutoUpgradeOptions struct {
	// [Output only] This field is set when upgrades are about to commence
	// with the approximate start time for the upgrades, in
	// [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
	AutoUpgradeStartTime string `protobuf:"bytes,1,opt,name=auto_upgrade_start_time,json=autoUpgradeStartTime" json:"auto_upgrade_start_time,omitempty"`
	// [Output only] This field is set when upgrades are about to commence
	// with the description of the upgrade.
	Description string `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
}

func (m *AutoUpgradeOptions) Reset()                    { *m = AutoUpgradeOptions{} }
func (m *AutoUpgradeOptions) String() string            { return proto.CompactTextString(m) }
func (*AutoUpgradeOptions) ProtoMessage()               {}
func (*AutoUpgradeOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *AutoUpgradeOptions) GetAutoUpgradeStartTime() string {
	if m != nil {
		return m.AutoUpgradeStartTime
	}
	return ""
}

func (m *AutoUpgradeOptions) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// SetNodePoolManagementRequest sets the node management properties of a node
// pool.
type SetNodePoolManagementRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to update.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool to update.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
	// NodeManagement configuration for the node pool.
	Management *NodeManagement `protobuf:"bytes,5,opt,name=management" json:"management,omitempty"`
}

func (m *SetNodePoolManagementRequest) Reset()                    { *m = SetNodePoolManagementRequest{} }
func (m *SetNodePoolManagementRequest) String() string            { return proto.CompactTextString(m) }
func (*SetNodePoolManagementRequest) ProtoMessage()               {}
func (*SetNodePoolManagementRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *SetNodePoolManagementRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetNodePoolManagementRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetNodePoolManagementRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetNodePoolManagementRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

func (m *SetNodePoolManagementRequest) GetManagement() *NodeManagement {
	if m != nil {
		return m.Management
	}
	return nil
}

// RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or Failed
// NodePool upgrade. This will be an no-op if the last upgrade successfully
// completed.
type RollbackNodePoolUpgradeRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to rollback.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The name of the node pool to rollback.
	NodePoolId string `protobuf:"bytes,4,opt,name=node_pool_id,json=nodePoolId" json:"node_pool_id,omitempty"`
}

func (m *RollbackNodePoolUpgradeRequest) Reset()                    { *m = RollbackNodePoolUpgradeRequest{} }
func (m *RollbackNodePoolUpgradeRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackNodePoolUpgradeRequest) ProtoMessage()               {}
func (*RollbackNodePoolUpgradeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *RollbackNodePoolUpgradeRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *RollbackNodePoolUpgradeRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *RollbackNodePoolUpgradeRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *RollbackNodePoolUpgradeRequest) GetNodePoolId() string {
	if m != nil {
		return m.NodePoolId
	}
	return ""
}

// ListNodePoolsResponse is the result of ListNodePoolsRequest.
type ListNodePoolsResponse struct {
	// A list of node pools for a cluster.
	NodePools []*NodePool `protobuf:"bytes,1,rep,name=node_pools,json=nodePools" json:"node_pools,omitempty"`
}

func (m *ListNodePoolsResponse) Reset()                    { *m = ListNodePoolsResponse{} }
func (m *ListNodePoolsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListNodePoolsResponse) ProtoMessage()               {}
func (*ListNodePoolsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *ListNodePoolsResponse) GetNodePools() []*NodePool {
	if m != nil {
		return m.NodePools
	}
	return nil
}

// NodePoolAutoscaling contains information required by cluster autoscaler to
// adjust the size of the node pool to the current cluster usage.
type NodePoolAutoscaling struct {
	// Is autoscaling enabled for this node pool.
	Enabled bool `protobuf:"varint,1,opt,name=enabled" json:"enabled,omitempty"`
	// Minimum number of nodes in the NodePool. Must be >= 1 and <=
	// max_node_count.
	MinNodeCount int32 `protobuf:"varint,2,opt,name=min_node_count,json=minNodeCount" json:"min_node_count,omitempty"`
	// Maximum number of nodes in the NodePool. Must be >= min_node_count. There
	// has to enough quota to scale up the cluster.
	MaxNodeCount int32 `protobuf:"varint,3,opt,name=max_node_count,json=maxNodeCount" json:"max_node_count,omitempty"`
}

func (m *NodePoolAutoscaling) Reset()                    { *m = NodePoolAutoscaling{} }
func (m *NodePoolAutoscaling) String() string            { return proto.CompactTextString(m) }
func (*NodePoolAutoscaling) ProtoMessage()               {}
func (*NodePoolAutoscaling) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *NodePoolAutoscaling) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *NodePoolAutoscaling) GetMinNodeCount() int32 {
	if m != nil {
		return m.MinNodeCount
	}
	return 0
}

func (m *NodePoolAutoscaling) GetMaxNodeCount() int32 {
	if m != nil {
		return m.MaxNodeCount
	}
	return 0
}

// SetLabelsRequest sets the Google Cloud Platform labels on a Google Container
// Engine cluster, which will in turn set them for Google Compute Engine
// resources used by that cluster
type SetLabelsRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// The labels to set for that cluster.
	ResourceLabels map[string]string `protobuf:"bytes,4,rep,name=resource_labels,json=resourceLabels" json:"resource_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The fingerprint of the previous set of labels for this resource,
	// used to detect conflicts. The fingerprint is initially generated by
	// Container Engine and changes after every request to modify or update
	// labels. You must always provide an up-to-date fingerprint hash when
	// updating or changing labels. Make a <code>get()</code> request to the
	// resource to get the latest fingerprint.
	LabelFingerprint string `protobuf:"bytes,5,opt,name=label_fingerprint,json=labelFingerprint" json:"label_fingerprint,omitempty"`
}

func (m *SetLabelsRequest) Reset()                    { *m = SetLabelsRequest{} }
func (m *SetLabelsRequest) String() string            { return proto.CompactTextString(m) }
func (*SetLabelsRequest) ProtoMessage()               {}
func (*SetLabelsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *SetLabelsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetLabelsRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetLabelsRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLabelsRequest) GetResourceLabels() map[string]string {
	if m != nil {
		return m.ResourceLabels
	}
	return nil
}

func (m *SetLabelsRequest) GetLabelFingerprint() string {
	if m != nil {
		return m.LabelFingerprint
	}
	return ""
}

// SetLegacyAbacRequest enables or disables the ABAC authorization mechanism for
// a cluster.
type SetLegacyAbacRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://support.google.com/cloud/answer/6158840).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster to update.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
	// Whether ABAC authorization will be enabled in the cluster.
	Enabled bool `protobuf:"varint,4,opt,name=enabled" json:"enabled,omitempty"`
}

func (m *SetLegacyAbacRequest) Reset()                    { *m = SetLegacyAbacRequest{} }
func (m *SetLegacyAbacRequest) String() string            { return proto.CompactTextString(m) }
func (*SetLegacyAbacRequest) ProtoMessage()               {}
func (*SetLegacyAbacRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *SetLegacyAbacRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SetLegacyAbacRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *SetLegacyAbacRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *SetLegacyAbacRequest) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

// StartIPRotationRequest creates a new IP for the cluster and then performs
// a node upgrade on each node pool to point to the new IP.
type StartIPRotationRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
}

func (m *StartIPRotationRequest) Reset()                    { *m = StartIPRotationRequest{} }
func (m *StartIPRotationRequest) String() string            { return proto.CompactTextString(m) }
func (*StartIPRotationRequest) ProtoMessage()               {}
func (*StartIPRotationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *StartIPRotationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *StartIPRotationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *StartIPRotationRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

// CompleteIPRotationRequest moves the cluster master back into single-IP mode.
type CompleteIPRotationRequest struct {
	// The Google Developers Console [project ID or project
	// number](https://developers.google.com/console/help/new/#projectnumber).
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The name of the Google Compute Engine
	// [zone](/compute/docs/zones#available) in which the cluster
	// resides.
	Zone string `protobuf:"bytes,2,opt,name=zone" json:"zone,omitempty"`
	// The name of the cluster.
	ClusterId string `protobuf:"bytes,3,opt,name=cluster_id,json=clusterId" json:"cluster_id,omitempty"`
}

func (m *CompleteIPRotationRequest) Reset()                    { *m = CompleteIPRotationRequest{} }
func (m *CompleteIPRotationRequest) String() string            { return proto.CompactTextString(m) }
func (*CompleteIPRotationRequest) ProtoMessage()               {}
func (*CompleteIPRotationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *CompleteIPRotationRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CompleteIPRotationRequest) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CompleteIPRotationRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func init() {
	proto.RegisterType((*NodeConfig)(nil), "google.container.v1.NodeConfig")
	proto.RegisterType((*MasterAuth)(nil), "google.container.v1.MasterAuth")
	proto.RegisterType((*AddonsConfig)(nil), "google.container.v1.AddonsConfig")
	proto.RegisterType((*HttpLoadBalancing)(nil), "google.container.v1.HttpLoadBalancing")
	proto.RegisterType((*HorizontalPodAutoscaling)(nil), "google.container.v1.HorizontalPodAutoscaling")
	proto.RegisterType((*LegacyAbac)(nil), "google.container.v1.LegacyAbac")
	proto.RegisterType((*Cluster)(nil), "google.container.v1.Cluster")
	proto.RegisterType((*ClusterUpdate)(nil), "google.container.v1.ClusterUpdate")
	proto.RegisterType((*Operation)(nil), "google.container.v1.Operation")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.container.v1.CreateClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.container.v1.GetClusterRequest")
	proto.RegisterType((*UpdateClusterRequest)(nil), "google.container.v1.UpdateClusterRequest")
	proto.RegisterType((*SetMasterAuthRequest)(nil), "google.container.v1.SetMasterAuthRequest")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.container.v1.DeleteClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.container.v1.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.container.v1.ListClustersResponse")
	proto.RegisterType((*GetOperationRequest)(nil), "google.container.v1.GetOperationRequest")
	proto.RegisterType((*ListOperationsRequest)(nil), "google.container.v1.ListOperationsRequest")
	proto.RegisterType((*CancelOperationRequest)(nil), "google.container.v1.CancelOperationRequest")
	proto.RegisterType((*ListOperationsResponse)(nil), "google.container.v1.ListOperationsResponse")
	proto.RegisterType((*GetServerConfigRequest)(nil), "google.container.v1.GetServerConfigRequest")
	proto.RegisterType((*ServerConfig)(nil), "google.container.v1.ServerConfig")
	proto.RegisterType((*CreateNodePoolRequest)(nil), "google.container.v1.CreateNodePoolRequest")
	proto.RegisterType((*DeleteNodePoolRequest)(nil), "google.container.v1.DeleteNodePoolRequest")
	proto.RegisterType((*ListNodePoolsRequest)(nil), "google.container.v1.ListNodePoolsRequest")
	proto.RegisterType((*GetNodePoolRequest)(nil), "google.container.v1.GetNodePoolRequest")
	proto.RegisterType((*NodePool)(nil), "google.container.v1.NodePool")
	proto.RegisterType((*NodeManagement)(nil), "google.container.v1.NodeManagement")
	proto.RegisterType((*AutoUpgradeOptions)(nil), "google.container.v1.AutoUpgradeOptions")
	proto.RegisterType((*SetNodePoolManagementRequest)(nil), "google.container.v1.SetNodePoolManagementRequest")
	proto.RegisterType((*RollbackNodePoolUpgradeRequest)(nil), "google.container.v1.RollbackNodePoolUpgradeRequest")
	proto.RegisterType((*ListNodePoolsResponse)(nil), "google.container.v1.ListNodePoolsResponse")
	proto.RegisterType((*NodePoolAutoscaling)(nil), "google.container.v1.NodePoolAutoscaling")
	proto.RegisterType((*SetLabelsRequest)(nil), "google.container.v1.SetLabelsRequest")
	proto.RegisterType((*SetLegacyAbacRequest)(nil), "google.container.v1.SetLegacyAbacRequest")
	proto.RegisterType((*StartIPRotationRequest)(nil), "google.container.v1.StartIPRotationRequest")
	proto.RegisterType((*CompleteIPRotationRequest)(nil), "google.container.v1.CompleteIPRotationRequest")
	proto.RegisterEnum("google.container.v1.Cluster_Status", Cluster_Status_name, Cluster_Status_value)
	proto.RegisterEnum("google.container.v1.Operation_Status", Operation_Status_name, Operation_Status_value)
	proto.RegisterEnum("google.container.v1.Operation_Type", Operation_Type_name, Operation_Type_value)
	proto.RegisterEnum("google.container.v1.SetMasterAuthRequest_Action", SetMasterAuthRequest_Action_name, SetMasterAuthRequest_Action_value)
	proto.RegisterEnum("google.container.v1.NodePool_Status", NodePool_Status_name, NodePool_Status_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ClusterManager service

type ClusterManagerClient interface {
	// Lists all clusters owned by a project in either the specified zone or all
	// zones.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Gets the details of a specific cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the cluster creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range is being used by the cluster.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the settings of a specific cluster.
	UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Used to set master auth materials. Currently supports :-
	// Changing the admin password of a specific cluster.
	// This can be either via password generation or explicitly set the password.
	SetMasterAuth(ctx context.Context, in *SetMasterAuthRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster
	// (e.g. load balancer resources) will not be deleted if they weren't present
	// at the initial create time.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all operations in a project in a specific zone or all zones.
	ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Cancels the specified operation.
	CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Returns configuration info about the Container Engine service.
	GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error)
	// Lists the node pools for a cluster.
	ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error)
	// Retrieves the node pool requested.
	GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error)
	// Creates a node pool for a cluster.
	CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a node pool from a cluster.
	DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*Operation, error)
	// Roll back the previously Aborted or Failed NodePool upgrade.
	// This will be an no-op if the last upgrade successfully completed.
	RollbackNodePoolUpgrade(ctx context.Context, in *RollbackNodePoolUpgradeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the NodeManagement options for a node pool.
	SetNodePoolManagement(ctx context.Context, in *SetNodePoolManagementRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets labels on a cluster.
	SetLabels(ctx context.Context, in *SetLabelsRequest, opts ...grpc.CallOption) (*Operation, error)
	// Enables or disables the ABAC authorization mechanism on a cluster.
	SetLegacyAbac(ctx context.Context, in *SetLegacyAbacRequest, opts ...grpc.CallOption) (*Operation, error)
	// Start master IP rotation.
	StartIPRotation(ctx context.Context, in *StartIPRotationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Completes master IP rotation.
	CompleteIPRotation(ctx context.Context, in *CompleteIPRotationRequest, opts ...grpc.CallOption) (*Operation, error)
}

type clusterManagerClient struct {
	cc *grpc.ClientConn
}

func NewClusterManagerClient(cc *grpc.ClientConn) ClusterManagerClient {
	return &clusterManagerClient{cc}
}

func (c *clusterManagerClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/ListClusters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/GetCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/CreateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) UpdateCluster(ctx context.Context, in *UpdateClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/UpdateCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetMasterAuth(ctx context.Context, in *SetMasterAuthRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/SetMasterAuth", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/DeleteCluster", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error) {
	out := new(ListOperationsResponse)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/ListOperations", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/GetOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/CancelOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetServerConfig(ctx context.Context, in *GetServerConfigRequest, opts ...grpc.CallOption) (*ServerConfig, error) {
	out := new(ServerConfig)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/GetServerConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) ListNodePools(ctx context.Context, in *ListNodePoolsRequest, opts ...grpc.CallOption) (*ListNodePoolsResponse, error) {
	out := new(ListNodePoolsResponse)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/ListNodePools", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) GetNodePool(ctx context.Context, in *GetNodePoolRequest, opts ...grpc.CallOption) (*NodePool, error) {
	out := new(NodePool)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/GetNodePool", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CreateNodePool(ctx context.Context, in *CreateNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/CreateNodePool", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) DeleteNodePool(ctx context.Context, in *DeleteNodePoolRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/DeleteNodePool", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) RollbackNodePoolUpgrade(ctx context.Context, in *RollbackNodePoolUpgradeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/RollbackNodePoolUpgrade", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetNodePoolManagement(ctx context.Context, in *SetNodePoolManagementRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/SetNodePoolManagement", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLabels(ctx context.Context, in *SetLabelsRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/SetLabels", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) SetLegacyAbac(ctx context.Context, in *SetLegacyAbacRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/SetLegacyAbac", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) StartIPRotation(ctx context.Context, in *StartIPRotationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/StartIPRotation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *clusterManagerClient) CompleteIPRotation(ctx context.Context, in *CompleteIPRotationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.container.v1.ClusterManager/CompleteIPRotation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ClusterManager service

type ClusterManagerServer interface {
	// Lists all clusters owned by a project in either the specified zone or all
	// zones.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Gets the details of a specific cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Creates a cluster, consisting of the specified number and type of Google
	// Compute Engine instances.
	//
	// By default, the cluster is created in the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// One firewall is added for the cluster. After cluster creation,
	// the cluster creates routes for each node to allow the containers
	// on that node to communicate with all other instances in the
	// cluster.
	//
	// Finally, an entry is added to the project's global metadata indicating
	// which CIDR range is being used by the cluster.
	CreateCluster(context.Context, *CreateClusterRequest) (*Operation, error)
	// Updates the settings of a specific cluster.
	UpdateCluster(context.Context, *UpdateClusterRequest) (*Operation, error)
	// Used to set master auth materials. Currently supports :-
	// Changing the admin password of a specific cluster.
	// This can be either via password generation or explicitly set the password.
	SetMasterAuth(context.Context, *SetMasterAuthRequest) (*Operation, error)
	// Deletes the cluster, including the Kubernetes endpoint and all worker
	// nodes.
	//
	// Firewalls and routes that were configured during cluster creation
	// are also deleted.
	//
	// Other Google Compute Engine resources that might be in use by the cluster
	// (e.g. load balancer resources) will not be deleted if they weren't present
	// at the initial create time.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*Operation, error)
	// Lists all operations in a project in a specific zone or all zones.
	ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error)
	// Gets the specified operation.
	GetOperation(context.Context, *GetOperationRequest) (*Operation, error)
	// Cancels the specified operation.
	CancelOperation(context.Context, *CancelOperationRequest) (*google_protobuf1.Empty, error)
	// Returns configuration info about the Container Engine service.
	GetServerConfig(context.Context, *GetServerConfigRequest) (*ServerConfig, error)
	// Lists the node pools for a cluster.
	ListNodePools(context.Context, *ListNodePoolsRequest) (*ListNodePoolsResponse, error)
	// Retrieves the node pool requested.
	GetNodePool(context.Context, *GetNodePoolRequest) (*NodePool, error)
	// Creates a node pool for a cluster.
	CreateNodePool(context.Context, *CreateNodePoolRequest) (*Operation, error)
	// Deletes a node pool from a cluster.
	DeleteNodePool(context.Context, *DeleteNodePoolRequest) (*Operation, error)
	// Roll back the previously Aborted or Failed NodePool upgrade.
	// This will be an no-op if the last upgrade successfully completed.
	RollbackNodePoolUpgrade(context.Context, *RollbackNodePoolUpgradeRequest) (*Operation, error)
	// Sets the NodeManagement options for a node pool.
	SetNodePoolManagement(context.Context, *SetNodePoolManagementRequest) (*Operation, error)
	// Sets labels on a cluster.
	SetLabels(context.Context, *SetLabelsRequest) (*Operation, error)
	// Enables or disables the ABAC authorization mechanism on a cluster.
	SetLegacyAbac(context.Context, *SetLegacyAbacRequest) (*Operation, error)
	// Start master IP rotation.
	StartIPRotation(context.Context, *StartIPRotationRequest) (*Operation, error)
	// Completes master IP rotation.
	CompleteIPRotation(context.Context, *CompleteIPRotationRequest) (*Operation, error)
}

func RegisterClusterManagerServer(s *grpc.Server, srv ClusterManagerServer) {
	s.RegisterService(&_ClusterManager_serviceDesc, srv)
}

func _ClusterManager_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).UpdateCluster(ctx, req.(*UpdateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetMasterAuth_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMasterAuthRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetMasterAuth(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetMasterAuth",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetMasterAuth(ctx, req.(*SetMasterAuthRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListOperations(ctx, req.(*ListOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetOperation(ctx, req.(*GetOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CancelOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CancelOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/CancelOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CancelOperation(ctx, req.(*CancelOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetServerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetServerConfig(ctx, req.(*GetServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_ListNodePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).ListNodePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/ListNodePools",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).ListNodePools(ctx, req.(*ListNodePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_GetNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).GetNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/GetNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).GetNodePool(ctx, req.(*GetNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CreateNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CreateNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/CreateNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CreateNodePool(ctx, req.(*CreateNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_DeleteNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).DeleteNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/DeleteNodePool",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).DeleteNodePool(ctx, req.(*DeleteNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_RollbackNodePoolUpgrade_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackNodePoolUpgradeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).RollbackNodePoolUpgrade(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/RollbackNodePoolUpgrade",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).RollbackNodePoolUpgrade(ctx, req.(*RollbackNodePoolUpgradeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetNodePoolManagement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodePoolManagementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetNodePoolManagement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetNodePoolManagement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetNodePoolManagement(ctx, req.(*SetNodePoolManagementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetLabels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLabels(ctx, req.(*SetLabelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_SetLegacyAbac_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLegacyAbacRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).SetLegacyAbac(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/SetLegacyAbac",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).SetLegacyAbac(ctx, req.(*SetLegacyAbacRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_StartIPRotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartIPRotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).StartIPRotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/StartIPRotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).StartIPRotation(ctx, req.(*StartIPRotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ClusterManager_CompleteIPRotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteIPRotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterManagerServer).CompleteIPRotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.container.v1.ClusterManager/CompleteIPRotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterManagerServer).CompleteIPRotation(ctx, req.(*CompleteIPRotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.container.v1.ClusterManager",
	HandlerType: (*ClusterManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListClusters",
			Handler:    _ClusterManager_ListClusters_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _ClusterManager_GetCluster_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _ClusterManager_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _ClusterManager_UpdateCluster_Handler,
		},
		{
			MethodName: "SetMasterAuth",
			Handler:    _ClusterManager_SetMasterAuth_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _ClusterManager_DeleteCluster_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _ClusterManager_ListOperations_Handler,
		},
		{
			MethodName: "GetOperation",
			Handler:    _ClusterManager_GetOperation_Handler,
		},
		{
			MethodName: "CancelOperation",
			Handler:    _ClusterManager_CancelOperation_Handler,
		},
		{
			MethodName: "GetServerConfig",
			Handler:    _ClusterManager_GetServerConfig_Handler,
		},
		{
			MethodName: "ListNodePools",
			Handler:    _ClusterManager_ListNodePools_Handler,
		},
		{
			MethodName: "GetNodePool",
			Handler:    _ClusterManager_GetNodePool_Handler,
		},
		{
			MethodName: "CreateNodePool",
			Handler:    _ClusterManager_CreateNodePool_Handler,
		},
		{
			MethodName: "DeleteNodePool",
			Handler:    _ClusterManager_DeleteNodePool_Handler,
		},
		{
			MethodName: "RollbackNodePoolUpgrade",
			Handler:    _ClusterManager_RollbackNodePoolUpgrade_Handler,
		},
		{
			MethodName: "SetNodePoolManagement",
			Handler:    _ClusterManager_SetNodePoolManagement_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _ClusterManager_SetLabels_Handler,
		},
		{
			MethodName: "SetLegacyAbac",
			Handler:    _ClusterManager_SetLegacyAbac_Handler,
		},
		{
			MethodName: "StartIPRotation",
			Handler:    _ClusterManager_StartIPRotation_Handler,
		},
		{
			MethodName: "CompleteIPRotation",
			Handler:    _ClusterManager_CompleteIPRotation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/container/v1/cluster_service.proto",
}

func init() { proto.RegisterFile("google/container/v1/cluster_service.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 3298 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xdb, 0x6f, 0x1b, 0xd7,
	0xd1, 0xff, 0x56, 0xa2, 0x2e, 0x1c, 0x5e, 0x44, 0x1d, 0x5d, 0xbc, 0x1f, 0x63, 0xc7, 0xf2, 0xe6,
	0x62, 0xc7, 0x6e, 0xc4, 0xf8, 0x92, 0x9b, 0xed, 0x06, 0xa1, 0x29, 0x5a, 0xa2, 0x2d, 0x91, 0xcc,
	0x92, 0xb4, 0x91, 0x00, 0xed, 0x62, 0xb5, 0x7b, 0x44, 0x6d, 0xb4, 0xdc, 0xdd, 0xec, 0x2e, 0x95,
	0xc8, 0x86, 0x1f, 0x1a, 0xb4, 0x40, 0x81, 0x3e, 0xb6, 0x28, 0xfa, 0x50, 0x14, 0x45, 0x9a, 0xf6,
	0x21, 0x05, 0x5a, 0x04, 0x28, 0xda, 0x02, 0x7d, 0x29, 0xd0, 0x97, 0xbe, 0x16, 0x79, 0x28, 0xda,
	0xe7, 0xa2, 0x8f, 0xfd, 0x1b, 0x8a, 0x73, 0xd9, 0xe5, 0xae, 0xb4, 0x14, 0xa5, 0xc8, 0x4a, 0xfa,
	0x64, 0xed, 0x9c, 0x99, 0x73, 0x7e, 0x33, 0x67, 0x66, 0xce, 0xcc, 0x98, 0xf0, 0x52, 0xd7, 0xb6,
	0xbb, 0x26, 0x2e, 0x69, 0xb6, 0xe5, 0xab, 0x86, 0x85, 0xdd, 0xd2, 0xee, 0xd5, 0x92, 0x66, 0xf6,
	0x3d, 0x1f, 0xbb, 0x8a, 0x87, 0xdd, 0x5d, 0x43, 0xc3, 0xcb, 0x8e, 0x6b, 0xfb, 0x36, 0x9a, 0x63,
	0xac, 0xcb, 0x21, 0xeb, 0xf2, 0xee, 0xd5, 0xe2, 0x59, 0x2e, 0xaf, 0x3a, 0x46, 0x49, 0xb5, 0x2c,
	0xdb, 0x57, 0x7d, 0xc3, 0xb6, 0x3c, 0x26, 0x52, 0x7c, 0x86, 0xaf, 0xd2, 0xaf, 0xcd, 0xfe, 0x56,
	0x09, 0xf7, 0x1c, 0x7f, 0x8f, 0x2d, 0x4a, 0x9f, 0xa4, 0x00, 0xea, 0xb6, 0x8e, 0x2b, 0xb6, 0xb5,
	0x65, 0x74, 0xd1, 0x05, 0xc8, 0xf6, 0x54, 0x6d, 0xdb, 0xb0, 0xb0, 0xe2, 0xef, 0x39, 0x58, 0x14,
	0x96, 0x84, 0x4b, 0x69, 0x39, 0xc3, 0x69, 0xed, 0x3d, 0x07, 0xa3, 0x25, 0xc8, 0xea, 0x86, 0xb7,
	0xa3, 0x78, 0xc6, 0x23, 0xac, 0x74, 0x37, 0xc5, 0xb1, 0x25, 0xe1, 0xd2, 0x84, 0x0c, 0x84, 0xd6,
	0x32, 0x1e, 0xe1, 0xd5, 0x4d, 0xb2, 0x89, 0xad, 0xf6, 0xfd, 0x6d, 0xc5, 0xd3, 0x6c, 0x07, 0x7b,
	0xe2, 0xf8, 0xd2, 0x38, 0xd9, 0x84, 0xd2, 0x5a, 0x94, 0x84, 0x2e, 0xc2, 0x0c, 0xd7, 0x4b, 0x51,
	0x35, 0xcd, 0xee, 0x5b, 0xbe, 0x98, 0xa6, 0x47, 0xe5, 0x39, 0xb9, 0xcc, 0xa8, 0xa8, 0x06, 0xd3,
	0x3d, 0xec, 0xab, 0xba, 0xea, 0xab, 0x62, 0x6a, 0x69, 0xfc, 0x52, 0xe6, 0xda, 0xcb, 0xcb, 0x09,
	0x26, 0x58, 0x1e, 0xe8, 0xb0, 0xbc, 0xc1, 0xf9, 0xab, 0x96, 0xef, 0xee, 0xc9, 0xa1, 0x38, 0x3a,
	0x07, 0x60, 0xf4, 0xd4, 0x2e, 0xd7, 0x6c, 0x82, 0x1e, 0x97, 0xa6, 0x14, 0xaa, 0x57, 0x05, 0x26,
	0x4d, 0x75, 0x13, 0x9b, 0x9e, 0x38, 0x49, 0xcf, 0xb9, 0x32, 0xea, 0x9c, 0x75, 0xca, 0xcd, 0x4e,
	0xe1, 0xa2, 0xe8, 0x45, 0x98, 0x31, 0x6d, 0x4d, 0x35, 0x15, 0xcf, 0xd3, 0x15, 0xa6, 0xd7, 0x14,
	0xb5, 0x4f, 0x8e, 0x92, 0x5b, 0x9e, 0x5e, 0xa1, 0x6a, 0x21, 0x48, 0xf9, 0x6a, 0xd7, 0x13, 0xa7,
	0xa9, 0x69, 0xe8, 0xdf, 0x68, 0x09, 0x32, 0x8e, 0x8b, 0xc9, 0xe5, 0x18, 0x9b, 0x26, 0x16, 0x61,
	0x49, 0xb8, 0x34, 0x2d, 0x47, 0x49, 0xc5, 0x5b, 0x90, 0x8b, 0x29, 0x87, 0x0a, 0x30, 0xbe, 0x83,
	0xf7, 0xf8, 0x2d, 0x91, 0x3f, 0xd1, 0x3c, 0x4c, 0xec, 0xaa, 0x66, 0x1f, 0xd3, 0x6b, 0x49, 0xcb,
	0xec, 0xe3, 0xe6, 0xd8, 0x1b, 0x42, 0xf1, 0x4d, 0xc8, 0x44, 0x10, 0x1f, 0x47, 0x54, 0xfa, 0xab,
	0x00, 0xb0, 0xa1, 0x12, 0x6f, 0x2c, 0xf7, 0xfd, 0x6d, 0x54, 0x84, 0xe9, 0xbe, 0x87, 0x5d, 0x4b,
	0xed, 0x05, 0x0e, 0x12, 0x7e, 0x93, 0x35, 0x47, 0xf5, 0xbc, 0x0f, 0x6d, 0x57, 0xe7, 0xfb, 0x84,
	0xdf, 0xe8, 0x06, 0x2c, 0x06, 0x4e, 0xad, 0xa9, 0x8a, 0x86, 0x5d, 0xdf, 0xd8, 0x32, 0x34, 0xd5,
	0xc7, 0xa2, 0x4e, 0x39, 0xe7, 0xf9, 0x6a, 0x45, 0xad, 0x0c, 0xd6, 0xd0, 0xcb, 0x80, 0x34, 0xd3,
	0xc0, 0x96, 0x1f, 0x93, 0xc0, 0x54, 0x62, 0x96, 0xad, 0x44, 0xd9, 0xcf, 0x01, 0x70, 0x76, 0xa2,
	0xde, 0x16, 0xbb, 0x65, 0x46, 0xb9, 0x8f, 0xf7, 0xa4, 0x2f, 0x04, 0xc8, 0x96, 0x75, 0xdd, 0xb6,
	0x3c, 0xee, 0xf1, 0x0f, 0x60, 0x6e, 0xdb, 0xf7, 0x1d, 0xc5, 0xb4, 0x55, 0x5d, 0xd9, 0x54, 0x4d,
	0xd5, 0xd2, 0x0c, 0xab, 0x4b, 0xf5, 0xca, 0x5c, 0x7b, 0x31, 0xd1, 0x07, 0xd6, 0x7c, 0xdf, 0x59,
	0xb7, 0x55, 0xfd, 0x4e, 0xc0, 0x2d, 0xcf, 0x6e, 0xef, 0x27, 0xa1, 0x1d, 0x28, 0x6e, 0xdb, 0xae,
	0xf1, 0x88, 0x08, 0x9a, 0x8a, 0x63, 0xeb, 0x8a, 0xda, 0xf7, 0x6d, 0x4f, 0x53, 0x4d, 0xb2, 0xfd,
	0x18, 0xdd, 0x3e, 0xd9, 0x95, 0xd7, 0x42, 0xb1, 0xa6, 0xad, 0x97, 0x07, 0x42, 0xb2, 0xb8, 0x3d,
	0x64, 0x45, 0x2a, 0xc1, 0xec, 0x01, 0x50, 0xe4, 0x2a, 0x74, 0xc3, 0x53, 0x37, 0x4d, 0xac, 0x53,
	0x75, 0xa6, 0xe5, 0xf0, 0x5b, 0x7a, 0x0d, 0xc4, 0x61, 0xc7, 0x1c, 0x2a, 0xf7, 0x22, 0xc0, 0x3a,
	0xee, 0xaa, 0xda, 0x5e, 0x79, 0x53, 0xd5, 0x90, 0x08, 0x53, 0xd8, 0x8a, 0x32, 0x06, 0x9f, 0xd2,
	0xdf, 0xb2, 0x30, 0x55, 0x61, 0xb7, 0x49, 0x7c, 0x3d, 0xe2, 0x2a, 0xf4, 0x6f, 0xe2, 0xeb, 0x3a,
	0xf6, 0x34, 0xd7, 0x70, 0x48, 0xa6, 0xe2, 0x9e, 0x12, 0x25, 0xa1, 0x6f, 0x00, 0x32, 0x2c, 0xc3,
	0x37, 0x54, 0x53, 0xb1, 0x6c, 0x1d, 0xf3, 0x60, 0x1a, 0xa7, 0xc1, 0x54, 0xe0, 0x2b, 0x2c, 0x18,
	0x49, 0x3c, 0xbd, 0x0d, 0x19, 0xce, 0x45, 0x2e, 0x55, 0x4c, 0x51, 0xf3, 0x9e, 0x1f, 0x11, 0xc1,
	0x32, 0x58, 0x83, 0xcc, 0xf7, 0x36, 0x64, 0x7a, 0xd4, 0xc5, 0xc9, 0x3d, 0x6d, 0xd3, 0xf4, 0x30,
	0x6c, 0x87, 0x41, 0x28, 0xc8, 0xd0, 0x1b, 0x84, 0xc5, 0x45, 0x12, 0xfb, 0xdd, 0xae, 0x61, 0x75,
	0x83, 0x9c, 0x2d, 0x4e, 0xb2, 0x9c, 0xc6, 0xc9, 0x2d, 0x46, 0x25, 0x1e, 0xdd, 0xb3, 0x2d, 0xc3,
	0xb7, 0xdd, 0x28, 0xef, 0x14, 0xf3, 0xe8, 0xc1, 0x4a, 0xc0, 0x2e, 0xc2, 0x94, 0x85, 0xfd, 0x0f,
	0x6d, 0x77, 0x47, 0x9c, 0xa6, 0x3c, 0xc1, 0x27, 0xba, 0x0c, 0xb3, 0x41, 0x40, 0x19, 0xce, 0xee,
	0x0d, 0x45, 0x33, 0x74, 0x97, 0xe7, 0xd1, 0x19, 0xbe, 0x50, 0x73, 0x76, 0x6f, 0x54, 0x0c, 0xdd,
	0x45, 0x77, 0x21, 0xa7, 0x52, 0xbf, 0x0f, 0x6c, 0x04, 0x54, 0xc3, 0x0b, 0x89, 0x1a, 0x46, 0x23,
	0x44, 0xce, 0xaa, 0xd1, 0x78, 0x79, 0x16, 0xc0, 0xeb, 0x6f, 0x06, 0x80, 0x32, 0xf4, 0xb0, 0x08,
	0x05, 0xdd, 0x06, 0x6a, 0x55, 0xc5, 0xb1, 0x6d, 0xd3, 0x13, 0xb3, 0x34, 0x95, 0x9e, 0x1b, 0x7a,
	0x11, 0x4d, 0xdb, 0x36, 0xe5, 0xb4, 0xc5, 0xff, 0xf2, 0xd0, 0x59, 0x48, 0x93, 0x44, 0x49, 0x9f,
	0x2f, 0x31, 0x47, 0x93, 0xe3, 0x80, 0x80, 0x5e, 0x83, 0x33, 0xcc, 0xc1, 0x94, 0x9d, 0xfe, 0x26,
	0x76, 0x2d, 0xec, 0x63, 0x4f, 0x51, 0x4d, 0x67, 0x5b, 0x15, 0xf3, 0xd4, 0xff, 0x16, 0xd8, 0xf2,
	0xfd, 0x70, 0xb5, 0x4c, 0x16, 0xd1, 0xbb, 0x30, 0xe3, 0x62, 0xcf, 0xee, 0xbb, 0x1a, 0x56, 0x78,
	0x8e, 0x9f, 0xa1, 0xc0, 0x5e, 0x49, 0x04, 0xc6, 0x1d, 0x77, 0x59, 0xe6, 0x32, 0xd1, 0x44, 0x9f,
	0x77, 0x63, 0x44, 0x74, 0x05, 0x66, 0xe9, 0x8e, 0xca, 0x96, 0x61, 0x75, 0xb1, 0xeb, 0xb8, 0x86,
	0xe5, 0x8b, 0x05, 0x6a, 0x95, 0x02, 0x5d, 0xb8, 0x3b, 0xa0, 0x13, 0x1f, 0x33, 0x69, 0xf4, 0x28,
	0xea, 0xa6, 0xaa, 0x89, 0xe8, 0x10, 0x1f, 0x1b, 0x44, 0x99, 0x0c, 0xe6, 0x20, 0xe2, 0x9e, 0x81,
	0xb4, 0x87, 0xcd, 0x2d, 0xc5, 0x34, 0xac, 0x1d, 0x9e, 0x35, 0xa7, 0x09, 0x61, 0xdd, 0xb0, 0x76,
	0x48, 0xa0, 0x3d, 0xb2, 0xad, 0x20, 0x37, 0xd2, 0xbf, 0x49, 0x30, 0x63, 0x4b, 0x77, 0x6c, 0x02,
	0x8b, 0x25, 0xc3, 0xf0, 0x9b, 0x98, 0x33, 0x08, 0xb1, 0xc0, 0x8d, 0x76, 0xb1, 0xeb, 0x91, 0x80,
	0xec, 0x52, 0xd6, 0x05, 0xbe, 0xcc, 0x0d, 0xf2, 0x80, 0x2d, 0xd2, 0x3c, 0xde, 0x77, 0x5d, 0x92,
	0x63, 0x79, 0xc8, 0x04, 0x62, 0xdb, 0x3c, 0x8f, 0xb3, 0x55, 0x16, 0x27, 0x81, 0xd4, 0x2b, 0x10,
	0xd0, 0x59, 0x40, 0x07, 0x32, 0x06, 0x95, 0x41, 0x7c, 0x8d, 0x38, 0x45, 0x20, 0x71, 0x1e, 0x32,
	0x9a, 0x8b, 0x55, 0x1f, 0x2b, 0xbe, 0xd1, 0xc3, 0xe2, 0xfb, 0xcc, 0xd7, 0x18, 0xa9, 0x6d, 0xf4,
	0x30, 0xba, 0x05, 0x93, 0x9e, 0xaf, 0xfa, 0x7d, 0x4f, 0xdc, 0x59, 0x12, 0x2e, 0xe5, 0xaf, 0x3d,
	0x77, 0xe8, 0x75, 0xb6, 0x28, 0xab, 0xcc, 0x45, 0xd0, 0x0b, 0x90, 0x67, 0x7f, 0x29, 0x3d, 0xec,
	0x79, 0x6a, 0x17, 0x8b, 0x26, 0x3d, 0x20, 0xc7, 0xa8, 0x1b, 0x8c, 0x88, 0x5e, 0x86, 0x39, 0x0a,
	0x37, 0x0c, 0x30, 0x5a, 0xf8, 0x88, 0x3d, 0x96, 0x88, 0xc8, 0x52, 0x10, 0x62, 0xa4, 0xfa, 0x21,
	0x69, 0x8b, 0x07, 0xb4, 0x17, 0x89, 0x49, 0x8b, 0x39, 0x44, 0xb0, 0x12, 0x06, 0xe5, 0x32, 0xcc,
	0x19, 0x96, 0xe7, 0xab, 0x96, 0x86, 0x95, 0xae, 0x6b, 0xf7, 0x1d, 0xa5, 0xef, 0x9a, 0x9e, 0x68,
	0x53, 0xc7, 0x9f, 0x0d, 0x96, 0x56, 0xc9, 0x4a, 0xc7, 0x35, 0x3d, 0xb2, 0x7b, 0xcc, 0x86, 0x2c,
	0x29, 0x3a, 0x0c, 0x4b, 0xc4, 0x82, 0x2c, 0x29, 0x9e, 0x87, 0x0c, 0xfe, 0xc8, 0x31, 0x5c, 0x6e,
	0xbf, 0x0f, 0x98, 0xfd, 0x18, 0x89, 0xd8, 0xaf, 0x58, 0x86, 0xb9, 0x04, 0x1f, 0x3f, 0x56, 0x69,
	0x60, 0xc0, 0x24, 0xb3, 0x2b, 0x5a, 0x04, 0xd4, 0x6a, 0x97, 0xdb, 0x9d, 0x96, 0xd2, 0xa9, 0xb7,
	0x9a, 0xd5, 0x4a, 0xed, 0x6e, 0xad, 0xba, 0x52, 0xf8, 0x3f, 0x54, 0x80, 0x6c, 0x53, 0x6e, 0x3c,
	0xa8, 0xb5, 0x6a, 0x8d, 0x7a, 0xad, 0xbe, 0x5a, 0x10, 0x50, 0x06, 0xa6, 0xe4, 0x4e, 0x9d, 0x7e,
	0x8c, 0xa1, 0x19, 0xc8, 0xc8, 0xd5, 0x4a, 0xa3, 0x5e, 0xa9, 0xad, 0x13, 0xc2, 0x38, 0xca, 0xc2,
	0x74, 0xab, 0xdd, 0x68, 0x36, 0xc9, 0x57, 0x0a, 0xa5, 0x61, 0xa2, 0x2a, 0xcb, 0x0d, 0xb9, 0x30,
	0x21, 0x7d, 0x2f, 0x05, 0x39, 0x7e, 0x97, 0x1d, 0x47, 0x27, 0x6f, 0xfd, 0x2b, 0x30, 0xaf, 0x63,
	0xcf, 0x70, 0xb1, 0x1e, 0x77, 0xa9, 0x14, 0x73, 0x29, 0xbe, 0x16, 0x75, 0xa9, 0xdb, 0x50, 0x0c,
	0x24, 0x12, 0x52, 0x30, 0xab, 0x09, 0x45, 0xce, 0xb1, 0x71, 0x20, 0x13, 0x77, 0x60, 0x21, 0x90,
	0x8e, 0xe7, 0xd2, 0xc9, 0xa3, 0xe6, 0xd2, 0x39, 0x2e, 0x1f, 0x2b, 0x41, 0x4a, 0xfb, 0xd4, 0x20,
	0xa9, 0x53, 0x31, 0xf4, 0xe0, 0x45, 0x88, 0xa8, 0x41, 0x92, 0x64, 0x4d, 0x27, 0x6e, 0x10, 0x08,
	0x44, 0x2a, 0x5a, 0xf6, 0x38, 0x14, 0xf8, 0x4a, 0x2d, 0x2c, 0x6c, 0x77, 0xe0, 0xdc, 0xc1, 0xed,
	0xa3, 0xc5, 0x48, 0x9a, 0xa2, 0xbf, 0x74, 0x68, 0x92, 0x8e, 0xd6, 0x21, 0xc5, 0x7d, 0x88, 0xa2,
	0xc5, 0xc3, 0x15, 0x08, 0xf0, 0x2a, 0x83, 0x44, 0x0e, 0xd4, 0x9f, 0x03, 0x64, 0xeb, 0x61, 0x3e,
	0xbf, 0x01, 0x8b, 0xe1, 0x6d, 0xc4, 0x13, 0x09, 0x2f, 0x08, 0x83, 0x9b, 0x88, 0x26, 0x12, 0xe9,
	0x2f, 0x13, 0x90, 0x6e, 0x38, 0xd8, 0xa5, 0x9b, 0x24, 0x56, 0x17, 0x41, 0x22, 0x1c, 0x8b, 0x24,
	0xc2, 0x7b, 0x90, 0xb7, 0x03, 0x21, 0x66, 0xaf, 0xf1, 0x43, 0x72, 0x46, 0xb8, 0xff, 0x32, 0x31,
	0xa1, 0x9c, 0x0b, 0x45, 0xa9, 0x45, 0xbf, 0x19, 0xe6, 0x9d, 0x14, 0xdd, 0xe3, 0x85, 0x11, 0x7b,
	0xec, 0xcb, 0x3c, 0x8b, 0x30, 0xa9, 0x63, 0x5f, 0x35, 0x4c, 0x7e, 0x65, 0xfc, 0x2b, 0x21, 0x23,
	0x4d, 0x24, 0x65, 0xa4, 0xd8, 0x1b, 0x30, 0xb9, 0xef, 0x0d, 0x38, 0x0f, 0x19, 0x5f, 0x75, 0xbb,
	0xd8, 0x67, 0xcb, 0xcc, 0x85, 0x80, 0x91, 0x08, 0x83, 0x24, 0x8f, 0x0c, 0xd8, 0x0c, 0x4c, 0x35,
	0xab, 0xf5, 0x95, 0x84, 0x58, 0x9d, 0x86, 0xd4, 0x4a, 0xa3, 0x5e, 0x65, 0x41, 0x5a, 0xbe, 0xd3,
	0x90, 0xdb, 0x34, 0x48, 0xa5, 0xcf, 0xc7, 0x20, 0x45, 0x0d, 0x33, 0x0f, 0x85, 0xf6, 0xbb, 0xcd,
	0xea, 0xbe, 0x0d, 0x11, 0xe4, 0x2b, 0x72, 0xb5, 0xdc, 0xae, 0x2a, 0x95, 0xf5, 0x4e, 0xab, 0x5d,
	0x95, 0x0b, 0x02, 0xa1, 0xad, 0x54, 0xd7, 0xab, 0x11, 0xda, 0x18, 0xa1, 0x75, 0x9a, 0xab, 0x72,
	0x79, 0xa5, 0xaa, 0x6c, 0x94, 0x29, 0x6d, 0x1c, 0xcd, 0x42, 0x2e, 0xa0, 0xd5, 0x1b, 0x2b, 0xd5,
	0x56, 0x21, 0x45, 0xd8, 0xe4, 0x6a, 0xb3, 0x5c, 0x93, 0x43, 0xd1, 0x09, 0x26, 0xba, 0x12, 0x3d,
	0x62, 0x92, 0x80, 0xe1, 0xc7, 0x12, 0x49, 0xa5, 0xd9, 0x68, 0xac, 0x17, 0xa6, 0x08, 0x95, 0x1f,
	0x3c, 0xa0, 0x4e, 0xa3, 0xb3, 0x20, 0xb6, 0xaa, 0xed, 0x01, 0x49, 0xd9, 0x28, 0xd7, 0xcb, 0xab,
	0xd5, 0x8d, 0x6a, 0xbd, 0x5d, 0x48, 0xa3, 0x05, 0x98, 0x2d, 0x77, 0xda, 0x0d, 0x85, 0x1f, 0xcb,
	0x80, 0x00, 0x31, 0x20, 0x25, 0xc7, 0x01, 0x66, 0x50, 0x1e, 0x80, 0x6c, 0xb6, 0x5e, 0xbe, 0x53,
	0x5d, 0x6f, 0x15, 0xb2, 0x68, 0x0e, 0x66, 0xc8, 0x37, 0xd3, 0x49, 0x29, 0x77, 0xda, 0x6b, 0x85,
	0x9c, 0xf4, 0x1d, 0x01, 0xe6, 0x2b, 0xf4, 0x29, 0xe3, 0x39, 0x4d, 0xc6, 0x1f, 0xf4, 0xb1, 0xe7,
	0x93, 0x06, 0xc6, 0x71, 0xed, 0xf7, 0xb1, 0xe6, 0x93, 0x1c, 0xc0, 0xdc, 0x3a, 0xcd, 0x29, 0x35,
	0x3d, 0xd1, 0xb7, 0x5f, 0x83, 0x29, 0xfe, 0x80, 0x53, 0xa7, 0xce, 0x5c, 0x3b, 0x7b, 0xd8, 0x43,
	0x28, 0x07, 0xcc, 0x12, 0x86, 0xd9, 0x55, 0xec, 0x9f, 0xfc, 0x7c, 0xda, 0x73, 0xf1, 0x3a, 0x54,
	0xa7, 0x10, 0x68, 0xcf, 0xc5, 0x0a, 0x50, 0x5d, 0xfa, 0x54, 0x80, 0x79, 0x96, 0xb1, 0x4f, 0xfb,
	0x28, 0x74, 0x13, 0x26, 0xfb, 0xf4, 0x24, 0xde, 0x02, 0x48, 0x87, 0x19, 0x82, 0x61, 0x92, 0xb9,
	0x84, 0xf4, 0xeb, 0x31, 0x98, 0x6f, 0x61, 0x3f, 0x52, 0xdd, 0x9f, 0x1a, 0xcc, 0x35, 0x98, 0x54,
	0x35, 0x3f, 0x78, 0xaa, 0xf2, 0x43, 0xea, 0xd0, 0x24, 0x30, 0xcb, 0x65, 0x2a, 0x27, 0x73, 0x79,
	0xf4, 0x7a, 0xa8, 0xf0, 0x11, 0x3b, 0x96, 0x40, 0xdb, 0xb7, 0x60, 0x92, 0x6d, 0x45, 0x42, 0xbc,
	0x53, 0xbf, 0x5f, 0x6f, 0x3c, 0xac, 0xb3, 0xd7, 0x9a, 0xf8, 0x6a, 0xb3, 0xdc, 0x6a, 0x3d, 0x6c,
	0xc8, 0x2b, 0x05, 0x81, 0x38, 0xff, 0x6a, 0xb5, 0x5e, 0x95, 0x49, 0x20, 0x85, 0xe4, 0x31, 0x69,
	0x1b, 0xe6, 0x57, 0xb0, 0x89, 0x4f, 0xff, 0x4e, 0xa5, 0x35, 0x98, 0x5b, 0x37, 0xbc, 0xc0, 0x4d,
	0xbd, 0x2f, 0x7f, 0x90, 0xd4, 0x87, 0xf9, 0xf8, 0x4e, 0x9e, 0x63, 0x5b, 0x1e, 0x46, 0x6f, 0xc0,
	0x34, 0x3f, 0xce, 0x13, 0x05, 0xda, 0x18, 0x1c, 0x1e, 0x40, 0x21, 0x37, 0x7a, 0x0e, 0x72, 0x3d,
	0xc3, 0xf3, 0x48, 0x11, 0x41, 0x4e, 0xf0, 0xc4, 0x31, 0xfa, 0xd4, 0x65, 0x39, 0xf1, 0x3d, 0x42,
	0x93, 0x76, 0x60, 0x6e, 0x15, 0xfb, 0xe1, 0x73, 0x70, 0x02, 0x4b, 0x5d, 0x80, 0xec, 0xe0, 0x11,
	0x0b, 0x6d, 0x95, 0x09, 0x69, 0x35, 0x5d, 0xba, 0x07, 0x0b, 0x44, 0xc7, 0xf0, 0xb4, 0x93, 0xd8,
	0xcb, 0x82, 0xc5, 0x0a, 0x29, 0x40, 0xcd, 0xaf, 0x08, 0xfb, 0x13, 0x58, 0xdc, 0x8f, 0x9d, 0xdf,
	0xd0, 0x5b, 0x00, 0x21, 0x63, 0x70, 0x47, 0xcf, 0x1e, 0xfe, 0xea, 0xca, 0x11, 0x89, 0xa3, 0xdd,
	0xd3, 0x7d, 0x58, 0x5c, 0xc5, 0x3e, 0x29, 0xf6, 0xb0, 0xcb, 0xeb, 0xb5, 0x2f, 0x6f, 0xbb, 0xef,
	0x8e, 0x41, 0x36, 0xba, 0x15, 0xe9, 0xb6, 0x74, 0xbc, 0xa5, 0xf6, 0x4d, 0xff, 0x40, 0xb7, 0xc5,
	0x36, 0x5c, 0xe0, 0xcb, 0xfb, 0xba, 0xad, 0x65, 0x98, 0xdb, 0x55, 0x4d, 0x23, 0x5e, 0xe2, 0x06,
	0x43, 0xd5, 0x59, 0xba, 0x14, 0xa9, 0x70, 0x3d, 0x56, 0x1c, 0xb2, 0x73, 0x22, 0xc5, 0x61, 0x2a,
	0x28, 0x0e, 0xe9, 0xca, 0xa0, 0x38, 0xbc, 0x0c, 0x6c, 0x8b, 0x08, 0xaf, 0x27, 0x4e, 0xd0, 0xbd,
	0x67, 0xe8, 0x42, 0xc8, 0xea, 0xa1, 0x6b, 0xb0, 0xc0, 0x78, 0xe3, 0xc5, 0x1a, 0x1b, 0x98, 0xa6,
	0x65, 0x06, 0x33, 0x56, 0xab, 0x79, 0xd2, 0x2f, 0x05, 0x58, 0x60, 0xcf, 0x5c, 0xd8, 0xee, 0x9f,
	0x62, 0xf2, 0x4f, 0x87, 0x05, 0x2e, 0xcf, 0xff, 0x23, 0x26, 0x0f, 0xd3, 0xc1, 0xe4, 0x41, 0xfa,
	0x81, 0x00, 0x0b, 0x2c, 0x9f, 0x9d, 0x3e, 0xce, 0x25, 0xc8, 0xc6, 0xea, 0x7c, 0x76, 0x37, 0x60,
	0x85, 0x05, 0x3e, 0x49, 0xae, 0x24, 0x10, 0x02, 0x28, 0xde, 0xe9, 0x25, 0xd7, 0xef, 0x0b, 0x80,
	0x56, 0xb1, 0xff, 0xbf, 0xa0, 0xf4, 0xbf, 0x53, 0x30, 0x1d, 0xe0, 0x48, 0x2c, 0xeb, 0x5f, 0x87,
	0x49, 0xde, 0x6f, 0x8d, 0x1d, 0x6d, 0xbe, 0xc7, 0xd9, 0x8f, 0x39, 0x4b, 0x3c, 0x74, 0xc6, 0x22,
	0xc2, 0x54, 0x10, 0xb5, 0x6c, 0xcc, 0x12, 0x7c, 0x0e, 0xeb, 0xe5, 0xb7, 0x86, 0xf5, 0xf2, 0xb7,
	0xc3, 0x26, 0xa2, 0x4b, 0x6b, 0x80, 0xe7, 0x0f, 0x75, 0xd5, 0xd1, 0xd3, 0x8b, 0xed, 0xa4, 0x5e,
	0xe1, 0x1e, 0x64, 0xa2, 0x9d, 0x5e, 0xea, 0x98, 0x9d, 0x5e, 0x54, 0x18, 0x55, 0x00, 0x7a, 0xaa,
	0xa5, 0x76, 0x71, 0x0f, 0x5b, 0x3e, 0x2f, 0x37, 0x9e, 0x1b, 0xba, 0xd5, 0x46, 0xc8, 0x2a, 0x47,
	0xc4, 0x48, 0xd9, 0x7b, 0xc2, 0x81, 0xc1, 0x22, 0x20, 0xfe, 0xa1, 0x3c, 0xac, 0xb5, 0xd7, 0x14,
	0x36, 0x1e, 0x18, 0xdf, 0x3f, 0x48, 0x48, 0xc5, 0x06, 0x09, 0x13, 0x83, 0x41, 0xc2, 0xa4, 0xf4,
	0x2b, 0x01, 0xf2, 0x71, 0x88, 0xe4, 0x71, 0x22, 0xaa, 0x2a, 0x7d, 0xa7, 0xeb, 0xaa, 0x3a, 0xe6,
	0xe3, 0x6c, 0xaa, 0x7e, 0x87, 0x91, 0x48, 0x67, 0x45, 0x59, 0x5c, 0xec, 0xa8, 0x86, 0x4b, 0x5d,
	0x70, 0x5a, 0x06, 0x42, 0x92, 0x29, 0x05, 0x35, 0x61, 0x86, 0x8b, 0x2b, 0xb6, 0x13, 0x34, 0xbe,
	0xc4, 0x48, 0x17, 0x93, 0xe7, 0x02, 0x83, 0xbd, 0x1b, 0x8c, 0x5d, 0xce, 0xf7, 0x63, 0xdf, 0x52,
	0x0f, 0xd0, 0x41, 0x2e, 0xf4, 0x2a, 0x9c, 0x89, 0x62, 0x55, 0x3c, 0x5f, 0x75, 0x7d, 0x36, 0xe2,
	0x61, 0xd1, 0x32, 0x1f, 0x81, 0xdd, 0x22, 0x8b, 0x74, 0x58, 0x36, 0x72, 0xe4, 0x2e, 0xfd, 0x5d,
	0x80, 0xb3, 0xad, 0x41, 0x2e, 0x88, 0xdc, 0xe0, 0xd7, 0x97, 0x15, 0x9e, 0x8e, 0xd7, 0xfd, 0x48,
	0x80, 0x67, 0x65, 0xdb, 0x34, 0x37, 0x55, 0x6d, 0x27, 0x50, 0x8f, 0x1b, 0xe8, 0xeb, 0xcc, 0x78,
	0x1d, 0x56, 0xab, 0x45, 0xd2, 0x3c, 0x2f, 0x77, 0xe2, 0x43, 0x74, 0xe1, 0x78, 0x43, 0x74, 0xe9,
	0x31, 0xcc, 0x25, 0x8d, 0x66, 0x86, 0xfe, 0x6f, 0x0d, 0x7a, 0x1e, 0xf2, 0x3d, 0xc3, 0x8a, 0xe6,
	0x46, 0xf6, 0x9f, 0xba, 0xd9, 0x9e, 0x61, 0x0d, 0xf2, 0x22, 0xe1, 0x52, 0x3f, 0x3a, 0x98, 0x41,
	0xb3, 0x3d, 0xf5, 0xa3, 0x90, 0x4b, 0xfa, 0xe3, 0x18, 0x14, 0x5a, 0xd8, 0x67, 0xf3, 0xc4, 0xd3,
	0x33, 0xee, 0xe6, 0xc1, 0x91, 0x3e, 0xfb, 0xef, 0xe1, 0x37, 0x87, 0xb5, 0x52, 0x31, 0x44, 0x5f,
	0x7e, 0xb6, 0x3f, 0x91, 0x3c, 0xdb, 0x7f, 0x1a, 0xb3, 0xd4, 0x8f, 0x05, 0xda, 0x80, 0x46, 0x46,
	0xff, 0xa7, 0x66, 0xbe, 0x88, 0x2f, 0xa4, 0xe2, 0xff, 0x73, 0xf7, 0x3e, 0x2c, 0xd2, 0x9c, 0x51,
	0x6b, 0xca, 0xfc, 0x77, 0x04, 0xa7, 0x57, 0x7c, 0xf4, 0xe0, 0xff, 0x2b, 0x76, 0xcf, 0x21, 0x55,
	0xd7, 0x57, 0x70, 0xdc, 0xb5, 0xff, 0x3c, 0x03, 0x79, 0x5e, 0x5c, 0xb3, 0x3c, 0xe1, 0xa2, 0x9f,
	0x0a, 0x90, 0x8d, 0xb6, 0x84, 0x28, 0xf9, 0x6d, 0x4c, 0xe8, 0x3f, 0x8b, 0x2f, 0x1d, 0x81, 0x93,
	0x85, 0xb3, 0xf4, 0xfa, 0xc7, 0x5f, 0xfc, 0xeb, 0x87, 0x63, 0x57, 0x51, 0xa9, 0xb4, 0x7b, 0xb5,
	0xc4, 0x55, 0xf0, 0x4a, 0x8f, 0x07, 0xea, 0x3d, 0x29, 0xd1, 0xae, 0xa4, 0xf4, 0x98, 0xfc, 0xf3,
	0xa4, 0x14, 0xb6, 0x97, 0x3f, 0x11, 0x00, 0x06, 0x13, 0x1a, 0x94, 0xfc, 0xdf, 0xd1, 0x07, 0x46,
	0x38, 0xc5, 0x43, 0xbb, 0x57, 0x69, 0x85, 0xa2, 0x79, 0x0b, 0xdd, 0x3e, 0x26, 0x9a, 0xd2, 0xe3,
	0x81, 0x71, 0x9f, 0xa0, 0x1f, 0x0b, 0x90, 0x8b, 0xcd, 0xaf, 0x50, 0xb2, 0x41, 0x92, 0x66, 0x5c,
	0xc5, 0x11, 0xad, 0x9b, 0x74, 0x93, 0x42, 0xbc, 0x21, 0x1d, 0xd7, 0x60, 0x37, 0x85, 0xcb, 0xe8,
	0x17, 0x02, 0xe4, 0x62, 0xd3, 0xa6, 0x21, 0xc0, 0x92, 0x26, 0x52, 0x23, 0x81, 0xad, 0x52, 0x60,
	0xe5, 0xe2, 0x89, 0x6c, 0x47, 0x50, 0x7e, 0x2e, 0x40, 0x2e, 0x36, 0xdf, 0x19, 0x82, 0x32, 0x69,
	0x06, 0x34, 0x12, 0x65, 0x87, 0xa2, 0x6c, 0x48, 0xf7, 0x4e, 0x84, 0xd2, 0x8b, 0x1e, 0x4d, 0x30,
	0xff, 0x5c, 0x80, 0x5c, 0x6c, 0xe6, 0x33, 0x04, 0x73, 0xd2, 0x5c, 0x68, 0x24, 0x66, 0xee, 0x95,
	0x97, 0x4f, 0xe6, 0x95, 0x9f, 0x0a, 0x90, 0x8f, 0x8f, 0x10, 0xd0, 0xe5, 0xa1, 0x71, 0x7a, 0x60,
	0x46, 0x52, 0xbc, 0x72, 0x24, 0x5e, 0x1e, 0xd5, 0x6f, 0x52, 0xc4, 0xd7, 0xd1, 0xd5, 0x23, 0x22,
	0x8e, 0x8c, 0x23, 0x3e, 0x11, 0x20, 0x1b, 0x1d, 0x09, 0x0d, 0x49, 0x3b, 0x09, 0x53, 0xa3, 0x91,
	0x76, 0x5c, 0xa3, 0xa8, 0xee, 0xa0, 0xb7, 0x8f, 0x8d, 0xaa, 0xf4, 0x38, 0x3a, 0x9f, 0x79, 0x82,
	0x3e, 0x13, 0x60, 0x66, 0xdf, 0xf8, 0x07, 0x25, 0x1b, 0x28, 0x79, 0x48, 0x54, 0x5c, 0x0c, 0x98,
	0x83, 0x5f, 0x9e, 0x2d, 0x57, 0x7b, 0x8e, 0xbf, 0x27, 0xc9, 0x14, 0xe2, 0xba, 0xb4, 0x7a, 0x52,
	0x88, 0x37, 0x35, 0x7a, 0x30, 0xf1, 0xcd, 0x9f, 0x09, 0x30, 0xb3, 0x6f, 0x78, 0x33, 0x04, 0x6c,
	0xf2, 0x88, 0xa7, 0x78, 0x61, 0x48, 0xf8, 0x0d, 0x38, 0xa5, 0x5b, 0x14, 0xf7, 0xab, 0xe8, 0xfa,
	0x11, 0x71, 0x7b, 0x54, 0x98, 0xf7, 0xa0, 0xbf, 0x17, 0x20, 0x17, 0x2b, 0xf6, 0xd0, 0xf0, 0x07,
	0x64, 0x7f, 0xdf, 0x5f, 0xbc, 0x7c, 0x14, 0x56, 0xee, 0x96, 0x75, 0x8a, 0x72, 0x0d, 0xdd, 0x3d,
	0x49, 0x20, 0x95, 0x06, 0x3f, 0xc9, 0xf8, 0x9d, 0x00, 0x99, 0xc8, 0x84, 0x00, 0x5d, 0x1c, 0x66,
	0xd5, 0x7d, 0x33, 0x84, 0xe2, 0xe1, 0x05, 0xab, 0xf4, 0x2d, 0x8a, 0xf3, 0x21, 0xea, 0x3c, 0x1d,
	0x9c, 0xa5, 0xc7, 0xd1, 0x62, 0xfb, 0x09, 0xfa, 0xad, 0x00, 0xf9, 0xf8, 0xe0, 0x69, 0x48, 0x26,
	0x48, 0x9c, 0x4e, 0x8d, 0x0c, 0xb3, 0x77, 0x28, 0xfa, 0xfb, 0xd2, 0x53, 0xb2, 0x32, 0x71, 0xe1,
	0x3f, 0x09, 0x90, 0x8f, 0x8f, 0xa0, 0x86, 0x20, 0x4e, 0x9c, 0x53, 0x8d, 0x44, 0xcc, 0xed, 0x7d,
	0xf9, 0x94, 0xec, 0xfd, 0x0f, 0x01, 0xce, 0x0c, 0x69, 0xb1, 0xd0, 0xf5, 0x44, 0x68, 0x87, 0x37,
	0x64, 0x23, 0xf5, 0x31, 0xa8, 0x3e, 0x9a, 0xf4, 0xed, 0x53, 0xd1, 0xe7, 0xa6, 0xcb, 0xd1, 0x91,
	0x9b, 0xf9, 0xa7, 0x00, 0x0b, 0x89, 0x8d, 0x31, 0xba, 0x3a, 0xec, 0xd1, 0x1e, 0xda, 0x44, 0x8f,
	0xd4, 0xcb, 0xa2, 0x7a, 0x6d, 0x4b, 0xda, 0xa9, 0xe8, 0x55, 0xa2, 0xaf, 0x7a, 0x80, 0x89, 0x28,
	0xf7, 0x99, 0x00, 0xe9, 0xb0, 0x3d, 0x42, 0x2f, 0x1c, 0xa9, 0x7d, 0x1a, 0xa9, 0xc4, 0x03, 0xaa,
	0x44, 0x53, 0xba, 0x7f, 0x22, 0x25, 0xe2, 0xfd, 0x18, 0x01, 0xfb, 0x1b, 0x56, 0x36, 0x45, 0x7e,
	0x83, 0x38, 0xb4, 0x6c, 0x3a, 0xd0, 0x46, 0x8d, 0x04, 0x7d, 0xdc, 0x77, 0x29, 0x19, 0xf4, 0xe0,
	0xd7, 0x5a, 0x04, 0xf0, 0x1f, 0x04, 0x98, 0xd9, 0xd7, 0x4f, 0x0d, 0x79, 0x97, 0x92, 0xbb, 0xae,
	0x91, 0xa0, 0x1f, 0x52, 0xd0, 0xef, 0x48, 0xeb, 0x27, 0xab, 0xf5, 0xe8, 0xe1, 0x4e, 0x70, 0x38,
	0x41, 0xfe, 0x67, 0x01, 0xd0, 0xc1, 0xee, 0x0c, 0x2d, 0x27, 0x27, 0xd1, 0x61, 0x6d, 0xdc, 0x48,
	0xfc, 0xef, 0x51, 0xfc, 0x6d, 0xa9, 0x71, 0x22, 0xfc, 0x5a, 0x70, 0x7e, 0x54, 0x85, 0x3b, 0x16,
	0x9c, 0xd1, 0xec, 0x5e, 0x12, 0x80, 0x3b, 0x73, 0xbc, 0x3c, 0xe5, 0x3f, 0xed, 0x69, 0x92, 0x0a,
	0xa5, 0x29, 0xbc, 0x77, 0x9b, 0xf3, 0x76, 0x6d, 0x53, 0xb5, 0xba, 0xcb, 0xb6, 0xdb, 0x2d, 0x75,
	0xb1, 0x45, 0xeb, 0x97, 0x12, 0x5b, 0x52, 0x1d, 0xc3, 0x8b, 0xfd, 0x50, 0xff, 0x56, 0xf8, 0xb1,
	0x39, 0x49, 0x19, 0xaf, 0xff, 0x37, 0x00, 0x00, 0xff, 0xff, 0xcf, 0xbe, 0xbf, 0xb9, 0xd0, 0x2f,
	0x00, 0x00,
}
