// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/service.proto

package serviceconfig

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_api5 "google.golang.org/genproto/googleapis/api"
import google_api "google.golang.org/genproto/googleapis/api/annotations"
import _ "google.golang.org/genproto/googleapis/api/label"
import google_api3 "google.golang.org/genproto/googleapis/api/metric"
import google_api6 "google.golang.org/genproto/googleapis/api/monitoredres"
import _ "github.com/golang/protobuf/ptypes/any"
import google_protobuf4 "google.golang.org/genproto/protobuf/api"
import google_protobuf3 "google.golang.org/genproto/protobuf/ptype"
import google_protobuf5 "github.com/golang/protobuf/ptypes/wrappers"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// `Service` is the root object of Google service configuration schema. It
// describes basic information about a service, such as the name and the
// title, and delegates other aspects to sub-sections. Each sub-section is
// either a proto message or a repeated proto message that configures a
// specific aspect, such as auth. See each proto message definition for details.
//
// Example:
//
//     type: google.api.Service
//     config_version: 3
//     name: calendar.googleapis.com
//     title: Google Calendar API
//     apis:
//     - name: google.calendar.v3.Calendar
//     authentication:
//       providers:
//       - id: google_calendar_auth
//         jwks_uri: https://www.googleapis.com/oauth2/v1/certs
//         issuer: https://securetoken.google.com
//       rules:
//       - selector: "*"
//         requirements:
//           provider_id: google_calendar_auth
type Service struct {
	// The version of the service configuration. The config version may
	// influence interpretation of the configuration, for example, to
	// determine defaults. This is documented together with applicable
	// options. The current default for the config version itself is `3`.
	ConfigVersion *google_protobuf5.UInt32Value `protobuf:"bytes,20,opt,name=config_version,json=configVersion" json:"config_version,omitempty"`
	// The DNS address at which this service is available,
	// e.g. `calendar.googleapis.com`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A unique ID for a specific instance of this message, typically assigned
	// by the client for tracking purpose. If empty, the server may choose to
	// generate one instead.
	Id string `protobuf:"bytes,33,opt,name=id" json:"id,omitempty"`
	// The product title associated with this service.
	Title string `protobuf:"bytes,2,opt,name=title" json:"title,omitempty"`
	// The id of the Google developer project that owns the service.
	// Members of this project can manage the service configuration,
	// manage consumption of the service, etc.
	ProducerProjectId string `protobuf:"bytes,22,opt,name=producer_project_id,json=producerProjectId" json:"producer_project_id,omitempty"`
	// A list of API interfaces exported by this service. Only the `name` field
	// of the [google.protobuf.Api][google.protobuf.Api] needs to be provided by the configuration
	// author, as the remaining fields will be derived from the IDL during the
	// normalization process. It is an error to specify an API interface here
	// which cannot be resolved against the associated IDL files.
	Apis []*google_protobuf4.Api `protobuf:"bytes,3,rep,name=apis" json:"apis,omitempty"`
	// A list of all proto message types included in this API service.
	// Types referenced directly or indirectly by the `apis` are
	// automatically included.  Messages which are not referenced but
	// shall be included, such as types used by the `google.protobuf.Any` type,
	// should be listed here by name. Example:
	//
	//     types:
	//     - name: google.protobuf.Int32
	Types []*google_protobuf3.Type `protobuf:"bytes,4,rep,name=types" json:"types,omitempty"`
	// A list of all enum types included in this API service.  Enums
	// referenced directly or indirectly by the `apis` are automatically
	// included.  Enums which are not referenced but shall be included
	// should be listed here by name. Example:
	//
	//     enums:
	//     - name: google.someapi.v1.SomeEnum
	Enums []*google_protobuf3.Enum `protobuf:"bytes,5,rep,name=enums" json:"enums,omitempty"`
	// Additional API documentation.
	Documentation *Documentation `protobuf:"bytes,6,opt,name=documentation" json:"documentation,omitempty"`
	// API backend configuration.
	Backend *Backend `protobuf:"bytes,8,opt,name=backend" json:"backend,omitempty"`
	// HTTP configuration.
	Http *google_api.Http `protobuf:"bytes,9,opt,name=http" json:"http,omitempty"`
	// Quota configuration.
	Quota *Quota `protobuf:"bytes,10,opt,name=quota" json:"quota,omitempty"`
	// Auth configuration.
	Authentication *Authentication `protobuf:"bytes,11,opt,name=authentication" json:"authentication,omitempty"`
	// Context configuration.
	Context *Context `protobuf:"bytes,12,opt,name=context" json:"context,omitempty"`
	// Configuration controlling usage of this service.
	Usage *Usage `protobuf:"bytes,15,opt,name=usage" json:"usage,omitempty"`
	// Configuration for network endpoints.  If this is empty, then an endpoint
	// with the same name as the service is automatically generated to service all
	// defined APIs.
	Endpoints []*Endpoint `protobuf:"bytes,18,rep,name=endpoints" json:"endpoints,omitempty"`
	// Configuration for the service control plane.
	Control *Control `protobuf:"bytes,21,opt,name=control" json:"control,omitempty"`
	// Defines the logs used by this service.
	Logs []*LogDescriptor `protobuf:"bytes,23,rep,name=logs" json:"logs,omitempty"`
	// Defines the metrics used by this service.
	Metrics []*google_api3.MetricDescriptor `protobuf:"bytes,24,rep,name=metrics" json:"metrics,omitempty"`
	// Defines the monitored resources used by this service. This is required
	// by the [Service.monitoring][google.api.Service.monitoring] and [Service.logging][google.api.Service.logging] configurations.
	MonitoredResources []*google_api6.MonitoredResourceDescriptor `protobuf:"bytes,25,rep,name=monitored_resources,json=monitoredResources" json:"monitored_resources,omitempty"`
	// Logging configuration.
	Logging *Logging `protobuf:"bytes,27,opt,name=logging" json:"logging,omitempty"`
	// Monitoring configuration.
	Monitoring *Monitoring `protobuf:"bytes,28,opt,name=monitoring" json:"monitoring,omitempty"`
	// System parameter configuration.
	SystemParameters *SystemParameters `protobuf:"bytes,29,opt,name=system_parameters,json=systemParameters" json:"system_parameters,omitempty"`
	// Output only. The source information for this configuration if available.
	SourceInfo *SourceInfo `protobuf:"bytes,37,opt,name=source_info,json=sourceInfo" json:"source_info,omitempty"`
	// Experimental configuration.
	Experimental *google_api5.Experimental `protobuf:"bytes,101,opt,name=experimental" json:"experimental,omitempty"`
}

func (m *Service) Reset()                    { *m = Service{} }
func (m *Service) String() string            { return proto.CompactTextString(m) }
func (*Service) ProtoMessage()               {}
func (*Service) Descriptor() ([]byte, []int) { return fileDescriptor12, []int{0} }

func (m *Service) GetConfigVersion() *google_protobuf5.UInt32Value {
	if m != nil {
		return m.ConfigVersion
	}
	return nil
}

func (m *Service) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Service) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Service) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Service) GetProducerProjectId() string {
	if m != nil {
		return m.ProducerProjectId
	}
	return ""
}

func (m *Service) GetApis() []*google_protobuf4.Api {
	if m != nil {
		return m.Apis
	}
	return nil
}

func (m *Service) GetTypes() []*google_protobuf3.Type {
	if m != nil {
		return m.Types
	}
	return nil
}

func (m *Service) GetEnums() []*google_protobuf3.Enum {
	if m != nil {
		return m.Enums
	}
	return nil
}

func (m *Service) GetDocumentation() *Documentation {
	if m != nil {
		return m.Documentation
	}
	return nil
}

func (m *Service) GetBackend() *Backend {
	if m != nil {
		return m.Backend
	}
	return nil
}

func (m *Service) GetHttp() *google_api.Http {
	if m != nil {
		return m.Http
	}
	return nil
}

func (m *Service) GetQuota() *Quota {
	if m != nil {
		return m.Quota
	}
	return nil
}

func (m *Service) GetAuthentication() *Authentication {
	if m != nil {
		return m.Authentication
	}
	return nil
}

func (m *Service) GetContext() *Context {
	if m != nil {
		return m.Context
	}
	return nil
}

func (m *Service) GetUsage() *Usage {
	if m != nil {
		return m.Usage
	}
	return nil
}

func (m *Service) GetEndpoints() []*Endpoint {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

func (m *Service) GetControl() *Control {
	if m != nil {
		return m.Control
	}
	return nil
}

func (m *Service) GetLogs() []*LogDescriptor {
	if m != nil {
		return m.Logs
	}
	return nil
}

func (m *Service) GetMetrics() []*google_api3.MetricDescriptor {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *Service) GetMonitoredResources() []*google_api6.MonitoredResourceDescriptor {
	if m != nil {
		return m.MonitoredResources
	}
	return nil
}

func (m *Service) GetLogging() *Logging {
	if m != nil {
		return m.Logging
	}
	return nil
}

func (m *Service) GetMonitoring() *Monitoring {
	if m != nil {
		return m.Monitoring
	}
	return nil
}

func (m *Service) GetSystemParameters() *SystemParameters {
	if m != nil {
		return m.SystemParameters
	}
	return nil
}

func (m *Service) GetSourceInfo() *SourceInfo {
	if m != nil {
		return m.SourceInfo
	}
	return nil
}

func (m *Service) GetExperimental() *google_api5.Experimental {
	if m != nil {
		return m.Experimental
	}
	return nil
}

func init() {
	proto.RegisterType((*Service)(nil), "google.api.Service")
}

func init() { proto.RegisterFile("google/api/service.proto", fileDescriptor12) }

var fileDescriptor12 = []byte{
	// 809 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x95, 0xdd, 0x6e, 0xdb, 0x36,
	0x14, 0x80, 0x61, 0xd7, 0x6e, 0x66, 0x3a, 0xcd, 0x1a, 0xc6, 0x49, 0x19, 0xd7, 0x1b, 0xd2, 0xfd,
	0xa0, 0xc6, 0x86, 0xca, 0x80, 0x0b, 0x74, 0x17, 0x1b, 0x30, 0xc4, 0x6d, 0xb0, 0x19, 0xe8, 0x00,
	0x8f, 0x59, 0x8b, 0x61, 0x37, 0x06, 0x2d, 0xd1, 0x0a, 0x37, 0x89, 0xe4, 0x48, 0x2a, 0x8b, 0x5f,
	0x67, 0xcf, 0xb6, 0x07, 0x19, 0x44, 0x52, 0x31, 0x65, 0x39, 0x77, 0xd6, 0xf9, 0xbe, 0x73, 0x7c,
	0x28, 0x92, 0x47, 0x00, 0xa5, 0x42, 0xa4, 0x19, 0x9d, 0x10, 0xc9, 0x26, 0x9a, 0xaa, 0x5b, 0x16,
	0xd3, 0x48, 0x2a, 0x61, 0x04, 0x04, 0x8e, 0x44, 0x44, 0xb2, 0xe1, 0x28, 0xb0, 0x08, 0xe7, 0xc2,
	0x10, 0xc3, 0x04, 0xd7, 0xce, 0x1c, 0x9e, 0x86, 0xb4, 0x30, 0x37, 0x3e, 0x1c, 0x96, 0x5e, 0x91,
	0xf8, 0x2f, 0xca, 0x93, 0x3d, 0x24, 0x16, 0xdc, 0xd0, 0x3b, 0xf3, 0x00, 0x51, 0x22, 0xf3, 0xe4,
	0xf3, 0x80, 0x24, 0x22, 0x2e, 0x72, 0xca, 0x5d, 0x17, 0x9e, 0x9f, 0x07, 0x9c, 0xf2, 0x44, 0x0a,
	0xc6, 0xab, 0xa2, 0xdf, 0x84, 0xe8, 0x4e, 0x52, 0xc5, 0x6c, 0x72, 0x56, 0x7b, 0xd8, 0xb3, 0x96,
	0x1b, 0x63, 0xa4, 0x0f, 0x9f, 0x05, 0xe1, 0x8c, 0xac, 0x68, 0xa5, 0x0f, 0xc2, 0xb8, 0x48, 0xf7,
	0xac, 0x22, 0x13, 0x69, 0xca, 0x78, 0x45, 0x9e, 0x05, 0x24, 0xa7, 0x46, 0xb1, 0xd8, 0x83, 0x2f,
	0x43, 0x20, 0x38, 0x33, 0x42, 0xd1, 0x64, 0xa9, 0xa8, 0x16, 0x85, 0xaa, 0xb6, 0x64, 0xf8, 0xbc,
	0x29, 0x6d, 0x4b, 0x87, 0x2d, 0xfe, 0x5d, 0x08, 0x43, 0x7c, 0x3c, 0xdc, 0x3b, 0x57, 0x6d, 0xc9,
	0xf8, 0x5a, 0x78, 0xfa, 0x22, 0xa4, 0x1b, 0x6d, 0x68, 0xbe, 0x94, 0x44, 0x91, 0x9c, 0x1a, 0xaa,
	0xf6, 0x14, 0x2e, 0x34, 0x49, 0xe9, 0xce, 0x1b, 0xb7, 0x4f, 0xab, 0x62, 0x3d, 0x21, 0x7c, 0xf3,
	0x20, 0x92, 0xcc, 0xa3, 0xe1, 0x2e, 0x32, 0x1b, 0x49, 0x77, 0xf6, 0xf8, 0x9e, 0xfd, 0xa3, 0x88,
	0x94, 0x54, 0xf9, 0x83, 0xf6, 0xc5, 0x7f, 0x3d, 0x70, 0x70, 0xed, 0x0e, 0x29, 0x7c, 0x0b, 0x8e,
	0x62, 0xc1, 0xd7, 0x2c, 0x5d, 0xde, 0x52, 0xa5, 0x99, 0xe0, 0x68, 0x70, 0xd1, 0x1a, 0xf7, 0xa7,
	0xa3, 0xc8, 0x9f, 0xdb, 0xaa, 0x48, 0xf4, 0x61, 0xce, 0xcd, 0xeb, 0xe9, 0x47, 0x92, 0x15, 0x14,
	0x3f, 0x71, 0x39, 0x1f, 0x5d, 0x0a, 0x84, 0xa0, 0xc3, 0x49, 0x4e, 0x51, 0xeb, 0xa2, 0x35, 0xee,
	0x61, 0xfb, 0x1b, 0x1e, 0x81, 0x36, 0x4b, 0xd0, 0x0b, 0x1b, 0x69, 0xb3, 0x04, 0x0e, 0x40, 0xd7,
	0x30, 0x93, 0x51, 0xd4, 0xb6, 0x21, 0xf7, 0x00, 0x23, 0x70, 0x22, 0x95, 0x48, 0x8a, 0x98, 0xaa,
	0xa5, 0x54, 0xe2, 0x4f, 0x1a, 0x9b, 0x25, 0x4b, 0xd0, 0x99, 0x75, 0x8e, 0x2b, 0xb4, 0x70, 0x64,
	0x9e, 0xc0, 0x31, 0xe8, 0x10, 0xc9, 0x34, 0x7a, 0x74, 0xf1, 0x68, 0xdc, 0x9f, 0x0e, 0x1a, 0x4d,
	0x5e, 0x4a, 0x86, 0xad, 0x01, 0xbf, 0x05, 0xdd, 0xf2, 0x95, 0x68, 0xd4, 0xb1, 0xea, 0x69, 0x43,
	0xfd, 0x6d, 0x23, 0x29, 0x76, 0x4e, 0x29, 0x53, 0x5e, 0xe4, 0x1a, 0x75, 0x1f, 0x90, 0xaf, 0x78,
	0x91, 0x63, 0xe7, 0xc0, 0x1f, 0xc1, 0x93, 0xda, 0xcd, 0x41, 0x8f, 0xed, 0x1b, 0x3b, 0x8f, 0xb6,
	0x37, 0x3d, 0x7a, 0x17, 0x0a, 0xb8, 0xee, 0xc3, 0x57, 0xe0, 0xc0, 0x5f, 0x64, 0xf4, 0x89, 0x4d,
	0x3d, 0x09, 0x53, 0x67, 0x0e, 0xe1, 0xca, 0x81, 0x5f, 0x81, 0x4e, 0x79, 0x85, 0x50, 0xcf, 0xba,
	0x4f, 0x43, 0xf7, 0x67, 0x63, 0x24, 0xb6, 0x14, 0xbe, 0x04, 0x5d, 0x7b, 0x5c, 0x11, 0xb0, 0xda,
	0x71, 0xa8, 0xfd, 0x5a, 0x02, 0xec, 0x38, 0x9c, 0x81, 0xa3, 0x72, 0xba, 0x50, 0x6e, 0x58, 0xec,
	0xfa, 0xef, 0xdb, 0x8c, 0x61, 0x98, 0x71, 0x59, 0x33, 0xf0, 0x4e, 0x46, 0xb9, 0x02, 0x3f, 0x70,
	0xd0, 0x61, 0x73, 0x05, 0x6f, 0x1d, 0xc2, 0x95, 0x53, 0xf6, 0x66, 0x4f, 0x3c, 0xfa, 0xb4, 0xd9,
	0xdb, 0x87, 0x12, 0x60, 0xc7, 0xe1, 0x14, 0xf4, 0xaa, 0xa1, 0xa3, 0x11, 0xac, 0xef, 0x71, 0x29,
	0x5f, 0x79, 0x88, 0xb7, 0x5a, 0xd5, 0x8b, 0x12, 0x19, 0x3a, 0xdd, 0xdf, 0x8b, 0x12, 0x19, 0xae,
	0x1c, 0xf8, 0x0a, 0x74, 0x32, 0x91, 0x6a, 0xf4, 0xcc, 0x56, 0xaf, 0x6d, 0xda, 0x7b, 0x91, 0xbe,
	0xa3, 0x3a, 0x56, 0x4c, 0x1a, 0xa1, 0xb0, 0xd5, 0xe0, 0x1b, 0x70, 0xe0, 0x06, 0x8c, 0x46, 0xc8,
	0x66, 0x8c, 0xc2, 0x8c, 0x5f, 0x2c, 0x0a, 0x92, 0x2a, 0x19, 0xfe, 0x0e, 0x4e, 0x9a, 0xf3, 0x47,
	0xa3, 0x73, 0x5b, 0xe3, 0x65, 0xad, 0x46, 0xa5, 0x61, 0x6f, 0x05, 0xe5, 0x60, 0xbe, 0x0b, 0xed,
	0x7a, 0xfd, 0x30, 0x44, 0xcf, 0x9b, 0xeb, 0x7d, 0xef, 0x10, 0xae, 0x1c, 0xf8, 0x06, 0x80, 0xed,
	0x8c, 0x43, 0x23, 0x9b, 0x71, 0xb6, 0xe7, 0xff, 0xcb, 0xa4, 0xc0, 0x84, 0x73, 0x70, 0xbc, 0x3b,
	0xc8, 0x34, 0xfa, 0xac, 0x3e, 0x1b, 0xca, 0xf4, 0x6b, 0x2b, 0x2d, 0xee, 0x1d, 0xfc, 0x54, 0xef,
	0x44, 0xe0, 0x77, 0xa0, 0x1f, 0x4c, 0x4c, 0xf4, 0x75, 0xb3, 0x87, 0x6b, 0x8b, 0xe7, 0x7c, 0x2d,
	0x30, 0xd0, 0xf7, 0xbf, 0xe1, 0x0f, 0xe0, 0x30, 0xfc, 0xb6, 0x20, 0x6a, 0x33, 0x51, 0xed, 0x44,
	0x04, 0x1c, 0xd7, 0xec, 0x19, 0x2f, 0x47, 0x5b, 0x1e, 0xc8, 0xb3, 0x43, 0x3f, 0xf5, 0x16, 0xe5,
	0xb5, 0x5e, 0xb4, 0xfe, 0xb8, 0xf2, 0x2c, 0x15, 0x19, 0xe1, 0x69, 0x24, 0x54, 0x3a, 0x49, 0x29,
	0xb7, 0x97, 0x7e, 0xe2, 0x50, 0x39, 0x4a, 0xc2, 0x8f, 0xba, 0x9b, 0x7b, 0xdf, 0xd7, 0x9e, 0xfe,
	0x6d, 0x77, 0x7e, 0xba, 0x5c, 0xcc, 0x57, 0x8f, 0x6d, 0xe2, 0xeb, 0xff, 0x03, 0x00, 0x00, 0xff,
	0xff, 0xcc, 0xae, 0xb3, 0x8f, 0x0c, 0x08, 0x00, 0x00,
}
