// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/monitoring/v3/metric.proto

package monitoring

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_api5 "google.golang.org/genproto/googleapis/api/metric"
import google_api4 "google.golang.org/genproto/googleapis/api/monitoredres"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A single data point in a time series.
type Point struct {
	// The time interval to which the data point applies.  For GAUGE metrics, only
	// the end time of the interval is used.  For DELTA metrics, the start and end
	// time should specify a non-zero interval, with subsequent points specifying
	// contiguous and non-overlapping intervals.  For CUMULATIVE metrics, the
	// start and end time should specify a non-zero interval, with subsequent
	// points specifying the same start time and increasing end times, until an
	// event resets the cumulative value to zero and sets a new start time for the
	// following points.
	Interval *TimeInterval `protobuf:"bytes,1,opt,name=interval" json:"interval,omitempty"`
	// The value of the data point.
	Value *TypedValue `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *Point) Reset()                    { *m = Point{} }
func (m *Point) String() string            { return proto.CompactTextString(m) }
func (*Point) ProtoMessage()               {}
func (*Point) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *Point) GetInterval() *TimeInterval {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *Point) GetValue() *TypedValue {
	if m != nil {
		return m.Value
	}
	return nil
}

// A collection of data points that describes the time-varying values
// of a metric. A time series is identified by a combination of a
// fully-specified monitored resource and a fully-specified metric.
// This type is used for both listing and creating time series.
type TimeSeries struct {
	// The associated metric. A fully-specified metric used to identify the time
	// series.
	Metric *google_api5.Metric `protobuf:"bytes,1,opt,name=metric" json:"metric,omitempty"`
	// The associated resource. A fully-specified monitored resource used to
	// identify the time series.
	Resource *google_api4.MonitoredResource `protobuf:"bytes,2,opt,name=resource" json:"resource,omitempty"`
	// The metric kind of the time series. When listing time series, this metric
	// kind might be different from the metric kind of the associated metric if
	// this time series is an alignment or reduction of other time series.
	//
	// When creating a time series, this field is optional. If present, it must be
	// the same as the metric kind of the associated metric. If the associated
	// metric's descriptor must be auto-created, then this field specifies the
	// metric kind of the new descriptor and must be either `GAUGE` (the default)
	// or `CUMULATIVE`.
	MetricKind google_api5.MetricDescriptor_MetricKind `protobuf:"varint,3,opt,name=metric_kind,json=metricKind,enum=google.api.MetricDescriptor_MetricKind" json:"metric_kind,omitempty"`
	// The value type of the time series. When listing time series, this value
	// type might be different from the value type of the associated metric if
	// this time series is an alignment or reduction of other time series.
	//
	// When creating a time series, this field is optional. If present, it must be
	// the same as the type of the data in the `points` field.
	ValueType google_api5.MetricDescriptor_ValueType `protobuf:"varint,4,opt,name=value_type,json=valueType,enum=google.api.MetricDescriptor_ValueType" json:"value_type,omitempty"`
	// The data points of this time series. When listing time series, the order of
	// the points is specified by the list method.
	//
	// When creating a time series, this field must contain exactly one point and
	// the point's type must be the same as the value type of the associated
	// metric. If the associated metric's descriptor must be auto-created, then
	// the value type of the descriptor is determined by the point's type, which
	// must be `BOOL`, `INT64`, `DOUBLE`, or `DISTRIBUTION`.
	Points []*Point `protobuf:"bytes,5,rep,name=points" json:"points,omitempty"`
}

func (m *TimeSeries) Reset()                    { *m = TimeSeries{} }
func (m *TimeSeries) String() string            { return proto.CompactTextString(m) }
func (*TimeSeries) ProtoMessage()               {}
func (*TimeSeries) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

func (m *TimeSeries) GetMetric() *google_api5.Metric {
	if m != nil {
		return m.Metric
	}
	return nil
}

func (m *TimeSeries) GetResource() *google_api4.MonitoredResource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *TimeSeries) GetMetricKind() google_api5.MetricDescriptor_MetricKind {
	if m != nil {
		return m.MetricKind
	}
	return google_api5.MetricDescriptor_METRIC_KIND_UNSPECIFIED
}

func (m *TimeSeries) GetValueType() google_api5.MetricDescriptor_ValueType {
	if m != nil {
		return m.ValueType
	}
	return google_api5.MetricDescriptor_VALUE_TYPE_UNSPECIFIED
}

func (m *TimeSeries) GetPoints() []*Point {
	if m != nil {
		return m.Points
	}
	return nil
}

func init() {
	proto.RegisterType((*Point)(nil), "google.monitoring.v3.Point")
	proto.RegisterType((*TimeSeries)(nil), "google.monitoring.v3.TimeSeries")
}

func init() { proto.RegisterFile("google/monitoring/v3/metric.proto", fileDescriptor3) }

var fileDescriptor3 = []byte{
	// 384 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x92, 0x51, 0x4b, 0xeb, 0x30,
	0x14, 0xc7, 0xe9, 0x76, 0x37, 0x76, 0x53, 0xb8, 0x0f, 0xe1, 0xc2, 0x2d, 0xbb, 0x08, 0x75, 0x82,
	0x0e, 0x1f, 0x5a, 0x58, 0x41, 0x10, 0x61, 0x0f, 0x53, 0x51, 0x11, 0x61, 0x44, 0xd9, 0x83, 0x2f,
	0xa3, 0xb6, 0xa1, 0x04, 0xdb, 0x9c, 0x90, 0x66, 0x85, 0x3d, 0xf9, 0xe6, 0x87, 0xf1, 0x1b, 0xf8,
	0xed, 0xa4, 0x49, 0xba, 0x39, 0xac, 0xbe, 0xa5, 0x3d, 0xbf, 0xff, 0xff, 0x9f, 0x73, 0x4e, 0xd0,
	0x7e, 0x06, 0x90, 0xe5, 0x34, 0x2c, 0x80, 0x33, 0x05, 0x92, 0xf1, 0x2c, 0xac, 0xa2, 0xb0, 0xa0,
	0x4a, 0xb2, 0x24, 0x10, 0x12, 0x14, 0xe0, 0xbf, 0x06, 0x09, 0xb6, 0x48, 0x50, 0x45, 0xc3, 0x7f,
	0x56, 0x18, 0x0b, 0xb6, 0x83, 0x0f, 0x0f, 0x3e, 0x17, 0x8c, 0x84, 0xa6, 0x4b, 0x49, 0x4b, 0x58,
	0xc9, 0x84, 0x5a, 0xa8, 0x3d, 0x36, 0x81, 0xa2, 0x00, 0x6e, 0x90, 0xd1, 0x0b, 0xea, 0xcd, 0x81,
	0x71, 0x85, 0xa7, 0x68, 0xc0, 0xb8, 0xa2, 0xb2, 0x8a, 0x73, 0xcf, 0xf1, 0x9d, 0xb1, 0x3b, 0x19,
	0x05, 0x6d, 0x57, 0x0a, 0x1e, 0x58, 0x41, 0x6f, 0x2c, 0x49, 0x36, 0x1a, 0x7c, 0x82, 0x7a, 0x55,
	0x9c, 0xaf, 0xa8, 0xd7, 0xd1, 0x62, 0xff, 0x1b, 0xf1, 0x5a, 0xd0, 0x74, 0x51, 0x73, 0xc4, 0xe0,
	0xa3, 0xf7, 0x0e, 0x42, 0xb5, 0xe5, 0x3d, 0x95, 0x8c, 0x96, 0xf8, 0x18, 0xf5, 0x4d, 0x9f, 0xf6,
	0x12, 0xb8, 0xf1, 0x89, 0x05, 0x0b, 0xee, 0x74, 0x85, 0x58, 0x02, 0x9f, 0xa2, 0x41, 0xd3, 0xb0,
	0x4d, 0xdd, 0xdb, 0xa1, 0x9b, 0xb1, 0x10, 0x0b, 0x91, 0x0d, 0x8e, 0xaf, 0x91, 0x6b, 0x4c, 0x96,
	0xcf, 0x8c, 0xa7, 0x5e, 0xd7, 0x77, 0xc6, 0x7f, 0x26, 0x47, 0x5f, 0xb3, 0x2e, 0x68, 0x99, 0x48,
	0x26, 0x14, 0x48, 0xfb, 0xe3, 0x96, 0xf1, 0x94, 0xa0, 0x62, 0x73, 0xc6, 0x97, 0x08, 0xe9, 0x46,
	0x96, 0x6a, 0x2d, 0xa8, 0xf7, 0x4b, 0x1b, 0x1d, 0xfe, 0x68, 0xa4, 0xdb, 0xaf, 0x07, 0x41, 0x7e,
	0x57, 0xcd, 0x11, 0x47, 0xa8, 0x2f, 0xea, 0x3d, 0x94, 0x5e, 0xcf, 0xef, 0x8e, 0xdd, 0xc9, 0xff,
	0xf6, 0xf9, 0xe9, 0x5d, 0x11, 0x8b, 0xce, 0x5e, 0x1d, 0xe4, 0x25, 0x50, 0xb4, 0xa2, 0x33, 0xd7,
	0x04, 0xcf, 0xeb, 0x35, 0xcf, 0x9d, 0xc7, 0xa9, 0x85, 0x32, 0xc8, 0x63, 0x9e, 0x05, 0x20, 0xb3,
	0x30, 0xa3, 0x5c, 0x3f, 0x82, 0xd0, 0x94, 0x62, 0xc1, 0xca, 0xdd, 0xa7, 0x72, 0xb6, 0xfd, 0x7a,
	0xeb, 0x0c, 0xaf, 0x8c, 0xc1, 0x79, 0x0e, 0xab, 0xb4, 0x19, 0x6e, 0x9d, 0xb5, 0x88, 0x9e, 0xfa,
	0xda, 0x27, 0xfa, 0x08, 0x00, 0x00, 0xff, 0xff, 0xd5, 0xab, 0x3f, 0xd9, 0xe8, 0x02, 0x00, 0x00,
}
