// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/servicecontrol/v1/service_controller.proto

package servicecontrol

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Request message for the Check method.
type CheckRequest struct {
	// The service name as specified in its service configuration. For example,
	// `"pubsub.googleapis.com"`.
	//
	// See [google.api.Service][google.api.Service] for the definition of a service name.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// The operation to be checked.
	Operation *Operation `protobuf:"bytes,2,opt,name=operation" json:"operation,omitempty"`
	// Specifies which version of service configuration should be used to process
	// the request.
	//
	// If unspecified or no matching version can be found, the
	// latest one will be used.
	ServiceConfigId string `protobuf:"bytes,4,opt,name=service_config_id,json=serviceConfigId" json:"service_config_id,omitempty"`
}

func (m *CheckRequest) Reset()                    { *m = CheckRequest{} }
func (m *CheckRequest) String() string            { return proto.CompactTextString(m) }
func (*CheckRequest) ProtoMessage()               {}
func (*CheckRequest) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{0} }

func (m *CheckRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *CheckRequest) GetOperation() *Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *CheckRequest) GetServiceConfigId() string {
	if m != nil {
		return m.ServiceConfigId
	}
	return ""
}

// Response message for the Check method.
type CheckResponse struct {
	// The same operation_id value used in the CheckRequest.
	// Used for logging and diagnostics purposes.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	// Indicate the decision of the check.
	//
	// If no check errors are present, the service should process the operation.
	// Otherwise the service should use the list of errors to determine the
	// appropriate action.
	CheckErrors []*CheckError `protobuf:"bytes,2,rep,name=check_errors,json=checkErrors" json:"check_errors,omitempty"`
	// The actual config id used to process the request.
	ServiceConfigId string `protobuf:"bytes,5,opt,name=service_config_id,json=serviceConfigId" json:"service_config_id,omitempty"`
}

func (m *CheckResponse) Reset()                    { *m = CheckResponse{} }
func (m *CheckResponse) String() string            { return proto.CompactTextString(m) }
func (*CheckResponse) ProtoMessage()               {}
func (*CheckResponse) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{1} }

func (m *CheckResponse) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *CheckResponse) GetCheckErrors() []*CheckError {
	if m != nil {
		return m.CheckErrors
	}
	return nil
}

func (m *CheckResponse) GetServiceConfigId() string {
	if m != nil {
		return m.ServiceConfigId
	}
	return ""
}

// Request message for the Report method.
type ReportRequest struct {
	// The service name as specified in its service configuration. For example,
	// `"pubsub.googleapis.com"`.
	//
	// See [google.api.Service][google.api.Service] for the definition of a service name.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName" json:"service_name,omitempty"`
	// Operations to be reported.
	//
	// Typically the service should report one operation per request.
	// Putting multiple operations into a single request is allowed, but should
	// be used only when multiple operations are natually available at the time
	// of the report.
	//
	// If multiple operations are in a single request, the total request size
	// should be no larger than 1MB. See [ReportResponse.report_errors][google.api.servicecontrol.v1.ReportResponse.report_errors] for
	// partial failure behavior.
	Operations []*Operation `protobuf:"bytes,2,rep,name=operations" json:"operations,omitempty"`
	// Specifies which version of service config should be used to process the
	// request.
	//
	// If unspecified or no matching version can be found, the
	// latest one will be used.
	ServiceConfigId string `protobuf:"bytes,3,opt,name=service_config_id,json=serviceConfigId" json:"service_config_id,omitempty"`
}

func (m *ReportRequest) Reset()                    { *m = ReportRequest{} }
func (m *ReportRequest) String() string            { return proto.CompactTextString(m) }
func (*ReportRequest) ProtoMessage()               {}
func (*ReportRequest) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{2} }

func (m *ReportRequest) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *ReportRequest) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *ReportRequest) GetServiceConfigId() string {
	if m != nil {
		return m.ServiceConfigId
	}
	return ""
}

// Response message for the Report method.
type ReportResponse struct {
	// Partial failures, one for each `Operation` in the request that failed
	// processing. There are three possible combinations of the RPC status:
	//
	// 1. The combination of a successful RPC status and an empty `report_errors`
	//    list indicates a complete success where all `Operations` in the
	//    request are processed successfully.
	// 2. The combination of a successful RPC status and a non-empty
	//    `report_errors` list indicates a partial success where some
	//    `Operations` in the request succeeded. Each
	//    `Operation` that failed processing has a corresponding item
	//    in this list.
	// 3. A failed RPC status indicates a complete failure where none of the
	//    `Operations` in the request succeeded.
	ReportErrors []*ReportResponse_ReportError `protobuf:"bytes,1,rep,name=report_errors,json=reportErrors" json:"report_errors,omitempty"`
	// The actual config id used to process the request.
	ServiceConfigId string `protobuf:"bytes,2,opt,name=service_config_id,json=serviceConfigId" json:"service_config_id,omitempty"`
}

func (m *ReportResponse) Reset()                    { *m = ReportResponse{} }
func (m *ReportResponse) String() string            { return proto.CompactTextString(m) }
func (*ReportResponse) ProtoMessage()               {}
func (*ReportResponse) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{3} }

func (m *ReportResponse) GetReportErrors() []*ReportResponse_ReportError {
	if m != nil {
		return m.ReportErrors
	}
	return nil
}

func (m *ReportResponse) GetServiceConfigId() string {
	if m != nil {
		return m.ServiceConfigId
	}
	return ""
}

// Represents the processing error of one `Operation` in the request.
type ReportResponse_ReportError struct {
	// The [Operation.operation_id][google.api.servicecontrol.v1.Operation.operation_id] value from the request.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	// Details of the error when processing the `Operation`.
	Status *google_rpc.Status `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
}

func (m *ReportResponse_ReportError) Reset()                    { *m = ReportResponse_ReportError{} }
func (m *ReportResponse_ReportError) String() string            { return proto.CompactTextString(m) }
func (*ReportResponse_ReportError) ProtoMessage()               {}
func (*ReportResponse_ReportError) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{3, 0} }

func (m *ReportResponse_ReportError) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *ReportResponse_ReportError) GetStatus() *google_rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func init() {
	proto.RegisterType((*CheckRequest)(nil), "google.api.servicecontrol.v1.CheckRequest")
	proto.RegisterType((*CheckResponse)(nil), "google.api.servicecontrol.v1.CheckResponse")
	proto.RegisterType((*ReportRequest)(nil), "google.api.servicecontrol.v1.ReportRequest")
	proto.RegisterType((*ReportResponse)(nil), "google.api.servicecontrol.v1.ReportResponse")
	proto.RegisterType((*ReportResponse_ReportError)(nil), "google.api.servicecontrol.v1.ReportResponse.ReportError")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ServiceController service

type ServiceControllerClient interface {
	// Checks an operation with Google Service Control to decide whether
	// the given operation should proceed. It should be called before the
	// operation is executed.
	//
	// If feasible, the client should cache the check results and reuse them for
	// up to 60s. In case of server errors, the client may rely on the cached
	// results for longer time.
	//
	// This method requires the `servicemanagement.services.check` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error)
	// Reports operations to Google Service Control. It should be called
	// after the operation is completed.
	//
	// If feasible, the client should aggregate reporting data for up to 5s to
	// reduce API traffic. Limiting aggregation to 5s is to reduce data loss
	// during client crashes. Clients should carefully choose the aggregation
	// window to avoid data loss risk more than 0.01% for business and
	// compliance reasons.
	//
	// This method requires the `servicemanagement.services.report` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Report(ctx context.Context, in *ReportRequest, opts ...grpc.CallOption) (*ReportResponse, error)
}

type serviceControllerClient struct {
	cc *grpc.ClientConn
}

func NewServiceControllerClient(cc *grpc.ClientConn) ServiceControllerClient {
	return &serviceControllerClient{cc}
}

func (c *serviceControllerClient) Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error) {
	out := new(CheckResponse)
	err := grpc.Invoke(ctx, "/google.api.servicecontrol.v1.ServiceController/Check", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *serviceControllerClient) Report(ctx context.Context, in *ReportRequest, opts ...grpc.CallOption) (*ReportResponse, error) {
	out := new(ReportResponse)
	err := grpc.Invoke(ctx, "/google.api.servicecontrol.v1.ServiceController/Report", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ServiceController service

type ServiceControllerServer interface {
	// Checks an operation with Google Service Control to decide whether
	// the given operation should proceed. It should be called before the
	// operation is executed.
	//
	// If feasible, the client should cache the check results and reuse them for
	// up to 60s. In case of server errors, the client may rely on the cached
	// results for longer time.
	//
	// This method requires the `servicemanagement.services.check` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Check(context.Context, *CheckRequest) (*CheckResponse, error)
	// Reports operations to Google Service Control. It should be called
	// after the operation is completed.
	//
	// If feasible, the client should aggregate reporting data for up to 5s to
	// reduce API traffic. Limiting aggregation to 5s is to reduce data loss
	// during client crashes. Clients should carefully choose the aggregation
	// window to avoid data loss risk more than 0.01% for business and
	// compliance reasons.
	//
	// This method requires the `servicemanagement.services.report` permission
	// on the specified service. For more information, see
	// [Google Cloud IAM](https://cloud.google.com/iam).
	Report(context.Context, *ReportRequest) (*ReportResponse, error)
}

func RegisterServiceControllerServer(s *grpc.Server, srv ServiceControllerServer) {
	s.RegisterService(&_ServiceController_serviceDesc, srv)
}

func _ServiceController_Check_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceControllerServer).Check(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicecontrol.v1.ServiceController/Check",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceControllerServer).Check(ctx, req.(*CheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ServiceController_Report_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServiceControllerServer).Report(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.api.servicecontrol.v1.ServiceController/Report",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServiceControllerServer).Report(ctx, req.(*ReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ServiceController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.api.servicecontrol.v1.ServiceController",
	HandlerType: (*ServiceControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Check",
			Handler:    _ServiceController_Check_Handler,
		},
		{
			MethodName: "Report",
			Handler:    _ServiceController_Report_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/api/servicecontrol/v1/service_controller.proto",
}

func init() {
	proto.RegisterFile("google/api/servicecontrol/v1/service_controller.proto", fileDescriptor5)
}

var fileDescriptor5 = []byte{
	// 537 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0xcf, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0xb5, 0xee, 0x1f, 0xa9, 0xe3, 0x04, 0xd4, 0x3d, 0x40, 0x64, 0xf5, 0x90, 0xfa, 0x40,
	0x23, 0x37, 0xd8, 0x6a, 0x10, 0x12, 0x0a, 0x27, 0x1a, 0x55, 0x55, 0x41, 0x82, 0xca, 0xb9, 0x21,
	0x50, 0xb4, 0x38, 0x8b, 0xb1, 0x48, 0xbc, 0xcb, 0xae, 0x9b, 0x0b, 0xe2, 0xc2, 0x03, 0x70, 0x28,
	0x6f, 0x80, 0x90, 0x38, 0xf0, 0x04, 0x3c, 0x07, 0xaf, 0xc0, 0x43, 0xc0, 0x0d, 0x79, 0x77, 0xed,
	0x3a, 0xc2, 0x58, 0xee, 0x2d, 0x9e, 0x9d, 0xf9, 0xe6, 0xb7, 0xdf, 0x4c, 0x16, 0xee, 0xc7, 0x8c,
	0xc5, 0x0b, 0x1a, 0x10, 0x9e, 0x04, 0x92, 0x8a, 0x55, 0x12, 0xd1, 0x88, 0xa5, 0x99, 0x60, 0x8b,
	0x60, 0x75, 0x54, 0x44, 0x66, 0x26, 0xb4, 0xa0, 0xc2, 0xe7, 0x82, 0x65, 0x0c, 0xef, 0xe9, 0x32,
	0x9f, 0xf0, 0xc4, 0x5f, 0x2f, 0xf3, 0x57, 0x47, 0xce, 0x5e, 0x45, 0x94, 0xa4, 0x29, 0xcb, 0x48,
	0x96, 0xb0, 0x54, 0xea, 0x5a, 0xc7, 0x6f, 0x6c, 0x19, 0xbd, 0xa1, 0xd1, 0xdb, 0x19, 0x15, 0x82,
	0x99, 0x5e, 0xce, 0xb0, 0x31, 0x9f, 0x71, 0x2a, 0x94, 0xbc, 0xc9, 0xbe, 0x6d, 0xb2, 0x05, 0x8f,
	0x02, 0x99, 0x91, 0xec, 0xc2, 0xb4, 0x75, 0xbf, 0x22, 0xe8, 0x4c, 0x72, 0xf1, 0x90, 0xbe, 0xbb,
	0xa0, 0x32, 0xc3, 0xfb, 0xd0, 0x29, 0xee, 0x97, 0x92, 0x25, 0xed, 0xa1, 0x3e, 0x1a, 0xec, 0x84,
	0xb6, 0x89, 0x3d, 0x25, 0x4b, 0x8a, 0x4f, 0x60, 0xa7, 0xd4, 0xef, 0x59, 0x7d, 0x34, 0xb0, 0x47,
	0x07, 0x7e, 0xd3, 0xd5, 0xfd, 0x67, 0x45, 0x7a, 0x78, 0x55, 0x89, 0x3d, 0xd8, 0xad, 0x38, 0xf9,
	0x3a, 0x89, 0x67, 0xc9, 0xbc, 0xb7, 0xa9, 0xda, 0xdd, 0x34, 0x07, 0x13, 0x15, 0x3f, 0x9b, 0xbb,
	0xdf, 0x11, 0x74, 0x0d, 0xa6, 0xe4, 0x2c, 0x95, 0x34, 0xe7, 0x2c, 0xa5, 0xf2, 0x42, 0xc3, 0x59,
	0xc6, 0xce, 0xe6, 0xf8, 0x09, 0x74, 0x2a, 0xbe, 0xc9, 0x9e, 0xd5, 0xdf, 0x18, 0xd8, 0xa3, 0x41,
	0x33, 0xaa, 0xea, 0x72, 0x92, 0x17, 0x84, 0x76, 0x54, 0xfe, 0x96, 0xf5, 0xb4, 0x5b, 0xf5, 0xb4,
	0xdf, 0x10, 0x74, 0x43, 0xca, 0x99, 0xc8, 0xae, 0xe1, 0xea, 0x29, 0x40, 0x09, 0x5f, 0xb0, 0xb6,
	0xb6, 0xb5, 0x52, 0x5a, 0x4f, 0xba, 0x51, 0x4f, 0xfa, 0x07, 0xc1, 0x8d, 0x82, 0xd4, 0x18, 0xfb,
	0x12, 0xba, 0x42, 0x45, 0x0a, 0xdb, 0x90, 0x42, 0x79, 0xd0, 0x8c, 0xb2, 0x2e, 0x62, 0x3e, 0xb5,
	0x8d, 0x1d, 0x71, 0xf5, 0xf1, 0x1f, 0x3a, 0xab, 0x96, 0xce, 0x79, 0x01, 0x76, 0x45, 0xa8, 0xcd,
	0xc8, 0x3d, 0xd8, 0xd6, 0xeb, 0x6d, 0xf6, 0x12, 0x17, 0xd4, 0x82, 0x47, 0xfe, 0x54, 0x9d, 0x84,
	0x26, 0x63, 0xf4, 0xc3, 0x82, 0xdd, 0x69, 0xd9, 0xd1, 0xfc, 0x93, 0xf1, 0x27, 0x04, 0x5b, 0x6a,
	0x07, 0xb0, 0xd7, 0x62, 0x51, 0xcc, 0x7c, 0x9d, 0xc3, 0x56, 0xb9, 0xda, 0x1c, 0x77, 0xf8, 0xf1,
	0xe7, 0xaf, 0xcf, 0xd6, 0x1d, 0x77, 0xbf, 0xf2, 0x98, 0xc8, 0xe0, 0x7d, 0x75, 0x41, 0x3e, 0x8c,
	0xd5, 0xee, 0x8d, 0x91, 0x87, 0x2f, 0x11, 0x6c, 0x6b, 0x17, 0xf0, 0x61, 0xbb, 0x19, 0x68, 0xa4,
	0xe1, 0x75, 0x06, 0xe6, 0xde, 0x55, 0x4c, 0x07, 0xae, 0xdb, 0xc4, 0xa4, 0x07, 0x39, 0x46, 0xde,
	0xf1, 0x25, 0x82, 0x7e, 0xc4, 0x96, 0x8d, 0x2d, 0x8e, 0x6f, 0xfd, 0xe3, 0xee, 0x79, 0xfe, 0xe6,
	0x9c, 0xa3, 0xe7, 0x8f, 0x4d, 0x5d, 0xcc, 0x16, 0x24, 0x8d, 0x7d, 0x26, 0xe2, 0x20, 0xa6, 0xa9,
	0x7a, 0x91, 0x02, 0x7d, 0x44, 0x78, 0x22, 0xeb, 0xdf, 0xb6, 0x87, 0xeb, 0x91, 0xdf, 0x08, 0x7d,
	0xb1, 0x36, 0x4f, 0x1f, 0x4d, 0x27, 0xaf, 0xb6, 0x95, 0xc0, 0xbd, 0xbf, 0x01, 0x00, 0x00, 0xff,
	0xff, 0x6c, 0x58, 0x92, 0x07, 0xbe, 0x05, 0x00, 0x00,
}
