# CPU Manager Example

This example flow uses a pre-built docker image based on
[cpuset-visualizer](https://github.com/ConnorDoyle/cpuset-visualizer).
Each container run here hosts an endpoint serving an up-to-the-second
system representation generated by
[`lstopo`](https://www.open-mpi.org/projects/hwloc).

## Setup

1. Start a local cluster with the static CPU manager policy enabled :

   ```
   sudo PATH=$PATH \
     KUBELET_FLAGS="\
     --feature-gates=CPUManager=true \
     --cpu-manager-policy=static \
     --cpu-manager-reconcile-period=5s \
     --kube-reserved=cpu=500m" \
     ./hack/local-up-cluster.sh
   ```

## Run pods

The example pods are in the `/examples/cpu-manager` directory of the
Kubernetes source tree. Your ability to run all of the example pods
simultaneously depends on how many CPUs are available on the test system.

The required CPUs for each example pod are listed below:

```
 POD              | CPUs
------------------|---------
 be.yaml          | >= 1 CPU
 shared.yaml      | >= 1 CPU
 exclusive-1.yaml | >= 2 CPU
 exclusive-2.yaml | >= 3 CPU
 exclusive-3.yaml | >= 4 CPU
 exclusive-4.yaml | >= 5 CPU
```

### Example

Run a pod with a single container in the shared pool, and another pod
with a single container in an exclusive cpuset with one CPU.

```
$ kubectl create -f examples/cpu-manager/shared.yaml
$ kubectl create -f examples/cpu-manager/exclusive-1.yaml
```

To list IP addresses of the pods running in the local cluster, do:

```
$ watch ./examples/cpu-manager/pod-ips
exclusive-1 http://172.17.0.4
shared http://172.17.0.3
```

#### Sample cpuset-visualizer output

![Sample cpuset-visualizer output](https://user-images.githubusercontent.com/379372/28648573-974693ce-7223-11e7-84ed-17cce11910ff.png)
