// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewaymanagementapi

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// ConnectionId is a required field
	ConnectionId *string `location:"uri" locationName:"connectionId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteConnectionInput"}

	if s.ConnectionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteConnectionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ConnectionId != nil {
		v := *s.ConnectionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "connectionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteConnectionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest returns a request value for making API operation for
// AmazonApiGatewayManagementApi.
//
// Delete the connection with the provided id.
//
//    // Example sending a request using DeleteConnectionRequest.
//    req := client.DeleteConnectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewaymanagementapi-2018-11-29/DeleteConnection
func (c *Client) DeleteConnectionRequest(input *DeleteConnectionInput) DeleteConnectionRequest {
	op := &aws.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/@connections/{connectionId}",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	req := c.newRequest(op, input, &DeleteConnectionOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteConnectionRequest{Request: req, Input: input, Copy: c.DeleteConnectionRequest}
}

// DeleteConnectionRequest is the request type for the
// DeleteConnection API operation.
type DeleteConnectionRequest struct {
	*aws.Request
	Input *DeleteConnectionInput
	Copy  func(*DeleteConnectionInput) DeleteConnectionRequest
}

// Send marshals and sends the DeleteConnection API request.
func (r DeleteConnectionRequest) Send(ctx context.Context) (*DeleteConnectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteConnectionResponse{
		DeleteConnectionOutput: r.Request.Data.(*DeleteConnectionOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteConnectionResponse is the response type for the
// DeleteConnection API operation.
type DeleteConnectionResponse struct {
	*DeleteConnectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteConnection request.
func (r *DeleteConnectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
