// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/datastore/v1/entity.proto

package datastore

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/struct"
import google_protobuf2 "github.com/golang/protobuf/ptypes/timestamp"
import google_type "google.golang.org/genproto/googleapis/type/latlng"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A partition ID identifies a grouping of entities. The grouping is always
// by project and namespace, however the namespace ID may be empty.
//
// A partition ID contains several dimensions:
// project ID and namespace ID.
//
// Partition dimensions:
//
// - May be `""`.
// - Must be valid UTF-8 bytes.
// - Must have values that match regex `[A-Za-z\d\.\-_]{1,100}`
// If the value of any dimension matches regex `__.*__`, the partition is
// reserved/read-only.
// A reserved/read-only partition ID is forbidden in certain documented
// contexts.
//
// Foreign partition IDs (in which the project ID does
// not match the context project ID ) are discouraged.
// Reads and writes of foreign partition IDs may fail if the project is not in an active state.
type PartitionId struct {
	// The ID of the project to which the entities belong.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// If not empty, the ID of the namespace to which the entities belong.
	NamespaceId string `protobuf:"bytes,4,opt,name=namespace_id,json=namespaceId" json:"namespace_id,omitempty"`
}

func (m *PartitionId) Reset()                    { *m = PartitionId{} }
func (m *PartitionId) String() string            { return proto.CompactTextString(m) }
func (*PartitionId) ProtoMessage()               {}
func (*PartitionId) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *PartitionId) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *PartitionId) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

// A unique identifier for an entity.
// If a key's partition ID or any of its path kinds or names are
// reserved/read-only, the key is reserved/read-only.
// A reserved/read-only key is forbidden in certain documented contexts.
type Key struct {
	// Entities are partitioned into subsets, currently identified by a project
	// ID and namespace ID.
	// Queries are scoped to a single partition.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId" json:"partition_id,omitempty"`
	// The entity path.
	// An entity path consists of one or more elements composed of a kind and a
	// string or numerical identifier, which identify entities. The first
	// element identifies a _root entity_, the second element identifies
	// a _child_ of the root entity, the third element identifies a child of the
	// second entity, and so forth. The entities identified by all prefixes of
	// the path are called the element's _ancestors_.
	//
	// An entity path is always fully complete: *all* of the entity's ancestors
	// are required to be in the path along with the entity identifier itself.
	// The only exception is that in some documented cases, the identifier in the
	// last path element (for the entity) itself may be omitted. For example,
	// the last path element of the key of `Mutation.insert` may have no
	// identifier.
	//
	// A path can never be empty, and a path can have at most 100 elements.
	Path []*Key_PathElement `protobuf:"bytes,2,rep,name=path" json:"path,omitempty"`
}

func (m *Key) Reset()                    { *m = Key{} }
func (m *Key) String() string            { return proto.CompactTextString(m) }
func (*Key) ProtoMessage()               {}
func (*Key) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *Key) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *Key) GetPath() []*Key_PathElement {
	if m != nil {
		return m.Path
	}
	return nil
}

// A (kind, ID/name) pair used to construct a key path.
//
// If either name or ID is set, the element is complete.
// If neither is set, the element is incomplete.
type Key_PathElement struct {
	// The kind of the entity.
	// A kind matching regex `__.*__` is reserved/read-only.
	// A kind must not contain more than 1500 bytes when UTF-8 encoded.
	// Cannot be `""`.
	Kind string `protobuf:"bytes,1,opt,name=kind" json:"kind,omitempty"`
	// The type of ID.
	//
	// Types that are valid to be assigned to IdType:
	//	*Key_PathElement_Id
	//	*Key_PathElement_Name
	IdType isKey_PathElement_IdType `protobuf_oneof:"id_type"`
}

func (m *Key_PathElement) Reset()                    { *m = Key_PathElement{} }
func (m *Key_PathElement) String() string            { return proto.CompactTextString(m) }
func (*Key_PathElement) ProtoMessage()               {}
func (*Key_PathElement) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1, 0} }

type isKey_PathElement_IdType interface {
	isKey_PathElement_IdType()
}

type Key_PathElement_Id struct {
	Id int64 `protobuf:"varint,2,opt,name=id,oneof"`
}
type Key_PathElement_Name struct {
	Name string `protobuf:"bytes,3,opt,name=name,oneof"`
}

func (*Key_PathElement_Id) isKey_PathElement_IdType()   {}
func (*Key_PathElement_Name) isKey_PathElement_IdType() {}

func (m *Key_PathElement) GetIdType() isKey_PathElement_IdType {
	if m != nil {
		return m.IdType
	}
	return nil
}

func (m *Key_PathElement) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *Key_PathElement) GetId() int64 {
	if x, ok := m.GetIdType().(*Key_PathElement_Id); ok {
		return x.Id
	}
	return 0
}

func (m *Key_PathElement) GetName() string {
	if x, ok := m.GetIdType().(*Key_PathElement_Name); ok {
		return x.Name
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Key_PathElement) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Key_PathElement_OneofMarshaler, _Key_PathElement_OneofUnmarshaler, _Key_PathElement_OneofSizer, []interface{}{
		(*Key_PathElement_Id)(nil),
		(*Key_PathElement_Name)(nil),
	}
}

func _Key_PathElement_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Key_PathElement)
	// id_type
	switch x := m.IdType.(type) {
	case *Key_PathElement_Id:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Id))
	case *Key_PathElement_Name:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Name)
	case nil:
	default:
		return fmt.Errorf("Key_PathElement.IdType has unexpected type %T", x)
	}
	return nil
}

func _Key_PathElement_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Key_PathElement)
	switch tag {
	case 2: // id_type.id
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.IdType = &Key_PathElement_Id{int64(x)}
		return true, err
	case 3: // id_type.name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.IdType = &Key_PathElement_Name{x}
		return true, err
	default:
		return false, nil
	}
}

func _Key_PathElement_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Key_PathElement)
	// id_type
	switch x := m.IdType.(type) {
	case *Key_PathElement_Id:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Id))
	case *Key_PathElement_Name:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Name)))
		n += len(x.Name)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// An array value.
type ArrayValue struct {
	// Values in the array.
	// The order of this array may not be preserved if it contains a mix of
	// indexed and unindexed values.
	Values []*Value `protobuf:"bytes,1,rep,name=values" json:"values,omitempty"`
}

func (m *ArrayValue) Reset()                    { *m = ArrayValue{} }
func (m *ArrayValue) String() string            { return proto.CompactTextString(m) }
func (*ArrayValue) ProtoMessage()               {}
func (*ArrayValue) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *ArrayValue) GetValues() []*Value {
	if m != nil {
		return m.Values
	}
	return nil
}

// A message that can hold any of the supported value types and associated
// metadata.
type Value struct {
	// Must have a value set.
	//
	// Types that are valid to be assigned to ValueType:
	//	*Value_NullValue
	//	*Value_BooleanValue
	//	*Value_IntegerValue
	//	*Value_DoubleValue
	//	*Value_TimestampValue
	//	*Value_KeyValue
	//	*Value_StringValue
	//	*Value_BlobValue
	//	*Value_GeoPointValue
	//	*Value_EntityValue
	//	*Value_ArrayValue
	ValueType isValue_ValueType `protobuf_oneof:"value_type"`
	// The `meaning` field should only be populated for backwards compatibility.
	Meaning int32 `protobuf:"varint,14,opt,name=meaning" json:"meaning,omitempty"`
	// If the value should be excluded from all indexes including those defined
	// explicitly.
	ExcludeFromIndexes bool `protobuf:"varint,19,opt,name=exclude_from_indexes,json=excludeFromIndexes" json:"exclude_from_indexes,omitempty"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

type isValue_ValueType interface {
	isValue_ValueType()
}

type Value_NullValue struct {
	NullValue google_protobuf1.NullValue `protobuf:"varint,11,opt,name=null_value,json=nullValue,enum=google.protobuf.NullValue,oneof"`
}
type Value_BooleanValue struct {
	BooleanValue bool `protobuf:"varint,1,opt,name=boolean_value,json=booleanValue,oneof"`
}
type Value_IntegerValue struct {
	IntegerValue int64 `protobuf:"varint,2,opt,name=integer_value,json=integerValue,oneof"`
}
type Value_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,3,opt,name=double_value,json=doubleValue,oneof"`
}
type Value_TimestampValue struct {
	TimestampValue *google_protobuf2.Timestamp `protobuf:"bytes,10,opt,name=timestamp_value,json=timestampValue,oneof"`
}
type Value_KeyValue struct {
	KeyValue *Key `protobuf:"bytes,5,opt,name=key_value,json=keyValue,oneof"`
}
type Value_StringValue struct {
	StringValue string `protobuf:"bytes,17,opt,name=string_value,json=stringValue,oneof"`
}
type Value_BlobValue struct {
	BlobValue []byte `protobuf:"bytes,18,opt,name=blob_value,json=blobValue,proto3,oneof"`
}
type Value_GeoPointValue struct {
	GeoPointValue *google_type.LatLng `protobuf:"bytes,8,opt,name=geo_point_value,json=geoPointValue,oneof"`
}
type Value_EntityValue struct {
	EntityValue *Entity `protobuf:"bytes,6,opt,name=entity_value,json=entityValue,oneof"`
}
type Value_ArrayValue struct {
	ArrayValue *ArrayValue `protobuf:"bytes,9,opt,name=array_value,json=arrayValue,oneof"`
}

func (*Value_NullValue) isValue_ValueType()      {}
func (*Value_BooleanValue) isValue_ValueType()   {}
func (*Value_IntegerValue) isValue_ValueType()   {}
func (*Value_DoubleValue) isValue_ValueType()    {}
func (*Value_TimestampValue) isValue_ValueType() {}
func (*Value_KeyValue) isValue_ValueType()       {}
func (*Value_StringValue) isValue_ValueType()    {}
func (*Value_BlobValue) isValue_ValueType()      {}
func (*Value_GeoPointValue) isValue_ValueType()  {}
func (*Value_EntityValue) isValue_ValueType()    {}
func (*Value_ArrayValue) isValue_ValueType()     {}

func (m *Value) GetValueType() isValue_ValueType {
	if m != nil {
		return m.ValueType
	}
	return nil
}

func (m *Value) GetNullValue() google_protobuf1.NullValue {
	if x, ok := m.GetValueType().(*Value_NullValue); ok {
		return x.NullValue
	}
	return google_protobuf1.NullValue_NULL_VALUE
}

func (m *Value) GetBooleanValue() bool {
	if x, ok := m.GetValueType().(*Value_BooleanValue); ok {
		return x.BooleanValue
	}
	return false
}

func (m *Value) GetIntegerValue() int64 {
	if x, ok := m.GetValueType().(*Value_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (m *Value) GetDoubleValue() float64 {
	if x, ok := m.GetValueType().(*Value_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Value) GetTimestampValue() *google_protobuf2.Timestamp {
	if x, ok := m.GetValueType().(*Value_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (m *Value) GetKeyValue() *Key {
	if x, ok := m.GetValueType().(*Value_KeyValue); ok {
		return x.KeyValue
	}
	return nil
}

func (m *Value) GetStringValue() string {
	if x, ok := m.GetValueType().(*Value_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *Value) GetBlobValue() []byte {
	if x, ok := m.GetValueType().(*Value_BlobValue); ok {
		return x.BlobValue
	}
	return nil
}

func (m *Value) GetGeoPointValue() *google_type.LatLng {
	if x, ok := m.GetValueType().(*Value_GeoPointValue); ok {
		return x.GeoPointValue
	}
	return nil
}

func (m *Value) GetEntityValue() *Entity {
	if x, ok := m.GetValueType().(*Value_EntityValue); ok {
		return x.EntityValue
	}
	return nil
}

func (m *Value) GetArrayValue() *ArrayValue {
	if x, ok := m.GetValueType().(*Value_ArrayValue); ok {
		return x.ArrayValue
	}
	return nil
}

func (m *Value) GetMeaning() int32 {
	if m != nil {
		return m.Meaning
	}
	return 0
}

func (m *Value) GetExcludeFromIndexes() bool {
	if m != nil {
		return m.ExcludeFromIndexes
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Value) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Value_OneofMarshaler, _Value_OneofUnmarshaler, _Value_OneofSizer, []interface{}{
		(*Value_NullValue)(nil),
		(*Value_BooleanValue)(nil),
		(*Value_IntegerValue)(nil),
		(*Value_DoubleValue)(nil),
		(*Value_TimestampValue)(nil),
		(*Value_KeyValue)(nil),
		(*Value_StringValue)(nil),
		(*Value_BlobValue)(nil),
		(*Value_GeoPointValue)(nil),
		(*Value_EntityValue)(nil),
		(*Value_ArrayValue)(nil),
	}
}

func _Value_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Value)
	// value_type
	switch x := m.ValueType.(type) {
	case *Value_NullValue:
		b.EncodeVarint(11<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.NullValue))
	case *Value_BooleanValue:
		t := uint64(0)
		if x.BooleanValue {
			t = 1
		}
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *Value_IntegerValue:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IntegerValue))
	case *Value_DoubleValue:
		b.EncodeVarint(3<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *Value_TimestampValue:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampValue); err != nil {
			return err
		}
	case *Value_KeyValue:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KeyValue); err != nil {
			return err
		}
	case *Value_StringValue:
		b.EncodeVarint(17<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case *Value_BlobValue:
		b.EncodeVarint(18<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.BlobValue)
	case *Value_GeoPointValue:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GeoPointValue); err != nil {
			return err
		}
	case *Value_EntityValue:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EntityValue); err != nil {
			return err
		}
	case *Value_ArrayValue:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ArrayValue); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Value.ValueType has unexpected type %T", x)
	}
	return nil
}

func _Value_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Value)
	switch tag {
	case 11: // value_type.null_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ValueType = &Value_NullValue{google_protobuf1.NullValue(x)}
		return true, err
	case 1: // value_type.boolean_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ValueType = &Value_BooleanValue{x != 0}
		return true, err
	case 2: // value_type.integer_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ValueType = &Value_IntegerValue{int64(x)}
		return true, err
	case 3: // value_type.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.ValueType = &Value_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 10: // value_type.timestamp_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf2.Timestamp)
		err := b.DecodeMessage(msg)
		m.ValueType = &Value_TimestampValue{msg}
		return true, err
	case 5: // value_type.key_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Key)
		err := b.DecodeMessage(msg)
		m.ValueType = &Value_KeyValue{msg}
		return true, err
	case 17: // value_type.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ValueType = &Value_StringValue{x}
		return true, err
	case 18: // value_type.blob_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ValueType = &Value_BlobValue{x}
		return true, err
	case 8: // value_type.geo_point_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_type.LatLng)
		err := b.DecodeMessage(msg)
		m.ValueType = &Value_GeoPointValue{msg}
		return true, err
	case 6: // value_type.entity_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Entity)
		err := b.DecodeMessage(msg)
		m.ValueType = &Value_EntityValue{msg}
		return true, err
	case 9: // value_type.array_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ArrayValue)
		err := b.DecodeMessage(msg)
		m.ValueType = &Value_ArrayValue{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Value_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Value)
	// value_type
	switch x := m.ValueType.(type) {
	case *Value_NullValue:
		n += proto.SizeVarint(11<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.NullValue))
	case *Value_BooleanValue:
		n += proto.SizeVarint(1<<3 | proto.WireVarint)
		n += 1
	case *Value_IntegerValue:
		n += proto.SizeVarint(2<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IntegerValue))
	case *Value_DoubleValue:
		n += proto.SizeVarint(3<<3 | proto.WireFixed64)
		n += 8
	case *Value_TimestampValue:
		s := proto.Size(x.TimestampValue)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_KeyValue:
		s := proto.Size(x.KeyValue)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_StringValue:
		n += proto.SizeVarint(17<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *Value_BlobValue:
		n += proto.SizeVarint(18<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.BlobValue)))
		n += len(x.BlobValue)
	case *Value_GeoPointValue:
		s := proto.Size(x.GeoPointValue)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_EntityValue:
		s := proto.Size(x.EntityValue)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Value_ArrayValue:
		s := proto.Size(x.ArrayValue)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Datastore data object.
//
// An entity is limited to 1 megabyte when stored. That _roughly_
// corresponds to a limit of 1 megabyte for the serialized form of this
// message.
type Entity struct {
	// The entity's key.
	//
	// An entity must have a key, unless otherwise documented (for example,
	// an entity in `Value.entity_value` may have no key).
	// An entity's kind is its key path's last element's kind,
	// or null if it has no key.
	Key *Key `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// The entity's properties.
	// The map's keys are property names.
	// A property name matching regex `__.*__` is reserved.
	// A reserved property name is forbidden in certain documented contexts.
	// The name must not contain more than 500 characters.
	// The name cannot be `""`.
	Properties map[string]*Value `protobuf:"bytes,3,rep,name=properties" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Entity) Reset()                    { *m = Entity{} }
func (m *Entity) String() string            { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()               {}
func (*Entity) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *Entity) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *Entity) GetProperties() map[string]*Value {
	if m != nil {
		return m.Properties
	}
	return nil
}

func init() {
	proto.RegisterType((*PartitionId)(nil), "google.datastore.v1.PartitionId")
	proto.RegisterType((*Key)(nil), "google.datastore.v1.Key")
	proto.RegisterType((*Key_PathElement)(nil), "google.datastore.v1.Key.PathElement")
	proto.RegisterType((*ArrayValue)(nil), "google.datastore.v1.ArrayValue")
	proto.RegisterType((*Value)(nil), "google.datastore.v1.Value")
	proto.RegisterType((*Entity)(nil), "google.datastore.v1.Entity")
}

func init() { proto.RegisterFile("google/datastore/v1/entity.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 767 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x94, 0xdf, 0x8e, 0xdb, 0x44,
	0x14, 0xc6, 0xed, 0x64, 0xb3, 0x5d, 0x1f, 0xbb, 0xbb, 0x65, 0xb6, 0x12, 0x26, 0x80, 0xd6, 0x04,
	0x90, 0x22, 0x90, 0xec, 0xee, 0x72, 0x41, 0x45, 0x41, 0x2a, 0x29, 0x01, 0x47, 0x5b, 0x41, 0x34,
	0xaa, 0x2a, 0xc1, 0x4d, 0x34, 0x89, 0xa7, 0xee, 0x10, 0x7b, 0xc6, 0xb2, 0xc7, 0xab, 0xfa, 0x96,
	0xe7, 0xe0, 0x09, 0x78, 0x24, 0xc4, 0xc3, 0xa0, 0xf9, 0x13, 0x67, 0x29, 0xe9, 0xde, 0x79, 0xce,
	0xf9, 0x7d, 0xc7, 0xdf, 0xf1, 0x39, 0x63, 0x88, 0x72, 0x21, 0xf2, 0x82, 0x26, 0x19, 0x91, 0xa4,
	0x91, 0xa2, 0xa6, 0xc9, 0xcd, 0x65, 0x42, 0xb9, 0x64, 0xb2, 0x8b, 0xab, 0x5a, 0x48, 0x81, 0xce,
	0x0d, 0x11, 0xf7, 0x44, 0x7c, 0x73, 0x39, 0xfe, 0xc8, 0xca, 0x48, 0xc5, 0x12, 0xc2, 0xb9, 0x90,
	0x44, 0x32, 0xc1, 0x1b, 0x23, 0xe9, 0xb3, 0xfa, 0xb4, 0x6e, 0x5f, 0x25, 0x8d, 0xac, 0xdb, 0x8d,
	0xb4, 0xd9, 0x8b, 0xb7, 0xb3, 0x92, 0x95, 0xb4, 0x91, 0xa4, 0xac, 0x2c, 0x10, 0x5a, 0x40, 0x76,
	0x15, 0x4d, 0x0a, 0x22, 0x0b, 0x9e, 0x9b, 0xcc, 0xe4, 0x17, 0xf0, 0x97, 0xa4, 0x96, 0x4c, 0xbd,
	0x6c, 0x91, 0xa1, 0x8f, 0x01, 0xaa, 0x5a, 0xfc, 0x4e, 0x37, 0x72, 0xc5, 0xb2, 0x70, 0x10, 0xb9,
	0x53, 0x0f, 0x7b, 0x36, 0xb2, 0xc8, 0xd0, 0x27, 0x10, 0x70, 0x52, 0xd2, 0xa6, 0x22, 0x1b, 0xaa,
	0x80, 0x23, 0x0d, 0xf8, 0x7d, 0x6c, 0x91, 0x4d, 0xfe, 0x76, 0x61, 0x78, 0x4d, 0x3b, 0xf4, 0x0c,
	0x82, 0x6a, 0x57, 0x58, 0xa1, 0x6e, 0xe4, 0x4e, 0xfd, 0xab, 0x28, 0x3e, 0xd0, 0x7b, 0x7c, 0xcb,
	0x01, 0xf6, 0xab, 0x5b, 0x76, 0x1e, 0xc3, 0x51, 0x45, 0xe4, 0xeb, 0x70, 0x10, 0x0d, 0xa7, 0xfe,
	0xd5, 0x67, 0x07, 0xc5, 0xd7, 0xb4, 0x8b, 0x97, 0x44, 0xbe, 0x9e, 0x17, 0xb4, 0xa4, 0x5c, 0x62,
	0xad, 0x18, 0xbf, 0x50, 0x7d, 0xf5, 0x41, 0x84, 0xe0, 0x68, 0xcb, 0xb8, 0x71, 0xe1, 0x61, 0xfd,
	0x8c, 0x1e, 0xc0, 0xc0, 0xf6, 0x38, 0x4c, 0x1d, 0x3c, 0x60, 0x19, 0x7a, 0x08, 0x47, 0xaa, 0x95,
	0x70, 0xa8, 0xa8, 0xd4, 0xc1, 0xfa, 0x34, 0xf3, 0xe0, 0x1e, 0xcb, 0x56, 0xea, 0xd3, 0x4d, 0x9e,
	0x02, 0x7c, 0x5f, 0xd7, 0xa4, 0x7b, 0x49, 0x8a, 0x96, 0xa2, 0x2b, 0x38, 0xbe, 0x51, 0x0f, 0x4d,
	0xe8, 0x6a, 0x7f, 0xe3, 0x83, 0xfe, 0x34, 0x8b, 0x2d, 0x39, 0xf9, 0x73, 0x04, 0x23, 0xa3, 0x7e,
	0x02, 0xc0, 0xdb, 0xa2, 0x58, 0xe9, 0x44, 0xe8, 0x47, 0xee, 0xf4, 0x74, 0x5f, 0x61, 0x37, 0xc9,
	0xf8, 0xe7, 0xb6, 0x28, 0x34, 0x9f, 0x3a, 0xd8, 0xe3, 0xbb, 0x03, 0xfa, 0x1c, 0xee, 0xaf, 0x85,
	0x28, 0x28, 0xe1, 0x56, 0xaf, 0x1a, 0x3b, 0x49, 0x1d, 0x1c, 0xd8, 0x70, 0x8f, 0x31, 0x2e, 0x69,
	0x4e, 0x6b, 0x8b, 0xed, 0xba, 0x0d, 0x6c, 0xd8, 0x60, 0x9f, 0x42, 0x90, 0x89, 0x76, 0x5d, 0x50,
	0x4b, 0xa9, 0xfe, 0xdd, 0xd4, 0xc1, 0xbe, 0x89, 0x1a, 0x68, 0x0e, 0x67, 0xfd, 0x5a, 0x59, 0x0e,
	0xf4, 0x4c, 0xff, 0x6f, 0xfa, 0xc5, 0x8e, 0x4b, 0x1d, 0x7c, 0xda, 0x8b, 0x4c, 0x99, 0xaf, 0xc1,
	0xdb, 0xd2, 0xce, 0x16, 0x18, 0xe9, 0x02, 0xe1, 0xbb, 0xe6, 0x9a, 0x3a, 0xf8, 0x64, 0x4b, 0xbb,
	0xde, 0x64, 0x23, 0x6b, 0xc6, 0x73, 0xab, 0x7d, 0xcf, 0x0e, 0xc9, 0x37, 0x51, 0x03, 0x5d, 0x00,
	0xac, 0x0b, 0xb1, 0xb6, 0x08, 0x8a, 0xdc, 0x69, 0xa0, 0x3e, 0x9c, 0x8a, 0x19, 0xe0, 0x3b, 0x38,
	0xcb, 0xa9, 0x58, 0x55, 0x82, 0x71, 0x69, 0xa9, 0x13, 0x6d, 0xe2, 0x7c, 0x67, 0x42, 0x0d, 0x3a,
	0x7e, 0x4e, 0xe4, 0x73, 0x9e, 0xa7, 0x0e, 0xbe, 0x9f, 0x53, 0xb1, 0x54, 0xb0, 0x91, 0x3f, 0x85,
	0xc0, 0x5c, 0x65, 0xab, 0x3d, 0xd6, 0xda, 0x0f, 0x0f, 0x36, 0x30, 0xd7, 0xa0, 0x72, 0x68, 0x24,
	0xa6, 0xc2, 0x0c, 0x7c, 0xa2, 0x56, 0xc8, 0x16, 0xf0, 0x74, 0x81, 0x8b, 0x83, 0x05, 0xf6, 0xab,
	0x96, 0x3a, 0x18, 0xc8, 0x7e, 0xf1, 0x42, 0xb8, 0x57, 0x52, 0xc2, 0x19, 0xcf, 0xc3, 0xd3, 0xc8,
	0x9d, 0x8e, 0xf0, 0xee, 0x88, 0x1e, 0xc1, 0x43, 0xfa, 0x66, 0x53, 0xb4, 0x19, 0x5d, 0xbd, 0xaa,
	0x45, 0xb9, 0x62, 0x3c, 0xa3, 0x6f, 0x68, 0x13, 0x9e, 0xab, 0xf5, 0xc0, 0xc8, 0xe6, 0x7e, 0xac,
	0x45, 0xb9, 0x30, 0x99, 0x59, 0x00, 0xa0, 0x9d, 0x98, 0x05, 0xff, 0xc7, 0x85, 0x63, 0xe3, 0x1b,
	0x7d, 0x01, 0xc3, 0x2d, 0xed, 0xec, 0xbd, 0x7d, 0xe7, 0x88, 0xb0, 0x82, 0xd0, 0xb5, 0xfe, 0x6d,
	0x54, 0xb4, 0x96, 0x8c, 0x36, 0xe1, 0x50, 0xdf, 0x86, 0x2f, 0xef, 0xf8, 0x28, 0xf1, 0xb2, 0xa7,
	0xe7, 0x5c, 0xd6, 0x1d, 0xbe, 0x25, 0x1f, 0xff, 0x0a, 0x67, 0x6f, 0xa5, 0xd1, 0x83, 0xbd, 0x17,
	0xcf, 0xbc, 0xf1, 0x11, 0x8c, 0xf6, 0x1b, 0x7d, 0xf7, 0xd5, 0x33, 0xe0, 0x37, 0x83, 0xc7, 0xee,
	0xec, 0x0f, 0x17, 0xde, 0xdf, 0x88, 0xf2, 0x10, 0x3c, 0xf3, 0x8d, 0xb5, 0xa5, 0x5a, 0xe2, 0xa5,
	0xfb, 0xdb, 0xb7, 0x96, 0xc9, 0x45, 0x41, 0x78, 0x1e, 0x8b, 0x3a, 0x4f, 0x72, 0xca, 0xf5, 0x8a,
	0x27, 0x26, 0x45, 0x2a, 0xd6, 0xfc, 0xe7, 0x2f, 0xff, 0xa4, 0x3f, 0xfc, 0x35, 0xf8, 0xe0, 0x27,
	0x23, 0x7f, 0x56, 0x88, 0x36, 0x8b, 0x7f, 0xe8, 0x5f, 0xf4, 0xf2, 0x72, 0x7d, 0xac, 0x8b, 0x7c,
	0xf5, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x89, 0x5b, 0xc5, 0xcd, 0x29, 0x06, 0x00, 0x00,
}
