// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/cloud/pubsublite/v1/cursor.proto

package pubsublite

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// The first streaming request that must be sent on a newly-opened stream. The
// client must wait for the response before sending subsequent requests on the
// stream.
type InitialCommitCursorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The subscription for which to manage committed cursors.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// The partition for which to manage committed cursors. Partitions are zero
	// indexed, so `partition` must be in the range [0, topic.num_partitions).
	Partition int64 `protobuf:"varint,2,opt,name=partition,proto3" json:"partition,omitempty"`
}

func (x *InitialCommitCursorRequest) Reset() {
	*x = InitialCommitCursorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitialCommitCursorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitialCommitCursorRequest) ProtoMessage() {}

func (x *InitialCommitCursorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitialCommitCursorRequest.ProtoReflect.Descriptor instead.
func (*InitialCommitCursorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{0}
}

func (x *InitialCommitCursorRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *InitialCommitCursorRequest) GetPartition() int64 {
	if x != nil {
		return x.Partition
	}
	return 0
}

// Response to an InitialCommitCursorRequest.
type InitialCommitCursorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InitialCommitCursorResponse) Reset() {
	*x = InitialCommitCursorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitialCommitCursorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitialCommitCursorResponse) ProtoMessage() {}

func (x *InitialCommitCursorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitialCommitCursorResponse.ProtoReflect.Descriptor instead.
func (*InitialCommitCursorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{1}
}

// Streaming request to update the committed cursor. Subsequent
// SequencedCommitCursorRequests override outstanding ones.
type SequencedCommitCursorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The new value for the committed cursor.
	Cursor *Cursor `protobuf:"bytes,1,opt,name=cursor,proto3" json:"cursor,omitempty"`
}

func (x *SequencedCommitCursorRequest) Reset() {
	*x = SequencedCommitCursorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SequencedCommitCursorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SequencedCommitCursorRequest) ProtoMessage() {}

func (x *SequencedCommitCursorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SequencedCommitCursorRequest.ProtoReflect.Descriptor instead.
func (*SequencedCommitCursorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{2}
}

func (x *SequencedCommitCursorRequest) GetCursor() *Cursor {
	if x != nil {
		return x.Cursor
	}
	return nil
}

// Response to a SequencedCommitCursorRequest.
type SequencedCommitCursorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of outstanding SequencedCommitCursorRequests acknowledged by
	// this response. Note that SequencedCommitCursorRequests are acknowledged in
	// the order that they are received.
	AcknowledgedCommits int64 `protobuf:"varint,1,opt,name=acknowledged_commits,json=acknowledgedCommits,proto3" json:"acknowledged_commits,omitempty"`
}

func (x *SequencedCommitCursorResponse) Reset() {
	*x = SequencedCommitCursorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SequencedCommitCursorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SequencedCommitCursorResponse) ProtoMessage() {}

func (x *SequencedCommitCursorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SequencedCommitCursorResponse.ProtoReflect.Descriptor instead.
func (*SequencedCommitCursorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{3}
}

func (x *SequencedCommitCursorResponse) GetAcknowledgedCommits() int64 {
	if x != nil {
		return x.AcknowledgedCommits
	}
	return 0
}

// A request sent from the client to the server on a stream.
type StreamingCommitCursorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Request:
	//	*StreamingCommitCursorRequest_Initial
	//	*StreamingCommitCursorRequest_Commit
	Request isStreamingCommitCursorRequest_Request `protobuf_oneof:"request"`
}

func (x *StreamingCommitCursorRequest) Reset() {
	*x = StreamingCommitCursorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingCommitCursorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingCommitCursorRequest) ProtoMessage() {}

func (x *StreamingCommitCursorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingCommitCursorRequest.ProtoReflect.Descriptor instead.
func (*StreamingCommitCursorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{4}
}

func (m *StreamingCommitCursorRequest) GetRequest() isStreamingCommitCursorRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *StreamingCommitCursorRequest) GetInitial() *InitialCommitCursorRequest {
	if x, ok := x.GetRequest().(*StreamingCommitCursorRequest_Initial); ok {
		return x.Initial
	}
	return nil
}

func (x *StreamingCommitCursorRequest) GetCommit() *SequencedCommitCursorRequest {
	if x, ok := x.GetRequest().(*StreamingCommitCursorRequest_Commit); ok {
		return x.Commit
	}
	return nil
}

type isStreamingCommitCursorRequest_Request interface {
	isStreamingCommitCursorRequest_Request()
}

type StreamingCommitCursorRequest_Initial struct {
	// Initial request on the stream.
	Initial *InitialCommitCursorRequest `protobuf:"bytes,1,opt,name=initial,proto3,oneof"`
}

type StreamingCommitCursorRequest_Commit struct {
	// Request to commit a new cursor value.
	Commit *SequencedCommitCursorRequest `protobuf:"bytes,2,opt,name=commit,proto3,oneof"`
}

func (*StreamingCommitCursorRequest_Initial) isStreamingCommitCursorRequest_Request() {}

func (*StreamingCommitCursorRequest_Commit) isStreamingCommitCursorRequest_Request() {}

// Response to a StreamingCommitCursorRequest.
type StreamingCommitCursorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Request:
	//	*StreamingCommitCursorResponse_Initial
	//	*StreamingCommitCursorResponse_Commit
	Request isStreamingCommitCursorResponse_Request `protobuf_oneof:"request"`
}

func (x *StreamingCommitCursorResponse) Reset() {
	*x = StreamingCommitCursorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamingCommitCursorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingCommitCursorResponse) ProtoMessage() {}

func (x *StreamingCommitCursorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingCommitCursorResponse.ProtoReflect.Descriptor instead.
func (*StreamingCommitCursorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{5}
}

func (m *StreamingCommitCursorResponse) GetRequest() isStreamingCommitCursorResponse_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *StreamingCommitCursorResponse) GetInitial() *InitialCommitCursorResponse {
	if x, ok := x.GetRequest().(*StreamingCommitCursorResponse_Initial); ok {
		return x.Initial
	}
	return nil
}

func (x *StreamingCommitCursorResponse) GetCommit() *SequencedCommitCursorResponse {
	if x, ok := x.GetRequest().(*StreamingCommitCursorResponse_Commit); ok {
		return x.Commit
	}
	return nil
}

type isStreamingCommitCursorResponse_Request interface {
	isStreamingCommitCursorResponse_Request()
}

type StreamingCommitCursorResponse_Initial struct {
	// Initial response on the stream.
	Initial *InitialCommitCursorResponse `protobuf:"bytes,1,opt,name=initial,proto3,oneof"`
}

type StreamingCommitCursorResponse_Commit struct {
	// Response to committing a new cursor value.
	Commit *SequencedCommitCursorResponse `protobuf:"bytes,2,opt,name=commit,proto3,oneof"`
}

func (*StreamingCommitCursorResponse_Initial) isStreamingCommitCursorResponse_Request() {}

func (*StreamingCommitCursorResponse_Commit) isStreamingCommitCursorResponse_Request() {}

// Request for CommitCursor.
type CommitCursorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The subscription for which to update the cursor.
	Subscription string `protobuf:"bytes,1,opt,name=subscription,proto3" json:"subscription,omitempty"`
	// The partition for which to update the cursor. Partitions are zero indexed,
	// so `partition` must be in the range [0, topic.num_partitions).
	Partition int64 `protobuf:"varint,2,opt,name=partition,proto3" json:"partition,omitempty"`
	// The new value for the committed cursor.
	Cursor *Cursor `protobuf:"bytes,3,opt,name=cursor,proto3" json:"cursor,omitempty"`
}

func (x *CommitCursorRequest) Reset() {
	*x = CommitCursorRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitCursorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitCursorRequest) ProtoMessage() {}

func (x *CommitCursorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitCursorRequest.ProtoReflect.Descriptor instead.
func (*CommitCursorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{6}
}

func (x *CommitCursorRequest) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

func (x *CommitCursorRequest) GetPartition() int64 {
	if x != nil {
		return x.Partition
	}
	return 0
}

func (x *CommitCursorRequest) GetCursor() *Cursor {
	if x != nil {
		return x.Cursor
	}
	return nil
}

// Response for CommitCursor.
type CommitCursorResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CommitCursorResponse) Reset() {
	*x = CommitCursorResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitCursorResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitCursorResponse) ProtoMessage() {}

func (x *CommitCursorResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitCursorResponse.ProtoReflect.Descriptor instead.
func (*CommitCursorResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{7}
}

// Request for ListPartitionCursors.
type ListPartitionCursorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The subscription for which to retrieve cursors.
	// Structured like
	// `projects/{project_number}/locations/{location}/subscriptions/{subscription_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of cursors to return. The service may return fewer than
	// this value.
	// If unset or zero, all cursors for the parent will be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListPartitionCursors` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListPartitionCursors`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPartitionCursorsRequest) Reset() {
	*x = ListPartitionCursorsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPartitionCursorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPartitionCursorsRequest) ProtoMessage() {}

func (x *ListPartitionCursorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPartitionCursorsRequest.ProtoReflect.Descriptor instead.
func (*ListPartitionCursorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{8}
}

func (x *ListPartitionCursorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPartitionCursorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPartitionCursorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A pair of a Cursor and the partition it is for.
type PartitionCursor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The partition this is for.
	Partition int64 `protobuf:"varint,1,opt,name=partition,proto3" json:"partition,omitempty"`
	// The value of the cursor.
	Cursor *Cursor `protobuf:"bytes,2,opt,name=cursor,proto3" json:"cursor,omitempty"`
}

func (x *PartitionCursor) Reset() {
	*x = PartitionCursor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionCursor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionCursor) ProtoMessage() {}

func (x *PartitionCursor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionCursor.ProtoReflect.Descriptor instead.
func (*PartitionCursor) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{9}
}

func (x *PartitionCursor) GetPartition() int64 {
	if x != nil {
		return x.Partition
	}
	return 0
}

func (x *PartitionCursor) GetCursor() *Cursor {
	if x != nil {
		return x.Cursor
	}
	return nil
}

// Response for ListPartitionCursors
type ListPartitionCursorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The partition cursors from this request.
	PartitionCursors []*PartitionCursor `protobuf:"bytes,1,rep,name=partition_cursors,json=partitionCursors,proto3" json:"partition_cursors,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPartitionCursorsResponse) Reset() {
	*x = ListPartitionCursorsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPartitionCursorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPartitionCursorsResponse) ProtoMessage() {}

func (x *ListPartitionCursorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPartitionCursorsResponse.ProtoReflect.Descriptor instead.
func (*ListPartitionCursorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP(), []int{10}
}

func (x *ListPartitionCursorsResponse) GetPartitionCursors() []*PartitionCursor {
	if x != nil {
		return x.PartitionCursors
	}
	return nil
}

func (x *ListPartitionCursorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_pubsublite_v1_cursor_proto protoreflect.FileDescriptor

var file_google_cloud_pubsublite_v1_cursor_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x75, 0x72,
	0x73, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69,
	0x74, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74,
	0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x5e, 0x0a, 0x1a, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x22, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x1d, 0x0a, 0x1b, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5a, 0x0a, 0x1c, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3a, 0x0a, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75,
	0x72, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x22, 0x52, 0x0a, 0x1d,
	0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43,
	0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a,
	0x14, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x61, 0x63, 0x6b,
	0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73,
	0x22, 0xd1, 0x01, 0x0a, 0x1c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6d, 0x6d, 0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x52, 0x0a, 0x07, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x75, 0x72,
	0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x07, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x52, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48,
	0x00, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x22, 0xd4, 0x01, 0x0a, 0x1d, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x53, 0x0a, 0x07, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x48, 0x00, 0x52, 0x07, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x12, 0x53, 0x0a, 0x06, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x65, 0x64, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x42, 0x09, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0x93, 0x01, 0x0a, 0x13,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f,
	0x72, 0x22, 0x16, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f,
	0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa1, 0x01, 0x0a, 0x1b, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x72, 0x73, 0x6f,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6b, 0x0a,
	0x0f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72,
	0x12, 0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a,
	0x0a, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x73,
	0x6f, 0x72, 0x52, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x22, 0xa0, 0x01, 0x0a, 0x1c, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x72, 0x73,
	0x6f, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x11, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x72,
	0x73, 0x6f, 0x72, 0x52, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75,
	0x72, 0x73, 0x6f, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xc9, 0x04,
	0x0a, 0x0d, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x92, 0x01, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c,
	0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x28, 0x01, 0x30, 0x01, 0x12, 0x73, 0x0a, 0x0c, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x75,
	0x72, 0x73, 0x6f, 0x72, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0xde, 0x01, 0x0a, 0x14, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x72, 0x73, 0x6f,
	0x72, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x72,
	0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x72,
	0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x7b, 0x0a, 0x21, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42, 0x0b,
	0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x6c, 0x69, 0x74, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c,
	0x69, 0x74, 0x65, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_pubsublite_v1_cursor_proto_rawDescOnce sync.Once
	file_google_cloud_pubsublite_v1_cursor_proto_rawDescData = file_google_cloud_pubsublite_v1_cursor_proto_rawDesc
)

func file_google_cloud_pubsublite_v1_cursor_proto_rawDescGZIP() []byte {
	file_google_cloud_pubsublite_v1_cursor_proto_rawDescOnce.Do(func() {
		file_google_cloud_pubsublite_v1_cursor_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_pubsublite_v1_cursor_proto_rawDescData)
	})
	return file_google_cloud_pubsublite_v1_cursor_proto_rawDescData
}

var file_google_cloud_pubsublite_v1_cursor_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_pubsublite_v1_cursor_proto_goTypes = []interface{}{
	(*InitialCommitCursorRequest)(nil),    // 0: google.cloud.pubsublite.v1.InitialCommitCursorRequest
	(*InitialCommitCursorResponse)(nil),   // 1: google.cloud.pubsublite.v1.InitialCommitCursorResponse
	(*SequencedCommitCursorRequest)(nil),  // 2: google.cloud.pubsublite.v1.SequencedCommitCursorRequest
	(*SequencedCommitCursorResponse)(nil), // 3: google.cloud.pubsublite.v1.SequencedCommitCursorResponse
	(*StreamingCommitCursorRequest)(nil),  // 4: google.cloud.pubsublite.v1.StreamingCommitCursorRequest
	(*StreamingCommitCursorResponse)(nil), // 5: google.cloud.pubsublite.v1.StreamingCommitCursorResponse
	(*CommitCursorRequest)(nil),           // 6: google.cloud.pubsublite.v1.CommitCursorRequest
	(*CommitCursorResponse)(nil),          // 7: google.cloud.pubsublite.v1.CommitCursorResponse
	(*ListPartitionCursorsRequest)(nil),   // 8: google.cloud.pubsublite.v1.ListPartitionCursorsRequest
	(*PartitionCursor)(nil),               // 9: google.cloud.pubsublite.v1.PartitionCursor
	(*ListPartitionCursorsResponse)(nil),  // 10: google.cloud.pubsublite.v1.ListPartitionCursorsResponse
	(*Cursor)(nil),                        // 11: google.cloud.pubsublite.v1.Cursor
}
var file_google_cloud_pubsublite_v1_cursor_proto_depIdxs = []int32{
	11, // 0: google.cloud.pubsublite.v1.SequencedCommitCursorRequest.cursor:type_name -> google.cloud.pubsublite.v1.Cursor
	0,  // 1: google.cloud.pubsublite.v1.StreamingCommitCursorRequest.initial:type_name -> google.cloud.pubsublite.v1.InitialCommitCursorRequest
	2,  // 2: google.cloud.pubsublite.v1.StreamingCommitCursorRequest.commit:type_name -> google.cloud.pubsublite.v1.SequencedCommitCursorRequest
	1,  // 3: google.cloud.pubsublite.v1.StreamingCommitCursorResponse.initial:type_name -> google.cloud.pubsublite.v1.InitialCommitCursorResponse
	3,  // 4: google.cloud.pubsublite.v1.StreamingCommitCursorResponse.commit:type_name -> google.cloud.pubsublite.v1.SequencedCommitCursorResponse
	11, // 5: google.cloud.pubsublite.v1.CommitCursorRequest.cursor:type_name -> google.cloud.pubsublite.v1.Cursor
	11, // 6: google.cloud.pubsublite.v1.PartitionCursor.cursor:type_name -> google.cloud.pubsublite.v1.Cursor
	9,  // 7: google.cloud.pubsublite.v1.ListPartitionCursorsResponse.partition_cursors:type_name -> google.cloud.pubsublite.v1.PartitionCursor
	4,  // 8: google.cloud.pubsublite.v1.CursorService.StreamingCommitCursor:input_type -> google.cloud.pubsublite.v1.StreamingCommitCursorRequest
	6,  // 9: google.cloud.pubsublite.v1.CursorService.CommitCursor:input_type -> google.cloud.pubsublite.v1.CommitCursorRequest
	8,  // 10: google.cloud.pubsublite.v1.CursorService.ListPartitionCursors:input_type -> google.cloud.pubsublite.v1.ListPartitionCursorsRequest
	5,  // 11: google.cloud.pubsublite.v1.CursorService.StreamingCommitCursor:output_type -> google.cloud.pubsublite.v1.StreamingCommitCursorResponse
	7,  // 12: google.cloud.pubsublite.v1.CursorService.CommitCursor:output_type -> google.cloud.pubsublite.v1.CommitCursorResponse
	10, // 13: google.cloud.pubsublite.v1.CursorService.ListPartitionCursors:output_type -> google.cloud.pubsublite.v1.ListPartitionCursorsResponse
	11, // [11:14] is the sub-list for method output_type
	8,  // [8:11] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_pubsublite_v1_cursor_proto_init() }
func file_google_cloud_pubsublite_v1_cursor_proto_init() {
	if File_google_cloud_pubsublite_v1_cursor_proto != nil {
		return
	}
	file_google_cloud_pubsublite_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitialCommitCursorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitialCommitCursorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SequencedCommitCursorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SequencedCommitCursorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingCommitCursorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamingCommitCursorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitCursorRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitCursorResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPartitionCursorsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PartitionCursor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPartitionCursorsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*StreamingCommitCursorRequest_Initial)(nil),
		(*StreamingCommitCursorRequest_Commit)(nil),
	}
	file_google_cloud_pubsublite_v1_cursor_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*StreamingCommitCursorResponse_Initial)(nil),
		(*StreamingCommitCursorResponse_Commit)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_pubsublite_v1_cursor_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_pubsublite_v1_cursor_proto_goTypes,
		DependencyIndexes: file_google_cloud_pubsublite_v1_cursor_proto_depIdxs,
		MessageInfos:      file_google_cloud_pubsublite_v1_cursor_proto_msgTypes,
	}.Build()
	File_google_cloud_pubsublite_v1_cursor_proto = out.File
	file_google_cloud_pubsublite_v1_cursor_proto_rawDesc = nil
	file_google_cloud_pubsublite_v1_cursor_proto_goTypes = nil
	file_google_cloud_pubsublite_v1_cursor_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CursorServiceClient is the client API for CursorService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CursorServiceClient interface {
	// Establishes a stream with the server for managing committed cursors.
	StreamingCommitCursor(ctx context.Context, opts ...grpc.CallOption) (CursorService_StreamingCommitCursorClient, error)
	// Updates the committed cursor.
	CommitCursor(ctx context.Context, in *CommitCursorRequest, opts ...grpc.CallOption) (*CommitCursorResponse, error)
	// Returns all committed cursor information for a subscription.
	ListPartitionCursors(ctx context.Context, in *ListPartitionCursorsRequest, opts ...grpc.CallOption) (*ListPartitionCursorsResponse, error)
}

type cursorServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCursorServiceClient(cc grpc.ClientConnInterface) CursorServiceClient {
	return &cursorServiceClient{cc}
}

func (c *cursorServiceClient) StreamingCommitCursor(ctx context.Context, opts ...grpc.CallOption) (CursorService_StreamingCommitCursorClient, error) {
	stream, err := c.cc.NewStream(ctx, &_CursorService_serviceDesc.Streams[0], "/google.cloud.pubsublite.v1.CursorService/StreamingCommitCursor", opts...)
	if err != nil {
		return nil, err
	}
	x := &cursorServiceStreamingCommitCursorClient{stream}
	return x, nil
}

type CursorService_StreamingCommitCursorClient interface {
	Send(*StreamingCommitCursorRequest) error
	Recv() (*StreamingCommitCursorResponse, error)
	grpc.ClientStream
}

type cursorServiceStreamingCommitCursorClient struct {
	grpc.ClientStream
}

func (x *cursorServiceStreamingCommitCursorClient) Send(m *StreamingCommitCursorRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *cursorServiceStreamingCommitCursorClient) Recv() (*StreamingCommitCursorResponse, error) {
	m := new(StreamingCommitCursorResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *cursorServiceClient) CommitCursor(ctx context.Context, in *CommitCursorRequest, opts ...grpc.CallOption) (*CommitCursorResponse, error) {
	out := new(CommitCursorResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.pubsublite.v1.CursorService/CommitCursor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cursorServiceClient) ListPartitionCursors(ctx context.Context, in *ListPartitionCursorsRequest, opts ...grpc.CallOption) (*ListPartitionCursorsResponse, error) {
	out := new(ListPartitionCursorsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.pubsublite.v1.CursorService/ListPartitionCursors", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CursorServiceServer is the server API for CursorService service.
type CursorServiceServer interface {
	// Establishes a stream with the server for managing committed cursors.
	StreamingCommitCursor(CursorService_StreamingCommitCursorServer) error
	// Updates the committed cursor.
	CommitCursor(context.Context, *CommitCursorRequest) (*CommitCursorResponse, error)
	// Returns all committed cursor information for a subscription.
	ListPartitionCursors(context.Context, *ListPartitionCursorsRequest) (*ListPartitionCursorsResponse, error)
}

// UnimplementedCursorServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCursorServiceServer struct {
}

func (*UnimplementedCursorServiceServer) StreamingCommitCursor(CursorService_StreamingCommitCursorServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingCommitCursor not implemented")
}
func (*UnimplementedCursorServiceServer) CommitCursor(context.Context, *CommitCursorRequest) (*CommitCursorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitCursor not implemented")
}
func (*UnimplementedCursorServiceServer) ListPartitionCursors(context.Context, *ListPartitionCursorsRequest) (*ListPartitionCursorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPartitionCursors not implemented")
}

func RegisterCursorServiceServer(s *grpc.Server, srv CursorServiceServer) {
	s.RegisterService(&_CursorService_serviceDesc, srv)
}

func _CursorService_StreamingCommitCursor_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(CursorServiceServer).StreamingCommitCursor(&cursorServiceStreamingCommitCursorServer{stream})
}

type CursorService_StreamingCommitCursorServer interface {
	Send(*StreamingCommitCursorResponse) error
	Recv() (*StreamingCommitCursorRequest, error)
	grpc.ServerStream
}

type cursorServiceStreamingCommitCursorServer struct {
	grpc.ServerStream
}

func (x *cursorServiceStreamingCommitCursorServer) Send(m *StreamingCommitCursorResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *cursorServiceStreamingCommitCursorServer) Recv() (*StreamingCommitCursorRequest, error) {
	m := new(StreamingCommitCursorRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _CursorService_CommitCursor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitCursorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CursorServiceServer).CommitCursor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.pubsublite.v1.CursorService/CommitCursor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CursorServiceServer).CommitCursor(ctx, req.(*CommitCursorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CursorService_ListPartitionCursors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPartitionCursorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CursorServiceServer).ListPartitionCursors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.pubsublite.v1.CursorService/ListPartitionCursors",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CursorServiceServer).ListPartitionCursors(ctx, req.(*ListPartitionCursorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CursorService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.pubsublite.v1.CursorService",
	HandlerType: (*CursorServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CommitCursor",
			Handler:    _CursorService_CommitCursor_Handler,
		},
		{
			MethodName: "ListPartitionCursors",
			Handler:    _CursorService_ListPartitionCursors_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingCommitCursor",
			Handler:       _CursorService_StreamingCommitCursor_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/pubsublite/v1/cursor.proto",
}
