// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1beta2/video_intelligence.proto

package videointelligence

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Human face detection and tracking.
	Feature_FACE_DETECTION Feature = 4
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	4: "FACE_DETECTION",
}

var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"FACE_DETECTION":             4,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}

func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}

var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}

func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}

var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}

func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{2}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris). A video
	// URI may include wildcards in `object-id`, and thus identify multiple
	// videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1beta2.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{0}
}

func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(m, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video
	// is treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for FACE_DETECTION.
	FaceDetectionConfig  *FaceDetectionConfig `protobuf:"bytes,5,opt,name=face_detection_config,json=faceDetectionConfig,proto3" json:"face_detection_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{1}
}

func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (m *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(m, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetFaceDetectionConfig() *FaceDetectionConfig {
	if m != nil {
		return m.FaceDetectionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1beta2.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{2}
}

func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (m *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(m, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{3}
}

func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(m, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{4}
}

func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (m *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(m, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for FACE_DETECTION.
type FaceDetectionConfig struct {
	// Model to use for face detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Whether bounding boxes be included in the face annotation output.
	IncludeBoundingBoxes bool     `protobuf:"varint,2,opt,name=include_bounding_boxes,json=includeBoundingBoxes,proto3" json:"include_bounding_boxes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaceDetectionConfig) Reset()         { *m = FaceDetectionConfig{} }
func (m *FaceDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*FaceDetectionConfig) ProtoMessage()    {}
func (*FaceDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{5}
}

func (m *FaceDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceDetectionConfig.Unmarshal(m, b)
}
func (m *FaceDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceDetectionConfig.Marshal(b, m, deterministic)
}
func (m *FaceDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceDetectionConfig.Merge(m, src)
}
func (m *FaceDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_FaceDetectionConfig.Size(m)
}
func (m *FaceDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FaceDetectionConfig proto.InternalMessageInfo

func (m *FaceDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *FaceDetectionConfig) GetIncludeBoundingBoxes() bool {
	if m != nil {
		return m.IncludeBoundingBoxes
	}
	return false
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{6}
}

func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (m *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(m, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{7}
}

func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (m *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(m, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{8}
}

func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (m *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(m, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{9}
}

func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (m *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(m, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{10}
}

func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (m *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(m, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1beta2.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{11}
}

func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (m *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(m, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{12}
}

func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (m *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(m, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left,proto3" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top,proto3" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom               float32  `protobuf:"fixed32,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedBoundingBox) Reset()         { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()    {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{13}
}

func (m *NormalizedBoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingBox.Unmarshal(m, b)
}
func (m *NormalizedBoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingBox.Marshal(b, m, deterministic)
}
func (m *NormalizedBoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingBox.Merge(m, src)
}
func (m *NormalizedBoundingBox) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingBox.Size(m)
}
func (m *NormalizedBoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingBox proto.InternalMessageInfo

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// Video segment level annotation results for face detection.
type FaceSegment struct {
	// Video segment where a face was detected.
	Segment              *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *FaceSegment) Reset()         { *m = FaceSegment{} }
func (m *FaceSegment) String() string { return proto.CompactTextString(m) }
func (*FaceSegment) ProtoMessage()    {}
func (*FaceSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{14}
}

func (m *FaceSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceSegment.Unmarshal(m, b)
}
func (m *FaceSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceSegment.Marshal(b, m, deterministic)
}
func (m *FaceSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceSegment.Merge(m, src)
}
func (m *FaceSegment) XXX_Size() int {
	return xxx_messageInfo_FaceSegment.Size(m)
}
func (m *FaceSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceSegment.DiscardUnknown(m)
}

var xxx_messageInfo_FaceSegment proto.InternalMessageInfo

func (m *FaceSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

// Video frame level annotation results for face detection.
type FaceFrame struct {
	// Normalized Bounding boxes in a frame.
	// There can be more than one boxes if the same face is detected in multiple
	// locations within the current frame.
	NormalizedBoundingBoxes []*NormalizedBoundingBox `protobuf:"bytes,1,rep,name=normalized_bounding_boxes,json=normalizedBoundingBoxes,proto3" json:"normalized_bounding_boxes,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this location.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *FaceFrame) Reset()         { *m = FaceFrame{} }
func (m *FaceFrame) String() string { return proto.CompactTextString(m) }
func (*FaceFrame) ProtoMessage()    {}
func (*FaceFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{15}
}

func (m *FaceFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceFrame.Unmarshal(m, b)
}
func (m *FaceFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceFrame.Marshal(b, m, deterministic)
}
func (m *FaceFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceFrame.Merge(m, src)
}
func (m *FaceFrame) XXX_Size() int {
	return xxx_messageInfo_FaceFrame.Size(m)
}
func (m *FaceFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceFrame.DiscardUnknown(m)
}

var xxx_messageInfo_FaceFrame proto.InternalMessageInfo

func (m *FaceFrame) GetNormalizedBoundingBoxes() []*NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBoxes
	}
	return nil
}

func (m *FaceFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Face annotation.
type FaceAnnotation struct {
	// Thumbnail of a representative face view (in JPEG format).
	Thumbnail []byte `protobuf:"bytes,1,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	// All video segments where a face was detected.
	Segments []*FaceSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a face was detected.
	Frames               []*FaceFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *FaceAnnotation) Reset()         { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()    {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{16}
}

func (m *FaceAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation.Unmarshal(m, b)
}
func (m *FaceAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation.Marshal(b, m, deterministic)
}
func (m *FaceAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation.Merge(m, src)
}
func (m *FaceAnnotation) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation.Size(m)
}
func (m *FaceAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation proto.InternalMessageInfo

func (m *FaceAnnotation) GetThumbnail() []byte {
	if m != nil {
		return m.Thumbnail
	}
	return nil
}

func (m *FaceAnnotation) GetSegments() []*FaceSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *FaceAnnotation) GetFrames() []*FaceFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Face annotations. There is exactly one element for each unique face.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,5,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{17}
}

func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(m, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{18}
}

func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(m, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far.
	// Guaranteed to be 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{19}
}

func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (m *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(m, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_84237f664d80452c, []int{20}
}

func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (m *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(m, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.videointelligence.v1beta2.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta2.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1beta2.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1beta2.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1beta2.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.ExplicitContentDetectionConfig")
	proto.RegisterType((*FaceDetectionConfig)(nil), "google.cloud.videointelligence.v1beta2.FaceDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1beta2.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1beta2.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1beta2.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1beta2.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1beta2.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1beta2.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1beta2.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1beta2.NormalizedBoundingBox")
	proto.RegisterType((*FaceSegment)(nil), "google.cloud.videointelligence.v1beta2.FaceSegment")
	proto.RegisterType((*FaceFrame)(nil), "google.cloud.videointelligence.v1beta2.FaceFrame")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.videointelligence.v1beta2.FaceAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1beta2.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1beta2.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1beta2.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1beta2.AnnotateVideoProgress")
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1beta2/video_intelligence.proto", fileDescriptor_84237f664d80452c)
}

var fileDescriptor_84237f664d80452c = []byte{
	// 1736 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xcd, 0x6f, 0xdb, 0xc8,
	0x15, 0x2f, 0x29, 0xd9, 0xb1, 0x9e, 0xbf, 0x94, 0xf1, 0x97, 0xec, 0x26, 0x5e, 0x97, 0x29, 0x16,
	0x5e, 0x17, 0x90, 0x10, 0xef, 0x62, 0x8b, 0x2a, 0xdb, 0x2e, 0x64, 0x99, 0xde, 0xa8, 0xeb, 0x48,
	0x06, 0xa5, 0xa4, 0x4d, 0x9b, 0x82, 0xa0, 0xc8, 0x11, 0x45, 0x2c, 0xc5, 0xe1, 0x92, 0xc3, 0x20,
	0xee, 0xa1, 0x87, 0x3d, 0x2c, 0xd0, 0x63, 0xd1, 0x4b, 0xff, 0x80, 0x9e, 0x7a, 0xe8, 0x7f, 0x50,
	0xa0, 0xe8, 0xa5, 0xc0, 0x5e, 0xdb, 0x4b, 0x2f, 0x3d, 0xf5, 0x54, 0xf4, 0x8f, 0x28, 0x38, 0x33,
	0x94, 0x28, 0x52, 0x8e, 0xa5, 0x18, 0x7b, 0xe3, 0xbc, 0x8f, 0xdf, 0xfb, 0x98, 0xf7, 0xde, 0xcc,
	0x10, 0x3e, 0xb5, 0x09, 0xb1, 0x5d, 0x5c, 0x33, 0x5d, 0x12, 0x59, 0xb5, 0xd7, 0x8e, 0x85, 0x89,
	0xe3, 0x51, 0xec, 0xba, 0x8e, 0x8d, 0x3d, 0x13, 0xd7, 0x5e, 0x3f, 0xee, 0x63, 0x6a, 0x9c, 0x72,
	0x8e, 0x9e, 0x66, 0x55, 0xfd, 0x80, 0x50, 0x82, 0xde, 0xe7, 0x00, 0x55, 0x06, 0x50, 0xcd, 0x01,
	0x54, 0x05, 0xc0, 0xc1, 0x03, 0x61, 0xc8, 0xf0, 0x9d, 0x9a, 0xe1, 0x79, 0x84, 0x1a, 0xd4, 0x21,
	0x5e, 0xc8, 0x51, 0x0e, 0x1e, 0x09, 0xae, 0x4b, 0x3c, 0x3b, 0x88, 0x3c, 0xcf, 0xf1, 0xec, 0x1a,
	0xf1, 0x71, 0x30, 0x25, 0x74, 0x28, 0x84, 0xd8, 0xaa, 0x1f, 0x0d, 0x6a, 0x56, 0xc4, 0x05, 0x04,
	0xff, 0xbd, 0x2c, 0x9f, 0x3a, 0x23, 0x1c, 0x52, 0x63, 0xe4, 0x0b, 0x81, 0x3d, 0x21, 0x10, 0xf8,
	0x66, 0x2d, 0xa4, 0x06, 0x8d, 0x04, 0xb2, 0xf2, 0x57, 0x19, 0xb6, 0x1b, 0xdc, 0x29, 0xfc, 0x22,
	0x0e, 0x41, 0xc3, 0x5f, 0x46, 0x38, 0xa4, 0xe8, 0xbb, 0x50, 0x72, 0x3c, 0x3f, 0xa2, 0x7a, 0x14,
	0x38, 0x15, 0xe9, 0x48, 0x3a, 0x2e, 0x69, 0x2b, 0x8c, 0xf0, 0x3c, 0x70, 0xd0, 0x23, 0x58, 0xe7,
	0x4c, 0x93, 0x78, 0x14, 0x7b, 0xb4, 0xb2, 0x7c, 0x24, 0x1d, 0xaf, 0x69, 0x6b, 0x8c, 0xd8, 0xe4,
	0x34, 0xf4, 0x39, 0xac, 0x0c, 0xb0, 0x41, 0xa3, 0x00, 0x87, 0x15, 0xf9, 0xa8, 0x70, 0xbc, 0x71,
	0x5a, 0xab, 0xce, 0x97, 0xb2, 0xea, 0x05, 0xd7, 0xd3, 0xc6, 0x00, 0xe8, 0x25, 0xac, 0xf3, 0x8d,
	0x60, 0x16, 0xdf, 0xd0, 0x4a, 0xe1, 0x48, 0x3a, 0x5e, 0x3d, 0xfd, 0x68, 0x5e, 0x44, 0x16, 0x5b,
	0x93, 0xeb, 0x6a, 0x6b, 0xaf, 0x53, 0x2b, 0xf4, 0x10, 0x80, 0x44, 0x34, 0x09, 0xb5, 0xc8, 0x42,
	0x2d, 0x71, 0x4a, 0x1c, 0xeb, 0x7b, 0xb0, 0xea, 0x12, 0x93, 0x65, 0x5b, 0x77, 0xac, 0xca, 0x12,
	0xe3, 0x43, 0x42, 0x6a, 0x59, 0xca, 0xbf, 0x8b, 0xb0, 0x96, 0x86, 0x47, 0x57, 0xb0, 0x12, 0x62,
	0x7b, 0x84, 0x3d, 0x1a, 0x56, 0xa4, 0xa3, 0xc2, 0xc2, 0x6e, 0x76, 0xb9, 0xb2, 0x36, 0x46, 0x41,
	0x01, 0xec, 0xba, 0x46, 0x1f, 0xbb, 0xba, 0x85, 0x29, 0x36, 0x99, 0x2b, 0x26, 0xf1, 0x06, 0x8e,
	0x5d, 0x91, 0x59, 0x1a, 0x3e, 0x99, 0x17, 0xff, 0x32, 0x46, 0x39, 0x4f, 0x40, 0x9a, 0x0c, 0x43,
	0xdb, 0x76, 0x67, 0x50, 0xd1, 0x57, 0x12, 0x3c, 0x08, 0x87, 0x84, 0xea, 0xe6, 0xd0, 0xf0, 0x6c,
	0x9c, 0x37, 0xcd, 0x77, 0xa0, 0x31, 0xaf, 0xe9, 0xee, 0x90, 0xd0, 0x26, 0x83, 0xca, 0xda, 0xdf,
	0x0f, 0x6f, 0x62, 0xa1, 0xdf, 0x49, 0xf0, 0x3d, 0xfc, 0xc6, 0x77, 0x1d, 0xd3, 0x19, 0x17, 0x5b,
	0xde, 0x93, 0x22, 0xf3, 0xe4, 0x62, 0x5e, 0x4f, 0x54, 0x01, 0x28, 0x0a, 0x35, 0xeb, 0xce, 0x21,
	0x7e, 0x2b, 0x1f, 0x11, 0xd8, 0x19, 0x18, 0xe6, 0x8c, 0x84, 0x2c, 0x31, 0x37, 0x9e, 0xcc, 0x5d,
	0xe4, 0x86, 0x99, 0x4b, 0xc5, 0xd6, 0x20, 0x4f, 0x54, 0xfe, 0x2e, 0xc1, 0xf6, 0xac, 0x8d, 0x43,
	0x2e, 0x6c, 0x67, 0xcb, 0x62, 0x44, 0x2c, 0xcc, 0xda, 0x75, 0xe3, 0xb4, 0xfe, 0x6e, 0x45, 0xf1,
	0x8c, 0x58, 0x58, 0x43, 0x6e, 0x8e, 0x86, 0x7e, 0x00, 0xf7, 0x43, 0x3e, 0xbb, 0x8c, 0xe0, 0x5a,
	0x37, 0x8d, 0x11, 0x0e, 0x0c, 0x56, 0x7f, 0x2b, 0x5a, 0x79, 0xc2, 0x68, 0x32, 0x3a, 0xda, 0x86,
	0xa5, 0xd8, 0x15, 0x97, 0x55, 0x49, 0x49, 0xe3, 0x0b, 0xe5, 0x31, 0xec, 0xdf, 0x58, 0x06, 0x13,
	0x15, 0x29, 0xad, 0xf2, 0x31, 0x1c, 0xbe, 0x7d, 0xbf, 0x6e, 0xd0, 0x33, 0x60, 0x6b, 0x46, 0x82,
	0x67, 0x0b, 0xa3, 0x8f, 0x60, 0xd7, 0xf1, 0x4c, 0x37, 0xb2, 0xb0, 0xde, 0x27, 0x91, 0x67, 0x39,
	0x9e, 0xad, 0xf7, 0xc9, 0x1b, 0x36, 0xb8, 0xe2, 0xf8, 0xb6, 0x05, 0xf7, 0x4c, 0x30, 0xcf, 0x62,
	0x9e, 0xf2, 0x07, 0x49, 0x34, 0xbe, 0x68, 0x58, 0xa4, 0xb2, 0x0c, 0x05, 0x54, 0x8f, 0xc7, 0xaf,
	0x4e, 0x06, 0x83, 0x10, 0x53, 0x66, 0x68, 0xf5, 0x74, 0x3f, 0xd9, 0x8c, 0x64, 0x44, 0x57, 0xcf,
	0xc5, 0x08, 0xd7, 0x36, 0x99, 0x4e, 0xcf, 0x19, 0xe1, 0x0e, 0xd3, 0x40, 0x0d, 0xd8, 0xc4, 0x9e,
	0x35, 0x05, 0x22, 0xdf, 0x06, 0xb2, 0x8e, 0x3d, 0x6b, 0x02, 0xa1, 0xfc, 0x06, 0xd6, 0xd8, 0xae,
	0x26, 0x9e, 0xb5, 0xe1, 0x9e, 0x18, 0x26, 0xc2, 0x9f, 0x77, 0x9b, 0x48, 0x09, 0x08, 0x3a, 0x04,
	0x60, 0x45, 0x6f, 0xc5, 0xb2, 0xcc, 0x3b, 0x59, 0x4b, 0x51, 0x94, 0x21, 0x00, 0xb3, 0x7f, 0x11,
	0x18, 0x23, 0x8c, 0xea, 0xb0, 0xba, 0x50, 0x46, 0x80, 0x4e, 0x92, 0x71, 0x9b, 0x25, 0x17, 0x96,
	0x55, 0x8f, 0x3a, 0xf4, 0x3a, 0x3e, 0xb1, 0x30, 0xfb, 0x8a, 0xc7, 0xb4, 0x38, 0xb1, 0x38, 0xa1,
	0x65, 0xa1, 0x23, 0x58, 0xb5, 0x70, 0x68, 0x06, 0x8e, 0x1f, 0x5b, 0x60, 0x38, 0x25, 0x2d, 0x4d,
	0x8a, 0xcf, 0x34, 0xd7, 0xf0, 0xec, 0xc8, 0xb0, 0xb1, 0x6e, 0xc6, 0x5d, 0xc4, 0x2b, 0x77, 0x2d,
	0x21, 0x36, 0x89, 0x85, 0x95, 0x7f, 0xca, 0xb0, 0xc9, 0x02, 0x6b, 0x8c, 0x0f, 0x72, 0x74, 0x01,
	0xcb, 0xdc, 0x8c, 0x08, 0xac, 0x3a, 0xf7, 0x1c, 0x62, 0x5a, 0x9a, 0xd0, 0x46, 0xbf, 0x84, 0xfb,
	0xa6, 0x41, 0xb1, 0x4d, 0x82, 0x6b, 0x9d, 0x91, 0x1c, 0x71, 0x70, 0x2e, 0x0e, 0x59, 0x4e, 0x80,
	0x54, 0x81, 0x33, 0x75, 0x26, 0x15, 0x16, 0x3b, 0x93, 0xd2, 0x85, 0x94, 0x3a, 0x93, 0x7e, 0x0a,
	0xcb, 0x83, 0x78, 0x77, 0xc3, 0x4a, 0x91, 0xe1, 0x9d, 0x2e, 0x84, 0xc7, 0x0a, 0x43, 0x13, 0x08,
	0xca, 0x5f, 0x24, 0xd8, 0xce, 0x74, 0xf9, 0xdd, 0x2b, 0xc7, 0x81, 0x5d, 0x9f, 0x04, 0x1e, 0xb1,
	0x03, 0xc3, 0x1f, 0x5e, 0xeb, 0xae, 0xf3, 0x05, 0x76, 0x9d, 0x21, 0x21, 0x16, 0xdb, 0xfd, 0x8d,
	0x05, 0x1c, 0x1e, 0x6b, 0x6a, 0x3b, 0x29, 0xc4, 0x09, 0x59, 0xf9, 0x12, 0xf6, 0x33, 0xee, 0xa7,
	0xea, 0xa3, 0x37, 0x4e, 0x14, 0xbf, 0x0c, 0x7c, 0xf2, 0x8e, 0xe7, 0xd4, 0x74, 0xca, 0xbe, 0x80,
	0x9d, 0x36, 0x09, 0x46, 0x86, 0xeb, 0xfc, 0x1a, 0x5b, 0xa9, 0xb9, 0x84, 0x10, 0x14, 0x5d, 0x3c,
	0xe0, 0xb9, 0x92, 0x35, 0xf6, 0x8d, 0xca, 0x50, 0xa0, 0xc4, 0x17, 0xdd, 0x13, 0x7f, 0xc6, 0x73,
	0x30, 0x70, 0xec, 0x21, 0xbf, 0x47, 0xc9, 0x1a, 0x5f, 0xa0, 0x5d, 0x58, 0xee, 0x13, 0x4a, 0xc9,
	0x88, 0x1d, 0xa9, 0xb2, 0x26, 0x56, 0xca, 0xaf, 0x60, 0x35, 0x1e, 0xa6, 0xdf, 0xd2, 0x34, 0x51,
	0xfe, 0x26, 0x41, 0x29, 0xc6, 0xe7, 0x7b, 0x7e, 0x0d, 0xfb, 0xde, 0x38, 0xb2, 0xec, 0x3c, 0xe6,
	0x29, 0xfc, 0xf1, 0xbc, 0xf6, 0x66, 0xa6, 0x48, 0xdb, 0xf3, 0x66, 0x91, 0x71, 0x98, 0x2d, 0x37,
	0x79, 0x81, 0x72, 0x53, 0xbe, 0x91, 0x60, 0x23, 0x0e, 0x22, 0xb5, 0xf3, 0x0f, 0xa0, 0x44, 0x87,
	0xd1, 0xa8, 0xef, 0x19, 0x0e, 0x3f, 0x70, 0xd6, 0xb4, 0x09, 0x01, 0x75, 0x52, 0x2d, 0xc9, 0xdb,
	0xfc, 0xc3, 0x45, 0xae, 0x0e, 0xf9, 0x8e, 0x6c, 0x8d, 0x0b, 0x8d, 0x77, 0xf8, 0xe3, 0x45, 0xe0,
	0xa6, 0xab, 0xeb, 0x7f, 0x4b, 0xb0, 0xcb, 0xf6, 0x6a, 0x12, 0x8d, 0x86, 0xc3, 0xc8, 0xa5, 0xe1,
	0xdb, 0x1f, 0x06, 0x21, 0xec, 0x0b, 0x77, 0x74, 0x7e, 0x33, 0x49, 0x3d, 0x78, 0x44, 0x90, 0x3f,
	0x5c, 0x68, 0x4e, 0xa4, 0xec, 0xef, 0x09, 0xe4, 0x0c, 0x3d, 0x44, 0x23, 0xd8, 0x65, 0x17, 0xd5,
	0xbc, 0xc5, 0xc2, 0xdd, 0x2c, 0x6e, 0xc7, 0xb0, 0x39, 0x73, 0x04, 0xf6, 0x58, 0x96, 0x66, 0xd8,
	0x2b, 0xde, 0xcd, 0xde, 0x0e, 0xc3, 0xcd, 0x19, 0x34, 0xa0, 0xcc, 0x2e, 0x9c, 0x69, 0x4b, 0x4b,
	0xcc, 0xd2, 0xc7, 0x8b, 0xec, 0x70, 0xca, 0xd0, 0xe6, 0x60, 0x6a, 0x1d, 0x22, 0x1d, 0xca, 0x2c,
	0x85, 0x69, 0x13, 0xcb, 0x77, 0x78, 0xba, 0x6c, 0xc6, 0x68, 0x69, 0x03, 0x01, 0x6c, 0x8d, 0xef,
	0xf1, 0x13, 0x23, 0x95, 0x7b, 0x8b, 0xbd, 0x21, 0x6e, 0x1c, 0xb2, 0x1a, 0x4a, 0xd0, 0x53, 0xed,
	0x77, 0x0c, 0x4b, 0x38, 0x08, 0x48, 0x50, 0x29, 0x31, 0x2b, 0x28, 0xb1, 0x12, 0xf8, 0x66, 0xb5,
	0xcb, 0x1e, 0xc1, 0x1a, 0x17, 0x50, 0xbe, 0x96, 0x60, 0x27, 0xf3, 0x0a, 0x0e, 0x7d, 0xe2, 0x85,
	0x18, 0x8d, 0x00, 0x4d, 0xdc, 0xd5, 0x03, 0xde, 0x03, 0x62, 0x0a, 0xfd, 0x64, 0xa1, 0xd4, 0xe4,
	0x3a, 0x49, 0xbb, 0x6f, 0x64, 0x49, 0xca, 0xbf, 0x24, 0xd8, 0xcb, 0x48, 0x5f, 0x05, 0xc4, 0x0e,
	0x70, 0x78, 0x4b, 0xe3, 0x7d, 0x00, 0x65, 0x5f, 0x08, 0xea, 0x3e, 0x0e, 0xcc, 0x78, 0x36, 0xc7,
	0xe3, 0x6b, 0x49, 0xdb, 0x4c, 0xe8, 0x57, 0x9c, 0x8c, 0x7e, 0x04, 0x30, 0xb9, 0xa5, 0x8a, 0x57,
	0xdc, 0x41, 0x6e, 0xc6, 0xf5, 0x92, 0x3f, 0x08, 0x5a, 0x69, 0x7c, 0x3f, 0x45, 0x4f, 0x60, 0x35,
	0xf2, 0x2d, 0x83, 0x62, 0xae, 0x5b, 0xbc, 0x55, 0x17, 0xb8, 0x78, 0x4c, 0x50, 0x7e, 0x9b, 0x4d,
	0xf2, 0x38, 0x32, 0x1f, 0xb6, 0x52, 0x49, 0x4e, 0xfc, 0x15, 0x59, 0xfe, 0xf4, 0x1d, 0xb3, 0x9c,
	0xa0, 0x6b, 0xa9, 0x0d, 0x4c, 0x68, 0x27, 0x5f, 0x4b, 0x70, 0x4f, 0xfc, 0x64, 0x40, 0x7b, 0xb0,
	0x75, 0xa1, 0x36, 0x7a, 0xcf, 0x35, 0x55, 0x7f, 0xde, 0xee, 0x5e, 0xa9, 0xcd, 0xd6, 0x45, 0x4b,
	0x3d, 0x2f, 0x7f, 0x07, 0x6d, 0xc1, 0xe6, 0x65, 0xe3, 0x4c, 0xbd, 0xd4, 0xcf, 0xd5, 0x9e, 0xda,
	0xec, 0xb5, 0x3a, 0xed, 0xb2, 0x84, 0xf6, 0x61, 0xa7, 0xfb, 0xb4, 0xd3, 0xd3, 0x9b, 0x4f, 0x1b,
	0xed, 0xcf, 0xd4, 0x14, 0x4b, 0x46, 0x87, 0x70, 0xa0, 0xfe, 0xfc, 0xea, 0xb2, 0xd5, 0x6c, 0xf5,
	0xf4, 0x66, 0xa7, 0xdd, 0x53, 0xdb, 0xbd, 0x14, 0xbf, 0x80, 0x10, 0x6c, 0x5c, 0x34, 0x9a, 0x69,
	0x9d, 0xe2, 0x49, 0x00, 0x28, 0xff, 0xfc, 0x42, 0xdf, 0x87, 0xa3, 0x8c, 0x65, 0xfd, 0x59, 0xe7,
	0x3c, 0xeb, 0xdf, 0x3a, 0x94, 0x98, 0x2b, 0x31, 0xab, 0x2c, 0xa1, 0x0d, 0x80, 0x0b, 0xad, 0xf1,
	0x4c, 0xe5, 0x6b, 0x39, 0x8e, 0x8b, 0xb1, 0x1b, 0xed, 0x73, 0x3d, 0xc5, 0x28, 0x9c, 0x50, 0x80,
	0xc9, 0xdd, 0x05, 0x1d, 0xc0, 0xee, 0x65, 0xeb, 0x73, 0xf5, 0xb2, 0xf5, 0xb4, 0xd3, 0x39, 0xcf,
	0x58, 0xb8, 0x0f, 0xeb, 0x2f, 0x54, 0xed, 0xa5, 0xfe, 0xbc, 0xcd, 0x44, 0x5e, 0x96, 0x25, 0xb4,
	0x06, 0x2b, 0xe3, 0x95, 0x1c, 0xaf, 0xae, 0x3a, 0xdd, 0x6e, 0xeb, 0xec, 0x52, 0x2d, 0x17, 0x10,
	0xc0, 0xb2, 0xe0, 0x14, 0xd1, 0x26, 0xac, 0x32, 0x55, 0x41, 0x58, 0x3a, 0xfd, 0xb3, 0x04, 0x15,
	0xb6, 0x45, 0xad, 0xd4, 0xe6, 0x75, 0x71, 0xf0, 0xda, 0x31, 0x71, 0xfc, 0xce, 0x5f, 0x9f, 0xaa,
	0x0d, 0x34, 0xf7, 0x2d, 0x69, 0xd6, 0xdf, 0xab, 0x83, 0x87, 0x89, 0x76, 0xea, 0xb7, 0x5a, 0xb5,
	0x93, 0xfc, 0x56, 0x53, 0x1e, 0x7d, 0xf5, 0x8f, 0xff, 0xfc, 0x5e, 0x7e, 0xa8, 0x54, 0xa6, 0xff,
	0xf2, 0x85, 0x75, 0x51, 0x2a, 0xb8, 0x2e, 0x9d, 0x9c, 0xfd, 0x51, 0x86, 0x13, 0x93, 0x8c, 0xe6,
	0xf4, 0xe3, 0xec, 0xe1, 0x4d, 0xc1, 0x5d, 0xc5, 0x6d, 0x71, 0x25, 0xfd, 0xe2, 0x67, 0x02, 0xc8,
	0x26, 0xf1, 0x93, 0xa2, 0x4a, 0x02, 0xbb, 0x66, 0x63, 0x8f, 0x35, 0x4d, 0x8d, 0xb3, 0x0c, 0xdf,
	0x09, 0x6f, 0xfb, 0x1f, 0xf9, 0x24, 0xc7, 0xf9, 0x93, 0xfc, 0xfe, 0x67, 0x1c, 0xb9, 0xc9, 0x5c,
	0xcc, 0xf9, 0x51, 0x7d, 0xf1, 0xf8, 0x2c, 0x56, 0xfd, 0x26, 0x11, 0x7c, 0xc5, 0x04, 0x5f, 0xe5,
	0x04, 0x5f, 0xbd, 0xe0, 0x36, 0xfe, 0x2b, 0x7f, 0xc0, 0x05, 0xeb, 0x75, 0x26, 0x59, 0xaf, 0xe7,
	0x44, 0xeb, 0x75, 0x21, 0xdb, 0x5f, 0x66, 0x11, 0x7c, 0xf8, 0xff, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xf3, 0x71, 0x6c, 0x41, 0x50, 0x15, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1beta2.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

// UnimplementedVideoIntelligenceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVideoIntelligenceServiceServer struct {
}

func (*UnimplementedVideoIntelligenceServiceServer) AnnotateVideo(ctx context.Context, req *AnnotateVideoRequest) (*longrunning.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnnotateVideo not implemented")
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1beta2.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1beta2.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1beta2/video_intelligence.proto",
}
