/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/ovn-org/ovn-kubernetes/go-controller/pkg/crd/egressfirewall/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// EgressFirewallLister helps list EgressFirewalls.
// All objects returned here must be treated as read-only.
type EgressFirewallLister interface {
	// List lists all EgressFirewalls in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.EgressFirewall, err error)
	// EgressFirewalls returns an object that can list and get EgressFirewalls.
	EgressFirewalls(namespace string) EgressFirewallNamespaceLister
	EgressFirewallListerExpansion
}

// egressFirewallLister implements the EgressFirewallLister interface.
type egressFirewallLister struct {
	indexer cache.Indexer
}

// NewEgressFirewallLister returns a new EgressFirewallLister.
func NewEgressFirewallLister(indexer cache.Indexer) EgressFirewallLister {
	return &egressFirewallLister{indexer: indexer}
}

// List lists all EgressFirewalls in the indexer.
func (s *egressFirewallLister) List(selector labels.Selector) (ret []*v1.EgressFirewall, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.EgressFirewall))
	})
	return ret, err
}

// EgressFirewalls returns an object that can list and get EgressFirewalls.
func (s *egressFirewallLister) EgressFirewalls(namespace string) EgressFirewallNamespaceLister {
	return egressFirewallNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// EgressFirewallNamespaceLister helps list and get EgressFirewalls.
// All objects returned here must be treated as read-only.
type EgressFirewallNamespaceLister interface {
	// List lists all EgressFirewalls in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.EgressFirewall, err error)
	// Get retrieves the EgressFirewall from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.EgressFirewall, error)
	EgressFirewallNamespaceListerExpansion
}

// egressFirewallNamespaceLister implements the EgressFirewallNamespaceLister
// interface.
type egressFirewallNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all EgressFirewalls in the indexer for a given namespace.
func (s egressFirewallNamespaceLister) List(selector labels.Selector) (ret []*v1.EgressFirewall, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.EgressFirewall))
	})
	return ret, err
}

// Get retrieves the EgressFirewall from the indexer for a given namespace and name.
func (s egressFirewallNamespaceLister) Get(name string) (*v1.EgressFirewall, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("egressfirewall"), name)
	}
	return obj.(*v1.EgressFirewall), nil
}
