/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/ovn-org/ovn-kubernetes/go-controller/pkg/crd/egressip/v1"
	scheme "github.com/ovn-org/ovn-kubernetes/go-controller/pkg/crd/egressip/v1/apis/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// EgressIPsGetter has a method to return a EgressIPInterface.
// A group's client should implement this interface.
type EgressIPsGetter interface {
	EgressIPs() EgressIPInterface
}

// EgressIPInterface has methods to work with EgressIP resources.
type EgressIPInterface interface {
	Create(ctx context.Context, egressIP *v1.EgressIP, opts metav1.CreateOptions) (*v1.EgressIP, error)
	Update(ctx context.Context, egressIP *v1.EgressIP, opts metav1.UpdateOptions) (*v1.EgressIP, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.EgressIP, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.EgressIPList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.EgressIP, err error)
	EgressIPExpansion
}

// egressIPs implements EgressIPInterface
type egressIPs struct {
	client rest.Interface
}

// newEgressIPs returns a EgressIPs
func newEgressIPs(c *K8sV1Client) *egressIPs {
	return &egressIPs{
		client: c.RESTClient(),
	}
}

// Get takes name of the egressIP, and returns the corresponding egressIP object, and an error if there is any.
func (c *egressIPs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.EgressIP, err error) {
	result = &v1.EgressIP{}
	err = c.client.Get().
		Resource("egressips").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of EgressIPs that match those selectors.
func (c *egressIPs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.EgressIPList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.EgressIPList{}
	err = c.client.Get().
		Resource("egressips").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested egressIPs.
func (c *egressIPs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("egressips").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a egressIP and creates it.  Returns the server's representation of the egressIP, and an error, if there is any.
func (c *egressIPs) Create(ctx context.Context, egressIP *v1.EgressIP, opts metav1.CreateOptions) (result *v1.EgressIP, err error) {
	result = &v1.EgressIP{}
	err = c.client.Post().
		Resource("egressips").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(egressIP).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a egressIP and updates it. Returns the server's representation of the egressIP, and an error, if there is any.
func (c *egressIPs) Update(ctx context.Context, egressIP *v1.EgressIP, opts metav1.UpdateOptions) (result *v1.EgressIP, err error) {
	result = &v1.EgressIP{}
	err = c.client.Put().
		Resource("egressips").
		Name(egressIP.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(egressIP).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the egressIP and deletes it. Returns an error if one occurs.
func (c *egressIPs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("egressips").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *egressIPs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("egressips").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched egressIP.
func (c *egressIPs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.EgressIP, err error) {
	result = &v1.EgressIP{}
	err = c.client.Patch(pt).
		Resource("egressips").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
