// Code generated by go-swagger; DO NOT EDIT.

package service_instances

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewServiceInstanceLastOperationGetParams creates a new ServiceInstanceLastOperationGetParams object
// with the default values initialized.
func NewServiceInstanceLastOperationGetParams() *ServiceInstanceLastOperationGetParams {
	var ()
	return &ServiceInstanceLastOperationGetParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewServiceInstanceLastOperationGetParamsWithTimeout creates a new ServiceInstanceLastOperationGetParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewServiceInstanceLastOperationGetParamsWithTimeout(timeout time.Duration) *ServiceInstanceLastOperationGetParams {
	var ()
	return &ServiceInstanceLastOperationGetParams{

		timeout: timeout,
	}
}

// NewServiceInstanceLastOperationGetParamsWithContext creates a new ServiceInstanceLastOperationGetParams object
// with the default values initialized, and the ability to set a context for a request
func NewServiceInstanceLastOperationGetParamsWithContext(ctx context.Context) *ServiceInstanceLastOperationGetParams {
	var ()
	return &ServiceInstanceLastOperationGetParams{

		Context: ctx,
	}
}

// NewServiceInstanceLastOperationGetParamsWithHTTPClient creates a new ServiceInstanceLastOperationGetParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewServiceInstanceLastOperationGetParamsWithHTTPClient(client *http.Client) *ServiceInstanceLastOperationGetParams {
	var ()
	return &ServiceInstanceLastOperationGetParams{
		HTTPClient: client,
	}
}

/*ServiceInstanceLastOperationGetParams contains all the parameters to send to the API endpoint
for the service instance last operation get operation typically these are written to a http.Request
*/
type ServiceInstanceLastOperationGetParams struct {

	/*XBrokerAPIVersion
	  version number of the Service Broker API that the Platform will use

	*/
	XBrokerAPIVersion string
	/*InstanceID
	  instance id of instance to provision

	*/
	InstanceID string
	/*Operation
	  a provided identifier for the operation

	*/
	Operation *string
	/*PlanID
	  id of the plan associated with the instance

	*/
	PlanID *string
	/*ServiceID
	  id of the service associated with the instance

	*/
	ServiceID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) WithTimeout(timeout time.Duration) *ServiceInstanceLastOperationGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) WithContext(ctx context.Context) *ServiceInstanceLastOperationGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) WithHTTPClient(client *http.Client) *ServiceInstanceLastOperationGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithXBrokerAPIVersion adds the xBrokerAPIVersion to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) WithXBrokerAPIVersion(xBrokerAPIVersion string) *ServiceInstanceLastOperationGetParams {
	o.SetXBrokerAPIVersion(xBrokerAPIVersion)
	return o
}

// SetXBrokerAPIVersion adds the xBrokerApiVersion to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) SetXBrokerAPIVersion(xBrokerAPIVersion string) {
	o.XBrokerAPIVersion = xBrokerAPIVersion
}

// WithInstanceID adds the instanceID to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) WithInstanceID(instanceID string) *ServiceInstanceLastOperationGetParams {
	o.SetInstanceID(instanceID)
	return o
}

// SetInstanceID adds the instanceId to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) SetInstanceID(instanceID string) {
	o.InstanceID = instanceID
}

// WithOperation adds the operation to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) WithOperation(operation *string) *ServiceInstanceLastOperationGetParams {
	o.SetOperation(operation)
	return o
}

// SetOperation adds the operation to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) SetOperation(operation *string) {
	o.Operation = operation
}

// WithPlanID adds the planID to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) WithPlanID(planID *string) *ServiceInstanceLastOperationGetParams {
	o.SetPlanID(planID)
	return o
}

// SetPlanID adds the planId to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) SetPlanID(planID *string) {
	o.PlanID = planID
}

// WithServiceID adds the serviceID to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) WithServiceID(serviceID *string) *ServiceInstanceLastOperationGetParams {
	o.SetServiceID(serviceID)
	return o
}

// SetServiceID adds the serviceId to the service instance last operation get params
func (o *ServiceInstanceLastOperationGetParams) SetServiceID(serviceID *string) {
	o.ServiceID = serviceID
}

// WriteToRequest writes these params to a swagger request
func (o *ServiceInstanceLastOperationGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// header param X-Broker-API-Version
	if err := r.SetHeaderParam("X-Broker-API-Version", o.XBrokerAPIVersion); err != nil {
		return err
	}

	// path param instance_id
	if err := r.SetPathParam("instance_id", o.InstanceID); err != nil {
		return err
	}

	if o.Operation != nil {

		// query param operation
		var qrOperation string
		if o.Operation != nil {
			qrOperation = *o.Operation
		}
		qOperation := qrOperation
		if qOperation != "" {
			if err := r.SetQueryParam("operation", qOperation); err != nil {
				return err
			}
		}

	}

	if o.PlanID != nil {

		// query param plan_id
		var qrPlanID string
		if o.PlanID != nil {
			qrPlanID = *o.PlanID
		}
		qPlanID := qrPlanID
		if qPlanID != "" {
			if err := r.SetQueryParam("plan_id", qPlanID); err != nil {
				return err
			}
		}

	}

	if o.ServiceID != nil {

		// query param service_id
		var qrServiceID string
		if o.ServiceID != nil {
			qrServiceID = *o.ServiceID
		}
		qServiceID := qrServiceID
		if qServiceID != "" {
			if err := r.SetQueryParam("service_id", qServiceID); err != nil {
				return err
			}
		}

	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
