// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HostPVMInstance A pvm instance on host
// swagger:model HostPVMInstance
type HostPVMInstance struct {

	// Cloud Instance ID pvm instance is a member of
	// Required: true
	CloudInstanceID *string `json:"cloudInstanceID"`

	// Owner information of pvm instance
	// Required: true
	Owner *OwnerInfo `json:"owner"`

	// Instance ID
	// Required: true
	PvmInstanceID *string `json:"pvmInstanceID"`

	// Instance name
	// Required: true
	PvmName *string `json:"pvmName"`

	// State of pvm instance
	// Required: true
	State *string `json:"state"`

	// Tenant ID of pvm instance
	// Required: true
	TenantID *string `json:"tenantID"`
}

// Validate validates this host p VM instance
func (m *HostPVMInstance) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudInstanceID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePvmInstanceID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePvmName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTenantID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostPVMInstance) validateCloudInstanceID(formats strfmt.Registry) error {

	if err := validate.Required("cloudInstanceID", "body", m.CloudInstanceID); err != nil {
		return err
	}

	return nil
}

func (m *HostPVMInstance) validateOwner(formats strfmt.Registry) error {

	if err := validate.Required("owner", "body", m.Owner); err != nil {
		return err
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *HostPVMInstance) validatePvmInstanceID(formats strfmt.Registry) error {

	if err := validate.Required("pvmInstanceID", "body", m.PvmInstanceID); err != nil {
		return err
	}

	return nil
}

func (m *HostPVMInstance) validatePvmName(formats strfmt.Registry) error {

	if err := validate.Required("pvmName", "body", m.PvmName); err != nil {
		return err
	}

	return nil
}

func (m *HostPVMInstance) validateState(formats strfmt.Registry) error {

	if err := validate.Required("state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *HostPVMInstance) validateTenantID(formats strfmt.Registry) error {

	if err := validate.Required("tenantID", "body", m.TenantID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HostPVMInstance) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostPVMInstance) UnmarshalBinary(b []byte) error {
	var res HostPVMInstance
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
