// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DHCPServerDetail d h c p server detail
// swagger:model DHCPServerDetail
type DHCPServerDetail struct {

	// The ID of the DHCP Server
	// Required: true
	ID *string `json:"id"`

	// The list of DHCP Server PVM Instance leases
	Leases []*DHCPServerLeases `json:"leases"`

	// The DHCP Server private network
	// Required: true
	Network *DHCPServerNetwork `json:"network"`

	// The status of the DHCP Server
	// Required: true
	Status *string `json:"status"`
}

// Validate validates this d h c p server detail
func (m *DHCPServerDetail) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLeases(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetwork(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DHCPServerDetail) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *DHCPServerDetail) validateLeases(formats strfmt.Registry) error {

	if swag.IsZero(m.Leases) { // not required
		return nil
	}

	for i := 0; i < len(m.Leases); i++ {
		if swag.IsZero(m.Leases[i]) { // not required
			continue
		}

		if m.Leases[i] != nil {
			if err := m.Leases[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("leases" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DHCPServerDetail) validateNetwork(formats strfmt.Registry) error {

	if err := validate.Required("network", "body", m.Network); err != nil {
		return err
	}

	if m.Network != nil {
		if err := m.Network.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("network")
			}
			return err
		}
	}

	return nil
}

func (m *DHCPServerDetail) validateStatus(formats strfmt.Registry) error {

	if err := validate.Required("status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DHCPServerDetail) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DHCPServerDetail) UnmarshalBinary(b []byte) error {
	var res DHCPServerDetail
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
