// Code generated by golang.org/x/tools/cmd/bundle. DO NOT EDIT.
//   $ bundle -pkg godo -prefix  ./dev/dist/godo

package godo

import ()

// AppDatabaseSpec struct for AppDatabaseSpec
type AppDatabaseSpec struct {
	Name     string                `json:"name"`
	Engine   AppDatabaseSpecEngine `json:"engine,omitempty"`
	Version  string                `json:"version,omitempty"`
	Size     string                `json:"size,omitempty"`
	NumNodes int64                 `json:"num_nodes,omitempty"`
}

// AppDatabaseSpecEngine the model 'AppDatabaseSpecEngine'
type AppDatabaseSpecEngine string

// List of AppDatabaseSpecEngine
const (
	APPDATABASESPECENGINE_UNSET AppDatabaseSpecEngine = "UNSET"
	APPDATABASESPECENGINE_MYSQL AppDatabaseSpecEngine = "MYSQL"
	APPDATABASESPECENGINE_PG    AppDatabaseSpecEngine = "PG"
	APPDATABASESPECENGINE_REDIS AppDatabaseSpecEngine = "REDIS"
)

// AppDomainSpec struct for AppDomainSpec
type AppDomainSpec struct {
	Domain string `json:"domain"`
}

// AppRouteSpec struct for AppRouteSpec
type AppRouteSpec struct {
	Path string `json:"path,omitempty"`
}

// AppServiceSpec struct for AppServiceSpec
type AppServiceSpec struct {
	Name             string                  `json:"name"`
	RunCommand       string                  `json:"run_command,omitempty"`
	BuildCommand     string                  `json:"build_command,omitempty"`
	HTTPPort         int64                   `json:"http_port,omitempty"`
	DockerfilePath   string                  `json:"dockerfile_path,omitempty"`
	Git              GitSourceSpec           `json:"git,omitempty"`
	GitHub           GitHubSourceSpec        `json:"github,omitempty"`
	Envs             []AppVariableDefinition `json:"envs,omitempty"`
	InstanceSizeSlug string                  `json:"instance_size_slug,omitempty"`
	InstanceCount    int64                   `json:"instance_count,omitempty"`
	Routes           []AppRouteSpec          `json:"routes,omitempty"`
	SourceDir        string                  `json:"source_dir,omitempty"`
	EnvironmentSlug  string                  `json:"environment_slug,omitempty"`
}

// AppSpec struct for AppSpec
type AppSpec struct {
	Services    []AppServiceSpec    `json:"services,omitempty"`
	StaticSites []AppStaticSiteSpec `json:"static_sites,omitempty"`
	Databases   []AppDatabaseSpec   `json:"databases,omitempty"`
	Workers     []AppWorkerSpec     `json:"workers,omitempty"`
	Region      string              `json:"region,omitempty"`
	Name        string              `json:"name"`
	Domains     []AppDomainSpec     `json:"domains,omitempty"`
}

// AppStaticSiteSpec struct for AppStaticSiteSpec
type AppStaticSiteSpec struct {
	Name            string                  `json:"name"`
	BuildCommand    string                  `json:"build_command,omitempty"`
	Git             GitSourceSpec           `json:"git,omitempty"`
	GitHub          GitHubSourceSpec        `json:"github,omitempty"`
	Envs            []AppVariableDefinition `json:"envs,omitempty"`
	Routes          []AppRouteSpec          `json:"routes,omitempty"`
	SourceDir       string                  `json:"source_dir,omitempty"`
	EnvironmentSlug string                  `json:"environment_slug,omitempty"`
}

// AppVariableDefinition struct for AppVariableDefinition
type AppVariableDefinition struct {
	Value string        `json:"value,omitempty"`
	Scope VariableScope `json:"scope,omitempty"`
	// POSIX allows a broader env var definition, but we restrict to what is allowed by bash. http://git.savannah.gnu.org/cgit/bash.git/tree/general.h?h=bash-5.0#n124 Based on the POSIX spec and some casting to unsigned char in bash code I think this is restricted to ASCII (not unicode).
	Key            string       `json:"key"`
	Type           VariableType `json:"type,omitempty"`
	EncryptedValue string       `json:"encrypted_value,omitempty"`
}

// AppWorkerSpec struct for AppWorkerSpec
type AppWorkerSpec struct {
	Name             string                  `json:"name"`
	RunCommand       string                  `json:"run_command,omitempty"`
	BuildCommand     string                  `json:"build_command,omitempty"`
	DockerfilePath   string                  `json:"dockerfile_path,omitempty"`
	Git              GitSourceSpec           `json:"git,omitempty"`
	GitHub           GitHubSourceSpec        `json:"github,omitempty"`
	Envs             []AppVariableDefinition `json:"envs,omitempty"`
	InstanceSizeSlug string                  `json:"instance_size_slug,omitempty"`
	InstanceCount    int64                   `json:"instance_count,omitempty"`
	SourceDir        string                  `json:"source_dir,omitempty"`
	EnvironmentSlug  string                  `json:"environment_slug,omitempty"`
}

// GitHubSourceSpec struct for GitHubSourceSpec
type GitHubSourceSpec struct {
	Repo         string `json:"repo"`
	Branch       string `json:"branch"`
	DeployOnPush bool   `json:"deploy_on_push,omitempty"`
}

// GitSourceSpec struct for GitSourceSpec
type GitSourceSpec struct {
	Repo         string `json:"repo,omitempty"`
	RequiresAuth bool   `json:"requires_auth,omitempty"`
	Branch       string `json:"branch,omitempty"`
	RepoCloneURL string `json:"repo_clone_url,omitempty"`
}

// VariableScope the model 'VariableScope'
type VariableScope string

// List of VariableScope
const (
	VARIABLESCOPE_UNSET              VariableScope = "UNSET"
	VARIABLESCOPE_RUN_TIME           VariableScope = "RUN_TIME"
	VARIABLESCOPE_BUILD_TIME         VariableScope = "BUILD_TIME"
	VARIABLESCOPE_RUN_AND_BUILD_TIME VariableScope = "RUN_AND_BUILD_TIME"
)

// VariableType the model 'VariableType'
type VariableType string

// List of VariableType
const (
	VARIABLETYPE_GENERAL VariableType = "GENERAL"
	VARIABLETYPE_SECRET  VariableType = "SECRET"
)
