// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: store/storepb/rpc.proto

package storepb

import (
	context "context"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	prompb "github.com/thanos-io/thanos/pkg/store/storepb/prompb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type StoreType int32

const (
	StoreType_UNKNOWN StoreType = 0
	StoreType_QUERY   StoreType = 1
	StoreType_RULE    StoreType = 2
	StoreType_SIDECAR StoreType = 3
	StoreType_STORE   StoreType = 4
	StoreType_RECEIVE StoreType = 5
	// DEBUG represents some debug StoreAPI components e.g. thanos tools store-api-serve.
	StoreType_DEBUG StoreType = 6
)

var StoreType_name = map[int32]string{
	0: "UNKNOWN",
	1: "QUERY",
	2: "RULE",
	3: "SIDECAR",
	4: "STORE",
	5: "RECEIVE",
	6: "DEBUG",
}

var StoreType_value = map[string]int32{
	"UNKNOWN": 0,
	"QUERY":   1,
	"RULE":    2,
	"SIDECAR": 3,
	"STORE":   4,
	"RECEIVE": 5,
	"DEBUG":   6,
}

func (x StoreType) String() string {
	return proto.EnumName(StoreType_name, int32(x))
}

func (StoreType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{0}
}

type Aggr int32

const (
	Aggr_RAW     Aggr = 0
	Aggr_COUNT   Aggr = 1
	Aggr_SUM     Aggr = 2
	Aggr_MIN     Aggr = 3
	Aggr_MAX     Aggr = 4
	Aggr_COUNTER Aggr = 5
)

var Aggr_name = map[int32]string{
	0: "RAW",
	1: "COUNT",
	2: "SUM",
	3: "MIN",
	4: "MAX",
	5: "COUNTER",
}

var Aggr_value = map[string]int32{
	"RAW":     0,
	"COUNT":   1,
	"SUM":     2,
	"MIN":     3,
	"MAX":     4,
	"COUNTER": 5,
}

func (x Aggr) String() string {
	return proto.EnumName(Aggr_name, int32(x))
}

func (Aggr) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{1}
}

type WriteResponse struct {
}

func (m *WriteResponse) Reset()         { *m = WriteResponse{} }
func (m *WriteResponse) String() string { return proto.CompactTextString(m) }
func (*WriteResponse) ProtoMessage()    {}
func (*WriteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{0}
}
func (m *WriteResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WriteResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WriteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteResponse.Merge(m, src)
}
func (m *WriteResponse) XXX_Size() int {
	return m.Size()
}
func (m *WriteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WriteResponse proto.InternalMessageInfo

type WriteRequest struct {
	Timeseries []prompb.TimeSeries `protobuf:"bytes,1,rep,name=timeseries,proto3" json:"timeseries"`
	Tenant     string              `protobuf:"bytes,2,opt,name=tenant,proto3" json:"tenant,omitempty"`
	Replica    int64               `protobuf:"varint,3,opt,name=replica,proto3" json:"replica,omitempty"`
}

func (m *WriteRequest) Reset()         { *m = WriteRequest{} }
func (m *WriteRequest) String() string { return proto.CompactTextString(m) }
func (*WriteRequest) ProtoMessage()    {}
func (*WriteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{1}
}
func (m *WriteRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WriteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WriteRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WriteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteRequest.Merge(m, src)
}
func (m *WriteRequest) XXX_Size() int {
	return m.Size()
}
func (m *WriteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WriteRequest proto.InternalMessageInfo

type InfoRequest struct {
}

func (m *InfoRequest) Reset()         { *m = InfoRequest{} }
func (m *InfoRequest) String() string { return proto.CompactTextString(m) }
func (*InfoRequest) ProtoMessage()    {}
func (*InfoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{2}
}
func (m *InfoRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InfoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InfoRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InfoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InfoRequest.Merge(m, src)
}
func (m *InfoRequest) XXX_Size() int {
	return m.Size()
}
func (m *InfoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InfoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InfoRequest proto.InternalMessageInfo

type InfoResponse struct {
	// Deprecated. Use label_sets instead.
	Labels    []Label   `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels"`
	MinTime   int64     `protobuf:"varint,2,opt,name=min_time,json=minTime,proto3" json:"min_time,omitempty"`
	MaxTime   int64     `protobuf:"varint,3,opt,name=max_time,json=maxTime,proto3" json:"max_time,omitempty"`
	StoreType StoreType `protobuf:"varint,4,opt,name=storeType,proto3,enum=thanos.StoreType" json:"storeType,omitempty"`
	// label_sets is an unsorted list of `LabelSet`s.
	LabelSets []LabelSet `protobuf:"bytes,5,rep,name=label_sets,json=labelSets,proto3" json:"label_sets"`
}

func (m *InfoResponse) Reset()         { *m = InfoResponse{} }
func (m *InfoResponse) String() string { return proto.CompactTextString(m) }
func (*InfoResponse) ProtoMessage()    {}
func (*InfoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{3}
}
func (m *InfoResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InfoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InfoResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InfoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InfoResponse.Merge(m, src)
}
func (m *InfoResponse) XXX_Size() int {
	return m.Size()
}
func (m *InfoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InfoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InfoResponse proto.InternalMessageInfo

type LabelSet struct {
	Labels []Label `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels"`
}

func (m *LabelSet) Reset()         { *m = LabelSet{} }
func (m *LabelSet) String() string { return proto.CompactTextString(m) }
func (*LabelSet) ProtoMessage()    {}
func (*LabelSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{4}
}
func (m *LabelSet) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelSet.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSet.Merge(m, src)
}
func (m *LabelSet) XXX_Size() int {
	return m.Size()
}
func (m *LabelSet) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSet.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSet proto.InternalMessageInfo

type SeriesRequest struct {
	MinTime             int64          `protobuf:"varint,1,opt,name=min_time,json=minTime,proto3" json:"min_time,omitempty"`
	MaxTime             int64          `protobuf:"varint,2,opt,name=max_time,json=maxTime,proto3" json:"max_time,omitempty"`
	Matchers            []LabelMatcher `protobuf:"bytes,3,rep,name=matchers,proto3" json:"matchers"`
	MaxResolutionWindow int64          `protobuf:"varint,4,opt,name=max_resolution_window,json=maxResolutionWindow,proto3" json:"max_resolution_window,omitempty"`
	Aggregates          []Aggr         `protobuf:"varint,5,rep,packed,name=aggregates,proto3,enum=thanos.Aggr" json:"aggregates,omitempty"`
	// Deprecated. Use partial_response_strategy instead.
	PartialResponseDisabled bool `protobuf:"varint,6,opt,name=partial_response_disabled,json=partialResponseDisabled,proto3" json:"partial_response_disabled,omitempty"`
	// TODO(bwplotka): Move Thanos components to use strategy instead. Including QueryAPI.
	PartialResponseStrategy PartialResponseStrategy `protobuf:"varint,7,opt,name=partial_response_strategy,json=partialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partial_response_strategy,omitempty"`
	// skip_chunks controls whether sending chunks or not in series responses.
	SkipChunks bool `protobuf:"varint,8,opt,name=skip_chunks,json=skipChunks,proto3" json:"skip_chunks,omitempty"`
	// hints is an opaque data structure that can be used to carry additional information.
	// The content of this field and whether it's supported depends on the
	// implementation of a specific store.
	Hints *types.Any `protobuf:"bytes,9,opt,name=hints,proto3" json:"hints,omitempty"`
}

func (m *SeriesRequest) Reset()         { *m = SeriesRequest{} }
func (m *SeriesRequest) String() string { return proto.CompactTextString(m) }
func (*SeriesRequest) ProtoMessage()    {}
func (*SeriesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{5}
}
func (m *SeriesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SeriesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SeriesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SeriesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SeriesRequest.Merge(m, src)
}
func (m *SeriesRequest) XXX_Size() int {
	return m.Size()
}
func (m *SeriesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SeriesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SeriesRequest proto.InternalMessageInfo

type SeriesResponse struct {
	// Types that are valid to be assigned to Result:
	//	*SeriesResponse_Series
	//	*SeriesResponse_Warning
	//	*SeriesResponse_Hints
	Result isSeriesResponse_Result `protobuf_oneof:"result"`
}

func (m *SeriesResponse) Reset()         { *m = SeriesResponse{} }
func (m *SeriesResponse) String() string { return proto.CompactTextString(m) }
func (*SeriesResponse) ProtoMessage()    {}
func (*SeriesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{6}
}
func (m *SeriesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SeriesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SeriesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SeriesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SeriesResponse.Merge(m, src)
}
func (m *SeriesResponse) XXX_Size() int {
	return m.Size()
}
func (m *SeriesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SeriesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SeriesResponse proto.InternalMessageInfo

type isSeriesResponse_Result interface {
	isSeriesResponse_Result()
	MarshalTo([]byte) (int, error)
	Size() int
}

type SeriesResponse_Series struct {
	Series *Series `protobuf:"bytes,1,opt,name=series,proto3,oneof" json:"series,omitempty"`
}
type SeriesResponse_Warning struct {
	Warning string `protobuf:"bytes,2,opt,name=warning,proto3,oneof" json:"warning,omitempty"`
}
type SeriesResponse_Hints struct {
	Hints *types.Any `protobuf:"bytes,3,opt,name=hints,proto3,oneof" json:"hints,omitempty"`
}

func (*SeriesResponse_Series) isSeriesResponse_Result()  {}
func (*SeriesResponse_Warning) isSeriesResponse_Result() {}
func (*SeriesResponse_Hints) isSeriesResponse_Result()   {}

func (m *SeriesResponse) GetResult() isSeriesResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *SeriesResponse) GetSeries() *Series {
	if x, ok := m.GetResult().(*SeriesResponse_Series); ok {
		return x.Series
	}
	return nil
}

func (m *SeriesResponse) GetWarning() string {
	if x, ok := m.GetResult().(*SeriesResponse_Warning); ok {
		return x.Warning
	}
	return ""
}

func (m *SeriesResponse) GetHints() *types.Any {
	if x, ok := m.GetResult().(*SeriesResponse_Hints); ok {
		return x.Hints
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SeriesResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SeriesResponse_Series)(nil),
		(*SeriesResponse_Warning)(nil),
		(*SeriesResponse_Hints)(nil),
	}
}

type LabelNamesRequest struct {
	PartialResponseDisabled bool `protobuf:"varint,1,opt,name=partial_response_disabled,json=partialResponseDisabled,proto3" json:"partial_response_disabled,omitempty"`
	// TODO(bwplotka): Move Thanos components to use strategy instead. Including QueryAPI.
	PartialResponseStrategy PartialResponseStrategy `protobuf:"varint,2,opt,name=partial_response_strategy,json=partialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partial_response_strategy,omitempty"`
	Start                   int64                   `protobuf:"varint,3,opt,name=start,proto3" json:"start,omitempty"`
	End                     int64                   `protobuf:"varint,4,opt,name=end,proto3" json:"end,omitempty"`
}

func (m *LabelNamesRequest) Reset()         { *m = LabelNamesRequest{} }
func (m *LabelNamesRequest) String() string { return proto.CompactTextString(m) }
func (*LabelNamesRequest) ProtoMessage()    {}
func (*LabelNamesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{7}
}
func (m *LabelNamesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelNamesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelNamesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelNamesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelNamesRequest.Merge(m, src)
}
func (m *LabelNamesRequest) XXX_Size() int {
	return m.Size()
}
func (m *LabelNamesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelNamesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelNamesRequest proto.InternalMessageInfo

type LabelNamesResponse struct {
	Names    []string `protobuf:"bytes,1,rep,name=names,proto3" json:"names,omitempty"`
	Warnings []string `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (m *LabelNamesResponse) Reset()         { *m = LabelNamesResponse{} }
func (m *LabelNamesResponse) String() string { return proto.CompactTextString(m) }
func (*LabelNamesResponse) ProtoMessage()    {}
func (*LabelNamesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{8}
}
func (m *LabelNamesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelNamesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelNamesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelNamesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelNamesResponse.Merge(m, src)
}
func (m *LabelNamesResponse) XXX_Size() int {
	return m.Size()
}
func (m *LabelNamesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelNamesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LabelNamesResponse proto.InternalMessageInfo

type LabelValuesRequest struct {
	Label                   string `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	PartialResponseDisabled bool   `protobuf:"varint,2,opt,name=partial_response_disabled,json=partialResponseDisabled,proto3" json:"partial_response_disabled,omitempty"`
	// TODO(bwplotka): Move Thanos components to use strategy instead. Including QueryAPI.
	PartialResponseStrategy PartialResponseStrategy `protobuf:"varint,3,opt,name=partial_response_strategy,json=partialResponseStrategy,proto3,enum=thanos.PartialResponseStrategy" json:"partial_response_strategy,omitempty"`
	Start                   int64                   `protobuf:"varint,4,opt,name=start,proto3" json:"start,omitempty"`
	End                     int64                   `protobuf:"varint,5,opt,name=end,proto3" json:"end,omitempty"`
}

func (m *LabelValuesRequest) Reset()         { *m = LabelValuesRequest{} }
func (m *LabelValuesRequest) String() string { return proto.CompactTextString(m) }
func (*LabelValuesRequest) ProtoMessage()    {}
func (*LabelValuesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{9}
}
func (m *LabelValuesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelValuesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelValuesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelValuesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelValuesRequest.Merge(m, src)
}
func (m *LabelValuesRequest) XXX_Size() int {
	return m.Size()
}
func (m *LabelValuesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelValuesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LabelValuesRequest proto.InternalMessageInfo

type LabelValuesResponse struct {
	Values   []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	Warnings []string `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (m *LabelValuesResponse) Reset()         { *m = LabelValuesResponse{} }
func (m *LabelValuesResponse) String() string { return proto.CompactTextString(m) }
func (*LabelValuesResponse) ProtoMessage()    {}
func (*LabelValuesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a938d55a388af629, []int{10}
}
func (m *LabelValuesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LabelValuesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LabelValuesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LabelValuesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelValuesResponse.Merge(m, src)
}
func (m *LabelValuesResponse) XXX_Size() int {
	return m.Size()
}
func (m *LabelValuesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelValuesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LabelValuesResponse proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("thanos.StoreType", StoreType_name, StoreType_value)
	proto.RegisterEnum("thanos.Aggr", Aggr_name, Aggr_value)
	proto.RegisterType((*WriteResponse)(nil), "thanos.WriteResponse")
	proto.RegisterType((*WriteRequest)(nil), "thanos.WriteRequest")
	proto.RegisterType((*InfoRequest)(nil), "thanos.InfoRequest")
	proto.RegisterType((*InfoResponse)(nil), "thanos.InfoResponse")
	proto.RegisterType((*LabelSet)(nil), "thanos.LabelSet")
	proto.RegisterType((*SeriesRequest)(nil), "thanos.SeriesRequest")
	proto.RegisterType((*SeriesResponse)(nil), "thanos.SeriesResponse")
	proto.RegisterType((*LabelNamesRequest)(nil), "thanos.LabelNamesRequest")
	proto.RegisterType((*LabelNamesResponse)(nil), "thanos.LabelNamesResponse")
	proto.RegisterType((*LabelValuesRequest)(nil), "thanos.LabelValuesRequest")
	proto.RegisterType((*LabelValuesResponse)(nil), "thanos.LabelValuesResponse")
}

func init() { proto.RegisterFile("store/storepb/rpc.proto", fileDescriptor_a938d55a388af629) }

var fileDescriptor_a938d55a388af629 = []byte{
	// 1003 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x4d, 0x6f, 0x23, 0x45,
	0x13, 0xf6, 0x78, 0xec, 0xb1, 0x5d, 0x4e, 0xf2, 0xce, 0x76, 0x9c, 0xec, 0xc4, 0x2b, 0x39, 0xd6,
	0x48, 0xaf, 0x64, 0x85, 0x95, 0x0d, 0x46, 0x80, 0x40, 0x5c, 0x9c, 0xc4, 0x4b, 0x22, 0x36, 0x0e,
	0xb4, 0xe3, 0x0d, 0x1f, 0x42, 0xd6, 0x24, 0xe9, 0x9d, 0x8c, 0x76, 0xbe, 0x98, 0x6e, 0x93, 0xf8,
	0x0a, 0x77, 0xc4, 0x9f, 0x42, 0xca, 0x71, 0x0f, 0x1c, 0xe0, 0x82, 0x20, 0x39, 0xf2, 0x27, 0x50,
	0x7f, 0x8c, 0xed, 0x09, 0xd9, 0x48, 0x28, 0x5c, 0xac, 0xae, 0x7a, 0xaa, 0xbb, 0x9e, 0x7e, 0xaa,
	0x6a, 0xdc, 0xf0, 0x98, 0xb2, 0x28, 0x21, 0x1d, 0xf1, 0x1b, 0x9f, 0x74, 0x92, 0xf8, 0xb4, 0x1d,
	0x27, 0x11, 0x8b, 0x90, 0xc1, 0xce, 0x9d, 0x30, 0xa2, 0xf5, 0x8d, 0x6c, 0x00, 0x9b, 0xc6, 0x84,
	0xca, 0x90, 0x7a, 0xcd, 0x8d, 0xdc, 0x48, 0x2c, 0x3b, 0x7c, 0xa5, 0xbc, 0xcd, 0xec, 0x86, 0x38,
	0x89, 0x82, 0x5b, 0xfb, 0x36, 0xdc, 0x28, 0x72, 0x7d, 0xd2, 0x11, 0xd6, 0xc9, 0xe4, 0x65, 0xc7,
	0x09, 0xa7, 0x12, 0xb2, 0xff, 0x07, 0xcb, 0xc7, 0x89, 0xc7, 0x08, 0x26, 0x34, 0x8e, 0x42, 0x4a,
	0xec, 0x1f, 0x34, 0x58, 0x52, 0x9e, 0x6f, 0x27, 0x84, 0x32, 0xd4, 0x03, 0x60, 0x5e, 0x40, 0x28,
	0x49, 0x3c, 0x42, 0x2d, 0xad, 0xa9, 0xb7, 0xaa, 0xdd, 0x27, 0x7c, 0x77, 0x40, 0xd8, 0x39, 0x99,
	0xd0, 0xf1, 0x69, 0x14, 0x4f, 0xdb, 0x47, 0x5e, 0x40, 0x86, 0x22, 0x64, 0xbb, 0x70, 0xf5, 0xfb,
	0x66, 0x0e, 0x2f, 0x6c, 0x42, 0xeb, 0x60, 0x30, 0x12, 0x3a, 0x21, 0xb3, 0xf2, 0x4d, 0xad, 0x55,
	0xc1, 0xca, 0x42, 0x16, 0x94, 0x12, 0x12, 0xfb, 0xde, 0xa9, 0x63, 0xe9, 0x4d, 0xad, 0xa5, 0xe3,
	0xd4, 0xb4, 0x97, 0xa1, 0xba, 0x1f, 0xbe, 0x8c, 0x14, 0x07, 0xfb, 0x37, 0x0d, 0x96, 0xa4, 0x2d,
	0x59, 0xa2, 0xb7, 0xc0, 0xf0, 0x9d, 0x13, 0xe2, 0xa7, 0x84, 0x96, 0xdb, 0x52, 0xbd, 0xf6, 0x73,
	0xee, 0x55, 0x14, 0x54, 0x08, 0xda, 0x80, 0x72, 0xe0, 0x85, 0x63, 0x4e, 0x48, 0x10, 0xd0, 0x71,
	0x29, 0xf0, 0x42, 0xce, 0x58, 0x40, 0xce, 0xa5, 0x84, 0x14, 0x85, 0xc0, 0xb9, 0x14, 0x50, 0x07,
	0x2a, 0x42, 0xd2, 0xa3, 0x69, 0x4c, 0xac, 0x42, 0x53, 0x6b, 0xad, 0x74, 0x1f, 0xa5, 0x59, 0x86,
	0x29, 0x80, 0xe7, 0x31, 0xe8, 0x3d, 0x00, 0x91, 0x70, 0x4c, 0x09, 0xa3, 0x56, 0x51, 0xf0, 0x32,
	0x33, 0xbc, 0x86, 0x84, 0x29, 0x6a, 0x15, 0x5f, 0xd9, 0xd4, 0xfe, 0x00, 0xca, 0x29, 0xf8, 0xaf,
	0xae, 0x65, 0xff, 0xac, 0xc3, 0xb2, 0x94, 0x3c, 0x2d, 0xd5, 0xe2, 0x45, 0xb5, 0x37, 0x5f, 0x34,
	0x9f, 0xbd, 0xe8, 0xfb, 0x1c, 0x62, 0xa7, 0xe7, 0x24, 0xa1, 0x96, 0x2e, 0xd2, 0xd6, 0x32, 0x69,
	0x0f, 0x24, 0xa8, 0xb2, 0xcf, 0x62, 0x51, 0x17, 0xd6, 0xf8, 0x91, 0x09, 0xa1, 0x91, 0x3f, 0x61,
	0x5e, 0x14, 0x8e, 0x2f, 0xbc, 0xf0, 0x2c, 0xba, 0x10, 0x62, 0xe9, 0x78, 0x35, 0x70, 0x2e, 0xf1,
	0x0c, 0x3b, 0x16, 0x10, 0x7a, 0x0a, 0xe0, 0xb8, 0x6e, 0x42, 0x5c, 0x87, 0x11, 0xa9, 0xd1, 0x4a,
	0x77, 0x29, 0xcd, 0xd6, 0x73, 0xdd, 0x04, 0x2f, 0xe0, 0xe8, 0x23, 0xd8, 0x88, 0x9d, 0x84, 0x79,
	0x8e, 0xcf, 0xb3, 0x88, 0xca, 0x8f, 0xcf, 0x3c, 0xea, 0x9c, 0xf8, 0xe4, 0xcc, 0x32, 0x9a, 0x5a,
	0xab, 0x8c, 0x1f, 0xab, 0x80, 0xb4, 0x33, 0x76, 0x15, 0x8c, 0xbe, 0xbe, 0x63, 0x2f, 0x65, 0x89,
	0xc3, 0x88, 0x3b, 0xb5, 0x4a, 0xa2, 0x9c, 0x9b, 0x69, 0xe2, 0xcf, 0xb2, 0x67, 0x0c, 0x55, 0xd8,
	0x3f, 0x0e, 0x4f, 0x01, 0xb4, 0x09, 0x55, 0xfa, 0xca, 0x8b, 0xc7, 0xa7, 0xe7, 0x93, 0xf0, 0x15,
	0xb5, 0xca, 0x82, 0x0a, 0x70, 0xd7, 0x8e, 0xf0, 0xa0, 0x2d, 0x28, 0x9e, 0x7b, 0x21, 0xa3, 0x56,
	0xa5, 0xa9, 0x09, 0x41, 0xe5, 0x04, 0xb6, 0xd3, 0x09, 0x6c, 0xf7, 0xc2, 0x29, 0x96, 0x21, 0xf6,
	0x8f, 0x1a, 0xac, 0xa4, 0x75, 0x54, 0xed, 0xdd, 0x02, 0x63, 0x36, 0x6f, 0x7c, 0xff, 0xca, 0xac,
	0xf1, 0x84, 0x77, 0x2f, 0x87, 0x15, 0x8e, 0xea, 0x50, 0xba, 0x70, 0x92, 0xd0, 0x0b, 0x5d, 0x39,
	0x5b, 0x7b, 0x39, 0x9c, 0x3a, 0xd0, 0xd3, 0x94, 0x84, 0xfe, 0x66, 0x12, 0x7b, 0x39, 0x45, 0x63,
	0xbb, 0x0c, 0x46, 0x42, 0xe8, 0xc4, 0x67, 0xf6, 0x2f, 0x1a, 0x3c, 0x12, 0x95, 0x1f, 0x38, 0xc1,
	0xbc, 0xb9, 0xee, 0x2d, 0x86, 0xf6, 0x80, 0x62, 0xe4, 0x1f, 0x58, 0x8c, 0x1a, 0x14, 0x29, 0x73,
	0x12, 0xa6, 0x06, 0x58, 0x1a, 0xc8, 0x04, 0x9d, 0x84, 0x67, 0xaa, 0x17, 0xf9, 0xd2, 0x7e, 0x06,
	0x68, 0xf1, 0x56, 0x4a, 0xea, 0x1a, 0x14, 0x43, 0xee, 0x10, 0x13, 0x57, 0xc1, 0xd2, 0x40, 0x75,
	0x28, 0x2b, 0x15, 0xa9, 0x95, 0x17, 0xc0, 0xcc, 0xb6, 0xff, 0xd2, 0xd4, 0x41, 0x2f, 0x1c, 0x7f,
	0x32, 0xd7, 0xa7, 0x06, 0x45, 0x31, 0x98, 0x42, 0x8b, 0x0a, 0x96, 0xc6, 0xfd, 0xaa, 0xe5, 0x1f,
	0xa0, 0x9a, 0xfe, 0x5f, 0xa9, 0x56, 0xb8, 0x43, 0xb5, 0xe2, 0x5c, 0xb5, 0x7d, 0x58, 0xcd, 0x5c,
	0x56, 0xc9, 0xb6, 0x0e, 0xc6, 0x77, 0xc2, 0xa3, 0x74, 0x53, 0xd6, 0x7d, 0xc2, 0x6d, 0x7d, 0x03,
	0x95, 0xd9, 0x87, 0x13, 0x55, 0xa1, 0x34, 0x1a, 0x7c, 0x3a, 0x38, 0x3c, 0x1e, 0x98, 0x39, 0x54,
	0x81, 0xe2, 0xe7, 0xa3, 0x3e, 0xfe, 0xd2, 0xd4, 0x50, 0x19, 0x0a, 0x78, 0xf4, 0xbc, 0x6f, 0xe6,
	0x79, 0xc4, 0x70, 0x7f, 0xb7, 0xbf, 0xd3, 0xc3, 0xa6, 0xce, 0x23, 0x86, 0x47, 0x87, 0xb8, 0x6f,
	0x16, 0xb8, 0x1f, 0xf7, 0x77, 0xfa, 0xfb, 0x2f, 0xfa, 0x66, 0x91, 0xfb, 0x77, 0xfb, 0xdb, 0xa3,
	0x4f, 0x4c, 0x63, 0x6b, 0x1b, 0x0a, 0xfc, 0x0b, 0x82, 0x4a, 0xa0, 0xe3, 0xde, 0xb1, 0x3c, 0x75,
	0xe7, 0x70, 0x34, 0x38, 0x32, 0x35, 0xee, 0x1b, 0x8e, 0x0e, 0xcc, 0x3c, 0x5f, 0x1c, 0xec, 0x0f,
	0x4c, 0x5d, 0x2c, 0x7a, 0x5f, 0xc8, 0xe3, 0x44, 0x54, 0x1f, 0x9b, 0xc5, 0xee, 0xf7, 0x79, 0x28,
	0x0a, 0x8e, 0xe8, 0x1d, 0x28, 0xf0, 0x7f, 0x1c, 0xb4, 0x9a, 0x2a, 0xbc, 0xf0, 0x7f, 0x54, 0xaf,
	0x65, 0x9d, 0x4a, 0x93, 0x0f, 0xc1, 0x90, 0xf3, 0x89, 0xd6, 0xb2, 0xf3, 0x9a, 0x6e, 0x5b, 0xbf,
	0xed, 0x96, 0x1b, 0xdf, 0xd6, 0xd0, 0x0e, 0xc0, 0xbc, 0x37, 0xd1, 0x46, 0xe6, 0xfb, 0xbb, 0x38,
	0x85, 0xf5, 0xfa, 0x5d, 0x90, 0xca, 0xff, 0x0c, 0xaa, 0x0b, 0xa5, 0x42, 0xd9, 0xd0, 0x4c, 0xb3,
	0xd6, 0x9f, 0xdc, 0x89, 0xc9, 0x73, 0xba, 0x03, 0x58, 0x11, 0x2f, 0x00, 0xde, 0x85, 0x52, 0x8c,
	0x8f, 0xa1, 0x8a, 0x49, 0x10, 0x31, 0x22, 0xfc, 0x68, 0x76, 0xfd, 0xc5, 0x87, 0x42, 0x7d, 0xed,
	0x96, 0x57, 0x3d, 0x28, 0x72, 0xdb, 0xff, 0xbf, 0xfa, 0xb3, 0x91, 0xbb, 0xba, 0x6e, 0x68, 0xaf,
	0xaf, 0x1b, 0xda, 0x1f, 0xd7, 0x0d, 0xed, 0xa7, 0x9b, 0x46, 0xee, 0xf5, 0x4d, 0x23, 0xf7, 0xeb,
	0x4d, 0x23, 0xf7, 0x55, 0x49, 0x3d, 0x5c, 0x4e, 0x0c, 0xf1, 0x5d, 0x7a, 0xf7, 0xef, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x9f, 0xfa, 0x6e, 0x07, 0x22, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// StoreClient is the client API for Store service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StoreClient interface {
	/// Info returns meta information about a store e.g labels that makes that store unique as well as time range that is
	/// available.
	Info(ctx context.Context, in *InfoRequest, opts ...grpc.CallOption) (*InfoResponse, error)
	/// Series streams each Series (Labels and chunk/downsampling chunk) for given label matchers and time range.
	///
	/// Series should strictly stream full series after series, optionally split by time. This means that a single frame can contain
	/// partition of the single series, but once a new series is started to be streamed it means that no more data will
	/// be sent for previous one.
	/// Series has to be sorted.
	///
	/// There is no requirements on chunk sorting, however it is recommended to have chunk sorted by chunk min time.
	/// This heavily optimizes the resource usage on Querier / Federated Queries.
	Series(ctx context.Context, in *SeriesRequest, opts ...grpc.CallOption) (Store_SeriesClient, error)
	/// LabelNames returns all label names that is available.
	/// Currently unimplemented in all Thanos implementations, because Query API does not implement this either.
	LabelNames(ctx context.Context, in *LabelNamesRequest, opts ...grpc.CallOption) (*LabelNamesResponse, error)
	/// LabelValues returns all label values for given label name.
	LabelValues(ctx context.Context, in *LabelValuesRequest, opts ...grpc.CallOption) (*LabelValuesResponse, error)
}

type storeClient struct {
	cc *grpc.ClientConn
}

func NewStoreClient(cc *grpc.ClientConn) StoreClient {
	return &storeClient{cc}
}

func (c *storeClient) Info(ctx context.Context, in *InfoRequest, opts ...grpc.CallOption) (*InfoResponse, error) {
	out := new(InfoResponse)
	err := c.cc.Invoke(ctx, "/thanos.Store/Info", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storeClient) Series(ctx context.Context, in *SeriesRequest, opts ...grpc.CallOption) (Store_SeriesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Store_serviceDesc.Streams[0], "/thanos.Store/Series", opts...)
	if err != nil {
		return nil, err
	}
	x := &storeSeriesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Store_SeriesClient interface {
	Recv() (*SeriesResponse, error)
	grpc.ClientStream
}

type storeSeriesClient struct {
	grpc.ClientStream
}

func (x *storeSeriesClient) Recv() (*SeriesResponse, error) {
	m := new(SeriesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *storeClient) LabelNames(ctx context.Context, in *LabelNamesRequest, opts ...grpc.CallOption) (*LabelNamesResponse, error) {
	out := new(LabelNamesResponse)
	err := c.cc.Invoke(ctx, "/thanos.Store/LabelNames", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storeClient) LabelValues(ctx context.Context, in *LabelValuesRequest, opts ...grpc.CallOption) (*LabelValuesResponse, error) {
	out := new(LabelValuesResponse)
	err := c.cc.Invoke(ctx, "/thanos.Store/LabelValues", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StoreServer is the server API for Store service.
type StoreServer interface {
	/// Info returns meta information about a store e.g labels that makes that store unique as well as time range that is
	/// available.
	Info(context.Context, *InfoRequest) (*InfoResponse, error)
	/// Series streams each Series (Labels and chunk/downsampling chunk) for given label matchers and time range.
	///
	/// Series should strictly stream full series after series, optionally split by time. This means that a single frame can contain
	/// partition of the single series, but once a new series is started to be streamed it means that no more data will
	/// be sent for previous one.
	/// Series has to be sorted.
	///
	/// There is no requirements on chunk sorting, however it is recommended to have chunk sorted by chunk min time.
	/// This heavily optimizes the resource usage on Querier / Federated Queries.
	Series(*SeriesRequest, Store_SeriesServer) error
	/// LabelNames returns all label names that is available.
	/// Currently unimplemented in all Thanos implementations, because Query API does not implement this either.
	LabelNames(context.Context, *LabelNamesRequest) (*LabelNamesResponse, error)
	/// LabelValues returns all label values for given label name.
	LabelValues(context.Context, *LabelValuesRequest) (*LabelValuesResponse, error)
}

// UnimplementedStoreServer can be embedded to have forward compatible implementations.
type UnimplementedStoreServer struct {
}

func (*UnimplementedStoreServer) Info(ctx context.Context, req *InfoRequest) (*InfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Info not implemented")
}
func (*UnimplementedStoreServer) Series(req *SeriesRequest, srv Store_SeriesServer) error {
	return status.Errorf(codes.Unimplemented, "method Series not implemented")
}
func (*UnimplementedStoreServer) LabelNames(ctx context.Context, req *LabelNamesRequest) (*LabelNamesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LabelNames not implemented")
}
func (*UnimplementedStoreServer) LabelValues(ctx context.Context, req *LabelValuesRequest) (*LabelValuesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LabelValues not implemented")
}

func RegisterStoreServer(s *grpc.Server, srv StoreServer) {
	s.RegisterService(&_Store_serviceDesc, srv)
}

func _Store_Info_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoreServer).Info(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.Store/Info",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoreServer).Info(ctx, req.(*InfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Store_Series_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SeriesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StoreServer).Series(m, &storeSeriesServer{stream})
}

type Store_SeriesServer interface {
	Send(*SeriesResponse) error
	grpc.ServerStream
}

type storeSeriesServer struct {
	grpc.ServerStream
}

func (x *storeSeriesServer) Send(m *SeriesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Store_LabelNames_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelNamesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoreServer).LabelNames(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.Store/LabelNames",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoreServer).LabelNames(ctx, req.(*LabelNamesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Store_LabelValues_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LabelValuesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StoreServer).LabelValues(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.Store/LabelValues",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StoreServer).LabelValues(ctx, req.(*LabelValuesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Store_serviceDesc = grpc.ServiceDesc{
	ServiceName: "thanos.Store",
	HandlerType: (*StoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Info",
			Handler:    _Store_Info_Handler,
		},
		{
			MethodName: "LabelNames",
			Handler:    _Store_LabelNames_Handler,
		},
		{
			MethodName: "LabelValues",
			Handler:    _Store_LabelValues_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Series",
			Handler:       _Store_Series_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "store/storepb/rpc.proto",
}

// WriteableStoreClient is the client API for WriteableStore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WriteableStoreClient interface {
	// WriteRequest allows you to write metrics to this store via remote write
	RemoteWrite(ctx context.Context, in *WriteRequest, opts ...grpc.CallOption) (*WriteResponse, error)
}

type writeableStoreClient struct {
	cc *grpc.ClientConn
}

func NewWriteableStoreClient(cc *grpc.ClientConn) WriteableStoreClient {
	return &writeableStoreClient{cc}
}

func (c *writeableStoreClient) RemoteWrite(ctx context.Context, in *WriteRequest, opts ...grpc.CallOption) (*WriteResponse, error) {
	out := new(WriteResponse)
	err := c.cc.Invoke(ctx, "/thanos.WriteableStore/RemoteWrite", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WriteableStoreServer is the server API for WriteableStore service.
type WriteableStoreServer interface {
	// WriteRequest allows you to write metrics to this store via remote write
	RemoteWrite(context.Context, *WriteRequest) (*WriteResponse, error)
}

// UnimplementedWriteableStoreServer can be embedded to have forward compatible implementations.
type UnimplementedWriteableStoreServer struct {
}

func (*UnimplementedWriteableStoreServer) RemoteWrite(ctx context.Context, req *WriteRequest) (*WriteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoteWrite not implemented")
}

func RegisterWriteableStoreServer(s *grpc.Server, srv WriteableStoreServer) {
	s.RegisterService(&_WriteableStore_serviceDesc, srv)
}

func _WriteableStore_RemoteWrite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WriteableStoreServer).RemoteWrite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/thanos.WriteableStore/RemoteWrite",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WriteableStoreServer).RemoteWrite(ctx, req.(*WriteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _WriteableStore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "thanos.WriteableStore",
	HandlerType: (*WriteableStoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "RemoteWrite",
			Handler:    _WriteableStore_RemoteWrite_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "store/storepb/rpc.proto",
}

func (m *WriteResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WriteResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *WriteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WriteRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Replica != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Replica))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Tenant) > 0 {
		i -= len(m.Tenant)
		copy(dAtA[i:], m.Tenant)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Tenant)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Timeseries) > 0 {
		for iNdEx := len(m.Timeseries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Timeseries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *InfoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InfoRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *InfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InfoResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.LabelSets) > 0 {
		for iNdEx := len(m.LabelSets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.LabelSets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.StoreType != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.StoreType))
		i--
		dAtA[i] = 0x20
	}
	if m.MaxTime != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MaxTime))
		i--
		dAtA[i] = 0x18
	}
	if m.MinTime != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MinTime))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LabelSet) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelSet) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelSet) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for iNdEx := len(m.Labels) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Labels[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SeriesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.SkipChunks {
		i--
		if m.SkipChunks {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x38
	}
	if m.PartialResponseDisabled {
		i--
		if m.PartialResponseDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.Aggregates) > 0 {
		dAtA3 := make([]byte, len(m.Aggregates)*10)
		var j2 int
		for _, num := range m.Aggregates {
			for num >= 1<<7 {
				dAtA3[j2] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j2++
			}
			dAtA3[j2] = uint8(num)
			j2++
		}
		i -= j2
		copy(dAtA[i:], dAtA3[:j2])
		i = encodeVarintRpc(dAtA, i, uint64(j2))
		i--
		dAtA[i] = 0x2a
	}
	if m.MaxResolutionWindow != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MaxResolutionWindow))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Matchers) > 0 {
		for iNdEx := len(m.Matchers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Matchers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintRpc(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.MaxTime != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MaxTime))
		i--
		dAtA[i] = 0x10
	}
	if m.MinTime != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.MinTime))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SeriesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SeriesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *SeriesResponse_Series) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_Series) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Series != nil {
		{
			size, err := m.Series.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *SeriesResponse_Warning) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_Warning) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Warning)
	copy(dAtA[i:], m.Warning)
	i = encodeVarintRpc(dAtA, i, uint64(len(m.Warning)))
	i--
	dAtA[i] = 0x12
	return len(dAtA) - i, nil
}
func (m *SeriesResponse_Hints) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SeriesResponse_Hints) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Hints != nil {
		{
			size, err := m.Hints.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintRpc(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	return len(dAtA) - i, nil
}
func (m *LabelNamesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelNamesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelNamesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.End != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x20
	}
	if m.Start != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x18
	}
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x10
	}
	if m.PartialResponseDisabled {
		i--
		if m.PartialResponseDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LabelNamesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelNamesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelNamesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Warnings) > 0 {
		for iNdEx := len(m.Warnings) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Warnings[iNdEx])
			copy(dAtA[i:], m.Warnings[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Warnings[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Names) > 0 {
		for iNdEx := len(m.Names) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Names[iNdEx])
			copy(dAtA[i:], m.Names[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Names[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *LabelValuesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelValuesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelValuesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.End != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x28
	}
	if m.Start != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x20
	}
	if m.PartialResponseStrategy != 0 {
		i = encodeVarintRpc(dAtA, i, uint64(m.PartialResponseStrategy))
		i--
		dAtA[i] = 0x18
	}
	if m.PartialResponseDisabled {
		i--
		if m.PartialResponseDisabled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Label) > 0 {
		i -= len(m.Label)
		copy(dAtA[i:], m.Label)
		i = encodeVarintRpc(dAtA, i, uint64(len(m.Label)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LabelValuesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LabelValuesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LabelValuesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Warnings) > 0 {
		for iNdEx := len(m.Warnings) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Warnings[iNdEx])
			copy(dAtA[i:], m.Warnings[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Warnings[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Values) > 0 {
		for iNdEx := len(m.Values) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Values[iNdEx])
			copy(dAtA[i:], m.Values[iNdEx])
			i = encodeVarintRpc(dAtA, i, uint64(len(m.Values[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintRpc(dAtA []byte, offset int, v uint64) int {
	offset -= sovRpc(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *WriteResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *WriteRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Timeseries) > 0 {
		for _, e := range m.Timeseries {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	l = len(m.Tenant)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.Replica != 0 {
		n += 1 + sovRpc(uint64(m.Replica))
	}
	return n
}

func (m *InfoRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *InfoResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.MinTime != 0 {
		n += 1 + sovRpc(uint64(m.MinTime))
	}
	if m.MaxTime != 0 {
		n += 1 + sovRpc(uint64(m.MaxTime))
	}
	if m.StoreType != 0 {
		n += 1 + sovRpc(uint64(m.StoreType))
	}
	if len(m.LabelSets) > 0 {
		for _, e := range m.LabelSets {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func (m *LabelSet) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Labels) > 0 {
		for _, e := range m.Labels {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func (m *SeriesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MinTime != 0 {
		n += 1 + sovRpc(uint64(m.MinTime))
	}
	if m.MaxTime != 0 {
		n += 1 + sovRpc(uint64(m.MaxTime))
	}
	if len(m.Matchers) > 0 {
		for _, e := range m.Matchers {
			l = e.Size()
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if m.MaxResolutionWindow != 0 {
		n += 1 + sovRpc(uint64(m.MaxResolutionWindow))
	}
	if len(m.Aggregates) > 0 {
		l = 0
		for _, e := range m.Aggregates {
			l += sovRpc(uint64(e))
		}
		n += 1 + sovRpc(uint64(l)) + l
	}
	if m.PartialResponseDisabled {
		n += 2
	}
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	if m.SkipChunks {
		n += 2
	}
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}

func (m *SeriesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *SeriesResponse_Series) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Series != nil {
		l = m.Series.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *SeriesResponse_Warning) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Warning)
	n += 1 + l + sovRpc(uint64(l))
	return n
}
func (m *SeriesResponse_Hints) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Hints != nil {
		l = m.Hints.Size()
		n += 1 + l + sovRpc(uint64(l))
	}
	return n
}
func (m *LabelNamesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.PartialResponseDisabled {
		n += 2
	}
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	if m.Start != 0 {
		n += 1 + sovRpc(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovRpc(uint64(m.End))
	}
	return n
}

func (m *LabelNamesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Names) > 0 {
		for _, s := range m.Names {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func (m *LabelValuesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Label)
	if l > 0 {
		n += 1 + l + sovRpc(uint64(l))
	}
	if m.PartialResponseDisabled {
		n += 2
	}
	if m.PartialResponseStrategy != 0 {
		n += 1 + sovRpc(uint64(m.PartialResponseStrategy))
	}
	if m.Start != 0 {
		n += 1 + sovRpc(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovRpc(uint64(m.End))
	}
	return n
}

func (m *LabelValuesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Values) > 0 {
		for _, s := range m.Values {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovRpc(uint64(l))
		}
	}
	return n
}

func sovRpc(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozRpc(x uint64) (n int) {
	return sovRpc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *WriteResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeseries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Timeseries = append(m.Timeseries, prompb.TimeSeries{})
			if err := m.Timeseries[len(m.Timeseries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tenant", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tenant = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			m.Replica = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Replica |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, Label{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTime", wireType)
			}
			m.MinTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTime", wireType)
			}
			m.MaxTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreType", wireType)
			}
			m.StoreType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreType |= StoreType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelSets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LabelSets = append(m.LabelSets, LabelSet{})
			if err := m.LabelSets[len(m.LabelSets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelSet) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelSet: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelSet: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Labels = append(m.Labels, Label{})
			if err := m.Labels[len(m.Labels)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SeriesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinTime", wireType)
			}
			m.MinTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTime", wireType)
			}
			m.MaxTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxTime |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Matchers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Matchers = append(m.Matchers, LabelMatcher{})
			if err := m.Matchers[len(m.Matchers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxResolutionWindow", wireType)
			}
			m.MaxResolutionWindow = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxResolutionWindow |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType == 0 {
				var v Aggr
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRpc
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= Aggr(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Aggregates = append(m.Aggregates, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRpc
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthRpc
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthRpc
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				if elementCount != 0 && len(m.Aggregates) == 0 {
					m.Aggregates = make([]Aggr, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v Aggr
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRpc
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= Aggr(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Aggregates = append(m.Aggregates, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregates", wireType)
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PartialResponseDisabled = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SkipChunks", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SkipChunks = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Hints == nil {
				m.Hints = &types.Any{}
			}
			if err := m.Hints.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SeriesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SeriesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SeriesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Series", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Series{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_Series{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warning", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Result = &SeriesResponse_Warning{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &types.Any{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &SeriesResponse_Hints{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelNamesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelNamesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelNamesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PartialResponseDisabled = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelNamesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelNamesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelNamesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Names", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Names = append(m.Names, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelValuesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelValuesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelValuesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Label", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Label = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseDisabled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PartialResponseDisabled = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialResponseStrategy", wireType)
			}
			m.PartialResponseStrategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PartialResponseStrategy |= PartialResponseStrategy(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LabelValuesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LabelValuesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LabelValuesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Values = append(m.Values, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRpc
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthRpc
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRpc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthRpc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRpc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRpc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRpc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthRpc
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupRpc
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthRpc
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthRpc        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRpc          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupRpc = fmt.Errorf("proto: unexpected end of group")
)
