# In-Tree and Out-of-Tree Implementation Models for Cloud Providers in Kubernetes

Originally, Kubernetes implemented cloud provider-specific functionalities natively within the main Kubernetes tree, or as in-tree modules. However, with more infrastructure providers supporting Kubernetes, the old method has become impractical and is no longer advised. New providers that support Kubernetes must follow the out-of-tree model. For the existing in-tree cloud providers, Kubernetes offers a program of migration to the out-of-tree architecture and removal of all cloud provider specific code from the repository. See the [Removing In-Tree Cloud Provider Code](https://github.com/kubernetes/enhancements/tree/master/keps/sig-cloud-provider/2395-removing-in-tree-cloud-providers) proposal for more details.

While the mechanism for supporting cloud providers is still in transition, it is important to understand the difference between the in-tree and out-of-tree models.

The in-tree cloud providers are developed and released in the main Kubernetes repository. With the in-tree model, you simply deploy Kubernetes without the need to install any additional components. You can immediately begin to provision storage by setting the appropriate StorageClass that matches your underlying storage infrastructure. To control placement decisions, you can use zones and regions that are usually implemented.

The out-of-tree model does not offer a driver or provider in the Kubernetes repository, but the provider can be developed, built, and released independently of Kubernetes core. The out-of-tree solution that vSphere offers includes two distinct components, the Cloud Provider Interface (CPI) and the Container Storage Interface (CSI). Before you can start consuming underlying infrastructure resources, you must install both components.
