// +build !ignore_autogenerated_kubeadm_bootstrap_v1alpha3

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1beta1

import (
	unsafe "unsafe"

	corev1 "k8s.io/api/core/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	v1alpha4 "sigs.k8s.io/cluster-api/bootstrap/kubeadm/api/v1alpha4"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*APIEndpoint)(nil), (*v1alpha4.APIEndpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(a.(*APIEndpoint), b.(*v1alpha4.APIEndpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.APIEndpoint)(nil), (*APIEndpoint)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(a.(*v1alpha4.APIEndpoint), b.(*APIEndpoint), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*APIServer)(nil), (*v1alpha4.APIServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_APIServer_To_v1alpha4_APIServer(a.(*APIServer), b.(*v1alpha4.APIServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.APIServer)(nil), (*APIServer)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_APIServer_To_v1beta1_APIServer(a.(*v1alpha4.APIServer), b.(*APIServer), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BootstrapToken)(nil), (*v1alpha4.BootstrapToken)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_BootstrapToken_To_v1alpha4_BootstrapToken(a.(*BootstrapToken), b.(*v1alpha4.BootstrapToken), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.BootstrapToken)(nil), (*BootstrapToken)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_BootstrapToken_To_v1beta1_BootstrapToken(a.(*v1alpha4.BootstrapToken), b.(*BootstrapToken), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BootstrapTokenDiscovery)(nil), (*v1alpha4.BootstrapTokenDiscovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_BootstrapTokenDiscovery_To_v1alpha4_BootstrapTokenDiscovery(a.(*BootstrapTokenDiscovery), b.(*v1alpha4.BootstrapTokenDiscovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.BootstrapTokenDiscovery)(nil), (*BootstrapTokenDiscovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_BootstrapTokenDiscovery_To_v1beta1_BootstrapTokenDiscovery(a.(*v1alpha4.BootstrapTokenDiscovery), b.(*BootstrapTokenDiscovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*BootstrapTokenString)(nil), (*v1alpha4.BootstrapTokenString)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_BootstrapTokenString_To_v1alpha4_BootstrapTokenString(a.(*BootstrapTokenString), b.(*v1alpha4.BootstrapTokenString), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.BootstrapTokenString)(nil), (*BootstrapTokenString)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_BootstrapTokenString_To_v1beta1_BootstrapTokenString(a.(*v1alpha4.BootstrapTokenString), b.(*BootstrapTokenString), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.ClusterConfiguration)(nil), (*ClusterConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ClusterConfiguration_To_v1beta1_ClusterConfiguration(a.(*v1alpha4.ClusterConfiguration), b.(*ClusterConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ClusterStatus)(nil), (*v1alpha4.ClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus(a.(*ClusterStatus), b.(*v1alpha4.ClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.ClusterStatus)(nil), (*ClusterStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus(a.(*v1alpha4.ClusterStatus), b.(*ClusterStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ControlPlaneComponent)(nil), (*v1alpha4.ControlPlaneComponent)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ControlPlaneComponent_To_v1alpha4_ControlPlaneComponent(a.(*ControlPlaneComponent), b.(*v1alpha4.ControlPlaneComponent), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.ControlPlaneComponent)(nil), (*ControlPlaneComponent)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(a.(*v1alpha4.ControlPlaneComponent), b.(*ControlPlaneComponent), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.DNS)(nil), (*DNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_DNS_To_v1beta1_DNS(a.(*v1alpha4.DNS), b.(*DNS), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Discovery)(nil), (*v1alpha4.Discovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Discovery_To_v1alpha4_Discovery(a.(*Discovery), b.(*v1alpha4.Discovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.Discovery)(nil), (*Discovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_Discovery_To_v1beta1_Discovery(a.(*v1alpha4.Discovery), b.(*Discovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Etcd)(nil), (*v1alpha4.Etcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Etcd_To_v1alpha4_Etcd(a.(*Etcd), b.(*v1alpha4.Etcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.Etcd)(nil), (*Etcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_Etcd_To_v1beta1_Etcd(a.(*v1alpha4.Etcd), b.(*Etcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ExternalEtcd)(nil), (*v1alpha4.ExternalEtcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ExternalEtcd_To_v1alpha4_ExternalEtcd(a.(*ExternalEtcd), b.(*v1alpha4.ExternalEtcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.ExternalEtcd)(nil), (*ExternalEtcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ExternalEtcd_To_v1beta1_ExternalEtcd(a.(*v1alpha4.ExternalEtcd), b.(*ExternalEtcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*FileDiscovery)(nil), (*v1alpha4.FileDiscovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_FileDiscovery_To_v1alpha4_FileDiscovery(a.(*FileDiscovery), b.(*v1alpha4.FileDiscovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.FileDiscovery)(nil), (*FileDiscovery)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_FileDiscovery_To_v1beta1_FileDiscovery(a.(*v1alpha4.FileDiscovery), b.(*FileDiscovery), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*HostPathMount)(nil), (*v1alpha4.HostPathMount)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_HostPathMount_To_v1alpha4_HostPathMount(a.(*HostPathMount), b.(*v1alpha4.HostPathMount), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.HostPathMount)(nil), (*HostPathMount)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_HostPathMount_To_v1beta1_HostPathMount(a.(*v1alpha4.HostPathMount), b.(*HostPathMount), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*ImageMeta)(nil), (*v1alpha4.ImageMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ImageMeta_To_v1alpha4_ImageMeta(a.(*ImageMeta), b.(*v1alpha4.ImageMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.ImageMeta)(nil), (*ImageMeta)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_ImageMeta_To_v1beta1_ImageMeta(a.(*v1alpha4.ImageMeta), b.(*ImageMeta), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*InitConfiguration)(nil), (*v1alpha4.InitConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_InitConfiguration_To_v1alpha4_InitConfiguration(a.(*InitConfiguration), b.(*v1alpha4.InitConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.InitConfiguration)(nil), (*InitConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_InitConfiguration_To_v1beta1_InitConfiguration(a.(*v1alpha4.InitConfiguration), b.(*InitConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*JoinConfiguration)(nil), (*v1alpha4.JoinConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_JoinConfiguration_To_v1alpha4_JoinConfiguration(a.(*JoinConfiguration), b.(*v1alpha4.JoinConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.JoinConfiguration)(nil), (*JoinConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_JoinConfiguration_To_v1beta1_JoinConfiguration(a.(*v1alpha4.JoinConfiguration), b.(*JoinConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*JoinControlPlane)(nil), (*v1alpha4.JoinControlPlane)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_JoinControlPlane_To_v1alpha4_JoinControlPlane(a.(*JoinControlPlane), b.(*v1alpha4.JoinControlPlane), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.JoinControlPlane)(nil), (*JoinControlPlane)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_JoinControlPlane_To_v1beta1_JoinControlPlane(a.(*v1alpha4.JoinControlPlane), b.(*JoinControlPlane), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*LocalEtcd)(nil), (*v1alpha4.LocalEtcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_LocalEtcd_To_v1alpha4_LocalEtcd(a.(*LocalEtcd), b.(*v1alpha4.LocalEtcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.LocalEtcd)(nil), (*LocalEtcd)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_LocalEtcd_To_v1beta1_LocalEtcd(a.(*v1alpha4.LocalEtcd), b.(*LocalEtcd), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*Networking)(nil), (*v1alpha4.Networking)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Networking_To_v1alpha4_Networking(a.(*Networking), b.(*v1alpha4.Networking), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1alpha4.Networking)(nil), (*Networking)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_Networking_To_v1beta1_Networking(a.(*v1alpha4.Networking), b.(*Networking), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*NodeRegistrationOptions)(nil), (*v1alpha4.NodeRegistrationOptions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_NodeRegistrationOptions_To_v1alpha4_NodeRegistrationOptions(a.(*NodeRegistrationOptions), b.(*v1alpha4.NodeRegistrationOptions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1alpha4.NodeRegistrationOptions)(nil), (*NodeRegistrationOptions)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha4_NodeRegistrationOptions_To_v1beta1_NodeRegistrationOptions(a.(*v1alpha4.NodeRegistrationOptions), b.(*NodeRegistrationOptions), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*ClusterConfiguration)(nil), (*v1alpha4.ClusterConfiguration)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ClusterConfiguration_To_v1alpha4_ClusterConfiguration(a.(*ClusterConfiguration), b.(*v1alpha4.ClusterConfiguration), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*DNS)(nil), (*v1alpha4.DNS)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DNS_To_v1alpha4_DNS(a.(*DNS), b.(*v1alpha4.DNS), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(in *APIEndpoint, out *v1alpha4.APIEndpoint, s conversion.Scope) error {
	out.AdvertiseAddress = in.AdvertiseAddress
	out.BindPort = in.BindPort
	return nil
}

// Convert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint is an autogenerated conversion function.
func Convert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(in *APIEndpoint, out *v1alpha4.APIEndpoint, s conversion.Scope) error {
	return autoConvert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(in, out, s)
}

func autoConvert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(in *v1alpha4.APIEndpoint, out *APIEndpoint, s conversion.Scope) error {
	out.AdvertiseAddress = in.AdvertiseAddress
	out.BindPort = in.BindPort
	return nil
}

// Convert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint is an autogenerated conversion function.
func Convert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(in *v1alpha4.APIEndpoint, out *APIEndpoint, s conversion.Scope) error {
	return autoConvert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(in, out, s)
}

func autoConvert_v1beta1_APIServer_To_v1alpha4_APIServer(in *APIServer, out *v1alpha4.APIServer, s conversion.Scope) error {
	if err := Convert_v1beta1_ControlPlaneComponent_To_v1alpha4_ControlPlaneComponent(&in.ControlPlaneComponent, &out.ControlPlaneComponent, s); err != nil {
		return err
	}
	out.CertSANs = *(*[]string)(unsafe.Pointer(&in.CertSANs))
	out.TimeoutForControlPlane = (*v1.Duration)(unsafe.Pointer(in.TimeoutForControlPlane))
	return nil
}

// Convert_v1beta1_APIServer_To_v1alpha4_APIServer is an autogenerated conversion function.
func Convert_v1beta1_APIServer_To_v1alpha4_APIServer(in *APIServer, out *v1alpha4.APIServer, s conversion.Scope) error {
	return autoConvert_v1beta1_APIServer_To_v1alpha4_APIServer(in, out, s)
}

func autoConvert_v1alpha4_APIServer_To_v1beta1_APIServer(in *v1alpha4.APIServer, out *APIServer, s conversion.Scope) error {
	if err := Convert_v1alpha4_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(&in.ControlPlaneComponent, &out.ControlPlaneComponent, s); err != nil {
		return err
	}
	out.CertSANs = *(*[]string)(unsafe.Pointer(&in.CertSANs))
	out.TimeoutForControlPlane = (*v1.Duration)(unsafe.Pointer(in.TimeoutForControlPlane))
	return nil
}

// Convert_v1alpha4_APIServer_To_v1beta1_APIServer is an autogenerated conversion function.
func Convert_v1alpha4_APIServer_To_v1beta1_APIServer(in *v1alpha4.APIServer, out *APIServer, s conversion.Scope) error {
	return autoConvert_v1alpha4_APIServer_To_v1beta1_APIServer(in, out, s)
}

func autoConvert_v1beta1_BootstrapToken_To_v1alpha4_BootstrapToken(in *BootstrapToken, out *v1alpha4.BootstrapToken, s conversion.Scope) error {
	out.Token = (*v1alpha4.BootstrapTokenString)(unsafe.Pointer(in.Token))
	out.Description = in.Description
	out.TTL = (*v1.Duration)(unsafe.Pointer(in.TTL))
	out.Expires = (*v1.Time)(unsafe.Pointer(in.Expires))
	out.Usages = *(*[]string)(unsafe.Pointer(&in.Usages))
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	return nil
}

// Convert_v1beta1_BootstrapToken_To_v1alpha4_BootstrapToken is an autogenerated conversion function.
func Convert_v1beta1_BootstrapToken_To_v1alpha4_BootstrapToken(in *BootstrapToken, out *v1alpha4.BootstrapToken, s conversion.Scope) error {
	return autoConvert_v1beta1_BootstrapToken_To_v1alpha4_BootstrapToken(in, out, s)
}

func autoConvert_v1alpha4_BootstrapToken_To_v1beta1_BootstrapToken(in *v1alpha4.BootstrapToken, out *BootstrapToken, s conversion.Scope) error {
	out.Token = (*BootstrapTokenString)(unsafe.Pointer(in.Token))
	out.Description = in.Description
	out.TTL = (*v1.Duration)(unsafe.Pointer(in.TTL))
	out.Expires = (*v1.Time)(unsafe.Pointer(in.Expires))
	out.Usages = *(*[]string)(unsafe.Pointer(&in.Usages))
	out.Groups = *(*[]string)(unsafe.Pointer(&in.Groups))
	return nil
}

// Convert_v1alpha4_BootstrapToken_To_v1beta1_BootstrapToken is an autogenerated conversion function.
func Convert_v1alpha4_BootstrapToken_To_v1beta1_BootstrapToken(in *v1alpha4.BootstrapToken, out *BootstrapToken, s conversion.Scope) error {
	return autoConvert_v1alpha4_BootstrapToken_To_v1beta1_BootstrapToken(in, out, s)
}

func autoConvert_v1beta1_BootstrapTokenDiscovery_To_v1alpha4_BootstrapTokenDiscovery(in *BootstrapTokenDiscovery, out *v1alpha4.BootstrapTokenDiscovery, s conversion.Scope) error {
	out.Token = in.Token
	out.APIServerEndpoint = in.APIServerEndpoint
	out.CACertHashes = *(*[]string)(unsafe.Pointer(&in.CACertHashes))
	out.UnsafeSkipCAVerification = in.UnsafeSkipCAVerification
	return nil
}

// Convert_v1beta1_BootstrapTokenDiscovery_To_v1alpha4_BootstrapTokenDiscovery is an autogenerated conversion function.
func Convert_v1beta1_BootstrapTokenDiscovery_To_v1alpha4_BootstrapTokenDiscovery(in *BootstrapTokenDiscovery, out *v1alpha4.BootstrapTokenDiscovery, s conversion.Scope) error {
	return autoConvert_v1beta1_BootstrapTokenDiscovery_To_v1alpha4_BootstrapTokenDiscovery(in, out, s)
}

func autoConvert_v1alpha4_BootstrapTokenDiscovery_To_v1beta1_BootstrapTokenDiscovery(in *v1alpha4.BootstrapTokenDiscovery, out *BootstrapTokenDiscovery, s conversion.Scope) error {
	out.Token = in.Token
	out.APIServerEndpoint = in.APIServerEndpoint
	out.CACertHashes = *(*[]string)(unsafe.Pointer(&in.CACertHashes))
	out.UnsafeSkipCAVerification = in.UnsafeSkipCAVerification
	return nil
}

// Convert_v1alpha4_BootstrapTokenDiscovery_To_v1beta1_BootstrapTokenDiscovery is an autogenerated conversion function.
func Convert_v1alpha4_BootstrapTokenDiscovery_To_v1beta1_BootstrapTokenDiscovery(in *v1alpha4.BootstrapTokenDiscovery, out *BootstrapTokenDiscovery, s conversion.Scope) error {
	return autoConvert_v1alpha4_BootstrapTokenDiscovery_To_v1beta1_BootstrapTokenDiscovery(in, out, s)
}

func autoConvert_v1beta1_BootstrapTokenString_To_v1alpha4_BootstrapTokenString(in *BootstrapTokenString, out *v1alpha4.BootstrapTokenString, s conversion.Scope) error {
	out.ID = in.ID
	out.Secret = in.Secret
	return nil
}

// Convert_v1beta1_BootstrapTokenString_To_v1alpha4_BootstrapTokenString is an autogenerated conversion function.
func Convert_v1beta1_BootstrapTokenString_To_v1alpha4_BootstrapTokenString(in *BootstrapTokenString, out *v1alpha4.BootstrapTokenString, s conversion.Scope) error {
	return autoConvert_v1beta1_BootstrapTokenString_To_v1alpha4_BootstrapTokenString(in, out, s)
}

func autoConvert_v1alpha4_BootstrapTokenString_To_v1beta1_BootstrapTokenString(in *v1alpha4.BootstrapTokenString, out *BootstrapTokenString, s conversion.Scope) error {
	out.ID = in.ID
	out.Secret = in.Secret
	return nil
}

// Convert_v1alpha4_BootstrapTokenString_To_v1beta1_BootstrapTokenString is an autogenerated conversion function.
func Convert_v1alpha4_BootstrapTokenString_To_v1beta1_BootstrapTokenString(in *v1alpha4.BootstrapTokenString, out *BootstrapTokenString, s conversion.Scope) error {
	return autoConvert_v1alpha4_BootstrapTokenString_To_v1beta1_BootstrapTokenString(in, out, s)
}

func autoConvert_v1beta1_ClusterConfiguration_To_v1alpha4_ClusterConfiguration(in *ClusterConfiguration, out *v1alpha4.ClusterConfiguration, s conversion.Scope) error {
	if err := Convert_v1beta1_Etcd_To_v1alpha4_Etcd(&in.Etcd, &out.Etcd, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_Networking_To_v1alpha4_Networking(&in.Networking, &out.Networking, s); err != nil {
		return err
	}
	out.KubernetesVersion = in.KubernetesVersion
	out.ControlPlaneEndpoint = in.ControlPlaneEndpoint
	if err := Convert_v1beta1_APIServer_To_v1alpha4_APIServer(&in.APIServer, &out.APIServer, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_ControlPlaneComponent_To_v1alpha4_ControlPlaneComponent(&in.ControllerManager, &out.ControllerManager, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_ControlPlaneComponent_To_v1alpha4_ControlPlaneComponent(&in.Scheduler, &out.Scheduler, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_DNS_To_v1alpha4_DNS(&in.DNS, &out.DNS, s); err != nil {
		return err
	}
	out.CertificatesDir = in.CertificatesDir
	out.ImageRepository = in.ImageRepository
	// WARNING: in.UseHyperKubeImage requires manual conversion: does not exist in peer-type
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	out.ClusterName = in.ClusterName
	return nil
}

func autoConvert_v1alpha4_ClusterConfiguration_To_v1beta1_ClusterConfiguration(in *v1alpha4.ClusterConfiguration, out *ClusterConfiguration, s conversion.Scope) error {
	if err := Convert_v1alpha4_Etcd_To_v1beta1_Etcd(&in.Etcd, &out.Etcd, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_Networking_To_v1beta1_Networking(&in.Networking, &out.Networking, s); err != nil {
		return err
	}
	out.KubernetesVersion = in.KubernetesVersion
	out.ControlPlaneEndpoint = in.ControlPlaneEndpoint
	if err := Convert_v1alpha4_APIServer_To_v1beta1_APIServer(&in.APIServer, &out.APIServer, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(&in.ControllerManager, &out.ControllerManager, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(&in.Scheduler, &out.Scheduler, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_DNS_To_v1beta1_DNS(&in.DNS, &out.DNS, s); err != nil {
		return err
	}
	out.CertificatesDir = in.CertificatesDir
	out.ImageRepository = in.ImageRepository
	out.FeatureGates = *(*map[string]bool)(unsafe.Pointer(&in.FeatureGates))
	out.ClusterName = in.ClusterName
	return nil
}

// Convert_v1alpha4_ClusterConfiguration_To_v1beta1_ClusterConfiguration is an autogenerated conversion function.
func Convert_v1alpha4_ClusterConfiguration_To_v1beta1_ClusterConfiguration(in *v1alpha4.ClusterConfiguration, out *ClusterConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha4_ClusterConfiguration_To_v1beta1_ClusterConfiguration(in, out, s)
}

func autoConvert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus(in *ClusterStatus, out *v1alpha4.ClusterStatus, s conversion.Scope) error {
	out.APIEndpoints = *(*map[string]v1alpha4.APIEndpoint)(unsafe.Pointer(&in.APIEndpoints))
	return nil
}

// Convert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus is an autogenerated conversion function.
func Convert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus(in *ClusterStatus, out *v1alpha4.ClusterStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_ClusterStatus_To_v1alpha4_ClusterStatus(in, out, s)
}

func autoConvert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus(in *v1alpha4.ClusterStatus, out *ClusterStatus, s conversion.Scope) error {
	out.APIEndpoints = *(*map[string]APIEndpoint)(unsafe.Pointer(&in.APIEndpoints))
	return nil
}

// Convert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus is an autogenerated conversion function.
func Convert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus(in *v1alpha4.ClusterStatus, out *ClusterStatus, s conversion.Scope) error {
	return autoConvert_v1alpha4_ClusterStatus_To_v1beta1_ClusterStatus(in, out, s)
}

func autoConvert_v1beta1_ControlPlaneComponent_To_v1alpha4_ControlPlaneComponent(in *ControlPlaneComponent, out *v1alpha4.ControlPlaneComponent, s conversion.Scope) error {
	out.ExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.ExtraArgs))
	out.ExtraVolumes = *(*[]v1alpha4.HostPathMount)(unsafe.Pointer(&in.ExtraVolumes))
	return nil
}

// Convert_v1beta1_ControlPlaneComponent_To_v1alpha4_ControlPlaneComponent is an autogenerated conversion function.
func Convert_v1beta1_ControlPlaneComponent_To_v1alpha4_ControlPlaneComponent(in *ControlPlaneComponent, out *v1alpha4.ControlPlaneComponent, s conversion.Scope) error {
	return autoConvert_v1beta1_ControlPlaneComponent_To_v1alpha4_ControlPlaneComponent(in, out, s)
}

func autoConvert_v1alpha4_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(in *v1alpha4.ControlPlaneComponent, out *ControlPlaneComponent, s conversion.Scope) error {
	out.ExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.ExtraArgs))
	out.ExtraVolumes = *(*[]HostPathMount)(unsafe.Pointer(&in.ExtraVolumes))
	return nil
}

// Convert_v1alpha4_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent is an autogenerated conversion function.
func Convert_v1alpha4_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(in *v1alpha4.ControlPlaneComponent, out *ControlPlaneComponent, s conversion.Scope) error {
	return autoConvert_v1alpha4_ControlPlaneComponent_To_v1beta1_ControlPlaneComponent(in, out, s)
}

func autoConvert_v1beta1_DNS_To_v1alpha4_DNS(in *DNS, out *v1alpha4.DNS, s conversion.Scope) error {
	// WARNING: in.Type requires manual conversion: does not exist in peer-type
	if err := Convert_v1beta1_ImageMeta_To_v1alpha4_ImageMeta(&in.ImageMeta, &out.ImageMeta, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha4_DNS_To_v1beta1_DNS(in *v1alpha4.DNS, out *DNS, s conversion.Scope) error {
	if err := Convert_v1alpha4_ImageMeta_To_v1beta1_ImageMeta(&in.ImageMeta, &out.ImageMeta, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_DNS_To_v1beta1_DNS is an autogenerated conversion function.
func Convert_v1alpha4_DNS_To_v1beta1_DNS(in *v1alpha4.DNS, out *DNS, s conversion.Scope) error {
	return autoConvert_v1alpha4_DNS_To_v1beta1_DNS(in, out, s)
}

func autoConvert_v1beta1_Discovery_To_v1alpha4_Discovery(in *Discovery, out *v1alpha4.Discovery, s conversion.Scope) error {
	out.BootstrapToken = (*v1alpha4.BootstrapTokenDiscovery)(unsafe.Pointer(in.BootstrapToken))
	out.File = (*v1alpha4.FileDiscovery)(unsafe.Pointer(in.File))
	out.TLSBootstrapToken = in.TLSBootstrapToken
	out.Timeout = (*v1.Duration)(unsafe.Pointer(in.Timeout))
	return nil
}

// Convert_v1beta1_Discovery_To_v1alpha4_Discovery is an autogenerated conversion function.
func Convert_v1beta1_Discovery_To_v1alpha4_Discovery(in *Discovery, out *v1alpha4.Discovery, s conversion.Scope) error {
	return autoConvert_v1beta1_Discovery_To_v1alpha4_Discovery(in, out, s)
}

func autoConvert_v1alpha4_Discovery_To_v1beta1_Discovery(in *v1alpha4.Discovery, out *Discovery, s conversion.Scope) error {
	out.BootstrapToken = (*BootstrapTokenDiscovery)(unsafe.Pointer(in.BootstrapToken))
	out.File = (*FileDiscovery)(unsafe.Pointer(in.File))
	out.TLSBootstrapToken = in.TLSBootstrapToken
	out.Timeout = (*v1.Duration)(unsafe.Pointer(in.Timeout))
	return nil
}

// Convert_v1alpha4_Discovery_To_v1beta1_Discovery is an autogenerated conversion function.
func Convert_v1alpha4_Discovery_To_v1beta1_Discovery(in *v1alpha4.Discovery, out *Discovery, s conversion.Scope) error {
	return autoConvert_v1alpha4_Discovery_To_v1beta1_Discovery(in, out, s)
}

func autoConvert_v1beta1_Etcd_To_v1alpha4_Etcd(in *Etcd, out *v1alpha4.Etcd, s conversion.Scope) error {
	out.Local = (*v1alpha4.LocalEtcd)(unsafe.Pointer(in.Local))
	out.External = (*v1alpha4.ExternalEtcd)(unsafe.Pointer(in.External))
	return nil
}

// Convert_v1beta1_Etcd_To_v1alpha4_Etcd is an autogenerated conversion function.
func Convert_v1beta1_Etcd_To_v1alpha4_Etcd(in *Etcd, out *v1alpha4.Etcd, s conversion.Scope) error {
	return autoConvert_v1beta1_Etcd_To_v1alpha4_Etcd(in, out, s)
}

func autoConvert_v1alpha4_Etcd_To_v1beta1_Etcd(in *v1alpha4.Etcd, out *Etcd, s conversion.Scope) error {
	out.Local = (*LocalEtcd)(unsafe.Pointer(in.Local))
	out.External = (*ExternalEtcd)(unsafe.Pointer(in.External))
	return nil
}

// Convert_v1alpha4_Etcd_To_v1beta1_Etcd is an autogenerated conversion function.
func Convert_v1alpha4_Etcd_To_v1beta1_Etcd(in *v1alpha4.Etcd, out *Etcd, s conversion.Scope) error {
	return autoConvert_v1alpha4_Etcd_To_v1beta1_Etcd(in, out, s)
}

func autoConvert_v1beta1_ExternalEtcd_To_v1alpha4_ExternalEtcd(in *ExternalEtcd, out *v1alpha4.ExternalEtcd, s conversion.Scope) error {
	out.Endpoints = *(*[]string)(unsafe.Pointer(&in.Endpoints))
	out.CAFile = in.CAFile
	out.CertFile = in.CertFile
	out.KeyFile = in.KeyFile
	return nil
}

// Convert_v1beta1_ExternalEtcd_To_v1alpha4_ExternalEtcd is an autogenerated conversion function.
func Convert_v1beta1_ExternalEtcd_To_v1alpha4_ExternalEtcd(in *ExternalEtcd, out *v1alpha4.ExternalEtcd, s conversion.Scope) error {
	return autoConvert_v1beta1_ExternalEtcd_To_v1alpha4_ExternalEtcd(in, out, s)
}

func autoConvert_v1alpha4_ExternalEtcd_To_v1beta1_ExternalEtcd(in *v1alpha4.ExternalEtcd, out *ExternalEtcd, s conversion.Scope) error {
	out.Endpoints = *(*[]string)(unsafe.Pointer(&in.Endpoints))
	out.CAFile = in.CAFile
	out.CertFile = in.CertFile
	out.KeyFile = in.KeyFile
	return nil
}

// Convert_v1alpha4_ExternalEtcd_To_v1beta1_ExternalEtcd is an autogenerated conversion function.
func Convert_v1alpha4_ExternalEtcd_To_v1beta1_ExternalEtcd(in *v1alpha4.ExternalEtcd, out *ExternalEtcd, s conversion.Scope) error {
	return autoConvert_v1alpha4_ExternalEtcd_To_v1beta1_ExternalEtcd(in, out, s)
}

func autoConvert_v1beta1_FileDiscovery_To_v1alpha4_FileDiscovery(in *FileDiscovery, out *v1alpha4.FileDiscovery, s conversion.Scope) error {
	out.KubeConfigPath = in.KubeConfigPath
	return nil
}

// Convert_v1beta1_FileDiscovery_To_v1alpha4_FileDiscovery is an autogenerated conversion function.
func Convert_v1beta1_FileDiscovery_To_v1alpha4_FileDiscovery(in *FileDiscovery, out *v1alpha4.FileDiscovery, s conversion.Scope) error {
	return autoConvert_v1beta1_FileDiscovery_To_v1alpha4_FileDiscovery(in, out, s)
}

func autoConvert_v1alpha4_FileDiscovery_To_v1beta1_FileDiscovery(in *v1alpha4.FileDiscovery, out *FileDiscovery, s conversion.Scope) error {
	out.KubeConfigPath = in.KubeConfigPath
	return nil
}

// Convert_v1alpha4_FileDiscovery_To_v1beta1_FileDiscovery is an autogenerated conversion function.
func Convert_v1alpha4_FileDiscovery_To_v1beta1_FileDiscovery(in *v1alpha4.FileDiscovery, out *FileDiscovery, s conversion.Scope) error {
	return autoConvert_v1alpha4_FileDiscovery_To_v1beta1_FileDiscovery(in, out, s)
}

func autoConvert_v1beta1_HostPathMount_To_v1alpha4_HostPathMount(in *HostPathMount, out *v1alpha4.HostPathMount, s conversion.Scope) error {
	out.Name = in.Name
	out.HostPath = in.HostPath
	out.MountPath = in.MountPath
	out.ReadOnly = in.ReadOnly
	out.PathType = corev1.HostPathType(in.PathType)
	return nil
}

// Convert_v1beta1_HostPathMount_To_v1alpha4_HostPathMount is an autogenerated conversion function.
func Convert_v1beta1_HostPathMount_To_v1alpha4_HostPathMount(in *HostPathMount, out *v1alpha4.HostPathMount, s conversion.Scope) error {
	return autoConvert_v1beta1_HostPathMount_To_v1alpha4_HostPathMount(in, out, s)
}

func autoConvert_v1alpha4_HostPathMount_To_v1beta1_HostPathMount(in *v1alpha4.HostPathMount, out *HostPathMount, s conversion.Scope) error {
	out.Name = in.Name
	out.HostPath = in.HostPath
	out.MountPath = in.MountPath
	out.ReadOnly = in.ReadOnly
	out.PathType = corev1.HostPathType(in.PathType)
	return nil
}

// Convert_v1alpha4_HostPathMount_To_v1beta1_HostPathMount is an autogenerated conversion function.
func Convert_v1alpha4_HostPathMount_To_v1beta1_HostPathMount(in *v1alpha4.HostPathMount, out *HostPathMount, s conversion.Scope) error {
	return autoConvert_v1alpha4_HostPathMount_To_v1beta1_HostPathMount(in, out, s)
}

func autoConvert_v1beta1_ImageMeta_To_v1alpha4_ImageMeta(in *ImageMeta, out *v1alpha4.ImageMeta, s conversion.Scope) error {
	out.ImageRepository = in.ImageRepository
	out.ImageTag = in.ImageTag
	return nil
}

// Convert_v1beta1_ImageMeta_To_v1alpha4_ImageMeta is an autogenerated conversion function.
func Convert_v1beta1_ImageMeta_To_v1alpha4_ImageMeta(in *ImageMeta, out *v1alpha4.ImageMeta, s conversion.Scope) error {
	return autoConvert_v1beta1_ImageMeta_To_v1alpha4_ImageMeta(in, out, s)
}

func autoConvert_v1alpha4_ImageMeta_To_v1beta1_ImageMeta(in *v1alpha4.ImageMeta, out *ImageMeta, s conversion.Scope) error {
	out.ImageRepository = in.ImageRepository
	out.ImageTag = in.ImageTag
	return nil
}

// Convert_v1alpha4_ImageMeta_To_v1beta1_ImageMeta is an autogenerated conversion function.
func Convert_v1alpha4_ImageMeta_To_v1beta1_ImageMeta(in *v1alpha4.ImageMeta, out *ImageMeta, s conversion.Scope) error {
	return autoConvert_v1alpha4_ImageMeta_To_v1beta1_ImageMeta(in, out, s)
}

func autoConvert_v1beta1_InitConfiguration_To_v1alpha4_InitConfiguration(in *InitConfiguration, out *v1alpha4.InitConfiguration, s conversion.Scope) error {
	out.BootstrapTokens = *(*[]v1alpha4.BootstrapToken)(unsafe.Pointer(&in.BootstrapTokens))
	if err := Convert_v1beta1_NodeRegistrationOptions_To_v1alpha4_NodeRegistrationOptions(&in.NodeRegistration, &out.NodeRegistration, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(&in.LocalAPIEndpoint, &out.LocalAPIEndpoint, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_InitConfiguration_To_v1alpha4_InitConfiguration is an autogenerated conversion function.
func Convert_v1beta1_InitConfiguration_To_v1alpha4_InitConfiguration(in *InitConfiguration, out *v1alpha4.InitConfiguration, s conversion.Scope) error {
	return autoConvert_v1beta1_InitConfiguration_To_v1alpha4_InitConfiguration(in, out, s)
}

func autoConvert_v1alpha4_InitConfiguration_To_v1beta1_InitConfiguration(in *v1alpha4.InitConfiguration, out *InitConfiguration, s conversion.Scope) error {
	out.BootstrapTokens = *(*[]BootstrapToken)(unsafe.Pointer(&in.BootstrapTokens))
	if err := Convert_v1alpha4_NodeRegistrationOptions_To_v1beta1_NodeRegistrationOptions(&in.NodeRegistration, &out.NodeRegistration, s); err != nil {
		return err
	}
	if err := Convert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(&in.LocalAPIEndpoint, &out.LocalAPIEndpoint, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_InitConfiguration_To_v1beta1_InitConfiguration is an autogenerated conversion function.
func Convert_v1alpha4_InitConfiguration_To_v1beta1_InitConfiguration(in *v1alpha4.InitConfiguration, out *InitConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha4_InitConfiguration_To_v1beta1_InitConfiguration(in, out, s)
}

func autoConvert_v1beta1_JoinConfiguration_To_v1alpha4_JoinConfiguration(in *JoinConfiguration, out *v1alpha4.JoinConfiguration, s conversion.Scope) error {
	if err := Convert_v1beta1_NodeRegistrationOptions_To_v1alpha4_NodeRegistrationOptions(&in.NodeRegistration, &out.NodeRegistration, s); err != nil {
		return err
	}
	out.CACertPath = in.CACertPath
	if err := Convert_v1beta1_Discovery_To_v1alpha4_Discovery(&in.Discovery, &out.Discovery, s); err != nil {
		return err
	}
	out.ControlPlane = (*v1alpha4.JoinControlPlane)(unsafe.Pointer(in.ControlPlane))
	return nil
}

// Convert_v1beta1_JoinConfiguration_To_v1alpha4_JoinConfiguration is an autogenerated conversion function.
func Convert_v1beta1_JoinConfiguration_To_v1alpha4_JoinConfiguration(in *JoinConfiguration, out *v1alpha4.JoinConfiguration, s conversion.Scope) error {
	return autoConvert_v1beta1_JoinConfiguration_To_v1alpha4_JoinConfiguration(in, out, s)
}

func autoConvert_v1alpha4_JoinConfiguration_To_v1beta1_JoinConfiguration(in *v1alpha4.JoinConfiguration, out *JoinConfiguration, s conversion.Scope) error {
	if err := Convert_v1alpha4_NodeRegistrationOptions_To_v1beta1_NodeRegistrationOptions(&in.NodeRegistration, &out.NodeRegistration, s); err != nil {
		return err
	}
	out.CACertPath = in.CACertPath
	if err := Convert_v1alpha4_Discovery_To_v1beta1_Discovery(&in.Discovery, &out.Discovery, s); err != nil {
		return err
	}
	out.ControlPlane = (*JoinControlPlane)(unsafe.Pointer(in.ControlPlane))
	return nil
}

// Convert_v1alpha4_JoinConfiguration_To_v1beta1_JoinConfiguration is an autogenerated conversion function.
func Convert_v1alpha4_JoinConfiguration_To_v1beta1_JoinConfiguration(in *v1alpha4.JoinConfiguration, out *JoinConfiguration, s conversion.Scope) error {
	return autoConvert_v1alpha4_JoinConfiguration_To_v1beta1_JoinConfiguration(in, out, s)
}

func autoConvert_v1beta1_JoinControlPlane_To_v1alpha4_JoinControlPlane(in *JoinControlPlane, out *v1alpha4.JoinControlPlane, s conversion.Scope) error {
	if err := Convert_v1beta1_APIEndpoint_To_v1alpha4_APIEndpoint(&in.LocalAPIEndpoint, &out.LocalAPIEndpoint, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_JoinControlPlane_To_v1alpha4_JoinControlPlane is an autogenerated conversion function.
func Convert_v1beta1_JoinControlPlane_To_v1alpha4_JoinControlPlane(in *JoinControlPlane, out *v1alpha4.JoinControlPlane, s conversion.Scope) error {
	return autoConvert_v1beta1_JoinControlPlane_To_v1alpha4_JoinControlPlane(in, out, s)
}

func autoConvert_v1alpha4_JoinControlPlane_To_v1beta1_JoinControlPlane(in *v1alpha4.JoinControlPlane, out *JoinControlPlane, s conversion.Scope) error {
	if err := Convert_v1alpha4_APIEndpoint_To_v1beta1_APIEndpoint(&in.LocalAPIEndpoint, &out.LocalAPIEndpoint, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha4_JoinControlPlane_To_v1beta1_JoinControlPlane is an autogenerated conversion function.
func Convert_v1alpha4_JoinControlPlane_To_v1beta1_JoinControlPlane(in *v1alpha4.JoinControlPlane, out *JoinControlPlane, s conversion.Scope) error {
	return autoConvert_v1alpha4_JoinControlPlane_To_v1beta1_JoinControlPlane(in, out, s)
}

func autoConvert_v1beta1_LocalEtcd_To_v1alpha4_LocalEtcd(in *LocalEtcd, out *v1alpha4.LocalEtcd, s conversion.Scope) error {
	if err := Convert_v1beta1_ImageMeta_To_v1alpha4_ImageMeta(&in.ImageMeta, &out.ImageMeta, s); err != nil {
		return err
	}
	out.DataDir = in.DataDir
	out.ExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.ExtraArgs))
	out.ServerCertSANs = *(*[]string)(unsafe.Pointer(&in.ServerCertSANs))
	out.PeerCertSANs = *(*[]string)(unsafe.Pointer(&in.PeerCertSANs))
	return nil
}

// Convert_v1beta1_LocalEtcd_To_v1alpha4_LocalEtcd is an autogenerated conversion function.
func Convert_v1beta1_LocalEtcd_To_v1alpha4_LocalEtcd(in *LocalEtcd, out *v1alpha4.LocalEtcd, s conversion.Scope) error {
	return autoConvert_v1beta1_LocalEtcd_To_v1alpha4_LocalEtcd(in, out, s)
}

func autoConvert_v1alpha4_LocalEtcd_To_v1beta1_LocalEtcd(in *v1alpha4.LocalEtcd, out *LocalEtcd, s conversion.Scope) error {
	if err := Convert_v1alpha4_ImageMeta_To_v1beta1_ImageMeta(&in.ImageMeta, &out.ImageMeta, s); err != nil {
		return err
	}
	out.DataDir = in.DataDir
	out.ExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.ExtraArgs))
	out.ServerCertSANs = *(*[]string)(unsafe.Pointer(&in.ServerCertSANs))
	out.PeerCertSANs = *(*[]string)(unsafe.Pointer(&in.PeerCertSANs))
	return nil
}

// Convert_v1alpha4_LocalEtcd_To_v1beta1_LocalEtcd is an autogenerated conversion function.
func Convert_v1alpha4_LocalEtcd_To_v1beta1_LocalEtcd(in *v1alpha4.LocalEtcd, out *LocalEtcd, s conversion.Scope) error {
	return autoConvert_v1alpha4_LocalEtcd_To_v1beta1_LocalEtcd(in, out, s)
}

func autoConvert_v1beta1_Networking_To_v1alpha4_Networking(in *Networking, out *v1alpha4.Networking, s conversion.Scope) error {
	out.ServiceSubnet = in.ServiceSubnet
	out.PodSubnet = in.PodSubnet
	out.DNSDomain = in.DNSDomain
	return nil
}

// Convert_v1beta1_Networking_To_v1alpha4_Networking is an autogenerated conversion function.
func Convert_v1beta1_Networking_To_v1alpha4_Networking(in *Networking, out *v1alpha4.Networking, s conversion.Scope) error {
	return autoConvert_v1beta1_Networking_To_v1alpha4_Networking(in, out, s)
}

func autoConvert_v1alpha4_Networking_To_v1beta1_Networking(in *v1alpha4.Networking, out *Networking, s conversion.Scope) error {
	out.ServiceSubnet = in.ServiceSubnet
	out.PodSubnet = in.PodSubnet
	out.DNSDomain = in.DNSDomain
	return nil
}

// Convert_v1alpha4_Networking_To_v1beta1_Networking is an autogenerated conversion function.
func Convert_v1alpha4_Networking_To_v1beta1_Networking(in *v1alpha4.Networking, out *Networking, s conversion.Scope) error {
	return autoConvert_v1alpha4_Networking_To_v1beta1_Networking(in, out, s)
}

func autoConvert_v1beta1_NodeRegistrationOptions_To_v1alpha4_NodeRegistrationOptions(in *NodeRegistrationOptions, out *v1alpha4.NodeRegistrationOptions, s conversion.Scope) error {
	out.Name = in.Name
	out.CRISocket = in.CRISocket
	out.Taints = *(*[]corev1.Taint)(unsafe.Pointer(&in.Taints))
	out.KubeletExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.KubeletExtraArgs))
	return nil
}

// Convert_v1beta1_NodeRegistrationOptions_To_v1alpha4_NodeRegistrationOptions is an autogenerated conversion function.
func Convert_v1beta1_NodeRegistrationOptions_To_v1alpha4_NodeRegistrationOptions(in *NodeRegistrationOptions, out *v1alpha4.NodeRegistrationOptions, s conversion.Scope) error {
	return autoConvert_v1beta1_NodeRegistrationOptions_To_v1alpha4_NodeRegistrationOptions(in, out, s)
}

func autoConvert_v1alpha4_NodeRegistrationOptions_To_v1beta1_NodeRegistrationOptions(in *v1alpha4.NodeRegistrationOptions, out *NodeRegistrationOptions, s conversion.Scope) error {
	out.Name = in.Name
	out.CRISocket = in.CRISocket
	out.Taints = *(*[]corev1.Taint)(unsafe.Pointer(&in.Taints))
	out.KubeletExtraArgs = *(*map[string]string)(unsafe.Pointer(&in.KubeletExtraArgs))
	// WARNING: in.IgnorePreflightErrors requires manual conversion: does not exist in peer-type
	return nil
}
