/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package v1alpha3

import (
	apiconversion "k8s.io/apimachinery/pkg/conversion"
	"sigs.k8s.io/cluster-api/test/infrastructure/docker/api/v1alpha4"
	utilconversion "sigs.k8s.io/cluster-api/util/conversion"
	"sigs.k8s.io/controller-runtime/pkg/conversion"
)

func (src *DockerCluster) ConvertTo(dstRaw conversion.Hub) error {
	dst := dstRaw.(*v1alpha4.DockerCluster)

	if err := Convert_v1alpha3_DockerCluster_To_v1alpha4_DockerCluster(src, dst, nil); err != nil {
		return err
	}

	// Manually restore data.
	restored := &v1alpha4.DockerCluster{}
	if ok, err := utilconversion.UnmarshalData(src, restored); err != nil || !ok {
		return err
	}

	if restored.Spec.LoadBalancer.ImageRepository != "" {
		dst.Spec.LoadBalancer.ImageRepository = restored.Spec.LoadBalancer.ImageRepository
	}

	if restored.Spec.LoadBalancer.ImageTag != "" {
		dst.Spec.LoadBalancer.ImageTag = restored.Spec.LoadBalancer.ImageTag
	}

	return nil
}

func (dst *DockerCluster) ConvertFrom(srcRaw conversion.Hub) error {
	src := srcRaw.(*v1alpha4.DockerCluster)

	if err := Convert_v1alpha4_DockerCluster_To_v1alpha3_DockerCluster(src, dst, nil); err != nil {
		return err
	}

	// Preserve Hub data on down-conversion except for metadata
	if err := utilconversion.MarshalData(src, dst); err != nil {
		return err
	}

	return nil
}

// Convert_v1alpha4_DockerClusterSpec_To_v1alpha3_DockerClusterSpec is an autogenerated conversion function.
func Convert_v1alpha4_DockerClusterSpec_To_v1alpha3_DockerClusterSpec(in *v1alpha4.DockerClusterSpec, out *DockerClusterSpec, s apiconversion.Scope) error {
	// DockerClusterSpec.LoadBalancer was added in v1alpha4, so automatic conversion is not possible
	return autoConvert_v1alpha4_DockerClusterSpec_To_v1alpha3_DockerClusterSpec(in, out, s)
}
