// Code generated by "go generate gonum.org/v1/gonum/unit”; DO NOT EDIT.

// Copyright ©2014 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package unit

import (
	"errors"
	"fmt"
	"math"
	"unicode/utf8"
)

// Inductance represents an electrical inductance in Henry.
type Inductance float64

const (
	Yottahenry Inductance = 1e24
	Zettahenry Inductance = 1e21
	Exahenry   Inductance = 1e18
	Petahenry  Inductance = 1e15
	Terahenry  Inductance = 1e12
	Gigahenry  Inductance = 1e9
	Megahenry  Inductance = 1e6
	Kilohenry  Inductance = 1e3
	Hectohenry Inductance = 1e2
	Decahenry  Inductance = 1e1
	Henry      Inductance = 1.0
	Decihenry  Inductance = 1e-1
	Centihenry Inductance = 1e-2
	Millihenry Inductance = 1e-3
	Microhenry Inductance = 1e-6
	Nanohenry  Inductance = 1e-9
	Picohenry  Inductance = 1e-12
	Femtohenry Inductance = 1e-15
	Attohenry  Inductance = 1e-18
	Zeptohenry Inductance = 1e-21
	Yoctohenry Inductance = 1e-24
)

// Unit converts the Inductance to a *Unit
func (i Inductance) Unit() *Unit {
	return New(float64(i), Dimensions{
		CurrentDim: -2,
		LengthDim:  2,
		MassDim:    1,
		TimeDim:    -2,
	})
}

// Inductance allows Inductance to implement a Inductancer interface
func (i Inductance) Inductance() Inductance {
	return i
}

// From converts the unit into the receiver. From returns an
// error if there is a mismatch in dimension
func (i *Inductance) From(u Uniter) error {
	if !DimensionsMatch(u, Henry) {
		*i = Inductance(math.NaN())
		return errors.New("Dimension mismatch")
	}
	*i = Inductance(u.Unit().Value())
	return nil
}

func (i Inductance) Format(fs fmt.State, c rune) {
	switch c {
	case 'v':
		if fs.Flag('#') {
			fmt.Fprintf(fs, "%T(%v)", i, float64(i))
			return
		}
		fallthrough
	case 'e', 'E', 'f', 'F', 'g', 'G':
		p, pOk := fs.Precision()
		w, wOk := fs.Width()
		const unit = " H"
		switch {
		case pOk && wOk:
			fmt.Fprintf(fs, "%*.*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), p, float64(i))
		case pOk:
			fmt.Fprintf(fs, "%.*"+string(c), p, float64(i))
		case wOk:
			fmt.Fprintf(fs, "%*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), float64(i))
		default:
			fmt.Fprintf(fs, "%"+string(c), float64(i))
		}
		fmt.Fprint(fs, unit)
	default:
		fmt.Fprintf(fs, "%%!%c(%T=%g H)", c, i, float64(i))
	}
}
