// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeDocumentClassificationJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDocumentClassificationJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentClassificationJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDocumentClassificationJobInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeDocumentClassificationJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the properties associated with the document classification
	// job.
	DocumentClassificationJobProperties *DocumentClassificationJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeDocumentClassificationJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDocumentClassificationJob = "DescribeDocumentClassificationJob"

// DescribeDocumentClassificationJobRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Gets the properties associated with a document classification job. Use this
// operation to get the status of a classification job.
//
//    // Example sending a request using DescribeDocumentClassificationJobRequest.
//    req := client.DescribeDocumentClassificationJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob
func (c *Client) DescribeDocumentClassificationJobRequest(input *DescribeDocumentClassificationJobInput) DescribeDocumentClassificationJobRequest {
	op := &aws.Operation{
		Name:       opDescribeDocumentClassificationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentClassificationJobInput{}
	}

	req := c.newRequest(op, input, &DescribeDocumentClassificationJobOutput{})
	return DescribeDocumentClassificationJobRequest{Request: req, Input: input, Copy: c.DescribeDocumentClassificationJobRequest}
}

// DescribeDocumentClassificationJobRequest is the request type for the
// DescribeDocumentClassificationJob API operation.
type DescribeDocumentClassificationJobRequest struct {
	*aws.Request
	Input *DescribeDocumentClassificationJobInput
	Copy  func(*DescribeDocumentClassificationJobInput) DescribeDocumentClassificationJobRequest
}

// Send marshals and sends the DescribeDocumentClassificationJob API request.
func (r DescribeDocumentClassificationJobRequest) Send(ctx context.Context) (*DescribeDocumentClassificationJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDocumentClassificationJobResponse{
		DescribeDocumentClassificationJobOutput: r.Request.Data.(*DescribeDocumentClassificationJobOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDocumentClassificationJobResponse is the response type for the
// DescribeDocumentClassificationJob API operation.
type DescribeDocumentClassificationJobResponse struct {
	*DescribeDocumentClassificationJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDocumentClassificationJob request.
func (r *DescribeDocumentClassificationJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
