// DO NOT EDIT: This file is autogenerated via the builtin command.

package anomalydetection

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   31,
				},
				File:   "mad.flux",
				Source: "package anomalydetection \n\nimport \"math\"\nimport \"experimental\"\n\nmad = (table=<-, threshold=3.0) => {\n    // MEDiXi = med(x)\n    data = table |> group(columns: [\"_time\"], mode:\"by\")\n    med = data |> median(column: \"_value\")\n    // diff = |Xi - MEDiXi| = math.abs(xi-med(xi))\n    diff = join(tables: {data: data, med: med}, on: [\"_time\"], method: \"inner\")\n    |> map(fn: (r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) }))\n    |> drop(columns: [\"_start\", \"_stop\", \"_value_med\", \"_value_data\"])\n    // The constant k is needed to make the estimator consistent for the parameter of interest.\n    // In the case of the usual parameter at Gaussian distributions k = 1.4826\n    k = 1.4826\n    // MAD =  k * MEDi * |Xi - MEDiXi| \n    diff_med =\n    diff\n        |> median(column: \"_value\")\n        |> map(fn: (r) => ({ r with MAD: k * r._value}))\n        |> filter(fn: (r) => r.MAD > 0.0)\n    output = join(tables: {diff: diff, diff_med: diff_med}, on: [\"_time\"], method: \"inner\")\n        |> map(fn: (r) => ({ r with _value: r._value_diff/r._value_diff_med}))\n    |> map(fn: (r) => ({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        }))\nreturn output\n}",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "mad.flux",
					Source: "mad = (table=<-, threshold=3.0) => {\n    // MEDiXi = med(x)\n    data = table |> group(columns: [\"_time\"], mode:\"by\")\n    med = data |> median(column: \"_value\")\n    // diff = |Xi - MEDiXi| = math.abs(xi-med(xi))\n    diff = join(tables: {data: data, med: med}, on: [\"_time\"], method: \"inner\")\n    |> map(fn: (r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) }))\n    |> drop(columns: [\"_start\", \"_stop\", \"_value_med\", \"_value_data\"])\n    // The constant k is needed to make the estimator consistent for the parameter of interest.\n    // In the case of the usual parameter at Gaussian distributions k = 1.4826\n    k = 1.4826\n    // MAD =  k * MEDi * |Xi - MEDiXi| \n    diff_med =\n    diff\n        |> median(column: \"_value\")\n        |> map(fn: (r) => ({ r with MAD: k * r._value}))\n        |> filter(fn: (r) => r.MAD > 0.0)\n    output = join(tables: {diff: diff, diff_med: diff_med}, on: [\"_time\"], method: \"inner\")\n        |> map(fn: (r) => ({ r with _value: r._value_diff/r._value_diff_med}))\n    |> map(fn: (r) => ({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        }))\nreturn output\n}",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   6,
						},
						File:   "mad.flux",
						Source: "mad",
						Start: ast.Position{
							Column: 1,
							Line:   6,
						},
					},
				},
				Name: "mad",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "mad.flux",
						Source: "(table=<-, threshold=3.0) => {\n    // MEDiXi = med(x)\n    data = table |> group(columns: [\"_time\"], mode:\"by\")\n    med = data |> median(column: \"_value\")\n    // diff = |Xi - MEDiXi| = math.abs(xi-med(xi))\n    diff = join(tables: {data: data, med: med}, on: [\"_time\"], method: \"inner\")\n    |> map(fn: (r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) }))\n    |> drop(columns: [\"_start\", \"_stop\", \"_value_med\", \"_value_data\"])\n    // The constant k is needed to make the estimator consistent for the parameter of interest.\n    // In the case of the usual parameter at Gaussian distributions k = 1.4826\n    k = 1.4826\n    // MAD =  k * MEDi * |Xi - MEDiXi| \n    diff_med =\n    diff\n        |> median(column: \"_value\")\n        |> map(fn: (r) => ({ r with MAD: k * r._value}))\n        |> filter(fn: (r) => r.MAD > 0.0)\n    output = join(tables: {diff: diff, diff_med: diff_med}, on: [\"_time\"], method: \"inner\")\n        |> map(fn: (r) => ({ r with _value: r._value_diff/r._value_diff_med}))\n    |> map(fn: (r) => ({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        }))\nreturn output\n}",
						Start: ast.Position{
							Column: 7,
							Line:   6,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   31,
							},
							File:   "mad.flux",
							Source: "{\n    // MEDiXi = med(x)\n    data = table |> group(columns: [\"_time\"], mode:\"by\")\n    med = data |> median(column: \"_value\")\n    // diff = |Xi - MEDiXi| = math.abs(xi-med(xi))\n    diff = join(tables: {data: data, med: med}, on: [\"_time\"], method: \"inner\")\n    |> map(fn: (r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) }))\n    |> drop(columns: [\"_start\", \"_stop\", \"_value_med\", \"_value_data\"])\n    // The constant k is needed to make the estimator consistent for the parameter of interest.\n    // In the case of the usual parameter at Gaussian distributions k = 1.4826\n    k = 1.4826\n    // MAD =  k * MEDi * |Xi - MEDiXi| \n    diff_med =\n    diff\n        |> median(column: \"_value\")\n        |> map(fn: (r) => ({ r with MAD: k * r._value}))\n        |> filter(fn: (r) => r.MAD > 0.0)\n    output = join(tables: {diff: diff, diff_med: diff_med}, on: [\"_time\"], method: \"inner\")\n        |> map(fn: (r) => ({ r with _value: r._value_diff/r._value_diff_med}))\n    |> map(fn: (r) => ({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        }))\nreturn output\n}",
							Start: ast.Position{
								Column: 36,
								Line:   6,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   8,
								},
								File:   "mad.flux",
								Source: "data = table |> group(columns: [\"_time\"], mode:\"by\")",
								Start: ast.Position{
									Column: 5,
									Line:   8,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// MEDiXi = med(x)\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   8,
									},
									File:   "mad.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   8,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   8,
										},
										File:   "mad.flux",
										Source: "table",
										Start: ast.Position{
											Column: 12,
											Line:   8,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   8,
									},
									File:   "mad.flux",
									Source: "table |> group(columns: [\"_time\"], mode:\"by\")",
									Start: ast.Position{
										Column: 12,
										Line:   8,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   8,
											},
											File:   "mad.flux",
											Source: "columns: [\"_time\"], mode:\"by\"",
											Start: ast.Position{
												Column: 27,
												Line:   8,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   8,
												},
												File:   "mad.flux",
												Source: "columns: [\"_time\"]",
												Start: ast.Position{
													Column: 27,
													Line:   8,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   8,
													},
													File:   "mad.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 27,
														Line:   8,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   8,
													},
													File:   "mad.flux",
													Source: "[\"_time\"]",
													Start: ast.Position{
														Column: 36,
														Line:   8,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   8,
														},
														File:   "mad.flux",
														Source: "\"_time\"",
														Start: ast.Position{
															Column: 37,
															Line:   8,
														},
													},
												},
												Value: "_time",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   8,
												},
												File:   "mad.flux",
												Source: "mode:\"by\"",
												Start: ast.Position{
													Column: 47,
													Line:   8,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   8,
													},
													File:   "mad.flux",
													Source: "mode",
													Start: ast.Position{
														Column: 47,
														Line:   8,
													},
												},
											},
											Name: "mode",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   8,
													},
													File:   "mad.flux",
													Source: "\"by\"",
													Start: ast.Position{
														Column: 52,
														Line:   8,
													},
												},
											},
											Value: "by",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   8,
										},
										File:   "mad.flux",
										Source: "group(columns: [\"_time\"], mode:\"by\")",
										Start: ast.Position{
											Column: 21,
											Line:   8,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   8,
											},
											File:   "mad.flux",
											Source: "group",
											Start: ast.Position{
												Column: 21,
												Line:   8,
											},
										},
									},
									Name: "group",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   9,
								},
								File:   "mad.flux",
								Source: "med = data |> median(column: \"_value\")",
								Start: ast.Position{
									Column: 5,
									Line:   9,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   9,
									},
									File:   "mad.flux",
									Source: "med",
									Start: ast.Position{
										Column: 5,
										Line:   9,
									},
								},
							},
							Name: "med",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   9,
										},
										File:   "mad.flux",
										Source: "data",
										Start: ast.Position{
											Column: 11,
											Line:   9,
										},
									},
								},
								Name: "data",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   9,
									},
									File:   "mad.flux",
									Source: "data |> median(column: \"_value\")",
									Start: ast.Position{
										Column: 11,
										Line:   9,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   9,
											},
											File:   "mad.flux",
											Source: "column: \"_value\"",
											Start: ast.Position{
												Column: 26,
												Line:   9,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   9,
												},
												File:   "mad.flux",
												Source: "column: \"_value\"",
												Start: ast.Position{
													Column: 26,
													Line:   9,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   9,
													},
													File:   "mad.flux",
													Source: "column",
													Start: ast.Position{
														Column: 26,
														Line:   9,
													},
												},
											},
											Name: "column",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   9,
													},
													File:   "mad.flux",
													Source: "\"_value\"",
													Start: ast.Position{
														Column: 34,
														Line:   9,
													},
												},
											},
											Value: "_value",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   9,
										},
										File:   "mad.flux",
										Source: "median(column: \"_value\")",
										Start: ast.Position{
											Column: 19,
											Line:   9,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   9,
											},
											File:   "mad.flux",
											Source: "median",
											Start: ast.Position{
												Column: 19,
												Line:   9,
											},
										},
									},
									Name: "median",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   13,
								},
								File:   "mad.flux",
								Source: "diff = join(tables: {data: data, med: med}, on: [\"_time\"], method: \"inner\")\n    |> map(fn: (r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) }))\n    |> drop(columns: [\"_start\", \"_stop\", \"_value_med\", \"_value_data\"])",
								Start: ast.Position{
									Column: 5,
									Line:   11,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// diff = |Xi - MEDiXi| = math.abs(xi-med(xi))\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   11,
									},
									File:   "mad.flux",
									Source: "diff",
									Start: ast.Position{
										Column: 5,
										Line:   11,
									},
								},
							},
							Name: "diff",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   11,
												},
												File:   "mad.flux",
												Source: "tables: {data: data, med: med}, on: [\"_time\"], method: \"inner\"",
												Start: ast.Position{
													Column: 17,
													Line:   11,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   11,
													},
													File:   "mad.flux",
													Source: "tables: {data: data, med: med}",
													Start: ast.Position{
														Column: 17,
														Line:   11,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   11,
														},
														File:   "mad.flux",
														Source: "tables",
														Start: ast.Position{
															Column: 17,
															Line:   11,
														},
													},
												},
												Name: "tables",
											},
											Separator: nil,
											Value: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 47,
															Line:   11,
														},
														File:   "mad.flux",
														Source: "{data: data, med: med}",
														Start: ast.Position{
															Column: 25,
															Line:   11,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   11,
															},
															File:   "mad.flux",
															Source: "data: data",
															Start: ast.Position{
																Column: 26,
																Line:   11,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   11,
																},
																File:   "mad.flux",
																Source: "data",
																Start: ast.Position{
																	Column: 26,
																	Line:   11,
																},
															},
														},
														Name: "data",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   11,
																},
																File:   "mad.flux",
																Source: "data",
																Start: ast.Position{
																	Column: 32,
																	Line:   11,
																},
															},
														},
														Name: "data",
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   11,
															},
															File:   "mad.flux",
															Source: "med: med",
															Start: ast.Position{
																Column: 38,
																Line:   11,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 41,
																	Line:   11,
																},
																File:   "mad.flux",
																Source: "med",
																Start: ast.Position{
																	Column: 38,
																	Line:   11,
																},
															},
														},
														Name: "med",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   11,
																},
																File:   "mad.flux",
																Source: "med",
																Start: ast.Position{
																	Column: 43,
																	Line:   11,
																},
															},
														},
														Name: "med",
													},
												}},
												Rbrace: nil,
												With:   nil,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   11,
													},
													File:   "mad.flux",
													Source: "on: [\"_time\"]",
													Start: ast.Position{
														Column: 49,
														Line:   11,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 51,
															Line:   11,
														},
														File:   "mad.flux",
														Source: "on",
														Start: ast.Position{
															Column: 49,
															Line:   11,
														},
													},
												},
												Name: "on",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   11,
														},
														File:   "mad.flux",
														Source: "[\"_time\"]",
														Start: ast.Position{
															Column: 53,
															Line:   11,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   11,
															},
															File:   "mad.flux",
															Source: "\"_time\"",
															Start: ast.Position{
																Column: 54,
																Line:   11,
															},
														},
													},
													Value: "_time",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   11,
													},
													File:   "mad.flux",
													Source: "method: \"inner\"",
													Start: ast.Position{
														Column: 64,
														Line:   11,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   11,
														},
														File:   "mad.flux",
														Source: "method",
														Start: ast.Position{
															Column: 64,
															Line:   11,
														},
													},
												},
												Name: "method",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   11,
														},
														File:   "mad.flux",
														Source: "\"inner\"",
														Start: ast.Position{
															Column: 72,
															Line:   11,
														},
													},
												},
												Value: "inner",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   11,
											},
											File:   "mad.flux",
											Source: "join(tables: {data: data, med: med}, on: [\"_time\"], method: \"inner\")",
											Start: ast.Position{
												Column: 12,
												Line:   11,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   11,
												},
												File:   "mad.flux",
												Source: "join",
												Start: ast.Position{
													Column: 12,
													Line:   11,
												},
											},
										},
										Name: "join",
									},
									Lparen: nil,
									Rparen: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   12,
										},
										File:   "mad.flux",
										Source: "join(tables: {data: data, med: med}, on: [\"_time\"], method: \"inner\")\n    |> map(fn: (r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) }))",
										Start: ast.Position{
											Column: 12,
											Line:   11,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 85,
													Line:   12,
												},
												File:   "mad.flux",
												Source: "fn: (r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) })",
												Start: ast.Position{
													Column: 12,
													Line:   12,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   12,
													},
													File:   "mad.flux",
													Source: "fn: (r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) })",
													Start: ast.Position{
														Column: 12,
														Line:   12,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   12,
														},
														File:   "mad.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 12,
															Line:   12,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 85,
															Line:   12,
														},
														File:   "mad.flux",
														Source: "(r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) })",
														Start: ast.Position{
															Column: 16,
															Line:   12,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 85,
																Line:   12,
															},
															File:   "mad.flux",
															Source: "({ r with _value: math.abs(x: r._value_data - r._value_med) })",
															Start: ast.Position{
																Column: 23,
																Line:   12,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 84,
																	Line:   12,
																},
																File:   "mad.flux",
																Source: "{ r with _value: math.abs(x: r._value_data - r._value_med) }",
																Start: ast.Position{
																	Column: 24,
																	Line:   12,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 82,
																		Line:   12,
																	},
																	File:   "mad.flux",
																	Source: "_value: math.abs(x: r._value_data - r._value_med)",
																	Start: ast.Position{
																		Column: 33,
																		Line:   12,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 39,
																			Line:   12,
																		},
																		File:   "mad.flux",
																		Source: "_value",
																		Start: ast.Position{
																			Column: 33,
																			Line:   12,
																		},
																	},
																},
																Name: "_value",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 81,
																				Line:   12,
																			},
																			File:   "mad.flux",
																			Source: "x: r._value_data - r._value_med",
																			Start: ast.Position{
																				Column: 50,
																				Line:   12,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 81,
																					Line:   12,
																				},
																				File:   "mad.flux",
																				Source: "x: r._value_data - r._value_med",
																				Start: ast.Position{
																					Column: 50,
																					Line:   12,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 51,
																						Line:   12,
																					},
																					File:   "mad.flux",
																					Source: "x",
																					Start: ast.Position{
																						Column: 50,
																						Line:   12,
																					},
																				},
																			},
																			Name: "x",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 81,
																						Line:   12,
																					},
																					File:   "mad.flux",
																					Source: "r._value_data - r._value_med",
																					Start: ast.Position{
																						Column: 53,
																						Line:   12,
																					},
																				},
																			},
																			Left: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 66,
																							Line:   12,
																						},
																						File:   "mad.flux",
																						Source: "r._value_data",
																						Start: ast.Position{
																							Column: 53,
																							Line:   12,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 54,
																								Line:   12,
																							},
																							File:   "mad.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 53,
																								Line:   12,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 66,
																								Line:   12,
																							},
																							File:   "mad.flux",
																							Source: "_value_data",
																							Start: ast.Position{
																								Column: 55,
																								Line:   12,
																							},
																						},
																					},
																					Name: "_value_data",
																				},
																				Rbrack: nil,
																			},
																			Operator: 6,
																			Right: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 81,
																							Line:   12,
																						},
																						File:   "mad.flux",
																						Source: "r._value_med",
																						Start: ast.Position{
																							Column: 69,
																							Line:   12,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 70,
																								Line:   12,
																							},
																							File:   "mad.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 69,
																								Line:   12,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 81,
																								Line:   12,
																							},
																							File:   "mad.flux",
																							Source: "_value_med",
																							Start: ast.Position{
																								Column: 71,
																								Line:   12,
																							},
																						},
																					},
																					Name: "_value_med",
																				},
																				Rbrack: nil,
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 82,
																			Line:   12,
																		},
																		File:   "mad.flux",
																		Source: "math.abs(x: r._value_data - r._value_med)",
																		Start: ast.Position{
																			Column: 41,
																			Line:   12,
																		},
																	},
																},
																Callee: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   12,
																			},
																			File:   "mad.flux",
																			Source: "math.abs",
																			Start: ast.Position{
																				Column: 41,
																				Line:   12,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 45,
																					Line:   12,
																				},
																				File:   "mad.flux",
																				Source: "math",
																				Start: ast.Position{
																					Column: 41,
																					Line:   12,
																				},
																			},
																		},
																		Name: "math",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   12,
																				},
																				File:   "mad.flux",
																				Source: "abs",
																				Start: ast.Position{
																					Column: 46,
																					Line:   12,
																				},
																			},
																		},
																		Name: "abs",
																	},
																	Rbrack: nil,
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 27,
																		Line:   12,
																	},
																	File:   "mad.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 26,
																		Line:   12,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   12,
															},
															File:   "mad.flux",
															Source: "r",
															Start: ast.Position{
																Column: 17,
																Line:   12,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   12,
																},
																File:   "mad.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 17,
																	Line:   12,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   12,
											},
											File:   "mad.flux",
											Source: "map(fn: (r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) }))",
											Start: ast.Position{
												Column: 8,
												Line:   12,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   12,
												},
												File:   "mad.flux",
												Source: "map",
												Start: ast.Position{
													Column: 8,
													Line:   12,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   13,
									},
									File:   "mad.flux",
									Source: "join(tables: {data: data, med: med}, on: [\"_time\"], method: \"inner\")\n    |> map(fn: (r) => ({ r with _value: math.abs(x: r._value_data - r._value_med) }))\n    |> drop(columns: [\"_start\", \"_stop\", \"_value_med\", \"_value_data\"])",
									Start: ast.Position{
										Column: 12,
										Line:   11,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   13,
											},
											File:   "mad.flux",
											Source: "columns: [\"_start\", \"_stop\", \"_value_med\", \"_value_data\"]",
											Start: ast.Position{
												Column: 13,
												Line:   13,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   13,
												},
												File:   "mad.flux",
												Source: "columns: [\"_start\", \"_stop\", \"_value_med\", \"_value_data\"]",
												Start: ast.Position{
													Column: 13,
													Line:   13,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   13,
													},
													File:   "mad.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 13,
														Line:   13,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   13,
													},
													File:   "mad.flux",
													Source: "[\"_start\", \"_stop\", \"_value_med\", \"_value_data\"]",
													Start: ast.Position{
														Column: 22,
														Line:   13,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   13,
														},
														File:   "mad.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 23,
															Line:   13,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   13,
														},
														File:   "mad.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 33,
															Line:   13,
														},
													},
												},
												Value: "_stop",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   13,
														},
														File:   "mad.flux",
														Source: "\"_value_med\"",
														Start: ast.Position{
															Column: 42,
															Line:   13,
														},
													},
												},
												Value: "_value_med",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   13,
														},
														File:   "mad.flux",
														Source: "\"_value_data\"",
														Start: ast.Position{
															Column: 56,
															Line:   13,
														},
													},
												},
												Value: "_value_data",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   13,
										},
										File:   "mad.flux",
										Source: "drop(columns: [\"_start\", \"_stop\", \"_value_med\", \"_value_data\"])",
										Start: ast.Position{
											Column: 8,
											Line:   13,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   13,
											},
											File:   "mad.flux",
											Source: "drop",
											Start: ast.Position{
												Column: 8,
												Line:   13,
											},
										},
									},
									Name: "drop",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   16,
								},
								File:   "mad.flux",
								Source: "k = 1.4826",
								Start: ast.Position{
									Column: 5,
									Line:   16,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// The constant k is needed to make the estimator consistent for the parameter of interest.\n"}, ast.Comment{Text: "// In the case of the usual parameter at Gaussian distributions k = 1.4826\n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   16,
									},
									File:   "mad.flux",
									Source: "k",
									Start: ast.Position{
										Column: 5,
										Line:   16,
									},
								},
							},
							Name: "k",
						},
						Init: &ast.FloatLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   16,
									},
									File:   "mad.flux",
									Source: "1.4826",
									Start: ast.Position{
										Column: 9,
										Line:   16,
									},
								},
							},
							Value: 1.4826,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   22,
								},
								File:   "mad.flux",
								Source: "diff_med =\n    diff\n        |> median(column: \"_value\")\n        |> map(fn: (r) => ({ r with MAD: k * r._value}))\n        |> filter(fn: (r) => r.MAD > 0.0)",
								Start: ast.Position{
									Column: 5,
									Line:   18,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: []ast.Comment{ast.Comment{Text: "// MAD =  k * MEDi * |Xi - MEDiXi| \n"}},
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   18,
									},
									File:   "mad.flux",
									Source: "diff_med",
									Start: ast.Position{
										Column: 5,
										Line:   18,
									},
								},
							},
							Name: "diff_med",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 9,
													Line:   19,
												},
												File:   "mad.flux",
												Source: "diff",
												Start: ast.Position{
													Column: 5,
													Line:   19,
												},
											},
										},
										Name: "diff",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   20,
											},
											File:   "mad.flux",
											Source: "diff\n        |> median(column: \"_value\")",
											Start: ast.Position{
												Column: 5,
												Line:   19,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   20,
													},
													File:   "mad.flux",
													Source: "column: \"_value\"",
													Start: ast.Position{
														Column: 19,
														Line:   20,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   20,
														},
														File:   "mad.flux",
														Source: "column: \"_value\"",
														Start: ast.Position{
															Column: 19,
															Line:   20,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   20,
															},
															File:   "mad.flux",
															Source: "column",
															Start: ast.Position{
																Column: 19,
																Line:   20,
															},
														},
													},
													Name: "column",
												},
												Separator: nil,
												Value: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   20,
															},
															File:   "mad.flux",
															Source: "\"_value\"",
															Start: ast.Position{
																Column: 27,
																Line:   20,
															},
														},
													},
													Value: "_value",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   20,
												},
												File:   "mad.flux",
												Source: "median(column: \"_value\")",
												Start: ast.Position{
													Column: 12,
													Line:   20,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   20,
													},
													File:   "mad.flux",
													Source: "median",
													Start: ast.Position{
														Column: 12,
														Line:   20,
													},
												},
											},
											Name: "median",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   21,
										},
										File:   "mad.flux",
										Source: "diff\n        |> median(column: \"_value\")\n        |> map(fn: (r) => ({ r with MAD: k * r._value}))",
										Start: ast.Position{
											Column: 5,
											Line:   19,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   21,
												},
												File:   "mad.flux",
												Source: "fn: (r) => ({ r with MAD: k * r._value})",
												Start: ast.Position{
													Column: 16,
													Line:   21,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   21,
													},
													File:   "mad.flux",
													Source: "fn: (r) => ({ r with MAD: k * r._value})",
													Start: ast.Position{
														Column: 16,
														Line:   21,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   21,
														},
														File:   "mad.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 16,
															Line:   21,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   21,
														},
														File:   "mad.flux",
														Source: "(r) => ({ r with MAD: k * r._value})",
														Start: ast.Position{
															Column: 20,
															Line:   21,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   21,
															},
															File:   "mad.flux",
															Source: "({ r with MAD: k * r._value})",
															Start: ast.Position{
																Column: 27,
																Line:   21,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   21,
																},
																File:   "mad.flux",
																Source: "{ r with MAD: k * r._value}",
																Start: ast.Position{
																	Column: 28,
																	Line:   21,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   21,
																	},
																	File:   "mad.flux",
																	Source: "MAD: k * r._value",
																	Start: ast.Position{
																		Column: 37,
																		Line:   21,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   21,
																		},
																		File:   "mad.flux",
																		Source: "MAD",
																		Start: ast.Position{
																			Column: 37,
																			Line:   21,
																		},
																	},
																},
																Name: "MAD",
															},
															Separator: nil,
															Value: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   21,
																		},
																		File:   "mad.flux",
																		Source: "k * r._value",
																		Start: ast.Position{
																			Column: 42,
																			Line:   21,
																		},
																	},
																},
																Left: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 43,
																				Line:   21,
																			},
																			File:   "mad.flux",
																			Source: "k",
																			Start: ast.Position{
																				Column: 42,
																				Line:   21,
																			},
																		},
																	},
																	Name: "k",
																},
																Operator: 1,
																Right: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 54,
																				Line:   21,
																			},
																			File:   "mad.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 46,
																				Line:   21,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 47,
																					Line:   21,
																				},
																				File:   "mad.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 46,
																					Line:   21,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   21,
																				},
																				File:   "mad.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 48,
																					Line:   21,
																				},
																			},
																		},
																		Name: "_value",
																	},
																	Rbrack: nil,
																},
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   21,
																	},
																	File:   "mad.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 30,
																		Line:   21,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   21,
															},
															File:   "mad.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   21,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   21,
																},
																File:   "mad.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   21,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   21,
											},
											File:   "mad.flux",
											Source: "map(fn: (r) => ({ r with MAD: k * r._value}))",
											Start: ast.Position{
												Column: 12,
												Line:   21,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   21,
												},
												File:   "mad.flux",
												Source: "map",
												Start: ast.Position{
													Column: 12,
													Line:   21,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   22,
									},
									File:   "mad.flux",
									Source: "diff\n        |> median(column: \"_value\")\n        |> map(fn: (r) => ({ r with MAD: k * r._value}))\n        |> filter(fn: (r) => r.MAD > 0.0)",
									Start: ast.Position{
										Column: 5,
										Line:   19,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   22,
											},
											File:   "mad.flux",
											Source: "fn: (r) => r.MAD > 0.0",
											Start: ast.Position{
												Column: 19,
												Line:   22,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   22,
												},
												File:   "mad.flux",
												Source: "fn: (r) => r.MAD > 0.0",
												Start: ast.Position{
													Column: 19,
													Line:   22,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   22,
													},
													File:   "mad.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   22,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   22,
													},
													File:   "mad.flux",
													Source: "(r) => r.MAD > 0.0",
													Start: ast.Position{
														Column: 23,
														Line:   22,
													},
												},
											},
											Body: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   22,
														},
														File:   "mad.flux",
														Source: "r.MAD > 0.0",
														Start: ast.Position{
															Column: 30,
															Line:   22,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   22,
															},
															File:   "mad.flux",
															Source: "r.MAD",
															Start: ast.Position{
																Column: 30,
																Line:   22,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   22,
																},
																File:   "mad.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 30,
																	Line:   22,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   22,
																},
																File:   "mad.flux",
																Source: "MAD",
																Start: ast.Position{
																	Column: 32,
																	Line:   22,
																},
															},
														},
														Name: "MAD",
													},
													Rbrack: nil,
												},
												Operator: 10,
												Right: &ast.FloatLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   22,
															},
															File:   "mad.flux",
															Source: "0.0",
															Start: ast.Position{
																Column: 38,
																Line:   22,
															},
														},
													},
													Value: 0.0,
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   22,
														},
														File:   "mad.flux",
														Source: "r",
														Start: ast.Position{
															Column: 24,
															Line:   22,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   22,
															},
															File:   "mad.flux",
															Source: "r",
															Start: ast.Position{
																Column: 24,
																Line:   22,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   22,
										},
										File:   "mad.flux",
										Source: "filter(fn: (r) => r.MAD > 0.0)",
										Start: ast.Position{
											Column: 12,
											Line:   22,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   22,
											},
											File:   "mad.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 12,
												Line:   22,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   29,
								},
								File:   "mad.flux",
								Source: "output = join(tables: {diff: diff, diff_med: diff_med}, on: [\"_time\"], method: \"inner\")\n        |> map(fn: (r) => ({ r with _value: r._value_diff/r._value_diff_med}))\n    |> map(fn: (r) => ({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        }))",
								Start: ast.Position{
									Column: 5,
									Line:   23,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   23,
									},
									File:   "mad.flux",
									Source: "output",
									Start: ast.Position{
										Column: 5,
										Line:   23,
									},
								},
							},
							Name: "output",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   23,
												},
												File:   "mad.flux",
												Source: "tables: {diff: diff, diff_med: diff_med}, on: [\"_time\"], method: \"inner\"",
												Start: ast.Position{
													Column: 19,
													Line:   23,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   23,
													},
													File:   "mad.flux",
													Source: "tables: {diff: diff, diff_med: diff_med}",
													Start: ast.Position{
														Column: 19,
														Line:   23,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   23,
														},
														File:   "mad.flux",
														Source: "tables",
														Start: ast.Position{
															Column: 19,
															Line:   23,
														},
													},
												},
												Name: "tables",
											},
											Separator: nil,
											Value: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   23,
														},
														File:   "mad.flux",
														Source: "{diff: diff, diff_med: diff_med}",
														Start: ast.Position{
															Column: 27,
															Line:   23,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   23,
															},
															File:   "mad.flux",
															Source: "diff: diff",
															Start: ast.Position{
																Column: 28,
																Line:   23,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 32,
																	Line:   23,
																},
																File:   "mad.flux",
																Source: "diff",
																Start: ast.Position{
																	Column: 28,
																	Line:   23,
																},
															},
														},
														Name: "diff",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 38,
																	Line:   23,
																},
																File:   "mad.flux",
																Source: "diff",
																Start: ast.Position{
																	Column: 34,
																	Line:   23,
																},
															},
														},
														Name: "diff",
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 58,
																Line:   23,
															},
															File:   "mad.flux",
															Source: "diff_med: diff_med",
															Start: ast.Position{
																Column: 40,
																Line:   23,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   23,
																},
																File:   "mad.flux",
																Source: "diff_med",
																Start: ast.Position{
																	Column: 40,
																	Line:   23,
																},
															},
														},
														Name: "diff_med",
													},
													Separator: nil,
													Value: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   23,
																},
																File:   "mad.flux",
																Source: "diff_med",
																Start: ast.Position{
																	Column: 50,
																	Line:   23,
																},
															},
														},
														Name: "diff_med",
													},
												}},
												Rbrace: nil,
												With:   nil,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   23,
													},
													File:   "mad.flux",
													Source: "on: [\"_time\"]",
													Start: ast.Position{
														Column: 61,
														Line:   23,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   23,
														},
														File:   "mad.flux",
														Source: "on",
														Start: ast.Position{
															Column: 61,
															Line:   23,
														},
													},
												},
												Name: "on",
											},
											Separator: nil,
											Value: &ast.ArrayExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 74,
															Line:   23,
														},
														File:   "mad.flux",
														Source: "[\"_time\"]",
														Start: ast.Position{
															Column: 65,
															Line:   23,
														},
													},
												},
												Elements: []ast.Expression{&ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   23,
															},
															File:   "mad.flux",
															Source: "\"_time\"",
															Start: ast.Position{
																Column: 66,
																Line:   23,
															},
														},
													},
													Value: "_time",
												}},
												Lbrack: nil,
												Rbrack: nil,
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 91,
														Line:   23,
													},
													File:   "mad.flux",
													Source: "method: \"inner\"",
													Start: ast.Position{
														Column: 76,
														Line:   23,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   23,
														},
														File:   "mad.flux",
														Source: "method",
														Start: ast.Position{
															Column: 76,
															Line:   23,
														},
													},
												},
												Name: "method",
											},
											Separator: nil,
											Value: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 91,
															Line:   23,
														},
														File:   "mad.flux",
														Source: "\"inner\"",
														Start: ast.Position{
															Column: 84,
															Line:   23,
														},
													},
												},
												Value: "inner",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   23,
											},
											File:   "mad.flux",
											Source: "join(tables: {diff: diff, diff_med: diff_med}, on: [\"_time\"], method: \"inner\")",
											Start: ast.Position{
												Column: 14,
												Line:   23,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   23,
												},
												File:   "mad.flux",
												Source: "join",
												Start: ast.Position{
													Column: 14,
													Line:   23,
												},
											},
										},
										Name: "join",
									},
									Lparen: nil,
									Rparen: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 79,
											Line:   24,
										},
										File:   "mad.flux",
										Source: "join(tables: {diff: diff, diff_med: diff_med}, on: [\"_time\"], method: \"inner\")\n        |> map(fn: (r) => ({ r with _value: r._value_diff/r._value_diff_med}))",
										Start: ast.Position{
											Column: 14,
											Line:   23,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   24,
												},
												File:   "mad.flux",
												Source: "fn: (r) => ({ r with _value: r._value_diff/r._value_diff_med})",
												Start: ast.Position{
													Column: 16,
													Line:   24,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   24,
													},
													File:   "mad.flux",
													Source: "fn: (r) => ({ r with _value: r._value_diff/r._value_diff_med})",
													Start: ast.Position{
														Column: 16,
														Line:   24,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   24,
														},
														File:   "mad.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 16,
															Line:   24,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   24,
														},
														File:   "mad.flux",
														Source: "(r) => ({ r with _value: r._value_diff/r._value_diff_med})",
														Start: ast.Position{
															Column: 20,
															Line:   24,
														},
													},
												},
												Body: &ast.ParenExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 78,
																Line:   24,
															},
															File:   "mad.flux",
															Source: "({ r with _value: r._value_diff/r._value_diff_med})",
															Start: ast.Position{
																Column: 27,
																Line:   24,
															},
														},
													},
													Expression: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   24,
																},
																File:   "mad.flux",
																Source: "{ r with _value: r._value_diff/r._value_diff_med}",
																Start: ast.Position{
																	Column: 28,
																	Line:   24,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   24,
																	},
																	File:   "mad.flux",
																	Source: "_value: r._value_diff/r._value_diff_med",
																	Start: ast.Position{
																		Column: 37,
																		Line:   24,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 43,
																			Line:   24,
																		},
																		File:   "mad.flux",
																		Source: "_value",
																		Start: ast.Position{
																			Column: 37,
																			Line:   24,
																		},
																	},
																},
																Name: "_value",
															},
															Separator: nil,
															Value: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   24,
																		},
																		File:   "mad.flux",
																		Source: "r._value_diff/r._value_diff_med",
																		Start: ast.Position{
																			Column: 45,
																			Line:   24,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   24,
																			},
																			File:   "mad.flux",
																			Source: "r._value_diff",
																			Start: ast.Position{
																				Column: 45,
																				Line:   24,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 46,
																					Line:   24,
																				},
																				File:   "mad.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 45,
																					Line:   24,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   24,
																				},
																				File:   "mad.flux",
																				Source: "_value_diff",
																				Start: ast.Position{
																					Column: 47,
																					Line:   24,
																				},
																			},
																		},
																		Name: "_value_diff",
																	},
																	Rbrack: nil,
																},
																Operator: 2,
																Right: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 76,
																				Line:   24,
																			},
																			File:   "mad.flux",
																			Source: "r._value_diff_med",
																			Start: ast.Position{
																				Column: 59,
																				Line:   24,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 60,
																					Line:   24,
																				},
																				File:   "mad.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 59,
																					Line:   24,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 76,
																					Line:   24,
																				},
																				File:   "mad.flux",
																				Source: "_value_diff_med",
																				Start: ast.Position{
																					Column: 61,
																					Line:   24,
																				},
																			},
																		},
																		Name: "_value_diff_med",
																	},
																	Rbrack: nil,
																},
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   24,
																	},
																	File:   "mad.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 30,
																		Line:   24,
																	},
																},
															},
															Name: "r",
														},
													},
													Lparen: nil,
													Rparen: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   24,
															},
															File:   "mad.flux",
															Source: "r",
															Start: ast.Position{
																Column: 21,
																Line:   24,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   24,
																},
																File:   "mad.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 21,
																	Line:   24,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   24,
											},
											File:   "mad.flux",
											Source: "map(fn: (r) => ({ r with _value: r._value_diff/r._value_diff_med}))",
											Start: ast.Position{
												Column: 12,
												Line:   24,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   24,
												},
												File:   "mad.flux",
												Source: "map",
												Start: ast.Position{
													Column: 12,
													Line:   24,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   29,
									},
									File:   "mad.flux",
									Source: "join(tables: {diff: diff, diff_med: diff_med}, on: [\"_time\"], method: \"inner\")\n        |> map(fn: (r) => ({ r with _value: r._value_diff/r._value_diff_med}))\n    |> map(fn: (r) => ({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        }))",
									Start: ast.Position{
										Column: 14,
										Line:   23,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   29,
											},
											File:   "mad.flux",
											Source: "fn: (r) => ({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        })",
											Start: ast.Position{
												Column: 12,
												Line:   25,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   29,
												},
												File:   "mad.flux",
												Source: "fn: (r) => ({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        })",
												Start: ast.Position{
													Column: 12,
													Line:   25,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   25,
													},
													File:   "mad.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 12,
														Line:   25,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   29,
													},
													File:   "mad.flux",
													Source: "(r) => ({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        })",
													Start: ast.Position{
														Column: 16,
														Line:   25,
													},
												},
											},
											Body: &ast.ParenExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   29,
														},
														File:   "mad.flux",
														Source: "({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        })",
														Start: ast.Position{
															Column: 23,
															Line:   25,
														},
													},
												},
												Expression: &ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   29,
															},
															File:   "mad.flux",
															Source: "{ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        }",
															Start: ast.Position{
																Column: 24,
																Line:   25,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   28,
																},
																File:   "mad.flux",
																Source: "level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"",
																Start: ast.Position{
																	Column: 13,
																	Line:   26,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   26,
																	},
																	File:   "mad.flux",
																	Source: "level",
																	Start: ast.Position{
																		Column: 13,
																		Line:   26,
																	},
																},
															},
															Name: "level",
														},
														Separator: nil,
														Value: &ast.ConditionalExpression{
															Alternate: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 30,
																			Line:   28,
																		},
																		File:   "mad.flux",
																		Source: "\"normal\"",
																		Start: ast.Position{
																			Column: 22,
																			Line:   28,
																		},
																	},
																},
																Value: "normal",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   28,
																	},
																	File:   "mad.flux",
																	Source: "if r._value >= threshold then \"anomaly\"\n                else \"normal\"",
																	Start: ast.Position{
																		Column: 17,
																		Line:   27,
																	},
																},
															},
															Consequent: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   27,
																		},
																		File:   "mad.flux",
																		Source: "\"anomaly\"",
																		Start: ast.Position{
																			Column: 47,
																			Line:   27,
																		},
																	},
																},
																Value: "anomaly",
															},
															Test: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   27,
																		},
																		File:   "mad.flux",
																		Source: "r._value >= threshold",
																		Start: ast.Position{
																			Column: 20,
																			Line:   27,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   27,
																			},
																			File:   "mad.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 20,
																				Line:   27,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 21,
																					Line:   27,
																				},
																				File:   "mad.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 20,
																					Line:   27,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   27,
																				},
																				File:   "mad.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 22,
																					Line:   27,
																				},
																			},
																		},
																		Name: "_value",
																	},
																	Rbrack: nil,
																},
																Operator: 9,
																Right: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 41,
																				Line:   27,
																			},
																			File:   "mad.flux",
																			Source: "threshold",
																			Start: ast.Position{
																				Column: 32,
																				Line:   27,
																			},
																		},
																	},
																	Name: "threshold",
																},
															},
															Tk_else: nil,
															Tk_if:   nil,
															Tk_then: nil,
														},
													}},
													Rbrace: nil,
													With: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 27,
																	Line:   25,
																},
																File:   "mad.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 26,
																	Line:   25,
																},
															},
														},
														Name: "r",
													},
												},
												Lparen: nil,
												Rparen: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   25,
														},
														File:   "mad.flux",
														Source: "r",
														Start: ast.Position{
															Column: 17,
															Line:   25,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   25,
															},
															File:   "mad.flux",
															Source: "r",
															Start: ast.Position{
																Column: 17,
																Line:   25,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   29,
										},
										File:   "mad.flux",
										Source: "map(fn: (r) => ({ r with\n            level:\n                if r._value >= threshold then \"anomaly\"\n                else \"normal\"\n        }))",
										Start: ast.Position{
											Column: 8,
											Line:   25,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   25,
											},
											File:   "mad.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   25,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.ReturnStatement{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   30,
									},
									File:   "mad.flux",
									Source: "output",
									Start: ast.Position{
										Column: 8,
										Line:   30,
									},
								},
							},
							Name: "output",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   30,
								},
								File:   "mad.flux",
								Source: "return output",
								Start: ast.Position{
									Column: 1,
									Line:   30,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   6,
							},
							File:   "mad.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 8,
								Line:   6,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   6,
								},
								File:   "mad.flux",
								Source: "table",
								Start: ast.Position{
									Column: 8,
									Line:   6,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   6,
							},
							File:   "mad.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   6,
							},
							File:   "mad.flux",
							Source: "threshold=3.0",
							Start: ast.Position{
								Column: 18,
								Line:   6,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   6,
								},
								File:   "mad.flux",
								Source: "threshold",
								Start: ast.Position{
									Column: 18,
									Line:   6,
								},
							},
						},
						Name: "threshold",
					},
					Separator: nil,
					Value: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   6,
								},
								File:   "mad.flux",
								Source: "3.0",
								Start: ast.Position{
									Column: 28,
									Line:   6,
								},
							},
						},
						Value: 3.0,
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   3,
					},
					File:   "mad.flux",
					Source: "import \"math\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   3,
						},
						File:   "mad.flux",
						Source: "\"math\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "math",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   4,
					},
					File:   "mad.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   4,
						},
						File:   "mad.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "mad.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   1,
					},
					File:   "mad.flux",
					Source: "package anomalydetection",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   1,
						},
						File:   "mad.flux",
						Source: "anomalydetection",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "anomalydetection",
			},
		},
	}},
	Package: "anomalydetection",
	Path:    "contrib/anaisdg/anomalydetection",
}
