// DO NOT EDIT: This file is autogenerated via the builtin command.

package slack

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 15,
					Line:   53,
				},
				File:   "slack.flux",
				Source: "package slack\n\nimport \"http\"\nimport \"json\"\n\nbuiltin validateColorString : (color: string) => string\n\noption defaultURL = \"https://slack.com/api/chat.postMessage\"\n\n// `message` sends a single message to a Slack channel. It will work either with the chat.postMessage API or with a slack webhook.\n// `url` - string - URL of the slack endpoint. Defaults to: \"https://slack.com/api/chat.postMessage\", if one uses the webhook api this must be acquired as part of the slack API setup. This URL will be secret. Don't worry about secrets for the initial implementation.\n// `token` - string - the api token string.  Defaults to: \"\", and can be ignored if one uses the webhook api URL.\n// `channel` - string - Name of channel in which to post the message. No default.\n// `text` - string - The text to display.\n// `color` - string - Color to give message: one of good, warning, and danger, or any hex rgb color value ex. #439FE0.\nmessage = (url=defaultURL, token=\"\", channel, text, color) => {\n    attachments = [{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]\n\n    data = {\n        channel: channel,\n        attachments: attachments,\n    }\n\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url, data: enc)\n}\n\n// `endpoint` creates the endpoint for the Slack external service.\n// `url` - string - URL of the slack endpoint. Defaults to: \"https://slack.com/api/chat.postMessage\", if one uses the webhook api this must be acquired as part of the slack API setup, and this URL will be secret.\n// `token` - string - token for the slack endpoint.  This can be ignored if one uses the webhook url acquired as part of the slack API setup, but must be supplied if the chat.postMessage API is used.\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with `channel`, `text`, and `color` fields as defined in the `message` function arguments.\nendpoint = (url=defaultURL, token=\"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            })",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 28,
						Line:   6,
					},
					File:   "slack.flux",
					Source: "builtin validateColorString",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   6,
						},
						File:   "slack.flux",
						Source: "validateColorString",
						Start: ast.Position{
							Column: 9,
							Line:   6,
						},
					},
				},
				Name: "validateColorString",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   6,
						},
						File:   "slack.flux",
						Source: "(color: string) => string",
						Start: ast.Position{
							Column: 31,
							Line:   6,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   6,
							},
							File:   "slack.flux",
							Source: "(color: string) => string",
							Start: ast.Position{
								Column: 31,
								Line:   6,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   6,
								},
								File:   "slack.flux",
								Source: "color: string",
								Start: ast.Position{
									Column: 32,
									Line:   6,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   6,
									},
									File:   "slack.flux",
									Source: "color",
									Start: ast.Position{
										Column: 32,
										Line:   6,
									},
								},
							},
							Name: "color",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   6,
									},
									File:   "slack.flux",
									Source: "string",
									Start: ast.Position{
										Column: 39,
										Line:   6,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   6,
										},
										File:   "slack.flux",
										Source: "string",
										Start: ast.Position{
											Column: 39,
											Line:   6,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   6,
								},
								File:   "slack.flux",
								Source: "string",
								Start: ast.Position{
									Column: 50,
									Line:   6,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   6,
									},
									File:   "slack.flux",
									Source: "string",
									Start: ast.Position{
										Column: 50,
										Line:   6,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 61,
							Line:   8,
						},
						File:   "slack.flux",
						Source: "defaultURL = \"https://slack.com/api/chat.postMessage\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   8,
							},
							File:   "slack.flux",
							Source: "defaultURL",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "defaultURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   8,
							},
							File:   "slack.flux",
							Source: "\"https://slack.com/api/chat.postMessage\"",
							Start: ast.Position{
								Column: 21,
								Line:   8,
							},
						},
					},
					Value: "https://slack.com/api/chat.postMessage",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 61,
						Line:   8,
					},
					File:   "slack.flux",
					Source: "option defaultURL = \"https://slack.com/api/chat.postMessage\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "slack.flux",
					Source: "message = (url=defaultURL, token=\"\", channel, text, color) => {\n    attachments = [{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]\n\n    data = {\n        channel: channel,\n        attachments: attachments,\n    }\n\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url, data: enc)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `message` sends a single message to a Slack channel. It will work either with the chat.postMessage API or with a slack webhook.\n"}, ast.Comment{Text: "// `url` - string - URL of the slack endpoint. Defaults to: \"https://slack.com/api/chat.postMessage\", if one uses the webhook api this must be acquired as part of the slack API setup. This URL will be secret. Don't worry about secrets for the initial implementation.\n"}, ast.Comment{Text: "// `token` - string - the api token string.  Defaults to: \"\", and can be ignored if one uses the webhook api URL.\n"}, ast.Comment{Text: "// `channel` - string - Name of channel in which to post the message. No default.\n"}, ast.Comment{Text: "// `text` - string - The text to display.\n"}, ast.Comment{Text: "// `color` - string - Color to give message: one of good, warning, and danger, or any hex rgb color value ex. #439FE0.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   16,
						},
						File:   "slack.flux",
						Source: "message",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "message",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "slack.flux",
						Source: "(url=defaultURL, token=\"\", channel, text, color) => {\n    attachments = [{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]\n\n    data = {\n        channel: channel,\n        attachments: attachments,\n    }\n\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url, data: enc)\n}",
						Start: ast.Position{
							Column: 11,
							Line:   16,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   34,
							},
							File:   "slack.flux",
							Source: "{\n    attachments = [{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]\n\n    data = {\n        channel: channel,\n        attachments: attachments,\n    }\n\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v:data)\n    return http.post(headers: headers, url: url, data: enc)\n}",
							Start: ast.Position{
								Column: 63,
								Line:   16,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 7,
									Line:   21,
								},
								File:   "slack.flux",
								Source: "attachments = [{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]",
								Start: ast.Position{
									Column: 5,
									Line:   17,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   17,
									},
									File:   "slack.flux",
									Source: "attachments",
									Start: ast.Position{
										Column: 5,
										Line:   17,
									},
								},
							},
							Name: "attachments",
						},
						Init: &ast.ArrayExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   21,
									},
									File:   "slack.flux",
									Source: "[{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }]",
									Start: ast.Position{
										Column: 19,
										Line:   17,
									},
								},
							},
							Elements: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   21,
										},
										File:   "slack.flux",
										Source: "{\n        color: validateColorString(color),\n        text: string(v: text),\n        mrkdwn_in: [\"text\"],\n    }",
										Start: ast.Position{
											Column: 20,
											Line:   17,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   18,
											},
											File:   "slack.flux",
											Source: "color: validateColorString(color)",
											Start: ast.Position{
												Column: 9,
												Line:   18,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   18,
												},
												File:   "slack.flux",
												Source: "color",
												Start: ast.Position{
													Column: 9,
													Line:   18,
												},
											},
										},
										Name: "color",
									},
									Separator: nil,
									Value: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   18,
													},
													File:   "slack.flux",
													Source: "color",
													Start: ast.Position{
														Column: 36,
														Line:   18,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   18,
														},
														File:   "slack.flux",
														Source: "color",
														Start: ast.Position{
															Column: 36,
															Line:   18,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 41,
																Line:   18,
															},
															File:   "slack.flux",
															Source: "color",
															Start: ast.Position{
																Column: 36,
																Line:   18,
															},
														},
													},
													Name: "color",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   18,
												},
												File:   "slack.flux",
												Source: "validateColorString(color)",
												Start: ast.Position{
													Column: 16,
													Line:   18,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   18,
													},
													File:   "slack.flux",
													Source: "validateColorString",
													Start: ast.Position{
														Column: 16,
														Line:   18,
													},
												},
											},
											Name: "validateColorString",
										},
										Lparen: nil,
										Rparen: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   19,
											},
											File:   "slack.flux",
											Source: "text: string(v: text)",
											Start: ast.Position{
												Column: 9,
												Line:   19,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   19,
												},
												File:   "slack.flux",
												Source: "text",
												Start: ast.Position{
													Column: 9,
													Line:   19,
												},
											},
										},
										Name: "text",
									},
									Separator: nil,
									Value: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   19,
													},
													File:   "slack.flux",
													Source: "v: text",
													Start: ast.Position{
														Column: 22,
														Line:   19,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   19,
														},
														File:   "slack.flux",
														Source: "v: text",
														Start: ast.Position{
															Column: 22,
															Line:   19,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   19,
															},
															File:   "slack.flux",
															Source: "v",
															Start: ast.Position{
																Column: 22,
																Line:   19,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   19,
															},
															File:   "slack.flux",
															Source: "text",
															Start: ast.Position{
																Column: 25,
																Line:   19,
															},
														},
													},
													Name: "text",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   19,
												},
												File:   "slack.flux",
												Source: "string(v: text)",
												Start: ast.Position{
													Column: 15,
													Line:   19,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   19,
													},
													File:   "slack.flux",
													Source: "string",
													Start: ast.Position{
														Column: 15,
														Line:   19,
													},
												},
											},
											Name: "string",
										},
										Lparen: nil,
										Rparen: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   20,
											},
											File:   "slack.flux",
											Source: "mrkdwn_in: [\"text\"]",
											Start: ast.Position{
												Column: 9,
												Line:   20,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   20,
												},
												File:   "slack.flux",
												Source: "mrkdwn_in",
												Start: ast.Position{
													Column: 9,
													Line:   20,
												},
											},
										},
										Name: "mrkdwn_in",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   20,
												},
												File:   "slack.flux",
												Source: "[\"text\"]",
												Start: ast.Position{
													Column: 20,
													Line:   20,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   20,
													},
													File:   "slack.flux",
													Source: "\"text\"",
													Start: ast.Position{
														Column: 21,
														Line:   20,
													},
												},
											},
											Value: "text",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							Lbrack: nil,
							Rbrack: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   26,
								},
								File:   "slack.flux",
								Source: "data = {\n        channel: channel,\n        attachments: attachments,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   23,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   23,
									},
									File:   "slack.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   23,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   26,
									},
									File:   "slack.flux",
									Source: "{\n        channel: channel,\n        attachments: attachments,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   23,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   24,
										},
										File:   "slack.flux",
										Source: "channel: channel",
										Start: ast.Position{
											Column: 9,
											Line:   24,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   24,
											},
											File:   "slack.flux",
											Source: "channel",
											Start: ast.Position{
												Column: 9,
												Line:   24,
											},
										},
									},
									Name: "channel",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   24,
											},
											File:   "slack.flux",
											Source: "channel",
											Start: ast.Position{
												Column: 18,
												Line:   24,
											},
										},
									},
									Name: "channel",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   25,
										},
										File:   "slack.flux",
										Source: "attachments: attachments",
										Start: ast.Position{
											Column: 9,
											Line:   25,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   25,
											},
											File:   "slack.flux",
											Source: "attachments",
											Start: ast.Position{
												Column: 9,
												Line:   25,
											},
										},
									},
									Name: "attachments",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   25,
											},
											File:   "slack.flux",
											Source: "attachments",
											Start: ast.Position{
												Column: 22,
												Line:   25,
											},
										},
									},
									Name: "attachments",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   31,
								},
								File:   "slack.flux",
								Source: "headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   28,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   28,
									},
									File:   "slack.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   28,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   31,
									},
									File:   "slack.flux",
									Source: "{\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   28,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   29,
										},
										File:   "slack.flux",
										Source: "\"Authorization\": \"Bearer \" + token",
										Start: ast.Position{
											Column: 9,
											Line:   29,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   29,
											},
											File:   "slack.flux",
											Source: "\"Authorization\"",
											Start: ast.Position{
												Column: 9,
												Line:   29,
											},
										},
									},
									Value: "Authorization",
								},
								Separator: nil,
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   29,
											},
											File:   "slack.flux",
											Source: "\"Bearer \" + token",
											Start: ast.Position{
												Column: 26,
												Line:   29,
											},
										},
									},
									Left: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   29,
												},
												File:   "slack.flux",
												Source: "\"Bearer \"",
												Start: ast.Position{
													Column: 26,
													Line:   29,
												},
											},
										},
										Value: "Bearer ",
									},
									Operator: 5,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   29,
												},
												File:   "slack.flux",
												Source: "token",
												Start: ast.Position{
													Column: 38,
													Line:   29,
												},
											},
										},
										Name: "token",
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   30,
										},
										File:   "slack.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   30,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   30,
											},
											File:   "slack.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   30,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   30,
											},
											File:   "slack.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   30,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   32,
								},
								File:   "slack.flux",
								Source: "enc = json.encode(v:data)",
								Start: ast.Position{
									Column: 5,
									Line:   32,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   32,
									},
									File:   "slack.flux",
									Source: "enc",
									Start: ast.Position{
										Column: 5,
										Line:   32,
									},
								},
							},
							Name: "enc",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   32,
										},
										File:   "slack.flux",
										Source: "v:data",
										Start: ast.Position{
											Column: 23,
											Line:   32,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   32,
											},
											File:   "slack.flux",
											Source: "v:data",
											Start: ast.Position{
												Column: 23,
												Line:   32,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   32,
												},
												File:   "slack.flux",
												Source: "v",
												Start: ast.Position{
													Column: 23,
													Line:   32,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   32,
												},
												File:   "slack.flux",
												Source: "data",
												Start: ast.Position{
													Column: 25,
													Line:   32,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   32,
									},
									File:   "slack.flux",
									Source: "json.encode(v:data)",
									Start: ast.Position{
										Column: 11,
										Line:   32,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   32,
										},
										File:   "slack.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 11,
											Line:   32,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   32,
											},
											File:   "slack.flux",
											Source: "json",
											Start: ast.Position{
												Column: 11,
												Line:   32,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   32,
											},
											File:   "slack.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 16,
												Line:   32,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   33,
										},
										File:   "slack.flux",
										Source: "headers: headers, url: url, data: enc",
										Start: ast.Position{
											Column: 22,
											Line:   33,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   33,
											},
											File:   "slack.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   33,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   33,
												},
												File:   "slack.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   33,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   33,
												},
												File:   "slack.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   33,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   33,
											},
											File:   "slack.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   33,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   33,
												},
												File:   "slack.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   33,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   33,
												},
												File:   "slack.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   33,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   33,
											},
											File:   "slack.flux",
											Source: "data: enc",
											Start: ast.Position{
												Column: 50,
												Line:   33,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   33,
												},
												File:   "slack.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   33,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   33,
												},
												File:   "slack.flux",
												Source: "enc",
												Start: ast.Position{
													Column: 56,
													Line:   33,
												},
											},
										},
										Name: "enc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   33,
									},
									File:   "slack.flux",
									Source: "http.post(headers: headers, url: url, data: enc)",
									Start: ast.Position{
										Column: 12,
										Line:   33,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   33,
										},
										File:   "slack.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   33,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   33,
											},
											File:   "slack.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   33,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   33,
											},
											File:   "slack.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   33,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   33,
								},
								File:   "slack.flux",
								Source: "return http.post(headers: headers, url: url, data: enc)",
								Start: ast.Position{
									Column: 5,
									Line:   33,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   16,
							},
							File:   "slack.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 12,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   16,
								},
								File:   "slack.flux",
								Source: "url",
								Start: ast.Position{
									Column: 12,
									Line:   16,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   16,
								},
								File:   "slack.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 16,
									Line:   16,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   16,
							},
							File:   "slack.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 28,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   16,
								},
								File:   "slack.flux",
								Source: "token",
								Start: ast.Position{
									Column: 28,
									Line:   16,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   16,
								},
								File:   "slack.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 34,
									Line:   16,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   16,
							},
							File:   "slack.flux",
							Source: "channel",
							Start: ast.Position{
								Column: 38,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   16,
								},
								File:   "slack.flux",
								Source: "channel",
								Start: ast.Position{
									Column: 38,
									Line:   16,
								},
							},
						},
						Name: "channel",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   16,
							},
							File:   "slack.flux",
							Source: "text",
							Start: ast.Position{
								Column: 47,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   16,
								},
								File:   "slack.flux",
								Source: "text",
								Start: ast.Position{
									Column: 47,
									Line:   16,
								},
							},
						},
						Name: "text",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   16,
							},
							File:   "slack.flux",
							Source: "color",
							Start: ast.Position{
								Column: 53,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   16,
								},
								File:   "slack.flux",
								Source: "color",
								Start: ast.Position{
									Column: 53,
									Line:   16,
								},
							},
						},
						Name: "color",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   53,
					},
					File:   "slack.flux",
					Source: "endpoint = (url=defaultURL, token=\"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            })",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates the endpoint for the Slack external service.\n"}, ast.Comment{Text: "// `url` - string - URL of the slack endpoint. Defaults to: \"https://slack.com/api/chat.postMessage\", if one uses the webhook api this must be acquired as part of the slack API setup, and this URL will be secret.\n"}, ast.Comment{Text: "// `token` - string - token for the slack endpoint.  This can be ignored if one uses the webhook url acquired as part of the slack API setup, but must be supplied if the chat.postMessage API is used.\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with `channel`, `text`, and `color` fields as defined in the `message` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   41,
						},
						File:   "slack.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   41,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   53,
						},
						File:   "slack.flux",
						Source: "(url=defaultURL, token=\"\") =>\n    (mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            })",
						Start: ast.Position{
							Column: 12,
							Line:   41,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   53,
							},
							File:   "slack.flux",
							Source: "(mapFn) =>\n        (tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            })",
							Start: ast.Position{
								Column: 5,
								Line:   42,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   53,
								},
								File:   "slack.flux",
								Source: "(tables=<-) => tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            })",
								Start: ast.Position{
									Column: 9,
									Line:   43,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   43,
										},
										File:   "slack.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 24,
											Line:   43,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   53,
									},
									File:   "slack.flux",
									Source: "tables\n            |> map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            })",
									Start: ast.Position{
										Column: 24,
										Line:   43,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   53,
											},
											File:   "slack.flux",
											Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            }",
											Start: ast.Position{
												Column: 20,
												Line:   44,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   53,
												},
												File:   "slack.flux",
												Source: "fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            }",
												Start: ast.Position{
													Column: 20,
													Line:   44,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   44,
													},
													File:   "slack.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 20,
														Line:   44,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   53,
													},
													File:   "slack.flux",
													Source: "(r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            }",
													Start: ast.Position{
														Column: 24,
														Line:   44,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   53,
														},
														File:   "slack.flux",
														Source: "{\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            }",
														Start: ast.Position{
															Column: 31,
															Line:   44,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   45,
															},
															File:   "slack.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 17,
																Line:   45,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   45,
																},
																File:   "slack.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 17,
																	Line:   45,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   45,
																	},
																	File:   "slack.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 29,
																		Line:   45,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 33,
																			Line:   45,
																		},
																		File:   "slack.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 29,
																			Line:   45,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   45,
																			},
																			File:   "slack.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 29,
																				Line:   45,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 33,
																				Line:   45,
																			},
																			File:   "slack.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 32,
																				Line:   45,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   45,
																},
																File:   "slack.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 23,
																	Line:   45,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   45,
																	},
																	File:   "slack.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 23,
																		Line:   45,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   52,
																},
																File:   "slack.flux",
																Source: "{r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}",
																Start: ast.Position{
																	Column: 24,
																	Line:   46,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   52,
																	},
																	File:   "slack.flux",
																	Source: "_sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)",
																	Start: ast.Position{
																		Column: 32,
																		Line:   46,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   46,
																		},
																		File:   "slack.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 32,
																			Line:   46,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   52,
																			},
																			File:   "slack.flux",
																			Source: "v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100",
																			Start: ast.Position{
																				Column: 46,
																				Line:   46,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   52,
																				},
																				File:   "slack.flux",
																				Source: "v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100",
																				Start: ast.Position{
																					Column: 46,
																					Line:   46,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   46,
																					},
																					File:   "slack.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 46,
																						Line:   46,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   52,
																					},
																					File:   "slack.flux",
																					Source: "2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100",
																					Start: ast.Position{
																						Column: 49,
																						Line:   46,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 50,
																							Line:   46,
																						},
																						File:   "slack.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 49,
																							Line:   46,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 24,
																							Line:   52,
																						},
																						File:   "slack.flux",
																						Source: "message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100",
																						Start: ast.Position{
																							Column: 54,
																							Line:   46,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 37,
																									Line:   51,
																								},
																								File:   "slack.flux",
																								Source: "url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color",
																								Start: ast.Position{
																									Column: 21,
																									Line:   47,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 29,
																										Line:   47,
																									},
																									File:   "slack.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 21,
																										Line:   47,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 24,
																											Line:   47,
																										},
																										File:   "slack.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 21,
																											Line:   47,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   47,
																										},
																										File:   "slack.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 26,
																											Line:   47,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   48,
																									},
																									File:   "slack.flux",
																									Source: "token: token",
																									Start: ast.Position{
																										Column: 21,
																										Line:   48,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 26,
																											Line:   48,
																										},
																										File:   "slack.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 21,
																											Line:   48,
																										},
																									},
																								},
																								Name: "token",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   48,
																										},
																										File:   "slack.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 28,
																											Line:   48,
																										},
																									},
																								},
																								Name: "token",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   49,
																									},
																									File:   "slack.flux",
																									Source: "channel: obj.channel",
																									Start: ast.Position{
																										Column: 21,
																										Line:   49,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   49,
																										},
																										File:   "slack.flux",
																										Source: "channel",
																										Start: ast.Position{
																											Column: 21,
																											Line:   49,
																										},
																									},
																								},
																								Name: "channel",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   49,
																										},
																										File:   "slack.flux",
																										Source: "obj.channel",
																										Start: ast.Position{
																											Column: 30,
																											Line:   49,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 33,
																												Line:   49,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 30,
																												Line:   49,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   49,
																											},
																											File:   "slack.flux",
																											Source: "channel",
																											Start: ast.Position{
																												Column: 34,
																												Line:   49,
																											},
																										},
																									},
																									Name: "channel",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 35,
																										Line:   50,
																									},
																									File:   "slack.flux",
																									Source: "text: obj.text",
																									Start: ast.Position{
																										Column: 21,
																										Line:   50,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 25,
																											Line:   50,
																										},
																										File:   "slack.flux",
																										Source: "text",
																										Start: ast.Position{
																											Column: 21,
																											Line:   50,
																										},
																									},
																								},
																								Name: "text",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   50,
																										},
																										File:   "slack.flux",
																										Source: "obj.text",
																										Start: ast.Position{
																											Column: 27,
																											Line:   50,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 30,
																												Line:   50,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 27,
																												Line:   50,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   50,
																											},
																											File:   "slack.flux",
																											Source: "text",
																											Start: ast.Position{
																												Column: 31,
																												Line:   50,
																											},
																										},
																									},
																									Name: "text",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 37,
																										Line:   51,
																									},
																									File:   "slack.flux",
																									Source: "color: obj.color",
																									Start: ast.Position{
																										Column: 21,
																										Line:   51,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 26,
																											Line:   51,
																										},
																										File:   "slack.flux",
																										Source: "color",
																										Start: ast.Position{
																											Column: 21,
																											Line:   51,
																										},
																									},
																								},
																								Name: "color",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   51,
																										},
																										File:   "slack.flux",
																										Source: "obj.color",
																										Start: ast.Position{
																											Column: 28,
																											Line:   51,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 31,
																												Line:   51,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 28,
																												Line:   51,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   51,
																											},
																											File:   "slack.flux",
																											Source: "color",
																											Start: ast.Position{
																												Column: 32,
																												Line:   51,
																											},
																										},
																									},
																									Name: "color",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 18,
																								Line:   52,
																							},
																							File:   "slack.flux",
																							Source: "message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                )",
																							Start: ast.Position{
																								Column: 54,
																								Line:   46,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 61,
																									Line:   46,
																								},
																								File:   "slack.flux",
																								Source: "message",
																								Start: ast.Position{
																									Column: 54,
																									Line:   46,
																								},
																							},
																						},
																						Name: "message",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 24,
																								Line:   52,
																							},
																							File:   "slack.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 21,
																								Line:   52,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 25,
																			Line:   52,
																		},
																		File:   "slack.flux",
																		Source: "string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)",
																		Start: ast.Position{
																			Column: 39,
																			Line:   46,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   46,
																			},
																			File:   "slack.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 39,
																				Line:   46,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   46,
																	},
																	File:   "slack.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   46,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   52,
															},
															File:   "slack.flux",
															Source: "return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}",
															Start: ast.Position{
																Column: 17,
																Line:   46,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   44,
														},
														File:   "slack.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   44,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   44,
															},
															File:   "slack.flux",
															Source: "r",
															Start: ast.Position{
																Column: 25,
																Line:   44,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   53,
										},
										File:   "slack.flux",
										Source: "map(fn: (r) => {\n                obj = mapFn(r: r)\n                return {r with _sent: string(v: 2 == message(\n                    url: url,\n                    token: token,\n                    channel: obj.channel,\n                    text: obj.text,\n                    color: obj.color,\n                ) / 100)}\n            })",
										Start: ast.Position{
											Column: 16,
											Line:   44,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   44,
											},
											File:   "slack.flux",
											Source: "map",
											Start: ast.Position{
												Column: 16,
												Line:   44,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   43,
									},
									File:   "slack.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 10,
										Line:   43,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   43,
										},
										File:   "slack.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 10,
											Line:   43,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   43,
									},
									File:   "slack.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 17,
										Line:   43,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   42,
								},
								File:   "slack.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 6,
									Line:   42,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   42,
									},
									File:   "slack.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 6,
										Line:   42,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   41,
							},
							File:   "slack.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   41,
								},
								File:   "slack.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   41,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   41,
								},
								File:   "slack.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   41,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   41,
							},
							File:   "slack.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 29,
								Line:   41,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   41,
								},
								File:   "slack.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   41,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   41,
								},
								File:   "slack.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 35,
									Line:   41,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   3,
					},
					File:   "slack.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   3,
						},
						File:   "slack.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   3,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "slack.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "slack.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "slack.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   1,
					},
					File:   "slack.flux",
					Source: "package slack",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   1,
						},
						File:   "slack.flux",
						Source: "slack",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "slack",
			},
		},
	}},
	Package: "slack",
	Path:    "slack",
}
