// Copyright (c) 2020 Red Hat, Intel Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package types

const (
	DownwardAPIMountPath   = "/etc/podnetinfo"
	AnnotationsPath        = "annotations"
	LabelsPath             = "labels"
	EnvNameContainerName   = "CONTAINER_NAME"
	Hugepages1GRequestPath = "hugepages_1G_request"
	Hugepages2MRequestPath = "hugepages_2M_request"
	Hugepages1GLimitPath   = "hugepages_1G_limit"
	Hugepages2MLimitPath   = "hugepages_2M_limit"
	ConfigMapMainFileKey   = "config.json"
)

// JsonPatchOperation the JSON path operation
type JsonPatchOperation struct {
	Operation string      `json:"op"`
	Path      string      `json:"path"`
	Value     interface{} `json:"value,omitempty"`
}
