// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/ad_group_simulation.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v1/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An ad group simulation. Supported combinations of advertising
// channel type, simulation type and simulation modification method is
// detailed below respectively.
//
// SEARCH   CPC_BID     DEFAULT
// SEARCH   CPC_BID     UNIFORM
// SEARCH   TARGET_CPA  UNIFORM
// DISPLAY  CPC_BID     DEFAULT
// DISPLAY  CPC_BID     UNIFORM
// DISPLAY  TARGET_CPA  UNIFORM
// VIDEO    CPV_BID     DEFAULT
// VIDEO    CPV_BID     UNIFORM
type AdGroupSimulation struct {
	// The resource name of the ad group simulation.
	// Ad group simulation resource names have the form:
	//
	// `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Ad group id of the simulation.
	AdGroupId *wrappers.Int64Value `protobuf:"bytes,2,opt,name=ad_group_id,json=adGroupId,proto3" json:"ad_group_id,omitempty"`
	// The field that the simulation modifies.
	Type enums.SimulationTypeEnum_SimulationType `protobuf:"varint,3,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.SimulationTypeEnum_SimulationType" json:"type,omitempty"`
	// How the simulation modifies the field.
	ModificationMethod enums.SimulationModificationMethodEnum_SimulationModificationMethod `protobuf:"varint,4,opt,name=modification_method,json=modificationMethod,proto3,enum=google.ads.googleads.v1.enums.SimulationModificationMethodEnum_SimulationModificationMethod" json:"modification_method,omitempty"`
	// First day on which the simulation is based, in YYYY-MM-DD format.
	StartDate *wrappers.StringValue `protobuf:"bytes,5,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Last day on which the simulation is based, in YYYY-MM-DD format
	EndDate *wrappers.StringValue `protobuf:"bytes,6,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// List of simulation points.
	//
	// Types that are valid to be assigned to PointList:
	//	*AdGroupSimulation_CpcBidPointList
	//	*AdGroupSimulation_CpvBidPointList
	//	*AdGroupSimulation_TargetCpaPointList
	PointList            isAdGroupSimulation_PointList `protobuf_oneof:"point_list"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AdGroupSimulation) Reset()         { *m = AdGroupSimulation{} }
func (m *AdGroupSimulation) String() string { return proto.CompactTextString(m) }
func (*AdGroupSimulation) ProtoMessage()    {}
func (*AdGroupSimulation) Descriptor() ([]byte, []int) {
	return fileDescriptor_8c8573d5f5d3a023, []int{0}
}

func (m *AdGroupSimulation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupSimulation.Unmarshal(m, b)
}
func (m *AdGroupSimulation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupSimulation.Marshal(b, m, deterministic)
}
func (m *AdGroupSimulation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupSimulation.Merge(m, src)
}
func (m *AdGroupSimulation) XXX_Size() int {
	return xxx_messageInfo_AdGroupSimulation.Size(m)
}
func (m *AdGroupSimulation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupSimulation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupSimulation proto.InternalMessageInfo

func (m *AdGroupSimulation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupSimulation) GetAdGroupId() *wrappers.Int64Value {
	if m != nil {
		return m.AdGroupId
	}
	return nil
}

func (m *AdGroupSimulation) GetType() enums.SimulationTypeEnum_SimulationType {
	if m != nil {
		return m.Type
	}
	return enums.SimulationTypeEnum_UNSPECIFIED
}

func (m *AdGroupSimulation) GetModificationMethod() enums.SimulationModificationMethodEnum_SimulationModificationMethod {
	if m != nil {
		return m.ModificationMethod
	}
	return enums.SimulationModificationMethodEnum_UNSPECIFIED
}

func (m *AdGroupSimulation) GetStartDate() *wrappers.StringValue {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *AdGroupSimulation) GetEndDate() *wrappers.StringValue {
	if m != nil {
		return m.EndDate
	}
	return nil
}

type isAdGroupSimulation_PointList interface {
	isAdGroupSimulation_PointList()
}

type AdGroupSimulation_CpcBidPointList struct {
	CpcBidPointList *common.CpcBidSimulationPointList `protobuf:"bytes,8,opt,name=cpc_bid_point_list,json=cpcBidPointList,proto3,oneof"`
}

type AdGroupSimulation_CpvBidPointList struct {
	CpvBidPointList *common.CpvBidSimulationPointList `protobuf:"bytes,10,opt,name=cpv_bid_point_list,json=cpvBidPointList,proto3,oneof"`
}

type AdGroupSimulation_TargetCpaPointList struct {
	TargetCpaPointList *common.TargetCpaSimulationPointList `protobuf:"bytes,9,opt,name=target_cpa_point_list,json=targetCpaPointList,proto3,oneof"`
}

func (*AdGroupSimulation_CpcBidPointList) isAdGroupSimulation_PointList() {}

func (*AdGroupSimulation_CpvBidPointList) isAdGroupSimulation_PointList() {}

func (*AdGroupSimulation_TargetCpaPointList) isAdGroupSimulation_PointList() {}

func (m *AdGroupSimulation) GetPointList() isAdGroupSimulation_PointList {
	if m != nil {
		return m.PointList
	}
	return nil
}

func (m *AdGroupSimulation) GetCpcBidPointList() *common.CpcBidSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_CpcBidPointList); ok {
		return x.CpcBidPointList
	}
	return nil
}

func (m *AdGroupSimulation) GetCpvBidPointList() *common.CpvBidSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_CpvBidPointList); ok {
		return x.CpvBidPointList
	}
	return nil
}

func (m *AdGroupSimulation) GetTargetCpaPointList() *common.TargetCpaSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_TargetCpaPointList); ok {
		return x.TargetCpaPointList
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupSimulation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupSimulation_CpcBidPointList)(nil),
		(*AdGroupSimulation_CpvBidPointList)(nil),
		(*AdGroupSimulation_TargetCpaPointList)(nil),
	}
}

func init() {
	proto.RegisterType((*AdGroupSimulation)(nil), "google.ads.googleads.v1.resources.AdGroupSimulation")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/ad_group_simulation.proto", fileDescriptor_8c8573d5f5d3a023)
}

var fileDescriptor_8c8573d5f5d3a023 = []byte{
	// 575 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x54, 0xcf, 0x6e, 0xd3, 0x30,
	0x18, 0x27, 0xdd, 0x28, 0xab, 0x37, 0x40, 0x04, 0x81, 0xa2, 0x31, 0xa1, 0x0e, 0x34, 0xa9, 0x27,
	0x47, 0xdd, 0x10, 0x88, 0x94, 0x03, 0xe9, 0x40, 0x65, 0x88, 0xa1, 0x2a, 0xab, 0x7a, 0x40, 0x95,
	0x22, 0x37, 0xf6, 0x32, 0x4b, 0x8d, 0x6d, 0x62, 0xa7, 0x68, 0x67, 0xce, 0xbc, 0x04, 0x07, 0x0e,
	0x3c, 0x0a, 0x8f, 0xc2, 0x53, 0xa0, 0x38, 0x89, 0x5b, 0xda, 0x75, 0xeb, 0xed, 0xcb, 0xf7, 0xfd,
	0xfe, 0xd8, 0x3f, 0xc7, 0x06, 0x9d, 0x98, 0xf3, 0x78, 0x42, 0x5c, 0x84, 0xa5, 0x5b, 0x94, 0x79,
	0x35, 0x6d, 0xbb, 0x29, 0x91, 0x3c, 0x4b, 0x23, 0x22, 0x5d, 0x84, 0xc3, 0x38, 0xe5, 0x99, 0x08,
	0x25, 0x4d, 0xb2, 0x09, 0x52, 0x94, 0x33, 0x28, 0x52, 0xae, 0xb8, 0xbd, 0x5f, 0x30, 0x20, 0xc2,
	0x12, 0x1a, 0x32, 0x9c, 0xb6, 0xa1, 0x21, 0xef, 0xba, 0xab, 0xf4, 0x23, 0x9e, 0x24, 0x9c, 0xb9,
	0x8b, 0x9a, 0xbb, 0xdd, 0x55, 0x04, 0xc2, 0xb2, 0x44, 0xce, 0xe1, 0xc3, 0x84, 0x63, 0x7a, 0x4e,
	0xa3, 0xf2, 0x83, 0xa8, 0x0b, 0x8e, 0x4b, 0x8d, 0xa3, 0xb5, 0x35, 0xd4, 0xa5, 0x20, 0x25, 0xe9,
	0x69, 0x49, 0xd2, 0x5f, 0xe3, 0xec, 0xdc, 0xfd, 0x96, 0x22, 0x21, 0x48, 0x2a, 0xcb, 0xf9, 0x5e,
	0x25, 0x2a, 0xa8, 0x8b, 0x18, 0xe3, 0x4a, 0x2b, 0x94, 0xd3, 0x67, 0xbf, 0xea, 0xe0, 0x81, 0x8f,
	0x7b, 0x79, 0x4e, 0x67, 0x46, 0xde, 0x7e, 0x0e, 0xee, 0x56, 0x51, 0x84, 0x0c, 0x25, 0xc4, 0xb1,
	0x9a, 0x56, 0xab, 0x11, 0xec, 0x54, 0xcd, 0xcf, 0x28, 0x21, 0x76, 0x07, 0x6c, 0x9b, 0x88, 0x29,
	0x76, 0x6a, 0x4d, 0xab, 0xb5, 0x7d, 0xf8, 0xa4, 0x0c, 0x14, 0x56, 0xcb, 0x81, 0x27, 0x4c, 0xbd,
	0x7c, 0x31, 0x44, 0x93, 0x8c, 0x04, 0x0d, 0x54, 0x38, 0x9d, 0x60, 0x7b, 0x00, 0x36, 0xf3, 0x3d,
	0x38, 0x1b, 0x4d, 0xab, 0x75, 0xef, 0xf0, 0x2d, 0x5c, 0x75, 0x22, 0x7a, 0xe7, 0x70, 0xb6, 0xb4,
	0xc1, 0xa5, 0x20, 0xef, 0x59, 0x96, 0x2c, 0xb4, 0x02, 0xad, 0x66, 0xff, 0xb0, 0xc0, 0xc3, 0x2b,
	0xe2, 0x75, 0x36, 0xb5, 0xcb, 0x68, 0x6d, 0x97, 0xd3, 0x39, 0x8d, 0x53, 0x2d, 0xb1, 0xe0, 0xb9,
	0x0c, 0x08, 0xec, 0x64, 0xa9, 0x67, 0x77, 0x00, 0x90, 0x0a, 0xa5, 0x2a, 0xc4, 0x48, 0x11, 0xe7,
	0xb6, 0x4e, 0x68, 0x6f, 0x29, 0xa1, 0x33, 0x95, 0x52, 0x16, 0x97, 0x11, 0x69, 0xfc, 0x3b, 0xa4,
	0x88, 0xfd, 0x0a, 0x6c, 0x11, 0x86, 0x0b, 0x6a, 0x7d, 0x0d, 0xea, 0x1d, 0xc2, 0xb0, 0x26, 0x5e,
	0x00, 0x3b, 0x12, 0x51, 0x38, 0xa6, 0x38, 0x14, 0x9c, 0x32, 0x15, 0x4e, 0xa8, 0x54, 0xce, 0x96,
	0x96, 0x78, 0xbd, 0x32, 0x83, 0xe2, 0xc7, 0x86, 0xc7, 0x22, 0xea, 0x52, 0x3c, 0xdb, 0x69, 0x3f,
	0x57, 0xf8, 0x44, 0xa5, 0xfa, 0x70, 0x2b, 0xb8, 0x1f, 0xe9, 0xa1, 0x69, 0x15, 0x4e, 0xd3, 0x45,
	0x27, 0xb0, 0xae, 0xd3, 0xf4, 0x3a, 0xa7, 0xe9, 0x7f, 0x4e, 0x5f, 0xc1, 0x23, 0x85, 0xd2, 0x98,
	0xa8, 0x30, 0x12, 0x68, 0xde, 0xac, 0xa1, 0xcd, 0xde, 0xdc, 0x64, 0x36, 0xd0, 0xe4, 0x63, 0x81,
	0xae, 0xf6, 0xb3, 0x55, 0x35, 0x37, 0xdd, 0xee, 0x0e, 0x00, 0x33, 0x9f, 0xee, 0xf7, 0x1a, 0x38,
	0x88, 0x78, 0x02, 0x6f, 0x7c, 0x3a, 0xba, 0x8f, 0x97, 0xee, 0x53, 0x3f, 0x3f, 0xae, 0xbe, 0xf5,
	0xe5, 0x63, 0x49, 0x8e, 0xf9, 0x04, 0xb1, 0x18, 0xf2, 0x34, 0x76, 0x63, 0xc2, 0xf4, 0x61, 0x56,
	0xf7, 0x5d, 0x50, 0x79, 0xcd, 0x9b, 0xd6, 0x31, 0xd5, 0xcf, 0xda, 0x46, 0xcf, 0xf7, 0x7f, 0xd7,
	0xf6, 0x7b, 0x85, 0xa4, 0x8f, 0x25, 0x2c, 0xca, 0xbc, 0x1a, 0xb6, 0x61, 0x50, 0x21, 0xff, 0x54,
	0x98, 0x91, 0x8f, 0xe5, 0xc8, 0x60, 0x46, 0xc3, 0xf6, 0xc8, 0x60, 0xfe, 0xd6, 0x0e, 0x8a, 0x81,
	0xe7, 0xf9, 0x58, 0x7a, 0x9e, 0x41, 0x79, 0xde, 0xb0, 0xed, 0x79, 0x06, 0x37, 0xae, 0xeb, 0xc5,
	0x1e, 0xfd, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x88, 0x3e, 0x0c, 0x11, 0x7f, 0x05, 0x00, 0x00,
}
