// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/resources/ad_group_simulation.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An ad group simulation. Supported combinations of advertising
// channel type, simulation type and simulation modification method is
// detailed below respectively.
//
// SEARCH   CPC_BID     DEFAULT
// SEARCH   CPC_BID     UNIFORM
// SEARCH   TARGET_CPA  UNIFORM
// DISPLAY  CPC_BID     DEFAULT
// DISPLAY  CPC_BID     UNIFORM
// DISPLAY  TARGET_CPA  UNIFORM
// VIDEO    CPV_BID     DEFAULT
// VIDEO    CPV_BID     UNIFORM
type AdGroupSimulation struct {
	// The resource name of the ad group simulation.
	// Ad group simulation resource names have the form:
	//
	// `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Ad group id of the simulation.
	AdGroupId *wrappers.Int64Value `protobuf:"bytes,2,opt,name=ad_group_id,json=adGroupId,proto3" json:"ad_group_id,omitempty"`
	// The field that the simulation modifies.
	Type enums.SimulationTypeEnum_SimulationType `protobuf:"varint,3,opt,name=type,proto3,enum=google.ads.googleads.v2.enums.SimulationTypeEnum_SimulationType" json:"type,omitempty"`
	// How the simulation modifies the field.
	ModificationMethod enums.SimulationModificationMethodEnum_SimulationModificationMethod `protobuf:"varint,4,opt,name=modification_method,json=modificationMethod,proto3,enum=google.ads.googleads.v2.enums.SimulationModificationMethodEnum_SimulationModificationMethod" json:"modification_method,omitempty"`
	// First day on which the simulation is based, in YYYY-MM-DD format.
	StartDate *wrappers.StringValue `protobuf:"bytes,5,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Last day on which the simulation is based, in YYYY-MM-DD format
	EndDate *wrappers.StringValue `protobuf:"bytes,6,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// List of simulation points.
	//
	// Types that are valid to be assigned to PointList:
	//	*AdGroupSimulation_CpcBidPointList
	//	*AdGroupSimulation_CpvBidPointList
	//	*AdGroupSimulation_TargetCpaPointList
	PointList            isAdGroupSimulation_PointList `protobuf_oneof:"point_list"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AdGroupSimulation) Reset()         { *m = AdGroupSimulation{} }
func (m *AdGroupSimulation) String() string { return proto.CompactTextString(m) }
func (*AdGroupSimulation) ProtoMessage()    {}
func (*AdGroupSimulation) Descriptor() ([]byte, []int) {
	return fileDescriptor_b65db7c3498c5238, []int{0}
}

func (m *AdGroupSimulation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupSimulation.Unmarshal(m, b)
}
func (m *AdGroupSimulation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupSimulation.Marshal(b, m, deterministic)
}
func (m *AdGroupSimulation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupSimulation.Merge(m, src)
}
func (m *AdGroupSimulation) XXX_Size() int {
	return xxx_messageInfo_AdGroupSimulation.Size(m)
}
func (m *AdGroupSimulation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupSimulation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupSimulation proto.InternalMessageInfo

func (m *AdGroupSimulation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupSimulation) GetAdGroupId() *wrappers.Int64Value {
	if m != nil {
		return m.AdGroupId
	}
	return nil
}

func (m *AdGroupSimulation) GetType() enums.SimulationTypeEnum_SimulationType {
	if m != nil {
		return m.Type
	}
	return enums.SimulationTypeEnum_UNSPECIFIED
}

func (m *AdGroupSimulation) GetModificationMethod() enums.SimulationModificationMethodEnum_SimulationModificationMethod {
	if m != nil {
		return m.ModificationMethod
	}
	return enums.SimulationModificationMethodEnum_UNSPECIFIED
}

func (m *AdGroupSimulation) GetStartDate() *wrappers.StringValue {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *AdGroupSimulation) GetEndDate() *wrappers.StringValue {
	if m != nil {
		return m.EndDate
	}
	return nil
}

type isAdGroupSimulation_PointList interface {
	isAdGroupSimulation_PointList()
}

type AdGroupSimulation_CpcBidPointList struct {
	CpcBidPointList *common.CpcBidSimulationPointList `protobuf:"bytes,8,opt,name=cpc_bid_point_list,json=cpcBidPointList,proto3,oneof"`
}

type AdGroupSimulation_CpvBidPointList struct {
	CpvBidPointList *common.CpvBidSimulationPointList `protobuf:"bytes,10,opt,name=cpv_bid_point_list,json=cpvBidPointList,proto3,oneof"`
}

type AdGroupSimulation_TargetCpaPointList struct {
	TargetCpaPointList *common.TargetCpaSimulationPointList `protobuf:"bytes,9,opt,name=target_cpa_point_list,json=targetCpaPointList,proto3,oneof"`
}

func (*AdGroupSimulation_CpcBidPointList) isAdGroupSimulation_PointList() {}

func (*AdGroupSimulation_CpvBidPointList) isAdGroupSimulation_PointList() {}

func (*AdGroupSimulation_TargetCpaPointList) isAdGroupSimulation_PointList() {}

func (m *AdGroupSimulation) GetPointList() isAdGroupSimulation_PointList {
	if m != nil {
		return m.PointList
	}
	return nil
}

func (m *AdGroupSimulation) GetCpcBidPointList() *common.CpcBidSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_CpcBidPointList); ok {
		return x.CpcBidPointList
	}
	return nil
}

func (m *AdGroupSimulation) GetCpvBidPointList() *common.CpvBidSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_CpvBidPointList); ok {
		return x.CpvBidPointList
	}
	return nil
}

func (m *AdGroupSimulation) GetTargetCpaPointList() *common.TargetCpaSimulationPointList {
	if x, ok := m.GetPointList().(*AdGroupSimulation_TargetCpaPointList); ok {
		return x.TargetCpaPointList
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupSimulation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupSimulation_CpcBidPointList)(nil),
		(*AdGroupSimulation_CpvBidPointList)(nil),
		(*AdGroupSimulation_TargetCpaPointList)(nil),
	}
}

func init() {
	proto.RegisterType((*AdGroupSimulation)(nil), "google.ads.googleads.v2.resources.AdGroupSimulation")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/resources/ad_group_simulation.proto", fileDescriptor_b65db7c3498c5238)
}

var fileDescriptor_b65db7c3498c5238 = []byte{
	// 574 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x54, 0xcf, 0x6e, 0xd3, 0x30,
	0x18, 0x27, 0xdd, 0x18, 0xab, 0x37, 0x40, 0x04, 0x81, 0xa2, 0x31, 0xa1, 0x0e, 0x34, 0xa9, 0x27,
	0x47, 0xca, 0x10, 0x88, 0x94, 0x03, 0xe9, 0x40, 0x65, 0x88, 0xa1, 0x2a, 0xab, 0x7a, 0x40, 0x95,
	0x22, 0x37, 0xf6, 0x32, 0x4b, 0x8d, 0x6d, 0x62, 0xa7, 0x68, 0x67, 0xce, 0xbc, 0x04, 0x07, 0x0e,
	0x3c, 0x0a, 0x8f, 0xc2, 0x53, 0xa0, 0x38, 0x89, 0x5b, 0xda, 0x75, 0xeb, 0xed, 0xcb, 0xf7, 0xfd,
	0xfe, 0xd8, 0x3f, 0xc7, 0x06, 0x9d, 0x84, 0xf3, 0x64, 0x42, 0x5c, 0x84, 0xa5, 0x5b, 0x96, 0x45,
	0x35, 0xf5, 0xdc, 0x8c, 0x48, 0x9e, 0x67, 0x31, 0x91, 0x2e, 0xc2, 0x51, 0x92, 0xf1, 0x5c, 0x44,
	0x92, 0xa6, 0xf9, 0x04, 0x29, 0xca, 0x19, 0x14, 0x19, 0x57, 0xdc, 0x3e, 0x28, 0x19, 0x10, 0x61,
	0x09, 0x0d, 0x19, 0x4e, 0x3d, 0x68, 0xc8, 0x7b, 0xee, 0x2a, 0xfd, 0x98, 0xa7, 0x29, 0x67, 0xee,
	0xa2, 0xe6, 0x5e, 0x77, 0x15, 0x81, 0xb0, 0x3c, 0x95, 0x73, 0xf8, 0x28, 0xe5, 0x98, 0x9e, 0xd3,
	0xb8, 0xfa, 0x20, 0xea, 0x82, 0xe3, 0x4a, 0xe3, 0x68, 0x6d, 0x0d, 0x75, 0x29, 0x48, 0x45, 0x7a,
	0x5a, 0x91, 0xf4, 0xd7, 0x38, 0x3f, 0x77, 0xbf, 0x65, 0x48, 0x08, 0x92, 0xc9, 0x6a, 0xbe, 0x5f,
	0x8b, 0x0a, 0xea, 0x22, 0xc6, 0xb8, 0xd2, 0x0a, 0xd5, 0xf4, 0xd9, 0xaf, 0x2d, 0xf0, 0x20, 0xc0,
	0xbd, 0x22, 0xa7, 0x33, 0x23, 0x6f, 0x3f, 0x07, 0x77, 0xeb, 0x28, 0x22, 0x86, 0x52, 0xe2, 0x58,
	0x2d, 0xab, 0xdd, 0x0c, 0x77, 0xeb, 0xe6, 0x67, 0x94, 0x12, 0xbb, 0x03, 0x76, 0x4c, 0xc4, 0x14,
	0x3b, 0x8d, 0x96, 0xd5, 0xde, 0xf1, 0x9e, 0x54, 0x81, 0xc2, 0x7a, 0x39, 0xf0, 0x84, 0xa9, 0x97,
	0x2f, 0x86, 0x68, 0x92, 0x93, 0xb0, 0x89, 0x4a, 0xa7, 0x13, 0x6c, 0x0f, 0xc0, 0x66, 0xb1, 0x07,
	0x67, 0xa3, 0x65, 0xb5, 0xef, 0x79, 0x6f, 0xe1, 0xaa, 0x13, 0xd1, 0x3b, 0x87, 0xb3, 0xa5, 0x0d,
	0x2e, 0x05, 0x79, 0xcf, 0xf2, 0x74, 0xa1, 0x15, 0x6a, 0x35, 0xfb, 0x87, 0x05, 0x1e, 0x5e, 0x11,
	0xaf, 0xb3, 0xa9, 0x5d, 0x46, 0x6b, 0xbb, 0x9c, 0xce, 0x69, 0x9c, 0x6a, 0x89, 0x05, 0xcf, 0x65,
	0x40, 0x68, 0xa7, 0x4b, 0x3d, 0xbb, 0x03, 0x80, 0x54, 0x28, 0x53, 0x11, 0x46, 0x8a, 0x38, 0xb7,
	0x75, 0x42, 0xfb, 0x4b, 0x09, 0x9d, 0xa9, 0x8c, 0xb2, 0xa4, 0x8a, 0x48, 0xe3, 0xdf, 0x21, 0x45,
	0xec, 0x57, 0x60, 0x9b, 0x30, 0x5c, 0x52, 0xb7, 0xd6, 0xa0, 0xde, 0x21, 0x0c, 0x6b, 0xe2, 0x05,
	0xb0, 0x63, 0x11, 0x47, 0x63, 0x8a, 0x23, 0xc1, 0x29, 0x53, 0xd1, 0x84, 0x4a, 0xe5, 0x6c, 0x6b,
	0x89, 0xd7, 0x2b, 0x33, 0x28, 0x7f, 0x6c, 0x78, 0x2c, 0xe2, 0x2e, 0xc5, 0xb3, 0x9d, 0xf6, 0x0b,
	0x85, 0x4f, 0x54, 0xaa, 0x0f, 0xb7, 0xc2, 0xfb, 0xb1, 0x1e, 0x9a, 0x56, 0xe9, 0x34, 0x5d, 0x74,
	0x02, 0xeb, 0x3a, 0x4d, 0xaf, 0x73, 0x9a, 0xfe, 0xe7, 0xf4, 0x15, 0x3c, 0x52, 0x28, 0x4b, 0x88,
	0x8a, 0x62, 0x81, 0xe6, 0xcd, 0x9a, 0xda, 0xec, 0xcd, 0x4d, 0x66, 0x03, 0x4d, 0x3e, 0x16, 0xe8,
	0x6a, 0x3f, 0x5b, 0xd5, 0x73, 0xd3, 0xed, 0xee, 0x02, 0x30, 0xf3, 0xe9, 0x7e, 0x6f, 0x80, 0xc3,
	0x98, 0xa7, 0xf0, 0xc6, 0xa7, 0xa3, 0xfb, 0x78, 0xe9, 0x3e, 0xf5, 0x8b, 0xe3, 0xea, 0x5b, 0x5f,
	0x3e, 0x56, 0xe4, 0x84, 0x4f, 0x10, 0x4b, 0x20, 0xcf, 0x12, 0x37, 0x21, 0x4c, 0x1f, 0x66, 0x7d,
	0xdf, 0x05, 0x95, 0xd7, 0xbc, 0x69, 0x1d, 0x53, 0xfd, 0x6c, 0x6c, 0xf4, 0x82, 0xe0, 0x77, 0xe3,
	0xa0, 0x57, 0x4a, 0x06, 0x58, 0xc2, 0xb2, 0x2c, 0xaa, 0xa1, 0x07, 0xc3, 0x1a, 0xf9, 0xa7, 0xc6,
	0x8c, 0x02, 0x2c, 0x47, 0x06, 0x33, 0x1a, 0x7a, 0x23, 0x83, 0xf9, 0xdb, 0x38, 0x2c, 0x07, 0xbe,
	0x1f, 0x60, 0xe9, 0xfb, 0x06, 0xe5, 0xfb, 0x43, 0xcf, 0xf7, 0x0d, 0x6e, 0xbc, 0xa5, 0x17, 0x7b,
	0xf4, 0x2f, 0x00, 0x00, 0xff, 0xff, 0xdb, 0x6c, 0xe2, 0xae, 0x7f, 0x05, 0x00, 0x00,
}
