// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommender/v1beta1/recommender_service.proto

package recommender

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request for the `ListRecommendations` method.
type ListRecommendationsRequest struct {
	// Required. The container resource on which to execute the request.
	// Acceptable formats:
	//
	// 1.
	// "projects/[PROJECT_NUMBER]/locations/[LOCATION]/recommenders/[RECOMMENDER_ID]",
	//
	// LOCATION here refers to GCP Locations:
	// https://cloud.google.com/about/locations/
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of results to return from this request.  Non-positive
	// values are ignored. If not specified, the server will determine the number
	// of results to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, retrieves the next batch of results from the preceding call to
	// this method. `page_token` must be the value of `next_page_token` from the
	// previous response. The values of other method parameters must be identical
	// to those in the previous call.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter expression to restrict the recommendations returned. Supported
	// filter fields: state_info.state
	// Eg: `state_info.state:"DISMISSED" or state_info.state:"FAILED"
	Filter               string   `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRecommendationsRequest) Reset()         { *m = ListRecommendationsRequest{} }
func (m *ListRecommendationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListRecommendationsRequest) ProtoMessage()    {}
func (*ListRecommendationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{0}
}

func (m *ListRecommendationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRecommendationsRequest.Unmarshal(m, b)
}
func (m *ListRecommendationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRecommendationsRequest.Marshal(b, m, deterministic)
}
func (m *ListRecommendationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRecommendationsRequest.Merge(m, src)
}
func (m *ListRecommendationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListRecommendationsRequest.Size(m)
}
func (m *ListRecommendationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRecommendationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRecommendationsRequest proto.InternalMessageInfo

func (m *ListRecommendationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListRecommendationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListRecommendationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListRecommendationsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Response to the `ListRecommendations` method.
type ListRecommendationsResponse struct {
	// The set of recommendations for the `parent` resource.
	Recommendations []*Recommendation `protobuf:"bytes,1,rep,name=recommendations,proto3" json:"recommendations,omitempty"`
	// A token that can be used to request the next page of results. This field is
	// empty if there are no additional results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRecommendationsResponse) Reset()         { *m = ListRecommendationsResponse{} }
func (m *ListRecommendationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListRecommendationsResponse) ProtoMessage()    {}
func (*ListRecommendationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{1}
}

func (m *ListRecommendationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRecommendationsResponse.Unmarshal(m, b)
}
func (m *ListRecommendationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRecommendationsResponse.Marshal(b, m, deterministic)
}
func (m *ListRecommendationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRecommendationsResponse.Merge(m, src)
}
func (m *ListRecommendationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListRecommendationsResponse.Size(m)
}
func (m *ListRecommendationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRecommendationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRecommendationsResponse proto.InternalMessageInfo

func (m *ListRecommendationsResponse) GetRecommendations() []*Recommendation {
	if m != nil {
		return m.Recommendations
	}
	return nil
}

func (m *ListRecommendationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to the `GetRecommendation` method.
type GetRecommendationRequest struct {
	// Required. Name of the recommendation.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRecommendationRequest) Reset()         { *m = GetRecommendationRequest{} }
func (m *GetRecommendationRequest) String() string { return proto.CompactTextString(m) }
func (*GetRecommendationRequest) ProtoMessage()    {}
func (*GetRecommendationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{2}
}

func (m *GetRecommendationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRecommendationRequest.Unmarshal(m, b)
}
func (m *GetRecommendationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRecommendationRequest.Marshal(b, m, deterministic)
}
func (m *GetRecommendationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRecommendationRequest.Merge(m, src)
}
func (m *GetRecommendationRequest) XXX_Size() int {
	return xxx_messageInfo_GetRecommendationRequest.Size(m)
}
func (m *GetRecommendationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRecommendationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRecommendationRequest proto.InternalMessageInfo

func (m *GetRecommendationRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the `MarkRecommendationClaimed` Method.
type MarkRecommendationClaimedRequest struct {
	// Required. Name of the recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// State properties to include with this state. Overwrites any existing
	// `state_metadata`.
	// Keys must match the regex /^[a-z0-9][a-z0-9_.-]{0,62}$/.
	// Values must match the regex /^[a-zA-Z0-9_./-]{0,255}$/.
	StateMetadata map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Fingerprint of the Recommendation. Provides optimistic locking.
	Etag                 string   `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MarkRecommendationClaimedRequest) Reset()         { *m = MarkRecommendationClaimedRequest{} }
func (m *MarkRecommendationClaimedRequest) String() string { return proto.CompactTextString(m) }
func (*MarkRecommendationClaimedRequest) ProtoMessage()    {}
func (*MarkRecommendationClaimedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{3}
}

func (m *MarkRecommendationClaimedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MarkRecommendationClaimedRequest.Unmarshal(m, b)
}
func (m *MarkRecommendationClaimedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MarkRecommendationClaimedRequest.Marshal(b, m, deterministic)
}
func (m *MarkRecommendationClaimedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarkRecommendationClaimedRequest.Merge(m, src)
}
func (m *MarkRecommendationClaimedRequest) XXX_Size() int {
	return xxx_messageInfo_MarkRecommendationClaimedRequest.Size(m)
}
func (m *MarkRecommendationClaimedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MarkRecommendationClaimedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MarkRecommendationClaimedRequest proto.InternalMessageInfo

func (m *MarkRecommendationClaimedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MarkRecommendationClaimedRequest) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func (m *MarkRecommendationClaimedRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Request for the `MarkRecommendationSucceeded` Method.
type MarkRecommendationSucceededRequest struct {
	// Required. Name of the recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// State properties to include with this state. Overwrites any existing
	// `state_metadata`.
	// Keys must match the regex /^[a-z0-9][a-z0-9_.-]{0,62}$/.
	// Values must match the regex /^[a-zA-Z0-9_./-]{0,255}$/.
	StateMetadata map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Fingerprint of the Recommendation. Provides optimistic locking.
	Etag                 string   `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MarkRecommendationSucceededRequest) Reset()         { *m = MarkRecommendationSucceededRequest{} }
func (m *MarkRecommendationSucceededRequest) String() string { return proto.CompactTextString(m) }
func (*MarkRecommendationSucceededRequest) ProtoMessage()    {}
func (*MarkRecommendationSucceededRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{4}
}

func (m *MarkRecommendationSucceededRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MarkRecommendationSucceededRequest.Unmarshal(m, b)
}
func (m *MarkRecommendationSucceededRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MarkRecommendationSucceededRequest.Marshal(b, m, deterministic)
}
func (m *MarkRecommendationSucceededRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarkRecommendationSucceededRequest.Merge(m, src)
}
func (m *MarkRecommendationSucceededRequest) XXX_Size() int {
	return xxx_messageInfo_MarkRecommendationSucceededRequest.Size(m)
}
func (m *MarkRecommendationSucceededRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MarkRecommendationSucceededRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MarkRecommendationSucceededRequest proto.InternalMessageInfo

func (m *MarkRecommendationSucceededRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MarkRecommendationSucceededRequest) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func (m *MarkRecommendationSucceededRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// Request for the `MarkRecommendationFailed` Method.
type MarkRecommendationFailedRequest struct {
	// Required. Name of the recommendation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// State properties to include with this state. Overwrites any existing
	// `state_metadata`.
	// Keys must match the regex /^[a-z0-9][a-z0-9_.-]{0,62}$/.
	// Values must match the regex /^[a-zA-Z0-9_./-]{0,255}$/.
	StateMetadata map[string]string `protobuf:"bytes,2,rep,name=state_metadata,json=stateMetadata,proto3" json:"state_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Fingerprint of the Recommendation. Provides optimistic locking.
	Etag                 string   `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MarkRecommendationFailedRequest) Reset()         { *m = MarkRecommendationFailedRequest{} }
func (m *MarkRecommendationFailedRequest) String() string { return proto.CompactTextString(m) }
func (*MarkRecommendationFailedRequest) ProtoMessage()    {}
func (*MarkRecommendationFailedRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0ca265e4ecfbc6d8, []int{5}
}

func (m *MarkRecommendationFailedRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MarkRecommendationFailedRequest.Unmarshal(m, b)
}
func (m *MarkRecommendationFailedRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MarkRecommendationFailedRequest.Marshal(b, m, deterministic)
}
func (m *MarkRecommendationFailedRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MarkRecommendationFailedRequest.Merge(m, src)
}
func (m *MarkRecommendationFailedRequest) XXX_Size() int {
	return xxx_messageInfo_MarkRecommendationFailedRequest.Size(m)
}
func (m *MarkRecommendationFailedRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MarkRecommendationFailedRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MarkRecommendationFailedRequest proto.InternalMessageInfo

func (m *MarkRecommendationFailedRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MarkRecommendationFailedRequest) GetStateMetadata() map[string]string {
	if m != nil {
		return m.StateMetadata
	}
	return nil
}

func (m *MarkRecommendationFailedRequest) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func init() {
	proto.RegisterType((*ListRecommendationsRequest)(nil), "google.cloud.recommender.v1beta1.ListRecommendationsRequest")
	proto.RegisterType((*ListRecommendationsResponse)(nil), "google.cloud.recommender.v1beta1.ListRecommendationsResponse")
	proto.RegisterType((*GetRecommendationRequest)(nil), "google.cloud.recommender.v1beta1.GetRecommendationRequest")
	proto.RegisterType((*MarkRecommendationClaimedRequest)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationClaimedRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationClaimedRequest.StateMetadataEntry")
	proto.RegisterType((*MarkRecommendationSucceededRequest)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationSucceededRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationSucceededRequest.StateMetadataEntry")
	proto.RegisterType((*MarkRecommendationFailedRequest)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationFailedRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommender.v1beta1.MarkRecommendationFailedRequest.StateMetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/recommender/v1beta1/recommender_service.proto", fileDescriptor_0ca265e4ecfbc6d8)
}

var fileDescriptor_0ca265e4ecfbc6d8 = []byte{
	// 863 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x56, 0x4d, 0x6f, 0xeb, 0x44,
	0x14, 0x95, 0x9d, 0xb6, 0xe2, 0xcd, 0x53, 0x79, 0x8f, 0x01, 0xf1, 0xfc, 0xfc, 0x90, 0x1a, 0x59,
	0xa8, 0x0a, 0xa1, 0xd8, 0xa4, 0x08, 0x09, 0x05, 0x2a, 0xe1, 0x84, 0xb6, 0x42, 0x50, 0x54, 0x39,
	0xfd, 0x40, 0xdd, 0x44, 0x53, 0xe7, 0xd6, 0x35, 0xb1, 0x3d, 0xc6, 0x33, 0x49, 0xbf, 0x28, 0x0b,
	0x76, 0x48, 0xac, 0xe0, 0x17, 0xc0, 0x92, 0x1d, 0xff, 0x00, 0x75, 0xc1, 0x82, 0x25, 0xac, 0xe8,
	0x86, 0x2e, 0xf8, 0x07, 0xec, 0x58, 0x21, 0x8f, 0xdd, 0xd6, 0x49, 0x6a, 0x5c, 0xd2, 0x48, 0xdd,
	0xc5, 0xf7, 0xce, 0xb9, 0x73, 0xce, 0xb1, 0x73, 0x66, 0x50, 0xdd, 0xa1, 0xd4, 0xf1, 0xc0, 0xb0,
	0x3d, 0xda, 0xeb, 0x18, 0x11, 0xd8, 0xd4, 0xf7, 0x21, 0xe8, 0x40, 0x64, 0xf4, 0x6b, 0xbb, 0xc0,
	0x49, 0x2d, 0x5b, 0x6b, 0x33, 0x88, 0xfa, 0xae, 0x0d, 0x7a, 0x18, 0x51, 0x4e, 0x71, 0x39, 0xc1,
	0xea, 0x02, 0xab, 0x67, 0xd6, 0xe9, 0x29, 0x56, 0x7d, 0x25, 0x9d, 0x4e, 0x42, 0xd7, 0x20, 0x41,
	0x40, 0x39, 0xe1, 0x2e, 0x0d, 0x58, 0x82, 0x57, 0x9f, 0x64, 0xba, 0xb6, 0xe7, 0x42, 0xc0, 0xd3,
	0xc6, 0x5c, 0xa6, 0xb1, 0xe7, 0x82, 0xd7, 0x69, 0xef, 0xc2, 0x3e, 0xe9, 0xbb, 0x34, 0x4a, 0x17,
	0x3c, 0xcd, 0x2c, 0x88, 0x80, 0xd1, 0x5e, 0x74, 0x49, 0x4a, 0x7d, 0xfb, 0xf6, 0x82, 0x04, 0x99,
	0x04, 0xa6, 0x9d, 0x49, 0x48, 0xfd, 0xd8, 0x65, 0xdc, 0x1a, 0x68, 0x32, 0x0b, 0x3e, 0xef, 0x01,
	0xe3, 0x78, 0x05, 0xcd, 0x84, 0x24, 0x82, 0x80, 0x2b, 0x52, 0x59, 0xaa, 0x3c, 0x68, 0xe8, 0x17,
	0xa6, 0xfc, 0x8f, 0x59, 0x41, 0xf3, 0x59, 0xd5, 0xc9, 0xce, 0x24, 0x74, 0x99, 0x6e, 0x53, 0xdf,
	0xb0, 0xae, 0x5b, 0x56, 0x8a, 0xc6, 0x65, 0xf4, 0x20, 0x24, 0x0e, 0xb4, 0x99, 0x7b, 0x0c, 0x8a,
	0x5c, 0x96, 0x2a, 0xd3, 0x8d, 0xd2, 0x85, 0x29, 0x59, 0xcf, 0xc5, 0xd5, 0x96, 0x7b, 0x0c, 0x58,
	0x43, 0x48, 0xac, 0xe0, 0xb4, 0x0b, 0x81, 0x52, 0x12, 0xbb, 0x89, 0x25, 0x02, 0xb8, 0x11, 0x57,
	0xf1, 0xcb, 0x68, 0x66, 0xcf, 0xf5, 0x38, 0x44, 0xca, 0x74, 0xdc, 0xb7, 0xd2, 0x27, 0xed, 0x7b,
	0x09, 0x3d, 0xbb, 0x51, 0x04, 0x0b, 0x69, 0xc0, 0x00, 0xef, 0xa0, 0x47, 0x83, 0xe2, 0x99, 0x22,
	0x95, 0x4b, 0x95, 0x87, 0x8b, 0x6f, 0xea, 0x45, 0xaf, 0x52, 0x1f, 0x9c, 0x69, 0x0d, 0x0f, 0xc2,
	0xf3, 0xe8, 0x51, 0x00, 0x87, 0xbc, 0x9d, 0x21, 0x2f, 0x0b, 0x72, 0xb3, 0x71, 0x79, 0xfd, 0x92,
	0xbb, 0x46, 0x90, 0xb2, 0x0a, 0x43, 0x0c, 0x2f, 0x5d, 0x5e, 0x46, 0x53, 0x01, 0xf1, 0x21, 0xf5,
	0xb8, 0x26, 0x3c, 0x7e, 0x1d, 0xbd, 0x76, 0x1b, 0x8f, 0x93, 0x39, 0x02, 0xae, 0x9d, 0xc9, 0xa8,
	0xbc, 0x46, 0xa2, 0xee, 0x60, 0xb3, 0xe9, 0x11, 0xd7, 0x87, 0xce, 0x64, 0xf7, 0xc2, 0x5f, 0xa0,
	0xe7, 0x19, 0x27, 0x1c, 0xda, 0x3e, 0x70, 0xd2, 0x21, 0x9c, 0x28, 0xb2, 0x70, 0x74, 0xb3, 0xd8,
	0xd1, 0x22, 0x8a, 0x7a, 0x2b, 0x1e, 0xbc, 0x96, 0xce, 0x5d, 0x0e, 0x78, 0x74, 0x64, 0xcd, 0xb2,
	0x6c, 0x0d, 0x3f, 0x41, 0x53, 0xc0, 0x89, 0x73, 0xfd, 0x99, 0xc8, 0x96, 0x28, 0xa8, 0xef, 0x23,
	0x3c, 0x8a, 0xc6, 0x8f, 0x51, 0xa9, 0x0b, 0x47, 0x89, 0x64, 0x2b, 0xfe, 0x89, 0x5f, 0x42, 0xd3,
	0x7d, 0xe2, 0xf5, 0x20, 0x7d, 0x57, 0xc9, 0x43, 0x5d, 0x7e, 0x47, 0xd2, 0x7e, 0x91, 0x91, 0x36,
	0xca, 0xb0, 0xd5, 0xb3, 0x6d, 0x80, 0xce, 0xc4, 0x6d, 0xfc, 0x32, 0xc7, 0xc6, 0xed, 0x71, 0x6c,
	0x1c, 0x26, 0x79, 0xbf, 0x46, 0xfe, 0x2c, 0xa3, 0xb9, 0x51, 0x8e, 0x2b, 0xc4, 0xf5, 0x26, 0xee,
	0xe2, 0x49, 0x8e, 0x8b, 0x1b, 0xe3, 0xb8, 0x38, 0xc0, 0xf0, 0x5e, 0x2d, 0x5c, 0xfc, 0x13, 0xa1,
	0x87, 0x99, 0x34, 0xc5, 0x7f, 0x4b, 0xe8, 0xc5, 0x1b, 0x72, 0x0e, 0xbf, 0x57, 0xac, 0x33, 0x3f,
	0xe3, 0xd5, 0xa5, 0x31, 0xd1, 0x49, 0xb8, 0x6a, 0xed, 0x73, 0x73, 0x36, 0x49, 0xf9, 0x85, 0x24,
	0x8e, 0xbf, 0xfa, 0xfd, 0xaf, 0xef, 0xe4, 0x0f, 0xf1, 0xea, 0xd5, 0xc1, 0x73, 0x92, 0xb4, 0x97,
	0xc2, 0x88, 0x7e, 0x06, 0x36, 0x67, 0x46, 0xd5, 0xf0, 0xa8, 0x9d, 0x8c, 0x31, 0xaa, 0xd9, 0xb3,
	0x8a, 0x19, 0xd5, 0x53, 0x63, 0x38, 0x61, 0xff, 0x90, 0xd0, 0x0b, 0x23, 0xd1, 0x89, 0xeb, 0xc5,
	0xac, 0xf3, 0xf2, 0x56, 0xfd, 0xdf, 0xb1, 0xaf, 0x6d, 0x9d, 0x9b, 0xe2, 0x53, 0x1b, 0xd5, 0x16,
	0x57, 0x6f, 0xa7, 0x6c, 0x58, 0x98, 0x51, 0x3d, 0xc5, 0xdf, 0xc8, 0xe8, 0x69, 0x6e, 0x1e, 0xe2,
	0xc6, 0xdd, 0xc3, 0x74, 0x0c, 0xad, 0x47, 0xe7, 0xa6, 0x12, 0xab, 0x5a, 0x18, 0xfc, 0x4f, 0x2d,
	0xc4, 0x1f, 0xb5, 0xd0, 0xff, 0xa9, 0xd6, 0x9a, 0x90, 0xfe, 0xba, 0x4f, 0xa2, 0x6e, 0x4a, 0xb8,
	0x2e, 0x55, 0xf1, 0xb7, 0x32, 0x7a, 0xf6, 0x1f, 0xb9, 0x86, 0x3f, 0x98, 0x44, 0x2c, 0x8e, 0x61,
	0xc9, 0x49, 0x91, 0x25, 0x3b, 0xda, 0xe6, 0x24, 0x2d, 0xb9, 0xa2, 0x1c, 0x9b, 0xf2, 0xb5, 0x8c,
	0x94, 0xbc, 0x98, 0xc2, 0xe6, 0x9d, 0x23, 0x6e, 0x0c, 0x3b, 0x0e, 0x8b, 0xec, 0xd8, 0xd6, 0xac,
	0x49, 0xda, 0x91, 0xf0, 0xad, 0x4b, 0x55, 0xf5, 0x93, 0x5f, 0x4d, 0x35, 0xff, 0x74, 0xf8, 0xcd,
	0xd4, 0xf7, 0x39, 0x0f, 0x59, 0xdd, 0x30, 0x0e, 0x0e, 0x0e, 0x86, 0x8f, 0x0e, 0xd2, 0xe3, 0xfb,
	0xc9, 0xf5, 0xf8, 0x8d, 0xd0, 0x23, 0x7c, 0x8f, 0x46, 0x7e, 0xe3, 0x27, 0x09, 0xbd, 0x6a, 0x53,
	0xbf, 0xd0, 0x81, 0xc6, 0xe3, 0x4c, 0x0e, 0xaf, 0xc7, 0x37, 0xe7, 0x75, 0x69, 0xe7, 0xa3, 0x14,
	0xe5, 0x50, 0x8f, 0x04, 0x8e, 0x4e, 0x23, 0xc7, 0x70, 0x20, 0x10, 0xf7, 0x6a, 0xe3, 0x7a, 0xef,
	0xfc, 0x1b, 0xf9, 0xbb, 0x99, 0xda, 0x0f, 0xf2, 0x54, 0xd3, 0x5a, 0x6e, 0xfe, 0x28, 0x97, 0x57,
	0x93, 0xa1, 0x4d, 0x41, 0x25, 0xb3, 0xab, 0xbe, 0x55, 0x6b, 0xc4, 0xa8, 0xdd, 0x19, 0xb1, 0xc3,
	0x5b, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x07, 0xde, 0x93, 0x0f, 0xc3, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RecommenderClient is the client API for Recommender service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RecommenderClient interface {
	// Lists recommendations for a Cloud project. Requires the recommender.*.list
	// IAM permission for the specified recommender.
	ListRecommendations(ctx context.Context, in *ListRecommendationsRequest, opts ...grpc.CallOption) (*ListRecommendationsResponse, error)
	// Gets the requested recommendation. Requires the recommender.*.get
	// IAM permission for the specified recommender.
	GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Marks the Recommendation State as Claimed. Users can use this method to
	// indicate to the Recommender API that they are starting to apply the
	// recommendation themselves. This stops the recommendation content from being
	// updated. Associated insights are frozen and placed in the ACCEPTED state.
	//
	// MarkRecommendationClaimed can be applied to recommendations in CLAIMED or
	// ACTIVE state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationClaimed(ctx context.Context, in *MarkRecommendationClaimedRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Marks the Recommendation State as Succeeded. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation was successful. This stops the recommendation
	// content from being updated. Associated insights are frozen and placed in
	// the ACCEPTED state.
	//
	// MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationSucceeded(ctx context.Context, in *MarkRecommendationSucceededRequest, opts ...grpc.CallOption) (*Recommendation, error)
	// Marks the Recommendation State as Failed. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation failed. This stops the recommendation content
	// from being updated. Associated insights are frozen and placed in the
	// ACCEPTED state.
	//
	// MarkRecommendationFailed can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationFailed(ctx context.Context, in *MarkRecommendationFailedRequest, opts ...grpc.CallOption) (*Recommendation, error)
}

type recommenderClient struct {
	cc grpc.ClientConnInterface
}

func NewRecommenderClient(cc grpc.ClientConnInterface) RecommenderClient {
	return &recommenderClient{cc}
}

func (c *recommenderClient) ListRecommendations(ctx context.Context, in *ListRecommendationsRequest, opts ...grpc.CallOption) (*ListRecommendationsResponse, error) {
	out := new(ListRecommendationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1beta1.Recommender/ListRecommendations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) GetRecommendation(ctx context.Context, in *GetRecommendationRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1beta1.Recommender/GetRecommendation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationClaimed(ctx context.Context, in *MarkRecommendationClaimedRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationClaimed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationSucceeded(ctx context.Context, in *MarkRecommendationSucceededRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationSucceeded", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *recommenderClient) MarkRecommendationFailed(ctx context.Context, in *MarkRecommendationFailedRequest, opts ...grpc.CallOption) (*Recommendation, error) {
	out := new(Recommendation)
	err := c.cc.Invoke(ctx, "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationFailed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RecommenderServer is the server API for Recommender service.
type RecommenderServer interface {
	// Lists recommendations for a Cloud project. Requires the recommender.*.list
	// IAM permission for the specified recommender.
	ListRecommendations(context.Context, *ListRecommendationsRequest) (*ListRecommendationsResponse, error)
	// Gets the requested recommendation. Requires the recommender.*.get
	// IAM permission for the specified recommender.
	GetRecommendation(context.Context, *GetRecommendationRequest) (*Recommendation, error)
	// Marks the Recommendation State as Claimed. Users can use this method to
	// indicate to the Recommender API that they are starting to apply the
	// recommendation themselves. This stops the recommendation content from being
	// updated. Associated insights are frozen and placed in the ACCEPTED state.
	//
	// MarkRecommendationClaimed can be applied to recommendations in CLAIMED or
	// ACTIVE state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationClaimed(context.Context, *MarkRecommendationClaimedRequest) (*Recommendation, error)
	// Marks the Recommendation State as Succeeded. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation was successful. This stops the recommendation
	// content from being updated. Associated insights are frozen and placed in
	// the ACCEPTED state.
	//
	// MarkRecommendationSucceeded can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationSucceeded(context.Context, *MarkRecommendationSucceededRequest) (*Recommendation, error)
	// Marks the Recommendation State as Failed. Users can use this method to
	// indicate to the Recommender API that they have applied the recommendation
	// themselves, and the operation failed. This stops the recommendation content
	// from being updated. Associated insights are frozen and placed in the
	// ACCEPTED state.
	//
	// MarkRecommendationFailed can be applied to recommendations in ACTIVE,
	// CLAIMED, SUCCEEDED, or FAILED state.
	//
	// Requires the recommender.*.update IAM permission for the specified
	// recommender.
	MarkRecommendationFailed(context.Context, *MarkRecommendationFailedRequest) (*Recommendation, error)
}

// UnimplementedRecommenderServer can be embedded to have forward compatible implementations.
type UnimplementedRecommenderServer struct {
}

func (*UnimplementedRecommenderServer) ListRecommendations(ctx context.Context, req *ListRecommendationsRequest) (*ListRecommendationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRecommendations not implemented")
}
func (*UnimplementedRecommenderServer) GetRecommendation(ctx context.Context, req *GetRecommendationRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecommendation not implemented")
}
func (*UnimplementedRecommenderServer) MarkRecommendationClaimed(ctx context.Context, req *MarkRecommendationClaimedRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationClaimed not implemented")
}
func (*UnimplementedRecommenderServer) MarkRecommendationSucceeded(ctx context.Context, req *MarkRecommendationSucceededRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationSucceeded not implemented")
}
func (*UnimplementedRecommenderServer) MarkRecommendationFailed(ctx context.Context, req *MarkRecommendationFailedRequest) (*Recommendation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MarkRecommendationFailed not implemented")
}

func RegisterRecommenderServer(s *grpc.Server, srv RecommenderServer) {
	s.RegisterService(&_Recommender_serviceDesc, srv)
}

func _Recommender_ListRecommendations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRecommendationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).ListRecommendations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1beta1.Recommender/ListRecommendations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).ListRecommendations(ctx, req.(*ListRecommendationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_GetRecommendation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecommendationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).GetRecommendation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1beta1.Recommender/GetRecommendation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).GetRecommendation(ctx, req.(*GetRecommendationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationClaimed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationClaimedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationClaimed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationClaimed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationClaimed(ctx, req.(*MarkRecommendationClaimedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationSucceeded_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationSucceededRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationSucceeded(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationSucceeded",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationSucceeded(ctx, req.(*MarkRecommendationSucceededRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Recommender_MarkRecommendationFailed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MarkRecommendationFailedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RecommenderServer).MarkRecommendationFailed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommender.v1beta1.Recommender/MarkRecommendationFailed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RecommenderServer).MarkRecommendationFailed(ctx, req.(*MarkRecommendationFailedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Recommender_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommender.v1beta1.Recommender",
	HandlerType: (*RecommenderServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRecommendations",
			Handler:    _Recommender_ListRecommendations_Handler,
		},
		{
			MethodName: "GetRecommendation",
			Handler:    _Recommender_GetRecommendation_Handler,
		},
		{
			MethodName: "MarkRecommendationClaimed",
			Handler:    _Recommender_MarkRecommendationClaimed_Handler,
		},
		{
			MethodName: "MarkRecommendationSucceeded",
			Handler:    _Recommender_MarkRecommendationSucceeded_Handler,
		},
		{
			MethodName: "MarkRecommendationFailed",
			Handler:    _Recommender_MarkRecommendationFailed_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommender/v1beta1/recommender_service.proto",
}
