// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/redis/v1beta1/cloud_redis.proto

package redis

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents the different states of a Redis instance.
type Instance_State int32

const (
	// Not set.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// Redis instance is being created.
	Instance_CREATING Instance_State = 1
	// Redis instance has been created and is fully usable.
	Instance_READY Instance_State = 2
	// Redis instance configuration is being updated. Certain kinds of updates
	// may cause the instance to become unusable while the update is in
	// progress.
	Instance_UPDATING Instance_State = 3
	// Redis instance is being deleted.
	Instance_DELETING Instance_State = 4
	// Redis instance is being repaired and may be unusable.
	Instance_REPAIRING Instance_State = 5
	// Maintenance is being performed on this Redis instance.
	Instance_MAINTENANCE Instance_State = 6
	// Redis instance is importing data (availability may be affected).
	Instance_IMPORTING Instance_State = 8
	// Redis instance is failing over (availability may be affected).
	Instance_FAILING_OVER Instance_State = 10
)

var Instance_State_name = map[int32]string{
	0:  "STATE_UNSPECIFIED",
	1:  "CREATING",
	2:  "READY",
	3:  "UPDATING",
	4:  "DELETING",
	5:  "REPAIRING",
	6:  "MAINTENANCE",
	8:  "IMPORTING",
	10: "FAILING_OVER",
}

var Instance_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"CREATING":          1,
	"READY":             2,
	"UPDATING":          3,
	"DELETING":          4,
	"REPAIRING":         5,
	"MAINTENANCE":       6,
	"IMPORTING":         8,
	"FAILING_OVER":      10,
}

func (x Instance_State) String() string {
	return proto.EnumName(Instance_State_name, int32(x))
}

func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{0, 0}
}

// Available service tiers to choose from
type Instance_Tier int32

const (
	// Not set.
	Instance_TIER_UNSPECIFIED Instance_Tier = 0
	// BASIC tier: standalone instance
	Instance_BASIC Instance_Tier = 1
	// STANDARD_HA tier: highly available primary/replica instances
	Instance_STANDARD_HA Instance_Tier = 3
)

var Instance_Tier_name = map[int32]string{
	0: "TIER_UNSPECIFIED",
	1: "BASIC",
	3: "STANDARD_HA",
}

var Instance_Tier_value = map[string]int32{
	"TIER_UNSPECIFIED": 0,
	"BASIC":            1,
	"STANDARD_HA":      3,
}

func (x Instance_Tier) String() string {
	return proto.EnumName(Instance_Tier_name, int32(x))
}

func (Instance_Tier) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{0, 1}
}

// Available connection modes.
type Instance_ConnectMode int32

const (
	// Not set.
	Instance_CONNECT_MODE_UNSPECIFIED Instance_ConnectMode = 0
	// Connect via directly peering with memorystore redis hosted service.
	Instance_DIRECT_PEERING Instance_ConnectMode = 1
	// Connect with google via private service access and share connection
	// across google managed services.
	Instance_PRIVATE_SERVICE_ACCESS Instance_ConnectMode = 2
)

var Instance_ConnectMode_name = map[int32]string{
	0: "CONNECT_MODE_UNSPECIFIED",
	1: "DIRECT_PEERING",
	2: "PRIVATE_SERVICE_ACCESS",
}

var Instance_ConnectMode_value = map[string]int32{
	"CONNECT_MODE_UNSPECIFIED": 0,
	"DIRECT_PEERING":           1,
	"PRIVATE_SERVICE_ACCESS":   2,
}

func (x Instance_ConnectMode) String() string {
	return proto.EnumName(Instance_ConnectMode_name, int32(x))
}

func (Instance_ConnectMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{0, 2}
}

// Specifies different modes of operation in relation to the data retention.
type FailoverInstanceRequest_DataProtectionMode int32

const (
	// Defaults to LIMITED_DATA_LOSS if a data protection mode is not
	// specified.
	FailoverInstanceRequest_DATA_PROTECTION_MODE_UNSPECIFIED FailoverInstanceRequest_DataProtectionMode = 0
	// Instance failover will be protected with data loss control. More
	// specifically, the failover will only be performed if the current
	// replication offset diff between master and replica is under a certain
	// threshold.
	FailoverInstanceRequest_LIMITED_DATA_LOSS FailoverInstanceRequest_DataProtectionMode = 1
	// Instance failover will be performed without data loss control.
	FailoverInstanceRequest_FORCE_DATA_LOSS FailoverInstanceRequest_DataProtectionMode = 2
)

var FailoverInstanceRequest_DataProtectionMode_name = map[int32]string{
	0: "DATA_PROTECTION_MODE_UNSPECIFIED",
	1: "LIMITED_DATA_LOSS",
	2: "FORCE_DATA_LOSS",
}

var FailoverInstanceRequest_DataProtectionMode_value = map[string]int32{
	"DATA_PROTECTION_MODE_UNSPECIFIED": 0,
	"LIMITED_DATA_LOSS":                1,
	"FORCE_DATA_LOSS":                  2,
}

func (x FailoverInstanceRequest_DataProtectionMode) String() string {
	return proto.EnumName(FailoverInstanceRequest_DataProtectionMode_name, int32(x))
}

func (FailoverInstanceRequest_DataProtectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{14, 0}
}

// A Google Cloud Redis instance.
type Instance struct {
	// Required. Unique name of the resource in this scope including project and
	// location using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	//
	// Note: Redis instances are managed and addressed at regional level so
	// location_id here refers to a GCP region; however, users may choose which
	// specific zone (or collection of zones for cross-zone instances) an instance
	// should be provisioned in. Refer to [location_id][google.cloud.redis.v1beta1.Instance.location_id] and
	// [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] fields for more details.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An arbitrary and optional user-provided name for the instance.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Resource labels to represent user provided metadata
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The zone where the instance will be provisioned. If not provided,
	// the service will choose a zone for the instance. For STANDARD_HA tier,
	// instances will be created across two zones for protection against zonal
	// failures. If [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] is also provided, it must be
	// different from [location_id][google.cloud.redis.v1beta1.Instance.location_id].
	LocationId string `protobuf:"bytes,4,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	// Optional. Only applicable to STANDARD_HA tier which protects the instance
	// against zonal failures by provisioning it across two zones. If provided, it
	// must be a different zone from the one provided in [location_id][google.cloud.redis.v1beta1.Instance.location_id].
	AlternativeLocationId string `protobuf:"bytes,5,opt,name=alternative_location_id,json=alternativeLocationId,proto3" json:"alternative_location_id,omitempty"`
	// Optional. The version of Redis software.
	// If not provided, latest supported version will be used. Currently, the
	// supported values are:
	//
	//  *   `REDIS_4_0` for Redis 4.0 compatibility (default)
	//  *   `REDIS_3_2` for Redis 3.2 compatibility
	RedisVersion string `protobuf:"bytes,7,opt,name=redis_version,json=redisVersion,proto3" json:"redis_version,omitempty"`
	// Optional. The CIDR range of internal addresses that are reserved for this
	// instance. If not provided, the service will choose an unused /29 block,
	// for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be unique
	// and non-overlapping with existing subnets in an authorized network.
	ReservedIpRange string `protobuf:"bytes,9,opt,name=reserved_ip_range,json=reservedIpRange,proto3" json:"reserved_ip_range,omitempty"`
	// Output only. Hostname or IP address of the exposed Redis endpoint used by
	// clients to connect to the service.
	Host string `protobuf:"bytes,10,opt,name=host,proto3" json:"host,omitempty"`
	// Output only. The port number of the exposed Redis endpoint.
	Port int32 `protobuf:"varint,11,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. The current zone where the Redis endpoint is placed. For Basic
	// Tier instances, this will always be the same as the [location_id][google.cloud.redis.v1beta1.Instance.location_id]
	// provided by the user at creation time. For Standard Tier instances,
	// this can be either [location_id][google.cloud.redis.v1beta1.Instance.location_id] or [alternative_location_id][google.cloud.redis.v1beta1.Instance.alternative_location_id] and can
	// change after a failover event.
	CurrentLocationId string `protobuf:"bytes,12,opt,name=current_location_id,json=currentLocationId,proto3" json:"current_location_id,omitempty"`
	// Output only. The time the instance was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,13,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The current state of this instance.
	State Instance_State `protobuf:"varint,14,opt,name=state,proto3,enum=google.cloud.redis.v1beta1.Instance_State" json:"state,omitempty"`
	// Output only. Additional information about the current status of this
	// instance, if available.
	StatusMessage string `protobuf:"bytes,15,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Optional. Redis configuration parameters, according to
	// http://redis.io/topics/config. Currently, the only supported parameters
	// are:
	//
	//  Redis 3.2 and above:
	//
	//  *   maxmemory-policy
	//  *   notify-keyspace-events
	//
	//  Redis 4.0 and above:
	//
	//  *   activedefrag
	//  *   lfu-log-factor
	//  *   lfu-decay-time
	RedisConfigs map[string]string `protobuf:"bytes,16,rep,name=redis_configs,json=redisConfigs,proto3" json:"redis_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The service tier of the instance.
	Tier Instance_Tier `protobuf:"varint,17,opt,name=tier,proto3,enum=google.cloud.redis.v1beta1.Instance_Tier" json:"tier,omitempty"`
	// Required. Redis memory size in GiB.
	MemorySizeGb int32 `protobuf:"varint,18,opt,name=memory_size_gb,json=memorySizeGb,proto3" json:"memory_size_gb,omitempty"`
	// Optional. The full name of the Google Compute Engine
	// [network](/compute/docs/networks-and-firewalls#networks) to which the
	// instance is connected. If left unspecified, the `default` network
	// will be used.
	AuthorizedNetwork string `protobuf:"bytes,20,opt,name=authorized_network,json=authorizedNetwork,proto3" json:"authorized_network,omitempty"`
	// Output only. Cloud IAM identity used by import / export operations to
	// transfer data to/from Cloud Storage. Format is
	// "serviceAccount:<service_account_email>". The value may change over time
	// for a given instance so should be checked before each import/export
	// operation.
	PersistenceIamIdentity string `protobuf:"bytes,21,opt,name=persistence_iam_identity,json=persistenceIamIdentity,proto3" json:"persistence_iam_identity,omitempty"`
	// Optional. The connect mode of Redis instance.
	// If not provided, default one will be used.
	// Current default: DIRECT_PEERING.
	ConnectMode          Instance_ConnectMode `protobuf:"varint,22,opt,name=connect_mode,json=connectMode,proto3,enum=google.cloud.redis.v1beta1.Instance_ConnectMode" json:"connect_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Instance) Reset()         { *m = Instance{} }
func (m *Instance) String() string { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()    {}
func (*Instance) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{0}
}

func (m *Instance) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Instance.Unmarshal(m, b)
}
func (m *Instance) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Instance.Marshal(b, m, deterministic)
}
func (m *Instance) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Instance.Merge(m, src)
}
func (m *Instance) XXX_Size() int {
	return xxx_messageInfo_Instance.Size(m)
}
func (m *Instance) XXX_DiscardUnknown() {
	xxx_messageInfo_Instance.DiscardUnknown(m)
}

var xxx_messageInfo_Instance proto.InternalMessageInfo

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Instance) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Instance) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

func (m *Instance) GetAlternativeLocationId() string {
	if m != nil {
		return m.AlternativeLocationId
	}
	return ""
}

func (m *Instance) GetRedisVersion() string {
	if m != nil {
		return m.RedisVersion
	}
	return ""
}

func (m *Instance) GetReservedIpRange() string {
	if m != nil {
		return m.ReservedIpRange
	}
	return ""
}

func (m *Instance) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *Instance) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *Instance) GetCurrentLocationId() string {
	if m != nil {
		return m.CurrentLocationId
	}
	return ""
}

func (m *Instance) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Instance) GetState() Instance_State {
	if m != nil {
		return m.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (m *Instance) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *Instance) GetRedisConfigs() map[string]string {
	if m != nil {
		return m.RedisConfigs
	}
	return nil
}

func (m *Instance) GetTier() Instance_Tier {
	if m != nil {
		return m.Tier
	}
	return Instance_TIER_UNSPECIFIED
}

func (m *Instance) GetMemorySizeGb() int32 {
	if m != nil {
		return m.MemorySizeGb
	}
	return 0
}

func (m *Instance) GetAuthorizedNetwork() string {
	if m != nil {
		return m.AuthorizedNetwork
	}
	return ""
}

func (m *Instance) GetPersistenceIamIdentity() string {
	if m != nil {
		return m.PersistenceIamIdentity
	}
	return ""
}

func (m *Instance) GetConnectMode() Instance_ConnectMode {
	if m != nil {
		return m.ConnectMode
	}
	return Instance_CONNECT_MODE_UNSPECIFIED
}

// Request for [ListInstances][google.cloud.redis.v1beta1.CloudRedis.ListInstances].
type ListInstancesRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	//
	// If not specified, a default value of 1000 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [`next_page_token`][google.cloud.redis.v1beta1.ListInstancesResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `next_page_token` value returned from a previous
	// [ListInstances][google.cloud.redis.v1beta1.CloudRedis.ListInstances] request, if any.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesRequest) Reset()         { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()    {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{1}
}

func (m *ListInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesRequest.Marshal(b, m, deterministic)
}
func (m *ListInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesRequest.Merge(m, src)
}
func (m *ListInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstancesRequest.Size(m)
}
func (m *ListInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesRequest proto.InternalMessageInfo

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for [ListInstances][google.cloud.redis.v1beta1.CloudRedis.ListInstances].
type ListInstancesResponse struct {
	// A list of Redis instances in the project in the specified location,
	// or across all locations.
	//
	// If the `location_id` in the parent field of the request is "-", all regions
	// available to the project are queried, and the results aggregated.
	// If in such an aggregated query a location is unavailable, a dummy Redis
	// entry is included in the response with the `name` field set to a value of
	// the form `projects/{project_id}/locations/{location_id}/instances/`- and
	// the `status` field set to ERROR and `status_message` field set to "location
	// not available for ListInstances".
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable          []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesResponse) Reset()         { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()    {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{2}
}

func (m *ListInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesResponse.Marshal(b, m, deterministic)
}
func (m *ListInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesResponse.Merge(m, src)
}
func (m *ListInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstancesResponse.Size(m)
}
func (m *ListInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesResponse proto.InternalMessageInfo

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListInstancesResponse) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

// Request for [GetInstance][google.cloud.redis.v1beta1.CloudRedis.GetInstance].
type GetInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceRequest) Reset()         { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()    {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{3}
}

func (m *GetInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceRequest.Unmarshal(m, b)
}
func (m *GetInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceRequest.Marshal(b, m, deterministic)
}
func (m *GetInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceRequest.Merge(m, src)
}
func (m *GetInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceRequest.Size(m)
}
func (m *GetInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceRequest proto.InternalMessageInfo

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for [CreateInstance][google.cloud.redis.v1beta1.CloudRedis.CreateInstance].
type CreateInstanceRequest struct {
	// Required. The resource name of the instance location using the form:
	//     `projects/{project_id}/locations/{location_id}`
	// where `location_id` refers to a GCP region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The logical name of the Redis instance in the customer project
	// with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-40 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the customer project / location
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. A Redis [Instance] resource
	Instance             *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateInstanceRequest) Reset()         { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()    {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{4}
}

func (m *CreateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceRequest.Unmarshal(m, b)
}
func (m *CreateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceRequest.Marshal(b, m, deterministic)
}
func (m *CreateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceRequest.Merge(m, src)
}
func (m *CreateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceRequest.Size(m)
}
func (m *CreateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceRequest proto.InternalMessageInfo

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for [UpdateInstance][google.cloud.redis.v1beta1.CloudRedis.UpdateInstance].
type UpdateInstanceRequest struct {
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field may only include these
	// fields from [Instance][google.cloud.redis.v1beta1.Instance]:
	//
	//  *   `displayName`
	//  *   `labels`
	//  *   `memorySizeGb`
	//  *   `redisConfig`
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Update description.
	// Only fields specified in update_mask are updated.
	Instance             *Instance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *UpdateInstanceRequest) Reset()         { *m = UpdateInstanceRequest{} }
func (m *UpdateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceRequest) ProtoMessage()    {}
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{5}
}

func (m *UpdateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceRequest.Unmarshal(m, b)
}
func (m *UpdateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceRequest.Marshal(b, m, deterministic)
}
func (m *UpdateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceRequest.Merge(m, src)
}
func (m *UpdateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceRequest.Size(m)
}
func (m *UpdateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceRequest proto.InternalMessageInfo

func (m *UpdateInstanceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

// Request for [UpgradeInstance][google.cloud.redis.v1beta1.CloudRedis.UpgradeInstance].
type UpgradeInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Specifies the target version of Redis software to upgrade to.
	RedisVersion         string   `protobuf:"bytes,2,opt,name=redis_version,json=redisVersion,proto3" json:"redis_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpgradeInstanceRequest) Reset()         { *m = UpgradeInstanceRequest{} }
func (m *UpgradeInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*UpgradeInstanceRequest) ProtoMessage()    {}
func (*UpgradeInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{6}
}

func (m *UpgradeInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpgradeInstanceRequest.Unmarshal(m, b)
}
func (m *UpgradeInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpgradeInstanceRequest.Marshal(b, m, deterministic)
}
func (m *UpgradeInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpgradeInstanceRequest.Merge(m, src)
}
func (m *UpgradeInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_UpgradeInstanceRequest.Size(m)
}
func (m *UpgradeInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpgradeInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpgradeInstanceRequest proto.InternalMessageInfo

func (m *UpgradeInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpgradeInstanceRequest) GetRedisVersion() string {
	if m != nil {
		return m.RedisVersion
	}
	return ""
}

// Request for [DeleteInstance][google.cloud.redis.v1beta1.CloudRedis.DeleteInstance].
type DeleteInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceRequest) Reset()         { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()    {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{7}
}

func (m *DeleteInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceRequest.Merge(m, src)
}
func (m *DeleteInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceRequest.Size(m)
}
func (m *DeleteInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceRequest proto.InternalMessageInfo

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The Cloud Storage location for the input content
type GcsSource struct {
	// Required. Source data URI. (e.g. 'gs://my_bucket/my_object').
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsSource) Reset()         { *m = GcsSource{} }
func (m *GcsSource) String() string { return proto.CompactTextString(m) }
func (*GcsSource) ProtoMessage()    {}
func (*GcsSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{8}
}

func (m *GcsSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsSource.Unmarshal(m, b)
}
func (m *GcsSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsSource.Marshal(b, m, deterministic)
}
func (m *GcsSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsSource.Merge(m, src)
}
func (m *GcsSource) XXX_Size() int {
	return xxx_messageInfo_GcsSource.Size(m)
}
func (m *GcsSource) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsSource.DiscardUnknown(m)
}

var xxx_messageInfo_GcsSource proto.InternalMessageInfo

func (m *GcsSource) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The input content
type InputConfig struct {
	// Required. Specify source location of input data
	//
	// Types that are valid to be assigned to Source:
	//	*InputConfig_GcsSource
	Source               isInputConfig_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InputConfig) Reset()         { *m = InputConfig{} }
func (m *InputConfig) String() string { return proto.CompactTextString(m) }
func (*InputConfig) ProtoMessage()    {}
func (*InputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{9}
}

func (m *InputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputConfig.Unmarshal(m, b)
}
func (m *InputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputConfig.Marshal(b, m, deterministic)
}
func (m *InputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputConfig.Merge(m, src)
}
func (m *InputConfig) XXX_Size() int {
	return xxx_messageInfo_InputConfig.Size(m)
}
func (m *InputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_InputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_InputConfig proto.InternalMessageInfo

type isInputConfig_Source interface {
	isInputConfig_Source()
}

type InputConfig_GcsSource struct {
	GcsSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

func (*InputConfig_GcsSource) isInputConfig_Source() {}

func (m *InputConfig) GetSource() isInputConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *InputConfig) GetGcsSource() *GcsSource {
	if x, ok := m.GetSource().(*InputConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InputConfig_GcsSource)(nil),
	}
}

// Request for [Import][google.cloud.redis.v1beta1.CloudRedis.ImportInstance].
type ImportInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Specify data to be imported.
	InputConfig          *InputConfig `protobuf:"bytes,3,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ImportInstanceRequest) Reset()         { *m = ImportInstanceRequest{} }
func (m *ImportInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*ImportInstanceRequest) ProtoMessage()    {}
func (*ImportInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{10}
}

func (m *ImportInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportInstanceRequest.Unmarshal(m, b)
}
func (m *ImportInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportInstanceRequest.Marshal(b, m, deterministic)
}
func (m *ImportInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportInstanceRequest.Merge(m, src)
}
func (m *ImportInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_ImportInstanceRequest.Size(m)
}
func (m *ImportInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportInstanceRequest proto.InternalMessageInfo

func (m *ImportInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportInstanceRequest) GetInputConfig() *InputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

// The Cloud Storage location for the output content
type GcsDestination struct {
	// Required. Data destination URI (e.g.
	// 'gs://my_bucket/my_object'). Existing files will be overwritten.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GcsDestination) Reset()         { *m = GcsDestination{} }
func (m *GcsDestination) String() string { return proto.CompactTextString(m) }
func (*GcsDestination) ProtoMessage()    {}
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{11}
}

func (m *GcsDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GcsDestination.Unmarshal(m, b)
}
func (m *GcsDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GcsDestination.Marshal(b, m, deterministic)
}
func (m *GcsDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GcsDestination.Merge(m, src)
}
func (m *GcsDestination) XXX_Size() int {
	return xxx_messageInfo_GcsDestination.Size(m)
}
func (m *GcsDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_GcsDestination.DiscardUnknown(m)
}

var xxx_messageInfo_GcsDestination proto.InternalMessageInfo

func (m *GcsDestination) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The output content
type OutputConfig struct {
	// Required. Specify destination location of output data
	//
	// Types that are valid to be assigned to Destination:
	//	*OutputConfig_GcsDestination
	Destination          isOutputConfig_Destination `protobuf_oneof:"destination"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *OutputConfig) Reset()         { *m = OutputConfig{} }
func (m *OutputConfig) String() string { return proto.CompactTextString(m) }
func (*OutputConfig) ProtoMessage()    {}
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{12}
}

func (m *OutputConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputConfig.Unmarshal(m, b)
}
func (m *OutputConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputConfig.Marshal(b, m, deterministic)
}
func (m *OutputConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputConfig.Merge(m, src)
}
func (m *OutputConfig) XXX_Size() int {
	return xxx_messageInfo_OutputConfig.Size(m)
}
func (m *OutputConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputConfig.DiscardUnknown(m)
}

var xxx_messageInfo_OutputConfig proto.InternalMessageInfo

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := m.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*OutputConfig) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*OutputConfig_GcsDestination)(nil),
	}
}

// Request for [Export][google.cloud.redis.v1beta1.CloudRedis.ExportInstance].
type ExportInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Specify data to be exported.
	OutputConfig         *OutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ExportInstanceRequest) Reset()         { *m = ExportInstanceRequest{} }
func (m *ExportInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*ExportInstanceRequest) ProtoMessage()    {}
func (*ExportInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{13}
}

func (m *ExportInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportInstanceRequest.Unmarshal(m, b)
}
func (m *ExportInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportInstanceRequest.Marshal(b, m, deterministic)
}
func (m *ExportInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportInstanceRequest.Merge(m, src)
}
func (m *ExportInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_ExportInstanceRequest.Size(m)
}
func (m *ExportInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportInstanceRequest proto.InternalMessageInfo

func (m *ExportInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportInstanceRequest) GetOutputConfig() *OutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

// Request for [Failover][google.cloud.redis.v1beta1.CloudRedis.FailoverInstance].
type FailoverInstanceRequest struct {
	// Required. Redis instance resource name using the form:
	//     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`
	// where `location_id` refers to a GCP region.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Available data protection modes that the user can choose. If it's
	// unspecified, data protection mode will be LIMITED_DATA_LOSS by default.
	DataProtectionMode   FailoverInstanceRequest_DataProtectionMode `protobuf:"varint,2,opt,name=data_protection_mode,json=dataProtectionMode,proto3,enum=google.cloud.redis.v1beta1.FailoverInstanceRequest_DataProtectionMode" json:"data_protection_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *FailoverInstanceRequest) Reset()         { *m = FailoverInstanceRequest{} }
func (m *FailoverInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*FailoverInstanceRequest) ProtoMessage()    {}
func (*FailoverInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{14}
}

func (m *FailoverInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FailoverInstanceRequest.Unmarshal(m, b)
}
func (m *FailoverInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FailoverInstanceRequest.Marshal(b, m, deterministic)
}
func (m *FailoverInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FailoverInstanceRequest.Merge(m, src)
}
func (m *FailoverInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_FailoverInstanceRequest.Size(m)
}
func (m *FailoverInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FailoverInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FailoverInstanceRequest proto.InternalMessageInfo

func (m *FailoverInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FailoverInstanceRequest) GetDataProtectionMode() FailoverInstanceRequest_DataProtectionMode {
	if m != nil {
		return m.DataProtectionMode
	}
	return FailoverInstanceRequest_DATA_PROTECTION_MODE_UNSPECIFIED
}

// This location metadata represents additional configuration options for a
// given location where a Redis instance may be created. All fields are output
// only. It is returned as content of the
// `google.cloud.location.Location.metadata` field.
type LocationMetadata struct {
	// Output only. The set of available zones in the location. The map is keyed
	// by the lowercase ID of each zone, as defined by GCE. These keys can be
	// specified in `location_id` or `alternative_location_id` fields when
	// creating a Redis instance.
	AvailableZones       map[string]*ZoneMetadata `protobuf:"bytes,1,rep,name=available_zones,json=availableZones,proto3" json:"available_zones,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *LocationMetadata) Reset()         { *m = LocationMetadata{} }
func (m *LocationMetadata) String() string { return proto.CompactTextString(m) }
func (*LocationMetadata) ProtoMessage()    {}
func (*LocationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{15}
}

func (m *LocationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationMetadata.Unmarshal(m, b)
}
func (m *LocationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationMetadata.Marshal(b, m, deterministic)
}
func (m *LocationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationMetadata.Merge(m, src)
}
func (m *LocationMetadata) XXX_Size() int {
	return xxx_messageInfo_LocationMetadata.Size(m)
}
func (m *LocationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LocationMetadata proto.InternalMessageInfo

func (m *LocationMetadata) GetAvailableZones() map[string]*ZoneMetadata {
	if m != nil {
		return m.AvailableZones
	}
	return nil
}

// Defines specific information for a particular zone. Currently empty and
// reserved for future use only.
type ZoneMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZoneMetadata) Reset()         { *m = ZoneMetadata{} }
func (m *ZoneMetadata) String() string { return proto.CompactTextString(m) }
func (*ZoneMetadata) ProtoMessage()    {}
func (*ZoneMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_522f9b2de914b9c5, []int{16}
}

func (m *ZoneMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZoneMetadata.Unmarshal(m, b)
}
func (m *ZoneMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZoneMetadata.Marshal(b, m, deterministic)
}
func (m *ZoneMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZoneMetadata.Merge(m, src)
}
func (m *ZoneMetadata) XXX_Size() int {
	return xxx_messageInfo_ZoneMetadata.Size(m)
}
func (m *ZoneMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ZoneMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ZoneMetadata proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("google.cloud.redis.v1beta1.Instance_State", Instance_State_name, Instance_State_value)
	proto.RegisterEnum("google.cloud.redis.v1beta1.Instance_Tier", Instance_Tier_name, Instance_Tier_value)
	proto.RegisterEnum("google.cloud.redis.v1beta1.Instance_ConnectMode", Instance_ConnectMode_name, Instance_ConnectMode_value)
	proto.RegisterEnum("google.cloud.redis.v1beta1.FailoverInstanceRequest_DataProtectionMode", FailoverInstanceRequest_DataProtectionMode_name, FailoverInstanceRequest_DataProtectionMode_value)
	proto.RegisterType((*Instance)(nil), "google.cloud.redis.v1beta1.Instance")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1beta1.Instance.LabelsEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.redis.v1beta1.Instance.RedisConfigsEntry")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.cloud.redis.v1beta1.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.cloud.redis.v1beta1.ListInstancesResponse")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.cloud.redis.v1beta1.GetInstanceRequest")
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.cloud.redis.v1beta1.CreateInstanceRequest")
	proto.RegisterType((*UpdateInstanceRequest)(nil), "google.cloud.redis.v1beta1.UpdateInstanceRequest")
	proto.RegisterType((*UpgradeInstanceRequest)(nil), "google.cloud.redis.v1beta1.UpgradeInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.cloud.redis.v1beta1.DeleteInstanceRequest")
	proto.RegisterType((*GcsSource)(nil), "google.cloud.redis.v1beta1.GcsSource")
	proto.RegisterType((*InputConfig)(nil), "google.cloud.redis.v1beta1.InputConfig")
	proto.RegisterType((*ImportInstanceRequest)(nil), "google.cloud.redis.v1beta1.ImportInstanceRequest")
	proto.RegisterType((*GcsDestination)(nil), "google.cloud.redis.v1beta1.GcsDestination")
	proto.RegisterType((*OutputConfig)(nil), "google.cloud.redis.v1beta1.OutputConfig")
	proto.RegisterType((*ExportInstanceRequest)(nil), "google.cloud.redis.v1beta1.ExportInstanceRequest")
	proto.RegisterType((*FailoverInstanceRequest)(nil), "google.cloud.redis.v1beta1.FailoverInstanceRequest")
	proto.RegisterType((*LocationMetadata)(nil), "google.cloud.redis.v1beta1.LocationMetadata")
	proto.RegisterMapType((map[string]*ZoneMetadata)(nil), "google.cloud.redis.v1beta1.LocationMetadata.AvailableZonesEntry")
	proto.RegisterType((*ZoneMetadata)(nil), "google.cloud.redis.v1beta1.ZoneMetadata")
}

func init() {
	proto.RegisterFile("google/cloud/redis/v1beta1/cloud_redis.proto", fileDescriptor_522f9b2de914b9c5)
}

var fileDescriptor_522f9b2de914b9c5 = []byte{
	// 2048 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0xcf, 0x6f, 0xdb, 0xd6,
	0x1d, 0x0f, 0xa5, 0xd8, 0xb3, 0xbe, 0x92, 0x65, 0xf9, 0xc5, 0x4a, 0x58, 0xb5, 0x59, 0x5d, 0x26,
	0x5d, 0x1d, 0x23, 0x93, 0x16, 0x67, 0x18, 0x1a, 0x67, 0x6d, 0x42, 0x4b, 0xb4, 0x4d, 0xc0, 0x96,
	0x04, 0x4a, 0x0e, 0xb6, 0x0e, 0x03, 0xfb, 0x4c, 0x3d, 0xcb, 0x9c, 0x25, 0x92, 0x23, 0x9f, 0x94,
	0x38, 0x81, 0x31, 0x6c, 0x28, 0x86, 0xdd, 0xd7, 0x6e, 0xc7, 0x6d, 0x87, 0x0d, 0xd8, 0x9f, 0x30,
	0xec, 0x0f, 0x18, 0x90, 0xe3, 0xb6, 0x53, 0x4e, 0x3d, 0xec, 0xb4, 0xcb, 0xee, 0x1d, 0x30, 0x0c,
	0xef, 0x91, 0x14, 0x29, 0x59, 0x96, 0x15, 0xc7, 0xbd, 0x91, 0xdf, 0x5f, 0xfc, 0x7e, 0x3e, 0xef,
	0xc7, 0xf7, 0x63, 0x19, 0xee, 0xb6, 0x6d, 0xbb, 0xdd, 0x21, 0x25, 0xa3, 0x63, 0xf7, 0x5a, 0x25,
	0x97, 0xb4, 0x4c, 0xaf, 0xd4, 0xbf, 0xb7, 0x4f, 0x28, 0xbe, 0xe7, 0xdb, 0x74, 0x6e, 0x2b, 0x3a,
	0xae, 0x4d, 0x6d, 0x54, 0xf0, 0xa3, 0x8b, 0xdc, 0x53, 0xf4, 0x3d, 0x41, 0x74, 0xe1, 0x9d, 0xa0,
	0x12, 0x76, 0xcc, 0x12, 0xb6, 0x2c, 0x9b, 0x62, 0x6a, 0xda, 0x56, 0x90, 0x59, 0xb8, 0x11, 0xf3,
	0x1a, 0x1d, 0x93, 0x58, 0x34, 0x70, 0xbc, 0x1b, 0x73, 0x1c, 0x98, 0xa4, 0xd3, 0xd2, 0xf7, 0xc9,
	0x21, 0xee, 0x9b, 0xb6, 0x1b, 0x04, 0xbc, 0x15, 0x0b, 0x70, 0x89, 0x67, 0xf7, 0x5c, 0x83, 0x04,
	0xae, 0x5b, 0x81, 0xab, 0x63, 0x5b, 0x6d, 0xb7, 0x67, 0x59, 0xa6, 0xd5, 0x2e, 0xd9, 0x0e, 0x71,
	0x87, 0xbe, 0xbc, 0x1c, 0x04, 0xf1, 0xb7, 0xfd, 0xde, 0x41, 0xf0, 0x95, 0x2e, 0xf6, 0x8e, 0x46,
	0x5a, 0x18, 0x44, 0x50, 0xb3, 0x4b, 0x3c, 0x8a, 0xbb, 0x8e, 0x1f, 0x20, 0x7d, 0x9e, 0x81, 0x39,
	0xd5, 0xf2, 0x28, 0xb6, 0x0c, 0x82, 0x6e, 0xc0, 0x55, 0x0b, 0x77, 0x89, 0x28, 0x2c, 0x0b, 0x2b,
	0xa9, 0x8d, 0xe4, 0x97, 0x72, 0x42, 0xe3, 0x06, 0xf4, 0x1e, 0x64, 0x5a, 0xa6, 0xe7, 0x74, 0xf0,
	0xb1, 0xce, 0x03, 0x12, 0x2c, 0x40, 0x4b, 0x07, 0xb6, 0x2a, 0x0b, 0xd9, 0x86, 0xd9, 0x0e, 0xde,
	0x27, 0x1d, 0x4f, 0x4c, 0x2e, 0x27, 0x57, 0xd2, 0x6b, 0xdf, 0x29, 0x9e, 0x4d, 0x68, 0x31, 0xfc,
	0x62, 0x71, 0x87, 0xa7, 0x28, 0x16, 0x75, 0x8f, 0xb5, 0x20, 0x1f, 0xdd, 0x86, 0x74, 0xc7, 0x36,
	0x38, 0x50, 0xdd, 0x6c, 0x89, 0x57, 0xc3, 0x66, 0x04, 0x0d, 0x42, 0xbb, 0xda, 0x42, 0x0f, 0xe1,
	0x06, 0xee, 0x50, 0xe2, 0x5a, 0x98, 0x9a, 0x7d, 0xa2, 0xc7, 0x33, 0x66, 0xa2, 0x8c, 0x7c, 0x2c,
	0x66, 0x27, 0x4a, 0x5e, 0x81, 0x79, 0xde, 0x90, 0xde, 0x27, 0xae, 0x67, 0xda, 0x96, 0xf8, 0x8d,
	0x28, 0x25, 0xc3, 0x3d, 0x4f, 0x7c, 0x07, 0x2a, 0xc1, 0xa2, 0x4b, 0x3c, 0xe2, 0xf6, 0x49, 0x4b,
	0x37, 0x1d, 0xdd, 0xc5, 0x56, 0x9b, 0x88, 0xa9, 0x28, 0x7a, 0x21, 0xf4, 0xaa, 0x8e, 0xc6, 0x7c,
	0x8c, 0xc3, 0x43, 0xdb, 0xa3, 0x22, 0x84, 0x31, 0x49, 0x8d, 0x1b, 0x98, 0xc3, 0xb1, 0x5d, 0x2a,
	0xa6, 0x97, 0x85, 0x95, 0x99, 0xc0, 0xc1, 0x0c, 0xe8, 0x3e, 0x5c, 0x33, 0x7a, 0xae, 0x4b, 0x2c,
	0x3a, 0x84, 0x22, 0x13, 0x15, 0x58, 0x0c, 0xfc, 0x31, 0x04, 0x8f, 0x21, 0x6d, 0xb8, 0x04, 0x53,
	0xa2, 0xb3, 0x15, 0x15, 0xe7, 0x97, 0x85, 0x95, 0xf4, 0x5a, 0x21, 0xe4, 0x3c, 0x5c, 0xee, 0x62,
	0x33, 0x5c, 0x6e, 0xbf, 0x10, 0xf8, 0x39, 0xcc, 0x8a, 0x14, 0x98, 0xf1, 0x28, 0xa6, 0x44, 0xcc,
	0x2e, 0x0b, 0x2b, 0xd9, 0xb5, 0xd5, 0xa9, 0xd6, 0xab, 0xc1, 0x32, 0xfc, 0x5a, 0x7e, 0x36, 0x5a,
	0x85, 0x2c, 0x7b, 0xe8, 0x79, 0x7a, 0x97, 0x78, 0x1e, 0x6e, 0x13, 0x71, 0x21, 0x6a, 0x7c, 0xde,
	0x77, 0xed, 0xfa, 0x1e, 0xf4, 0x69, 0x48, 0xbb, 0x61, 0x5b, 0x07, 0x66, 0xdb, 0x13, 0x73, 0x7c,
	0xab, 0x7c, 0x6f, 0xaa, 0x4f, 0x6b, 0xcc, 0x5c, 0xf6, 0x13, 0xf9, 0x86, 0x89, 0x2f, 0x57, 0x60,
	0x47, 0x1b, 0x70, 0x95, 0x9a, 0xc4, 0x15, 0x17, 0x39, 0xa6, 0x3b, 0x53, 0x15, 0x6e, 0x9a, 0xc4,
	0x0d, 0x36, 0x3b, 0xcb, 0x45, 0x77, 0x20, 0xdb, 0x25, 0x5d, 0xdb, 0x3d, 0xd6, 0x3d, 0xf3, 0x39,
	0xd1, 0xdb, 0xfb, 0x22, 0x0a, 0x97, 0x2c, 0xa1, 0x65, 0x7c, 0x57, 0xc3, 0x7c, 0x4e, 0xb6, 0xf6,
	0xd1, 0x1a, 0x20, 0xdc, 0xa3, 0x87, 0xb6, 0x6b, 0x3e, 0x27, 0x2d, 0xdd, 0x22, 0xf4, 0xa9, 0xed,
	0x1e, 0x89, 0x4b, 0xd1, 0xf6, 0x58, 0x8c, 0xdc, 0x55, 0xdf, 0x8b, 0x3e, 0x02, 0xd1, 0x61, 0x9b,
	0xcb, 0xa3, 0xc4, 0x32, 0x88, 0x6e, 0xe2, 0xae, 0x6e, 0xb6, 0x88, 0x45, 0x4d, 0x7a, 0x2c, 0xe6,
	0x23, 0xea, 0xae, 0xc7, 0x82, 0x54, 0xdc, 0x55, 0x83, 0x10, 0xf4, 0x03, 0xc8, 0x18, 0xb6, 0x65,
	0x11, 0x83, 0xea, 0x5d, 0xbb, 0x45, 0xc4, 0xeb, 0x1c, 0xe9, 0x74, 0xa7, 0xad, 0xec, 0x27, 0xee,
	0xda, 0x2d, 0xe2, 0xb7, 0x97, 0x36, 0x22, 0x4b, 0xe1, 0x01, 0xa4, 0x63, 0xc7, 0x11, 0xe5, 0x20,
	0x79, 0x44, 0x8e, 0xfd, 0xbb, 0x40, 0x63, 0x8f, 0x68, 0x09, 0x66, 0xfa, 0xb8, 0xd3, 0x0b, 0x8f,
	0xbf, 0xff, 0xb2, 0x9e, 0xf8, 0x50, 0x28, 0x3c, 0x82, 0xc5, 0x53, 0xcb, 0xf3, 0x3a, 0x05, 0xa4,
	0xcf, 0x05, 0x98, 0xe1, 0x7b, 0x0b, 0xe5, 0x61, 0xb1, 0xd1, 0x94, 0x9b, 0x8a, 0xbe, 0x57, 0x6d,
	0xd4, 0x95, 0xb2, 0xba, 0xa9, 0x2a, 0x95, 0xdc, 0x15, 0x94, 0x81, 0xb9, 0xb2, 0xa6, 0xc8, 0x4d,
	0xb5, 0xba, 0x95, 0x13, 0x50, 0x0a, 0x66, 0x34, 0x45, 0xae, 0xfc, 0x30, 0x97, 0x60, 0x8e, 0xbd,
	0x7a, 0xc5, 0x77, 0x24, 0xd9, 0x5b, 0x45, 0xd9, 0x51, 0xf8, 0xdb, 0x55, 0x34, 0x0f, 0x29, 0x4d,
	0xa9, 0xcb, 0xaa, 0xc6, 0x5e, 0x67, 0xd0, 0x02, 0xa4, 0x77, 0x65, 0xb5, 0xda, 0x54, 0xaa, 0x72,
	0xb5, 0xac, 0xe4, 0x66, 0x99, 0x5f, 0xdd, 0xad, 0xd7, 0x34, 0x1e, 0x3e, 0x87, 0x72, 0x90, 0xd9,
	0x94, 0xd5, 0x1d, 0xb5, 0xba, 0xa5, 0xd7, 0x9e, 0x28, 0x5a, 0x0e, 0xa4, 0x0f, 0xe1, 0x2a, 0xdb,
	0x1d, 0x68, 0x09, 0x72, 0x4d, 0x55, 0xd1, 0x46, 0x7a, 0x4a, 0xc1, 0xcc, 0x86, 0xdc, 0x50, 0xcb,
	0x39, 0x81, 0x95, 0x6e, 0x34, 0xe5, 0x6a, 0x45, 0xd6, 0x2a, 0xfa, 0xb6, 0x9c, 0x4b, 0x4a, 0x3f,
	0x82, 0x74, 0x8c, 0x6d, 0xf4, 0x0e, 0x88, 0xe5, 0x5a, 0xb5, 0xaa, 0x94, 0x9b, 0xfa, 0x6e, 0xad,
	0x32, 0x0a, 0x0e, 0x41, 0xb6, 0xa2, 0x6a, 0xcc, 0x59, 0x57, 0x14, 0xcd, 0x87, 0x58, 0x80, 0xeb,
	0x75, 0x4d, 0x7d, 0xc2, 0x98, 0x68, 0x28, 0xda, 0x13, 0xb5, 0xac, 0xe8, 0x72, 0xb9, 0xac, 0x34,
	0x1a, 0xb9, 0xc4, 0xfa, 0xa7, 0xff, 0x96, 0x7f, 0x0c, 0x37, 0xfd, 0x45, 0xf6, 0xd7, 0x1d, 0x3b,
	0xa6, 0x57, 0x34, 0xec, 0x6e, 0x69, 0x70, 0x97, 0x7f, 0xdf, 0x71, 0xed, 0x9f, 0x10, 0x83, 0x7a,
	0xa5, 0x17, 0xc1, 0xd3, 0x49, 0x29, 0xbc, 0x5e, 0xbc, 0xd2, 0x8b, 0xf0, 0xf1, 0xa4, 0x64, 0x06,
	0x19, 0x5e, 0xe9, 0x45, 0xf8, 0x78, 0x22, 0x7d, 0x21, 0xc0, 0xd2, 0x8e, 0xe9, 0xd1, 0xb0, 0x9c,
	0xa7, 0x91, 0x9f, 0xf6, 0x88, 0x47, 0x91, 0x0c, 0xb3, 0x0e, 0x66, 0x77, 0x51, 0x30, 0x24, 0xee,
	0x7c, 0x29, 0x27, 0xbe, 0x92, 0x6f, 0xc1, 0x7b, 0x83, 0xda, 0xa3, 0x1d, 0x85, 0x97, 0x96, 0x16,
	0x24, 0xa2, 0xb7, 0x21, 0xe5, 0xe0, 0x36, 0xe1, 0xa7, 0x8b, 0xef, 0x84, 0x19, 0x6d, 0x8e, 0x19,
	0xd8, 0x99, 0x42, 0x37, 0x01, 0xb8, 0x93, 0xda, 0x47, 0xc4, 0x12, 0x93, 0x7c, 0x9f, 0xf0, 0xf0,
	0x26, 0x33, 0x48, 0x7f, 0x14, 0x20, 0x3f, 0xd2, 0x97, 0xe7, 0xd8, 0x96, 0x47, 0xd0, 0x06, 0xa4,
	0x06, 0x48, 0x44, 0x81, 0xdf, 0x2b, 0xb7, 0xa7, 0x39, 0x14, 0x5a, 0x94, 0x86, 0xbe, 0x05, 0x0b,
	0x16, 0x79, 0x46, 0xf5, 0x58, 0x07, 0xfe, 0x4e, 0x9d, 0x67, 0xe6, 0x7a, 0xd8, 0x05, 0x5a, 0x86,
	0x74, 0xcf, 0x72, 0x09, 0x36, 0x0e, 0xf1, 0x7e, 0x87, 0xf0, 0x81, 0x97, 0xd2, 0xe2, 0x26, 0xa9,
	0x06, 0x68, 0x8b, 0x0c, 0xba, 0x0c, 0xc9, 0x7b, 0x30, 0x34, 0x5f, 0xdf, 0xe7, 0xd4, 0xbd, 0x7b,
	0xce, 0x42, 0xfa, 0x13, 0x58, 0xfa, 0x9b, 0x00, 0xf9, 0x32, 0xbf, 0xbc, 0x47, 0x8b, 0x5e, 0xc2,
	0x8a, 0xdc, 0x86, 0x74, 0x48, 0x02, 0x9b, 0x3c, 0x89, 0x68, 0xfc, 0x43, 0x68, 0x57, 0x5b, 0x48,
	0x81, 0xb9, 0xf0, 0x8d, 0x2f, 0xcc, 0x94, 0x04, 0xfb, 0x85, 0x06, 0xa9, 0xd2, 0xef, 0x05, 0xc8,
	0xef, 0x39, 0xad, 0x31, 0x48, 0x1e, 0x43, 0xba, 0xc7, 0x1d, 0x5c, 0xc1, 0x70, 0x38, 0xe3, 0x66,
	0xda, 0x26, 0x13, 0x39, 0xbb, 0xd8, 0x3b, 0x0a, 0x5a, 0xf4, 0x73, 0x98, 0x61, 0xa8, 0xc5, 0xc4,
	0xc5, 0x5b, 0x3c, 0x81, 0xeb, 0x7b, 0x4e, 0xdb, 0xc5, 0x2d, 0x72, 0x79, 0x2b, 0x78, 0x5a, 0x73,
	0xc4, 0x68, 0x1e, 0xd2, 0x1c, 0x92, 0x06, 0xf9, 0x0a, 0xe9, 0x10, 0x7a, 0x89, 0x5f, 0x97, 0x24,
	0x48, 0x6d, 0x19, 0x5e, 0x83, 0x4b, 0x4c, 0x94, 0x87, 0x64, 0xcf, 0x35, 0xe3, 0x32, 0x8f, 0xbd,
	0x4b, 0x3a, 0xa4, 0x55, 0xcb, 0xe9, 0x51, 0xff, 0x16, 0x47, 0x9b, 0x00, 0x6d, 0xc3, 0xd3, 0x7d,
	0x59, 0x1a, 0xac, 0xc6, 0xfb, 0x93, 0xe8, 0x1c, 0x7c, 0x60, 0xfb, 0x8a, 0x96, 0x6a, 0x87, 0x2f,
	0x1b, 0x73, 0x30, 0xeb, 0xd7, 0x90, 0x7e, 0x2e, 0x40, 0x5e, 0xed, 0x32, 0xd1, 0x33, 0x8a, 0xec,
	0x4c, 0xe5, 0x59, 0x83, 0x8c, 0xc9, 0x7a, 0x0a, 0x24, 0x43, 0xb0, 0xf1, 0x3e, 0x98, 0xbc, 0xaa,
	0x03, 0x0c, 0x7e, 0xa5, 0xb4, 0x19, 0x59, 0xa4, 0x0f, 0x20, 0xbb, 0x65, 0x78, 0x15, 0xe2, 0x51,
	0xd3, 0xe2, 0xa7, 0xe0, 0x2c, 0x36, 0x28, 0x64, 0x6a, 0x3d, 0x1a, 0xd1, 0xb1, 0x07, 0x0b, 0x8c,
	0x8e, 0x56, 0x94, 0x19, 0x70, 0xb2, 0x7a, 0x0e, 0x27, 0xb1, 0x6f, 0x6d, 0x5f, 0xd1, 0xb2, 0xed,
	0x21, 0xcb, 0xc6, 0x3c, 0xa4, 0x63, 0x25, 0xa5, 0xcf, 0x04, 0xc8, 0x2b, 0xcf, 0x5e, 0x8b, 0x22,
	0x0d, 0xe6, 0x6d, 0xde, 0xe8, 0x30, 0x47, 0x2b, 0x93, 0xda, 0x8a, 0x23, 0x0b, 0xb6, 0xa0, 0x1d,
	0x33, 0x49, 0x7f, 0x4d, 0xc0, 0x8d, 0x4d, 0x6c, 0x76, 0xec, 0x3e, 0x71, 0x2f, 0xf1, 0x0c, 0x9c,
	0xc0, 0x52, 0x0b, 0x53, 0xac, 0xb3, 0xb3, 0x4c, 0x0c, 0xae, 0x74, 0xb9, 0x88, 0x49, 0x70, 0x11,
	0xb3, 0x39, 0xa9, 0xe3, 0x33, 0xba, 0x29, 0x56, 0x30, 0xc5, 0xf5, 0x41, 0xb9, 0x48, 0xda, 0xa0,
	0xd6, 0x29, 0x87, 0x74, 0x00, 0xe8, 0x74, 0x38, 0xba, 0x0d, 0xcb, 0x15, 0xb9, 0x29, 0xeb, 0x75,
	0xad, 0xd6, 0x54, 0xca, 0x4d, 0xb5, 0x56, 0x1d, 0x37, 0xa3, 0xf3, 0xb0, 0xb8, 0xa3, 0xee, 0xaa,
	0x4d, 0xa5, 0xa2, 0xf3, 0xe8, 0x9d, 0x5a, 0xa3, 0x91, 0x13, 0xd0, 0x35, 0x58, 0xd8, 0xac, 0x69,
	0x65, 0x25, 0x66, 0x4c, 0x48, 0xff, 0x11, 0x20, 0x17, 0x5e, 0xb2, 0xbb, 0x84, 0x62, 0xd6, 0x0a,
	0xb2, 0x60, 0x01, 0xf7, 0xb1, 0xd9, 0x61, 0xf3, 0x41, 0x7f, 0x6e, 0x5b, 0x83, 0x31, 0xf5, 0x78,
	0x12, 0xec, 0xd1, 0x32, 0x45, 0x39, 0xac, 0xf1, 0x09, 0x2b, 0x31, 0x10, 0xc2, 0x49, 0x2d, 0x8b,
	0x87, 0x3c, 0x85, 0x23, 0xb8, 0x36, 0x26, 0x76, 0x8c, 0x2a, 0xfb, 0x38, 0xae, 0xca, 0xce, 0xd9,
	0x37, 0xac, 0x50, 0xd8, 0x4a, 0x5c, 0xbf, 0x65, 0x21, 0x13, 0x77, 0xad, 0xfd, 0x79, 0x11, 0xa0,
	0xcc, 0xf2, 0xb9, 0x2c, 0x44, 0x7f, 0x11, 0x60, 0x7e, 0x68, 0x6c, 0xa3, 0x89, 0x82, 0x75, 0x9c,
	0xf2, 0x28, 0xdc, 0x7b, 0x8d, 0x0c, 0x5f, 0x13, 0x48, 0xe5, 0x57, 0x72, 0x30, 0xe2, 0x7e, 0xf1,
	0x8f, 0x7f, 0xfd, 0x3a, 0xf1, 0x5d, 0xb4, 0x36, 0xf8, 0x01, 0xe0, 0x85, 0x6f, 0xff, 0x68, 0xa0,
	0x92, 0x56, 0x63, 0xea, 0x68, 0x35, 0xa6, 0x8a, 0xd0, 0x9f, 0x04, 0x48, 0xc7, 0x66, 0x39, 0x2a,
	0x4e, 0x3c, 0xee, 0xa7, 0x86, 0x7e, 0x61, 0xaa, 0x09, 0x24, 0xc9, 0xaf, 0x64, 0x7e, 0x44, 0x4e,
	0x37, 0xca, 0xac, 0x67, 0xb4, 0x19, 0xd3, 0x6e, 0xab, 0x27, 0xe8, 0xb3, 0x04, 0x64, 0x87, 0x25,
	0x02, 0x9a, 0xc8, 0xd9, 0x58, 0x39, 0x51, 0xb8, 0x19, 0xa6, 0xc4, 0x7e, 0x79, 0x28, 0xd6, 0xc2,
	0x5f, 0x1e, 0xa4, 0xdf, 0x09, 0x2f, 0xe5, 0x75, 0xb8, 0x35, 0x05, 0x24, 0x74, 0x6d, 0x74, 0x70,
	0xcb, 0xd6, 0xf1, 0x2b, 0xf9, 0x6d, 0x9f, 0xf8, 0xbb, 0x31, 0xc1, 0x31, 0x78, 0xe6, 0xe0, 0x3f,
	0x96, 0x2e, 0xb0, 0x4a, 0xeb, 0x83, 0xe1, 0x8d, 0x7e, 0x99, 0x80, 0xec, 0xb0, 0xbe, 0x98, 0x4c,
	0xc3, 0x58, 0x2d, 0x72, 0x1e, 0x0d, 0x7f, 0x78, 0x53, 0x1a, 0x96, 0x62, 0x4a, 0x67, 0x18, 0xff,
	0xd6, 0xda, 0xc3, 0x08, 0x7f, 0xe8, 0x29, 0x4e, 0xbb, 0x0b, 0x62, 0x44, 0xfc, 0x4f, 0x80, 0x85,
	0x11, 0x19, 0x83, 0xd6, 0x26, 0x33, 0x31, 0x4e, 0xf3, 0x9c, 0x47, 0xc5, 0x6f, 0xdf, 0x94, 0x0a,
	0xc4, 0xb0, 0xdd, 0x1d, 0xd2, 0x46, 0x9c, 0x88, 0x47, 0xd2, 0xfa, 0xeb, 0x9f, 0x82, 0xf5, 0x9e,
	0x0f, 0x62, 0x5d, 0x58, 0x45, 0x5f, 0x09, 0x90, 0x1d, 0x96, 0x1b, 0x93, 0x77, 0xc2, 0x58, 0x69,
	0x72, 0x1e, 0xfc, 0x2f, 0xde, 0x14, 0xfe, 0x22, 0x87, 0x1f, 0x17, 0x39, 0xc1, 0x31, 0x78, 0x70,
	0x01, 0xf4, 0x26, 0x87, 0xc0, 0xc0, 0xff, 0x57, 0x80, 0xec, 0xb0, 0x90, 0x98, 0x0c, 0x7e, 0xac,
	0xe8, 0x38, 0x0f, 0xfc, 0x6f, 0x2e, 0x67, 0xed, 0x87, 0xe4, 0xcb, 0x1b, 0xa0, 0x27, 0xcf, 0x42,
	0xf4, 0xbf, 0x4a, 0x40, 0x6e, 0x54, 0x31, 0xa0, 0xfb, 0x17, 0xd0, 0x17, 0x5f, 0xfb, 0x7d, 0xf8,
	0x16, 0x67, 0x60, 0x9c, 0x2a, 0xe2, 0x44, 0x3c, 0x96, 0x1e, 0x5e, 0x80, 0x88, 0x83, 0x00, 0x0c,
	0xa3, 0xe2, 0x9f, 0x02, 0x64, 0x87, 0xff, 0x9c, 0x98, 0xbc, 0x11, 0xc6, 0xfe, 0xe9, 0x71, 0x1e,
	0x0d, 0xce, 0x4b, 0xf9, 0x2e, 0xe4, 0x47, 0x01, 0x2a, 0x5d, 0x87, 0x1e, 0x9f, 0x81, 0x3b, 0x36,
	0xed, 0x56, 0x2f, 0x30, 0xed, 0x0a, 0xdb, 0x2f, 0xe5, 0xa5, 0x71, 0x92, 0xf3, 0xef, 0x72, 0xf1,
	0x90, 0x52, 0xc7, 0x5b, 0x2f, 0x95, 0x9e, 0x3e, 0x7d, 0x3a, 0xaa, 0x47, 0x71, 0x8f, 0x1e, 0xfa,
	0x3f, 0xfe, 0x7f, 0xdb, 0xe9, 0x60, 0x7a, 0x60, 0xbb, 0xdd, 0x8d, 0x9f, 0xc1, 0x37, 0x0d, 0xbb,
	0x3b, 0x81, 0x92, 0x8d, 0x42, 0x24, 0x65, 0x1a, 0xc4, 0xed, 0x9b, 0x06, 0xd9, 0x20, 0xbe, 0x8c,
	0xb4, 0xeb, 0xc2, 0x27, 0x8f, 0x82, 0xcc, 0xb6, 0xdd, 0xc1, 0x56, 0xbb, 0x68, 0xbb, 0xed, 0x52,
	0x9b, 0x58, 0x1c, 0x6d, 0x29, 0xfa, 0xfc, 0xb8, 0x7f, 0x43, 0x3c, 0xe4, 0x6f, 0xfb, 0xb3, 0x3c,
	0xf6, 0xfe, 0xff, 0x03, 0x00, 0x00, 0xff, 0xff, 0x26, 0x1c, 0x79, 0x8a, 0xb1, 0x18, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudRedisClient is the client API for CloudRedis service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudRedisClient interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	//
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is accessible from the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Upgrades Redis instance to the newer Redis version specified in the
	// request.
	UpgradeInstance(ctx context.Context, in *UpgradeInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Import a Redis RDB snapshot file from Cloud Storage into a Redis instance.
	//
	// Redis may stop serving during this operation. Instance state will be
	// IMPORTING for entire operation. When complete, the instance will contain
	// only data from the imported file.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ImportInstance(ctx context.Context, in *ImportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Export Redis instance data into a Redis RDB format file in Cloud Storage.
	//
	// Redis will continue serving during this operation.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ExportInstance(ctx context.Context, in *ExportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Initiates a failover of the master node to current replica node for a
	// specific STANDARD tier Cloud Memorystore for Redis instance.
	FailoverInstance(ctx context.Context, in *FailoverInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type cloudRedisClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudRedisClient(cc grpc.ClientConnInterface) CloudRedisClient {
	return &cloudRedisClient{cc}
}

func (c *cloudRedisClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) UpgradeInstance(ctx context.Context, in *UpgradeInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/UpgradeInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) ImportInstance(ctx context.Context, in *ImportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/ImportInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) ExportInstance(ctx context.Context, in *ExportInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/ExportInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) FailoverInstance(ctx context.Context, in *FailoverInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/FailoverInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudRedisClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.redis.v1beta1.CloudRedis/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudRedisServer is the server API for CloudRedis service.
type CloudRedisServer interface {
	// Lists all Redis instances owned by a project in either the specified
	// location (region) or all locations.
	//
	// The location should have the following format:
	//
	// * `projects/{project_id}/locations/{location_id}`
	//
	// If `location_id` is specified as `-` (wildcard), then all regions
	// available to the project are queried, and the results are aggregated.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets the details of a specific Redis instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a Redis instance based on the specified tier and memory size.
	//
	// By default, the instance is accessible from the project's
	// [default network](/compute/docs/networks-and-firewalls#networks).
	//
	// The creation is executed asynchronously and callers may check the returned
	// operation to track its progress. Once the operation is completed the Redis
	// instance will be fully functional. Completed longrunning.Operation will
	// contain the new instance object in the response field.
	//
	// The returned operation is automatically deleted after a few hours, so there
	// is no need to call DeleteOperation.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunning.Operation, error)
	// Updates the metadata and configuration of a specific Redis instance.
	//
	// Completed longrunning.Operation will contain the new instance object
	// in the response field. The returned operation is automatically deleted
	// after a few hours, so there is no need to call DeleteOperation.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunning.Operation, error)
	// Upgrades Redis instance to the newer Redis version specified in the
	// request.
	UpgradeInstance(context.Context, *UpgradeInstanceRequest) (*longrunning.Operation, error)
	// Import a Redis RDB snapshot file from Cloud Storage into a Redis instance.
	//
	// Redis may stop serving during this operation. Instance state will be
	// IMPORTING for entire operation. When complete, the instance will contain
	// only data from the imported file.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ImportInstance(context.Context, *ImportInstanceRequest) (*longrunning.Operation, error)
	// Export Redis instance data into a Redis RDB format file in Cloud Storage.
	//
	// Redis will continue serving during this operation.
	//
	// The returned operation is automatically deleted after a few hours, so
	// there is no need to call DeleteOperation.
	ExportInstance(context.Context, *ExportInstanceRequest) (*longrunning.Operation, error)
	// Initiates a failover of the master node to current replica node for a
	// specific STANDARD tier Cloud Memorystore for Redis instance.
	FailoverInstance(context.Context, *FailoverInstanceRequest) (*longrunning.Operation, error)
	// Deletes a specific Redis instance.  Instance stops serving and data is
	// deleted.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunning.Operation, error)
}

// UnimplementedCloudRedisServer can be embedded to have forward compatible implementations.
type UnimplementedCloudRedisServer struct {
}

func (*UnimplementedCloudRedisServer) ListInstances(ctx context.Context, req *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedCloudRedisServer) GetInstance(ctx context.Context, req *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (*UnimplementedCloudRedisServer) CreateInstance(ctx context.Context, req *CreateInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (*UnimplementedCloudRedisServer) UpdateInstance(ctx context.Context, req *UpdateInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (*UnimplementedCloudRedisServer) UpgradeInstance(ctx context.Context, req *UpgradeInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeInstance not implemented")
}
func (*UnimplementedCloudRedisServer) ImportInstance(ctx context.Context, req *ImportInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportInstance not implemented")
}
func (*UnimplementedCloudRedisServer) ExportInstance(ctx context.Context, req *ExportInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportInstance not implemented")
}
func (*UnimplementedCloudRedisServer) FailoverInstance(ctx context.Context, req *FailoverInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FailoverInstance not implemented")
}
func (*UnimplementedCloudRedisServer) DeleteInstance(ctx context.Context, req *DeleteInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}

func RegisterCloudRedisServer(s *grpc.Server, srv CloudRedisServer) {
	s.RegisterService(&_CloudRedis_serviceDesc, srv)
}

func _CloudRedis_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_UpgradeInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).UpgradeInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/UpgradeInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).UpgradeInstance(ctx, req.(*UpgradeInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_ImportInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ImportInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/ImportInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ImportInstance(ctx, req.(*ImportInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_ExportInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).ExportInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/ExportInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).ExportInstance(ctx, req.(*ExportInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_FailoverInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FailoverInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).FailoverInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/FailoverInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).FailoverInstance(ctx, req.(*FailoverInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudRedis_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudRedisServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.redis.v1beta1.CloudRedis/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudRedisServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudRedis_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.redis.v1beta1.CloudRedis",
	HandlerType: (*CloudRedisServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _CloudRedis_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _CloudRedis_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _CloudRedis_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _CloudRedis_UpdateInstance_Handler,
		},
		{
			MethodName: "UpgradeInstance",
			Handler:    _CloudRedis_UpgradeInstance_Handler,
		},
		{
			MethodName: "ImportInstance",
			Handler:    _CloudRedis_ImportInstance_Handler,
		},
		{
			MethodName: "ExportInstance",
			Handler:    _CloudRedis_ExportInstance_Handler,
		},
		{
			MethodName: "FailoverInstance",
			Handler:    _CloudRedis_FailoverInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _CloudRedis_DeleteInstance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/redis/v1beta1/cloud_redis.proto",
}
