// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/iam/admin/v1/iam.proto

package admin

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Supported key algorithms.
type ServiceAccountKeyAlgorithm int32

const (
	// An unspecified key algorithm.
	ServiceAccountKeyAlgorithm_KEY_ALG_UNSPECIFIED ServiceAccountKeyAlgorithm = 0
	// 1k RSA Key.
	ServiceAccountKeyAlgorithm_KEY_ALG_RSA_1024 ServiceAccountKeyAlgorithm = 1
	// 2k RSA Key.
	ServiceAccountKeyAlgorithm_KEY_ALG_RSA_2048 ServiceAccountKeyAlgorithm = 2
)

var ServiceAccountKeyAlgorithm_name = map[int32]string{
	0: "KEY_ALG_UNSPECIFIED",
	1: "KEY_ALG_RSA_1024",
	2: "KEY_ALG_RSA_2048",
}

var ServiceAccountKeyAlgorithm_value = map[string]int32{
	"KEY_ALG_UNSPECIFIED": 0,
	"KEY_ALG_RSA_1024":    1,
	"KEY_ALG_RSA_2048":    2,
}

func (x ServiceAccountKeyAlgorithm) String() string {
	return proto.EnumName(ServiceAccountKeyAlgorithm_name, int32(x))
}

func (ServiceAccountKeyAlgorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{0}
}

// Supported private key output formats.
type ServiceAccountPrivateKeyType int32

const (
	// Unspecified. Equivalent to `TYPE_GOOGLE_CREDENTIALS_FILE`.
	ServiceAccountPrivateKeyType_TYPE_UNSPECIFIED ServiceAccountPrivateKeyType = 0
	// PKCS12 format.
	// The password for the PKCS12 file is `notasecret`.
	// For more information, see https://tools.ietf.org/html/rfc7292.
	ServiceAccountPrivateKeyType_TYPE_PKCS12_FILE ServiceAccountPrivateKeyType = 1
	// Google Credentials File format.
	ServiceAccountPrivateKeyType_TYPE_GOOGLE_CREDENTIALS_FILE ServiceAccountPrivateKeyType = 2
)

var ServiceAccountPrivateKeyType_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "TYPE_PKCS12_FILE",
	2: "TYPE_GOOGLE_CREDENTIALS_FILE",
}

var ServiceAccountPrivateKeyType_value = map[string]int32{
	"TYPE_UNSPECIFIED":             0,
	"TYPE_PKCS12_FILE":             1,
	"TYPE_GOOGLE_CREDENTIALS_FILE": 2,
}

func (x ServiceAccountPrivateKeyType) String() string {
	return proto.EnumName(ServiceAccountPrivateKeyType_name, int32(x))
}

func (ServiceAccountPrivateKeyType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{1}
}

// Supported public key output formats.
type ServiceAccountPublicKeyType int32

const (
	// Unspecified. Returns nothing here.
	ServiceAccountPublicKeyType_TYPE_NONE ServiceAccountPublicKeyType = 0
	// X509 PEM format.
	ServiceAccountPublicKeyType_TYPE_X509_PEM_FILE ServiceAccountPublicKeyType = 1
	// Raw public key.
	ServiceAccountPublicKeyType_TYPE_RAW_PUBLIC_KEY ServiceAccountPublicKeyType = 2
)

var ServiceAccountPublicKeyType_name = map[int32]string{
	0: "TYPE_NONE",
	1: "TYPE_X509_PEM_FILE",
	2: "TYPE_RAW_PUBLIC_KEY",
}

var ServiceAccountPublicKeyType_value = map[string]int32{
	"TYPE_NONE":           0,
	"TYPE_X509_PEM_FILE":  1,
	"TYPE_RAW_PUBLIC_KEY": 2,
}

func (x ServiceAccountPublicKeyType) String() string {
	return proto.EnumName(ServiceAccountPublicKeyType_name, int32(x))
}

func (ServiceAccountPublicKeyType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{2}
}

// A view for Role objects.
type RoleView int32

const (
	// Omits the `included_permissions` field.
	// This is the default value.
	RoleView_BASIC RoleView = 0
	// Returns all fields.
	RoleView_FULL RoleView = 1
)

var RoleView_name = map[int32]string{
	0: "BASIC",
	1: "FULL",
}

var RoleView_value = map[string]int32{
	"BASIC": 0,
	"FULL":  1,
}

func (x RoleView) String() string {
	return proto.EnumName(RoleView_name, int32(x))
}

func (RoleView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{3}
}

// `KeyType` filters to selectively retrieve certain varieties
// of keys.
type ListServiceAccountKeysRequest_KeyType int32

const (
	// Unspecified key type. The presence of this in the
	// message will immediately result in an error.
	ListServiceAccountKeysRequest_KEY_TYPE_UNSPECIFIED ListServiceAccountKeysRequest_KeyType = 0
	// User-managed keys (managed and rotated by the user).
	ListServiceAccountKeysRequest_USER_MANAGED ListServiceAccountKeysRequest_KeyType = 1
	// System-managed keys (managed and rotated by Google).
	ListServiceAccountKeysRequest_SYSTEM_MANAGED ListServiceAccountKeysRequest_KeyType = 2
)

var ListServiceAccountKeysRequest_KeyType_name = map[int32]string{
	0: "KEY_TYPE_UNSPECIFIED",
	1: "USER_MANAGED",
	2: "SYSTEM_MANAGED",
}

var ListServiceAccountKeysRequest_KeyType_value = map[string]int32{
	"KEY_TYPE_UNSPECIFIED": 0,
	"USER_MANAGED":         1,
	"SYSTEM_MANAGED":       2,
}

func (x ListServiceAccountKeysRequest_KeyType) String() string {
	return proto.EnumName(ListServiceAccountKeysRequest_KeyType_name, int32(x))
}

func (ListServiceAccountKeysRequest_KeyType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{6, 0}
}

// A stage representing a role's lifecycle phase.
type Role_RoleLaunchStage int32

const (
	// The user has indicated this role is currently in an Alpha phase. If this
	// launch stage is selected, the `stage` field will not be included when
	// requesting the definition for a given role.
	Role_ALPHA Role_RoleLaunchStage = 0
	// The user has indicated this role is currently in a Beta phase.
	Role_BETA Role_RoleLaunchStage = 1
	// The user has indicated this role is generally available.
	Role_GA Role_RoleLaunchStage = 2
	// The user has indicated this role is being deprecated.
	Role_DEPRECATED Role_RoleLaunchStage = 4
	// This role is disabled and will not contribute permissions to any members
	// it is granted to in policies.
	Role_DISABLED Role_RoleLaunchStage = 5
	// The user has indicated this role is currently in an EAP phase.
	Role_EAP Role_RoleLaunchStage = 6
)

var Role_RoleLaunchStage_name = map[int32]string{
	0: "ALPHA",
	1: "BETA",
	2: "GA",
	4: "DEPRECATED",
	5: "DISABLED",
	6: "EAP",
}

var Role_RoleLaunchStage_value = map[string]int32{
	"ALPHA":      0,
	"BETA":       1,
	"GA":         2,
	"DEPRECATED": 4,
	"DISABLED":   5,
	"EAP":        6,
}

func (x Role_RoleLaunchStage) String() string {
	return proto.EnumName(Role_RoleLaunchStage_name, int32(x))
}

func (Role_RoleLaunchStage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{16, 0}
}

// A stage representing a permission's lifecycle phase.
type Permission_PermissionLaunchStage int32

const (
	// The permission is currently in an alpha phase.
	Permission_ALPHA Permission_PermissionLaunchStage = 0
	// The permission is currently in a beta phase.
	Permission_BETA Permission_PermissionLaunchStage = 1
	// The permission is generally available.
	Permission_GA Permission_PermissionLaunchStage = 2
	// The permission is being deprecated.
	Permission_DEPRECATED Permission_PermissionLaunchStage = 3
)

var Permission_PermissionLaunchStage_name = map[int32]string{
	0: "ALPHA",
	1: "BETA",
	2: "GA",
	3: "DEPRECATED",
}

var Permission_PermissionLaunchStage_value = map[string]int32{
	"ALPHA":      0,
	"BETA":       1,
	"GA":         2,
	"DEPRECATED": 3,
}

func (x Permission_PermissionLaunchStage) String() string {
	return proto.EnumName(Permission_PermissionLaunchStage_name, int32(x))
}

func (Permission_PermissionLaunchStage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{26, 0}
}

// The state of the permission with regards to custom roles.
type Permission_CustomRolesSupportLevel int32

const (
	// Permission is fully supported for custom role use.
	Permission_SUPPORTED Permission_CustomRolesSupportLevel = 0
	// Permission is being tested to check custom role compatibility.
	Permission_TESTING Permission_CustomRolesSupportLevel = 1
	// Permission is not supported for custom role use.
	Permission_NOT_SUPPORTED Permission_CustomRolesSupportLevel = 2
)

var Permission_CustomRolesSupportLevel_name = map[int32]string{
	0: "SUPPORTED",
	1: "TESTING",
	2: "NOT_SUPPORTED",
}

var Permission_CustomRolesSupportLevel_value = map[string]int32{
	"SUPPORTED":     0,
	"TESTING":       1,
	"NOT_SUPPORTED": 2,
}

func (x Permission_CustomRolesSupportLevel) String() string {
	return proto.EnumName(Permission_CustomRolesSupportLevel_name, int32(x))
}

func (Permission_CustomRolesSupportLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{26, 1}
}

// A service account in the Identity and Access Management API.
//
// To create a service account, specify the `project_id` and the `account_id`
// for the account.  The `account_id` is unique within the project, and is used
// to generate the service account email address and a stable
// `unique_id`.
//
// If the account already exists, the account's resource name is returned
// in the format of projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}. The caller
// can use the name in other methods to access the account.
//
// All other methods can identify the service account using the format
// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
// the account. The `ACCOUNT` value can be the `email` address or the
// `unique_id` of the service account.
type ServiceAccount struct {
	// The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	//
	// Requests using `-` as a wildcard for the `PROJECT_ID` will infer the
	// project from the `account` and the `ACCOUNT` value can be the `email`
	// address or the `unique_id` of the service account.
	//
	// In responses the resource name will always be in the format
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// @OutputOnly The id of the project that owns the service account.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// @OutputOnly The unique and stable id of the service account.
	UniqueId string `protobuf:"bytes,4,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
	// @OutputOnly The email address of the service account.
	Email string `protobuf:"bytes,5,opt,name=email,proto3" json:"email,omitempty"`
	// Optional. A user-specified name for the service account.
	// Must be less than or equal to 100 UTF-8 bytes.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Note: `etag` is an inoperable legacy field that is only returned
	// for backwards compatibility.
	Etag []byte `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	// @OutputOnly. The OAuth2 client id for the service account.
	// This is used in conjunction with the OAuth2 clientconfig API to make
	// three legged OAuth2 (3LO) flows to access the data of Google users.
	Oauth2ClientId       string   `protobuf:"bytes,9,opt,name=oauth2_client_id,json=oauth2ClientId,proto3" json:"oauth2_client_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ServiceAccount) Reset()         { *m = ServiceAccount{} }
func (m *ServiceAccount) String() string { return proto.CompactTextString(m) }
func (*ServiceAccount) ProtoMessage()    {}
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{0}
}

func (m *ServiceAccount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceAccount.Unmarshal(m, b)
}
func (m *ServiceAccount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceAccount.Marshal(b, m, deterministic)
}
func (m *ServiceAccount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceAccount.Merge(m, src)
}
func (m *ServiceAccount) XXX_Size() int {
	return xxx_messageInfo_ServiceAccount.Size(m)
}
func (m *ServiceAccount) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceAccount.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceAccount proto.InternalMessageInfo

func (m *ServiceAccount) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServiceAccount) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ServiceAccount) GetUniqueId() string {
	if m != nil {
		return m.UniqueId
	}
	return ""
}

func (m *ServiceAccount) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *ServiceAccount) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *ServiceAccount) GetEtag() []byte {
	if m != nil {
		return m.Etag
	}
	return nil
}

func (m *ServiceAccount) GetOauth2ClientId() string {
	if m != nil {
		return m.Oauth2ClientId
	}
	return ""
}

// The service account create request.
type CreateServiceAccountRequest struct {
	// Required. The resource name of the project associated with the service
	// accounts, such as `projects/my-project-123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The account id that is used to generate the service account
	// email address and a stable unique id. It is unique within a project,
	// must be 6-30 characters long, and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])` to comply with RFC1035.
	AccountId string `protobuf:"bytes,2,opt,name=account_id,json=accountId,proto3" json:"account_id,omitempty"`
	// The [ServiceAccount][google.iam.admin.v1.ServiceAccount] resource to
	// create. Currently, only the following values are user assignable:
	// `display_name` and `description`.
	ServiceAccount       *ServiceAccount `protobuf:"bytes,3,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *CreateServiceAccountRequest) Reset()         { *m = CreateServiceAccountRequest{} }
func (m *CreateServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceAccountRequest) ProtoMessage()    {}
func (*CreateServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{1}
}

func (m *CreateServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceAccountRequest.Unmarshal(m, b)
}
func (m *CreateServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceAccountRequest.Marshal(b, m, deterministic)
}
func (m *CreateServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceAccountRequest.Merge(m, src)
}
func (m *CreateServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_CreateServiceAccountRequest.Size(m)
}
func (m *CreateServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceAccountRequest proto.InternalMessageInfo

func (m *CreateServiceAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateServiceAccountRequest) GetAccountId() string {
	if m != nil {
		return m.AccountId
	}
	return ""
}

func (m *CreateServiceAccountRequest) GetServiceAccount() *ServiceAccount {
	if m != nil {
		return m.ServiceAccount
	}
	return nil
}

// The service account list request.
type ListServiceAccountsRequest struct {
	// Required. The resource name of the project associated with the service
	// accounts, such as `projects/my-project-123`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional limit on the number of service accounts to include in the
	// response. Further accounts can subsequently be obtained by including the
	// [ListServiceAccountsResponse.next_page_token][google.iam.admin.v1.ListServiceAccountsResponse.next_page_token]
	// in a subsequent request.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token returned in an earlier
	// [ListServiceAccountsResponse.next_page_token][google.iam.admin.v1.ListServiceAccountsResponse.next_page_token].
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceAccountsRequest) Reset()         { *m = ListServiceAccountsRequest{} }
func (m *ListServiceAccountsRequest) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountsRequest) ProtoMessage()    {}
func (*ListServiceAccountsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{2}
}

func (m *ListServiceAccountsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountsRequest.Unmarshal(m, b)
}
func (m *ListServiceAccountsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountsRequest.Marshal(b, m, deterministic)
}
func (m *ListServiceAccountsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountsRequest.Merge(m, src)
}
func (m *ListServiceAccountsRequest) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountsRequest.Size(m)
}
func (m *ListServiceAccountsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountsRequest proto.InternalMessageInfo

func (m *ListServiceAccountsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListServiceAccountsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListServiceAccountsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The service account list response.
type ListServiceAccountsResponse struct {
	// The list of matching service accounts.
	Accounts []*ServiceAccount `protobuf:"bytes,1,rep,name=accounts,proto3" json:"accounts,omitempty"`
	// To retrieve the next page of results, set
	// [ListServiceAccountsRequest.page_token][google.iam.admin.v1.ListServiceAccountsRequest.page_token]
	// to this value.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListServiceAccountsResponse) Reset()         { *m = ListServiceAccountsResponse{} }
func (m *ListServiceAccountsResponse) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountsResponse) ProtoMessage()    {}
func (*ListServiceAccountsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{3}
}

func (m *ListServiceAccountsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountsResponse.Unmarshal(m, b)
}
func (m *ListServiceAccountsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountsResponse.Marshal(b, m, deterministic)
}
func (m *ListServiceAccountsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountsResponse.Merge(m, src)
}
func (m *ListServiceAccountsResponse) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountsResponse.Size(m)
}
func (m *ListServiceAccountsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountsResponse proto.InternalMessageInfo

func (m *ListServiceAccountsResponse) GetAccounts() []*ServiceAccount {
	if m != nil {
		return m.Accounts
	}
	return nil
}

func (m *ListServiceAccountsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The service account get request.
type GetServiceAccountRequest struct {
	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServiceAccountRequest) Reset()         { *m = GetServiceAccountRequest{} }
func (m *GetServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceAccountRequest) ProtoMessage()    {}
func (*GetServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{4}
}

func (m *GetServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceAccountRequest.Unmarshal(m, b)
}
func (m *GetServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceAccountRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceAccountRequest.Merge(m, src)
}
func (m *GetServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceAccountRequest.Size(m)
}
func (m *GetServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceAccountRequest proto.InternalMessageInfo

func (m *GetServiceAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The service account delete request.
type DeleteServiceAccountRequest struct {
	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteServiceAccountRequest) Reset()         { *m = DeleteServiceAccountRequest{} }
func (m *DeleteServiceAccountRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteServiceAccountRequest) ProtoMessage()    {}
func (*DeleteServiceAccountRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{5}
}

func (m *DeleteServiceAccountRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteServiceAccountRequest.Unmarshal(m, b)
}
func (m *DeleteServiceAccountRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteServiceAccountRequest.Marshal(b, m, deterministic)
}
func (m *DeleteServiceAccountRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteServiceAccountRequest.Merge(m, src)
}
func (m *DeleteServiceAccountRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteServiceAccountRequest.Size(m)
}
func (m *DeleteServiceAccountRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteServiceAccountRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteServiceAccountRequest proto.InternalMessageInfo

func (m *DeleteServiceAccountRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The service account keys list request.
type ListServiceAccountKeysRequest struct {
	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	//
	// Using `-` as a wildcard for the `PROJECT_ID`, will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filters the types of keys the user wants to include in the list
	// response. Duplicate key types are not allowed. If no key type
	// is provided, all keys are returned.
	KeyTypes             []ListServiceAccountKeysRequest_KeyType `protobuf:"varint,2,rep,packed,name=key_types,json=keyTypes,proto3,enum=google.iam.admin.v1.ListServiceAccountKeysRequest_KeyType" json:"key_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *ListServiceAccountKeysRequest) Reset()         { *m = ListServiceAccountKeysRequest{} }
func (m *ListServiceAccountKeysRequest) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountKeysRequest) ProtoMessage()    {}
func (*ListServiceAccountKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{6}
}

func (m *ListServiceAccountKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountKeysRequest.Unmarshal(m, b)
}
func (m *ListServiceAccountKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountKeysRequest.Marshal(b, m, deterministic)
}
func (m *ListServiceAccountKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountKeysRequest.Merge(m, src)
}
func (m *ListServiceAccountKeysRequest) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountKeysRequest.Size(m)
}
func (m *ListServiceAccountKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountKeysRequest proto.InternalMessageInfo

func (m *ListServiceAccountKeysRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListServiceAccountKeysRequest) GetKeyTypes() []ListServiceAccountKeysRequest_KeyType {
	if m != nil {
		return m.KeyTypes
	}
	return nil
}

// The service account keys list response.
type ListServiceAccountKeysResponse struct {
	// The public keys for the service account.
	Keys                 []*ServiceAccountKey `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListServiceAccountKeysResponse) Reset()         { *m = ListServiceAccountKeysResponse{} }
func (m *ListServiceAccountKeysResponse) String() string { return proto.CompactTextString(m) }
func (*ListServiceAccountKeysResponse) ProtoMessage()    {}
func (*ListServiceAccountKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{7}
}

func (m *ListServiceAccountKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListServiceAccountKeysResponse.Unmarshal(m, b)
}
func (m *ListServiceAccountKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListServiceAccountKeysResponse.Marshal(b, m, deterministic)
}
func (m *ListServiceAccountKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListServiceAccountKeysResponse.Merge(m, src)
}
func (m *ListServiceAccountKeysResponse) XXX_Size() int {
	return xxx_messageInfo_ListServiceAccountKeysResponse.Size(m)
}
func (m *ListServiceAccountKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListServiceAccountKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListServiceAccountKeysResponse proto.InternalMessageInfo

func (m *ListServiceAccountKeysResponse) GetKeys() []*ServiceAccountKey {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The service account key get by id request.
type GetServiceAccountKeyRequest struct {
	// Required. The resource name of the service account key in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
	//
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The output format of the public key requested.
	// X509_PEM is the default output format.
	PublicKeyType        ServiceAccountPublicKeyType `protobuf:"varint,2,opt,name=public_key_type,json=publicKeyType,proto3,enum=google.iam.admin.v1.ServiceAccountPublicKeyType" json:"public_key_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *GetServiceAccountKeyRequest) Reset()         { *m = GetServiceAccountKeyRequest{} }
func (m *GetServiceAccountKeyRequest) String() string { return proto.CompactTextString(m) }
func (*GetServiceAccountKeyRequest) ProtoMessage()    {}
func (*GetServiceAccountKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{8}
}

func (m *GetServiceAccountKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServiceAccountKeyRequest.Unmarshal(m, b)
}
func (m *GetServiceAccountKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServiceAccountKeyRequest.Marshal(b, m, deterministic)
}
func (m *GetServiceAccountKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServiceAccountKeyRequest.Merge(m, src)
}
func (m *GetServiceAccountKeyRequest) XXX_Size() int {
	return xxx_messageInfo_GetServiceAccountKeyRequest.Size(m)
}
func (m *GetServiceAccountKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServiceAccountKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServiceAccountKeyRequest proto.InternalMessageInfo

func (m *GetServiceAccountKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetServiceAccountKeyRequest) GetPublicKeyType() ServiceAccountPublicKeyType {
	if m != nil {
		return m.PublicKeyType
	}
	return ServiceAccountPublicKeyType_TYPE_NONE
}

// Represents a service account key.
//
// A service account has two sets of key-pairs: user-managed, and
// system-managed.
//
// User-managed key-pairs can be created and deleted by users.  Users are
// responsible for rotating these keys periodically to ensure security of
// their service accounts.  Users retain the private key of these key-pairs,
// and Google retains ONLY the public key.
//
// System-managed keys are automatically rotated by Google, and are used for
// signing for a maximum of two weeks. The rotation process is probabilistic,
// and usage of the new key will gradually ramp up and down over the key's
// lifetime. We recommend caching the public key set for a service account for
// no more than 24 hours to ensure you have access to the latest keys.
//
// Public keys for all service accounts are also published at the OAuth2
// Service Account API.
type ServiceAccountKey struct {
	// The resource name of the service account key in the following format
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The output format for the private key.
	// Only provided in `CreateServiceAccountKey` responses, not
	// in `GetServiceAccountKey` or `ListServiceAccountKey` responses.
	//
	// Google never exposes system-managed private keys, and never retains
	// user-managed private keys.
	PrivateKeyType ServiceAccountPrivateKeyType `protobuf:"varint,2,opt,name=private_key_type,json=privateKeyType,proto3,enum=google.iam.admin.v1.ServiceAccountPrivateKeyType" json:"private_key_type,omitempty"`
	// Specifies the algorithm (and possibly key size) for the key.
	KeyAlgorithm ServiceAccountKeyAlgorithm `protobuf:"varint,8,opt,name=key_algorithm,json=keyAlgorithm,proto3,enum=google.iam.admin.v1.ServiceAccountKeyAlgorithm" json:"key_algorithm,omitempty"`
	// The private key data. Only provided in `CreateServiceAccountKey`
	// responses. Make sure to keep the private key data secure because it
	// allows for the assertion of the service account identity.
	// When base64 decoded, the private key data can be used to authenticate with
	// Google API client libraries and with
	// <a href="/sdk/gcloud/reference/auth/activate-service-account">gcloud
	// auth activate-service-account</a>.
	PrivateKeyData []byte `protobuf:"bytes,3,opt,name=private_key_data,json=privateKeyData,proto3" json:"private_key_data,omitempty"`
	// The public key data. Only provided in `GetServiceAccountKey` responses.
	PublicKeyData []byte `protobuf:"bytes,7,opt,name=public_key_data,json=publicKeyData,proto3" json:"public_key_data,omitempty"`
	// The key can be used after this timestamp.
	ValidAfterTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=valid_after_time,json=validAfterTime,proto3" json:"valid_after_time,omitempty"`
	// The key can be used before this timestamp.
	// For system-managed key pairs, this timestamp is the end time for the
	// private key signing operation. The public key could still be used
	// for verification for a few hours after this time.
	ValidBeforeTime      *timestamp.Timestamp `protobuf:"bytes,5,opt,name=valid_before_time,json=validBeforeTime,proto3" json:"valid_before_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ServiceAccountKey) Reset()         { *m = ServiceAccountKey{} }
func (m *ServiceAccountKey) String() string { return proto.CompactTextString(m) }
func (*ServiceAccountKey) ProtoMessage()    {}
func (*ServiceAccountKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{9}
}

func (m *ServiceAccountKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ServiceAccountKey.Unmarshal(m, b)
}
func (m *ServiceAccountKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ServiceAccountKey.Marshal(b, m, deterministic)
}
func (m *ServiceAccountKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ServiceAccountKey.Merge(m, src)
}
func (m *ServiceAccountKey) XXX_Size() int {
	return xxx_messageInfo_ServiceAccountKey.Size(m)
}
func (m *ServiceAccountKey) XXX_DiscardUnknown() {
	xxx_messageInfo_ServiceAccountKey.DiscardUnknown(m)
}

var xxx_messageInfo_ServiceAccountKey proto.InternalMessageInfo

func (m *ServiceAccountKey) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ServiceAccountKey) GetPrivateKeyType() ServiceAccountPrivateKeyType {
	if m != nil {
		return m.PrivateKeyType
	}
	return ServiceAccountPrivateKeyType_TYPE_UNSPECIFIED
}

func (m *ServiceAccountKey) GetKeyAlgorithm() ServiceAccountKeyAlgorithm {
	if m != nil {
		return m.KeyAlgorithm
	}
	return ServiceAccountKeyAlgorithm_KEY_ALG_UNSPECIFIED
}

func (m *ServiceAccountKey) GetPrivateKeyData() []byte {
	if m != nil {
		return m.PrivateKeyData
	}
	return nil
}

func (m *ServiceAccountKey) GetPublicKeyData() []byte {
	if m != nil {
		return m.PublicKeyData
	}
	return nil
}

func (m *ServiceAccountKey) GetValidAfterTime() *timestamp.Timestamp {
	if m != nil {
		return m.ValidAfterTime
	}
	return nil
}

func (m *ServiceAccountKey) GetValidBeforeTime() *timestamp.Timestamp {
	if m != nil {
		return m.ValidBeforeTime
	}
	return nil
}

// The service account key create request.
type CreateServiceAccountKeyRequest struct {
	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The output format of the private key. The default value is
	// `TYPE_GOOGLE_CREDENTIALS_FILE`, which is the Google Credentials File
	// format.
	PrivateKeyType ServiceAccountPrivateKeyType `protobuf:"varint,2,opt,name=private_key_type,json=privateKeyType,proto3,enum=google.iam.admin.v1.ServiceAccountPrivateKeyType" json:"private_key_type,omitempty"`
	// Which type of key and algorithm to use for the key.
	// The default is currently a 2K RSA key.  However this may change in the
	// future.
	KeyAlgorithm         ServiceAccountKeyAlgorithm `protobuf:"varint,3,opt,name=key_algorithm,json=keyAlgorithm,proto3,enum=google.iam.admin.v1.ServiceAccountKeyAlgorithm" json:"key_algorithm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *CreateServiceAccountKeyRequest) Reset()         { *m = CreateServiceAccountKeyRequest{} }
func (m *CreateServiceAccountKeyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateServiceAccountKeyRequest) ProtoMessage()    {}
func (*CreateServiceAccountKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{10}
}

func (m *CreateServiceAccountKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateServiceAccountKeyRequest.Unmarshal(m, b)
}
func (m *CreateServiceAccountKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateServiceAccountKeyRequest.Marshal(b, m, deterministic)
}
func (m *CreateServiceAccountKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateServiceAccountKeyRequest.Merge(m, src)
}
func (m *CreateServiceAccountKeyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateServiceAccountKeyRequest.Size(m)
}
func (m *CreateServiceAccountKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateServiceAccountKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateServiceAccountKeyRequest proto.InternalMessageInfo

func (m *CreateServiceAccountKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateServiceAccountKeyRequest) GetPrivateKeyType() ServiceAccountPrivateKeyType {
	if m != nil {
		return m.PrivateKeyType
	}
	return ServiceAccountPrivateKeyType_TYPE_UNSPECIFIED
}

func (m *CreateServiceAccountKeyRequest) GetKeyAlgorithm() ServiceAccountKeyAlgorithm {
	if m != nil {
		return m.KeyAlgorithm
	}
	return ServiceAccountKeyAlgorithm_KEY_ALG_UNSPECIFIED
}

// The service account key delete request.
type DeleteServiceAccountKeyRequest struct {
	// Required. The resource name of the service account key in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteServiceAccountKeyRequest) Reset()         { *m = DeleteServiceAccountKeyRequest{} }
func (m *DeleteServiceAccountKeyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteServiceAccountKeyRequest) ProtoMessage()    {}
func (*DeleteServiceAccountKeyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{11}
}

func (m *DeleteServiceAccountKeyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteServiceAccountKeyRequest.Unmarshal(m, b)
}
func (m *DeleteServiceAccountKeyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteServiceAccountKeyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteServiceAccountKeyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteServiceAccountKeyRequest.Merge(m, src)
}
func (m *DeleteServiceAccountKeyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteServiceAccountKeyRequest.Size(m)
}
func (m *DeleteServiceAccountKeyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteServiceAccountKeyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteServiceAccountKeyRequest proto.InternalMessageInfo

func (m *DeleteServiceAccountKeyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The service account sign blob request.
type SignBlobRequest struct {
	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The bytes to sign.
	BytesToSign          []byte   `protobuf:"bytes,2,opt,name=bytes_to_sign,json=bytesToSign,proto3" json:"bytes_to_sign,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SignBlobRequest) Reset()         { *m = SignBlobRequest{} }
func (m *SignBlobRequest) String() string { return proto.CompactTextString(m) }
func (*SignBlobRequest) ProtoMessage()    {}
func (*SignBlobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{12}
}

func (m *SignBlobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SignBlobRequest.Unmarshal(m, b)
}
func (m *SignBlobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SignBlobRequest.Marshal(b, m, deterministic)
}
func (m *SignBlobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignBlobRequest.Merge(m, src)
}
func (m *SignBlobRequest) XXX_Size() int {
	return xxx_messageInfo_SignBlobRequest.Size(m)
}
func (m *SignBlobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SignBlobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SignBlobRequest proto.InternalMessageInfo

func (m *SignBlobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SignBlobRequest) GetBytesToSign() []byte {
	if m != nil {
		return m.BytesToSign
	}
	return nil
}

// The service account sign blob response.
type SignBlobResponse struct {
	// The id of the key used to sign the blob.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// The signed blob.
	Signature            []byte   `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SignBlobResponse) Reset()         { *m = SignBlobResponse{} }
func (m *SignBlobResponse) String() string { return proto.CompactTextString(m) }
func (*SignBlobResponse) ProtoMessage()    {}
func (*SignBlobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{13}
}

func (m *SignBlobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SignBlobResponse.Unmarshal(m, b)
}
func (m *SignBlobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SignBlobResponse.Marshal(b, m, deterministic)
}
func (m *SignBlobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignBlobResponse.Merge(m, src)
}
func (m *SignBlobResponse) XXX_Size() int {
	return xxx_messageInfo_SignBlobResponse.Size(m)
}
func (m *SignBlobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SignBlobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SignBlobResponse proto.InternalMessageInfo

func (m *SignBlobResponse) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *SignBlobResponse) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

// The service account sign JWT request.
type SignJwtRequest struct {
	// Required. The resource name of the service account in the following format:
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
	// Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
	// the account. The `ACCOUNT` value can be the `email` address or the
	// `unique_id` of the service account.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The JWT payload to sign, a JSON JWT Claim set.
	Payload              string   `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SignJwtRequest) Reset()         { *m = SignJwtRequest{} }
func (m *SignJwtRequest) String() string { return proto.CompactTextString(m) }
func (*SignJwtRequest) ProtoMessage()    {}
func (*SignJwtRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{14}
}

func (m *SignJwtRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SignJwtRequest.Unmarshal(m, b)
}
func (m *SignJwtRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SignJwtRequest.Marshal(b, m, deterministic)
}
func (m *SignJwtRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignJwtRequest.Merge(m, src)
}
func (m *SignJwtRequest) XXX_Size() int {
	return xxx_messageInfo_SignJwtRequest.Size(m)
}
func (m *SignJwtRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SignJwtRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SignJwtRequest proto.InternalMessageInfo

func (m *SignJwtRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SignJwtRequest) GetPayload() string {
	if m != nil {
		return m.Payload
	}
	return ""
}

// The service account sign JWT response.
type SignJwtResponse struct {
	// The id of the key used to sign the JWT.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// The signed JWT.
	SignedJwt            string   `protobuf:"bytes,2,opt,name=signed_jwt,json=signedJwt,proto3" json:"signed_jwt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SignJwtResponse) Reset()         { *m = SignJwtResponse{} }
func (m *SignJwtResponse) String() string { return proto.CompactTextString(m) }
func (*SignJwtResponse) ProtoMessage()    {}
func (*SignJwtResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{15}
}

func (m *SignJwtResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SignJwtResponse.Unmarshal(m, b)
}
func (m *SignJwtResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SignJwtResponse.Marshal(b, m, deterministic)
}
func (m *SignJwtResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignJwtResponse.Merge(m, src)
}
func (m *SignJwtResponse) XXX_Size() int {
	return xxx_messageInfo_SignJwtResponse.Size(m)
}
func (m *SignJwtResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SignJwtResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SignJwtResponse proto.InternalMessageInfo

func (m *SignJwtResponse) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *SignJwtResponse) GetSignedJwt() string {
	if m != nil {
		return m.SignedJwt
	}
	return ""
}

// A role in the Identity and Access Management API.
type Role struct {
	// The name of the role.
	//
	// When Role is used in CreateRole, the role name must not be set.
	//
	// When Role is used in output and other input such as UpdateRole, the role
	// name is the complete path, e.g., roles/logging.viewer for predefined roles
	// and organizations/{ORGANIZATION_ID}/roles/logging.viewer for custom roles.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A human-readable title for the role.  Typically this
	// is limited to 100 UTF-8 bytes.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. A human-readable description for the role.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The names of the permissions this role grants when bound in an IAM policy.
	IncludedPermissions []string `protobuf:"bytes,7,rep,name=included_permissions,json=includedPermissions,proto3" json:"included_permissions,omitempty"`
	// The current launch stage of the role. If the `ALPHA` launch stage has been
	// selected for a role, the `stage` field will not be included in the
	// returned definition for the role.
	Stage Role_RoleLaunchStage `protobuf:"varint,8,opt,name=stage,proto3,enum=google.iam.admin.v1.Role_RoleLaunchStage" json:"stage,omitempty"`
	// Used to perform a consistent read-modify-write.
	Etag []byte `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// The current deleted state of the role. This field is read only.
	// It will be ignored in calls to CreateRole and UpdateRole.
	Deleted              bool     `protobuf:"varint,11,opt,name=deleted,proto3" json:"deleted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Role) Reset()         { *m = Role{} }
func (m *Role) String() string { return proto.CompactTextString(m) }
func (*Role) ProtoMessage()    {}
func (*Role) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{16}
}

func (m *Role) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Role.Unmarshal(m, b)
}
func (m *Role) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Role.Marshal(b, m, deterministic)
}
func (m *Role) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Role.Merge(m, src)
}
func (m *Role) XXX_Size() int {
	return xxx_messageInfo_Role.Size(m)
}
func (m *Role) XXX_DiscardUnknown() {
	xxx_messageInfo_Role.DiscardUnknown(m)
}

var xxx_messageInfo_Role proto.InternalMessageInfo

func (m *Role) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Role) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Role) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Role) GetIncludedPermissions() []string {
	if m != nil {
		return m.IncludedPermissions
	}
	return nil
}

func (m *Role) GetStage() Role_RoleLaunchStage {
	if m != nil {
		return m.Stage
	}
	return Role_ALPHA
}

func (m *Role) GetEtag() []byte {
	if m != nil {
		return m.Etag
	}
	return nil
}

func (m *Role) GetDeleted() bool {
	if m != nil {
		return m.Deleted
	}
	return false
}

// The grantable role query request.
type QueryGrantableRolesRequest struct {
	// Required. The full resource name to query from the list of grantable roles.
	//
	// The name follows the Google Cloud Platform resource format.
	// For example, a Cloud Platform project with id `my-project` will be named
	// `//cloudresourcemanager.googleapis.com/projects/my-project`.
	FullResourceName string   `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	View             RoleView `protobuf:"varint,2,opt,name=view,proto3,enum=google.iam.admin.v1.RoleView" json:"view,omitempty"`
	// Optional limit on the number of roles to include in the response.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token returned in an earlier
	// QueryGrantableRolesResponse.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryGrantableRolesRequest) Reset()         { *m = QueryGrantableRolesRequest{} }
func (m *QueryGrantableRolesRequest) String() string { return proto.CompactTextString(m) }
func (*QueryGrantableRolesRequest) ProtoMessage()    {}
func (*QueryGrantableRolesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{17}
}

func (m *QueryGrantableRolesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryGrantableRolesRequest.Unmarshal(m, b)
}
func (m *QueryGrantableRolesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryGrantableRolesRequest.Marshal(b, m, deterministic)
}
func (m *QueryGrantableRolesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryGrantableRolesRequest.Merge(m, src)
}
func (m *QueryGrantableRolesRequest) XXX_Size() int {
	return xxx_messageInfo_QueryGrantableRolesRequest.Size(m)
}
func (m *QueryGrantableRolesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryGrantableRolesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryGrantableRolesRequest proto.InternalMessageInfo

func (m *QueryGrantableRolesRequest) GetFullResourceName() string {
	if m != nil {
		return m.FullResourceName
	}
	return ""
}

func (m *QueryGrantableRolesRequest) GetView() RoleView {
	if m != nil {
		return m.View
	}
	return RoleView_BASIC
}

func (m *QueryGrantableRolesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *QueryGrantableRolesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The grantable role query response.
type QueryGrantableRolesResponse struct {
	// The list of matching roles.
	Roles []*Role `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	// To retrieve the next page of results, set
	// `QueryGrantableRolesRequest.page_token` to this value.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryGrantableRolesResponse) Reset()         { *m = QueryGrantableRolesResponse{} }
func (m *QueryGrantableRolesResponse) String() string { return proto.CompactTextString(m) }
func (*QueryGrantableRolesResponse) ProtoMessage()    {}
func (*QueryGrantableRolesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{18}
}

func (m *QueryGrantableRolesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryGrantableRolesResponse.Unmarshal(m, b)
}
func (m *QueryGrantableRolesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryGrantableRolesResponse.Marshal(b, m, deterministic)
}
func (m *QueryGrantableRolesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryGrantableRolesResponse.Merge(m, src)
}
func (m *QueryGrantableRolesResponse) XXX_Size() int {
	return xxx_messageInfo_QueryGrantableRolesResponse.Size(m)
}
func (m *QueryGrantableRolesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryGrantableRolesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryGrantableRolesResponse proto.InternalMessageInfo

func (m *QueryGrantableRolesResponse) GetRoles() []*Role {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *QueryGrantableRolesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request to get all roles defined under a resource.
type ListRolesRequest struct {
	// The `parent` parameter's value depends on the target resource for the
	// request, namely
	// [`roles`](/iam/reference/rest/v1/roles),
	// [`projects`](/iam/reference/rest/v1/projects.roles), or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `parent` value format is described below:
	//
	// * [`roles.list()`](/iam/reference/rest/v1/roles/list): An empty string.
	//   This method doesn't require a resource; it simply returns all
	//   [predefined roles](/iam/docs/understanding-roles#predefined_roles) in
	//   Cloud IAM. Example request URL:
	//   `https://iam.googleapis.com/v1/roles`
	//
	// * [`projects.roles.list()`](/iam/reference/rest/v1/projects.roles/list):
	//   `projects/{PROJECT_ID}`. This method lists all project-level
	//   [custom roles](/iam/docs/understanding-custom-roles).
	//   Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles`
	//
	// * [`organizations.roles.list()`](/iam/reference/rest/v1/organizations.roles/list):
	//   `organizations/{ORGANIZATION_ID}`. This method lists all
	//   organization-level [custom roles](/iam/docs/understanding-custom-roles).
	//   Example request URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional limit on the number of roles to include in the response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token returned in an earlier ListRolesResponse.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional view for the returned Role objects. When `FULL` is specified,
	// the `includedPermissions` field is returned, which includes a list of all
	// permissions in the role. The default value is `BASIC`, which does not
	// return the `includedPermissions` field.
	View RoleView `protobuf:"varint,4,opt,name=view,proto3,enum=google.iam.admin.v1.RoleView" json:"view,omitempty"`
	// Include Roles that have been deleted.
	ShowDeleted          bool     `protobuf:"varint,6,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRolesRequest) Reset()         { *m = ListRolesRequest{} }
func (m *ListRolesRequest) String() string { return proto.CompactTextString(m) }
func (*ListRolesRequest) ProtoMessage()    {}
func (*ListRolesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{19}
}

func (m *ListRolesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRolesRequest.Unmarshal(m, b)
}
func (m *ListRolesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRolesRequest.Marshal(b, m, deterministic)
}
func (m *ListRolesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRolesRequest.Merge(m, src)
}
func (m *ListRolesRequest) XXX_Size() int {
	return xxx_messageInfo_ListRolesRequest.Size(m)
}
func (m *ListRolesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRolesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRolesRequest proto.InternalMessageInfo

func (m *ListRolesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListRolesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListRolesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListRolesRequest) GetView() RoleView {
	if m != nil {
		return m.View
	}
	return RoleView_BASIC
}

func (m *ListRolesRequest) GetShowDeleted() bool {
	if m != nil {
		return m.ShowDeleted
	}
	return false
}

// The response containing the roles defined under a resource.
type ListRolesResponse struct {
	// The Roles defined on this resource.
	Roles []*Role `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	// To retrieve the next page of results, set
	// `ListRolesRequest.page_token` to this value.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRolesResponse) Reset()         { *m = ListRolesResponse{} }
func (m *ListRolesResponse) String() string { return proto.CompactTextString(m) }
func (*ListRolesResponse) ProtoMessage()    {}
func (*ListRolesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{20}
}

func (m *ListRolesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListRolesResponse.Unmarshal(m, b)
}
func (m *ListRolesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListRolesResponse.Marshal(b, m, deterministic)
}
func (m *ListRolesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRolesResponse.Merge(m, src)
}
func (m *ListRolesResponse) XXX_Size() int {
	return xxx_messageInfo_ListRolesResponse.Size(m)
}
func (m *ListRolesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRolesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListRolesResponse proto.InternalMessageInfo

func (m *ListRolesResponse) GetRoles() []*Role {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *ListRolesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request to get the definition of an existing role.
type GetRoleRequest struct {
	// The `name` parameter's value depends on the target resource for the
	// request, namely
	// [`roles`](/iam/reference/rest/v1/roles),
	// [`projects`](/iam/reference/rest/v1/projects.roles), or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `name` value format is described below:
	//
	// * [`roles.get()`](/iam/reference/rest/v1/roles/get): `roles/{ROLE_NAME}`.
	//   This method returns results from all
	//   [predefined roles](/iam/docs/understanding-roles#predefined_roles) in
	//   Cloud IAM. Example request URL:
	//   `https://iam.googleapis.com/v1/roles/{ROLE_NAME}`
	//
	// * [`projects.roles.get()`](/iam/reference/rest/v1/projects.roles/get):
	//   `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method returns only
	//   [custom roles](/iam/docs/understanding-custom-roles) that have been
	//   created at the project level. Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// * [`organizations.roles.get()`](/iam/reference/rest/v1/organizations.roles/get):
	//   `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method
	//   returns only [custom roles](/iam/docs/understanding-custom-roles) that
	//   have been created at the organization level. Example request URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetRoleRequest) Reset()         { *m = GetRoleRequest{} }
func (m *GetRoleRequest) String() string { return proto.CompactTextString(m) }
func (*GetRoleRequest) ProtoMessage()    {}
func (*GetRoleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{21}
}

func (m *GetRoleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetRoleRequest.Unmarshal(m, b)
}
func (m *GetRoleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetRoleRequest.Marshal(b, m, deterministic)
}
func (m *GetRoleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetRoleRequest.Merge(m, src)
}
func (m *GetRoleRequest) XXX_Size() int {
	return xxx_messageInfo_GetRoleRequest.Size(m)
}
func (m *GetRoleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetRoleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetRoleRequest proto.InternalMessageInfo

func (m *GetRoleRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request to create a new role.
type CreateRoleRequest struct {
	// The `parent` parameter's value depends on the target resource for the
	// request, namely
	// [`projects`](/iam/reference/rest/v1/projects.roles) or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `parent` value format is described below:
	//
	// * [`projects.roles.create()`](/iam/reference/rest/v1/projects.roles/create):
	//   `projects/{PROJECT_ID}`. This method creates project-level
	//   [custom roles](/iam/docs/understanding-custom-roles).
	//   Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles`
	//
	// * [`organizations.roles.create()`](/iam/reference/rest/v1/organizations.roles/create):
	//   `organizations/{ORGANIZATION_ID}`. This method creates organization-level
	//   [custom roles](/iam/docs/understanding-custom-roles). Example request
	//   URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The role ID to use for this role.
	RoleId string `protobuf:"bytes,2,opt,name=role_id,json=roleId,proto3" json:"role_id,omitempty"`
	// The Role resource to create.
	Role                 *Role    `protobuf:"bytes,3,opt,name=role,proto3" json:"role,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateRoleRequest) Reset()         { *m = CreateRoleRequest{} }
func (m *CreateRoleRequest) String() string { return proto.CompactTextString(m) }
func (*CreateRoleRequest) ProtoMessage()    {}
func (*CreateRoleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{22}
}

func (m *CreateRoleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateRoleRequest.Unmarshal(m, b)
}
func (m *CreateRoleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateRoleRequest.Marshal(b, m, deterministic)
}
func (m *CreateRoleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateRoleRequest.Merge(m, src)
}
func (m *CreateRoleRequest) XXX_Size() int {
	return xxx_messageInfo_CreateRoleRequest.Size(m)
}
func (m *CreateRoleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateRoleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateRoleRequest proto.InternalMessageInfo

func (m *CreateRoleRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateRoleRequest) GetRoleId() string {
	if m != nil {
		return m.RoleId
	}
	return ""
}

func (m *CreateRoleRequest) GetRole() *Role {
	if m != nil {
		return m.Role
	}
	return nil
}

// The request to update a role.
type UpdateRoleRequest struct {
	// The `name` parameter's value depends on the target resource for the
	// request, namely
	// [`projects`](/iam/reference/rest/v1/projects.roles) or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `name` value format is described below:
	//
	// * [`projects.roles.patch()`](/iam/reference/rest/v1/projects.roles/patch):
	//   `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method updates only
	//   [custom roles](/iam/docs/understanding-custom-roles) that have been
	//   created at the project level. Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// * [`organizations.roles.patch()`](/iam/reference/rest/v1/organizations.roles/patch):
	//   `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method
	//   updates only [custom roles](/iam/docs/understanding-custom-roles) that
	//   have been created at the organization level. Example request URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The updated role.
	Role *Role `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	// A mask describing which fields in the Role have changed.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateRoleRequest) Reset()         { *m = UpdateRoleRequest{} }
func (m *UpdateRoleRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateRoleRequest) ProtoMessage()    {}
func (*UpdateRoleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{23}
}

func (m *UpdateRoleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateRoleRequest.Unmarshal(m, b)
}
func (m *UpdateRoleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateRoleRequest.Marshal(b, m, deterministic)
}
func (m *UpdateRoleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateRoleRequest.Merge(m, src)
}
func (m *UpdateRoleRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateRoleRequest.Size(m)
}
func (m *UpdateRoleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateRoleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateRoleRequest proto.InternalMessageInfo

func (m *UpdateRoleRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateRoleRequest) GetRole() *Role {
	if m != nil {
		return m.Role
	}
	return nil
}

func (m *UpdateRoleRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request to delete an existing role.
type DeleteRoleRequest struct {
	// The `name` parameter's value depends on the target resource for the
	// request, namely
	// [`projects`](/iam/reference/rest/v1/projects.roles) or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `name` value format is described below:
	//
	// * [`projects.roles.delete()`](/iam/reference/rest/v1/projects.roles/delete):
	//   `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method deletes only
	//   [custom roles](/iam/docs/understanding-custom-roles) that have been
	//   created at the project level. Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// * [`organizations.roles.delete()`](/iam/reference/rest/v1/organizations.roles/delete):
	//   `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method
	//   deletes only [custom roles](/iam/docs/understanding-custom-roles) that
	//   have been created at the organization level. Example request URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Used to perform a consistent read-modify-write.
	Etag                 []byte   `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteRoleRequest) Reset()         { *m = DeleteRoleRequest{} }
func (m *DeleteRoleRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteRoleRequest) ProtoMessage()    {}
func (*DeleteRoleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{24}
}

func (m *DeleteRoleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteRoleRequest.Unmarshal(m, b)
}
func (m *DeleteRoleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteRoleRequest.Marshal(b, m, deterministic)
}
func (m *DeleteRoleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteRoleRequest.Merge(m, src)
}
func (m *DeleteRoleRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteRoleRequest.Size(m)
}
func (m *DeleteRoleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteRoleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteRoleRequest proto.InternalMessageInfo

func (m *DeleteRoleRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteRoleRequest) GetEtag() []byte {
	if m != nil {
		return m.Etag
	}
	return nil
}

// The request to undelete an existing role.
type UndeleteRoleRequest struct {
	// The `name` parameter's value depends on the target resource for the
	// request, namely
	// [`projects`](/iam/reference/rest/v1/projects.roles) or
	// [`organizations`](/iam/reference/rest/v1/organizations.roles). Each
	// resource type's `name` value format is described below:
	//
	// * [`projects.roles.undelete()`](/iam/reference/rest/v1/projects.roles/undelete):
	//   `projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`. This method undeletes
	//   only [custom roles](/iam/docs/understanding-custom-roles) that have been
	//   created at the project level. Example request URL:
	//   `https://iam.googleapis.com/v1/projects/{PROJECT_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// * [`organizations.roles.undelete()`](/iam/reference/rest/v1/organizations.roles/undelete):
	//   `organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`. This method
	//   undeletes only [custom roles](/iam/docs/understanding-custom-roles) that
	//   have been created at the organization level. Example request URL:
	//   `https://iam.googleapis.com/v1/organizations/{ORGANIZATION_ID}/roles/{CUSTOM_ROLE_ID}`
	//
	// Note: Wildcard (*) values are invalid; you must specify a complete project
	// ID or organization ID.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Used to perform a consistent read-modify-write.
	Etag                 []byte   `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UndeleteRoleRequest) Reset()         { *m = UndeleteRoleRequest{} }
func (m *UndeleteRoleRequest) String() string { return proto.CompactTextString(m) }
func (*UndeleteRoleRequest) ProtoMessage()    {}
func (*UndeleteRoleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{25}
}

func (m *UndeleteRoleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UndeleteRoleRequest.Unmarshal(m, b)
}
func (m *UndeleteRoleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UndeleteRoleRequest.Marshal(b, m, deterministic)
}
func (m *UndeleteRoleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UndeleteRoleRequest.Merge(m, src)
}
func (m *UndeleteRoleRequest) XXX_Size() int {
	return xxx_messageInfo_UndeleteRoleRequest.Size(m)
}
func (m *UndeleteRoleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UndeleteRoleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UndeleteRoleRequest proto.InternalMessageInfo

func (m *UndeleteRoleRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UndeleteRoleRequest) GetEtag() []byte {
	if m != nil {
		return m.Etag
	}
	return nil
}

// A permission which can be included by a role.
type Permission struct {
	// The name of this Permission.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The title of this Permission.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// A brief description of what this Permission is used for.
	// This permission can ONLY be used in predefined roles.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// This permission can ONLY be used in predefined roles.
	OnlyInPredefinedRoles bool `protobuf:"varint,4,opt,name=only_in_predefined_roles,json=onlyInPredefinedRoles,proto3" json:"only_in_predefined_roles,omitempty"`
	// The current launch stage of the permission.
	Stage Permission_PermissionLaunchStage `protobuf:"varint,5,opt,name=stage,proto3,enum=google.iam.admin.v1.Permission_PermissionLaunchStage" json:"stage,omitempty"`
	// The current custom role support level.
	CustomRolesSupportLevel Permission_CustomRolesSupportLevel `protobuf:"varint,6,opt,name=custom_roles_support_level,json=customRolesSupportLevel,proto3,enum=google.iam.admin.v1.Permission_CustomRolesSupportLevel" json:"custom_roles_support_level,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                           `json:"-"`
	XXX_unrecognized        []byte                             `json:"-"`
	XXX_sizecache           int32                              `json:"-"`
}

func (m *Permission) Reset()         { *m = Permission{} }
func (m *Permission) String() string { return proto.CompactTextString(m) }
func (*Permission) ProtoMessage()    {}
func (*Permission) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{26}
}

func (m *Permission) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Permission.Unmarshal(m, b)
}
func (m *Permission) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Permission.Marshal(b, m, deterministic)
}
func (m *Permission) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Permission.Merge(m, src)
}
func (m *Permission) XXX_Size() int {
	return xxx_messageInfo_Permission.Size(m)
}
func (m *Permission) XXX_DiscardUnknown() {
	xxx_messageInfo_Permission.DiscardUnknown(m)
}

var xxx_messageInfo_Permission proto.InternalMessageInfo

func (m *Permission) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Permission) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Permission) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Permission) GetOnlyInPredefinedRoles() bool {
	if m != nil {
		return m.OnlyInPredefinedRoles
	}
	return false
}

func (m *Permission) GetStage() Permission_PermissionLaunchStage {
	if m != nil {
		return m.Stage
	}
	return Permission_ALPHA
}

func (m *Permission) GetCustomRolesSupportLevel() Permission_CustomRolesSupportLevel {
	if m != nil {
		return m.CustomRolesSupportLevel
	}
	return Permission_SUPPORTED
}

// A request to get permissions which can be tested on a resource.
type QueryTestablePermissionsRequest struct {
	// Required. The full resource name to query from the list of testable
	// permissions.
	//
	// The name follows the Google Cloud Platform resource format.
	// For example, a Cloud Platform project with id `my-project` will be named
	// `//cloudresourcemanager.googleapis.com/projects/my-project`.
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// Optional limit on the number of permissions to include in the response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional pagination token returned in an earlier
	// QueryTestablePermissionsRequest.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryTestablePermissionsRequest) Reset()         { *m = QueryTestablePermissionsRequest{} }
func (m *QueryTestablePermissionsRequest) String() string { return proto.CompactTextString(m) }
func (*QueryTestablePermissionsRequest) ProtoMessage()    {}
func (*QueryTestablePermissionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{27}
}

func (m *QueryTestablePermissionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryTestablePermissionsRequest.Unmarshal(m, b)
}
func (m *QueryTestablePermissionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryTestablePermissionsRequest.Marshal(b, m, deterministic)
}
func (m *QueryTestablePermissionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryTestablePermissionsRequest.Merge(m, src)
}
func (m *QueryTestablePermissionsRequest) XXX_Size() int {
	return xxx_messageInfo_QueryTestablePermissionsRequest.Size(m)
}
func (m *QueryTestablePermissionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryTestablePermissionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryTestablePermissionsRequest proto.InternalMessageInfo

func (m *QueryTestablePermissionsRequest) GetFullResourceName() string {
	if m != nil {
		return m.FullResourceName
	}
	return ""
}

func (m *QueryTestablePermissionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *QueryTestablePermissionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response containing permissions which can be tested on a resource.
type QueryTestablePermissionsResponse struct {
	// The Permissions testable on the requested resource.
	Permissions []*Permission `protobuf:"bytes,1,rep,name=permissions,proto3" json:"permissions,omitempty"`
	// To retrieve the next page of results, set
	// `QueryTestableRolesRequest.page_token` to this value.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryTestablePermissionsResponse) Reset()         { *m = QueryTestablePermissionsResponse{} }
func (m *QueryTestablePermissionsResponse) String() string { return proto.CompactTextString(m) }
func (*QueryTestablePermissionsResponse) ProtoMessage()    {}
func (*QueryTestablePermissionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ffbc3f16f9a3a9d, []int{28}
}

func (m *QueryTestablePermissionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryTestablePermissionsResponse.Unmarshal(m, b)
}
func (m *QueryTestablePermissionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryTestablePermissionsResponse.Marshal(b, m, deterministic)
}
func (m *QueryTestablePermissionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryTestablePermissionsResponse.Merge(m, src)
}
func (m *QueryTestablePermissionsResponse) XXX_Size() int {
	return xxx_messageInfo_QueryTestablePermissionsResponse.Size(m)
}
func (m *QueryTestablePermissionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryTestablePermissionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryTestablePermissionsResponse proto.InternalMessageInfo

func (m *QueryTestablePermissionsResponse) GetPermissions() []*Permission {
	if m != nil {
		return m.Permissions
	}
	return nil
}

func (m *QueryTestablePermissionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.iam.admin.v1.ServiceAccountKeyAlgorithm", ServiceAccountKeyAlgorithm_name, ServiceAccountKeyAlgorithm_value)
	proto.RegisterEnum("google.iam.admin.v1.ServiceAccountPrivateKeyType", ServiceAccountPrivateKeyType_name, ServiceAccountPrivateKeyType_value)
	proto.RegisterEnum("google.iam.admin.v1.ServiceAccountPublicKeyType", ServiceAccountPublicKeyType_name, ServiceAccountPublicKeyType_value)
	proto.RegisterEnum("google.iam.admin.v1.RoleView", RoleView_name, RoleView_value)
	proto.RegisterEnum("google.iam.admin.v1.ListServiceAccountKeysRequest_KeyType", ListServiceAccountKeysRequest_KeyType_name, ListServiceAccountKeysRequest_KeyType_value)
	proto.RegisterEnum("google.iam.admin.v1.Role_RoleLaunchStage", Role_RoleLaunchStage_name, Role_RoleLaunchStage_value)
	proto.RegisterEnum("google.iam.admin.v1.Permission_PermissionLaunchStage", Permission_PermissionLaunchStage_name, Permission_PermissionLaunchStage_value)
	proto.RegisterEnum("google.iam.admin.v1.Permission_CustomRolesSupportLevel", Permission_CustomRolesSupportLevel_name, Permission_CustomRolesSupportLevel_value)
	proto.RegisterType((*ServiceAccount)(nil), "google.iam.admin.v1.ServiceAccount")
	proto.RegisterType((*CreateServiceAccountRequest)(nil), "google.iam.admin.v1.CreateServiceAccountRequest")
	proto.RegisterType((*ListServiceAccountsRequest)(nil), "google.iam.admin.v1.ListServiceAccountsRequest")
	proto.RegisterType((*ListServiceAccountsResponse)(nil), "google.iam.admin.v1.ListServiceAccountsResponse")
	proto.RegisterType((*GetServiceAccountRequest)(nil), "google.iam.admin.v1.GetServiceAccountRequest")
	proto.RegisterType((*DeleteServiceAccountRequest)(nil), "google.iam.admin.v1.DeleteServiceAccountRequest")
	proto.RegisterType((*ListServiceAccountKeysRequest)(nil), "google.iam.admin.v1.ListServiceAccountKeysRequest")
	proto.RegisterType((*ListServiceAccountKeysResponse)(nil), "google.iam.admin.v1.ListServiceAccountKeysResponse")
	proto.RegisterType((*GetServiceAccountKeyRequest)(nil), "google.iam.admin.v1.GetServiceAccountKeyRequest")
	proto.RegisterType((*ServiceAccountKey)(nil), "google.iam.admin.v1.ServiceAccountKey")
	proto.RegisterType((*CreateServiceAccountKeyRequest)(nil), "google.iam.admin.v1.CreateServiceAccountKeyRequest")
	proto.RegisterType((*DeleteServiceAccountKeyRequest)(nil), "google.iam.admin.v1.DeleteServiceAccountKeyRequest")
	proto.RegisterType((*SignBlobRequest)(nil), "google.iam.admin.v1.SignBlobRequest")
	proto.RegisterType((*SignBlobResponse)(nil), "google.iam.admin.v1.SignBlobResponse")
	proto.RegisterType((*SignJwtRequest)(nil), "google.iam.admin.v1.SignJwtRequest")
	proto.RegisterType((*SignJwtResponse)(nil), "google.iam.admin.v1.SignJwtResponse")
	proto.RegisterType((*Role)(nil), "google.iam.admin.v1.Role")
	proto.RegisterType((*QueryGrantableRolesRequest)(nil), "google.iam.admin.v1.QueryGrantableRolesRequest")
	proto.RegisterType((*QueryGrantableRolesResponse)(nil), "google.iam.admin.v1.QueryGrantableRolesResponse")
	proto.RegisterType((*ListRolesRequest)(nil), "google.iam.admin.v1.ListRolesRequest")
	proto.RegisterType((*ListRolesResponse)(nil), "google.iam.admin.v1.ListRolesResponse")
	proto.RegisterType((*GetRoleRequest)(nil), "google.iam.admin.v1.GetRoleRequest")
	proto.RegisterType((*CreateRoleRequest)(nil), "google.iam.admin.v1.CreateRoleRequest")
	proto.RegisterType((*UpdateRoleRequest)(nil), "google.iam.admin.v1.UpdateRoleRequest")
	proto.RegisterType((*DeleteRoleRequest)(nil), "google.iam.admin.v1.DeleteRoleRequest")
	proto.RegisterType((*UndeleteRoleRequest)(nil), "google.iam.admin.v1.UndeleteRoleRequest")
	proto.RegisterType((*Permission)(nil), "google.iam.admin.v1.Permission")
	proto.RegisterType((*QueryTestablePermissionsRequest)(nil), "google.iam.admin.v1.QueryTestablePermissionsRequest")
	proto.RegisterType((*QueryTestablePermissionsResponse)(nil), "google.iam.admin.v1.QueryTestablePermissionsResponse")
}

func init() { proto.RegisterFile("google/iam/admin/v1/iam.proto", fileDescriptor_8ffbc3f16f9a3a9d) }

var fileDescriptor_8ffbc3f16f9a3a9d = []byte{
	// 2827 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5a, 0xcf, 0x6f, 0x1b, 0xd7,
	0xb5, 0xce, 0xa5, 0xa8, 0x1f, 0x3c, 0xa2, 0x29, 0xea, 0x4a, 0xb6, 0x18, 0xca, 0xb2, 0x94, 0x49,
	0xec, 0xc8, 0x8c, 0x2c, 0x4a, 0xb4, 0xfd, 0x92, 0xa7, 0xc0, 0x2f, 0x18, 0x49, 0x34, 0xc3, 0x88,
	0x96, 0x99, 0x21, 0xf5, 0x12, 0x3b, 0x09, 0xe6, 0x8d, 0xc8, 0x2b, 0x6a, 0xa2, 0x21, 0x67, 0xcc,
	0x19, 0x4a, 0x8f, 0x31, 0xbc, 0x09, 0x8a, 0x6e, 0x8a, 0x6e, 0xda, 0xa2, 0x08, 0xd0, 0x02, 0x69,
	0x0b, 0x14, 0x68, 0xd1, 0xa2, 0xab, 0x16, 0xed, 0xa2, 0x68, 0x51, 0xa0, 0x8b, 0xa2, 0xd9, 0xb5,
	0x28, 0x50, 0x68, 0x95, 0x45, 0x56, 0xfd, 0x0b, 0x8a, 0xac, 0x8a, 0x7b, 0xef, 0x0c, 0x39, 0x24,
	0x67, 0xa8, 0x51, 0xec, 0x76, 0x23, 0xcc, 0x9c, 0x73, 0xee, 0x3d, 0xdf, 0xfd, 0xee, 0x99, 0x73,
	0xcf, 0x3d, 0x22, 0x2c, 0xd4, 0x74, 0xbd, 0xa6, 0x91, 0xb4, 0xaa, 0xd4, 0xd3, 0x4a, 0xb5, 0xae,
	0x36, 0xd2, 0xc7, 0xeb, 0xf4, 0x65, 0xd5, 0x68, 0xea, 0x96, 0x8e, 0x67, 0xb8, 0x7a, 0x95, 0x4a,
	0x98, 0x7a, 0xf5, 0x78, 0x3d, 0x79, 0xd9, 0x1e, 0xa3, 0x18, 0x6a, 0x5a, 0x69, 0x34, 0x74, 0x4b,
	0xb1, 0x54, 0xbd, 0x61, 0xf2, 0x21, 0xc9, 0x39, 0x97, 0xb6, 0xa2, 0xa9, 0xa4, 0x61, 0xd9, 0x8a,
	0x45, 0x97, 0xe2, 0x40, 0x25, 0x5a, 0x55, 0xde, 0x27, 0x87, 0xca, 0xb1, 0xaa, 0x37, 0x6d, 0x83,
	0xe7, 0x5d, 0x06, 0x4d, 0x62, 0xea, 0xad, 0x66, 0x85, 0xd8, 0xaa, 0x2b, 0x2e, 0x98, 0x1c, 0xa0,
	0x6c, 0xe8, 0x9a, 0x5a, 0x69, 0xdb, 0xfa, 0x64, 0xaf, 0xbe, 0x47, 0x37, 0x6f, 0xeb, 0xd8, 0xdb,
	0x7e, 0xeb, 0x20, 0x4d, 0xea, 0x86, 0xe5, 0x28, 0x97, 0xfa, 0x95, 0x1c, 0x59, 0x5d, 0x31, 0x8f,
	0xfa, 0x60, 0x77, 0x2c, 0x2c, 0xb5, 0x4e, 0x4c, 0x4b, 0xa9, 0x1b, 0xdc, 0x40, 0xf8, 0x55, 0x08,
	0x62, 0x25, 0xd2, 0x3c, 0x56, 0x2b, 0x44, 0xac, 0x54, 0xf4, 0x56, 0xc3, 0xc2, 0x18, 0xc2, 0x0d,
	0xa5, 0x4e, 0x12, 0x68, 0x09, 0x2d, 0x47, 0x24, 0xf6, 0x8c, 0x17, 0x00, 0x8c, 0xa6, 0xfe, 0x21,
	0xa9, 0x58, 0xb2, 0x5a, 0x4d, 0x84, 0x98, 0x26, 0x62, 0x4b, 0xf2, 0x55, 0x3c, 0x0f, 0x91, 0x56,
	0x43, 0x7d, 0xd4, 0x22, 0x54, 0x1b, 0x66, 0xda, 0x09, 0x2e, 0xc8, 0x57, 0xf1, 0x2c, 0x8c, 0x92,
	0xba, 0xa2, 0x6a, 0x89, 0x51, 0xa6, 0xe0, 0x2f, 0xf8, 0x05, 0x88, 0x56, 0x55, 0xd3, 0xd0, 0x94,
	0xb6, 0xcc, 0xbc, 0x8d, 0x31, 0xe5, 0xa4, 0x2d, 0xdb, 0xa5, 0x4e, 0x31, 0x84, 0x89, 0xa5, 0xd4,
	0x12, 0xe3, 0x4b, 0x68, 0x39, 0x2a, 0xb1, 0x67, 0xbc, 0x0c, 0x71, 0x5d, 0x69, 0x59, 0x87, 0x19,
	0x99, 0x6f, 0x0f, 0x75, 0x18, 0x61, 0x43, 0x63, 0x5c, 0xbe, 0xc5, 0xc4, 0xf9, 0xea, 0xc6, 0xfb,
	0xff, 0x10, 0x1f, 0xc0, 0x0b, 0x74, 0xef, 0x39, 0x07, 0x8a, 0xa1, 0x9a, 0xab, 0x15, 0xbd, 0x9e,
	0xee, 0x5b, 0xee, 0x2d, 0x7b, 0x19, 0x66, 0xfa, 0xb1, 0xfd, 0xf4, 0x24, 0x6d, 0xf6, 0x98, 0x98,
	0xe9, 0xc7, 0xb6, 0x40, 0x56, 0xb8, 0xe4, 0x89, 0xf0, 0x77, 0x04, 0xf3, 0x5b, 0x4d, 0xa2, 0x58,
	0xa4, 0x77, 0x3a, 0x89, 0x3c, 0x6a, 0x11, 0xd3, 0xc2, 0x39, 0x37, 0x89, 0x9b, 0x37, 0x3f, 0x17,
	0x43, 0x5f, 0x8a, 0x37, 0xe0, 0x95, 0x8a, 0xa6, 0xb7, 0xaa, 0x4e, 0x78, 0xd4, 0x95, 0x86, 0x52,
	0x23, 0xcd, 0x7e, 0x7c, 0x45, 0x8e, 0xc2, 0x66, 0x5e, 0x00, 0xb0, 0x9d, 0x76, 0x98, 0xdf, 0x1c,
	0xf9, 0x5c, 0x0c, 0x49, 0x11, 0x5b, 0x9c, 0xaf, 0xe2, 0x02, 0x4c, 0xf5, 0x01, 0x4c, 0x8c, 0x2c,
	0xa1, 0xe5, 0xc9, 0xcc, 0x8b, 0xab, 0x1e, 0x9f, 0xc0, 0x6a, 0x1f, 0xe2, 0x58, 0xef, 0x6a, 0x85,
	0x1f, 0x22, 0x48, 0x16, 0x54, 0xd3, 0xea, 0x35, 0x33, 0x9f, 0xf9, 0xca, 0xe6, 0x21, 0x62, 0x28,
	0x35, 0x22, 0x9b, 0xea, 0x47, 0x84, 0x2d, 0x6c, 0x54, 0x9a, 0xa0, 0x82, 0x92, 0xfa, 0x11, 0x0f,
	0x38, 0xaa, 0xb4, 0xf4, 0x23, 0xd2, 0x60, 0xab, 0xa1, 0x01, 0xa7, 0xd4, 0x48, 0x99, 0x0a, 0x84,
	0xaf, 0x23, 0x98, 0xf7, 0xc4, 0x68, 0x1a, 0x7a, 0xc3, 0x24, 0xf8, 0x0d, 0x98, 0xb0, 0x99, 0x30,
	0x13, 0x68, 0x69, 0x24, 0x28, 0x15, 0x9d, 0x41, 0xf8, 0x1a, 0x4c, 0x35, 0xc8, 0xff, 0x5b, 0xb2,
	0x0b, 0x04, 0x8f, 0xfa, 0x0b, 0x54, 0x5c, 0xec, 0x00, 0x79, 0x00, 0x89, 0x1c, 0xb1, 0xbc, 0x63,
	0xe0, 0x4e, 0x0f, 0x53, 0xd7, 0x19, 0x53, 0x2f, 0x06, 0x08, 0x49, 0xce, 0x8f, 0xf0, 0x3e, 0xcc,
	0x6f, 0x13, 0x8d, 0xf8, 0x45, 0xd8, 0x53, 0xce, 0xfe, 0x71, 0x08, 0x16, 0x06, 0x19, 0xdc, 0x21,
	0x6d, 0xf3, 0xd9, 0x38, 0xc0, 0xef, 0x40, 0xe4, 0x88, 0xb4, 0x65, 0xab, 0x6d, 0x10, 0x33, 0x11,
	0x5a, 0x1a, 0x59, 0x8e, 0x65, 0x36, 0x3c, 0xf7, 0x60, 0x28, 0x8a, 0xd5, 0x1d, 0xd2, 0x2e, 0xb7,
	0x0d, 0x22, 0x4d, 0x1c, 0xf1, 0x07, 0x53, 0xc8, 0xc3, 0xb8, 0x2d, 0xc4, 0x09, 0x98, 0xdd, 0xc9,
	0x3e, 0x90, 0xcb, 0x0f, 0x8a, 0x59, 0x79, 0x6f, 0xb7, 0x54, 0xcc, 0x6e, 0xe5, 0xef, 0xe6, 0xb3,
	0xdb, 0xf1, 0xe7, 0x70, 0x1c, 0xa2, 0x7b, 0xa5, 0xac, 0x24, 0xdf, 0x13, 0x77, 0xc5, 0x5c, 0x76,
	0x3b, 0x8e, 0x30, 0x86, 0x58, 0xe9, 0x41, 0xa9, 0x9c, 0xbd, 0xd7, 0x91, 0x85, 0x84, 0xf7, 0xe1,
	0x8a, 0x9f, 0x77, 0x3b, 0x90, 0x36, 0x20, 0x7c, 0x44, 0xda, 0x4e, 0x10, 0x5d, 0x0b, 0x10, 0x44,
	0x3b, 0xa4, 0x2d, 0xb1, 0x31, 0xc2, 0xcf, 0x10, 0xcc, 0x0f, 0x04, 0x07, 0x55, 0xdb, 0x04, 0x67,
	0x7a, 0x08, 0xbe, 0xc2, 0x08, 0x4e, 0xc0, 0x25, 0x0f, 0x82, 0xd9, 0x9c, 0x8c, 0xd5, 0x77, 0x61,
	0xca, 0x68, 0xed, 0x6b, 0x6a, 0x45, 0x76, 0xc8, 0x65, 0x71, 0x19, 0xcb, 0xac, 0x05, 0x80, 0x56,
	0x64, 0x23, 0x1d, 0x46, 0x2f, 0x18, 0xee, 0x57, 0xe1, 0x93, 0x30, 0x4c, 0x0f, 0x40, 0xf5, 0x3c,
	0x0c, 0xde, 0x83, 0xb8, 0xd1, 0x54, 0x8f, 0x15, 0x8b, 0xf4, 0x83, 0x58, 0x0f, 0x02, 0x82, 0x0f,
	0x75, 0x50, 0xc4, 0x8c, 0x9e, 0x77, 0x5c, 0x86, 0x0b, 0x74, 0x52, 0x45, 0xab, 0xe9, 0x4d, 0xd5,
	0x3a, 0xac, 0x27, 0x26, 0xd8, 0xcc, 0xe9, 0x60, 0xcc, 0x8b, 0xce, 0x30, 0x29, 0x7a, 0xe4, 0x7a,
	0xa3, 0xc7, 0x86, 0x1b, 0x72, 0x55, 0xb1, 0x14, 0x96, 0x54, 0xa2, 0x6e, 0xff, 0xdb, 0x8a, 0xa5,
	0xd0, 0x0f, 0xdf, 0x45, 0x30, 0x33, 0xe4, 0xe7, 0x4f, 0x97, 0x2e, 0x66, 0xb7, 0x0d, 0xf1, 0x63,
	0x45, 0x53, 0xab, 0xb2, 0x72, 0x60, 0x91, 0xa6, 0x4c, 0xcf, 0x55, 0x76, 0xf2, 0x4d, 0x66, 0x92,
	0x0e, 0x54, 0xe7, 0xd0, 0x5d, 0x2d, 0x3b, 0x87, 0xae, 0x14, 0x63, 0x63, 0x44, 0x3a, 0x84, 0x0a,
	0xf1, 0x5d, 0x98, 0xe6, 0xb3, 0xec, 0x93, 0x03, 0xbd, 0x49, 0xf8, 0x34, 0xa3, 0x67, 0x4e, 0x33,
	0xc5, 0x06, 0x6d, 0xb2, 0x31, 0x54, 0xca, 0x0f, 0x3b, 0x9f, 0xc8, 0xc1, 0x6f, 0x7c, 0x95, 0x13,
	0x2e, 0x4d, 0x43, 0x38, 0xfd, 0xf8, 0x88, 0xb4, 0x9f, 0x08, 0xdf, 0x0a, 0xc1, 0x15, 0xaf, 0xc3,
	0xce, 0x15, 0xcb, 0x4f, 0x99, 0x2c, 0xfe, 0xb3, 0x21, 0x35, 0xf2, 0x0c, 0x42, 0x4a, 0x28, 0xc3,
	0x15, 0xaf, 0xf4, 0xfc, 0x74, 0xdf, 0xb7, 0xd0, 0x86, 0xa9, 0x92, 0x5a, 0x6b, 0x6c, 0x6a, 0xfa,
	0xfe, 0x33, 0xa2, 0xf6, 0x65, 0xb8, 0xb0, 0xdf, 0xb6, 0x88, 0x29, 0x5b, 0xba, 0x6c, 0xaa, 0x35,
	0x7e, 0x8e, 0x45, 0x79, 0x0d, 0x31, 0xc9, 0x34, 0x65, 0x9d, 0xba, 0x14, 0x72, 0x10, 0xef, 0xba,
	0xb6, 0xd3, 0xdf, 0x45, 0x18, 0xa3, 0xd4, 0xa9, 0x55, 0x3b, 0x01, 0x8c, 0x1e, 0x91, 0x76, 0xbe,
	0x8a, 0x2f, 0x43, 0x84, 0x4e, 0xa5, 0x58, 0xad, 0x26, 0xdf, 0xa7, 0xa8, 0xd4, 0x15, 0x08, 0x0d,
	0x88, 0xd1, 0x89, 0xde, 0x3a, 0x79, 0x46, 0x67, 0x15, 0x5e, 0x80, 0x71, 0x43, 0x69, 0x6b, 0xba,
	0xd2, 0x53, 0x00, 0x39, 0x32, 0x21, 0xc7, 0x39, 0x63, 0xfe, 0x86, 0xe3, 0x5e, 0x00, 0xa0, 0x30,
	0x49, 0x55, 0xfe, 0xf0, 0xc4, 0x72, 0xca, 0x58, 0x2e, 0x79, 0xeb, 0xc4, 0x12, 0x3e, 0x0b, 0x41,
	0x58, 0xd2, 0x35, 0xe2, 0x99, 0xf5, 0x66, 0x61, 0xd4, 0x52, 0x2d, 0x8d, 0xd8, 0xc3, 0xf8, 0x0b,
	0x5e, 0x82, 0xc9, 0x2a, 0x31, 0x2b, 0x4d, 0xd5, 0xa0, 0xd7, 0x08, 0xbb, 0x50, 0x71, 0x8b, 0xf0,
	0x3a, 0xcc, 0xaa, 0x8d, 0x8a, 0xd6, 0xaa, 0x92, 0xaa, 0x6c, 0x90, 0x66, 0x5d, 0x35, 0x4d, 0x7a,
	0xe1, 0x48, 0x8c, 0x2f, 0x8d, 0x2c, 0x47, 0xa4, 0x19, 0x47, 0x57, 0xec, 0xaa, 0xf0, 0x1b, 0x30,
	0x6a, 0x5a, 0x4a, 0x8d, 0xd8, 0xb9, 0xef, 0xba, 0x67, 0xa0, 0x52, 0xa0, 0xec, 0x4f, 0x41, 0x69,
	0x35, 0x2a, 0x87, 0x25, 0x3a, 0x40, 0xe2, 0xe3, 0x3a, 0x95, 0x73, 0xc4, 0x55, 0x39, 0x27, 0x60,
	0xbc, 0xca, 0xe2, 0xb5, 0x9a, 0x98, 0x5c, 0x42, 0xcb, 0x13, 0x92, 0xf3, 0x2a, 0xec, 0xc1, 0x54,
	0xdf, 0x3c, 0x38, 0x02, 0xa3, 0x62, 0xa1, 0xf8, 0xa6, 0x18, 0x7f, 0x0e, 0x4f, 0x40, 0x78, 0x33,
	0x5b, 0x16, 0xe3, 0x08, 0x8f, 0x41, 0x28, 0x27, 0xc6, 0x43, 0x38, 0x06, 0xb0, 0x9d, 0x2d, 0x4a,
	0xd9, 0x2d, 0xb1, 0x9c, 0xdd, 0x8e, 0x87, 0x71, 0x14, 0x26, 0xb6, 0xf3, 0x25, 0x71, 0xb3, 0x90,
	0xdd, 0x8e, 0x8f, 0xe2, 0x71, 0x18, 0xc9, 0x8a, 0xc5, 0xf8, 0x98, 0xf0, 0x3b, 0x04, 0xc9, 0xb7,
	0x5b, 0xa4, 0xd9, 0xce, 0x35, 0x95, 0x86, 0xa5, 0xec, 0x6b, 0x84, 0x7a, 0xe9, 0x94, 0x17, 0xeb,
	0x80, 0x0f, 0x5a, 0x9a, 0x26, 0x3b, 0x35, 0xa3, 0xec, 0x8a, 0x10, 0xb6, 0xbf, 0x71, 0xaa, 0x96,
	0x6c, 0x2d, 0xbb, 0x10, 0xac, 0x43, 0xf8, 0x58, 0x25, 0x27, 0x76, 0x66, 0x58, 0xf0, 0xa5, 0xe5,
	0x7f, 0x55, 0x72, 0x22, 0x31, 0xd3, 0xde, 0x22, 0x73, 0x64, 0x68, 0x91, 0x19, 0xee, 0x2f, 0x32,
	0x8f, 0x61, 0xde, 0x13, 0xbf, 0x1d, 0x63, 0x69, 0x18, 0x6d, 0x52, 0x81, 0x5d, 0x1b, 0x3c, 0xef,
	0x0b, 0x47, 0xe2, 0x76, 0x81, 0x6b, 0xca, 0x3f, 0x22, 0x88, 0xd3, 0xb2, 0xa4, 0x87, 0xae, 0x2b,
	0x30, 0x66, 0x28, 0x4d, 0xd2, 0xb0, 0x6c, 0x8a, 0xc6, 0xbe, 0x14, 0x47, 0x00, 0xa5, 0x24, 0x5b,
	0xfa, 0x34, 0xd5, 0x74, 0x87, 0xd7, 0x70, 0x70, 0x5e, 0x5f, 0x80, 0xa8, 0x79, 0xa8, 0x9f, 0xc8,
	0x4e, 0x48, 0x8d, 0xb1, 0x90, 0x9a, 0xa4, 0xb2, 0x6d, 0x3b, 0xac, 0x34, 0x98, 0x76, 0xad, 0xe2,
	0xdf, 0x4d, 0xda, 0x0a, 0xc4, 0x72, 0x84, 0x39, 0x73, 0x18, 0x4b, 0xf6, 0x24, 0x1d, 0x87, 0x2f,
	0x9e, 0x66, 0x1f, 0xc3, 0x34, 0x3f, 0xd0, 0xdc, 0x03, 0xce, 0xa2, 0x78, 0x0e, 0xc6, 0x29, 0xa6,
	0xee, 0x0d, 0x78, 0x8c, 0xbe, 0xe6, 0xab, 0xf8, 0x06, 0x84, 0xe9, 0x93, 0x7d, 0xe9, 0x1a, 0xb2,
	0x26, 0x66, 0x26, 0x7c, 0x0f, 0xc1, 0xf4, 0x9e, 0x51, 0xed, 0xf3, 0x3e, 0x04, 0x6e, 0xc7, 0x41,
	0x28, 0x90, 0x03, 0xfc, 0x3a, 0x4c, 0xb6, 0xd8, 0xfc, 0xac, 0x15, 0x60, 0xc3, 0x1a, 0xac, 0x27,
	0xee, 0xaa, 0x44, 0xab, 0xde, 0x53, 0xcc, 0x23, 0x09, 0xb8, 0x39, 0x7d, 0x16, 0xb6, 0x60, 0x9a,
	0xef, 0x60, 0x50, 0x70, 0x4e, 0xb2, 0x09, 0x75, 0x93, 0x8d, 0x90, 0x85, 0x99, 0xbd, 0x46, 0xf5,
	0xa9, 0xa7, 0xf9, 0x62, 0x04, 0xa0, 0x9b, 0x18, 0x9f, 0x69, 0x5a, 0x7e, 0x15, 0x12, 0x7a, 0x43,
	0x6b, 0xcb, 0x6a, 0x43, 0x36, 0x9a, 0xa4, 0x4a, 0x0e, 0x54, 0x7a, 0x2c, 0xf0, 0xd8, 0x0c, 0xb3,
	0x60, 0xbe, 0x48, 0xf5, 0xf9, 0x46, 0xb1, 0xa3, 0x65, 0x91, 0x8c, 0x77, 0x9c, 0xe4, 0x3c, 0xca,
	0xbe, 0x96, 0xdb, 0x9e, 0x9b, 0xd1, 0x05, 0xed, 0x7a, 0xf4, 0x48, 0xd4, 0x16, 0x24, 0x2b, 0x2d,
	0xd3, 0xd2, 0xeb, 0xdc, 0xb3, 0x6c, 0xb6, 0x0c, 0x43, 0x6f, 0x5a, 0xb2, 0x46, 0x8e, 0x89, 0xc6,
	0x3e, 0xaa, 0x58, 0xe6, 0xd5, 0xb3, 0x3c, 0x6c, 0xb1, 0x19, 0x18, 0xba, 0x12, 0x1f, 0x5f, 0xa0,
	0xc3, 0xa5, 0xb9, 0x8a, 0xb7, 0x42, 0xd8, 0x86, 0x8b, 0x9e, 0xa8, 0xce, 0x93, 0xf6, 0x47, 0x84,
	0x37, 0x61, 0xce, 0xc7, 0x33, 0xbe, 0x00, 0x91, 0xd2, 0x5e, 0xb1, 0x78, 0x5f, 0x2a, 0xb3, 0xcb,
	0xd8, 0x24, 0x8c, 0x97, 0xb3, 0xa5, 0x72, 0x7e, 0x37, 0x17, 0x47, 0x78, 0x1a, 0x2e, 0xec, 0xde,
	0x2f, 0xcb, 0x5d, 0x7d, 0x48, 0xf8, 0x06, 0x82, 0x45, 0x96, 0x69, 0xcb, 0xb4, 0xbe, 0xdd, 0xd7,
	0x88, 0xeb, 0x30, 0x74, 0x42, 0x67, 0xc5, 0xff, 0xb8, 0xf0, 0x38, 0x29, 0x9e, 0xa6, 0xb7, 0xf0,
	0x4d, 0x04, 0x4b, 0xfe, 0x68, 0xec, 0x3c, 0x26, 0xc2, 0xa4, 0xfb, 0x30, 0xe7, 0xd9, 0x6c, 0xf1,
	0x8c, 0x9d, 0x92, 0xdc, 0x63, 0x82, 0x66, 0xb6, 0x94, 0x02, 0x49, 0xff, 0xa2, 0x14, 0xcf, 0xc1,
	0x0c, 0xbd, 0x02, 0x8b, 0x85, 0x5c, 0xdf, 0x0d, 0x78, 0x16, 0xe2, 0x8e, 0x42, 0x2a, 0x89, 0xf2,
	0xfa, 0x5a, 0xe6, 0x56, 0x1c, 0xf5, 0x4b, 0x33, 0x6b, 0xb7, 0x5e, 0x8b, 0x87, 0x52, 0x1a, 0x5c,
	0x1e, 0x56, 0x51, 0xd3, 0x51, 0x1e, 0x77, 0x6c, 0x47, 0x5a, 0xdc, 0xd9, 0x2a, 0xad, 0x67, 0xe4,
	0xbb, 0xf9, 0x42, 0x36, 0x8e, 0xf0, 0x12, 0x5c, 0x66, 0xd2, 0xdc, 0xfd, 0xfb, 0xb9, 0x42, 0x56,
	0xde, 0x92, 0xb2, 0xdb, 0xd9, 0xdd, 0x72, 0x5e, 0x2c, 0x94, 0xb8, 0x45, 0x28, 0xf5, 0x01, 0xcc,
	0x0f, 0xb9, 0x97, 0xd2, 0xe0, 0x61, 0x13, 0xec, 0xde, 0xdf, 0xcd, 0xc6, 0x9f, 0xc3, 0x97, 0x00,
	0xb3, 0xd7, 0x77, 0x6f, 0xaf, 0xfd, 0xb7, 0x5c, 0xcc, 0xde, 0x73, 0xfc, 0xcc, 0xc1, 0x0c, 0x93,
	0x4b, 0xe2, 0x3b, 0x72, 0x71, 0x6f, 0xb3, 0x90, 0xdf, 0x92, 0x77, 0xb2, 0x0f, 0xe2, 0xa1, 0xd4,
	0x22, 0x4c, 0x38, 0x87, 0x15, 0x0d, 0xe8, 0x4d, 0xb1, 0x94, 0xdf, 0xe2, 0x01, 0x7d, 0x77, 0xaf,
	0x50, 0x88, 0xa3, 0xcc, 0xd7, 0x16, 0x61, 0x24, 0x2f, 0xde, 0xc3, 0xbf, 0x40, 0x30, 0xe3, 0xd1,
	0x44, 0xc2, 0xe9, 0x80, 0x6d, 0x0a, 0x27, 0x36, 0x93, 0x6b, 0xc1, 0x07, 0xf0, 0xf0, 0x11, 0x6e,
	0x9d, 0x8a, 0x2c, 0x7d, 0x7d, 0xfc, 0xd7, 0x2f, 0xbe, 0x1d, 0x7a, 0x19, 0x5f, 0x4d, 0x1f, 0xaf,
	0xa7, 0x1f, 0x53, 0xc1, 0x9d, 0xce, 0x5d, 0x2d, 0x35, 0x70, 0x49, 0xc3, 0x9f, 0x22, 0x98, 0x1e,
	0x68, 0x28, 0xe0, 0x1b, 0x9e, 0xde, 0xfd, 0xba, 0x52, 0xc9, 0x20, 0x8d, 0x30, 0xe1, 0xbf, 0xdc,
	0xf8, 0xae, 0xe3, 0x97, 0xbd, 0xf0, 0x0d, 0xdc, 0x21, 0x53, 0x4f, 0xf0, 0x1f, 0x10, 0xcc, 0x7a,
	0xdd, 0x14, 0xb1, 0x37, 0x45, 0x43, 0x3a, 0xa8, 0xc1, 0x70, 0x4a, 0xa7, 0xe2, 0x22, 0x85, 0xb5,
	0xd2, 0xed, 0x91, 0xae, 0xf4, 0xdd, 0x64, 0xd9, 0x12, 0x52, 0x42, 0x30, 0x8a, 0x37, 0x50, 0x0a,
	0x7f, 0x07, 0xc1, 0x2c, 0x3f, 0x9e, 0xfb, 0xd6, 0x10, 0x04, 0x51, 0x30, 0xd8, 0x19, 0x06, 0x6a,
	0x25, 0x19, 0x94, 0x57, 0x0a, 0xeb, 0x13, 0x04, 0xb3, 0x5e, 0x17, 0x4e, 0x1f, 0x6a, 0x87, 0xb4,
	0x0e, 0x93, 0x97, 0x06, 0x4a, 0x81, 0x6c, 0xdd, 0xb0, 0xda, 0x7d, 0xbb, 0x9e, 0x0a, 0xbc, 0xeb,
	0x7f, 0x42, 0x70, 0xc9, 0xbb, 0x8f, 0x86, 0x33, 0xe7, 0x6f, 0xf9, 0x25, 0x6f, 0x9e, 0x6b, 0x8c,
	0xfd, 0x45, 0x65, 0x4f, 0xc5, 0x18, 0x8b, 0x84, 0x4e, 0xd3, 0x91, 0xad, 0x62, 0x15, 0xaf, 0x04,
	0x5c, 0x05, 0x6b, 0x78, 0xe0, 0xdf, 0x23, 0x98, 0xf5, 0xea, 0xd9, 0xf9, 0xb0, 0x3c, 0xa4, 0xbd,
	0x97, 0x0c, 0xd8, 0x2c, 0x14, 0xee, 0x9d, 0x8a, 0xb3, 0x0c, 0x79, 0x5f, 0x63, 0x8f, 0xe1, 0x5f,
	0xc3, 0xab, 0xc1, 0xf0, 0xf3, 0x7e, 0x4d, 0xea, 0x09, 0xfe, 0x1b, 0x82, 0x39, 0x9f, 0x66, 0x0d,
	0xbe, 0x19, 0xf8, 0x2b, 0xfc, 0x0a, 0xeb, 0xf8, 0xe0, 0x54, 0x7c, 0x91, 0xaf, 0xa3, 0xaf, 0x93,
	0xb3, 0xd2, 0xd3, 0x7d, 0x61, 0xcb, 0x5a, 0x17, 0xce, 0xb5, 0x2d, 0x34, 0xfe, 0x7f, 0x8c, 0x60,
	0xce, 0xa7, 0xe1, 0xe2, 0xb3, 0xae, 0xe1, 0xed, 0x19, 0xdf, 0xaf, 0xe0, 0x8e, 0xfb, 0x2b, 0x58,
	0x4b, 0x9d, 0x97, 0xff, 0x9f, 0x22, 0x98, 0x70, 0xfa, 0x28, 0xf8, 0x25, 0x6f, 0xee, 0x7a, 0x3b,
	0x3c, 0xc9, 0xab, 0x67, 0x58, 0xd9, 0x21, 0x5e, 0x3c, 0x15, 0x31, 0x23, 0xb8, 0xa7, 0x9f, 0xc3,
	0x60, 0xde, 0x16, 0xd6, 0x82, 0xa6, 0x12, 0xd3, 0x9e, 0x96, 0x72, 0xfa, 0x29, 0x82, 0x71, 0xbb,
	0x75, 0xe2, 0x97, 0xdd, 0x7a, 0x1a, 0x39, 0xc9, 0x97, 0x86, 0x1b, 0xd9, 0x40, 0xf3, 0xa7, 0x62,
	0x94, 0x47, 0x02, 0xef, 0xd0, 0x30, 0x88, 0xb7, 0x84, 0xf4, 0x79, 0x20, 0xbe, 0x75, 0x62, 0x51,
	0x84, 0xdf, 0x45, 0x10, 0xcd, 0x11, 0x2b, 0xaf, 0xd4, 0x8b, 0xec, 0xdf, 0xa2, 0x58, 0x70, 0x23,
	0xe0, 0x5f, 0x60, 0x47, 0xe9, 0xa0, 0xbc, 0xd8, 0x67, 0xc3, 0xb5, 0xc2, 0xce, 0xa9, 0x38, 0xe1,
	0x94, 0x8f, 0x0c, 0xd2, 0x86, 0xf0, 0x1a, 0x83, 0xe4, 0x08, 0xcf, 0x80, 0x55, 0x73, 0xe3, 0xf8,
	0x01, 0x82, 0x68, 0x69, 0x18, 0xb0, 0x52, 0x70, 0x60, 0x7b, 0xa7, 0xe2, 0x94, 0x83, 0x61, 0x85,
	0xff, 0xfb, 0x97, 0xe1, 0xbb, 0x73, 0x3e, 0x7c, 0xa6, 0xcb, 0x23, 0xe5, 0xee, 0x33, 0x04, 0x98,
	0xd6, 0xb0, 0x54, 0xe8, 0xaa, 0x3b, 0x97, 0xfb, 0x40, 0x0c, 0x9a, 0x38, 0x70, 0xaf, 0x07, 0xb0,
	0xb4, 0xb7, 0xfc, 0xff, 0x4e, 0xc5, 0xd9, 0xee, 0x12, 0xba, 0x06, 0x6c, 0x1d, 0x5b, 0xc2, 0xff,
	0x9c, 0x67, 0x1d, 0xd6, 0x80, 0x1b, 0xba, 0x9a, 0x5f, 0x23, 0x98, 0xf1, 0x68, 0xc7, 0xf8, 0x54,
	0x6b, 0xfe, 0x8d, 0x27, 0x9f, 0x6a, 0x6d, 0x48, 0xa7, 0x87, 0x66, 0x04, 0x8f, 0xcb, 0x07, 0x5b,
	0x9a, 0x20, 0x2c, 0xd0, 0xa5, 0xb1, 0xdb, 0xdb, 0xc6, 0xa3, 0xc1, 0x39, 0x28, 0xf2, 0x5f, 0x22,
	0x88, 0x74, 0x3a, 0x21, 0xf8, 0xaa, 0xef, 0xe9, 0xd6, 0x83, 0xf2, 0xda, 0x59, 0x66, 0x36, 0xb6,
	0x77, 0x19, 0x0c, 0x09, 0x47, 0x3a, 0x30, 0x1e, 0xbe, 0x84, 0x05, 0x46, 0x37, 0x6f, 0x5b, 0xdc,
	0xd1, 0x9b, 0x35, 0xa5, 0xa1, 0x7e, 0xc4, 0x7f, 0xe7, 0x40, 0x33, 0x2a, 0xb7, 0x5a, 0xc4, 0x0b,
	0x6e, 0x2b, 0x77, 0x51, 0xc4, 0x3b, 0x2f, 0x3f, 0x47, 0x30, 0x6e, 0xb7, 0x54, 0x7c, 0x92, 0x43,
	0x6f, 0xc3, 0x25, 0xe9, 0xdf, 0x97, 0x10, 0x14, 0x86, 0xf2, 0x3d, 0x8c, 0xbb, 0x29, 0x80, 0x39,
	0x49, 0xa7, 0x9e, 0x74, 0xe0, 0x32, 0x69, 0x1f, 0xd8, 0x74, 0xc7, 0xca, 0x81, 0xdb, 0x9f, 0x3e,
	0x1c, 0x03, 0xfc, 0x23, 0x04, 0xd0, 0xed, 0xe9, 0xe0, 0x6b, 0x43, 0x8e, 0xba, 0x80, 0xa0, 0xdf,
	0x66, 0xa0, 0x77, 0x84, 0x00, 0x6c, 0x6e, 0xa0, 0xd4, 0x43, 0x3b, 0x14, 0x7c, 0x09, 0xa5, 0xa1,
	0xf0, 0x13, 0x04, 0xd0, 0x6d, 0xfd, 0xf8, 0x80, 0x1c, 0xe8, 0x0d, 0x0d, 0x03, 0xf9, 0x0e, 0x03,
	0xf9, 0x76, 0x26, 0x00, 0x87, 0x1b, 0xac, 0x3b, 0xf4, 0xf0, 0x6a, 0x66, 0x38, 0x93, 0xdc, 0x0c,
	0x7f, 0x1f, 0x01, 0x74, 0x1b, 0x41, 0x3e, 0x50, 0x07, 0x3a, 0x45, 0xc3, 0xa0, 0xee, 0x30, 0xa8,
	0xd9, 0x54, 0xa0, 0xed, 0x4e, 0x9d, 0xb1, 0xdd, 0xbf, 0x41, 0x10, 0x75, 0xb7, 0x98, 0x7a, 0xd3,
	0x5a, 0x97, 0xcb, 0xc1, 0x2e, 0xd4, 0x30, 0x88, 0x15, 0x06, 0xf1, 0x03, 0xe1, 0x95, 0x00, 0x6c,
	0xb6, 0xec, 0xa9, 0xe9, 0xde, 0xbf, 0x22, 0x5c, 0x1b, 0xce, 0xa9, 0xcb, 0x18, 0xff, 0x16, 0x41,
	0xc2, 0xaf, 0xc1, 0x80, 0x6f, 0xf9, 0x67, 0x27, 0xff, 0xee, 0x48, 0xf2, 0xf6, 0x39, 0x47, 0xd9,
	0xc9, 0xe3, 0x26, 0x5b, 0xee, 0x0d, 0x61, 0x99, 0xfd, 0xee, 0xc8, 0x95, 0x6f, 0x1f, 0xf9, 0x8c,
	0xdc, 0x40, 0xa9, 0xe4, 0xdd, 0x3f, 0x8b, 0x78, 0xf0, 0x3f, 0x37, 0x7f, 0x11, 0x57, 0x0f, 0x2d,
	0xcb, 0x30, 0x37, 0xd2, 0xe9, 0x93, 0x93, 0x93, 0xfe, 0x7f, 0xeb, 0x28, 0x2d, 0xeb, 0x30, 0xcd,
	0x7e, 0x22, 0x72, 0xc3, 0xd0, 0x14, 0xeb, 0x40, 0x6f, 0xd6, 0x37, 0xf7, 0x61, 0xae, 0xa2, 0xd7,
	0xbd, 0x80, 0x6f, 0x4e, 0xd0, 0xf4, 0x4f, 0xab, 0xb2, 0x22, 0x7a, 0xf8, 0x9a, 0x6d, 0x50, 0xd3,
	0x35, 0xa5, 0x51, 0x5b, 0xd5, 0x9b, 0xb5, 0x74, 0x8d, 0x34, 0x58, 0xcd, 0x96, 0xee, 0x7a, 0xe9,
	0xf9, 0x0d, 0xd8, 0xeb, 0xec, 0xe1, 0x9f, 0x08, 0xed, 0x8f, 0x31, 0xbb, 0x9b, 0xff, 0x0a, 0x00,
	0x00, 0xff, 0xff, 0xd4, 0x9c, 0x09, 0xd1, 0x2a, 0x26, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IAMClient is the client API for IAM service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IAMClient interface {
	// Lists [ServiceAccounts][google.iam.admin.v1.ServiceAccount] for a project.
	ListServiceAccounts(ctx context.Context, in *ListServiceAccountsRequest, opts ...grpc.CallOption) (*ListServiceAccountsResponse, error)
	// Gets a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	GetServiceAccount(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Creates a [ServiceAccount][google.iam.admin.v1.ServiceAccount]
	// and returns it.
	CreateServiceAccount(ctx context.Context, in *CreateServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Updates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Currently, only the following fields are updatable:
	// `display_name` and `description`.
	UpdateServiceAccount(ctx context.Context, in *ServiceAccount, opts ...grpc.CallOption) (*ServiceAccount, error)
	// Deletes a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	DeleteServiceAccount(ctx context.Context, in *DeleteServiceAccountRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists [ServiceAccountKeys][google.iam.admin.v1.ServiceAccountKey].
	ListServiceAccountKeys(ctx context.Context, in *ListServiceAccountKeysRequest, opts ...grpc.CallOption) (*ListServiceAccountKeysResponse, error)
	// Gets the [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// by key id.
	GetServiceAccountKey(ctx context.Context, in *GetServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error)
	// Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// and returns it.
	CreateServiceAccountKey(ctx context.Context, in *CreateServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error)
	// Deletes a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
	DeleteServiceAccountKey(ctx context.Context, in *DeleteServiceAccountKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Signs a blob using a service account's system-managed private key.
	SignBlob(ctx context.Context, in *SignBlobRequest, opts ...grpc.CallOption) (*SignBlobResponse, error)
	// Signs a JWT using a service account's system-managed private key.
	//
	// If no expiry time (`exp`) is provided in the `SignJwtRequest`, IAM sets an
	// an expiry time of one hour by default. If you request an expiry time of
	// more than one hour, the request will fail.
	SignJwt(ctx context.Context, in *SignJwtRequest, opts ...grpc.CallOption) (*SignJwtResponse, error)
	// Returns the Cloud IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Note: Service accounts are both
	// [resources and
	// identities](/iam/docs/service-accounts#service_account_permissions). This
	// method treats the service account as a resource. It returns the Cloud IAM
	// policy that reflects what members have access to the service account.
	//
	// This method does not return what resources the service account has access
	// to. To see if a service account has access to a resource, call the
	// `getIamPolicy` method on the target resource. For example, to view grants
	// for a project, call the
	// [projects.getIamPolicy](/resource-manager/reference/rest/v1/projects/getIamPolicy)
	// method.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the Cloud IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Note: Service accounts are both
	// [resources and
	// identities](/iam/docs/service-accounts#service_account_permissions). This
	// method treats the service account as a resource. Use it to grant members
	// access to the service account, such as when they need to impersonate it.
	//
	// This method does not grant the service account access to other resources,
	// such as projects. To grant a service account access to resources, include
	// the service account in the Cloud IAM policy for the desired resource, then
	// call the appropriate `setIamPolicy` method on the target resource. For
	// example, to grant a service account access to a project, call the
	// [projects.setIamPolicy](/resource-manager/reference/rest/v1/projects/setIamPolicy)
	// method.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Tests the specified permissions against the IAM access control policy
	// for a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Queries roles that can be granted on a particular resource.
	// A role is grantable if it can be used as the role in a binding for a policy
	// for that resource.
	QueryGrantableRoles(ctx context.Context, in *QueryGrantableRolesRequest, opts ...grpc.CallOption) (*QueryGrantableRolesResponse, error)
	// Lists the Roles defined on a resource.
	ListRoles(ctx context.Context, in *ListRolesRequest, opts ...grpc.CallOption) (*ListRolesResponse, error)
	// Gets a Role definition.
	GetRole(ctx context.Context, in *GetRoleRequest, opts ...grpc.CallOption) (*Role, error)
	// Creates a new Role.
	CreateRole(ctx context.Context, in *CreateRoleRequest, opts ...grpc.CallOption) (*Role, error)
	// Updates a Role definition.
	UpdateRole(ctx context.Context, in *UpdateRoleRequest, opts ...grpc.CallOption) (*Role, error)
	// Soft deletes a role. The role is suspended and cannot be used to create new
	// IAM Policy Bindings.
	// The Role will not be included in `ListRoles()` unless `show_deleted` is set
	// in the `ListRolesRequest`. The Role contains the deleted boolean set.
	// Existing Bindings remains, but are inactive. The Role can be undeleted
	// within 7 days. After 7 days the Role is deleted and all Bindings associated
	// with the role are removed.
	DeleteRole(ctx context.Context, in *DeleteRoleRequest, opts ...grpc.CallOption) (*Role, error)
	// Undelete a Role, bringing it back in its previous state.
	UndeleteRole(ctx context.Context, in *UndeleteRoleRequest, opts ...grpc.CallOption) (*Role, error)
	// Lists the permissions testable on a resource.
	// A permission is testable if it can be tested for an identity on a resource.
	QueryTestablePermissions(ctx context.Context, in *QueryTestablePermissionsRequest, opts ...grpc.CallOption) (*QueryTestablePermissionsResponse, error)
}

type iAMClient struct {
	cc grpc.ClientConnInterface
}

func NewIAMClient(cc grpc.ClientConnInterface) IAMClient {
	return &iAMClient{cc}
}

func (c *iAMClient) ListServiceAccounts(ctx context.Context, in *ListServiceAccountsRequest, opts ...grpc.CallOption) (*ListServiceAccountsResponse, error) {
	out := new(ListServiceAccountsResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/ListServiceAccounts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetServiceAccount(ctx context.Context, in *GetServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) CreateServiceAccount(ctx context.Context, in *CreateServiceAccountRequest, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/CreateServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) UpdateServiceAccount(ctx context.Context, in *ServiceAccount, opts ...grpc.CallOption) (*ServiceAccount, error) {
	out := new(ServiceAccount)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/UpdateServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) DeleteServiceAccount(ctx context.Context, in *DeleteServiceAccountRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/DeleteServiceAccount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) ListServiceAccountKeys(ctx context.Context, in *ListServiceAccountKeysRequest, opts ...grpc.CallOption) (*ListServiceAccountKeysResponse, error) {
	out := new(ListServiceAccountKeysResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/ListServiceAccountKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetServiceAccountKey(ctx context.Context, in *GetServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error) {
	out := new(ServiceAccountKey)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetServiceAccountKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) CreateServiceAccountKey(ctx context.Context, in *CreateServiceAccountKeyRequest, opts ...grpc.CallOption) (*ServiceAccountKey, error) {
	out := new(ServiceAccountKey)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/CreateServiceAccountKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) DeleteServiceAccountKey(ctx context.Context, in *DeleteServiceAccountKeyRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/DeleteServiceAccountKey", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) SignBlob(ctx context.Context, in *SignBlobRequest, opts ...grpc.CallOption) (*SignBlobResponse, error) {
	out := new(SignBlobResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/SignBlob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) SignJwt(ctx context.Context, in *SignJwtRequest, opts ...grpc.CallOption) (*SignJwtResponse, error) {
	out := new(SignJwtResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/SignJwt", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) QueryGrantableRoles(ctx context.Context, in *QueryGrantableRolesRequest, opts ...grpc.CallOption) (*QueryGrantableRolesResponse, error) {
	out := new(QueryGrantableRolesResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/QueryGrantableRoles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) ListRoles(ctx context.Context, in *ListRolesRequest, opts ...grpc.CallOption) (*ListRolesResponse, error) {
	out := new(ListRolesResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/ListRoles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) GetRole(ctx context.Context, in *GetRoleRequest, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/GetRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) CreateRole(ctx context.Context, in *CreateRoleRequest, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/CreateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) UpdateRole(ctx context.Context, in *UpdateRoleRequest, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/UpdateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) DeleteRole(ctx context.Context, in *DeleteRoleRequest, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/DeleteRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) UndeleteRole(ctx context.Context, in *UndeleteRoleRequest, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/UndeleteRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMClient) QueryTestablePermissions(ctx context.Context, in *QueryTestablePermissionsRequest, opts ...grpc.CallOption) (*QueryTestablePermissionsResponse, error) {
	out := new(QueryTestablePermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.iam.admin.v1.IAM/QueryTestablePermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IAMServer is the server API for IAM service.
type IAMServer interface {
	// Lists [ServiceAccounts][google.iam.admin.v1.ServiceAccount] for a project.
	ListServiceAccounts(context.Context, *ListServiceAccountsRequest) (*ListServiceAccountsResponse, error)
	// Gets a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	GetServiceAccount(context.Context, *GetServiceAccountRequest) (*ServiceAccount, error)
	// Creates a [ServiceAccount][google.iam.admin.v1.ServiceAccount]
	// and returns it.
	CreateServiceAccount(context.Context, *CreateServiceAccountRequest) (*ServiceAccount, error)
	// Updates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Currently, only the following fields are updatable:
	// `display_name` and `description`.
	UpdateServiceAccount(context.Context, *ServiceAccount) (*ServiceAccount, error)
	// Deletes a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	DeleteServiceAccount(context.Context, *DeleteServiceAccountRequest) (*empty.Empty, error)
	// Lists [ServiceAccountKeys][google.iam.admin.v1.ServiceAccountKey].
	ListServiceAccountKeys(context.Context, *ListServiceAccountKeysRequest) (*ListServiceAccountKeysResponse, error)
	// Gets the [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// by key id.
	GetServiceAccountKey(context.Context, *GetServiceAccountKeyRequest) (*ServiceAccountKey, error)
	// Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]
	// and returns it.
	CreateServiceAccountKey(context.Context, *CreateServiceAccountKeyRequest) (*ServiceAccountKey, error)
	// Deletes a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
	DeleteServiceAccountKey(context.Context, *DeleteServiceAccountKeyRequest) (*empty.Empty, error)
	// Signs a blob using a service account's system-managed private key.
	SignBlob(context.Context, *SignBlobRequest) (*SignBlobResponse, error)
	// Signs a JWT using a service account's system-managed private key.
	//
	// If no expiry time (`exp`) is provided in the `SignJwtRequest`, IAM sets an
	// an expiry time of one hour by default. If you request an expiry time of
	// more than one hour, the request will fail.
	SignJwt(context.Context, *SignJwtRequest) (*SignJwtResponse, error)
	// Returns the Cloud IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Note: Service accounts are both
	// [resources and
	// identities](/iam/docs/service-accounts#service_account_permissions). This
	// method treats the service account as a resource. It returns the Cloud IAM
	// policy that reflects what members have access to the service account.
	//
	// This method does not return what resources the service account has access
	// to. To see if a service account has access to a resource, call the
	// `getIamPolicy` method on the target resource. For example, to view grants
	// for a project, call the
	// [projects.getIamPolicy](/resource-manager/reference/rest/v1/projects/getIamPolicy)
	// method.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the Cloud IAM access control policy for a
	// [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	//
	// Note: Service accounts are both
	// [resources and
	// identities](/iam/docs/service-accounts#service_account_permissions). This
	// method treats the service account as a resource. Use it to grant members
	// access to the service account, such as when they need to impersonate it.
	//
	// This method does not grant the service account access to other resources,
	// such as projects. To grant a service account access to resources, include
	// the service account in the Cloud IAM policy for the desired resource, then
	// call the appropriate `setIamPolicy` method on the target resource. For
	// example, to grant a service account access to a project, call the
	// [projects.setIamPolicy](/resource-manager/reference/rest/v1/projects/setIamPolicy)
	// method.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Tests the specified permissions against the IAM access control policy
	// for a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Queries roles that can be granted on a particular resource.
	// A role is grantable if it can be used as the role in a binding for a policy
	// for that resource.
	QueryGrantableRoles(context.Context, *QueryGrantableRolesRequest) (*QueryGrantableRolesResponse, error)
	// Lists the Roles defined on a resource.
	ListRoles(context.Context, *ListRolesRequest) (*ListRolesResponse, error)
	// Gets a Role definition.
	GetRole(context.Context, *GetRoleRequest) (*Role, error)
	// Creates a new Role.
	CreateRole(context.Context, *CreateRoleRequest) (*Role, error)
	// Updates a Role definition.
	UpdateRole(context.Context, *UpdateRoleRequest) (*Role, error)
	// Soft deletes a role. The role is suspended and cannot be used to create new
	// IAM Policy Bindings.
	// The Role will not be included in `ListRoles()` unless `show_deleted` is set
	// in the `ListRolesRequest`. The Role contains the deleted boolean set.
	// Existing Bindings remains, but are inactive. The Role can be undeleted
	// within 7 days. After 7 days the Role is deleted and all Bindings associated
	// with the role are removed.
	DeleteRole(context.Context, *DeleteRoleRequest) (*Role, error)
	// Undelete a Role, bringing it back in its previous state.
	UndeleteRole(context.Context, *UndeleteRoleRequest) (*Role, error)
	// Lists the permissions testable on a resource.
	// A permission is testable if it can be tested for an identity on a resource.
	QueryTestablePermissions(context.Context, *QueryTestablePermissionsRequest) (*QueryTestablePermissionsResponse, error)
}

// UnimplementedIAMServer can be embedded to have forward compatible implementations.
type UnimplementedIAMServer struct {
}

func (*UnimplementedIAMServer) ListServiceAccounts(ctx context.Context, req *ListServiceAccountsRequest) (*ListServiceAccountsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceAccounts not implemented")
}
func (*UnimplementedIAMServer) GetServiceAccount(ctx context.Context, req *GetServiceAccountRequest) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceAccount not implemented")
}
func (*UnimplementedIAMServer) CreateServiceAccount(ctx context.Context, req *CreateServiceAccountRequest) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServiceAccount not implemented")
}
func (*UnimplementedIAMServer) UpdateServiceAccount(ctx context.Context, req *ServiceAccount) (*ServiceAccount, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateServiceAccount not implemented")
}
func (*UnimplementedIAMServer) DeleteServiceAccount(ctx context.Context, req *DeleteServiceAccountRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServiceAccount not implemented")
}
func (*UnimplementedIAMServer) ListServiceAccountKeys(ctx context.Context, req *ListServiceAccountKeysRequest) (*ListServiceAccountKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceAccountKeys not implemented")
}
func (*UnimplementedIAMServer) GetServiceAccountKey(ctx context.Context, req *GetServiceAccountKeyRequest) (*ServiceAccountKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceAccountKey not implemented")
}
func (*UnimplementedIAMServer) CreateServiceAccountKey(ctx context.Context, req *CreateServiceAccountKeyRequest) (*ServiceAccountKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServiceAccountKey not implemented")
}
func (*UnimplementedIAMServer) DeleteServiceAccountKey(ctx context.Context, req *DeleteServiceAccountKeyRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServiceAccountKey not implemented")
}
func (*UnimplementedIAMServer) SignBlob(ctx context.Context, req *SignBlobRequest) (*SignBlobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignBlob not implemented")
}
func (*UnimplementedIAMServer) SignJwt(ctx context.Context, req *SignJwtRequest) (*SignJwtResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignJwt not implemented")
}
func (*UnimplementedIAMServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedIAMServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedIAMServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedIAMServer) QueryGrantableRoles(ctx context.Context, req *QueryGrantableRolesRequest) (*QueryGrantableRolesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryGrantableRoles not implemented")
}
func (*UnimplementedIAMServer) ListRoles(ctx context.Context, req *ListRolesRequest) (*ListRolesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRoles not implemented")
}
func (*UnimplementedIAMServer) GetRole(ctx context.Context, req *GetRoleRequest) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRole not implemented")
}
func (*UnimplementedIAMServer) CreateRole(ctx context.Context, req *CreateRoleRequest) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRole not implemented")
}
func (*UnimplementedIAMServer) UpdateRole(ctx context.Context, req *UpdateRoleRequest) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRole not implemented")
}
func (*UnimplementedIAMServer) DeleteRole(ctx context.Context, req *DeleteRoleRequest) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRole not implemented")
}
func (*UnimplementedIAMServer) UndeleteRole(ctx context.Context, req *UndeleteRoleRequest) (*Role, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteRole not implemented")
}
func (*UnimplementedIAMServer) QueryTestablePermissions(ctx context.Context, req *QueryTestablePermissionsRequest) (*QueryTestablePermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryTestablePermissions not implemented")
}

func RegisterIAMServer(s *grpc.Server, srv IAMServer) {
	s.RegisterService(&_IAM_serviceDesc, srv)
}

func _IAM_ListServiceAccounts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceAccountsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).ListServiceAccounts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/ListServiceAccounts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).ListServiceAccounts(ctx, req.(*ListServiceAccountsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetServiceAccount(ctx, req.(*GetServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_CreateServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).CreateServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/CreateServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).CreateServiceAccount(ctx, req.(*CreateServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_UpdateServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ServiceAccount)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).UpdateServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/UpdateServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).UpdateServiceAccount(ctx, req.(*ServiceAccount))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_DeleteServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceAccountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).DeleteServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/DeleteServiceAccount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).DeleteServiceAccount(ctx, req.(*DeleteServiceAccountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_ListServiceAccountKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceAccountKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).ListServiceAccountKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/ListServiceAccountKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).ListServiceAccountKeys(ctx, req.(*ListServiceAccountKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetServiceAccountKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceAccountKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetServiceAccountKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetServiceAccountKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetServiceAccountKey(ctx, req.(*GetServiceAccountKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_CreateServiceAccountKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceAccountKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).CreateServiceAccountKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/CreateServiceAccountKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).CreateServiceAccountKey(ctx, req.(*CreateServiceAccountKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_DeleteServiceAccountKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceAccountKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).DeleteServiceAccountKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/DeleteServiceAccountKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).DeleteServiceAccountKey(ctx, req.(*DeleteServiceAccountKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_SignBlob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignBlobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).SignBlob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/SignBlob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).SignBlob(ctx, req.(*SignBlobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_SignJwt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignJwtRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).SignJwt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/SignJwt",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).SignJwt(ctx, req.(*SignJwtRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_QueryGrantableRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryGrantableRolesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).QueryGrantableRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/QueryGrantableRoles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).QueryGrantableRoles(ctx, req.(*QueryGrantableRolesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_ListRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRolesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).ListRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/ListRoles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).ListRoles(ctx, req.(*ListRolesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_GetRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).GetRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/GetRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).GetRole(ctx, req.(*GetRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_CreateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).CreateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/CreateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).CreateRole(ctx, req.(*CreateRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_UpdateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).UpdateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/UpdateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).UpdateRole(ctx, req.(*UpdateRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_DeleteRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).DeleteRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/DeleteRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).DeleteRole(ctx, req.(*DeleteRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_UndeleteRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteRoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).UndeleteRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/UndeleteRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).UndeleteRole(ctx, req.(*UndeleteRoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAM_QueryTestablePermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryTestablePermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServer).QueryTestablePermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.admin.v1.IAM/QueryTestablePermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServer).QueryTestablePermissions(ctx, req.(*QueryTestablePermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IAM_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.admin.v1.IAM",
	HandlerType: (*IAMServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServiceAccounts",
			Handler:    _IAM_ListServiceAccounts_Handler,
		},
		{
			MethodName: "GetServiceAccount",
			Handler:    _IAM_GetServiceAccount_Handler,
		},
		{
			MethodName: "CreateServiceAccount",
			Handler:    _IAM_CreateServiceAccount_Handler,
		},
		{
			MethodName: "UpdateServiceAccount",
			Handler:    _IAM_UpdateServiceAccount_Handler,
		},
		{
			MethodName: "DeleteServiceAccount",
			Handler:    _IAM_DeleteServiceAccount_Handler,
		},
		{
			MethodName: "ListServiceAccountKeys",
			Handler:    _IAM_ListServiceAccountKeys_Handler,
		},
		{
			MethodName: "GetServiceAccountKey",
			Handler:    _IAM_GetServiceAccountKey_Handler,
		},
		{
			MethodName: "CreateServiceAccountKey",
			Handler:    _IAM_CreateServiceAccountKey_Handler,
		},
		{
			MethodName: "DeleteServiceAccountKey",
			Handler:    _IAM_DeleteServiceAccountKey_Handler,
		},
		{
			MethodName: "SignBlob",
			Handler:    _IAM_SignBlob_Handler,
		},
		{
			MethodName: "SignJwt",
			Handler:    _IAM_SignJwt_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _IAM_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _IAM_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _IAM_TestIamPermissions_Handler,
		},
		{
			MethodName: "QueryGrantableRoles",
			Handler:    _IAM_QueryGrantableRoles_Handler,
		},
		{
			MethodName: "ListRoles",
			Handler:    _IAM_ListRoles_Handler,
		},
		{
			MethodName: "GetRole",
			Handler:    _IAM_GetRole_Handler,
		},
		{
			MethodName: "CreateRole",
			Handler:    _IAM_CreateRole_Handler,
		},
		{
			MethodName: "UpdateRole",
			Handler:    _IAM_UpdateRole_Handler,
		},
		{
			MethodName: "DeleteRole",
			Handler:    _IAM_DeleteRole_Handler,
		},
		{
			MethodName: "UndeleteRole",
			Handler:    _IAM_UndeleteRole_Handler,
		},
		{
			MethodName: "QueryTestablePermissions",
			Handler:    _IAM_QueryTestablePermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/iam/admin/v1/iam.proto",
}
