// +build !ignore_autogenerated

/*
Copyright 2016 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was autogenerated by deepcopy-gen. Do not edit it manually!

package serializer

import (
	conversion "k8s.io/kubernetes/pkg/conversion"
	runtime "k8s.io/kubernetes/pkg/runtime"
)

func DeepCopy_serializer_CodecFactory(in CodecFactory, out *CodecFactory, c *conversion.Cloner) error {
	if in.scheme != nil {
		in, out := in.scheme, &out.scheme
		*out = new(runtime.Scheme)
		if err := runtime.DeepCopy_runtime_Scheme(*in, *out, c); err != nil {
			return err
		}
	} else {
		out.scheme = nil
	}
	if in.serializers != nil {
		in, out := in.serializers, &out.serializers
		*out = make([]serializerType, len(in))
		for i := range in {
			if newVal, err := c.DeepCopy(in[i]); err != nil {
				return err
			} else {
				(*out)[i] = newVal.(serializerType)
			}
		}
	} else {
		out.serializers = nil
	}
	if in.universal == nil {
		out.universal = nil
	} else if newVal, err := c.DeepCopy(in.universal); err != nil {
		return err
	} else {
		out.universal = newVal.(runtime.Decoder)
	}
	if in.accepts != nil {
		in, out := in.accepts, &out.accepts
		*out = make([]string, len(in))
		copy(*out, in)
	} else {
		out.accepts = nil
	}
	if in.legacySerializer == nil {
		out.legacySerializer = nil
	} else if newVal, err := c.DeepCopy(in.legacySerializer); err != nil {
		return err
	} else {
		out.legacySerializer = newVal.(runtime.Serializer)
	}
	return nil
}
