// Code generated by go-bindata.
// sources:
// examples/image-streams/image-streams-centos7.json
// examples/image-streams/image-streams-rhel7.json
// examples/db-templates/mongodb-ephemeral-template.json
// examples/db-templates/mongodb-persistent-template.json
// examples/db-templates/mysql-ephemeral-template.json
// examples/db-templates/mysql-persistent-template.json
// examples/db-templates/postgresql-ephemeral-template.json
// examples/db-templates/postgresql-persistent-template.json
// examples/quickstarts/cakephp-mysql.json
// examples/quickstarts/dancer-mysql.json
// examples/quickstarts/django-postgresql.json
// examples/quickstarts/nodejs-mongodb.json
// examples/quickstarts/rails-postgresql.json
// DO NOT EDIT!

package bootstrap

import (
	"fmt"
	"strings"
	"os"
	"time"
	"io/ioutil"
	"path/filepath"
)
type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name string
	size int64
	mode os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _examplesImageStreamsImageStreamsCentos7Json = []byte(`{
  "kind": "ImageStreamList",
  "apiVersion": "v1",
  "metadata": {},
  "items": [
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "ruby",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Ruby applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "2.2"
            }
          },
          {
            "name": "2.0",
            "annotations": {
              "description": "Build and run Ruby 2.0 applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby:2.0,ruby",
              "version": "2.0",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/ruby-20-centos7:latest"
            }
          },
          {
            "name": "2.2",
            "annotations": {
              "description": "Build and run Ruby 2.2 applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby:2.2,ruby",
              "version": "2.2",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/ruby-22-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "nodejs",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run NodeJS applications",
              "iconClass": "icon-nodejs",
              "tags": "builder,nodejs",
              "supports":"nodejs",
              "sampleRepo": "https://github.com/openshift/nodejs-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "0.10"
            }
          },
          {
            "name": "0.10",
            "annotations": {
              "description": "Build and run NodeJS 0.10 applications",
              "iconClass": "icon-nodejs",
              "tags": "builder,nodejs",
              "supports":"nodejs:0.10,nodejs:0.1,nodejs",
              "version": "0.10",
              "sampleRepo": "https://github.com/openshift/nodejs-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/nodejs-010-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "perl",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Perl applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.20"
            }
          },
          {
            "name": "5.16",
            "annotations": {
              "description": "Build and run Perl 5.16 applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl:5.16,perl",
              "version": "5.16",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/perl-516-centos7:latest"
            }
          },
          {
            "name": "5.20",
            "annotations": {
              "description": "Build and run Perl 5.20 applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl:5.20,perl",
              "version": "5.20",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/perl-520-centos7:latest"
            }

          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "php",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run PHP applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.6"
            }
          },
          {
            "name": "5.5",
            "annotations": {
              "description": "Build and run PHP 5.5 applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php:5.5,php",
              "version": "5.5",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/php-55-centos7:latest"
            }
          },
          {
            "name": "5.6",
            "annotations": {
              "description": "Build and run PHP 5.6 applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php:5.6,php",
              "version": "5.6",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/php-56-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "python",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Python applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "3.4"
            }
          },
          {
            "name": "3.3",
            "annotations": {
              "description": "Build and run Python 3.3 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:3.3,python",
              "version": "3.3",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/python-33-centos7:latest"
            }
          },
          {
            "name": "2.7",
            "annotations": {
              "description": "Build and run Python 2.7 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:2.7,python",
              "version": "2.7",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/python-27-centos7:latest"
            }
          },
          {
            "name": "3.4",
            "annotations": {
              "description": "Build and run Python 3.4 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:3.4,python",
              "version": "3.4",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/python-34-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "wildfly",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Java applications on Wildfly",
              "iconClass": "icon-wildfly",
              "tags": "builder,wildfly,java",
              "supports":"jee,java",
              "sampleRepo": "https://github.com/bparees/openshift-jee-sample.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "10.0"
            }
          },
          {
            "name": "8.1",
            "annotations": {
              "description": "Build and run Java applications on Wildfly 8.1",
              "iconClass": "icon-wildfly",
              "tags": "builder,wildfly,java",
              "supports":"wildfly:8.1,jee,java",
              "version": "8.1",
              "sampleRepo": "https://github.com/bparees/openshift-jee-sample.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/wildfly-81-centos7:latest"
            }
          },
          {
            "name": "9.0",
            "annotations": {
              "description": "Build and run Java applications on Wildfly 9.0",
              "iconClass": "icon-wildfly",
              "tags": "builder,wildfly,java",
              "supports":"wildfly:9.0,jee,java",
              "version": "9.0",
              "sampleRepo": "https://github.com/bparees/openshift-jee-sample.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/wildfly-90-centos7:latest"
            }
          },
          {
            "name": "10.0",
            "annotations": {
              "description": "Build and run Java applications on Wildfly 10.0",
              "iconClass": "icon-wildfly",
              "tags": "builder,wildfly,java",
              "supports":"wildfly:10.0,jee,java",
              "version": "10.0",
              "sampleRepo": "https://github.com/bparees/openshift-jee-sample.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/wildfly-100-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "mysql",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a MySQL database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.6"
            }
          },
          {
            "name": "5.5",
            "annotations": {
              "description": "Provides a MySQL v5.5 database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql",
              "version": "5.5"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/mysql-55-centos7:latest"
            }
          },
          {
            "name": "5.6",
            "annotations": {
              "description": "Provides a MySQL v5.6 database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql",
              "version": "5.6"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/mysql-56-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "postgresql",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a PostgreSQL database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "9.4"
            }
          },
          {
            "name": "9.2",
            "annotations": {
              "description": "Provides a PostgreSQL v9.2 database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql",
              "version": "9.2"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/postgresql-92-centos7:latest"
            }
          },
          {
            "name": "9.4",
            "annotations": {
              "description": "Provides a PostgreSQL v9.4 database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql",
              "version": "9.4"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/postgresql-94-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "mongodb",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a MongoDB database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "2.6"
            }
          },
          {
            "name": "2.4",
            "annotations": {
              "description": "Provides a MongoDB v2.4 database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb",
              "version": "2.4"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/mongodb-24-centos7:latest"
            }
          },
          {
            "name": "2.6",
            "annotations": {
              "description": "Provides a MongoDB v2.6 database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb",
              "version": "2.6"
            },
            "from": {
              "kind": "DockerImage",
              "name": "centos/mongodb-26-centos7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "jenkins",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a Jenkins server",
              "iconClass": "icon-jenkins",
              "tags": "jenkins"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "1"
            }
          },
          {
            "name": "1",
            "annotations": {
              "description": "Provides a Jenkins server",
              "iconClass": "icon-jenkins",
              "tags": "jenkins",
              "version": "1.x"
            },
            "from": {
              "kind": "DockerImage",
              "name": "openshift/jenkins-1-centos7:latest"
            }
          }
        ]
      }
    }
  ]
}
`)

func examplesImageStreamsImageStreamsCentos7JsonBytes() ([]byte, error) {
	return _examplesImageStreamsImageStreamsCentos7Json, nil
}

func examplesImageStreamsImageStreamsCentos7Json() (*asset, error) {
	bytes, err := examplesImageStreamsImageStreamsCentos7JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/image-streams/image-streams-centos7.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesImageStreamsImageStreamsRhel7Json = []byte(`{
  "kind": "ImageStreamList",
  "apiVersion": "v1",
  "metadata": {},
  "items": [
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "ruby",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Ruby applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby,ruby",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "2.2"
            }
          },
          {
            "name": "2.0",
            "annotations": {
              "description": "Build and run Ruby 2.0 applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby:2.0,ruby",
              "version": "2.0",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/ruby-20-rhel7:latest"
            }
          },
          {
            "name": "2.2",
            "annotations": {
              "description": "Build and run Ruby 2.2 applications",
              "iconClass": "icon-ruby",
              "tags": "builder,ruby",
              "supports": "ruby:2.2,ruby",
              "version": "2.2",
              "sampleRepo": "https://github.com/openshift/ruby-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/ruby-22-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "nodejs",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run NodeJS applications",
              "iconClass": "icon-nodejs",
              "tags": "builder,nodejs",
              "supports":"nodejs",
              "sampleRepo": "https://github.com/openshift/nodejs-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "0.10"
            }
          },
          {
            "name": "0.10",
            "annotations": {
              "description": "Build and run NodeJS 0.10 applications",
              "iconClass": "icon-nodejs",
              "tags": "builder,nodejs",
              "supports":"nodejs:0.10,nodejs:0.1,nodejs",
              "version": "0.10",
              "sampleRepo": "https://github.com/openshift/nodejs-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/nodejs-010-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "perl",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Perl applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.20"
            }
          },
          {
            "name": "5.16",
            "annotations": {
              "description": "Build and run Perl 5.16 applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl:5.16,perl",
              "version": "5.16",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/perl-516-rhel7:latest"
            }
          },
          {
            "name": "5.20",
            "annotations": {
              "description": "Build and run Perl 5.20 applications",
              "iconClass": "icon-perl",
              "tags": "builder,perl",
              "supports":"perl:5.20,perl",
              "version": "5.20",
              "sampleRepo": "https://github.com/openshift/dancer-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/perl-520-rhel7:latest"
            }

          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "php",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run PHP applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.6"
            }
          },
          {
            "name": "5.5",
            "annotations": {
              "description": "Build and run PHP 5.5 applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php:5.5,php",
              "version": "5.5",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"              
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/php-55-rhel7:latest"
            }
          },
          {
            "name": "5.6",
            "annotations": {
              "description": "Build and run PHP 5.6 applications",
              "iconClass": "icon-php",
              "tags": "builder,php",
              "supports":"php:5.6,php",
              "version": "5.6",
              "sampleRepo": "https://github.com/openshift/cakephp-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/php-56-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "python",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Build and run Python applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "3.4"
            }
          },
          {
            "name": "3.3",
            "annotations": {
              "description": "Build and run Python 3.3 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:3.3,python",
              "version": "3.3",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/python-33-rhel7:latest"
            }
          },
          {
            "name": "2.7",
            "annotations": {
              "description": "Build and run Python 2.7 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:2.7,python",
              "version": "2.7",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/python-27-rhel7:latest"
            }
          },
          {
            "name": "3.4",
            "annotations": {
              "description": "Build and run Python 3.4 applications",
              "iconClass": "icon-python",
              "tags": "builder,python",
              "supports":"python:3.4,python",
              "version": "3.4",
              "sampleRepo": "https://github.com/openshift/django-ex.git"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/python-34-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "mysql",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a MySQL database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "5.6"
            }
          },
          {
            "name": "5.5",
            "annotations": {
              "description": "Provides a MySQL v5.5 database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql",
              "version": "5.5"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/mysql-55-rhel7:latest"
            }
          },
          {
            "name": "5.6",
            "annotations": {
              "description": "Provides a MySQL v5.6 database",
              "iconClass": "icon-mysql-database",
              "tags": "mysql",
              "version": "5.6"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/mysql-56-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "postgresql",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a PostgreSQL database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "9.4"
            }
          },
          {
            "name": "9.2",
            "annotations": {
              "description": "Provides a PostgreSQL v9.2 database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql",
              "version": "9.2"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/postgresql-92-rhel7:latest"
            }
          },
          {
            "name": "9.4",
            "annotations": {
              "description": "Provides a PostgreSQL v9.4 database",
              "iconClass": "icon-postgresql",
              "tags": "postgresql",
              "version": "9.4"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/postgresql-94-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "mongodb",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a MongoDB database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "2.6"
            }
          },
          {
            "name": "2.4",
            "annotations": {
              "description": "Provides a MongoDB v2.4 database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb",
              "version": "2.4"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/mongodb-24-rhel7:latest"
            }
          },
          {
            "name": "2.6",
            "annotations": {
              "description": "Provides a MongoDB v2.6 database",
              "iconClass": "icon-mongodb",
              "tags": "mongodb",
              "version": "2.6"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/rhscl/mongodb-26-rhel7:latest"
            }
          }
        ]
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "jenkins",
        "creationTimestamp": null
      },
      "spec": {
        "tags": [
          {
            "name": "latest",
            "annotations": {
              "description": "Provides a Jenkins server",
              "iconClass": "icon-jenkins",
              "tags": "jenkins"
            },
            "from": {
              "kind": "ImageStreamTag",
              "name": "1"
            }
          },
          {
            "name": "1",
            "annotations": {
              "description": "Provides a Jenkins server",
              "iconClass": "icon-jenkins",
              "tags": "jenkins",
              "version": "1.x"
            },
            "from": {
              "kind": "DockerImage",
              "name": "registry.access.redhat.com/openshift3/jenkins-1-rhel7:latest"
            }
          }
        ]
      }
    }
  ]
}
`)

func examplesImageStreamsImageStreamsRhel7JsonBytes() ([]byte, error) {
	return _examplesImageStreamsImageStreamsRhel7Json, nil
}

func examplesImageStreamsImageStreamsRhel7Json() (*asset, error) {
	bytes, err := examplesImageStreamsImageStreamsRhel7JsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/image-streams/image-streams-rhel7.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesMongodbEphemeralTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "mongodb-ephemeral",
    "creationTimestamp": null,
    "annotations": {
      "description": "MongoDB database service, without persistent storage. WARNING: Any data stored will be lost upon pod destruction. Only use this template for testing",
      "iconClass": "icon-mongodb",
      "tags": "database,mongodb"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "mongo",
            "protocol": "TCP",
            "port": 27017,
            "targetPort": 27017,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": false,
              "containerNames": [
                "mongodb"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mongodb:latest",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mongodb",
                "image": "mongodb",
                "ports": [
                  {
                    "containerPort": 27017,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 3,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "mongostat --host 127.0.0.1 -u admin -p $MONGODB_ADMIN_PASSWORD -n 1 --noheaders"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 27017
                  }
                },
                "env": [
                  {
                    "name": "MONGODB_USER",
                    "value": "${MONGODB_USER}"
                  },
                  {
                    "name": "MONGODB_PASSWORD",
                    "value": "${MONGODB_PASSWORD}"
                  },
                  {
                    "name": "MONGODB_DATABASE",
                    "value": "${MONGODB_DATABASE}"
                  },
                  {
                    "name": "MONGODB_ADMIN_PASSWORD",
                    "value": "${MONGODB_ADMIN_PASSWORD}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mongodb/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "emptyDir": {
                  "medium": ""
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "mongodb",
      "required": true
    },
    {
      "name": "MONGODB_USER",
      "displayName": "MongoDB User",
      "description": "Username for MongoDB user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MONGODB_PASSWORD",
      "displayName": "MongoDB Password",
      "description": "Password for the MongoDB user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MONGODB_DATABASE",
      "displayName": "MongoDB Database Name",
      "description": "Name of the MongoDB database accessed.",
      "value": "sampledb",
      "required": true
    },
    {
      "name": "MONGODB_ADMIN_PASSWORD",
      "displayName": "MongoDB Admin Password",
      "description": "Password for the database admin user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    }
  ],
  "labels": {
    "template": "mongodb-ephemeral-template"
  }
}
`)

func examplesDbTemplatesMongodbEphemeralTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesMongodbEphemeralTemplateJson, nil
}

func examplesDbTemplatesMongodbEphemeralTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesMongodbEphemeralTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/mongodb-ephemeral-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesMongodbPersistentTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "mongodb-persistent",
    "creationTimestamp": null,
    "annotations": {
      "description": "MongoDB database service, with persistent storage.  Scaling to more than one replica is not supported.  You must have persistent volumes available in your cluster to use this template.",
      "iconClass": "icon-mongodb",
      "tags": "database,mongodb"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "mongo",
            "protocol": "TCP",
            "port": 27017,
            "targetPort": 27017,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "PersistentVolumeClaim",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "accessModes": [
          "ReadWriteOnce"
        ],
        "resources": {
          "requests": {
            "storage": "${VOLUME_CAPACITY}"
          }
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mongodb"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mongodb:latest",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mongodb",
                "image": "mongodb",
                "ports": [
                  {
                    "containerPort": 27017,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 3,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "mongostat --host 127.0.0.1 -u admin -p $MONGODB_ADMIN_PASSWORD -n 1 --noheaders"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 27017
                  }
                },
                "env": [
                  {
                    "name": "MONGODB_USER",
                    "value": "${MONGODB_USER}"
                  },
                  {
                    "name": "MONGODB_PASSWORD",
                    "value": "${MONGODB_PASSWORD}"
                  },
                  {
                    "name": "MONGODB_DATABASE",
                    "value": "${MONGODB_DATABASE}"
                  },
                  {
                    "name": "MONGODB_ADMIN_PASSWORD",
                    "value": "${MONGODB_ADMIN_PASSWORD}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mongodb/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "persistentVolumeClaim": {
                  "claimName": "${DATABASE_SERVICE_NAME}"
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "mongodb",
      "required": true
    },
    {
      "name": "MONGODB_USER",
      "displayName": "MongoDB User",
      "description": "Username for MongoDB user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MONGODB_PASSWORD",
      "displayName": "MongoDB Password",
      "description": "Password for the MongoDB user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MONGODB_DATABASE",
      "displayName": "MongoDB Database Name",
      "description": "Name of the MongoDB database accessed.",
      "value": "sampledb",
      "required": true
    },
    {
      "name": "MONGODB_ADMIN_PASSWORD",
      "displayName": "MongoDB Admin Password",
      "description": "Password for the database admin user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "VOLUME_CAPACITY",
      "displayName": "Volume Capacity",
      "description": "Volume space available for data, e.g. 512Mi, 2Gi.",
      "value": "1Gi",
      "required": true
    }
  ],
  "labels": {
    "template": "mongodb-persistent-template"
  }
}
`)

func examplesDbTemplatesMongodbPersistentTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesMongodbPersistentTemplateJson, nil
}

func examplesDbTemplatesMongodbPersistentTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesMongodbPersistentTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/mongodb-persistent-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesMysqlEphemeralTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "mysql-ephemeral",
    "creationTimestamp": null,
    "annotations": {
      "description": "MySQL database service, without persistent storage. WARNING: Any data stored will be lost upon pod destruction. Only use this template for testing",
      "iconClass": "icon-mysql-database",
      "tags": "database,mysql"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "mysql",
            "protocol": "TCP",
            "port": 3306,
            "targetPort": 3306,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": false,
              "containerNames": [
                "mysql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mysql:latest",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mysql",
                "image": "mysql",
                "ports": [
                  {
                    "containerPort": 3306,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c",
                      "MYSQL_PWD=\"$MYSQL_PASSWORD\" mysql -h 127.0.0.1 -u $MYSQL_USER -D $MYSQL_DATABASE -e 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 3306
                  }
                },
                "env": [
                  {
                    "name": "MYSQL_USER",
                    "value": "${MYSQL_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${MYSQL_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_DATABASE",
                    "value": "${MYSQL_DATABASE}"
                  }
                ],
                "resources": {
		    "limits": {
			"memory": "${MEMORY_LIMIT}"
		    }
		},
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "emptyDir": {
                  "medium": ""
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "mysql",
      "required": true
    },
    {
      "name": "MYSQL_USER",
      "displayName": "MySQL User",
      "description": "Username for MySQL user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MYSQL_PASSWORD",
      "displayName": "MySQL Password",
      "description": "Password for the MySQL user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MYSQL_DATABASE",
      "displayName": "MySQL Database Name",
      "description": "Name of the MySQL database accessed.",
      "value": "sampledb",
      "required": true
    }
  ],
  "labels": {
    "template": "mysql-ephemeral-template"
  }
}
`)

func examplesDbTemplatesMysqlEphemeralTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesMysqlEphemeralTemplateJson, nil
}

func examplesDbTemplatesMysqlEphemeralTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesMysqlEphemeralTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/mysql-ephemeral-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesMysqlPersistentTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "mysql-persistent",
    "creationTimestamp": null,
    "annotations": {
      "description": "MySQL database service, with persistent storage.  Scaling to more than one replica is not supported.  You must have persistent volumes available in your cluster to use this template.",
      "iconClass": "icon-mysql-database",
      "tags": "database,mysql"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "mysql",
            "protocol": "TCP",
            "port": 3306,
            "targetPort": 3306,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "PersistentVolumeClaim",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "accessModes": [
          "ReadWriteOnce"
        ],
        "resources": {
          "requests": {
            "storage": "${VOLUME_CAPACITY}"
          }
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "mysql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "mysql:latest",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "mysql",
                "image": "mysql",
                "ports": [
                  {
                    "containerPort": 3306,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c",
                      "MYSQL_PWD=\"$MYSQL_PASSWORD\" mysql -h 127.0.0.1 -u $MYSQL_USER -D $MYSQL_DATABASE -e 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 3306
                  }
                },
                "env": [
                  {
                    "name": "MYSQL_USER",
                    "value": "${MYSQL_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${MYSQL_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_DATABASE",
                    "value": "${MYSQL_DATABASE}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "persistentVolumeClaim": {
                  "claimName": "${DATABASE_SERVICE_NAME}"
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "mysql",
      "required": true
    },
    {
      "name": "MYSQL_USER",
      "displayName": "MySQL User",
      "description": "Username for MySQL user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "MYSQL_PASSWORD",
      "displayName": "MySQL Password",
      "description": "Password for the MySQL user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "MYSQL_DATABASE",
      "displayName": "MySQL Database Name",
      "description": "Name of the MySQL database accessed.",
      "value": "sampledb",
      "required": true
    },
    {
      "name": "VOLUME_CAPACITY",
      "displayName": "Volume Capacity",
      "description": "Volume space available for data, e.g. 512Mi, 2Gi.",
      "value": "1Gi",
      "required": true
    }
  ],
  "labels": {
    "template": "mysql-persistent-template"
  }
}
`)

func examplesDbTemplatesMysqlPersistentTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesMysqlPersistentTemplateJson, nil
}

func examplesDbTemplatesMysqlPersistentTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesMysqlPersistentTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/mysql-persistent-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesPostgresqlEphemeralTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "postgresql-ephemeral",
    "creationTimestamp": null,
    "annotations": {
      "description": "PostgreSQL database service, without persistent storage. WARNING: Any data stored will be lost upon pod destruction. Only use this template for testing",
      "iconClass": "icon-postgresql",
      "tags": "database,postgresql"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "postgresql",
            "protocol": "TCP",
            "port": 5432,
            "targetPort": 5432,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": false,
              "containerNames": [
                "postgresql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "postgresql:latest",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "postgresql",
                "image": "postgresql",
                "ports": [
                  {
                    "containerPort": 5432,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "psql -h 127.0.0.1 -U $POSTGRESQL_USER -q -d $POSTGRESQL_DATABASE -c 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 5432
                  }
                },
                "env": [
                  {
                    "name": "POSTGRESQL_USER",
                    "value": "${POSTGRESQL_USER}"
                  },
                  {
                    "name": "POSTGRESQL_PASSWORD",
                    "value": "${POSTGRESQL_PASSWORD}"
                  },
                  {
                    "name": "POSTGRESQL_DATABASE",
                    "value": "${POSTGRESQL_DATABASE}"
                  }
                ],
                "resources": {
		    "limits": {
			"memory": "${MEMORY_LIMIT}"
		    }
		},
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/pgsql/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "emptyDir": {
                  "medium": ""
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "postgresql",
      "required": true
    },
    {
      "name": "POSTGRESQL_USER",
      "displayName": "PostgreSQL User",
      "description": "Username for PostgreSQL user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "POSTGRESQL_PASSWORD",
      "displayName": "PostgreSQL Password",
      "description": "Password for the PostgreSQL user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "POSTGRESQL_DATABASE",
      "displayName": "PostgreSQL Database Name",
      "description": "Name of the PostgreSQL database accessed.",
      "value": "sampledb",
      "required": true
    }
  ],
  "labels": {
    "template": "postgresql-ephemeral-template"
  }
}
`)

func examplesDbTemplatesPostgresqlEphemeralTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesPostgresqlEphemeralTemplateJson, nil
}

func examplesDbTemplatesPostgresqlEphemeralTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesPostgresqlEphemeralTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/postgresql-ephemeral-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesDbTemplatesPostgresqlPersistentTemplateJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "postgresql-persistent",
    "creationTimestamp": null,
    "annotations": {
      "description": "PostgreSQL database service, with persistent storage.  Scaling to more than one replica is not supported.  You must have persistent volumes available in your cluster to use this template.",
      "iconClass": "icon-postgresql",
      "tags": "database,postgresql"
    }
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "ports": [
          {
            "name": "postgresql",
            "protocol": "TCP",
            "port": 5432,
            "targetPort": 5432,
            "nodePort": 0
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "portalIP": "",
        "type": "ClusterIP",
        "sessionAffinity": "None"
      },
      "status": {
        "loadBalancer": {}
      }
    },
    {
      "kind": "PersistentVolumeClaim",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}"
      },
      "spec": {
        "accessModes": [
          "ReadWriteOnce"
        ],
        "resources": {
          "requests": {
            "storage": "${VOLUME_CAPACITY}"
          }
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "creationTimestamp": null
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "postgresql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "postgresql:latest",
                "namespace": "${NAMESPACE}"
              },
              "lastTriggeredImage": ""
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "creationTimestamp": null,
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "postgresql",
                "image": "postgresql",
                "ports": [
                  {
                    "containerPort": 5432,
                    "protocol": "TCP"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "psql -h 127.0.0.1 -U $POSTGRESQL_USER -q -d $POSTGRESQL_DATABASE -c 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 5432
                  }
                },
                "env": [
                  {
                    "name": "POSTGRESQL_USER",
                    "value": "${POSTGRESQL_USER}"
                  },
                  {
                    "name": "POSTGRESQL_PASSWORD",
                    "value": "${POSTGRESQL_PASSWORD}"
                  },
                  {
                    "name": "POSTGRESQL_DATABASE",
                    "value": "${POSTGRESQL_DATABASE}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                },
                "volumeMounts": [
                  {
                    "name": "${DATABASE_SERVICE_NAME}-data",
                    "mountPath": "/var/lib/pgsql/data"
                  }
                ],
                "terminationMessagePath": "/dev/termination-log",
                "imagePullPolicy": "IfNotPresent",
                "capabilities": {},
                "securityContext": {
                  "capabilities": {},
                  "privileged": false
                }
              }
            ],
            "volumes": [
              {
                "name": "${DATABASE_SERVICE_NAME}-data",
                "persistentVolumeClaim": {
                  "claimName": "${DATABASE_SERVICE_NAME}"
                }
              }
            ],
            "restartPolicy": "Always",
            "dnsPolicy": "ClusterFirst"
          }
        }
      },
      "status": {}
    }
  ],
  "parameters": [
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the container can use.",
      "value": "512Mi"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "description": "The name of the OpenShift Service exposed for the database.",
      "value": "postgresql",
      "required": true
    },
    {
      "name": "POSTGRESQL_USER",
      "displayName": "PostgreSQL User",
      "description": "Username for PostgreSQL user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}",
      "required": true
    },
    {
      "name": "POSTGRESQL_PASSWORD",
      "displayName": "PostgreSQL Password",
      "description": "Password for the PostgreSQL user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}",
      "required": true
    },
    {
      "name": "POSTGRESQL_DATABASE",
      "displayName": "PostgreSQL Database Name",
      "description": "Name of the PostgreSQL database accessed.",
      "value": "sampledb",
      "required": true
    },
    {
      "name": "VOLUME_CAPACITY",
      "displayName": "Volume Capacity",
      "description": "Volume space available for data, e.g. 512Mi, 2Gi.",
      "value": "1Gi",
      "required": true
    }
  ],
  "labels": {
    "template": "postgresql-persistent-template"
  }
}
`)

func examplesDbTemplatesPostgresqlPersistentTemplateJsonBytes() ([]byte, error) {
	return _examplesDbTemplatesPostgresqlPersistentTemplateJson, nil
}

func examplesDbTemplatesPostgresqlPersistentTemplateJson() (*asset, error) {
	bytes, err := examplesDbTemplatesPostgresqlPersistentTemplateJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/db-templates/postgresql-persistent-template.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesQuickstartsCakephpMysqlJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "cakephp-mysql-example",
    "annotations": {
      "description": "An example CakePHP application with a MySQL database",
      "tags": "quickstart,php,cakephp,mysql",
      "iconClass": "icon-php"
    }
  },
  "labels": {
    "template": "cakephp-mysql-example"
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Exposes and load balances the application pods"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "port": 8080,
            "targetPort": 8080
          }
        ],
        "selector": {
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}"
      },
      "spec": {
        "host": "${APPLICATION_DOMAIN}",
        "to": {
          "kind": "Service",
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Keeps track of changes in the application image"
        }
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to build the application"
        }
      },
      "spec": {
        "source": {
          "type": "Git",
          "git": {
            "uri": "${SOURCE_REPOSITORY_URL}",
            "ref": "${SOURCE_REPOSITORY_REF}"
          },
          "contextDir": "${CONTEXT_DIR}"
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "namespace": "${NAMESPACE}",
              "name": "php:5.6"
            }
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "${NAME}:latest"
          }
        },
        "triggers": [
          {
            "type": "ImageChange"
          },
          {
            "type": "ConfigChange"
          },
          {
            "type": "GitHub",
            "github": {
              "secret": "${GITHUB_WEBHOOK_SECRET}"
            }
          }
        ]
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to deploy the application server"
        }
      },
      "spec": {
        "strategy": {
          "type": "Rolling",
          "recreateParams": {
          "pre": {
              "failurePolicy": "Retry",
              "execNewPod": {
                "command": [
                  "./migrate-database.sh"
                ],
                "containerName": "cakephp-mysql-example"
              }
            }
          }
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "cakephp-mysql-example"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${NAME}:latest"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${NAME}"
        },
        "template": {
          "metadata": {
            "name": "${NAME}",
            "labels": {
              "name": "${NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "cakephp-mysql-example",
                "image": "cakephp-mysql-example",
                "ports": [
                  {
                    "containerPort": 8080
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 3,
                  "httpGet": {
                    "path": "/health.php",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 3,
                    "initialDelaySeconds": 30,
                    "httpGet": {
                        "path": "/",
                        "port": 8080
                    }
                },
                "env": [
                  {
                    "name": "DATABASE_SERVICE_NAME",
                    "value": "${DATABASE_SERVICE_NAME}"
                  },
                  {
                    "name": "DATABASE_ENGINE",
                    "value": "${DATABASE_ENGINE}"
                  },
                  {
                    "name": "DATABASE_NAME",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "DATABASE_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "DATABASE_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "CAKEPHP_SECRET_TOKEN",
                    "value": "${CAKEPHP_SECRET_TOKEN}"
                  },
                  {
                    "name": "CAKEPHP_SECURITY_SALT",
                    "value": "${CAKEPHP_SECURITY_SALT}"
                  },
                  {
                    "name": "CAKEPHP_SECURITY_CIPHER_SEED",
                    "value": "${CAKEPHP_SECURITY_CIPHER_SEED}"
                  },
                  {
                    "name": "OPCACHE_REVALIDATE_FREQ",
                    "value": "${OPCACHE_REVALIDATE_FREQ}"
                  }
                ],
                "resources": {
		    "limits": {
			"memory": "${MEMORY_LIMIT}"
		    }
                }
              }
            ]
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Exposes the database server"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "mysql",
            "port": 3306,
            "targetPort": 3306
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Defines how to deploy the database"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": false,
              "containerNames": [
                "mysql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "namespace": "${NAMESPACE}",
                "name": "mysql:5.6"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "name": "${DATABASE_SERVICE_NAME}",
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "volumes": [
              {
                "name": "data",
                "emptyDir": {}
              }
            ],
            "containers": [
              {
                "name": "mysql",
                "image": "mysql",
                "ports": [
                  {
                    "containerPort": 3306
                  }
                ],
                "volumeMounts": [
                  {
                    "name": "data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "MYSQL_PWD='${DATABASE_PASSWORD}' mysql -h 127.0.0.1 -u ${DATABASE_USER} -D ${DATABASE_NAME} -e 'SELECT 1'" ]
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 1,
                    "initialDelaySeconds": 30,
                    "tcpSocket": {
                        "port": 3306
                    }
                },
                "env": [
                    {
                        "name": "MYSQL_USER",
                        "value": "${DATABASE_USER}"
                    },
                    {
                        "name": "MYSQL_PASSWORD",
                        "value": "${DATABASE_PASSWORD}"
                    },
                    {
                        "name": "MYSQL_DATABASE",
                        "value": "${DATABASE_NAME}"
                    }
                ],
                "resources": {
                    "limits": {
                        "memory": "${MEMORY_MYSQL_LIMIT}"
                    }
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "NAME",
      "displayName": "Name",
      "description": "The name assigned to all of the frontend objects defined in this template.",
      "required": true,
      "value": "cakephp-mysql-example"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the CakePHP container can use.",
      "value": "512Mi"
    },
    {
      "name": "MEMORY_MYSQL_LIMIT",
      "displayName": "Memory Limit (MySQL)",
      "description": "Maximum amount of memory the MySQL container can use.",
      "value": "512Mi"
    },
    {
      "name": "SOURCE_REPOSITORY_URL",
      "displayName": "Git Repository URL",
      "description": "The URL of the repository with your application source code.",
      "value": "https://github.com/openshift/cakephp-ex.git"
    },
    {
      "name": "SOURCE_REPOSITORY_REF",
      "displayName": "Git Reference",
      "description": "Set this to a branch name, tag or other ref of your repository if you are not using the default branch."
    },
    {
      "name": "CONTEXT_DIR",
      "displayName": "Context Directory",
      "description": "Set this to the relative path to your project if it is not in the root of your repository."
    },
    {
      "name": "APPLICATION_DOMAIN",
      "displayName": "Application Hostname",
      "description": "The exposed hostname that will route to the CakePHP service, if left blank a value will be defaulted.",
      "value": ""
    },
    {
      "name": "GITHUB_WEBHOOK_SECRET",
      "displayName": "GitHub Webhook Secret",
      "description": "A secret string used to configure the GitHub webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "value": "mysql"
    },
    {
      "name": "DATABASE_ENGINE",
      "displayName": "Database Engine",
      "description": "Database engine: postgresql, mysql or sqlite (default).",
      "value": "mysql"
    },
    {
      "name": "DATABASE_NAME",
      "displayName": "Database Name",
      "value": "default"
    },
    {
      "name": "DATABASE_USER",
      "displayName": "Database User",
      "value": "cakephp"
    },
    {
      "name": "DATABASE_PASSWORD",
      "displayName": "Database Password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}"
    },
    {
      "name": "CAKEPHP_SECRET_TOKEN",
      "displayName": "CakePHP secret token",
      "description": "Set this to a long random string.",
      "generate": "expression",
      "from": "[\\w]{50}"
    },
    {
      "name": "CAKEPHP_SECURITY_SALT",
      "displayName": "CakePHP Security Salt",
      "description": "Security salt for session hash.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "CAKEPHP_SECURITY_CIPHER_SEED",
      "displayName": "CakePHP Security Cipher Seed",
      "description": "Security cipher seed for session hash.",
      "generate": "expression",
      "from": "[0-9]{30}"
    },
    {
      "name": "OPCACHE_REVALIDATE_FREQ",
      "displayName": "OPcache Revalidation Frequency",
      "description": "How often to check script timestamps for updates, in seconds. 0 will result in OPcache checking for updates on every request.",
      "value": "2"
    }
  ]
}
`)

func examplesQuickstartsCakephpMysqlJsonBytes() ([]byte, error) {
	return _examplesQuickstartsCakephpMysqlJson, nil
}

func examplesQuickstartsCakephpMysqlJson() (*asset, error) {
	bytes, err := examplesQuickstartsCakephpMysqlJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/quickstarts/cakephp-mysql.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesQuickstartsDancerMysqlJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "dancer-mysql-example",
    "annotations": {
      "description": "An example Dancer application with a MySQL database",
      "tags": "quickstart,perl,dancer,mysql",
      "iconClass": "icon-perl"
    }
  },
  "labels": {
    "template": "dancer-mysql-example"
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Exposes and load balances the application pods"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "port": 8080,
            "targetPort": 8080
          }
        ],
        "selector": {
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}"
      },
      "spec": {
        "host": "${APPLICATION_DOMAIN}",
        "to": {
          "kind": "Service",
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Keeps track of changes in the application image"
        }
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to build the application"
        }
      },
      "spec": {
        "source": {
          "type": "Git",
          "git": {
            "uri": "${SOURCE_REPOSITORY_URL}",
            "ref": "${SOURCE_REPOSITORY_REF}"
          },
          "contextDir": "${CONTEXT_DIR}"
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "namespace": "${NAMESPACE}",
              "name": "perl:5.20"
            }
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "${NAME}:latest"
          }
        },
        "triggers": [
          {
            "type": "ImageChange"
          },
          {
            "type": "ConfigChange"
          },
          {
            "type": "GitHub",
            "github": {
              "secret": "${GITHUB_WEBHOOK_SECRET}"
            }
          }
        ]
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to deploy the application server"
        }
      },
      "spec": {
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "dancer-mysql-example"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${NAME}:latest"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${NAME}"
        },
        "template": {
          "metadata": {
            "name": "${NAME}",
            "labels": {
              "name": "${NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "dancer-mysql-example",
                "image": "dancer-mysql-example",
                "ports": [
                  {
                    "containerPort": 8080
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 3,
                  "httpGet": {
                    "path": "/health",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 3,
                    "initialDelaySeconds": 30,
                    "httpGet": {
                        "path": "/",
                        "port": 8080
                    }
                },
                "env": [
                  {
                    "name": "DATABASE_SERVICE_NAME",
                    "value": "${DATABASE_SERVICE_NAME}"
                  },
                  {
                    "name": "MYSQL_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "MYSQL_DATABASE",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "SECRET_KEY_BASE",
                    "value": "${SECRET_KEY_BASE}"
                  },
                  {
                    "name": "PERL_APACHE2_RELOAD",
                    "value": "${PERL_APACHE2_RELOAD}"
                  }
                ],
                "resources": {
		      "limits": {
			  "memory": "${MEMORY_LIMIT}"
		      }
                }
              }
            ]
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Exposes the database server"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "mysql",
            "port": 3306,
            "targetPort": 3306
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Defines how to deploy the database"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": false,
              "containerNames": [
                "mysql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "namespace": "${NAMESPACE}",
                "name": "mysql:5.6"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "name": "${DATABASE_SERVICE_NAME}",
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "volumes": [
              {
                "name": "data",
                "emptyDir": {}
              }
            ],
            "containers": [
              {
                "name": "mysql",
                "image": "mysql",
                "ports": [
                  {
                    "containerPort": 3306
                  }
                ],
                "volumeMounts": [
                  {
                    "name": "data",
                    "mountPath": "/var/lib/mysql/data"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "MYSQL_PWD='${DATABASE_PASSWORD}' mysql -h 127.0.0.1 -u ${DATABASE_USER} -D ${DATABASE_NAME} -e 'SELECT 1'" ]
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 1,
                    "initialDelaySeconds": 30,
                    "tcpSocket": {
                        "port": 3306
                    }
                },
                "env": [
                  {
                    "name": "MYSQL_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "MYSQL_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                      "name": "MYSQL_DATABASE",
                      "value": "${DATABASE_NAME}"
                  }
                ],
                "resources": {
                    "limits": {
                        "memory": "${MEMORY_MYSQL_LIMIT}"
                    }
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "NAME",
      "displayName": "Name",
      "description": "The name assigned to all of the frontend objects defined in this template.",
      "required": true,
      "value": "dancer-mysql-example"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the Perl Dancer container can use.",
      "value": "512Mi"
    },
    {
      "name": "MEMORY_MYSQL_LIMIT",
      "displayName": "Memory Limit (MySQL)",
      "description": "Maximum amount of memory the MySQL container can use.",
      "value": "512Mi"
    },
    {
      "name": "SOURCE_REPOSITORY_URL",
      "displayName": "Git Repository URL",
      "description": "The URL of the repository with your application source code.",
      "value": "https://github.com/openshift/dancer-ex.git"
    },
    {
      "name": "SOURCE_REPOSITORY_REF",
      "displayName": "Git Reference",
      "description": "Set this to a branch name, tag or other ref of your repository if you are not using the default branch."
    },
    {
      "name": "CONTEXT_DIR",
      "displayName": "Context Directory",
      "description": "Set this to the relative path to your project if it is not in the root of your repository."
    },
    {
      "name": "APPLICATION_DOMAIN",
      "displayName": "Application Hostname",
      "description": "The exposed hostname that will route to the Dancer service, if left blank a value will be defaulted.",
      "value": ""
    },
    {
      "name": "GITHUB_WEBHOOK_SECRET",
      "displayName": "GitHub Webhook Secret",
      "description": "A secret string used to configure the GitHub webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "ADMIN_USERNAME",
      "displayName": "Administrator Username",
      "generate": "expression",
      "from": "admin[A-Z0-9]{3}"
    },
    {
      "name": "ADMIN_PASSWORD",
      "displayName": "Administrator Password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{8}"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "value": "database"
    },
    {
      "name": "DATABASE_USER",
      "displayName": "Database Username",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}"
    },
    {
      "name": "DATABASE_PASSWORD",
      "displayName": "Database Password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{8}"
    },
    {
      "name": "DATABASE_NAME",
      "displayName": "Database Name",
      "value": "sampledb"
    },
    {
      "name": "PERL_APACHE2_RELOAD",
      "displayName": "Perl Module Reload",
      "description": "Set this to \"true\" to enable automatic reloading of modified Perl modules.",
      "value": ""
    },
    {
      "name": "SECRET_KEY_BASE",
      "displayName": "Secret Key",
      "description": "Your secret key for verifying the integrity of signed cookies.",
      "generate": "expression",
      "from": "[a-z0-9]{127}"
    }
  ]
}
`)

func examplesQuickstartsDancerMysqlJsonBytes() ([]byte, error) {
	return _examplesQuickstartsDancerMysqlJson, nil
}

func examplesQuickstartsDancerMysqlJson() (*asset, error) {
	bytes, err := examplesQuickstartsDancerMysqlJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/quickstarts/dancer-mysql.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesQuickstartsDjangoPostgresqlJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "django-psql-example",
    "annotations": {
      "description": "An example Django application with a PostgreSQL database",
      "tags": "quickstart,python,django,postgresql",
      "iconClass": "icon-python"
    }
  },
  "labels": {
    "template": "django-psql-example"
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Exposes and load balances the application pods"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "port": 8080,
            "targetPort": 8080
          }
        ],
        "selector": {
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}"
      },
      "spec": {
        "host": "${APPLICATION_DOMAIN}",
        "to": {
          "kind": "Service",
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Keeps track of changes in the application image"
        }
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to build the application"
        }
      },
      "spec": {
        "source": {
          "type": "Git",
          "git": {
            "uri": "${SOURCE_REPOSITORY_URL}",
            "ref": "${SOURCE_REPOSITORY_REF}"
          },
          "contextDir": "${CONTEXT_DIR}"
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "namespace": "${NAMESPACE}",
              "name": "python:3.4"
            }
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "${NAME}:latest"
          }
        },
        "triggers": [
          {
            "type": "ImageChange"
          },
          {
            "type": "ConfigChange"
          },
          {
            "type": "GitHub",
            "github": {
              "secret": "${GITHUB_WEBHOOK_SECRET}"
            }
          }
        ],
        "postCommit": {
           "script": "./manage.py test"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to deploy the application server"
        }
      },
      "spec": {
        "strategy": {
          "type": "Rolling"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "django-psql-example"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${NAME}:latest"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${NAME}"
        },
        "template": {
          "metadata": {
            "name": "${NAME}",
            "labels": {
              "name": "${NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "django-psql-example",
                "image": "django-psql-example",
                "ports": [
                  {
                    "containerPort": 8080
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 3,
                  "httpGet": {
                    "path": "/health",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 30,
                  "httpGet": {
                    "path": "/health",
                    "port": 8080
                  }
                },
                "env": [
                  {
                    "name": "DATABASE_SERVICE_NAME",
                    "value": "${DATABASE_SERVICE_NAME}"
                  },
                  {
                    "name": "DATABASE_ENGINE",
                    "value": "${DATABASE_ENGINE}"
                  },
                  {
                    "name": "DATABASE_NAME",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "DATABASE_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "DATABASE_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "APP_CONFIG",
                    "value": "${APP_CONFIG}"
                  },
                  {
                    "name": "DJANGO_SECRET_KEY",
                    "value": "${DJANGO_SECRET_KEY}"
                  }
                ],
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_LIMIT}"
                  }
                }
              }
            ]
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Exposes the database server"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "postgresql",
            "port": 5432,
            "targetPort": 5432
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Defines how to deploy the database"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": false,
              "containerNames": [
                "postgresql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "namespace": "${NAMESPACE}",
                "name": "postgresql:9.4"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "name": "${DATABASE_SERVICE_NAME}",
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "volumes": [
              {
                "name": "data",
                "emptyDir": {}
              }
            ],
            "containers": [
              {
                "name": "postgresql",
                "image": "postgresql",
                "ports": [
                  {
                    "containerPort": 5432
                  }
                ],
                "env": [
                  {
                    "name": "POSTGRESQL_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "POSTGRESQL_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "POSTGRESQL_DATABASE",
                    "value": "${DATABASE_NAME}"
                  }
                ],
                "volumeMounts": [
                  {
                    "name": "data",
                    "mountPath": "/var/lib/pgsql/data"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "psql -h 127.0.0.1 -U ${POSTGRESQL_USER} -q -d ${POSTGRESQL_DATABASE} -c 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 5432
                  }
                },
                "resources": {
                  "limits": {
                    "memory": "${MEMORY_POSTGRESQL_LIMIT}"
                  }
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "NAME",
      "displayName": "Name",
      "description": "The name assigned to all of the frontend objects defined in this template.",
      "required": true,
      "value": "django-psql-example"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the Django container can use.",
      "value": "512Mi"
    },
    {
      "name": "MEMORY_POSTGRESQL_LIMIT",
      "displayName": "Memory Limit (PostgreSQL)",
      "description": "Maximum amount of memory the PostgreSQL container can use.",
      "value": "512Mi"
    },
    {
      "name": "SOURCE_REPOSITORY_URL",
      "displayName": "Git Repository URL",
      "description": "The URL of the repository with your application source code.",
      "value": "https://github.com/openshift/django-ex.git"
    },
    {
      "name": "SOURCE_REPOSITORY_REF",
      "displayName": "Git Reference",
      "description": "Set this to a branch name, tag or other ref of your repository if you are not using the default branch."
    },
    {
      "name": "CONTEXT_DIR",
      "displayName": "Context Directory",
      "description": "Set this to the relative path to your project if it is not in the root of your repository."
    },
    {
      "name": "APPLICATION_DOMAIN",
      "displayName": "Application Hostname",
      "description": "The exposed hostname that will route to the Django service, if left blank a value will be defaulted.",
      "value": ""
    },
    {
      "name": "GITHUB_WEBHOOK_SECRET",
      "displayName": "GitHub Webhook Secret",
      "description": "A secret string used to configure the GitHub webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "value": "postgresql"
    },
    {
      "name": "DATABASE_ENGINE",
      "displayName": "Database Engine",
      "description": "Database engine: postgresql, mysql or sqlite (default).",
      "value": "postgresql"
    },
    {
      "name": "DATABASE_NAME",
      "displayName": "Database Name",
      "value": "default"
    },
    {
      "name": "DATABASE_USER",
      "displayName": "Database Username",
      "value": "django"
    },
    {
      "name": "DATABASE_PASSWORD",
      "displayName": "Database User Password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}"
    },
    {
      "name": "APP_CONFIG",
      "displayName": "Application Configuration File Path",
      "description": "Relative path to Gunicorn configuration file (optional)."
    },
    {
      "name": "DJANGO_SECRET_KEY",
      "displayName": "Djange Secret Key",
      "description": "Set this to a long random string.",
      "generate": "expression",
      "from": "[\\w]{50}"
    }
  ]
}
`)

func examplesQuickstartsDjangoPostgresqlJsonBytes() ([]byte, error) {
	return _examplesQuickstartsDjangoPostgresqlJson, nil
}

func examplesQuickstartsDjangoPostgresqlJson() (*asset, error) {
	bytes, err := examplesQuickstartsDjangoPostgresqlJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/quickstarts/django-postgresql.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesQuickstartsNodejsMongodbJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "nodejs-mongodb-example",
    "annotations": {
      "description": "An example Node.js application with a MongoDB database",
      "tags": "quickstart,nodejs,mongodb",
      "iconClass": "icon-nodejs"
    }
  },
  "labels": {
    "template": "nodejs-mongodb-example"
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Exposes and load balances the application pods"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "port": 8080,
            "targetPort": 8080
          }
        ],
        "selector": {
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}"
      },
      "spec": {
        "host": "${APPLICATION_DOMAIN}",
        "to": {
          "kind": "Service",
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Keeps track of changes in the application image"
        }
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to build the application"
        }
      },
      "spec": {
        "source": {
          "type": "Git",
          "git": {
            "uri": "${SOURCE_REPOSITORY_URL}",
            "ref": "${SOURCE_REPOSITORY_REF}"
          },
          "contextDir": "${CONTEXT_DIR}"
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "namespace": "${NAMESPACE}",
              "name": "nodejs:0.10"
            }
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "${NAME}:latest"
          }
        },
        "triggers": [
          {
            "type": "ImageChange"
          },
          {
            "type": "ConfigChange"
          },
          {
            "type": "GitHub",
            "github": {
              "secret": "${GITHUB_WEBHOOK_SECRET}"
            }
          },
          {
            "type": "Generic",
            "generic": {
              "secret": "${GENERIC_WEBHOOK_SECRET}"
            }
          }
        ]
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to deploy the application server"
        }
      },
      "spec": {
        "strategy": {
          "type": "Rolling"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "nodejs-mongodb-example"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${NAME}:latest"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${NAME}"
        },
        "template": {
          "metadata": {
            "name": "${NAME}",
            "labels": {
              "name": "${NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "nodejs-mongodb-example",
                "image": "nodejs-mongodb-example",
                "ports": [
                  {
                    "containerPort": 8080
                  }
                ],
                "env": [
                  {
                    "name": "DATABASE_SERVICE_NAME",
                    "value": "${DATABASE_SERVICE_NAME}"
                  },
                  {
                    "name": "MONGODB_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "MONGODB_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "MONGODB_DATABASE",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "MONGODB_ADMIN_PASSWORD",
                    "value": "${DATABASE_ADMIN_PASSWORD}"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 3,
                  "httpGet": {
                    "path": "/pagecount",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                    "timeoutSeconds": 3,
                    "initialDelaySeconds": 30,
                    "httpGet": {
                        "path": "/pagecount",
                        "port": 8080
                    }
                },
                "resources": {
                    "limits": {
                        "memory": "${MEMORY_LIMIT}"
                    }
                }
              }
            ]
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Exposes the database server"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "mongodb",
            "port": 27017,
            "targetPort": 27017
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Defines how to deploy the database"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": false,
              "containerNames": [
                "mongodb"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "namespace": "${NAMESPACE}",
                "name": "mongodb:2.6"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "name": "${DATABASE_SERVICE_NAME}",
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "volumes": [
              {
                "name": "data",
                "emptyDir": {}
              }
            ],
            "containers": [
              {
                "name": "mongodb",
                "image": "mongodb",
                "ports": [
                  {
                    "containerPort": 27017
                  }
                ],
                "volumeMounts": [
                  {
                    "name": "data",
                    "mountPath": "/var/lib/mongodb/data"
                  }
                ],
                "env": [
                  {
                    "name": "MONGODB_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "MONGODB_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "MONGODB_DATABASE",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "MONGODB_ADMIN_PASSWORD",
                    "value": "${DATABASE_ADMIN_PASSWORD}"
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 3,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "mongostat --host 127.0.0.1 -u admin -p ${DATABASE_ADMIN_PASSWORD} -n 1 --noheaders"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 27017
                  }
                },
                "resources": {
                    "limits": {
                        "memory": "${MEMORY_MONGODB_LIMIT}"
                    }
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "NAME",
      "displayName": "Name",
      "description": "The name assigned to all of the frontend objects defined in this template.",
      "required": true,
      "value": "nodejs-mongodb-example"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the Node.js container can use.",
      "value": "512Mi"
    },
    {
      "name": "MEMORY_MONGODB_LIMIT",
      "displayName": "Memory Limit (MongoDB)",
      "description": "Maximum amount of memory the MongoDB container can use.",
      "value": "512Mi"
    },
    {
      "name": "SOURCE_REPOSITORY_URL",
      "displayName": "Git Repository URL",
      "description": "The URL of the repository with your application source code.",
      "value": "https://github.com/openshift/nodejs-ex.git"
    },
    {
      "name": "SOURCE_REPOSITORY_REF",
      "displayName": "Git Reference",
      "description": "Set this to a branch name, tag or other ref of your repository if you are not using the default branch."
    },
    {
      "name": "CONTEXT_DIR",
      "displayName": "Context Directory",
      "description": "Set this to the relative path to your project if it is not in the root of your repository."
    },
    {
      "name": "APPLICATION_DOMAIN",
      "displayName": "Application Hostname",
      "description": "The exposed hostname that will route to the Node.js service, if left blank a value will be defaulted.",
      "value": ""
    },
    {
      "name": "GITHUB_WEBHOOK_SECRET",
      "displayName": "GitHub Webhook Secret",
      "description": "A secret string used to configure the GitHub webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "GENERIC_WEBHOOK_SECRET",
      "displayName": "Generic Webhook Secret",
      "description": "A secret string used to configure the Generic webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "value": "mongodb"
    },
    {
      "name": "DATABASE_USER",
      "displayName": "MongoDB Username",
      "description": "Username for MongoDB user that will be used for accessing the database.",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}"
    },
    {
      "name": "DATABASE_PASSWORD",
      "displayName": "MongoDB Password",
      "description": "Password for the MongoDB user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}"
    },
    {
      "name": "DATABASE_NAME",
      "displayName": "Database Name",
      "value": "sampledb"
    },
    {
      "name": "DATABASE_ADMIN_PASSWORD",
      "displayName": "Database Administrator Password",
      "description": "Password for the database admin user.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{16}"
    }
  ]
}
`)

func examplesQuickstartsNodejsMongodbJsonBytes() ([]byte, error) {
	return _examplesQuickstartsNodejsMongodbJson, nil
}

func examplesQuickstartsNodejsMongodbJson() (*asset, error) {
	bytes, err := examplesQuickstartsNodejsMongodbJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/quickstarts/nodejs-mongodb.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

var _examplesQuickstartsRailsPostgresqlJson = []byte(`{
  "kind": "Template",
  "apiVersion": "v1",
  "metadata": {
    "name": "rails-postgresql-example",
    "annotations": {
      "description": "An example Rails application with a PostgreSQL database",
      "tags": "quickstart,ruby,rails,postgresql",
      "iconClass": "icon-ruby"
    }
  },
  "labels": {
    "template": "rails-postgresql-example"
  },
  "objects": [
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Exposes and load balances the application pods"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "web",
            "port": 8080,
            "targetPort": 8080
          }
        ],
        "selector": {
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "Route",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}"
      },
      "spec": {
        "host": "${APPLICATION_DOMAIN}",
        "to": {
          "kind": "Service",
          "name": "${NAME}"
        }
      }
    },
    {
      "kind": "ImageStream",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Keeps track of changes in the application image"
        }
      }
    },
    {
      "kind": "BuildConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to build the application"
        }
      },
      "spec": {
        "source": {
          "type": "Git",
          "git": {
            "uri": "${SOURCE_REPOSITORY_URL}",
            "ref": "${SOURCE_REPOSITORY_REF}"
          },
          "contextDir": "${CONTEXT_DIR}"
        },
        "strategy": {
          "type": "Source",
          "sourceStrategy": {
            "from": {
              "kind": "ImageStreamTag",
              "namespace": "${NAMESPACE}",
              "name": "ruby:2.2"
            }
          }
        },
        "output": {
          "to": {
            "kind": "ImageStreamTag",
            "name": "${NAME}:latest"
          }
        },
        "triggers": [
          {
            "type": "ImageChange"
          },
          {
            "type": "ConfigChange"
          },
          {
            "type": "GitHub",
            "github": {
              "secret": "${GITHUB_WEBHOOK_SECRET}"
            }
          }
        ],
        "postCommit": {
          "script": "bundle exec rake test"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${NAME}",
        "annotations": {
          "description": "Defines how to deploy the application server"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate",
          "recreateParams": {
          "pre": {
              "failurePolicy": "Abort",
              "execNewPod": {
                "command": [
                  "./migrate-database.sh"
                ],
                "containerName": "${NAME}"
              }
            }
          }
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": true,
              "containerNames": [
                "rails-postgresql-example"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "name": "${NAME}:latest"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${NAME}"
        },
        "template": {
          "metadata": {
            "name": "${NAME}",
            "labels": {
              "name": "${NAME}"
            }
          },
          "spec": {
            "containers": [
              {
                "name": "rails-postgresql-example",
                "image": "rails-postgresql-example",
                "ports": [
                  {
                    "containerPort": 8080
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 5,
                  "httpGet": {
                    "path": "/articles",
                    "port": 8080
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 3,
                  "initialDelaySeconds": 10,
                  "httpGet": {
                    "path": "/articles",
                    "port": 8080
                  }
                },
                "env": [
                  {
                    "name": "DATABASE_SERVICE_NAME",
                    "value": "${DATABASE_SERVICE_NAME}"
                  },
                  {
                    "name": "POSTGRESQL_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "POSTGRESQL_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "POSTGRESQL_DATABASE",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "SECRET_KEY_BASE",
                    "value": "${SECRET_KEY_BASE}"
                  },
                  {
                    "name": "POSTGRESQL_MAX_CONNECTIONS",
                    "value": "${POSTGRESQL_MAX_CONNECTIONS}"
                  },
                  {
                    "name": "POSTGRESQL_SHARED_BUFFERS",
                    "value": "${POSTGRESQL_SHARED_BUFFERS}"
                  },
                  {
                    "name": "APPLICATION_DOMAIN",
                    "value": "${APPLICATION_DOMAIN}"
                  },
                  {
                    "name": "APPLICATION_USER",
                    "value": "${APPLICATION_USER}"
                  },
                  {
                    "name": "APPLICATION_PASSWORD",
                    "value": "${APPLICATION_PASSWORD}"
                  },
                  {
                    "name": "RAILS_ENV",
                    "value": "${RAILS_ENV}"
                  }
                ],
                "resources": {
		      "limits": {
			  "memory": "${MEMORY_LIMIT}"
		      }
                }
              }
            ]
          }
        }
      }
    },
    {
      "kind": "Service",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Exposes the database server"
        }
      },
      "spec": {
        "ports": [
          {
            "name": "postgresql",
            "port": 5432,
            "targetPort": 5432
          }
        ],
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        }
      }
    },
    {
      "kind": "DeploymentConfig",
      "apiVersion": "v1",
      "metadata": {
        "name": "${DATABASE_SERVICE_NAME}",
        "annotations": {
          "description": "Defines how to deploy the database"
        }
      },
      "spec": {
        "strategy": {
          "type": "Recreate"
        },
        "triggers": [
          {
            "type": "ImageChange",
            "imageChangeParams": {
              "automatic": false,
              "containerNames": [
                "postgresql"
              ],
              "from": {
                "kind": "ImageStreamTag",
                "namespace": "${NAMESPACE}",
                "name": "postgresql:9.4"
              }
            }
          },
          {
            "type": "ConfigChange"
          }
        ],
        "replicas": 1,
        "selector": {
          "name": "${DATABASE_SERVICE_NAME}"
        },
        "template": {
          "metadata": {
            "name": "${DATABASE_SERVICE_NAME}",
            "labels": {
              "name": "${DATABASE_SERVICE_NAME}"
            }
          },
          "spec": {
            "volumes": [
              {
                "name": "data",
                "emptyDir": {}
              }
            ],
            "containers": [
              {
                "name": "postgresql",
                "image": "postgresql",
                "ports": [
                  {
                    "containerPort": 5432
                  }
                ],
                "readinessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 5,
                  "exec": {
                    "command": [ "/bin/sh", "-i", "-c", "psql -h 127.0.0.1 -U ${POSTGRESQL_USER} -q -d ${POSTGRESQL_DATABASE} -c 'SELECT 1'"]
                  }
                },
                "livenessProbe": {
                  "timeoutSeconds": 1,
                  "initialDelaySeconds": 30,
                  "tcpSocket": {
                    "port": 5432
                  }
                },
                "volumeMounts": [
                  {
                    "name": "data",
                    "mountPath": "/var/lib/pgsql/data"
                  }
                ],
                "env": [
                  {
                    "name": "POSTGRESQL_USER",
                    "value": "${DATABASE_USER}"
                  },
                  {
                    "name": "POSTGRESQL_PASSWORD",
                    "value": "${DATABASE_PASSWORD}"
                  },
                  {
                    "name": "POSTGRESQL_DATABASE",
                    "value": "${DATABASE_NAME}"
                  },
                  {
                    "name": "POSTGRESQL_MAX_CONNECTIONS",
                    "value": "${POSTGRESQL_MAX_CONNECTIONS}"
                  },
                  {
                    "name": "POSTGRESQL_SHARED_BUFFERS",
                    "value": "${POSTGRESQL_SHARED_BUFFERS}"
                  }
                ],
                "resources": {
		      "limits": {
			  "memory": "${MEMORY_POSTGRESQL_LIMIT}"
		      }
                }
              }
            ]
          }
        }
      }
    }
  ],
  "parameters": [
    {
      "name": "NAME",
      "displayName": "Name",
      "description": "The name assigned to all of the frontend objects defined in this template.",
      "required": true,
      "value": "rails-postgresql-example"
    },
    {
      "name": "NAMESPACE",
      "displayName": "Namespace",
      "description": "The OpenShift Namespace where the ImageStream resides.",
      "value": "openshift"
    },
    {
      "name": "MEMORY_LIMIT",
      "displayName": "Memory Limit",
      "description": "Maximum amount of memory the Rails container can use.",
      "value": "512Mi"
    },
    {
      "name": "MEMORY_POSTGRESQL_LIMIT",
      "displayName": "Memory Limit (PostgreSQL)",
      "description": "Maximum amount of memory the PostgreSQL container can use.",
      "value": "512Mi"
    },
    {
      "name": "SOURCE_REPOSITORY_URL",
      "displayName": "Git Repository URL",
      "description": "The URL of the repository with your application source code.",
      "value": "https://github.com/openshift/rails-ex.git"
    },
    {
      "name": "SOURCE_REPOSITORY_REF",
      "displayName": "Git Reference",
      "description": "Set this to a branch name, tag or other ref of your repository if you are not using the default branch."
    },
    {
      "name": "CONTEXT_DIR",
      "displayName": "Context Directory",
      "description": "Set this to the relative path to your project if it is not in the root of your repository."
    },
    {
      "name": "APPLICATION_DOMAIN",
      "displayName": "Application Hostname",
      "description": "The exposed hostname that will route to the Rails service, if left blank a value will be defaulted.",
      "value": ""
    },
    {
      "name": "GITHUB_WEBHOOK_SECRET",
      "displayName": "GitHub Webhook Secret",
      "description": "A secret string used to configure the GitHub webhook.",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{40}"
    },
    {
      "name": "SECRET_KEY_BASE",
      "displayName": "Secret Key",
      "description": "Your secret key for verifying the integrity of signed cookies.",
      "generate": "expression",
      "from": "[a-z0-9]{127}"
    },
    {
      "name": "APPLICATION_USER",
      "displayName": "Application Username",
      "description": "The application user that is used within the sample application to authorize access on pages.",
      "value": "openshift"
    },
    {
      "name": "APPLICATION_PASSWORD",
      "displayName": "Application Password",
      "description": "The application password that is used within the sample application to authorize access on pages.",
      "value": "secret"
    },
    {
      "name": "RAILS_ENV",
      "displayName": "Rails Environment",
      "description": "Environment under which the sample application will run. Could be set to production, development or test.",
      "value": "production"
    },
    {
      "name": "DATABASE_SERVICE_NAME",
      "displayName": "Database Service Name",
      "value": "postgresql"
    },
    {
      "name": "DATABASE_USER",
      "displayName": "Database Username",
      "generate": "expression",
      "from": "user[A-Z0-9]{3}"
    },
    {
      "name": "DATABASE_PASSWORD",
      "displayName": "Database Password",
      "generate": "expression",
      "from": "[a-zA-Z0-9]{8}"
    },
    {
      "name": "DATABASE_NAME",
      "displayName": "Database Name",
      "value": "root"
    },
    {
      "name": "POSTGRESQL_MAX_CONNECTIONS",
      "displayName": "Maximum Database Connections",
      "value": "100"
    },
    {
      "name": "POSTGRESQL_SHARED_BUFFERS",
      "displayName": "Shared Buffer Amount",
      "value": "12MB"
    }
  ]
}
`)

func examplesQuickstartsRailsPostgresqlJsonBytes() ([]byte, error) {
	return _examplesQuickstartsRailsPostgresqlJson, nil
}

func examplesQuickstartsRailsPostgresqlJson() (*asset, error) {
	bytes, err := examplesQuickstartsRailsPostgresqlJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "examples/quickstarts/rails-postgresql.json", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info:  info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if (err != nil) {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"examples/image-streams/image-streams-centos7.json": examplesImageStreamsImageStreamsCentos7Json,
	"examples/image-streams/image-streams-rhel7.json": examplesImageStreamsImageStreamsRhel7Json,
	"examples/db-templates/mongodb-ephemeral-template.json": examplesDbTemplatesMongodbEphemeralTemplateJson,
	"examples/db-templates/mongodb-persistent-template.json": examplesDbTemplatesMongodbPersistentTemplateJson,
	"examples/db-templates/mysql-ephemeral-template.json": examplesDbTemplatesMysqlEphemeralTemplateJson,
	"examples/db-templates/mysql-persistent-template.json": examplesDbTemplatesMysqlPersistentTemplateJson,
	"examples/db-templates/postgresql-ephemeral-template.json": examplesDbTemplatesPostgresqlEphemeralTemplateJson,
	"examples/db-templates/postgresql-persistent-template.json": examplesDbTemplatesPostgresqlPersistentTemplateJson,
	"examples/quickstarts/cakephp-mysql.json": examplesQuickstartsCakephpMysqlJson,
	"examples/quickstarts/dancer-mysql.json": examplesQuickstartsDancerMysqlJson,
	"examples/quickstarts/django-postgresql.json": examplesQuickstartsDjangoPostgresqlJson,
	"examples/quickstarts/nodejs-mongodb.json": examplesQuickstartsNodejsMongodbJson,
	"examples/quickstarts/rails-postgresql.json": examplesQuickstartsRailsPostgresqlJson,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func func() (*asset, error)
	Children map[string]*bintree
}
var _bintree = &bintree{nil, map[string]*bintree{
	"examples": &bintree{nil, map[string]*bintree{
		"db-templates": &bintree{nil, map[string]*bintree{
			"mongodb-ephemeral-template.json": &bintree{examplesDbTemplatesMongodbEphemeralTemplateJson, map[string]*bintree{
			}},
			"mongodb-persistent-template.json": &bintree{examplesDbTemplatesMongodbPersistentTemplateJson, map[string]*bintree{
			}},
			"mysql-ephemeral-template.json": &bintree{examplesDbTemplatesMysqlEphemeralTemplateJson, map[string]*bintree{
			}},
			"mysql-persistent-template.json": &bintree{examplesDbTemplatesMysqlPersistentTemplateJson, map[string]*bintree{
			}},
			"postgresql-ephemeral-template.json": &bintree{examplesDbTemplatesPostgresqlEphemeralTemplateJson, map[string]*bintree{
			}},
			"postgresql-persistent-template.json": &bintree{examplesDbTemplatesPostgresqlPersistentTemplateJson, map[string]*bintree{
			}},
		}},
		"image-streams": &bintree{nil, map[string]*bintree{
			"image-streams-centos7.json": &bintree{examplesImageStreamsImageStreamsCentos7Json, map[string]*bintree{
			}},
			"image-streams-rhel7.json": &bintree{examplesImageStreamsImageStreamsRhel7Json, map[string]*bintree{
			}},
		}},
		"quickstarts": &bintree{nil, map[string]*bintree{
			"cakephp-mysql.json": &bintree{examplesQuickstartsCakephpMysqlJson, map[string]*bintree{
			}},
			"dancer-mysql.json": &bintree{examplesQuickstartsDancerMysqlJson, map[string]*bintree{
			}},
			"django-postgresql.json": &bintree{examplesQuickstartsDjangoPostgresqlJson, map[string]*bintree{
			}},
			"nodejs-mongodb.json": &bintree{examplesQuickstartsNodejsMongodbJson, map[string]*bintree{
			}},
			"rails-postgresql.json": &bintree{examplesQuickstartsRailsPostgresqlJson, map[string]*bintree{
			}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
        data, err := Asset(name)
        if err != nil {
                return err
        }
        info, err := AssetInfo(name)
        if err != nil {
                return err
        }
        err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
        if err != nil {
                return err
        }
        err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
        if err != nil {
                return err
        }
        err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
        if err != nil {
                return err
        }
        return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
        children, err := AssetDir(name)
        // File
        if err != nil {
                return RestoreAsset(dir, name)
        }
        // Dir
        for _, child := range children {
                err = RestoreAssets(dir, filepath.Join(name, child))
                if err != nil {
                        return err
                }
        }
        return nil
}

func _filePath(dir, name string) string {
        cannonicalName := strings.Replace(name, "\\", "/", -1)
        return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}

