// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroups

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGroup for more information on using the CreateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/CreateGroup
func (c *ResourceGroups) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/groups",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for AWS Resource Groups.
//
// Creates a group with a specified name, description, and resource query.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation CreateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/CreateGroup
func (c *ResourceGroups) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	return out, req.Send()
}

// CreateGroupWithContext is the same as CreateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) CreateGroupWithContext(ctx aws.Context, input *CreateGroupInput, opts ...request.Option) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGroup for more information on using the DeleteGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/DeleteGroup
func (c *ResourceGroups) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/groups/{GroupName}",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGroup API operation for AWS Resource Groups.
//
// Deletes a specified resource group. Deleting a resource group does not delete
// resources that are members of the group; it only deletes the group structure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more resources specified in the request do not exist.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/DeleteGroup
func (c *ResourceGroups) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	return out, req.Send()
}

// DeleteGroupWithContext is the same as DeleteGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) DeleteGroupWithContext(ctx aws.Context, input *DeleteGroupInput, opts ...request.Option) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroup = "GetGroup"

// GetGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroup for more information on using the GetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupRequest method.
//    req, resp := client.GetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroup
func (c *ResourceGroups) GetGroupRequest(input *GetGroupInput) (req *request.Request, output *GetGroupOutput) {
	op := &request.Operation{
		Name:       opGetGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/groups/{GroupName}",
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	output = &GetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroup API operation for AWS Resource Groups.
//
// Returns information about a specified resource group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation GetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more resources specified in the request do not exist.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroup
func (c *ResourceGroups) GetGroup(input *GetGroupInput) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	return out, req.Send()
}

// GetGroupWithContext is the same as GetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) GetGroupWithContext(ctx aws.Context, input *GetGroupInput, opts ...request.Option) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGroupQuery = "GetGroupQuery"

// GetGroupQueryRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGroupQuery for more information on using the GetGroupQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGroupQueryRequest method.
//    req, resp := client.GetGroupQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupQuery
func (c *ResourceGroups) GetGroupQueryRequest(input *GetGroupQueryInput) (req *request.Request, output *GetGroupQueryOutput) {
	op := &request.Operation{
		Name:       opGetGroupQuery,
		HTTPMethod: "GET",
		HTTPPath:   "/groups/{GroupName}/query",
	}

	if input == nil {
		input = &GetGroupQueryInput{}
	}

	output = &GetGroupQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupQuery API operation for AWS Resource Groups.
//
// Returns the resource query associated with the specified resource group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation GetGroupQuery for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more resources specified in the request do not exist.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupQuery
func (c *ResourceGroups) GetGroupQuery(input *GetGroupQueryInput) (*GetGroupQueryOutput, error) {
	req, out := c.GetGroupQueryRequest(input)
	return out, req.Send()
}

// GetGroupQueryWithContext is the same as GetGroupQuery with the addition of
// the ability to pass a context and additional request options.
//
// See GetGroupQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) GetGroupQueryWithContext(ctx aws.Context, input *GetGroupQueryInput, opts ...request.Option) (*GetGroupQueryOutput, error) {
	req, out := c.GetGroupQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTags = "GetTags"

// GetTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTags for more information on using the GetTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagsRequest method.
//    req, resp := client.GetTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetTags
func (c *ResourceGroups) GetTagsRequest(input *GetTagsInput) (req *request.Request, output *GetTagsOutput) {
	op := &request.Operation{
		Name:       opGetTags,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/{Arn}/tags",
	}

	if input == nil {
		input = &GetTagsInput{}
	}

	output = &GetTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTags API operation for AWS Resource Groups.
//
// Returns a list of tags that are associated with a resource, specified by
// an ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation GetTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more resources specified in the request do not exist.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetTags
func (c *ResourceGroups) GetTags(input *GetTagsInput) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	return out, req.Send()
}

// GetTagsWithContext is the same as GetTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) GetTagsWithContext(ctx aws.Context, input *GetTagsInput, opts ...request.Option) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupResources = "ListGroupResources"

// ListGroupResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroupResources for more information on using the ListGroupResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupResourcesRequest method.
//    req, resp := client.ListGroupResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroupResources
func (c *ResourceGroups) ListGroupResourcesRequest(input *ListGroupResourcesInput) (req *request.Request, output *ListGroupResourcesOutput) {
	op := &request.Operation{
		Name:       opListGroupResources,
		HTTPMethod: "POST",
		HTTPPath:   "/groups/{GroupName}/resource-identifiers-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupResourcesInput{}
	}

	output = &ListGroupResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupResources API operation for AWS Resource Groups.
//
// Returns a list of ARNs of resources that are members of a specified resource
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation ListGroupResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The request has not been applied because it lacks valid authentication credentials
//   for the target resource.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more resources specified in the request do not exist.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroupResources
func (c *ResourceGroups) ListGroupResources(input *ListGroupResourcesInput) (*ListGroupResourcesOutput, error) {
	req, out := c.ListGroupResourcesRequest(input)
	return out, req.Send()
}

// ListGroupResourcesWithContext is the same as ListGroupResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) ListGroupResourcesWithContext(ctx aws.Context, input *ListGroupResourcesInput, opts ...request.Option) (*ListGroupResourcesOutput, error) {
	req, out := c.ListGroupResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupResourcesPages iterates over the pages of a ListGroupResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroupResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroupResources operation.
//    pageNum := 0
//    err := client.ListGroupResourcesPages(params,
//        func(page *ListGroupResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroups) ListGroupResourcesPages(input *ListGroupResourcesInput, fn func(*ListGroupResourcesOutput, bool) bool) error {
	return c.ListGroupResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupResourcesPagesWithContext same as ListGroupResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) ListGroupResourcesPagesWithContext(ctx aws.Context, input *ListGroupResourcesInput, fn func(*ListGroupResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListGroupResourcesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroups for more information on using the ListGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroups
func (c *ResourceGroups) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/groups-list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for AWS Resource Groups.
//
// Returns a list of existing resource groups in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation ListGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroups
func (c *ResourceGroups) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	return out, req.Send()
}

// ListGroupsWithContext is the same as ListGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) ListGroupsWithContext(ctx aws.Context, input *ListGroupsInput, opts ...request.Option) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroupsPages iterates over the pages of a ListGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroups operation.
//    pageNum := 0
//    err := client.ListGroupsPages(params,
//        func(page *ListGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroups) ListGroupsPages(input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool) error {
	return c.ListGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroupsPagesWithContext same as ListGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) ListGroupsPagesWithContext(ctx aws.Context, input *ListGroupsInput, fn func(*ListGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListGroupsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchResources = "SearchResources"

// SearchResourcesRequest generates a "aws/request.Request" representing the
// client's request for the SearchResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchResources for more information on using the SearchResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchResourcesRequest method.
//    req, resp := client.SearchResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResources
func (c *ResourceGroups) SearchResourcesRequest(input *SearchResourcesInput) (req *request.Request, output *SearchResourcesOutput) {
	op := &request.Operation{
		Name:       opSearchResources,
		HTTPMethod: "POST",
		HTTPPath:   "/resources/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchResourcesInput{}
	}

	output = &SearchResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchResources API operation for AWS Resource Groups.
//
// Returns a list of AWS resource identifiers that matches a specified query.
// The query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation SearchResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnauthorizedException "UnauthorizedException"
//   The request has not been applied because it lacks valid authentication credentials
//   for the target resource.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResources
func (c *ResourceGroups) SearchResources(input *SearchResourcesInput) (*SearchResourcesOutput, error) {
	req, out := c.SearchResourcesRequest(input)
	return out, req.Send()
}

// SearchResourcesWithContext is the same as SearchResources with the addition of
// the ability to pass a context and additional request options.
//
// See SearchResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) SearchResourcesWithContext(ctx aws.Context, input *SearchResourcesInput, opts ...request.Option) (*SearchResourcesOutput, error) {
	req, out := c.SearchResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchResourcesPages iterates over the pages of a SearchResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchResources operation.
//    pageNum := 0
//    err := client.SearchResourcesPages(params,
//        func(page *SearchResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroups) SearchResourcesPages(input *SearchResourcesInput, fn func(*SearchResourcesOutput, bool) bool) error {
	return c.SearchResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchResourcesPagesWithContext same as SearchResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) SearchResourcesPagesWithContext(ctx aws.Context, input *SearchResourcesInput, fn func(*SearchResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchResourcesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opTag = "Tag"

// TagRequest generates a "aws/request.Request" representing the
// client's request for the Tag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Tag for more information on using the Tag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagRequest method.
//    req, resp := client.TagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Tag
func (c *ResourceGroups) TagRequest(input *TagInput) (req *request.Request, output *TagOutput) {
	op := &request.Operation{
		Name:       opTag,
		HTTPMethod: "PUT",
		HTTPPath:   "/resources/{Arn}/tags",
	}

	if input == nil {
		input = &TagInput{}
	}

	output = &TagOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Tag API operation for AWS Resource Groups.
//
// Adds tags to a resource group with the specified ARN. Existing tags on a
// resource group are not changed if they are not specified in the request parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation Tag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more resources specified in the request do not exist.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Tag
func (c *ResourceGroups) Tag(input *TagInput) (*TagOutput, error) {
	req, out := c.TagRequest(input)
	return out, req.Send()
}

// TagWithContext is the same as Tag with the addition of
// the ability to pass a context and additional request options.
//
// See Tag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) TagWithContext(ctx aws.Context, input *TagInput, opts ...request.Option) (*TagOutput, error) {
	req, out := c.TagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntag = "Untag"

// UntagRequest generates a "aws/request.Request" representing the
// client's request for the Untag operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Untag for more information on using the Untag
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagRequest method.
//    req, resp := client.UntagRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Untag
func (c *ResourceGroups) UntagRequest(input *UntagInput) (req *request.Request, output *UntagOutput) {
	op := &request.Operation{
		Name:       opUntag,
		HTTPMethod: "PATCH",
		HTTPPath:   "/resources/{Arn}/tags",
	}

	if input == nil {
		input = &UntagInput{}
	}

	output = &UntagOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Untag API operation for AWS Resource Groups.
//
// Deletes specified tags from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation Untag for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more resources specified in the request do not exist.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Untag
func (c *ResourceGroups) Untag(input *UntagInput) (*UntagOutput, error) {
	req, out := c.UntagRequest(input)
	return out, req.Send()
}

// UntagWithContext is the same as Untag with the addition of
// the ability to pass a context and additional request options.
//
// See Untag for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) UntagWithContext(ctx aws.Context, input *UntagInput, opts ...request.Option) (*UntagOutput, error) {
	req, out := c.UntagRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroup
func (c *ResourceGroups) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/groups/{GroupName}",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroup API operation for AWS Resource Groups.
//
// Updates an existing group with a new or changed description. You cannot update
// the name of a resource group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more resources specified in the request do not exist.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroup
func (c *ResourceGroups) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) UpdateGroupWithContext(ctx aws.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroupQuery = "UpdateGroupQuery"

// UpdateGroupQueryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroupQuery operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGroupQuery for more information on using the UpdateGroupQuery
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGroupQueryRequest method.
//    req, resp := client.UpdateGroupQueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroupQuery
func (c *ResourceGroups) UpdateGroupQueryRequest(input *UpdateGroupQueryInput) (req *request.Request, output *UpdateGroupQueryOutput) {
	op := &request.Operation{
		Name:       opUpdateGroupQuery,
		HTTPMethod: "PUT",
		HTTPPath:   "/groups/{GroupName}/query",
	}

	if input == nil {
		input = &UpdateGroupQueryInput{}
	}

	output = &UpdateGroupQueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGroupQuery API operation for AWS Resource Groups.
//
// Updates the resource query of a group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups's
// API operation UpdateGroupQuery for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The request does not comply with validation rules that are defined for the
//   request parameters.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   The caller is not authorized to make the request.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   One or more resources specified in the request do not exist.
//
//   * ErrCodeMethodNotAllowedException "MethodNotAllowedException"
//   The request uses an HTTP method which is not allowed for the specified resource.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   The caller has exceeded throttling limits.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal error occurred while processing the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroupQuery
func (c *ResourceGroups) UpdateGroupQuery(input *UpdateGroupQueryInput) (*UpdateGroupQueryOutput, error) {
	req, out := c.UpdateGroupQueryRequest(input)
	return out, req.Send()
}

// UpdateGroupQueryWithContext is the same as UpdateGroupQuery with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroupQuery for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroups) UpdateGroupQueryWithContext(ctx aws.Context, input *UpdateGroupQueryInput, opts ...request.Option) (*UpdateGroupQueryOutput, error) {
	req, out := c.UpdateGroupQueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the resource group. Descriptions can have a maximum of
	// 511 characters, including letters, numbers, hyphens, underscores, punctuation,
	// and spaces.
	Description *string `type:"string"`

	// The name of the group, which is the identifier of the group in other operations.
	// A resource group name cannot be updated after it is created. A resource group
	// name can have a maximum of 128 characters, including letters, numbers, hyphens,
	// dots, and underscores. The name cannot start with AWS or aws; these are reserved.
	// A resource group name must be unique within your account.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The resource query that determines which AWS resources are members of this
	// group.
	//
	// ResourceQuery is a required field
	ResourceQuery *ResourceQuery `type:"structure" required:"true"`

	// The tags to add to the group. A tag is a string-to-string map of key-value
	// pairs. Tag keys can have a maximum character length of 128 characters, and
	// tag values can have a maximum length of 256 characters.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourceQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceQuery"))
	}
	if s.ResourceQuery != nil {
		if err := s.ResourceQuery.Validate(); err != nil {
			invalidParams.AddNested("ResourceQuery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateGroupInput) SetDescription(v string) *CreateGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGroupInput) SetName(v string) *CreateGroupInput {
	s.Name = &v
	return s
}

// SetResourceQuery sets the ResourceQuery field's value.
func (s *CreateGroupInput) SetResourceQuery(v *ResourceQuery) *CreateGroupInput {
	s.ResourceQuery = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGroupInput) SetTags(v map[string]*string) *CreateGroupInput {
	s.Tags = v
	return s
}

type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// A full description of the resource group after it is created.
	Group *Group `type:"structure"`

	// The resource query associated with the group.
	ResourceQuery *ResourceQuery `type:"structure"`

	// The tags associated with the group.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateGroupOutput) SetGroup(v *Group) *CreateGroupOutput {
	s.Group = v
	return s
}

// SetResourceQuery sets the ResourceQuery field's value.
func (s *CreateGroupOutput) SetResourceQuery(v *ResourceQuery) *CreateGroupOutput {
	s.ResourceQuery = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateGroupOutput) SetTags(v map[string]*string) *CreateGroupOutput {
	s.Tags = v
	return s
}

type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group to delete.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupInput) SetGroupName(v string) *DeleteGroupInput {
	s.GroupName = &v
	return s
}

type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`

	// A full description of the deleted resource group.
	Group *Group `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *DeleteGroupOutput) SetGroup(v *Group) *DeleteGroupOutput {
	s.Group = v
	return s
}

type GetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupInput) SetGroupName(v string) *GetGroupInput {
	s.GroupName = &v
	return s
}

type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	// A full description of the resource group.
	Group *Group `type:"structure"`
}

// String returns the string representation
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *GetGroupOutput) SetGroup(v *Group) *GetGroupOutput {
	s.Group = v
	return s
}

type GetGroupQueryInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupQueryInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupQueryInput) SetGroupName(v string) *GetGroupQueryInput {
	s.GroupName = &v
	return s
}

type GetGroupQueryOutput struct {
	_ struct{} `type:"structure"`

	// The resource query associated with the specified group.
	GroupQuery *GroupQuery `type:"structure"`
}

// String returns the string representation
func (s GetGroupQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupQueryOutput) GoString() string {
	return s.String()
}

// SetGroupQuery sets the GroupQuery field's value.
func (s *GetGroupQueryOutput) SetGroupQuery(v *GroupQuery) *GetGroupQueryOutput {
	s.GroupQuery = v
	return s
}

type GetTagsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource for which you want a list of tags. The resource must
	// exist within the account you are using.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTagsInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetTagsInput) SetArn(v string) *GetTagsInput {
	s.Arn = &v
	return s
}

type GetTagsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the tagged resource.
	Arn *string `type:"string"`

	// The tags associated with the specified resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagsOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetTagsOutput) SetArn(v string) *GetTagsOutput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTagsOutput) SetTags(v map[string]*string) *GetTagsOutput {
	s.Tags = v
	return s
}

// A resource group.
type Group struct {
	_ struct{} `type:"structure"`

	// The description of the resource group.
	Description *string `type:"string"`

	// The ARN of a resource group.
	//
	// GroupArn is a required field
	GroupArn *string `type:"string" required:"true"`

	// The name of a resource group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Group) SetDescription(v string) *Group {
	s.Description = &v
	return s
}

// SetGroupArn sets the GroupArn field's value.
func (s *Group) SetGroupArn(v string) *Group {
	s.GroupArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Group) SetName(v string) *Group {
	s.Name = &v
	return s
}

// A filter name and value pair that is used to obtain more specific results
// from a list of groups.
type GroupFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"GroupFilterName"`

	// One or more filter values. Allowed filter values vary by group filter name,
	// and are case-sensitive.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s GroupFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GroupFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GroupFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GroupFilter) SetName(v string) *GroupFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *GroupFilter) SetValues(v []*string) *GroupFilter {
	s.Values = v
	return s
}

// The ARN and group name of a group.
type GroupIdentifier struct {
	_ struct{} `type:"structure"`

	// The ARN of a resource group.
	GroupArn *string `type:"string"`

	// The name of a resource group.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupIdentifier) GoString() string {
	return s.String()
}

// SetGroupArn sets the GroupArn field's value.
func (s *GroupIdentifier) SetGroupArn(v string) *GroupIdentifier {
	s.GroupArn = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GroupIdentifier) SetGroupName(v string) *GroupIdentifier {
	s.GroupName = &v
	return s
}

// The underlying resource query of a resource group. Resources that match query
// results are part of the group.
type GroupQuery struct {
	_ struct{} `type:"structure"`

	// The name of a resource group that is associated with a specific resource
	// query.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The resource query which determines which AWS resources are members of the
	// associated resource group.
	//
	// ResourceQuery is a required field
	ResourceQuery *ResourceQuery `type:"structure" required:"true"`
}

// String returns the string representation
func (s GroupQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupQuery) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *GroupQuery) SetGroupName(v string) *GroupQuery {
	s.GroupName = &v
	return s
}

// SetResourceQuery sets the ResourceQuery field's value.
func (s *GroupQuery) SetResourceQuery(v *ResourceQuery) *GroupQuery {
	s.ResourceQuery = v
	return s
}

type ListGroupResourcesInput struct {
	_ struct{} `type:"structure"`

	// Filters, formatted as ResourceFilter objects, that you want to apply to a
	// ListGroupResources operation.
	//
	//    * resource-type - Filter resources by their type. Specify up to five resource
	//    types in the format AWS::ServiceCode::ResourceType. For example, AWS::EC2::Instance,
	//    or AWS::S3::Bucket.
	Filters []*ResourceFilter `type:"list"`

	// The name of the resource group.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The maximum number of group member ARNs that are returned in a single call
	// by ListGroupResources, in paginated output. By default, this number is 50.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The NextToken value that is returned in a paginated ListGroupResources request.
	// To get the next page of results, run the call again, add the NextToken parameter,
	// and specify the NextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListGroupResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupResourcesInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListGroupResourcesInput) SetFilters(v []*ResourceFilter) *ListGroupResourcesInput {
	s.Filters = v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *ListGroupResourcesInput) SetGroupName(v string) *ListGroupResourcesInput {
	s.GroupName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupResourcesInput) SetMaxResults(v int64) *ListGroupResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupResourcesInput) SetNextToken(v string) *ListGroupResourcesInput {
	s.NextToken = &v
	return s
}

type ListGroupResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The NextToken value to include in a subsequent ListGroupResources request,
	// to get more results.
	NextToken *string `type:"string"`

	// A list of QueryError objects. Each error is an object that contains ErrorCode
	// and Message structures. Possible values for ErrorCode are CLOUDFORMATION_STACK_INACTIVE
	// and CLOUDFORMATION_STACK_NOT_EXISTING.
	QueryErrors []*QueryError `type:"list"`

	// The ARNs and resource types of resources that are members of the group that
	// you specified.
	ResourceIdentifiers []*ResourceIdentifier `type:"list"`
}

// String returns the string representation
func (s ListGroupResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupResourcesOutput) SetNextToken(v string) *ListGroupResourcesOutput {
	s.NextToken = &v
	return s
}

// SetQueryErrors sets the QueryErrors field's value.
func (s *ListGroupResourcesOutput) SetQueryErrors(v []*QueryError) *ListGroupResourcesOutput {
	s.QueryErrors = v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *ListGroupResourcesOutput) SetResourceIdentifiers(v []*ResourceIdentifier) *ListGroupResourcesOutput {
	s.ResourceIdentifiers = v
	return s
}

type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// Filters, formatted as GroupFilter objects, that you want to apply to a ListGroups
	// operation.
	//
	//    * resource-type - Filter groups by resource type. Specify up to five resource
	//    types in the format AWS::ServiceCode::ResourceType. For example, AWS::EC2::Instance,
	//    or AWS::S3::Bucket.
	Filters []*GroupFilter `type:"list"`

	// The maximum number of resource group results that are returned by ListGroups
	// in paginated output. By default, this number is 50.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The NextToken value that is returned in a paginated ListGroups request. To
	// get the next page of results, run the call again, add the NextToken parameter,
	// and specify the NextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListGroupsInput) SetFilters(v []*GroupFilter) *ListGroupsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroupsInput) SetMaxResults(v int64) *ListGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsInput) SetNextToken(v string) *ListGroupsInput {
	s.NextToken = &v
	return s
}

type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of GroupIdentifier objects. Each identifier is an object that contains
	// both the GroupName and the GroupArn.
	GroupIdentifiers []*GroupIdentifier `type:"list"`

	// A list of resource groups.
	//
	// Deprecated: This field is deprecated, use GroupIdentifiers instead.
	Groups []*Group `deprecated:"true" type:"list"`

	// The NextToken value to include in a subsequent ListGroups request, to get
	// more results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroupIdentifiers sets the GroupIdentifiers field's value.
func (s *ListGroupsOutput) SetGroupIdentifiers(v []*GroupIdentifier) *ListGroupsOutput {
	s.GroupIdentifiers = v
	return s
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*Group) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroupsOutput) SetNextToken(v string) *ListGroupsOutput {
	s.NextToken = &v
	return s
}

// A two-part error structure that can occur in ListGroupResources or SearchResources
// operations on CloudFormation stack-based queries. The error occurs if the
// CloudFormation stack on which the query is based either does not exist, or
// has a status that renders the stack inactive. A QueryError occurrence does
// not necessarily mean that AWS Resource Groups could not complete the operation,
// but the resulting group might have no member resources.
type QueryError struct {
	_ struct{} `type:"structure"`

	// Possible values are CLOUDFORMATION_STACK_INACTIVE and CLOUDFORMATION_STACK_NOT_EXISTING.
	ErrorCode *string `type:"string" enum:"QueryErrorCode"`

	// A message that explains the ErrorCode value. Messages might state that the
	// specified CloudFormation stack does not exist (or no longer exists). For
	// CLOUDFORMATION_STACK_INACTIVE, the message typically states that the CloudFormation
	// stack has a status that is not (or no longer) active, such as CREATE_FAILED.
	Message *string `type:"string"`
}

// String returns the string representation
func (s QueryError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *QueryError) SetErrorCode(v string) *QueryError {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *QueryError) SetMessage(v string) *QueryError {
	s.Message = &v
	return s
}

// A filter name and value pair that is used to obtain more specific results
// from a list of resources.
type ResourceFilter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"ResourceFilterName"`

	// One or more filter values. Allowed filter values vary by resource filter
	// name, and are case-sensitive.
	//
	// Values is a required field
	Values []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s ResourceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ResourceFilter) SetName(v string) *ResourceFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ResourceFilter) SetValues(v []*string) *ResourceFilter {
	s.Values = v
	return s
}

// The ARN of a resource, and its resource type.
type ResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The ARN of a resource.
	ResourceArn *string `type:"string"`

	// The resource type of a resource, such as AWS::EC2::Instance.
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s ResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceIdentifier) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourceIdentifier) SetResourceArn(v string) *ResourceIdentifier {
	s.ResourceArn = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceIdentifier) SetResourceType(v string) *ResourceIdentifier {
	s.ResourceType = &v
	return s
}

// The query that is used to define a resource group or a search for resources.
type ResourceQuery struct {
	_ struct{} `type:"structure"`

	// The query that defines a group or a search.
	//
	// Query is a required field
	Query *string `type:"string" required:"true"`

	// The type of the query. The valid values in this release are TAG_FILTERS_1_0
	// and CLOUDFORMATION_STACK_1_0.
	//
	// TAG_FILTERS_1_0: A JSON syntax that lets you specify a collection of simple
	// tag filters for resource types and tags, as supported by the AWS Tagging
	// API GetResources (https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html)
	// operation. If you specify more than one tag key, only resources that match
	// all tag keys, and at least one value of each specified tag key, are returned
	// in your query. If you specify more than one value for a tag key, a resource
	// matches the filter if it has a tag key value that matches any of the specified
	// values.
	//
	// For example, consider the following sample query for resources that have
	// two tags, Stage and Version, with two values each. ([{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}])
	// The results of this query might include the following.
	//
	//    * An EC2 instance that has the following two tags: {"Key":"Stage","Values":["Deploy"]},
	//    and {"Key":"Version","Values":["2"]}
	//
	//    * An S3 bucket that has the following two tags: {"Key":"Stage","Values":["Test","Deploy"]},
	//    and {"Key":"Version","Values":["1"]}
	//
	// The query would not return the following results, however. The following
	// EC2 instance does not have all tag keys specified in the filter, so it is
	// rejected. The RDS database has all of the tag keys, but no values that match
	// at least one of the specified tag key values in the filter.
	//
	//    * An EC2 instance that has only the following tag: {"Key":"Stage","Values":["Deploy"]}.
	//
	//    * An RDS database that has the following two tags: {"Key":"Stage","Values":["Archived"]},
	//    and {"Key":"Version","Values":["4"]}
	//
	// CLOUDFORMATION_STACK_1_0: A JSON syntax that lets you specify a CloudFormation
	// stack ARN.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"QueryType"`
}

// String returns the string representation
func (s ResourceQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceQuery"}
	if s.Query == nil {
		invalidParams.Add(request.NewErrParamRequired("Query"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQuery sets the Query field's value.
func (s *ResourceQuery) SetQuery(v string) *ResourceQuery {
	s.Query = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceQuery) SetType(v string) *ResourceQuery {
	s.Type = &v
	return s
}

type SearchResourcesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of group member ARNs returned by SearchResources in paginated
	// output. By default, this number is 50.
	MaxResults *int64 `min:"1" type:"integer"`

	// The NextToken value that is returned in a paginated SearchResources request.
	// To get the next page of results, run the call again, add the NextToken parameter,
	// and specify the NextToken value.
	NextToken *string `type:"string"`

	// The search query, using the same formats that are supported for resource
	// group definition.
	//
	// ResourceQuery is a required field
	ResourceQuery *ResourceQuery `type:"structure" required:"true"`
}

// String returns the string representation
func (s SearchResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceQuery"))
	}
	if s.ResourceQuery != nil {
		if err := s.ResourceQuery.Validate(); err != nil {
			invalidParams.AddNested("ResourceQuery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchResourcesInput) SetMaxResults(v int64) *SearchResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchResourcesInput) SetNextToken(v string) *SearchResourcesInput {
	s.NextToken = &v
	return s
}

// SetResourceQuery sets the ResourceQuery field's value.
func (s *SearchResourcesInput) SetResourceQuery(v *ResourceQuery) *SearchResourcesInput {
	s.ResourceQuery = v
	return s
}

type SearchResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The NextToken value to include in a subsequent SearchResources request, to
	// get more results.
	NextToken *string `type:"string"`

	// A list of QueryError objects. Each error is an object that contains ErrorCode
	// and Message structures. Possible values for ErrorCode are CLOUDFORMATION_STACK_INACTIVE
	// and CLOUDFORMATION_STACK_NOT_EXISTING.
	QueryErrors []*QueryError `type:"list"`

	// The ARNs and resource types of resources that are members of the group that
	// you specified.
	ResourceIdentifiers []*ResourceIdentifier `type:"list"`
}

// String returns the string representation
func (s SearchResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchResourcesOutput) SetNextToken(v string) *SearchResourcesOutput {
	s.NextToken = &v
	return s
}

// SetQueryErrors sets the QueryErrors field's value.
func (s *SearchResourcesOutput) SetQueryErrors(v []*QueryError) *SearchResourcesOutput {
	s.QueryErrors = v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *SearchResourcesOutput) SetResourceIdentifiers(v []*ResourceIdentifier) *SearchResourcesOutput {
	s.ResourceIdentifiers = v
	return s
}

type TagInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to which to add tags.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" type:"string" required:"true"`

	// The tags to add to the specified resource. A tag is a string-to-string map
	// of key-value pairs. Tag keys can have a maximum character length of 128 characters,
	// and tag values can have a maximum length of 256 characters.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s TagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *TagInput) SetArn(v string) *TagInput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagInput) SetTags(v map[string]*string) *TagInput {
	s.Tags = v
	return s
}

type TagOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the tagged resource.
	Arn *string `type:"string"`

	// The tags that have been added to the specified resource.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s TagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TagOutput) SetArn(v string) *TagOutput {
	s.Arn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagOutput) SetTags(v map[string]*string) *TagOutput {
	s.Tags = v
	return s
}

type UntagInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource from which to remove tags.
	//
	// Arn is a required field
	Arn *string `location:"uri" locationName:"Arn" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// Keys is a required field
	Keys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.Keys == nil {
		invalidParams.Add(request.NewErrParamRequired("Keys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UntagInput) SetArn(v string) *UntagInput {
	s.Arn = &v
	return s
}

// SetKeys sets the Keys field's value.
func (s *UntagInput) SetKeys(v []*string) *UntagInput {
	s.Keys = v
	return s
}

type UntagOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource from which tags have been removed.
	Arn *string `type:"string"`

	// The keys of tags that have been removed.
	Keys []*string `type:"list"`
}

// String returns the string representation
func (s UntagOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UntagOutput) SetArn(v string) *UntagOutput {
	s.Arn = &v
	return s
}

// SetKeys sets the Keys field's value.
func (s *UntagOutput) SetKeys(v []*string) *UntagOutput {
	s.Keys = v
	return s
}

type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the resource group. Descriptions can have a maximum of
	// 511 characters, including letters, numbers, hyphens, underscores, punctuation,
	// and spaces.
	Description *string `type:"string"`

	// The name of the resource group for which you want to update its description.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateGroupInput) SetDescription(v string) *UpdateGroupInput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateGroupInput) SetGroupName(v string) *UpdateGroupInput {
	s.GroupName = &v
	return s
}

type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the resource group after it has been updated.
	Group *Group `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *UpdateGroupOutput) SetGroup(v *Group) *UpdateGroupOutput {
	s.Group = v
	return s
}

type UpdateGroupQueryInput struct {
	_ struct{} `type:"structure"`

	// The name of the resource group for which you want to edit the query.
	//
	// GroupName is a required field
	GroupName *string `location:"uri" locationName:"GroupName" min:"1" type:"string" required:"true"`

	// The resource query that determines which AWS resources are members of the
	// resource group.
	//
	// ResourceQuery is a required field
	ResourceQuery *ResourceQuery `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGroupQueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupQueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupQueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupQueryInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.ResourceQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceQuery"))
	}
	if s.ResourceQuery != nil {
		if err := s.ResourceQuery.Validate(); err != nil {
			invalidParams.AddNested("ResourceQuery", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateGroupQueryInput) SetGroupName(v string) *UpdateGroupQueryInput {
	s.GroupName = &v
	return s
}

// SetResourceQuery sets the ResourceQuery field's value.
func (s *UpdateGroupQueryInput) SetResourceQuery(v *ResourceQuery) *UpdateGroupQueryInput {
	s.ResourceQuery = v
	return s
}

type UpdateGroupQueryOutput struct {
	_ struct{} `type:"structure"`

	// The resource query associated with the resource group after the update.
	GroupQuery *GroupQuery `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupQueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupQueryOutput) GoString() string {
	return s.String()
}

// SetGroupQuery sets the GroupQuery field's value.
func (s *UpdateGroupQueryOutput) SetGroupQuery(v *GroupQuery) *UpdateGroupQueryOutput {
	s.GroupQuery = v
	return s
}

const (
	// GroupFilterNameResourceType is a GroupFilterName enum value
	GroupFilterNameResourceType = "resource-type"
)

const (
	// QueryErrorCodeCloudformationStackInactive is a QueryErrorCode enum value
	QueryErrorCodeCloudformationStackInactive = "CLOUDFORMATION_STACK_INACTIVE"

	// QueryErrorCodeCloudformationStackNotExisting is a QueryErrorCode enum value
	QueryErrorCodeCloudformationStackNotExisting = "CLOUDFORMATION_STACK_NOT_EXISTING"
)

const (
	// QueryTypeTagFilters10 is a QueryType enum value
	QueryTypeTagFilters10 = "TAG_FILTERS_1_0"

	// QueryTypeCloudformationStack10 is a QueryType enum value
	QueryTypeCloudformationStack10 = "CLOUDFORMATION_STACK_1_0"
)

const (
	// ResourceFilterNameResourceType is a ResourceFilterName enum value
	ResourceFilterNameResourceType = "resource-type"
)
